#!/usr/bin/python
# -*- coding: utf-8 -*-

import gobject, gtk
import hildondesktop
import hildon
import time
import dbus
from dbus.mainloop.glib import DBusGMainLoop
from os import path, remove, system
from commands import getoutput
from ConfigParser import SafeConfigParser

try:
    remove("/home/user/.openssh-status-connected")
except:
    print("")

class opensshStatus(hildondesktop.StatusMenuItem):
    def __init__(self):
        hildondesktop.StatusMenuItem.__init__(self)

        self.trackingEnabled = True
        self.stopTracking = True
        self.stopWhenIdle = False
        self.stopAfterMinutes = 5
        self.confirmDisconnect = True
        self.showRestartButton = False
        self.showConnected = True
        connectedIcon = "symbol"
        self.skipSystemCheck = False
        
        if path.isfile("/home/user/.openssh-status-widget"):
            parser = SafeConfigParser()
            try:
                parser.read('/home/user/.openssh-status-widget')
            except:
                system("rm /home/user/.openssh-status-widget")
            if parser.has_option('options', 'trackingEnabled'):
                self.trackingEnabled = parser.getboolean('options', 'trackingEnabled')
            if parser.has_option('options', 'stopTracking'):
                self.stopTracking = parser.getboolean('options', 'stopTracking')
            if parser.has_option('options', 'stopWhenIdle'):
                self.stopWhenIdle = parser.getboolean('options', 'stopWhenIdle')
            if parser.has_option('options', 'stopAfterMinutes'):
                self.stopAfterMinutes = int(parser.get('options', 'stopAfterMinutes').strip('_').split()[0]) # fix changed syntax when updating from < v1.6-0
            if parser.has_option('options', 'confirmDisconnect'):
                self.confirmDisconnect = parser.getboolean('options', 'confirmDisconnect')
            if parser.has_option('options', 'showRestartButton'):
                self.showRestartButton = parser.getboolean('options', 'showRestartButton')
            if parser.has_option('options', 'showConnected'):
                self.showConnected = parser.getboolean('options', 'showConnected')
            if parser.has_option('options', 'connectedIcon'):
                connectedIcon = parser.get('options', 'connectedIcon').strip('_')
            if parser.has_option('options', 'skipSystemCheck'):
                self.skipSystemCheck = parser.getboolean('options', 'skipSystemCheck')
            
        self.icon=gtk.gdk.pixbuf_new_from_file("/usr/share/icons/hicolor/18x18/hildon/openssh-status_no-users.png")
        try:
            self.icon_plus=gtk.gdk.pixbuf_new_from_file("/usr/share/icons/hicolor/18x18/hildon/openssh-status_users_"+connectedIcon.lower()+".png")
        except:
            self.icon_plus=gtk.gdk.pixbuf_new_from_file("/usr/share/icons/hicolor/18x18/hildon/openssh-status_users_symbol.png")

        self.button=hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.button.set_style(hildon.BUTTON_STYLE_PICKER)
        self.button.set_alignment(0.2,0.5,1,1)

        self.image_off=gtk.image_new_from_file("/usr/share/icons/hicolor/48x48/hildon/openssh-status_off.png")
        self.image_on=gtk.image_new_from_file("/usr/share/icons/hicolor/48x48/hildon/openssh-status_on.png")
        self.button.set_image_position(gtk.POS_LEFT)

        self.add(self.button)
        self.show_all()

        self.on = False
        self.connected = False
        self.waitWhileIdle = False
        self.refresh = False
        self.refreshWifiPMOff = False
        self.loops = 0
        self.labelConnected = 0
        self.sshJustOff = 0
        

        self.start()

        self.button.connect("clicked", self.buttonClicked)
        self.button.tap_and_hold_setup(None, None, 0)
        self.button.connect("tap-and-hold", self.buttonPressed)

        DBusGMainLoop(set_as_default=True)
        bus = dbus.SystemBus()
        bus.add_signal_receiver(self.handleDisplay, path='/com/nokia/mce/signal', dbus_interface='com.nokia.mce.signal', signal_name='display_status_ind')
        mceObj = bus.get_object("com.nokia.mce", "/com/nokia/mce/request")
        mceIF = dbus.Interface(mceObj, "com.nokia.mce.request")
        displayStatus = mceIF.get_display_status()
        self.handleDisplay(displayStatus)
        
    def handleDisplay(self, displayStatus):
        if displayStatus == "on" or displayStatus == "dimmed":
            self.loops = 0
            if self.refresh:
                self.sshTracker()
        if displayStatus == "off":
            self.loops = 17279
            if self.stopWhenIdle:
                self.loops = 11
                if self.stopAfterMinutes == 1:
                    self.loops = 5
        
    def start(self):
        if not self.skipSystemCheck:
            sshSystemRespawn = False
            if path.isfile("/etc/event.d/sshd"):
                sshFile = open("/etc/event.d/sshd",'r')
                lines = sshFile.readlines()
                sshFile.close()
                for line in lines:
                    if line.strip('\n').strip(' ') == "respawn":
                        sshSystemRespawn = True
            if sshSystemRespawn:
                self.adjustSshFile()
        
        self.sshStatus()
        if self.trackingEnabled:
            self.sshUsers()
        if self.sshRunning:
            self.on = True
            self.button.set_image(self.image_on)
            if self.trackingEnabled:
                if self.sshConnected and self.showConnected:
                    self.connected = True
                    self.set_status_area_icon(self.icon_plus)
                else:
                    self.set_status_area_icon(self.icon)
                self.refresh = True
                if not self.sshConnected:
                    self.button.set_text("OpenSSH Server", "0 connections")
                self.loopCount = -1
                self.sshTracker()
                gobject.timeout_add(5000, self.sshTracker)
            else:
                self.set_status_area_icon(self.icon)
                self.button.set_text("OpenSSH Server", "On")
        else:
            self.button.set_image(self.image_off)
            if self.trackingEnabled:
                if self.sshConnected:
                    if self.showConnected:
                        self.connected = True
                        self.set_status_area_icon(self.icon_plus)
                    else:
                        self.set_status_area_icon(self.icon)
                    self.refresh = True
                    self.loopCount = -1
                    gobject.timeout_add(5000, self.sshTracker)
                else:
                    self.set_status_area_icon(None)
                    self.button.set_text("OpenSSH Server", "Off")
                    if not self.stopTracking:
                        self.refresh = True
                        self.loopCount = -1
                        gobject.timeout_add(5000, self.sshTracker)
            else:
                self.set_status_area_icon(None)
                self.button.set_text("OpenSSH Server", "Off")
            
    def adjustSshFile(self):
        self.dialog = gtk.Dialog("OpenSSH status", None)
        text = gtk.Label("The widget has detected a system configuration for respawning the OpenSSH server. "
        "For error-free function of this widget respawning the server should be disabled.\n\nDo you want the widget to disable it now?\n")
        text.set_line_wrap(True)
        self.dialog.vbox.pack_start(text)
        buttonYes = self.dialog.add_button("Yes", gtk.RESPONSE_YES)
        buttonNo = self.dialog.add_button("No", gtk.RESPONSE_NO)
        buttonDetails = self.dialog.add_button("Details", gtk.RESPONSE_NONE)
        
        buttonYes.connect("clicked", self.adjustYes)
        buttonNo.connect("clicked", self.adjustNo)
        buttonDetails.connect("clicked", self.detailsMessage)
        
        self.dialog.show_all()
        
    def adjustYes(self, dummy):
        system("sudo openssh-status.sh disable_respawn")
        self.dialog.destroy()
        message = gtk.Dialog("OpenSSH status", None)
        text = gtk.Label("Done! Please reboot the N900.")
        text.set_line_wrap(True)
        message.vbox.add(text)
        message.add_button("Close", gtk.RESPONSE_OK)
            
        message.show_all()
        message.run()
        message.destroy()
        
    def adjustNo(self, dummy):
        self.dialog.destroy()

    def detailsMessage(self,dummy):
        message = gtk.Dialog("OpenSSH status", None)
        text = gtk.Label("The widget will modify the file\n\n/etc/event.d/sshd\n\nby commenting out the relevant line\nin the existing file. Nothing will be deleted.")
        text.set_line_wrap(True)
        message.vbox.add(text)
        message.add_button("Close", gtk.RESPONSE_OK)
            
        message.show_all()
        message.run()
        message.destroy()
        
    def sshStatus(self):
        self.sshRunning = int(getoutput("ps aux | grep -c /usr/sbin/sshd")) - 2
        
    def sshUsers(self):
        self.sshConnected = int(getoutput("ps aux | grep sshd: | grep -c @")) - 1
        
    def sshTracker(self):
        # Smart frequency
        self.loopCount += 1
        if self.loopCount > self.loops:
            self.loopCount = 0
        # Tracker
        if not self.loopCount or self.sshJustOff:
            self.sshStatus()
            self.sshUsers()
            if self.sshRunning and self.sshJustOff:
                self.sshJustOff = 0
            if not self.sshRunning and self.on:
                self.on = False
                self.button.set_image(self.image_off)
            if self.sshRunning and not self.on:
                self.on = True
                self.button.set_image(self.image_on)
                if self.sshConnected and self.showConnected:
                    self.connected = True
                    self.set_status_area_icon(self.icon_plus)
                else:
                    self.connected = False
                    self.set_status_area_icon(self.icon)
            # Update Status area icon
            if self.showConnected:
                if self.sshConnected and not self.connected:
                    self.connected = True
                    self.set_status_area_icon(self.icon_plus)
                if self.sshRunning and not self.sshConnected and self.connected:
                    self.connected = False
                    self.set_status_area_icon(self.icon)
            # Update button
            if self.sshConnected != self.labelConnected:
                self.labelConnected = self.sshConnected
                self.waitWhileIdle = False
                if self.sshConnected == 1:
                    self.button.set_text("OpenSSH Server", str(self.sshConnected)+" connection")
                    return True
                elif self.sshConnected > 1 or (not self.sshConnected and self.sshRunning):
                    self.button.set_text("OpenSSH Server", str(self.sshConnected)+" connections")
                    return True
            # Stop tracking when server is off
            if not self.sshConnected and not self.sshRunning:
                self.on = False
                self.button.set_image(self.image_off)
                self.set_status_area_icon(None)
                self.button.set_text("OpenSSH Server", "Off")
                if self.stopTracking:
                    if self.sshJustOff < 3:
                        self.sshJustOff += 1
                        return True
                    else:
                        self.sshJustOff = 0
                        self.refresh = False
                        self.waitWhileIdle = False
                        return False
                else:
                    return True
            # Stop server when not connected
            if not self.sshConnected and self.stopWhenIdle:
                if not self.waitWhileIdle:
                    try:
                        remove("/home/user/.openssh-status-connected")
                    except:
                        self.waitWhileIdle = True
                    self.idleStartTime = time.time()
                    self.waitWhileIdle = True
                    return True
                elif self.loops and path.isfile("/home/user/.openssh-status-connected"):
                    remove("/home/user/.openssh-status-connected")
                    self.idleStartTime = time.time()
                    return True
                elif time.time() - self.idleStartTime + 5 > self.stopAfterMinutes * 60:
                    system("sudo openssh-status.sh stop_sshd")
                    time.sleep(1)
                    self.sshStatus()
                    if self.sshRunning:
                        self.printDialog("Could NOT stop OpenSSH Server!")
                    else:
                        self.on = False
                        self.waitWhileIdle = False
                        self.button.set_text("OpenSSH Server", "Off")
                        self.button.set_image(self.image_off)
                        self.set_status_area_icon(None)
        return True
        
    def buttonClicked(self, dummy):
        self.sshStatus()
        if self.sshRunning and self.on:
            system("sudo openssh-status.sh stop_sshd")
            time.sleep(1)
            self.sshStatus()
            if self.sshRunning:
                self.printDialog("Could NOT stop OpenSSH Server!")
            else:
                self.on = False
                self.button.set_image(self.image_off)
                if self.trackingEnabled:
                    self.sshUsers()
                    if not self.sshConnected:
                        self.set_status_area_icon(None)
                        self.button.set_text("OpenSSH Server", "Off")
                else:
                    self.set_status_area_icon(None)
                    self.button.set_text("OpenSSH Server", "Off")
                    
        elif self.sshRunning and not self.on:
            self.on = True
            self.button.set_image(self.image_on)
            if self.trackingEnabled:
                self.sshUsers()
                if self.sshConnected:
                    if self.sshConnected == 1:
                        self.button.set_text("OpenSSH Server", "1 connection")
                    else:
                        self.button.set_text("OpenSSH Server", str(self.sshConnected)+" connections")
                    if self.showConnected:
                        self.connected = True
                        self.set_status_area_icon(self.icon_plus)
                    else:
                        self.connected = False
                        self.set_status_area_icon(self.icon)
                else:
                    self.button.set_text("OpenSSH Server", "0 connections")
                    self.connected = False
                    self.set_status_area_icon(self.icon)
                if not self.refresh:
                    self.refresh = True
                    self.loopCount = -1
                    gobject.timeout_add(5000, self.sshTracker)
            else:
                self.set_status_area_icon(self.icon)
                self.button.set_text("OpenSSH Server", "On")
            self.printDialog("OpenSSH Server already running! Display updated.")
        elif not self.sshRunning and self.on:
            self.on = False
            self.button.set_image(self.image_off)
            if self.trackingEnabled:
                self.sshUsers()
                if self.sshConnected:
                    if self.sshConnected == 1:
                        self.button.set_text("OpenSSH Server", "1 connection")
                    else:
                        self.button.set_text("OpenSSH Server", str(self.sshConnected)+" connections")
                    if self.showConnected:
                        self.connected = True
                        self.set_status_area_icon(self.icon_plus)
                    else:
                        self.connected = False
                        self.set_status_area_icon(self.icon)
                else:
                    self.button.set_text("OpenSSH Server", "Off")
                    self.connected = False
                    self.set_status_area_icon(None)
                self.refresh = False
            else:
                self.set_status_area_icon(None)
                self.button.set_text("OpenSSH Server", "Off")
            self.printDialog("OpenSSH Server already stopped! Display updated.")
        else:
            system("sudo openssh-status.sh start_sshd")
            time.sleep(1)
            self.sshStatus()
            if self.sshRunning:
                self.on = True
                self.button.set_image(self.image_on)
                if self.trackingEnabled:
                    self.sshUsers()
                    if not self.sshConnected:
                        self.button.set_text("OpenSSH Server", "0 connections")
                        self.connected = False
                        self.set_status_area_icon(self.icon)
                    if not self.refresh:
                        self.refresh = True
                        self.loopCount = -1
                        gobject.timeout_add(5000, self.sshTracker)
                else:
                    self.set_status_area_icon(self.icon)
                    self.button.set_text("OpenSSH Server", "On")
            else:
                self.printDialog("Could NOT start OpenSSH Server!")

    def buttonPressed(self, dummy):
        self.button.get_toplevel().hide()
        self.sshStatus()
        self.sshUsers()
        if (self.sshRunning or self.sshConnected) and (self.confirmDisconnect or not self.trackingEnabled):
            self.dialog = gtk.Dialog("OpenSSH status", None)
            if not self.showRestartButton:
                buttonDisconnectStop = hildon.Button(gtk.HILDON_SIZE_THUMB_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
                buttonDisconnectStop.set_label('Disconnect and stop server')
            else:
                buttonDisconnectStop = hildon.Button(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_THUMB_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
                buttonDisconnectStop.set_label('Disconnect\nStop server')
                buttonDisconnectRestart = hildon.Button(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_THUMB_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
                buttonDisconnectRestart.set_label('  Disconnect\nRestart server')
            if not self.trackingEnabled:
                buttonConnected = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
                buttonConnected.set_label('Connections')
                if self.sshConnected == 1:
                    self.printInfo("1 connection")
                else:
                    self.printInfo(str(self.sshConnected)+" connections")
            vbox2 = gtk.VBox(False,2)
            vbox2.set_border_width(8)
            hbox = gtk.HBox(False,0)
            if not self.trackingEnabled:
                vbox2.pack_start(buttonConnected)
                buttonConnected.connect("clicked", self.buttonConnected_clicked)
            hbox.pack_start(buttonDisconnectStop)
            if self.showRestartButton:
                hbox.pack_start(buttonDisconnectRestart)
                buttonDisconnectRestart.connect("clicked", self.buttonDisconnectRestart_clicked)
            buttonDisconnectStop.connect("clicked", self.buttonDisconnectStop_clicked)
            vbox2.pack_start(hbox)
            self.dialog.vbox.pack_start(vbox2)
            self.dialog.show_all()
        elif self.sshRunning or self.sshConnected:
            self.sshDisconnect()
        else:
            if self.trackingEnabled:
                time.sleep(1)
                self.printInfo("OpenSSH Server already stopped!")
            else:
                self.buttonConnected_clicked(0)
        
    def buttonDisconnectStop_clicked(self, dummy):
        self.dialog.destroy()
        self.sshDisconnect()
    
    def buttonDisconnectRestart_clicked(self, dummy):
        self.dialog.destroy()
        self.sshDisconnectRestart()
    
    def buttonConnected_clicked(self, dummy):
        self.sshUsers()
        if self.sshConnected == 1:
            self.printInfo("1 connection")
        else:
            self.printInfo(str(self.sshConnected)+" connections")
    
    def sshDisconnect(self):
        self.sshStatus()
        self.sshUsers()
        if self.sshRunning:
            system("sudo openssh-status.sh kill_sshd")
            time.sleep(1)
            self.sshStatus()
            self.sshUsers()
            if self.sshRunning:
                self.printDialog("Could NOT stop OpenSSH Server!")
            elif self.sshConnected:
                self.printDialog("Could NOT close OpenSSH connections!")
            else:
                self.on = False
                self.button.set_text("OpenSSH Server", "Off")
                self.button.set_image(self.image_off)
                self.set_status_area_icon(None)
        elif self.sshConnected:
            system("sudo openssh-status.sh kill_sshd")
            time.sleep(1)
            self.sshUsers()
            if self.sshConnected:
                self.printDialog("Could NOT close OpenSSH connections!")
            else:
                self.on = False
                self.button.set_text("OpenSSH Server", "Off")
                self.button.set_image(self.image_off)
                self.set_status_area_icon(None)
            
    def sshDisconnectRestart(self):
        self.sshStatus()
        self.sshUsers()
        if self.sshRunning:
            system("sudo openssh-status.sh kill_sshd")
            time.sleep(1)
            self.sshStatus()
            self.sshUsers()
            if self.sshRunning:
                self.printDialog("Could NOT restart OpenSSH Server!")
            elif self.sshConnected:
                self.printDialog("Could NOT close OpenSSH connections!")
            else:
                system("sudo openssh-status.sh start_sshd")
                if self.trackingEnabled:
                    self.button.set_text("OpenSSH Server", "0 connections")
                self.set_status_area_icon(self.icon)
        elif self.sshConnected:
            system("sudo openssh-status.sh kill_sshd")
            time.sleep(1)
            self.sshUsers()
            if self.sshConnected:
                self.printDialog("Could NOT close OpenSSH connections!")
            else:
                system("sudo openssh-status.sh start_sshd")
                if self.trackingEnabled:
                    self.button.set_text("OpenSSH Server", "0 connections")
                else:
                    self.button.set_text("OpenSSH Server", "On")
                self.button.set_image(self.image_on)
                self.set_status_area_icon(self.icon)
            
    def printDialog(self, msg):
        system("run-standalone.sh dbus-send --print-reply \
        --type=method_call --dest=org.freedesktop.Notifications \
        /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog \
        string:\""+msg+"\" uint32:0 string:")

    def printInfo(self, msg):
        system("run-standalone.sh dbus-send --print-reply \
        --type=method_call --dest=org.freedesktop.Notifications \
        /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
        string:\""+msg+"\"")

hd_plugin_type = opensshStatus
