#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
import gtk
import hildon
from os import path, system
from ConfigParser import SafeConfigParser

version = "1.1-2"
autostart = False
confirmDisconnect = True
stopTracking = False
skipSystemCheck = False

class Main(object):
    def __init__(self):
        global autostart
        global confirmDisconnect
        global stopTracking
        global skipSystemCheck
        autostartDisabled = False
       
        self.parser = SafeConfigParser()
        self.parser.optionxform = str
        if not path.isfile("/home/user/.openssh-status-widget"):
            self.configFile = open('/home/user/.openssh-status-widget', 'w')
            self.parser.add_section('options')
            self.parser.set('options', 'confirmDisconnect', str(confirmDisconnect))
            self.parser.set('options', 'stopTracking', str(stopTracking))
            self.parser.set('options', 'skipSystemCheck', str(skipSystemCheck))
            self.parser.write(configFile)
            self.configFile.close()
        else:
            self.configFile = open('/home/user/.openssh-status-widget', 'r+')
            self.parser.read('/home/user/.openssh-status-widget')
            confirmDisconnect = self.parser.getboolean('options', 'confirmDisconnect')
            stopTracking = self.parser.getboolean('options', 'stopTracking')
            skipSystemCheck = self.parser.getboolean('options', 'skipSystemCheck')
            
        if not path.isfile("/etc/event.d/sshd"):
            system("sudo sh -c \"echo '#start on stopped rcS\n\nconsole output\n\n#respawn\n\npre-start script\n    "
            "if [ ! -d /var/run/sshd ] ; then\n        mkdir /var/run/sshd\n        chmod 755 /var/run/sshd\n    fi\n"
            "end script\n\nexec /usr/sbin/sshd\n' >>/etc/event.d/sshd\"")
        sshFile = open("/etc/event.d/sshd",'r')
        lines = sshFile.readlines()
        sshFile.close()
        for line in lines:
            if line.strip('\n').strip(' ') == "start on stopped rcS":
                autostart = True
            if line.strip('\n').strip(' ') == "#start on stopped rcS":
                autostartDisabled = True
        if not autostart and not autostartDisabled:
            system("sudo sed -i '1i#start on stopped rcS' /etc/event.d/sshd")
            
        self.main()
    
    def main(self):
        window = hildon.Window()
        window.set_title("OpenSSH Status Widget")
        window.connect("delete_event", gtk.main_quit, None)
        
        labelServer = gtk.Label("Server options:")
        labelWidget = gtk.Label("Widget options:")
    
        self.buttonAutostart = hildon.CheckButton(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonAutostart.set_label("Run server at system startup")
                
        self.buttonConfirm = hildon.CheckButton(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonConfirm.set_label("Confirm when disconnecting")
        
        self.buttonStopTracking = hildon.CheckButton(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonStopTracking.set_label("Stop tracking status when off")
    
        vbox = gtk.VBox(False, 0)
        vbox.set_border_width(8)
        vbox.pack_start(labelServer, False, False, 10)
        vbox.pack_start(self.buttonAutostart, False, False, 0)
        vbox.pack_start(labelWidget, False, False, 10)
        vbox.pack_start(self.buttonConfirm, False, False, 0)
        vbox.pack_start(self.buttonStopTracking, False, False, 0)
        
        window.add(vbox)
        
        if autostart:
            self.buttonAutostart.set_active(True)
        else:
            self.buttonAutostart.set_active(False)
        if confirmDisconnect:
            self.buttonConfirm.set_active(True)
        else:
            self.buttonConfirm.set_active(False)
        if stopTracking:
            self.buttonStopTracking.set_active(True)
        else:
            self.buttonStopTracking.set_active(False)
            
        self.buttonAutostart.connect("clicked", self.buttonAutostart_clicked)
        self.buttonConfirm.connect("clicked", self.buttonConfirm_clicked)
        self.buttonStopTracking.connect("clicked", self.buttonStopTracking_clicked)
        
        menu = self.create_menu()
        window.set_app_menu(menu)
        
        window.show_all()
    
        gtk.main()
        
    def buttonAutostart_clicked(self, dummy):
        global autostart
        autostart = not autostart
        if autostart:
            system("sudo sed -i 's/#start on stopped rcS/start on stopped rcS/g' /etc/event.d/sshd")
        else:
            system("sudo sed -i 's/start on stopped rcS/#start on stopped rcS/g' /etc/event.d/sshd")

    def buttonConfirm_clicked(self, dummy):
        global confirmDisconnect
        confirmDisconnect = not confirmDisconnect
        self.parser.set('options', 'confirmDisconnect', str(confirmDisconnect))
        self.write_config()

    def buttonStopTracking_clicked(self, dummy):
        global stopTracking
        stopTracking = not stopTracking
        self.parser.set('options', 'stopTracking', str(stopTracking))
        self.write_config()
        
    def write_config(self):
        self.configFile = open('/home/user/.openssh-status-widget', 'r+')
        self.parser.write(self.configFile)
        self.configFile.close()

    def create_menu(self):
        menu = hildon.AppMenu()
    
        buttonRestart = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        buttonRestart.set_label('Restart Status Menu')
        buttonRestart.connect("clicked", self.restart_clicked)
        buttonAbout = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        buttonAbout.set_label('About')
        buttonAbout.connect("clicked", self.about_clicked)
    
        menu.append(buttonRestart)
        menu.append(buttonAbout)
    
        menu.show_all()
    
        return menu
    
    def restart_clicked(self, dummy):
        system("killall hildon-status-menu")
        return
    
    def about_clicked(self, dummy):
        about = gtk.Dialog("About", None)
        textApp = gtk.Label("<big><b>OpenSSH Status Widget  "+version+"</b></big>")
        textApp.set_use_markup(True)
        textApp.set_line_wrap(True)
        textIandI = gtk.Label("Created by Marc Pöpperl (rasmarc)\n")
        vbox2 = gtk.VBox(False,16)
        vbox2.set_border_width(16)
        logo = gtk.image_new_from_file("/usr/share/icons/hicolor/64x64/apps/openssh-status.png")
        vbox2.pack_start(logo)
        vbox2.pack_start(textApp)
        vbox2.pack_start(textIandI)
        about.vbox.pack_start(vbox2)
        
        about.show_all()
    
if __name__ == "__main__":
    Main()

