/**********************************************************************
 *
 *    FILE:            Group.cpp
 *
 *    DESCRIPTION:    Read/Write osg::Group in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerated
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 17.3.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "Node.h"
#include "Group.h"
#include "MatrixTransform.h"
#include "Geode.h"
#include "LightSource.h"
#include "Billboard.h"
#include "Sequence.h"
#include "LOD.h"
#include "PositionAttitudeTransform.h"
#include "Transform.h"

using namespace ive;

void Group::write(DataOutputStream* out){
    // Write Group's identification.
    out->writeInt(IVEGROUP);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Node* node = dynamic_cast<osg::Node*>(this);
    if(node){
        static_cast<ive::Node*>(node)->write(out);
    }
    else
        out_THROW_EXCEPTION("Group::write(): Could not cast this osg::Group to an osg::Node.");

    // Write Group's properties.

    // Write number of children.
    out->writeInt(getNumChildren());
    // Write children.
    for(unsigned int i=0; i<getNumChildren(); i++){
        osg::Node* child = getChild(i);
        out->writeNode(child);
    }
}

void Group::read(DataInputStream* in){
    // Read Group's identification.
    int id = in->peekInt();
    if(id == IVEGROUP){
        // Read Group's identification.
        id = in->readInt();

        // If the osg class is inherited by any other class we should also read this from file.
        osg::Node* node = dynamic_cast<osg::Node*>(this);
        if(node){
            ((ive::Node*)(node))->read(in);
        }
        else
            in_THROW_EXCEPTION("Group::read(): Could not cast this osg::Group to an osg::Node.");


        // Read groups properties.

        // Read number of children.
        int size = in->readInt();
        // Read children.
        for(int i=0; i<size; i++)
        {
            addChild(in->readNode());            
        }
    }
    else{
        in_THROW_EXCEPTION("Group::read(): Expected Group identification");
    }
}
