/***************************************************************************
 *   Copyright (C) 2010 by lwp                                             *
 *   levin108@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "fx_include.h"

FxSet* fx_set_new(FxMain* fxmain)
{
	FxSet *fxset = (FxSet*)malloc(sizeof(FxSet));

	DEBUG_FOOTPRINT();

	memset(fxset , 0 , sizeof(FxSet));
	fxset->fxmain = fxmain;
	return fxset;
}

void fx_set_initialize(FxSet* fxset)
{
	GtkWidget *psetting_label = NULL;
	GtkWidget *ssetting_label = NULL;

	GtkWidget *ok_button = NULL;
	GtkWidget* cancel_button = NULL;

	GdkPixbuf* pb = gdk_pixbuf_new_from_file(SKIN_DIR"user_online.png" , NULL);

	DEBUG_FOOTPRINT();

	fxset->dialog = gtk_dialog_new();
	gtk_window_set_icon(GTK_WINDOW(fxset->dialog) , pb);
	gtk_dialog_set_has_separator(GTK_DIALOG(fxset->dialog)
							   , FALSE);
	gtk_widget_set_usize(fxset->dialog , 500 , 360);
	gtk_window_set_title(GTK_WINDOW(fxset->dialog) , "个人设置");

	fxset->notebook = gtk_notebook_new();
	gtk_widget_set_usize(fxset->notebook , 490 , 320);
	gtk_notebook_set_show_border(GTK_NOTEBOOK(fxset->notebook) , FALSE);
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(fxset->notebook) , GTK_POS_TOP);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(fxset->dialog)->vbox)
					 , fxset->notebook , FALSE , FALSE , 0);

	fxset->psetting = gtk_vbox_new(FALSE , FALSE);
	psetting_label = gtk_label_new("个人设置");
	gtk_notebook_append_page(GTK_NOTEBOOK(fxset->notebook)
						   , fxset->psetting
						   , psetting_label);

	fxset->ssetting = gtk_vbox_new(FALSE , FALSE);
	ssetting_label = gtk_label_new("系统设置");
	gtk_notebook_append_page(GTK_NOTEBOOK(fxset->notebook)
						   , fxset->ssetting
						   , ssetting_label);


	ok_button = gtk_button_new_with_label("确定");
	gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(fxset->dialog)->action_area) , ok_button);
	g_signal_connect(ok_button , "clicked" , G_CALLBACK(fx_set_on_ok_clicked) , fxset);

	cancel_button = gtk_button_new_with_label("取消");
	gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(fxset->dialog)->action_area) , cancel_button);
	g_signal_connect(cancel_button , "clicked" , G_CALLBACK(fx_set_on_cancel_clicked) , fxset->dialog);

	fx_set_initialize_personal(fxset);
	fx_set_initialize_system(fxset);

	gtk_widget_show_all(fxset->dialog);
	gtk_widget_hide(fxset->dialog);
}

void fx_set_bind_system(FxSet* fxset)
{
	FxMain *fxmain = fxset->fxmain;  
	Config *config = fxmain->user->config;
	GtkTextBuffer *buffer = NULL;
	GtkTextIter startIter , endIter;
	char *autoReplyMsg = NULL;

	DEBUG_FOOTPRINT();

	if(config->sendMode == SEND_MODE_ENTER)
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fxset->etBtn) , TRUE);	
	}
	else
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fxset->ctBtn) , TRUE);	
	}

	if(config->autoPopup == AUTO_POPUP_ENABLE)
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fxset->ppCb) , TRUE);
	}
	else
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fxset->ppCb) , FALSE);
	}
	if(config->closeMode == CLOSE_ICON_MODE)
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fxset->smallBtn) , TRUE);
	}
	else
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fxset->smallBtn) , FALSE);
	}
	if(config->isMute == MUTE_ENABLE)
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fxset->muteBtn) , TRUE);
	}
	else
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fxset->muteBtn) , FALSE);
	}
	if(config->msgAlert == MSG_ALERT_ENABLE)
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fxset->alertBtn) , FALSE);
	}
	else
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fxset->alertBtn) , TRUE);
	}
	buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(fxset->apEty));
	gtk_text_buffer_get_start_iter(buffer , &startIter);
	gtk_text_buffer_get_end_iter(buffer , &endIter);
	gtk_text_buffer_delete(buffer , &startIter , &endIter);

	if(strlen(config->autoReplyMessage) == 0)
	{
		autoReplyMsg = "对不起，我现在不在，稍后给您回复";
		gtk_text_buffer_insert(buffer , &startIter , autoReplyMsg , strlen(autoReplyMsg));
	}
	else
	{
		gtk_text_buffer_insert(buffer , &startIter , config->autoReplyMessage , strlen(config->autoReplyMessage));
	}
}

void fx_set_initialize_personal(FxSet* fxset)
{
	FxMain *fxmain = fxset->fxmain;
	User *user = fxmain->user;
	Config *config = user->config;
	char filepath[128];
	GdkPixbuf *pb = NULL;

	GtkWidget *box = NULL;
	GtkTreeModel *gmodel = NULL;
	GtkWidget *gender_entry = NULL;
	GtkTreeIter iter;
	int id;
	char *cityName = NULL;
	char *provinceName = NULL;

	DEBUG_FOOTPRINT();

	box = gtk_fixed_new();
	gtk_box_pack_start_defaults(GTK_BOX(fxset->psetting) , box);

	pb = gdk_pixbuf_new_from_file_at_size(SKIN_DIR"fetion.jpg" , 90 , 90 , NULL);
	fxset->image = gtk_image_new_from_pixbuf(pb);
	gtk_fixed_put(GTK_FIXED(box) , fxset->image , 10 , 15 );

	fxset->sid_label = gtk_label_new("飞信号:");
	gtk_misc_set_alignment(GTK_MISC(fxset->sid_label) , 0 , 0);
	gtk_fixed_put(GTK_FIXED(box) , fxset->sid_label , 120 , 10 );

	fxset->sid_entry = gtk_entry_new();
	gtk_entry_set_editable(GTK_ENTRY(fxset->sid_entry) , FALSE);
	gtk_fixed_put(GTK_FIXED(box) , fxset->sid_entry , 120 , 30 );

	fxset->gender_label = gtk_label_new("性别:");
	gtk_misc_set_alignment(GTK_MISC(fxset->gender_label) , 0 , 0);
	gtk_fixed_put(GTK_FIXED(box) , fxset->gender_label , 310 , 10 );

	gmodel = fx_set_create_gender_model();
	fxset->gender_combo = gtk_combo_box_entry_new_with_model(gmodel , COMBO_NAME_COL);
	gender_entry = gtk_bin_get_child(GTK_BIN(fxset->gender_combo));
	gtk_entry_set_editable(GTK_ENTRY(gender_entry) , FALSE);
	gtk_combo_box_set_active(GTK_COMBO_BOX(fxset->gender_combo) , 1);
	gtk_widget_set_usize(fxset->gender_combo , 150 , 25);
	gtk_fixed_put(GTK_FIXED(box) , fxset->gender_combo , 310 , 30 );

	fxset->mno_label = gtk_label_new("手机号:");
	gtk_misc_set_alignment(GTK_MISC(fxset->mno_label) , 0 , 0);
	gtk_fixed_put(GTK_FIXED(box) , fxset->mno_label , 120 , 60 );

	fxset->mno_entry = gtk_entry_new();
	gtk_entry_set_editable(GTK_ENTRY(fxset->mno_entry) , FALSE);
	gtk_fixed_put(GTK_FIXED(box) , fxset->mno_entry , 120 , 80 );

	fxset->nick_label = gtk_label_new("昵称:");
	gtk_misc_set_alignment(GTK_MISC(fxset->nick_label) , 0 , 0);
	gtk_fixed_put(GTK_FIXED(box) , fxset->nick_label , 310 , 60 );

	fxset->nick_entry = gtk_entry_new();
	gtk_fixed_put(GTK_FIXED(box) , fxset->nick_entry , 310 , 80 );

	fxset->impre_label = gtk_label_new("个性签名:");
	gtk_misc_set_alignment(GTK_MISC(fxset->impre_label) , 0 , 0);
	gtk_fixed_put(GTK_FIXED(box) , fxset->impre_label , 10 , 115 );

	fxset->impre_entry = gtk_entry_new();
	gtk_widget_set_usize(fxset->impre_entry , 460 , 25);
	gtk_fixed_put(GTK_FIXED(box) , fxset->impre_entry , 10 , 135 );
	
	fxset->province_label = gtk_label_new("省份:");
	gtk_misc_set_alignment(GTK_MISC(fxset->province_label) , 0 , 0 );
	gtk_fixed_put(GTK_FIXED(box) , fxset->province_label , 10 , 165 );

	fxset->province_entry = gtk_entry_new();
	gtk_entry_set_editable(GTK_ENTRY(fxset->province_entry) , FALSE);
	gtk_widget_set_usize(fxset->province_entry , 220 , 25);
	gtk_fixed_put(GTK_FIXED(box) , fxset->province_entry , 10 , 185 );

	fxset->city_label = gtk_label_new("城市:");
	gtk_misc_set_alignment(GTK_MISC(fxset->city_label) , 0 , 0 );
	gtk_fixed_put(GTK_FIXED(box) , fxset->city_label , 250 , 165 );

	fxset->city_entry = gtk_entry_new();
	gtk_entry_set_editable(GTK_ENTRY(fxset->city_entry) , FALSE);
	gtk_widget_set_usize(fxset->city_entry , 220 , 25);
	gtk_fixed_put(GTK_FIXED(box) , fxset->city_entry , 250 , 185 );
	
	fxset->job_label = gtk_label_new("职业:");
	gtk_misc_set_alignment(GTK_MISC(fxset->job_label) , 0 , 0 );
	gtk_fixed_put(GTK_FIXED(box) , fxset->job_label , 10 , 215 );

	fxset->job_entry = gtk_entry_new();
	gtk_entry_set_editable(GTK_ENTRY(fxset->job_entry) , FALSE);
	gtk_widget_set_usize(fxset->job_entry , 220 , 25);
	gtk_fixed_put(GTK_FIXED(box) , fxset->job_entry , 10 , 235 );

	fxset->email_label = gtk_label_new("电子邮箱:");
	gtk_misc_set_alignment(GTK_MISC(fxset->email_label) , 0 , 0 );
	gtk_fixed_put(GTK_FIXED(box) , fxset->email_label , 250 , 215 );

	fxset->email_entry = gtk_entry_new();
	gtk_entry_set_editable(GTK_ENTRY(fxset->email_entry) , FALSE);
	gtk_widget_set_usize(fxset->email_entry , 220 , 25);
	gtk_fixed_put(GTK_FIXED(box) , fxset->email_entry , 250 , 235 );


	gtk_entry_set_text(GTK_ENTRY(fxset->sid_entry) , user->sId);
	if(user->mobileno != NULL)
		gtk_entry_set_text(GTK_ENTRY(fxset->mno_entry) , user->mobileno);
	if(user->nickname != NULL)
		gtk_entry_set_text(GTK_ENTRY(fxset->nick_entry) , user->nickname);
	if(user->impression != NULL)
		gtk_entry_set_text(GTK_ENTRY(fxset->impre_entry) , user->impression);
	if(user->province != NULL)
	{
		provinceName = fetion_config_get_province_name(user->province);
		gtk_entry_set_text(GTK_ENTRY(fxset->province_entry) , provinceName);
		free(provinceName);
	}
	if(user->city != NULL)
	{
		cityName = fetion_config_get_city_name(user->province , user->city);
		gtk_entry_set_text(GTK_ENTRY(fxset->city_entry) , cityName);
		free(cityName);
	}

	gtk_entry_set_text(GTK_ENTRY(fxset->job_entry) , "保密");
	gtk_entry_set_text(GTK_ENTRY(fxset->email_entry) , "保密");

	gtk_tree_model_get_iter_root(gmodel , &iter);
	do
	{
		gtk_tree_model_get(gmodel , &iter , COMBO_ID_COL , &id , -1);
		if(id == user->gender)
		{
			gtk_combo_box_set_active_iter(GTK_COMBO_BOX(fxset->gender_combo), &iter);
			break;
		}
	}
	while(gtk_tree_model_iter_next(gmodel , &iter));

	sprintf(filepath , "%s/%s.jpg" , config->iconPath , user->sId);
	pb = gdk_pixbuf_new_from_file_at_size(filepath , 90 , 90 , NULL);
	if(pb != NULL)
		gtk_image_set_from_pixbuf(GTK_IMAGE(fxset->image) , pb);
}

void fx_set_initialize_system(FxSet* fxset)
{
	
	GtkWidget *fixed = NULL;
	GtkWidget *label1 = NULL;
	GtkWidget *apScr = NULL;
	GtkWidget *label3 = NULL;
	GtkWidget *label4 = NULL;
	GtkWidget *label5 = NULL;
	GtkWidget *label6 = NULL;
	GSList	  *gl = NULL;
	
	DEBUG_FOOTPRINT();

	fixed = gtk_fixed_new();

	label1 = gtk_label_new("");
	gtk_label_set_markup(GTK_LABEL(label1) , "<b>自动回复</b>");
	gtk_fixed_put(GTK_FIXED(fixed) , label1 , 20 , 20);

	fxset->apBtn = gtk_check_button_new_with_label("开启动自回复");
	g_signal_connect(fxset->apBtn , "toggled" , G_CALLBACK(fx_set_on_autoreply_toggled) , fxset);
	gtk_fixed_put(GTK_FIXED(fixed) , fxset->apBtn , 40 , 50);

	fxset->muteBtn = gtk_check_button_new_with_label("静音");
	gtk_fixed_put(GTK_FIXED(fixed) , fxset->muteBtn , 240 , 50);

	fxset->apEty = gtk_text_view_new();
	gtk_widget_set_sensitive(fxset->apEty , FALSE);
	gtk_widget_set_usize(fxset->apEty , 380 , 50);
	apScr = gtk_scrolled_window_new(NULL , NULL);
	gtk_container_add(GTK_CONTAINER(apScr) , fxset->apEty);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(apScr)
								 , GTK_POLICY_NEVER
								 , GTK_POLICY_NEVER);
	gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(apScr)
									  , GTK_SHADOW_ETCHED_IN);
	gtk_fixed_put(GTK_FIXED(fixed) , apScr , 40 , 80);

	label3 = gtk_label_new("");
	gtk_label_set_markup(GTK_LABEL(label3) , "<b>自动弹出消息窗口</b>");
	gtk_fixed_put(GTK_FIXED(fixed) , label3 , 20 , 150);
	
	fxset->ppCb = gtk_check_button_new_with_label("开启");
	gtk_fixed_put(GTK_FIXED(fixed) , fxset->ppCb , 40 , 180);

	label5 = gtk_label_new("");
	gtk_label_set_markup(GTK_LABEL(label5) , "<b>关闭按钮点击最小化</b>");
	gtk_fixed_put(GTK_FIXED(fixed) , label5 , 200 , 150);

	fxset->smallBtn = gtk_check_button_new_with_label("开启");
	gtk_fixed_put(GTK_FIXED(fixed) , fxset->smallBtn , 220 , 180);

	label6 = gtk_label_new("");
	gtk_label_set_markup(GTK_LABEL(label6) , "<b>消息提示</b>");
	gtk_fixed_put(GTK_FIXED(fixed) , label6 , 360 , 150);

	fxset->alertBtn = gtk_check_button_new_with_label("关闭");
	gtk_fixed_put(GTK_FIXED(fixed) , fxset->alertBtn , 370 , 180);

	label4 = gtk_label_new("");
	gtk_label_set_markup(GTK_LABEL(label4) , "<b>消息发送方式</b>");
	gtk_fixed_put(GTK_FIXED(fixed) , label4 , 20 , 210);

	fxset->etBtn = gtk_radio_button_new_with_label(NULL , "ENTER 发送消息");
	gtk_fixed_put(GTK_FIXED(fixed) , fxset->etBtn , 40 , 240);
	gl = gtk_radio_button_get_group(GTK_RADIO_BUTTON(fxset->etBtn));
	fxset->ctBtn = gtk_radio_button_new_with_label(gl , "CTRL+ENTER 发送消息");
	gtk_fixed_put(GTK_FIXED(fixed) , fxset->ctBtn , 40 , 260);

	gtk_box_pack_start_defaults(GTK_BOX(fxset->ssetting) , fixed);

	fx_set_bind_system(fxset);
}

GtkTreeModel* fx_set_create_gender_model()
{
	struct
	{
		const char* name;
		int id;
	} genders[] = 
	{
		{ "男" , 1 } ,
		{ "女" , 2 } ,
		{ "保密" , 0} ,
		{ NULL , 1}
	};
	GtkTreeStore* model = gtk_tree_store_new(COMBO_COLS_NUM
										, G_TYPE_STRING
										, G_TYPE_INT);
	GtkTreeIter iter;
	int i;

	DEBUG_FOOTPRINT();

	for(i = 0; genders[i].name != NULL ; i++)
	{
		gtk_tree_store_append(model , &iter , NULL);
		gtk_tree_store_set(model , &iter
						 , COMBO_NAME_COL , genders[i].name
						 , COMBO_ID_COL , genders[i].id
						 , -1);
	}
	return GTK_TREE_MODEL(model);
}

void fx_set_on_ok_clicked(GtkWidget* widget , gpointer data)
{
	FxSet *fxset = (FxSet*)data;
	User *user = fxset->fxmain->user;
	Config *config = user->config;
	/**
	 * system setting varibles
	 */
	GtkTextView *textview = GTK_TEXT_VIEW(fxset->apEty);
	GtkTextBuffer *buffer = gtk_text_view_get_buffer(textview);
	GtkTextIter startIter , endIter;
	const char *autoReplyMsg = NULL;
	/**
	 * personal setting varibles
	 */
	const char *nickname = NULL;
	const char *impression = NULL;
	char nickname_text[1024];
	int gender;
	GtkTreeModel *genderModel = NULL;
	GtkTreeIter genderIter;

	DEBUG_FOOTPRINT();

	if(gtk_notebook_get_current_page(GTK_NOTEBOOK(fxset->notebook)) == PAGE_SYSTEM)
	{
		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fxset->etBtn)))
			config->sendMode = SEND_MODE_ENTER;
		else
			config->sendMode = SEND_MODE_CTRL_ENTER;

		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fxset->ppCb)))
			config->autoPopup = AUTO_POPUP_ENABLE;
		else
			config->autoPopup = AUTO_POPUP_DISABLE;

		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fxset->smallBtn)))
			config->closeMode = CLOSE_ICON_MODE;
		else
			config->closeMode = CLOSE_DESTROY_MODE;

		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fxset->muteBtn)))
			config->isMute = MUTE_ENABLE;
		else
			config->isMute = MUTE_DISABLE;

		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fxset->alertBtn)))
			config->msgAlert = MSG_ALERT_DISABLE;
		else
			config->msgAlert = MSG_ALERT_ENABLE;

		gtk_text_buffer_get_start_iter(buffer , &startIter);
		gtk_text_buffer_get_end_iter(buffer , &endIter);
		autoReplyMsg = gtk_text_buffer_get_text(buffer , &startIter , &endIter , TRUE);

		bzero(config->autoReplyMessage , sizeof(config->autoReplyMessage));

		if(autoReplyMsg != NULL)
			strcpy(config->autoReplyMessage , autoReplyMsg);
		fetion_config_save(user);
	}
	else
	{
		nickname = gtk_entry_get_text(GTK_ENTRY(fxset->nick_entry));
		if(strlen(nickname) == 0)
		{
			fx_util_popup_warning(fxset->fxmain , "昵称不能为空!");
			return;
		}
		impression = gtk_entry_get_text(GTK_ENTRY(fxset->impre_entry));
		bzero(user->nickname , sizeof(user->nickname));
		strcpy(user->nickname , nickname);
		bzero(user->impression , sizeof(user->impression));
		strcpy(user->impression , impression);

		genderModel = gtk_combo_box_get_model(GTK_COMBO_BOX(fxset->gender_combo));
		gtk_combo_box_get_active_iter(GTK_COMBO_BOX(fxset->gender_combo) , &genderIter);

		gtk_tree_model_get(genderModel , &genderIter , COMBO_ID_COL , &gender , -1);
		user->gender = gender;
		if(fetion_user_update_info(user) > 0)
		{
			
			bzero(nickname_text , sizeof(nickname_text));

			sprintf(nickname_text , "<b>%s</b>"
					, user->nickname == NULL ? user->sId : user->nickname );

			gtk_label_set_markup(GTK_LABEL(fxset->fxmain->headPanel->name_label) , nickname_text );

			gtk_label_set_text(GTK_LABEL(fxset->fxmain->headPanel->impre_label)
					, strlen(user->impression) == 0 ? "点此输入心情短语" : user->impression);

			bzero(fxset->fxmain->headPanel->oldimpression , sizeof(fxset->fxmain->headPanel->oldimpression));
			strcpy(fxset->fxmain->headPanel->oldimpression
				, (strlen(user->impression) == 0 || user->impression == NULL)
				? "点此输入心情短语" : user->impression);
				}
	}
	gtk_dialog_response(GTK_DIALOG(fxset->dialog) , GTK_RESPONSE_CANCEL);
}

void fx_set_on_cancel_clicked(GtkWidget* widget , gpointer data)
{
	DEBUG_FOOTPRINT();

	gtk_dialog_response(GTK_DIALOG(data) , GTK_RESPONSE_CANCEL);
}

void fx_set_on_autoreply_toggled(GtkWidget* widget , gpointer data)
{
	FxSet *fxset = (FxSet*)data;

	DEBUG_FOOTPRINT();

	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)))
	{
		gtk_widget_set_sensitive(fxset->apEty , TRUE);
	}
	else
	{
		gtk_widget_set_sensitive(fxset->apEty , FALSE);
	}
}
