/*
 * OpenConnect GUI (a GTK/Hildon GUI client for OpenConnect)
 *
 * Copyright (c) 2009-2010 Pascal Jermini <lorelei@garage.maemo.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to:
 *
 *   Free Software Foundation, Inc.
 *   51 Franklin Street, Fifth Floor,
 *   Boston, MA 02110-1301 USA
 */

#include <stdlib.h>

#include "about.h"
#include "version.h"

void aboutWindow (GtkWidget *widget, gpointer data)
{
	GtkWidget *win;
	GtkWidget *vbox;
	GtkWidget *label1;
	GtkWidget *label2;
	GtkWidget *author;
	GtkWidget *email;
	GtkWidget *author2;
	GtkWidget *email2;
	char *versionString;

	versionString = (char*)malloc(sizeof(char)*100);
	sprintf(versionString, "Version %s", VERSION);
	
	/* Create the main window */
	win = hildon_stackable_window_new();
	gtk_window_set_title ( GTK_WINDOW (win), "OpenConnect GUI - About");

	label1 = gtk_label_new("OpenConnect GUI");
	label2 = gtk_label_new(versionString);
	author = gtk_label_new("Pascal Jermini");
	email = gtk_label_new("lorelei@garage.maemo.org");
	author2 = gtk_label_new("Geert Steyaert");
	email2 = gtk_label_new("geert.steyaert@gmail.com");

	
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), label1, FALSE, FALSE, 0); 
	gtk_box_pack_start (GTK_BOX (vbox), label2, FALSE, FALSE, 0); 
	gtk_box_pack_start (GTK_BOX (vbox), author, FALSE, FALSE, 10); 
	gtk_box_pack_start (GTK_BOX (vbox), email, FALSE, FALSE, 0); 
	gtk_box_pack_start (GTK_BOX (vbox), author2, FALSE, FALSE, 10); 
	gtk_box_pack_start (GTK_BOX (vbox), email2, FALSE, FALSE, 0); 
	gtk_container_add (GTK_CONTAINER (win), vbox);

	/* This call show the window and also add the window to the stack */
	gtk_widget_show_all (win);
	free(versionString);

}

/* vim: set ts=4: */
