#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <iostream>
#include <QDir>
#include <QSound>
#include <QCoreApplication>
#include <QTimer>
#include <QProcess>
#include <QXmlStreamReader>
#include <QTextDocumentWriter>

#include <QHttp>
#include <QUrl>
#include <phonon>


QList<QString> soundList;
bool playing = false;
bool cmbLangChange = false;




#if defined(Q_WS_MAEMO_5)
    QString citiesFolder = "/home/user/MyDocs/cities";
    QString SoundDir = "/home/user/MyDocs/cities/Voices";
    QString eSpeakLocation = "/usr/bin/espeak";
    bool maemo5 = true;
#else
    QString citiesFolder = "C:/Languages";
    QString SoundDir = "C:/Languages";
    QString eSpeakLocation = "C:/Program Files/eSpeak/command_line/espeak.exe";
    bool maemo5 = false;
#endif

QString soundLocation;

QString defaultVoice = "english";
QString defaultEspeak = "en";
bool UseEspeak = true;
bool UseOnlineSearch = true;


QStringList htmlEncoding;


//XML STUFF
QStringList maneuverValid;
QString distToJunction;

int kmVals[50];
QStringList kmSounds[50];
int miVals[50];
QStringList miSounds[50];
int num = -1;

QString manDownTurn[100];
QStringList manUpSound[100];
QString manUpTurn[100];
QStringList manDownSound[100];
QString manNextTurn[100];
QStringList manNextSound[100];


MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);


    LoadConfig();



    //Once a connection is made, accept it
    connect(&server, SIGNAL(newConnection()),
      this, SLOT(acceptConnection()));

    //Start listening for connections
    server.listen(QHostAddress::Any, 9999);



    LoadVoice();




    //Get espeak languages
    QStringList arguments;
    arguments << "--voices";
    QProcess *espeakServer = new QProcess(this);
    espeakServer->start(eSpeakLocation,arguments);


    while (!espeakServer->canReadLine())
    {
        QCoreApplication::processEvents();
    }

    QByteArray result = espeakServer->readAll();
    QStringList lst;
    lst << result;


    QString vlist = lst[0];
    QStringList voiceList;
    voiceList = vlist.split("\n");

    QStringList strParts;

    //Lets Log it!
    for (int v=1; v<voiceList.count(); v++)
    {
        strParts = voiceList[v].split(" ");
        if (strParts.count() > 1)
            ui->cmbeSpeakLang->addItem(strParts[3]);
    }

    //set the default espeak
    int defaultLang = ui->cmbeSpeakLang->findText(defaultEspeak);
    if (defaultLang > -1)
        ui->cmbeSpeakLang->setCurrentIndex(defaultLang);




    QTimer *timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(PlaySounds()));
    timer->start(100);


    //Super long list of encoding thingys
    htmlEncoding << "! %21" << "\" %22" << "# %23" << "$ %24" << "% %25" << "& %26" << "' %27" << "( %28" << ") %29" << "* %2A" << "+ %2B" << ", %2C" << "- %2D" << ". %2E" << "/ %2F" << "0 %30" << "1 %31" << "2 %32" << "3 %33" << "4 %34" << "5 %35" << "6 %36" << "7 %37" << "8 %38" << "9 %39" << ": %3A" << "; %3B" << "< %3C" << "= %3D" << "> %3E" << "? %3F" << "@ %40" << "A %41" << "B %42" << "C %43" << "D %44" << "E %45" << "F %46" << "G %47" << "H %48" << "I %49" << "J %4A" << "K %4B" << "L %4C" << "M %4D" << "N %4E" << "O %4F" << "P %50" << "Q %51" << "R %52" << "S %53" << "T %54" << "U %55" << "V %56" << "W %57" << "X %58" << "Y %59" << "Z %5A" << "[ %5B" << "\\ %5C" << "] %5D" << "^ %5E" << "_ %5F" << "` %60" << "a %61" << "b %62" << "c %63" << "d %64" << "e %65" << "f %66" << "g %67" << "h %68" << "i %69" << "j %6A" << "k %6B" << "l %6C" << "m %6D" << "n %6E" << "o %6F" << "p %70" << "q %71" << "r %72" << "s %73" << "t %74" << "u %75" << "v %76" << "w %77" << "x %78" << "y %79" << "z %7A" << "{ %7B" << "| %7C" << "} %7D" << "~ %7E" << " %80" << " %82" << " %83" << " %84" << " %85" << " %86" << " %87" << " %88" << " %89" << " %8A" << " %8B" << " %8C" << " %8E" << "  %91" << " %92" << " %95" << " %96" << " %97" << " %98" << " %99" << " %9A" << " %9B" << " %9C" << " %9E" << " %9F" << " %A1" << " %A2" << " %A3" << " %A5" << "| %A6" << " %A7" << " %A8" << " %A9" << " %AA" << " %AB" << " %AC" << " %AD" << " %AE" << " %AF" << " %B0" << " %B1" << " %B2" << " %B3" << " %B4" << " %B5" << " %B6" << " %B7" << " %B8" << " %B9" << " %BA" << " %BB" << " %BC" << " %BD" << " %BE" << " %BF" << " %C0" << " %C1" << " %C2" << " %C3" << " %C4" << " %C5" << " %C6" << " %C7" << " %C8" << " %C9" << " %CA" << " %CB" << " %CC" << " %CD" << " %CE" << " %CF" << " %D0" << " %D1" << " %D2" << " %D3" << " %D4" << " %D5" << " %D6" << " %D8" << " %D9" << " %DA" << " %DB" << " %DC" << " %DD" << " %DE" << " %DF" << " %E0" << " %E1" << " %E2" << " %E3" << " %E4" << " %E5" << " %E6" << " %E7" << " %E8" << " %E9" << " %EA" << " %EB" << " %EC" << " %ED" << " %EE" << " %EF" << " %F0" << " %F1" << " %F2" << " %F3" << " %F4" << " %F5" << " %F6" << " %F7" << " %F8" << " %F9" << " %FA" << " %FB" << " %FC" << " %FD" << " %FE" << " %FF";


    connect(ui->btnClear, SIGNAL(clicked()), this, SLOT(clearLog()));
    connect(ui->cmbLanguages, SIGNAL(currentIndexChanged(QString)), this, SLOT(on_cmbLanguages_editTextChanged(QString)));
    connect(ui->btnCommandTest, SIGNAL(clicked()), this, SLOT(btnCommandTest_clicked()));
    connect(ui->btneSpeakLine, SIGNAL(clicked()), this, SLOT(btneSpeakLine_Clicked()));
    connect(ui->btnSave, SIGNAL(clicked()), this, SLOT(SaveLog()));
    connect(ui->btnReload, SIGNAL(clicked()), this, SLOT(LoadVoice()));

    if (maemo5)
    {
        ui->txtLog->append("Using aplay for prerecorded sounds");
    }
    else
    {
        ui->txtLog->append("Using QSound for prerecorded sounds");
    }



    //Read some XML

    QFile xmlfile(SoundDir + "/" + ui->cmbLanguages->currentText() + "/config.xml");
    if (xmlfile.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        QTextStream in(&xmlfile);
        QString line = in.readAll();
        ReadXML(line);
    }

    searchResults = new QHttp(this);
    connect(searchResults, SIGNAL(done(bool)), this, SLOT(updateXML(bool)));


}

void MainWindow::LoadConfig()
{
    //Load Defaults
    QFile config(citiesFolder + "/config.txt");
    if (config.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        QTextStream ts(&config);
        QString line = ts.readAll();
        QStringList lineList = line.split("\n");
        for (int x = 0; x < lineList.count(); x++)
        {
            QStringList retLine = lineList[x].split("=");
            if (retLine[0] == "voice_path")
                SoundDir = retLine[1];
            else if (retLine[0] == "default_voice")
                defaultVoice = retLine[1];
            else if (retLine[0] == "default_espeak")
                defaultEspeak = retLine[1];
            else if (retLine[0] == "use_espeak")
                UseEspeak = (retLine[1] == "true");
            else if (retLine[0] == "use_online_search")
                UseOnlineSearch = (retLine[1] == "true");

        }
    }

    ui->chkSearchOnline->setChecked(UseOnlineSearch);
    ui->chkStreetNames->setChecked(UseEspeak);
    ui->txtVoicePath->setText(SoundDir);
    config.close();
}

void MainWindow::SaveConfig()
{
    //Save Defaults



    QFile config(citiesFolder + "/config.txt");
    if (config.open(QIODevice::Truncate | QIODevice::Text | QIODevice::ReadWrite))
    {
        QTextStream out(&config);

        out << "voice_path=" + SoundDir << "\n";
        out << "default_voice=" + ui->cmbLanguages->currentText() << "\n";
        out << "default_espeak=" + ui->cmbeSpeakLang->currentText() << "\n";
        QString retStreet = (ui->chkStreetNames->checkState() == Qt::Checked ? "true" : "false");
        out << "use_espeak=" + retStreet << "\n";
        QString retSearch = (ui->chkSearchOnline->checkState() == Qt::Checked ? "true" : "false");
        out << "use_online_search=" + retSearch;



        config.close();

    }


}

void MainWindow::LoadVoice()
{
    SoundDir = ui->txtVoicePath->text();

    ui->txtLog->append("Looking for voices in: " + SoundDir);

    cmbLangChange = true;
    ui->cmbLanguages->clear();
    cmbLangChange = false;


    //Open the directory with the voices
    QDir directory(SoundDir);
    if (directory.exists(SoundDir))
    {

        //Get back the list of directories excluding those dots for going back to the top etc
        QStringList retList = directory.entryList(QDir::Dirs | QDir::NoDotAndDotDot);

        //Load the combo box with the languages
        ui->cmbLanguages->addItems(retList);

        //Lets pick the default
        int defaultLangVoice = ui->cmbLanguages->findText(defaultVoice);
        if (defaultLangVoice > -1)
            ui->cmbLanguages->setCurrentIndex(defaultLangVoice);

        //Lets Log it!
        for (int x=0; x<retList.count(); x++)
        {
            ui->txtLog->append("Loaded voice: " + retList[x]);

        }

        //get chosen sound directory
        QDir soundDirectory(SoundDir + "/" + ui->cmbLanguages->currentText());
        QStringList soundList = soundDirectory.entryList(QDir::Dirs | QDir::NoDotAndDotDot);
        soundLocation = SoundDir + "/" + ui->cmbLanguages->currentText() + "/" + soundList[0] + "/";


        //populate the field for command testing
        QDir fileDir(soundLocation);
        QStringList fileList = fileDir.entryList(QDir::Files);
        ui->cmbCommand->clear();
        for (int x = 0; x< fileList.count(); x++)
        {
            ui->cmbCommand->addItem(ui->cmbLanguages->currentText() + "/" + soundList[0] + "/" + fileList[x]);
        }


        return;
    }
    ui->txtLog->append("No voices found!");
}

MainWindow::~MainWindow()
{
    SaveConfig();
    server.close();
    delete ui;
}


void MainWindow::acceptConnection()
{
  client = server.nextPendingConnection();

  connect(client, SIGNAL(readyRead()), this, SLOT(startRead()));
}

void MainWindow::startRead()
{
    if (client->canReadLine())
    {
        //Message to send back
        QString messageSend;

        //get the message
        QString msg = QString(client->readLine());

        //split it to remove the garbage parts
        QStringList parts = msg.split(QRegExp("[ \r\n][ \r\n]*"));

        //Add the message to the log
        ui->txtLog->append("Received:" + parts[1]);

        //the fun part :(
        QStringList messageParts = parts[1].split("/");

        if (messageParts[1] == "Sound")
        {
            //Do stuff with commands
            QStringList commands = messageParts[2].replace(":", "").split("|"); //replace bit is to fix backwards compatability
            if (commands.isEmpty())
                return;


            //clear the current list'
            soundList.clear();

            QString soundFiles = GetSound(commands[0],commands[1], "", commands[2], commands[3]);

            if (soundFiles.isEmpty() || soundFiles == "")
                return;

            soundList.append(soundFiles.split("|"));

            for (int x = 4; x < commands.count(); x++)
            {
                //Add it to the soundList but add play: at the front, this tells it to play the sound not say it
                soundList.append(commands[x]);
            }

            //show the message being said or something
            messageSend = msg;
            client->close();
        }
        else if (messageParts[1] == "Time")
        {
            messageSend = "Now!";
            client->close();
        }
        else
        {
            //Unknown commands
            ui->txtLog->append(parts[1].remove(0,1));


            url.setPath("/nsp" + parts[1]);
            searchResults->setHost("where.s2g.gate5.de");
            searchResults->get(url.toString());

        }





        //PlaySounds();
    }
}

void MainWindow::updateXML(bool error)
{
    if (!error) {
        //Send the xml result we recieved
        QByteArray ret = searchResults->readAll();
        //ui->txtLog->append(ret); //No need to spam the log with the xml results.
        QTextStream os( client );
        os << ret;
        client->close();
    }
}

void MainWindow::PlaySounds()
{

    //If already playing sounds, don't go through the loop again
    if (playing)
    {
        return;
    }


   //only play sounds as long as the list is full of something
    if (!soundList.isEmpty())
    {
        try
        {
            QString fileLocation = SoundDir + "/" + soundList.first().replace("\\","/");
            QDir directory(fileLocation);

            //Yes we're playing!
            playing = true;

            //the sound Exisits!
            if (directory.exists(fileLocation))
            {
                //Add the message to the log
                ui->txtLog->append("Playing:" + soundList.first());

                //Maemo 5 lacks QSound, using aplay for now until i get phonon working
                if (maemo5)
                {

                    //QCoreApplication::processEvents();

                    QStringList arguments;
                    arguments << fileLocation;

                    QProcess *aplayServer = new QProcess(this);

                    aplayServer->execute("/usr/bin/aplay",arguments);
                }
                else
                {
                    //Load the sound and play it
                    QSound soundPlayer(fileLocation);

                    while (!soundPlayer.isAvailable())
                    {
                        //QCoreApplication::processEvents();
                    }

                    soundPlayer.setLoops(2); //Temporary for windows. isfinished doesn't work unless looped on windows, not needed on linux

                    soundPlayer.play();

                    while (!soundPlayer.isFinished())
                    {
                        //QCoreApplication::processEvents();
                    }
                }


            }
            else
            {
                //If we've chosen to only play sounds
                if (ui->chkStreetNames->checkState() == Qt::Checked)
                {
                    //Add the message to the log
                    ui->txtLog->append("saying:" + soundList.first());
                    //QCoreApplication::processEvents();

                    QStringList arguments;
                    QStringList htmlparts;

                    QString wordSay = soundList.first().replace("%20", ", ");

                    for (int u = 0; u < htmlEncoding.count(); u++)
                    {
                        htmlparts = htmlEncoding[u].split(" ");
                        wordSay = wordSay.replace(htmlparts[1], htmlparts[0]);
                    }

                    arguments << "-v" << ui->cmbeSpeakLang->currentText() << "-a" << QString::number(ui->eSpeakVol->value()) << "\"" + wordSay + "\"";

                    QProcess *espeakServer = new QProcess(this);

                    espeakServer->execute(eSpeakLocation,arguments);
                }

            }

            //Incase we clear it
            if (!soundList.isEmpty())
            {
                //remove the one we played
                soundList.removeFirst();
            }
        }
        catch(...)
        {
            ui->txtLog->append("ERROR!");
        }

    }

    //QCoreApplication::processEvents();

    //all done so we can loop later
    playing = false;
}




void MainWindow::clearLog()
{
    ui->txtLog->clear();
}

void MainWindow::on_cmbLanguages_editTextChanged(QString )
{
    if (cmbLangChange)
            return;

    //get chosen sound directory
    QDir soundDirectory(SoundDir + "/" + ui->cmbLanguages->currentText());
    QStringList soundList = soundDirectory.entryList(QDir::Dirs | QDir::NoDotAndDotDot);
    soundLocation = SoundDir + "/" + ui->cmbLanguages->currentText() + "/" + soundList[0] + "/";

    QDir fileDir(soundLocation);
    QStringList fileList = fileDir.entryList(QDir::Files);
    ui->cmbCommand->clear();
    ui->cmbCommand->addItems(fileList);

    QFile xmlfile(SoundDir + "/" + ui->cmbLanguages->currentText() + "/config.xml");
    if (xmlfile.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        QTextStream in(&xmlfile);
        QString line = in.readAll();
        ReadXML(line);
    }


}
void MainWindow::btnCommandTest_clicked()
{
    //clear the current list
    soundList.clear();
    //Add it to the soundList but add play: at the front, this tells it to play the sound not say it
    soundList.append(ui->cmbCommand->currentText());
}

void MainWindow::btneSpeakLine_Clicked()
{
    //clear the current list
    soundList.clear();
    //Add it to the soundList but add play: at the front, this tells it to play the sound not say it
    soundList.append(" " + ui->txteSpeakLine->text());
}

void MainWindow::SaveLog()
{
    QTextDocumentWriter writer(SoundDir + "/log.txt");
    writer.write(ui->txtLog->document());
}










void MainWindow::ReadXML(QString xmlfile)
{
    QXmlStreamReader xmlDoc(xmlfile);

    ParseXML(xmlDoc);



    if (xmlDoc.hasError())
    {
        ui->txtLog->append("Error! oh damn :(");
    }

}



QString MainWindow::GetSound(QString distance, QString unit, QString linkID, QString maneuverType, QString turnVal)
{

    QString returnPart;

if (unit == "km")
{

    for (int z = 0; z < 51; z++)
    {

        if (distance.toInt() <= kmVals[z])
        {
            returnPart = kmSounds[z].join("|");
            z = 100;
        }
    }
}
else
{
    for (int z = 0; z < 51; z++)
    {

        if (distance.toInt() <= miVals[z])
        {
            returnPart = miSounds[z].join("|");
            z = 100;
        }
    }
}



    for (int x = 0; x < 100; x++)
    {
        QString sentCommand = maneuverType + turnVal;
        QString currentItem = manDownTurn[x].replace("_","").toLower();

        if (currentItem == sentCommand)
        {
            returnPart = returnPart + "|" + manDownSound[x].join("|");
            x = 100;
        }
    }

return returnPart;

}

void MainWindow::ParseXML(QXmlStreamReader& obj)
{
    num = -1;



//    QXmlStreamAttributes attr;
//    attr = obj.attributes();
//    //StartElement - speech
//    ui->txtLog->append(obj.tokenString() + " - " + obj.name().toString());

    //To all trying to decipher my horrible code... good luck. I can't do it myself.


//    int kmVals[50];
//    QStringList kmSounds[50];


    while (!obj.atEnd())
    {


        //maneuverValid not needed?
        if (obj.name().toString() == "link" && obj.attributes().value("id").toString() == "maneuverValid") {
            // skip through speech element
            obj.readNext();
            while (!(obj.isEndElement() && obj.name().toString() == "link"))
            {
                if (obj.name().toString() == "maneuver")
                {
                    QString ret = obj.attributes().value("val").toString();
                    if (ret != "")
                        maneuverValid.append(ret);
                }
                obj.readNext();
            }
        }




        //distToJunction
        if (obj.name().toString() == "link" && obj.attributes().value("id").toString() == "distToJunction") {
            // skip through speech element
            obj.readNext();

            while (!(obj.isEndElement() && obj.name().toString() == "link"))
            {
                if (obj.name().toString() == "soundfile")
                {
                    QString ret = obj.attributes().value("val").toString();
                    if (ret != "")
                        distToJunction = ret;
                }
                obj.readNext();
            }
        }


        //distToManeuver
        if (obj.name().toString() == "link" && obj.attributes().value("id").toString() == "distToManeuver")
        {
            num = -1;
            // skip through speech element

            while (!(obj.isEndElement() && obj.name().toString() == "link"))
            {

                //KM!
                if (obj.name().toString() == "flags" && obj.attributes().value("val") == "KM")
                {
                    obj.readNext();
                    while (!(obj.isEndElement() && obj.name().toString() == "flags"))
                    {
                        //Dummy
                        if (obj.name().toString() == "dummy")
                        {
                            while (!(obj.isEndElement() && obj.name().toString() == "dummy"))
                            {
                                if (obj.name().toString() == "distancetomaneuver")
                                {
                                    QString ret = obj.attributes().value("max").toString();
                                    if (ret != "")
                                    {
                                        num++;
                                        kmVals[num] = ret.toInt();
                                    }
                                }
                                if (obj.name().toString() == "soundfile")
                                {
                                    QString ret = obj.attributes().value("val").toString();
                                    if (ret != "")
                                    {
                                        if ((kmSounds[num].count() > 0))
                                        {
                                            num++;
                                            kmVals[num] = 951;
                                            kmSounds[num].append(ret);
                                        }
                                        else
                                        {
                                            kmSounds[num].append(ret);
                                        }
                                    }
                                }
                                obj.readNext();
                            }

                            while (!(obj.isEndElement() && obj.name().toString() == "distancetomaneuver"))
                            {
                                if (obj.name().toString() == "soundfile")
                                {
                                    QString ret = obj.attributes().value("val").toString();
                                    if (ret != "")
                                    {
                                        for (int w = 0; w < num+1; w++)
                                        {
                                            if (kmSounds[w].count() < 2)
                                                kmSounds[w].append(ret);
                                        }
                                    }
                                }
                                obj.readNext();
                            }

                            obj.readNext();
                            num++;
                            while (!(obj.isEndElement() && obj.name().toString() == "distancetomaneuver"))
                            {
                                if (obj.name().toString() == "soundfile")
                                {
                                    QString ret = obj.attributes().value("val").toString();
                                    if (ret != "")
                                    {
                                        kmVals[num] = 1600;
                                        kmSounds[num].append(ret);
                                    }
                                }
                                obj.readNext();
                            }
                        }


                        obj.readNext();
                    }
                }
                else if (obj.name().toString() == "flags" && obj.attributes().value("val") == "MI")
                {
                    num = -1;
                    obj.readNext();
                    while (!(obj.isEndElement() && obj.name().toString() == "flags"))
                    {
                        //Dummy
                        if (obj.name().toString() == "dummy")
                        {
                            while (!(obj.isEndElement() && obj.name().toString() == "dummy"))
                            {
                                if (obj.name().toString() == "distancetomaneuver")
                                {
                                    QString ret = obj.attributes().value("max").toString();
                                    if (ret != "")
                                    {
                                        num++;
                                        miVals[num] = ret.toInt();
                                    }
                                }
                                if (obj.name().toString() == "soundfile")
                                {
                                    QString ret = obj.attributes().value("val").toString();
                                    if (ret != "")
                                    {
                                        if ((miSounds[num].count() > 0))
                                        {
                                            num++;
                                            miVals[num] = 951;
                                            miSounds[num].append(ret);
                                        }
                                        else
                                        {
                                            miSounds[num].append(ret);
                                        }
                                    }
                                }
                                obj.readNext();
                            }

                            while (!(obj.isEndElement() && obj.name().toString() == "distancetomaneuver"))
                            {
                                if (obj.name().toString() == "soundfile")
                                {
                                    QString ret = obj.attributes().value("val").toString();
                                    if (ret != "")
                                    {
                                        for (int w = 0; w < num+1; w++)
                                        {
                                            if (miSounds[w].count() < 2)
                                                miSounds[w].append(ret);
                                        }
                                    }
                                }
                                obj.readNext();
                            }

                            obj.readNext();
                            num++;
                            while (!(obj.isEndElement() && obj.name().toString() == "distancetomaneuver"))
                            {
                                if (obj.name().toString() == "soundfile")
                                {
                                    QString ret = obj.attributes().value("val").toString();
                                    if (ret != "")
                                    {
                                        miVals[num] = 1600;
                                        miSounds[num].append(ret);
                                    }
                                }
                                obj.readNext();
                            }
                        }


                        obj.readNext();
                    }
                }

                obj.readNext();
            }

        }


        //maneuverDown, Up or next
        if (obj.name().toString() == "link" && (obj.attributes().value("id").toString() == "maneuverDown" || obj.attributes().value("id").toString() == "maneuverUp" || obj.attributes().value("id").toString() == "nextManeuver"))
        {
            QString TempTurn[100];
            QStringList TempSound[100];

            QString chosenMan = obj.attributes().value("id").toString();

            // skip through speech element

            while (!(obj.isEndElement() && obj.name().toString() == "link"))
            {

                //Junction
                if ((obj.name().toString() == "maneuver" || obj.name().toString() == "nextmaneuver") && obj.attributes().value("val") == "JUNCTION")
                {
                    num = -1;

                    obj.readNext();
                    while (!(obj.isEndElement() && (obj.name().toString() == "maneuver" || obj.name().toString() == "nextmaneuver")))
                    {

                        if (obj.name().toString() == "turn" || obj.name().toString() == "nextturn")
                        {
                            QString ret = obj.attributes().value("val").toString();
                            if (ret != "")
                            {
                                num++;
                                TempTurn[num] = "JUNCTION_" + ret;
                            }
                        }
                        if (obj.name().toString() == "soundfile")
                        {
                            QString ret = obj.attributes().value("val").toString();
                            if (ret != "")
                            {
                                TempSound[num].append(ret);
                            }
                        }

                        obj.readNext();
                    }
                }
                else if ((obj.name().toString() == "maneuver" || obj.name().toString() == "nextmaneuver") && (obj.attributes().value("val") == "ENTER_HIGHWAY" || obj.attributes().value("val") == "LEAVE_HIGHWAY" || obj.attributes().value("val") == "CHANGE_HIGHWAY" || obj.attributes().value("val") == "CONTINUE_HIGHWAY"))
                {
                    QString retName = obj.attributes().value("val").toString();

                    obj.readNext();
                    while (!(obj.isEndElement() && (obj.name().toString() == "maneuver" || obj.name().toString() == "nextmaneuver")))
                    {
                        obj.readNext();

                        if (obj.name().toString() == "turn" || obj.name().toString() == "nextturn")
                        {
                            QString ret = obj.attributes().value("val").toString();
                            if (ret != "")
                            {
                                num++;
                                TempTurn[num] = retName + "_" + ret;
                            }

                            while (!(obj.isEndElement() && obj.name().toString() == "turn"))
                            {
                                if (obj.name().toString() == "soundfile")
                                {
                                    QString ret = obj.attributes().value("val").toString();
                                    if (ret != "")
                                    {
                                        TempSound[num].append(ret);
                                    }
                                }

                                obj.readNext();
                            }
                        }

                        if (obj.name().toString() == "soundfile")
                        {
                            num++;
                            while (!(obj.isEndElement() && (obj.name().toString() == "maneuver" || obj.name().toString() == "nextmaneuver")))
                            {
                                QString ret = obj.attributes().value("val").toString();
                                if (ret != "")
                                {
                                    TempTurn[num] = retName + "_Ending";
                                    TempSound[num].append(ret);
                                }
                                obj.readNext();
                            }
                        }

                    }
                }
                else if ((obj.name().toString() == "maneuver" || obj.name().toString() == "nextmaneuver") && obj.attributes().value("val") == "ROUNDABOUT")
                {
                    QString startRound;
                    while (!(obj.isEndElement() && (obj.name().toString() == "maneuver" || obj.name().toString() == "nextmaneuver")))
                    {
                        obj.readNext();

                        if (obj.name().toString() == "soundfile")
                        {
                            QString ret = obj.attributes().value("val").toString();
                            if (ret != "")
                            {
                               startRound = ret;
                            }
                        }

                        if (obj.name().toString() == "roundaboutexit" || obj.name().toString() == "nextroundaboutexit")
                        {
                            QString ret = obj.attributes().value("val").toString();
                            if (ret != "")
                            {
                                num++;
                                TempTurn[num] = "ROUNDABOUTROUNDABOUT__" + ret;
                                TempSound[num].append(startRound);
                            }

                            while (!(obj.isEndElement() && (obj.name().toString() == "roundaboutexit" || obj.name().toString() == "nextroundaboutexit")))
                            {
                                if (obj.name().toString() == "soundfile")
                                {
                                    QString ret = obj.attributes().value("val").toString();
                                    if (ret != "")
                                    {
                                        TempSound[num].append(ret);
                                    }
                                }

                                obj.readNext();
                            }
                        }

                    }
                }
                else if ((obj.name().toString() == "maneuver" || obj.name().toString() == "nextmaneuver") && (obj.attributes().value("val") == "EXT_UTURN_RIGHT" || obj.attributes().value("val") == "EXT_UTURN_LEFT" || obj.attributes().value("val") == "END"  || obj.attributes().value("val") == "UTURN" || obj.attributes().value("val") == "FERRY"))
                {
                    num++;
                    TempTurn[num] = obj.attributes().value("val").toString();
                    obj.readNext();

                    while (!(obj.isEndElement() && (obj.name().toString() == "maneuver" || obj.name().toString() == "nextmaneuver")))
                    {
                        if (obj.name().toString() == "soundfile")
                        {
                            QString ret = obj.attributes().value("val").toString();
                            if (ret != "")
                            {
                                TempSound[num].append(ret);
                            }
                        }

                        obj.readNext();
                    }
                }

                obj.readNext();
            }

            if (chosenMan == "maneuverDown")
            {
                for (int x = 0; x < 100; x++)
                {
                    manDownTurn[x] = TempTurn[x];
                    manDownSound[x] = TempSound[x];
                }
            }
            else if (chosenMan == "maneuverUp")
            {
                for (int x = 0; x < 100; x++)
                {
                    manUpTurn[x] = TempTurn[x];
                    manUpSound[x] = TempSound[x];
                }
            }
            else if (chosenMan == "nextManeuver")
            {
                for (int x = 0; x < 100; x++)
                {
                    manNextTurn[x] = TempTurn[x];
                    manNextSound[x] = TempSound[x];
                }
            }
        }


        obj.readNext();
    }
    //Of no purpse other than to stop the debugger here
    num = 100;
}
