#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QtNetwork>
#include <QObject>
#include <QTcpServer>
#include <QTcpSocket>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    Ui::MainWindow *ui;

public slots:
  void acceptConnection();
  void startRead();
  void PlaySounds();
  void clearLog();

private:
  QTcpServer server;
  QTcpSocket* client;
  QHttp* searchResults;
  QUrl url;



private slots:
    void on_cmbLanguages_editTextChanged(QString );
    void btnCommandTest_clicked();
    void btneSpeakLine_Clicked();
    void ReadXML(QString xmlfile);
    void SaveLog();
    void ParseXML(QXmlStreamReader& obj);
    void updateXML(bool error);
    void LoadConfig();
    void SaveConfig();
    void LoadVoice();
    QString GetSound(QString distance, QString linkID, QString maneuverType, QString turnVal);
};

#endif // MAINWINDOW_H
