#!/usr/bin/env python

import logging
import pygame
import pygame.locals

import config


_moduleLogger = logging.getLogger(__name__)


SUPER_STATE_START = pygame.USEREVENT + 1
SUPER_STATE_OVER = SUPER_STATE_START + 1
PLAYER_EATEN = SUPER_STATE_OVER + 1
#BITE = pygame.USEREVENT + 1
#KILL = pygame.USEREVENT + 1
#SUPER = pygame.USEREVENT + 1


class greenMan(pygame.sprite.Sprite):

	def __init__(self, centerPoint, level):
		pygame.sprite.Sprite.__init__(self)
		self._normal_image = level.sprites[level.GREENMAN]
		self._closed_image = level.sprites[level.GREENMAN_CLOSED]
		self._image = self._normal_image
		self._rect = self._image.get_rect()
		self._rect.center = centerPoint
		self._current_rect = None
		#centerPoint = self.image.get_center()
		config.greenHits = 0
		self._openclosed = 1
		self.rect.inflate_ip(-6, -6)
		self._original_rect = pygame.Rect(self.rect)
		#self.rect.center = (100, 160)
		self.lives = config.lives
		self.pellets = 0
		self.supers = 0
		self.superState = False

		self._x_dist = config.player_speed
		self._y_dist = config.player_speed
		self._xMove = 0
		self._yMove = 0
		self._hdirect = 2
		self._vdirect = 0
		#self.charcenter = centerPoint
		#self.rect.inflate_ip(-6, -6)
		#pygame.mixer.init()
		self._biteSound = level.biteSound
		self._superSound = level.superSound
		self._killSound = level.killSound

	@property
	def image(self):
		# Used by pygame
		return self._image

	@property
	def rect(self):
		# Used by pygame
		return self._rect

	def OpenAndClose(self):
		if self._openclosed == 1:
			self._current_rect = self.rect
			self._image = self._closed_image
			self._rect = self._current_rect
			self._openclosed = 2
		else:
			self._current_rect = self.rect
			self._image = self._normal_image
			self._rect = self._current_rect
			self._openclosed = 1
		if self._hdirect == 1:
			self._image = pygame.transform.flip(self.image, 1, 0)
		if self._vdirect == 2:
			if self._hdirect == 1:
				self._image = pygame.transform.rotate(self.image, -90)
			elif self._hdirect == 2:
				self._image = pygame.transform.rotate(self.image, 90)
		elif self._vdirect == 1:
			if self._hdirect == 1:
				self._image = pygame.transform.rotate(self.image, 90)
			if self._hdirect == 2:
				self._image = pygame.transform.rotate(self.image, -90)

	def MoveKeyDown(self, key):
		if (key == pygame.locals.K_RIGHT):
			self._xMove += self._x_dist
			if self._hdirect == 1:
				self._image = pygame.transform.flip(self.image, 1, 0)
				self._hdirect = 2
		elif (key == pygame.locals.K_LEFT):
			self._xMove += -self._x_dist
			if self._hdirect == 2:
				self._image = pygame.transform.flip(self.image, 1, 0)
				self._hdirect = 1
		elif (key == pygame.locals.K_UP):
			self._yMove += -self._y_dist
			if self._vdirect == 0:
				if self._hdirect == 2:
					self._image = pygame.transform.rotate(self.image, 90)
				if self._hdirect == 1:
					self._image = pygame.transform.rotate(self.image, -90)
			self._vdirect = 2
		elif (key == pygame.locals.K_DOWN):
			self._yMove += self._y_dist
			if self._vdirect == 0:
				if self._hdirect == 2:
					self._image = pygame.transform.rotate(self.image, -90)
				if self._hdirect == 1:
					self._image = pygame.transform.rotate(self.image, 90)
			self._vdirect = 1

	def MoveKeyUp(self, key):
		control = 1
		if self._openclosed == 2:
			self._image = self._normal_image
			self.OpenAndClose()
		if (key == pygame.locals.K_RIGHT):
			self._xMove += -self._x_dist
		elif (key == pygame.locals.K_LEFT):
			self._xMove += self._x_dist
		elif (key == pygame.locals.K_UP):
			self._yMove += self._y_dist
			if self._hdirect == 2:
				self._image = pygame.transform.rotate(self.image, -90)
			if self._hdirect == 1:
				self._image = pygame.transform.rotate(self.image, 90)
			self._vdirect = 0
		elif (key == pygame.locals.K_DOWN):
			self._yMove += -self._y_dist
			if self._hdirect == 2:
				self._image = pygame.transform.rotate(self.image, 90)
			if self._hdirect == 1:
				self._image = pygame.transform.rotate(self.image, -90)
			self._vdirect = 0

	def update(self, block_group, pellet_group, super_pellet_group, monster_group):
		if (self._xMove==0)and(self._yMove==0):
			lst_monsters = pygame.sprite.spritecollide(self, monster_group, False)
			if (len(lst_monsters)>0):
				self.MonsterCollide(lst_monsters)
			else:
				return
		self.rect.move_ip(self._xMove, self._yMove)
		if pygame.sprite.spritecollideany(self, block_group):
			self.rect.move_ip(-self._xMove, -self._yMove)
		lst_monsters = pygame.sprite.spritecollide(self, monster_group, False)
		if (len(lst_monsters)>0):
			self.MonsterCollide(lst_monsters)
		else:
			lstCols = pygame.sprite.spritecollide(self, pellet_group, True)
			if (len(lstCols)>0):
				self.pellets += len(lstCols)
				#Sound.stop()
				self.OpenAndClose()
				if config.gameSound:
					#pygame.event.post(pygame.event.Event(BITE, {}))
					self._biteSound.play(loops=0, maxtime=0, fade_ms=0)
			elif (len(pygame.sprite.spritecollide(self, super_pellet_group, True))>0):
				self.superState = True
				self.supers += 1
				if config.gameSound:
					#Sound.stop()
					#pygame.event.post(pygame.event.Event(SUPER, {}))
					self._superSound.play(loops=0, maxtime=0, fade_ms=0)
				pygame.event.post(pygame.event.Event(SUPER_STATE_START, {}))
				pygame.time.set_timer(SUPER_STATE_OVER, 0)
				pygame.time.set_timer(SUPER_STATE_OVER, 8000)

	def MonsterCollide(self, lstMonsters):
		if(len(lstMonsters)<=0):
			return
		for monster in lstMonsters:
			if (monster.scared):
				monster.Eaten()
				config.greenHits = config.greenHits+1
				if config.gameSound:
					#pygame.event.post(pygame.event.Event(KILL, {}))
					self._killSound.play(loops=0, maxtime=0, fade_ms=0)
			else:
				self.lives -= 1
				if self.lives >= 1:
					self._rect = self._original_rect
				if config.players == 2:
					if self.lives == 0:
						self._rect = self.rect.move(-800, -800)
				if config.gameSound:
					#self._killSound.stop()
					#pygame.event.post(pygame.event.Event(KILL, {}))
					self._killSound.play(loops=0, maxtime=0, fade_ms=0)
				pygame.event.post(pygame.event.Event(PLAYER_EATEN, {}))
