#!/usr/bin/env python

import random
import logging
import pygame

import config


_moduleLogger = logging.getLogger(__name__)


class Monster(pygame.sprite.Sprite):

	def __init__(self, centerPoint, level):
		pygame.sprite.Sprite.__init__(self)

		self._normal__image = level.sprites[level.MONSTER]
		self._scared__image = level.sprites[level.SCARED_MONSTER]
		if self._scared__image is None:
			self._scared__image = self._normal__image
		self._evil__image = level.sprites[level.EVIL_MONSTER]

		self._image = self._normal__image
		self._rect = self._image.get_rect()
		self._rect.center = centerPoint
		self._original_rect = pygame.Rect(self._rect)
		self._scared = False
		self._direction = random.randint(1, 4)
		if config.boss:
			self._dist = config.player_speed+4
			self._moves = random.randint(10, 60)
		else:
			self._dist = config.enemy_speed
			self._moves = random.randint(60, 120)
		self._moveCount = 0

	@property
	def scared(self):
		return self._scared

	@property
	def image(self):
		# Used by pygame
		return self._image

	@property
	def rect(self):
		# Used by pygame
		return self._rect

	def update(self, block_group):
		xMove, yMove = 0, 0
		if self._direction == 1:
			xMove = -self._dist
		elif self._direction == 2:
			yMove = -self._dist
		elif self._direction == 3:
			xMove = self._dist
		elif self._direction == 4:
			yMove = self._dist

		self._rect.move_ip(xMove, yMove)
		self._moveCount += 1
		if pygame.sprite.spritecollideany(self, block_group):
			self._rect.move_ip(-xMove, -yMove)
			self._direction = random.randint(1, 4)
		elif self._moves == self._moveCount:
			self._direction = random.randint(1, 4)
			self._moves = random.randint(100, 200)
			self._moveCount = 0

	def SetScared(self, scared):
		if self._image is self._evil__image:
			return
		else:
			if self._scared != scared:
				self._scared = scared
				if scared:
					self._image = self._scared__image
				else:
					self._image = self._normal__image

	def Eaten(self):
		self._rect = self._original_rect
		self._scared = False
		self._image = self._evil__image
		config.areMonstersEvil = True
