#!/usr/bin/env python

import sys
from PyQt4 import QtGui,  QtCore
from n900_levels import LevelReader

bar_width = 140
bar_length = 35
signal_bar_y = 430
power_bar_y = 15

quit_x_min = 700
quit_x_max = 765
quit_y_min = 160
quit_y_max = 335

bar_x_1 = 460
bar_x_2 = 310
bar_x_3 = 160
bar_x_4 = 10

class Bar(QtGui.QWidget):
    def __init__(self, parent,  x,  y,  fill_percent=100,  mirror=False):
        QtGui.QWidget.__init__(self, parent)
        self.resize(bar_width, bar_length)
        self.move(x, y)
        
        label_y = 0
        label_length = bar_length * fill_percent / 100
        if (mirror):
            label_y = bar_length - label_length
        
        self.label = QtGui.QLabel(self)
        self.label.resize(bar_width, label_length)
        if label_y>0:
            self.label.move(0, label_y)
        self.label.setStyleSheet("background-color: black")
     

class OldSchoolWidget(QtGui.QWidget):
    power_bar = []
    signal_bar = []
    quit_pressed = QtCore.pyqtSignal()

    def __init__(self,  parent=None):
        QtGui.QWidget.__init__(self, parent)
        palette = QtGui.QPalette()
        palette.setBrush(self.backgroundRole(), QtGui.QBrush(QtGui.QImage("/opt/oldschool/old_school_bg.jpg")));
        self.setPalette(palette)
        
        self.power_bar.append(Bar(self, bar_x_1, power_bar_y, 25))
        self.power_bar.append(Bar(self, bar_x_2, power_bar_y, 50))
        self.power_bar.append(Bar(self, bar_x_3, power_bar_y, 75))
        self.power_bar.append(Bar(self, bar_x_4, power_bar_y, 100))
        
        self.signal_bar.append(Bar(self, bar_x_1, signal_bar_y, 25, True))
        self.signal_bar.append(Bar(self, bar_x_2, signal_bar_y, 50, True))
        self.signal_bar.append(Bar(self, bar_x_3, signal_bar_y, 75,  True))
        self.signal_bar.append(Bar(self, bar_x_4, signal_bar_y, 100, True))

    def mousePressEvent(self, ev):
        click_position = QtCore.QPoint(ev.pos())
        x = click_position.x()
        y = click_position.y()
        if (x>=quit_x_min and x <=quit_x_max and y>=quit_y_min and y<=quit_y_max):
            self.quit_pressed.emit()

    def percent_to_bars(self, percent):
        if percent<=20:
            return 0
        if percent <=40:
            return 1
        if percent <=60:
            return 2
        if percent <=80:
            return 3
        return 4

    def set_signal(self, value):
        for index in range(1, 4):
            bar = self.signal_bar[index]
            if value>index:
                bar.show()
            else:
                bar.hide()

    @QtCore.pyqtSlot(int)
    def set_signal_percent(self,  percentage):
        bar_count = self.percent_to_bars(percentage)
        self.set_signal(bar_count)

    def set_power(self, value):
        for index in range(1, 4):
            bar = self.power_bar[index]
            if value>index:
                bar.show()
            else:
                bar.hide()

    @QtCore.pyqtSlot(int)
    def set_power_percent(self,  percentage):
        bar_count = self.percent_to_bars(percentage)
        self.set_power(bar_count)

def do_normal():
    app = QtGui.QApplication(sys.argv)
    old_school = OldSchoolWidget()
    old_school.showFullScreen()
    QtCore.QObject.connect(old_school, QtCore.SIGNAL('quit_pressed()'),QtGui.qApp, QtCore.SLOT('quit()'))
    level_reader = LevelReader()
    QtCore.QObject.connect(level_reader, QtCore.SIGNAL("battery_change(int)") , old_school,  QtCore.SLOT("set_power_percent(int)"))
    QtCore.QObject.connect(level_reader, QtCore.SIGNAL("signal_change(int)") , old_school,  QtCore.SLOT("set_signal_percent(int)"))
    level_reader.check_battery_change()
    level_reader.check_signal_change()
    sys.exit(app.exec_())
    
def do_test_gui():
    app = QtGui.QApplication(sys.argv)
    old_school = OldSchoolWidget()
    old_school.resize(800, 480)
    old_school.show()
    QtCore.QObject.connect(old_school, QtCore.SIGNAL('quit_pressed()'),QtGui.qApp, QtCore.SLOT('quit()'))
    old_school.set_signal_percent(75)
    old_school.set_power_percent(30)
    sys.exit(app.exec_())

if __name__ == "__main__":
    args = sys.argv
    if len(args)>1:
        if args[1]=="test_gui":
            do_test_gui()
            quit()
    do_normal()

