#!/usr/bin/perl -w

use strict;

sub load_file {
  my $f = shift;

  die ("load_file: File not defined\n")
          unless (defined $f);

  local $/;
  
  open (F, "<$f")
          or die ("load_file: Failed to open $f: $!\n");

  my $content = <F>;

  close (F);

  return $content;
}


sub save_file {
  my $f = shift;
  my $content = shift;

  die ("save_file: File not defined\n")
          unless (defined $f);

  die ("save_file: content not defined\n")
	  unless (defined $content);

  local $/;
  
  open (F, ">$f")
          or die ("save_file: Failed to open $f: $!\n");

  print F $content;

  close (F);

  return $content;
}


sub usage {
  print "This comments or uncomments *.ogg glob in application/ogg\n";
  print "\n";
  print "$0 cmd file\n";
  print "\t cmd: COMMENT or UNCOMMENT\n";
  print "\n";
  exit -1;
}

my $cmd = $ARGV[0];
my $file = $ARGV[1];

if (not defined $cmd) {
  usage();
}

if (not defined $file) {
  usage();
}

my $data = load_file($file);

if ($cmd eq "COMMENT") {
# Add an XML comment around the *.ogg glob
  $data =~ s|^([ ]+)(<glob pattern="\*\.ogg"/>)\n([ ]+)(<glob pattern="\*\.ogx"/>)\n|$1<!--$2-->\n$3$4\n|ms;
}
if ($cmd eq "UNCOMMENT") {
# Remove all XML comments around the *.ogg glob
  $data =~ s|^([ ]+)(?:<!--)+(<glob pattern="\*\.ogg"/>)(?:-->)+\n([ ]+)(<glob pattern="\*\.ogx"/>)\n|$1$2\n$3$4\n|ms;
}

save_file($file, $data);
