/*
 *    Copyright 2004-2006 Intel Corporation
 * 
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

#ifdef HAVE_CONFIG_H
#  include <oasys-config.h>
#endif

#include "util/UnitTest.h"

using namespace oasys;

DECLARE_TEST(ATest) {
    return UNIT_TEST_PASSED;
}

DECLARE_TEST(AnotherTest) {
    return UNIT_TEST_PASSED;
}

DECLARE_TEST(InputTest) {
    log_debug_p("/test", "InputTest: should be foo");
    
    return UNIT_TEST_INPUT;
}

#ifdef DECLARE_TEST_TCL
    proc checkInputTest {output} {
        while {[set line [gets $output]] != ""} {
            if [regexp ".*InputTest: .*foo" $line] {
                return 0
            }
        }
        
        return -1
    }
#endif

DECLARE_TESTER(Test) {
    ADD_TEST(ATest);
    ADD_TEST(AnotherTest);
    ADD_TEST(InputTest);
}

DECLARE_TEST_FILE(Test, "sample test");
