public class VerseSelector: Hildon.PickerDialog
{
    Gtk.ListStore book_store = new Gtk.ListStore(1, typeof(string));
    Gtk.ListStore chapter_store = new Gtk.ListStore(1, typeof(string));
    Gtk.ListStore verse_store = new Gtk.ListStore(1, typeof(string));

    public VerseSelector(Gtk.Window? parent)
    {
        Object(title: "Select");
        set_transient_for(parent);

        var selector = new Hildon.TouchSelector();

        foreach (var book in Books.instance.books)
        {
            Gtk.TreeIter iter;
            book_store.append(out iter);
            book_store.set(iter, 0, book.name());
        }

        selector.append_text_column(book_store, true);
        selector.append_text_column(chapter_store, true);
        selector.append_text_column(verse_store, true);

        selector.changed.connect(on_changed);

        set_selector(selector);
    }


    public void update_language()
    {
        Gtk.TreeIter iter;
        book_store.get_iter_first(out iter);

        foreach (var book in Books.instance.books)
        {
            book_store.set(iter, 0, book.name());

            book_store.iter_next(ref iter);
        }
    }


    bool manual_call = false;
    void on_changed(int column)
    {
        if (manual_call) return;

        manual_call = true;

        var selector = get_selector();
        int act0 = selector.get_active(0);
        int act1 = selector.get_active(1);
        int act2 = selector.get_active(2);

        if (act0 != -1)
        {
            var book = Books.instance.books.nth(act0).data;
            fill_with_numbers(chapter_store, book.chapter_count);
            selector.set_active(1, act1);

            if (act1 != -1)
            {
                if (act1 > book.chapter_count - 1)
                    act1 = book.chapter_count - 1;

                fill_with_numbers(verse_store, book.verse_count[act1]);
                selector.set_active(2, act2);
            }
        }

        manual_call = false;
    }


    void fill_with_numbers(Gtk.ListStore store, int count)
    {
        if (store.length < count)
        {
            Gtk.TreeIter iter;
            for (var i = store.length + 1; i <= count; i++)
            {
                store.append(out iter);
                store.set(iter, 0, i.to_string());
            }
        }
        else if (store.length > count)
        {
            Gtk.TreeIter iter;
            for (var i = store.length - count; i > 0; i--)
            {
                store.get_iter_first(out iter);
                store.remove(iter);
            }

            store.get_iter_first(out iter);
            for (var i = 0; i < store.length; i++)
            {
                store.set(iter, 0, (i+1).to_string());
                store.iter_next(ref iter);
            }
        }
    }



    public Location get_location()
    {
        var selector = get_selector();
        int act0 = selector.get_active(0);
        int act1 = selector.get_active(1);
        int act2 = selector.get_active(2);

        Book book = null;
        if (act0 != -1)
            book = Books.instance.books.nth(act0).data;

        return Location(book, act1+1, act2+1);
    }

    public void set_location(Location location)
    {
        if (location.valid())
        {
            get_selector().set_active(0, Books.instance.books.index(location.book));
            get_selector().set_active(1, location.chapter - 1);
            get_selector().set_active(2, location.verse - 1);
        }
    }
}
