namespace Paths
{
    public string user_dir()
    {
        var dirname = Environment.get_home_dir() + Path.DIR_SEPARATOR_S + ".nwtbible/";
        DirUtils.create(dirname, 0750);
        return dirname;
    }

    public string share_dir()
    {
#if DEBUG
        return "/home/user/NWTBible/";
#else
        return "/usr/share/nwtbible/";
#endif
    }

    public string base_url()
    {
       return "file://" + share_dir();
    }

    public string css()
    {
       return base_url() + "style.css";
    }

    public string js()
    {
       return base_url() + "script.js";
    }
    public string js_basename()
    {
       return "script.js";
    }


    public string langs_ini()
    {
        return share_dir() + "langs.ini";
    }

    public string books_ini()
    {
        return share_dir() + "books.ini";
    }
}
