#include "videodelegatewidget.h"
#include <QFontMetrics>

VideoDelegateWidget::VideoDelegateWidget(const QMap<QString, QString> &video, QWidget *parent) :
    QWidget(parent)
{
    videodata = video;
    thumb = new QLabel(this);
    thumb->setGeometry(QRect(5, 0, 330, 220));
    thumb->setFrameShape(QFrame::StyledPanel);
    thumb->setScaledContents(true);
    thumb->setLineWidth(1);
    thumb->setTextInteractionFlags(Qt::NoTextInteraction);
    thumb->setAlignment(Qt::AlignCenter);
    title = new QLabel(this);
    title->setGeometry(QRect(5, 222, 330, 110));
    title->setStyleSheet("border-radius: 3px; background-color: rgb(255, 255, 255, 255); color: rgb(0, 0, 0, 220); margin-top: 5px; font: 18px");
    title->setAlignment(Qt::AlignLeading|Qt::AlignLeft|Qt::AlignTop);
    title->setWordWrap(true);
    QFontMetrics fm(title->font());
    title->setText(QString("<b>%1</b><br>by <font color=\"green\"><b>%2</b></font><br>%3 | %4 views").arg(fm.elidedText(videodata.value("title"), Qt::ElideRight, 660)).arg(videodata.value("credit")).arg(videodata.value("uploaded")).arg(videodata.value("viewCount")));
    averageRating = new QLabel(this);
    averageRating->setGeometry(QRect(7, 188, 165, 30));
    averageRating->setAlignment(Qt::AlignTop|Qt::AlignLeading|Qt::AlignLeft);
    averageRating->setStyleSheet("background-color: rgb(0, 0, 0, 150); color: rgb(255, 170, 40); font: bold 26px");
    averageRating->setText(videodata.value("average"));
    duration = new QLabel(this);
    duration->setGeometry(QRect(172, 188, 162, 30));
    duration->setAlignment(Qt::AlignRight);
    duration->setStyleSheet("background-color: rgb(0, 0, 0, 150); color: rgb(255, 255, 255, 150); font: 22px");
    duration->setText(QString("%1 %2").arg(videodata.contains("new")?"<font color=\"red\"><b>New</b></font> ":"").arg(videodata.value("duration")));
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    orientationChanged();
}

void VideoDelegateWidget::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() > screenGeometry.height()){
        resize(340, 340);
        thumb->setGeometry(QRect(5, 0, 330, 220));
        title->setGeometry(QRect(5, 222, 330, 110));
        averageRating->setGeometry(QRect(7, 188, 165, 30));
        duration->setGeometry(QRect(172, 188, 162, 30));
    }
    else {
        resize(480, 143);
        thumb->setGeometry(QRect(0, 4, 180, 135));
        title->setGeometry(QRect(184, 0, 295, 138));
        averageRating->setGeometry(QRect(2, 107, 63, 30));
        duration->setGeometry(QRect(65, 107, 113, 30));
    }
}
