#include "logindialog.h"
#include <QMaemo5InformationBox>

LoginDialog::LoginDialog(QWidget *parent) :
   QDialog(parent)
{
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    QLabel *usernameLabel = new QLabel(tr("Account"), this);
    usernameLabel->setStyleSheet("color: rgb(120, 120, 120)");
    QLabel *passwordLabel = new QLabel(tr("Password"), this);
    passwordLabel->setStyleSheet("color: rgb(120, 120, 120)");
    username = new QLineEdit(this);
    password = new QLineEdit(this);
    password->setEchoMode(QLineEdit::PasswordEchoOnEdit);
    saveAcct = new QCheckBox(tr("Remember credential && auto-login"), this);
    saveButtonP = new QPushButton("Login", this);
    connect(saveButtonP, SIGNAL(clicked()), this, SLOT(login()));
    saveButtonL = new QPushButton("Login", this);
    connect(saveButtonL, SIGNAL(clicked()), this, SLOT(login()));
    QGridLayout *mainLayout = new QGridLayout;
    mainLayout->addWidget(usernameLabel, 0, 0);
    mainLayout->addWidget(username, 0, 1);
    mainLayout->addWidget(passwordLabel, 1, 0);
    mainLayout->addWidget(password, 1, 1);
    mainLayout->addWidget(saveAcct, 2, 0, 1, 2);
    mainLayout->addWidget(saveButtonL, 2, 2);
    mainLayout->addWidget(saveButtonP, 3, 1);
    setLayout(mainLayout);
    setWindowTitle("YouTube Login");
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    orientationChanged();
}

LoginDialog::~LoginDialog()
{
}

void LoginDialog::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() > screenGeometry.height()){
        saveButtonP->hide();
        saveButtonL->show();
    }
    else {
        saveButtonP->show();
        saveButtonL->hide();
    }
}

void LoginDialog::login()
{
    if (username->text().isEmpty() || password->text().isEmpty()) {
        QMaemo5InformationBox::information(this, tr("Please enter %1").arg(username->text().isEmpty()?"account name or email address":"password"));
        return;
    }
    else {
        bool autologin = saveAcct->isChecked();
        emit acctData(username->text(), password->text(), autologin);
        QTimer::singleShot(0, this, SLOT(accept()));
    }
}
