#include "optionfilters.h"
#include <QMap>

QStringList OptionFilters::getTimeList()
{
    QString tkey("Today,This week,This month,All time");
    QStringList tkeyList = tkey.split(",");
    return tkeyList;
}

QString OptionFilters::getTimeValue(const QString &name)
{
    QStringList tkeyList = OptionFilters::getTimeList();
    QString tvalue("today,this_week,this_month,all_time");
    QStringList tvalueList = tvalue.split(",");
    QMap<QString, QString> timeLines;
    for (int i = 0; i < tkeyList.size(); ++i){
        timeLines.insert(tkeyList.at(i), tvalueList.at(i));
    }
    return timeLines.value(name);
}

QStringList OptionFilters::getFeedList()
{
    QString stfkey("Top rated,Top favorited,Most viewed,Most discussed,Most responded,Most recent,Most popular,Most shared,Recently featured,Trending videos");
    QStringList stfkeyList = stfkey.split(",");
    return stfkeyList;
}

QString OptionFilters::getFeedValue(const QString &name)
{
    QStringList stfkeyList = OptionFilters::getFeedList();
    QString stfvalue("top_rated,top_favorites,most_viewed,most_discussed,most_responded,most_recent,most_popular,most_shared,recently_featured,on_the_web");
    QStringList stfvalueList = stfvalue.split(",");
    QMap<QString, QString> standardFeeds;
    for (int i = 0; i < stfkeyList.size(); ++i){
        standardFeeds.insert(stfkeyList.at(i), stfvalueList.at(i));
    }
    return standardFeeds.value(name);
}

QStringList OptionFilters::getCategoriesList()
{
    QString ckey("All categories,Autos & Vehicles,Comedy,Education,Entertainment,Gaming,Howto & Style,Music,News & Politics,Nonprofits & Activism,People & Blogs,Pets & Animals,Science & Technology,Sports,Travel & Events");
    QStringList ckeyList = ckey.split(",");
    return ckeyList;
}

QString OptionFilters::getCategoriesValue(const QString &name)
{
    QStringList ckeyList = OptionFilters::getCategoriesList();
    QString cvalue(",_Autos,_Comedy,_Education,_Entertainment,_Games,_Howto,_Music,_News,_Nonprofit,_People,_Animals,_Tech,_Sports,_Travel");
    QStringList cvalueList = cvalue.split(",");
    QMap<QString, QString> categories;
    for (int i = 0; i < ckeyList.size(); ++i){
        categories.insert(ckeyList.at(i), cvalueList.at(i));
    }
    return categories.value(name);
}

QStringList OptionFilters::getRegionIDList()
{
    QString rkey("All,Australia,Brazil,Canada,Czech Republic,France,Germany,Great Britain,Hong Kong,India,Ireland,Israel,Italy,Japan,Mexico,New Zealand,Poland,Russia,South Africa,South Korea,Spain,Sweden,Taiwan,United States");
    QStringList rkeyList = rkey.split(",");
    return rkeyList;
}

QString OptionFilters::getRegionIDValue(const QString &name)
{
    QStringList rkeyList = OptionFilters::getRegionIDList();
    QString rvalue(",AU/,BR/,CA/,CZ/,FR/,DE/,GB/,HK/,IN/,IE/,IL/,IT/,JP/,MX/,NZ/,PL/,RU/,ZA/,KR/,ES/,SE/,TW/,US/");
    QStringList rvalueList = rvalue.split(",");
    QMap<QString, QString> regionID;
    for (int i = 0; i < rkeyList.size(); ++i){
        regionID.insert(rkeyList.at(i), rvalueList.at(i));
    }
    return regionID.value(name);
}
