#ifndef DOWNLOADMANAGER_H
#define DOWNLOADMANAGER_H

#include <QObject>
#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkRequest>
#include <QtNetwork/QNetworkReply>
#include <QFile>
#include <QTime>
#include <QList>

class DownloadManager : public QObject
{
    Q_OBJECT
public:
    explicit DownloadManager(QObject *parent = 0);

signals:
    void finished();
    void videoUrl(const QString&);
    void dlMessage(const QString&);
    void downloadStatus(qint64 bytesReceived, qint64 bytesTotal, const QString &speed);

public slots:
    void setUsePreferredServer(bool b);
    void setDownloadFolder(const QString &downloadPath);
    void append(const QMap<QString, QString> &video);
    void append(const QList< QMap<QString, QString> > &videos);
    void abort();

private slots:
    void getVideoUrl(const QString &videoId);
    void processVideoUrl(QNetworkReply *reply);
    void startNextDownload();
    void downloadRequest(const QString &videoId);
    void startDownload(const QString &dlUrl);
    void onDownloadProgress(qint64,qint64);
    void onReadyRead();
    void downloadFinished();

private:
    int count;
    bool usePreferredServer;
    QString dlPath;
    QNetworkAccessManager nam;
    QNetworkReply *dlReply;
    QFile file;
    QTime dlTimer;
    QList<QNetworkReply*> currentDownload;
    QList< QMap<QString, QString> > downloadQueue;
};

#endif // DOWNLOADMANAGER_H
