#ifndef VIDEOPLAYER_H
#define VIDEOPLAYER_H

#include <QMainWindow>
#include <QTimer>
#include <phonon/videowidget.h>
#include <phonon/audiooutput.h>
#include <phonon/seekslider.h>
#include <phonon/mediaobject.h>
#include <QListWidget>
#include <QListWidgetItem>
#include <QTextEdit>
#include <QSettings>
#include "networkaccess.h"

#define prevButtonIcon "/etc/hildon/theme/mediaplayer/Back.png"
#define playButtonIcon "/etc/hildon/theme/mediaplayer/Play.png"
#define pauseButtonIcon "/etc/hildon/theme/mediaplayer/Pause.png"
#define stopButtonIcon "/etc/hildon/theme/mediaplayer/Stop.png"
#define nextButtonIcon "/etc/hildon/theme/mediaplayer/Forward.png"

QT_BEGIN_NAMESPACE
class QAction;
class QLabel;
class QToolBar;
class QTimer;
class QListWidget;
class QTextEdit;
QT_END_NAMESPACE

class VideoPlayer : public QMainWindow
{
    Q_OBJECT
public:
    explicit VideoPlayer(bool login, QWidget *parent = 0);

protected:
    void mouseReleaseEvent(QMouseEvent*);
    void keyPressEvent(QKeyEvent*);

signals:
    void playerReady();
    void quit();
    void likeThisVideo(const QString&, bool);
    void addToDownloadQueue(const QMap<QString, QString>&);
    void addFavorite(const QString&);
    void subscribeVideo(const QString&);
    void addComment(const QString&, const QString&);


public slots:
    void loadVideo(const QMap<QString, QString>&);
    void loadVideoList(const QString&, const QString&, bool);
    void popupMessage(const QString &message);

private slots:
    void play();
    void itemClicked(QListWidgetItem*);
    void addVideo(const QMap<QString, QString>&);
    void addThumbnail(int, const QPixmap&);
    void gotVideoUrl(const QString &url);
    void stateChanged(Phonon::State newState, Phonon::State oldState);
    void stop();
    void tick(qint64 time);
    void totalTimeChanged(qint64 time);
    void onCurrentSourceChanged(const Phonon::MediaSource&);
    void onPrefinishMarkReached(qint32);
    void onAddToQueue();
    void doNotDisturb(bool b);
    void onScrollBarValueChanged(int value);
    void dataLoaded(bool);
    void onNextAction();
    void onPrevAction();
    void onFavAction();
    void onDownloadAction();
    void onLikeAction();
    void onDislikeAction();
    void toolbarSwitch();
    void onSubscribeAction();
    void onCommentAction(bool);
    void widgetsSwitch();
    void done();

private:
    int currentVidx, start_index;
    QListWidget *listWidget;
    QTextEdit *commentEdit;
    QMap<QString, QString> currentVideo;
    QList< QMap<QString, QString> > videos, playQueue;
    QTimer *timer;
    bool isLogin, isShown, isPlaylist, nextPage, isCommentShown;
    Phonon::MediaObject *mediaObject;
    Phonon::VideoWidget *videoWidget;
    QLabel *timeLcd, *titleLabel, *listWidgetLabel, *videoInfoLabel, *ytLabel;
    qint64 videoDuration;
    QAction *playAction, *stopAction, *pauseAction, *nextAction, *prevAction, *addToQueue, *optionAction;
    QToolBar *bar, *optionBar;
    NetworkAccess *net;
    QSettings settings;
    QStringList recentWVideos;
};

#endif // VIDEOPLAYER_H
