#include "settingdialog.h"
#include "optionfilters.h"
#include <QMaemo5InformationBox>

SettingDialog::SettingDialog(QWidget *parent) :
    QDialog(parent)
{
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    readSettings();
    QMaemo5ValueButton *regionList = new QMaemo5ValueButton("Regional filter", this);
    regionListSelector = new QMaemo5ListPickSelector(this);
    QStandardItemModel *listModel = new QStandardItemModel(0, 1, this);
    QStringList regionIDList = OptionFilters::getRegionIDList();
    int regionIDidx = 0;
    bool cont = true;
    for (int i = 0; i < regionIDList.size(); ++i){
        QStandardItem *item = new QStandardItem(regionIDList.at(i));
        item->setEditable(false);
        listModel->appendRow(item);
        if (cont){
            QString value = OptionFilters::getRegionIDValue(regionIDList.at(i));
            if(value == regionID){
                regionIDidx = i;
                cont = false;
            }
        }
    }
    regionListSelector->setModel(listModel);
    regionListSelector->setCurrentIndex(regionIDidx);
    regionList->setPickSelector(regionListSelector);

    QStringList safeSearchOption;
    safeSearchOption << "none" << "moderate" << "strict";
    QMaemo5ValueButton *safeSearchButton = new QMaemo5ValueButton(tr("SafeSearch filter"), this);
    safeSearchSelector = new QMaemo5ListPickSelector(this);
    QStandardItemModel *safeSearchModel = new QStandardItemModel(0, 1, this);
    for (int i = 0; i < safeSearchOption.size(); ++i){
        QStandardItem *item = new QStandardItem(safeSearchOption.at(i));
        item->setEditable(false);
        safeSearchModel->appendRow(item);
    }
    safeSearchSelector->setModel(safeSearchModel);
    safeSearchSelector->setCurrentIndex(safeSearchOption.indexOf(safeSearch));
    safeSearchButton->setPickSelector(safeSearchSelector);

    thumbnail = new QCheckBox(tr("Use HQ thumbnail"), this);
    thumbnail->setChecked(hqthumb);

    usePrefServer = new QCheckBox(tr("Use preferred server"), this);
    usePrefServer->setChecked(preferServer);

    dlFolder = new QMaemo5ValueButton(tr("Download folder"), this);
    dlFolder->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);
    dlFolder->setValueText(downloadFolder);
    connect(dlFolder, SIGNAL(clicked()), this, SLOT(chooseFolder()));
    QPushButton *clearRecentSearch = new QPushButton(tr("Clear search history"), this);
    connect(clearRecentSearch, SIGNAL(clicked()), this, SLOT(clearSearchHistory()));

    saveButtonP = new QDialogButtonBox(QDialogButtonBox::Save, Qt::Vertical, this);
    connect(saveButtonP, SIGNAL(accepted()), this, SLOT(saveSettings()));
    saveButtonL = new QDialogButtonBox(QDialogButtonBox::Save, Qt::Horizontal, this);
    connect(saveButtonL, SIGNAL(accepted()), this, SLOT(saveSettings()));
    QGridLayout *mainLayout = new QGridLayout;
    mainLayout->setColumnStretch(0,1);
    mainLayout->addWidget(safeSearchButton, 0, 0);
    mainLayout->addWidget(regionList, 0, 1);
    mainLayout->addWidget(thumbnail, 1, 0);
    mainLayout->addWidget(usePrefServer, 1, 1);
    mainLayout->addWidget(dlFolder, 2, 0, 1, 2);
    mainLayout->addWidget(clearRecentSearch, 3, 0, 1, 2);
    mainLayout->addWidget(saveButtonL, 3, 2);
    mainLayout->addWidget(saveButtonP, 4, 1);
    setLayout(mainLayout);
    setWindowTitle("Settings");
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    orientationChanged();
}

SettingDialog::~SettingDialog()
{
}
void SettingDialog::chooseFolder()
{
    QString dir = QFileDialog::getExistingDirectory(this, tr("Open directory"), downloadFolder, QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);
    if(!dir.isEmpty()){
        dlFolder->setValueText(dir);
    }
}

void SettingDialog::clearSearchHistory()
{
    settings.setValue("recentSearch", QStringList());
    QMaemo5InformationBox::information(this, tr("Recent search history has been cleared."));
}

/* Parsing the stored settings */
void SettingDialog::readSettings()
{
    regionID = settings.value("regionID", "").toString();
    safeSearch = settings.value("safeSearch", "none").toString();
    hqthumb = settings.value("hqthumb", true).toBool();
    preferServer = settings.value("preferserver", false).toBool();
    downloadFolder = settings.value("downloadfolder", "/home/user/MyDocs/.videos").toString();
}

/* Save settings and exit */
void SettingDialog::saveSettings()
{
    settings.setValue("regionID", OptionFilters::getRegionIDValue(regionListSelector->currentValueText()));
    settings.setValue("safeSearch", safeSearchSelector->currentValueText());
    settings.setValue("hqthumb", thumbnail->isChecked());
    settings.setValue("preferserver", usePrefServer->isChecked());
    settings.setValue("downloadfolder", dlFolder->valueText());

    /* This will let the QSettings finished writing to file, otherwise it will crash */
    QTimer::singleShot(0, this, SLOT(accept()));
}

void SettingDialog::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() > screenGeometry.height()){
        saveButtonP->hide();
        saveButtonL->show();
    }
    else {
        saveButtonP->show();
        saveButtonL->hide();
    }
}
