#ifndef PLAYLISTDLG_H
#define PLAYLISTDLG_H
#include <QWidget>
#include <QDialog>
#include <QListWidget>

class PlayListDlg : public QDialog
{
    Q_OBJECT
public:
    explicit PlayListDlg(const QString&, QWidget *parent = 0);

signals:
    void playlistID(const QString&, const QString&);
    void newPlaylistInfo(const QString&);

public slots:
    void showPlaylists(const QList< QMap<QString, QString> > &playlists);
private slots:
    void orientationChanged();
    void addNewPlaylist();
    void playlistItemClicked(QListWidgetItem*);
private:
    QListWidget *listWidget;
    QStringList playlistIDlist;
    QPushButton *newPlaylistP, *newPlaylistH;
    QString videoId;

};

#endif // PLAYLISTDLG_H
