#include <QMaemo5InformationBox>
#include "newplaylistdialog.h"

NewPlayListDialog::NewPlayListDialog(const QString &id, QWidget *parent) :
    QDialog(parent)
{
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    title = new QLabel(tr("Title"), this);
    title->setStyleSheet("color: rgb(120, 120, 120)");
    description = new QLabel(tr("Description"), this);
    description->setStyleSheet("color: rgb(120, 120, 120)");
    edlTitle = new QLineEdit(this);
    edlDescription = new QTextEdit(this);
    privateOption = new QCheckBox(tr("Private"), this);
    privateOption->setStyleSheet("color: rgb(120, 120, 120)");
    saveButtonP = new QDialogButtonBox(QDialogButtonBox::Ok);
    connect(saveButtonP, SIGNAL(accepted()), this, SLOT(createNewPlaylist()));
    saveButtonL = new QDialogButtonBox(QDialogButtonBox::Ok);
    connect(saveButtonL, SIGNAL(accepted()), this, SLOT(createNewPlaylist()));
    QGridLayout *mainLayout = new QGridLayout;
    mainLayout->setColumnStretch(1, 1);
    mainLayout->addWidget(title, 0, 0);
    mainLayout->addWidget(edlTitle, 0, 1);
    mainLayout->addWidget(description, 1, 0);
    mainLayout->addWidget(edlDescription, 1, 1);
    mainLayout->addWidget(privateOption, 2, 1);
    mainLayout->addWidget(saveButtonL, 2, 2);
    mainLayout->addWidget(saveButtonP, 3, 1);
    setLayout(mainLayout);
    setWindowTitle("New playlist");
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    orientationChanged();
    videoId = id;
}

void NewPlayListDialog::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() > screenGeometry.height()){
        saveButtonP->hide();
        saveButtonL->show();
    }
    else {
        saveButtonP->show();
        saveButtonL->hide();
    }
}

void NewPlayListDialog::createNewPlaylist()
{
    if(edlTitle->text().isEmpty()){
        QMaemo5InformationBox::information(this, tr("Please enter title"));
    }
    else {
        emit playlistInfo(videoId, edlTitle->text(), edlDescription->toPlainText(), privateOption->isChecked(), false);
        QTimer::singleShot(0, this, SLOT(accept()));
    }
}
