#include "ytxmlparser.h"
#include <QTime>
#include <QLocale>

YtxmlParser::YtxmlParser()
{
}

bool YtxmlParser::readData(const QByteArray &data)
{
    moreResults = false;
    addData(data);
    while (!atEnd()){
        readNext();
        if (isStartElement()){
            if (name() == "feed"){
                while (!atEnd()){
                    readNext();
                    if (isStartElement() && name() == "entry") {
                        readEntry();
                    }
                    else if (name() == "link" && attributes().value("rel").toString() == "next"){
                        moreResults = true;
                    }
                }
            }
        }
    }
    return !error();
}

void YtxmlParser::readEntry()
{
    video.clear();
    while (!atEnd()) {
        readNext();
        if (isEndElement() && name() == "entry"){
            break;
        }
        if (isStartElement()) {

            if (name() == "link" && attributes().value("rel").toString() == "http://gdata.youtube.com/schemas/2007#video.responses"){
                video.insert("reponses", attributes().value("href").toString());
            }
            else if (name() == "link" && attributes().value("rel").toString() == "http://gdata.youtube.com/schemas/2007#video.related"){
                video.insert("related", attributes().value("href").toString());
            }
            else if (name() == "link" && attributes().value("rel").toString() == "edit"){
                video.insert("edit", attributes().value("href").toString());
            }
            else if (namespaceUri() == "http://schemas.google.com/g/2005" && name() == "comments"){
                while (!atEnd()) {
                    readNext();
                    if (isEndElement() && name() == "comments"){
                        break;
                    }
                    if (isStartElement()){
                        if(name() == "feedLink"){
                            video.insert("comments", attributes().value("href").toString());
                            video.insert("countHint", attributes().value("countHint").toString());
                        }
                    }
                }
            }
            else if (namespaceUri() == "http://schemas.google.com/g/2005" && name() == "rating"){
                video.insert("average", formatedRating(attributes().value("average").toString()));
            }
            else if (namespaceUri() == "http://gdata.youtube.com/schemas/2007" && name() == "statistics"){
                video.insert("viewCount", QLocale::system().toString(attributes().value("viewCount").toString().toLongLong()));
            }
            else if (namespaceUri() == "http://gdata.youtube.com/schemas/2007" && name() == "rating"){
                video.insert("numDislikes", QLocale::system().toString(attributes().value("numDislikes").toString().toLongLong()));
                video.insert("numLikes", QLocale::system().toString(attributes().value("numLikes").toString().toLongLong()));
            }
            else if (namespaceUri() == "http://search.yahoo.com/mrss/" && name() == "group") {
                while (!atEnd()) {
                    readNext();
                    if (isEndElement() && name() == "group"){
                        break;
                    }
                    if (isStartElement()) {
                        if (name() == "credit"){
                            video.insert("credit", readElementText());
                        }
                        else if (name() == "description"){
                            video.insert("description", readElementText());
                        }
                        else if (name() == "thumbnail"){
                            video.insert("thumbnail", attributes().value("url").toString());
                        }
                        else if (name() == "title"){
                            video.insert("title", readElementText());
                        }
                        else if (name() == "duration"){
                            video.insert("duration", formatedDuration(attributes().value("seconds").toString()));
                        }
                        else if (name() == "uploaded"){
                            video.insert("uploaded", formatedDate(readElementText()));
                        }
                        else if (name() == "videoid"){
                            video.insert("videoid", readElementText());
                        }
                    }
                }
            }
        }
    }
    videos.append(video);
}

QList< QMap<QString, QString> > YtxmlParser::getVideos()
{
    return videos;
}

QString YtxmlParser::formatedRating(const QString &numString)
{
    QString ratingStars;
    int n = numString.toFloat();
    for (int i = 0; i < n; ++i){
        ratingStars.append("*");
    }
    return ratingStars;
}

QString YtxmlParser:: formatedDuration(const QString &secs)
{
    int seconds = secs.toInt();
    QTime displayTime((seconds / 3600) % 24, (seconds / 60) % 60, seconds % 60);
    if (seconds >= 3600){
        return displayTime.toString("h:mm:ss");
    }
    else {
        return displayTime.toString("mm:ss");
    }
}

QString YtxmlParser::formatedDate(const QString &dateString){
    QDateTime now = QDateTime::currentDateTime();
    QDateTime date = QDateTime::fromString(dateString, Qt::ISODate);
    int numOfDays = now.daysTo(date) * -1;
    if(numOfDays >= 365) {
        int years = numOfDays / 365;
        QString str = QString("%1 %2 ago").arg(years).arg(years > 1? "years":"year");
        return str;
    }
    else if (numOfDays >= 30) {
        int months = numOfDays / 30;
        QString str = QString("%1 %2 ago").arg(months).arg(months > 1? "months":"month");
        return str;
    }
    else if (numOfDays >= 7) {
        int weeks = numOfDays / 7;
        QString str = QString("%1 %2 ago").arg(weeks).arg(weeks > 1? "weeks":"week");
        return str;
    }
    else if (numOfDays >= 1) {
        QString str = QString("%1 %2 ago").arg(numOfDays).arg(numOfDays > 1? "days":"day");
        video.insert("new", "New");
        return str;
    }
    else {
        int numOfHrs = (now.secsTo(date) * -1) / 3600;
        QString str = QString("%1 %2 ago").arg(numOfHrs).arg(numOfHrs > 1? "hours":"hour");
        video.insert("new", "New");
        return str;
    }
}

bool YtxmlParser::readSuggestion(const QByteArray &data)
{
    addData(data);
    while (!atEnd()) {
        readNext();
        if (isStartElement()) {
            if (name() == "suggestion") {
                choices << attributes().value("data").toString();
            }
        }
    }
    return !error();
}

QStringList YtxmlParser::getSuggestion()
{
    return choices;
}

bool YtxmlParser::readPlaylistsData(const QByteArray &data)
{
    addData(data);
    while (!atEnd()){
        readNext();
        if (isStartElement()){
            if (name() == "feed"){
                while (!atEnd()){
                    readNext();
                    if (isStartElement() && name() == "entry") {
                        QMap<QString, QString> playlist;
                        while (!atEnd()) {
                            readNext();
                            if (isEndElement() && name() == "entry"){
                                break;
                            }
                            if (isStartElement()) {
                                if (name() == "link") {
                                    playlist.insert("edit", attributes().value("href").toString());
                                }
                                else if (name() == "title") {
                                    playlist.insert("title", readElementText());
                                }
                                else if (name() == "countHint") {
                                    playlist.insert("countHint", readElementText());
                                }
                                else if (name() == "content") {
                                    playlist.insert("content", attributes().value("src").toString());
                                }
                                else if (name() == "playlistId") {
                                    playlist.insert("playlistId", readElementText());
                                }
                                else if (name() == "username") {
                                    playlist.insert("username", readElementText());
                                }
                            }
                        }
                        playlists.append(playlist);
                    }
                }
            }
        }
    }
    return !error();
}

QList< QMap<QString, QString> > YtxmlParser::getPlaylists()
{
    return playlists;
}
