#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>
#include <QSettings>
#include <QMaemo5InformationBox>
#include <QMaemo5ValueButton>
#include <QScrollBar>
#include <QCompleter>
#include <QTimer>
#include <QStackedWidget>
#include "networkaccess.h"

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

protected:
    bool eventFilter(QObject *obj, QEvent *ev);
    void closeEvent(QCloseEvent *event);

private slots:
    void orientationChanged();
    void onScrollBarValueChanged(int value);
    void setupUi();
    void setupMenus();
    void editSettings();
    void readSettings();
    void getStandardFeed();
    void feedsButtonActivated(QAbstractButton*);
    void channelButtonActivated(QAbstractButton*);
    void getVideoInfo();
    void addVideo(const QMap<QString, QString>&);
    void addPlaylist(const QList< QMap<QString, QString> >&);
    void addSubscription(const QList< QMap<QString, QString> >&);
    void addThumbnail(int, const QPixmap&);
    void dataLoaded(bool);
    void itemClicked(QListWidgetItem*);
    void filterItemClicked(QListWidgetItem*);
    void playlistItemClicked(QListWidgetItem*);
    void subscribedItemClicked(QListWidgetItem*);
    void restoreOrientation();
    void playerReady();
    void closeToolBar();
    void autoSuggest();
    void updateSuggestion(const QStringList&);
    void searchVideo(const QString &searchTerm);
    void getSearchVideo(const QString &searchTerm);
    void login_out();
    void loginResult(bool);
    void processLogin(const QString&, const QString&, bool);
    QString maskIt(const QString&, bool);
    void replyMessage(const QString&);
    void errorMessage(const QString&);

    void widgetSwitch(QAction*);
    void showUploads(const QString&);
    void delUploadVideo();
    void delDownloadedVideo();
    void showFavorites(const QString&);
    void showPlaylist();
    void updatePlaylist(const QString&);
    void showSubscription();
    void updateSubscription(const QString&);
    void showStandardFeed();
    void showChannel();
    void showRecommendation();

    void on_addToPlaylist();
    void on_removeFromPlaylist();
    void createNewPlaylist(const QString &videoid);
    void playListPlay();
    void delPlaylist();
    void on_addToFavorite();
    void on_removeFromFavorite();
    void on_addToQueue();
    void on_subscribe();
    void delSubscription();
    void setActions(const QString&);

    void downloadVideo(const QMap<QString, QString> &video);
    void downloadVideoNow();
    void startDownloadQueue();
    void downloadProgress(qint64, qint64, const QString &speed);
    QStringList scanDownloadFolder();
    void recentWatched();
    void onUserVideos();

private:
    QList< QMap<QString, QString> > queueVideoList;
    QActionGroup *filterGroup;
    QAction *closeToolBarAction, *login_outAction, *browse, *channel, *downloaded, *previousAction, *downloadQueue, *userVideos;
    QAction *addToPlaylist, *removeFromPlaylist, *addToFavorite, *removeFromFavorite, *subscribe, *addToQueue, *delUpload, *delDownloaded, *downloadAction;
    QLineEdit *lineEdit;
    QToolBar *toolBar;
    QCompleter *c;
    QTimer *timer;

    QAbstractButton *previousButton;
    QButtonGroup *buttonGroup, *buttonGroup1;
    bool clearListWidget, nextPage, isBusy, isPortrait, isAuthenicated, autoLogin, hqthumb, rescanDownloaded;
    QListWidget *listWidget, *filterListWidget, *playlistListWidget, *subscribedListWidget;
    QScrollBar *hScrollBar, *vScrollBar;
    QMaemo5ValueButton *timeLineButton, *standardFeedButton, *categoriesButton, *uploadButton, *favoritesButton, *playlistsButton, *subscribedButton;
    QString timeLine, standardFeed, categories, regionID, safeSearch, acct, acctpsswd, ytfields, currentChannelUser, previousChannelUser;
    QStringList recentSearch, buttonListValue, playlistUrls, subscribedUrls, downloadedVideo;
    int start_index;
    QSettings settings;
    QUrl currentUrl;
    NetworkAccess *net;
    QStackedWidget *mainWidget;
    QLabel *ytLabel;
    QProgressDialog *progress;
};

#endif // MAINWINDOW_H
