/* Provide Declarations */
#include <stdarg.h>
#include <setjmp.h>
/* get a declaration for alloca */
#if defined(__CYGWIN__) || defined(__MINGW32__)
#define  alloca(x) __builtin_alloca((x))
#define _alloca(x) __builtin_alloca((x))
#elif defined(__APPLE__)
extern void *__builtin_alloca(unsigned long);
#define alloca(x) __builtin_alloca(x)
#define longjmp _longjmp
#define setjmp _setjmp
#elif defined(__sun__)
#if defined(__sparcv9)
extern void *__builtin_alloca(unsigned long);
#else
extern void *__builtin_alloca(unsigned int);
#endif
#define alloca(x) __builtin_alloca(x)
#elif defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__)
#define alloca(x) __builtin_alloca(x)
#elif defined(_MSC_VER)
#define inline _inline
#define alloca(x) _alloca(x)
#else
#include <alloca.h>
#endif

#ifndef __GNUC__  /* Can only support "linkonce" vars with GCC */
#define __attribute__(X)
#endif

#if defined(__GNUC__) && defined(__APPLE_CC__)
#define __EXTERNAL_WEAK__ __attribute__((weak_import))
#elif defined(__GNUC__)
#define __EXTERNAL_WEAK__ __attribute__((weak))
#else
#define __EXTERNAL_WEAK__
#endif

#if defined(__GNUC__) && defined(__APPLE_CC__)
#define __ATTRIBUTE_WEAK__
#elif defined(__GNUC__)
#define __ATTRIBUTE_WEAK__ __attribute__((weak))
#else
#define __ATTRIBUTE_WEAK__
#endif

#if defined(__GNUC__)
#define __HIDDEN__ __attribute__((visibility("hidden")))
#endif

#ifdef __GNUC__
#define LLVM_NAN(NanStr)   __builtin_nan(NanStr)   /* Double */
#define LLVM_NANF(NanStr)  __builtin_nanf(NanStr)  /* Float */
#define LLVM_NANS(NanStr)  __builtin_nans(NanStr)  /* Double */
#define LLVM_NANSF(NanStr) __builtin_nansf(NanStr) /* Float */
#define LLVM_INF           __builtin_inf()         /* Double */
#define LLVM_INFF          __builtin_inff()        /* Float */
#define LLVM_PREFETCH(addr,rw,locality) __builtin_prefetch(addr,rw,locality)
#define __ATTRIBUTE_CTOR__ __attribute__((constructor))
#define __ATTRIBUTE_DTOR__ __attribute__((destructor))
#define LLVM_ASM           __asm__
#else
#define LLVM_NAN(NanStr)   ((double)0.0)           /* Double */
#define LLVM_NANF(NanStr)  0.0F                    /* Float */
#define LLVM_NANS(NanStr)  ((double)0.0)           /* Double */
#define LLVM_NANSF(NanStr) 0.0F                    /* Float */
#define LLVM_INF           ((double)0.0)           /* Double */
#define LLVM_INFF          0.0F                    /* Float */
#define LLVM_PREFETCH(addr,rw,locality)            /* PREFETCH */
#define __ATTRIBUTE_CTOR__
#define __ATTRIBUTE_DTOR__
#define LLVM_ASM(X)
#endif

#if __GNUC__ < 4 /* Old GCC's, or compilers not GCC */ 
#define __builtin_stack_save() 0   /* not implemented */
#define __builtin_stack_restore(X) /* noop */
#endif

#ifdef __GNUC__ /* 128-bit integer types */
typedef int __attribute__((mode(TI))) llvmInt128;
typedef unsigned __attribute__((mode(TI))) llvmUInt128;
#endif

#define CODE_FOR_MAIN() /* Any target-specific code for main()*/

#ifndef __cplusplus
typedef unsigned char bool;
#endif


/* Support for floating point constants */
typedef unsigned long long ConstantDoubleTy;
typedef unsigned int        ConstantFloatTy;
typedef struct { unsigned long long f1; unsigned short f2; unsigned short pad[3]; } ConstantFP80Ty;
typedef struct { unsigned long long f1; unsigned long long f2; } ConstantFP128Ty;


/* Global Declarations */
/* Helper union for bitcasts */
typedef union {
  unsigned int Int32;
  unsigned long long Int64;
  float Float;
  double Double;
} llvmBitCastUnion;
/* Structure forward decls */
struct l_struct_2E__2E_0Features;
struct l_struct_2E__2E_0__pthread_mutex_s;
struct l_struct_2E__2E_1_2E__185;
struct l_struct_2E__2E_2BMPINFOHEADER;
struct l_struct_2E__2E_3BMPHEADER;
struct l_struct_2E__2E__125;
struct l_struct_2E_AlphaBrush_3C_short_20_unsigned_20_int_2C_1u_3E_;
struct l_struct_2E_Array_3C_DemoEntry_3E_;
struct l_struct_2E_Array_3C_Levels_3A__3A_LevelDesc_2A__3E_;
struct l_struct_2E_Array_3C_Overlay_2A__3E_;
struct l_struct_2E_Array_3C_OverlayBase_3A__3A_HotSpot_3E_;
struct l_struct_2E_Array_3C_Stroke_2A__3E_;
struct l_struct_2E_Array_3C_Vec2_3E_;
struct l_struct_2E_Canvas;
struct l_struct_2E_ClipVertex;
struct l_struct_2E_DIR;
struct l_struct_2E_DemoEntry;
struct l_struct_2E_DemoLog;
struct l_struct_2E_DemoPlayer;
struct l_struct_2E_DemoRecorder;
struct l_struct_2E_Depth;
struct l_struct_2E_Display;
struct l_struct_2E_EditOverlay;
struct l_struct_2E_FILE;
struct l_struct_2E_Font;
struct l_struct_2E_Game;
struct l_struct_2E_GameControl;
struct l_struct_2E_Http;
struct l_struct_2E_IconOverlay;
struct l_struct_2E_Image;
struct l_struct_2E_Levels;
struct l_struct_2E_Levels_3A__3A_LevelDesc;
struct l_struct_2E_MenuOverlay;
struct l_struct_2E_NextLevelOverlay;
struct l_struct_2E_Os;
struct l_struct_2E_OsFreeDesktop;
struct l_struct_2E_OverlayBase;
struct l_struct_2E_OverlayBase_3A__3A_HotSpot;
struct l_struct_2E_Path;
struct l_struct_2E_Rect;
struct l_struct_2E_SDL_ActiveEvent;
struct l_struct_2E_SDL_BlitMap;
struct l_struct_2E_SDL_Event;
struct l_struct_2E_SDL_KeyboardEvent;
struct l_struct_2E_SDL_MouseButtonEvent;
struct l_struct_2E_SDL_Palette;
struct l_struct_2E_SDL_PixelFormat;
struct l_struct_2E_SDL_Rect;
struct l_struct_2E_SDL_Surface;
struct l_struct_2E_SDL_SysWMinfo;
struct l_struct_2E_SDL_SysWMinfo_3A__3A__2E__184;
struct l_struct_2E_SDL_UserEvent;
struct l_struct_2E_SDL_VideoInfo;
struct l_struct_2E_SDL_keysym;
struct l_struct_2E_Scene;
struct l_struct_2E_Screen;
struct l_struct_2E_ScreenFormat;
struct l_struct_2E_Stroke;
struct l_struct_2E_Stroke_3A__3A_BoxDef;
struct l_struct_2E_Stroke_3A__3A_JointDef;
struct l_struct_2E_Transform;
struct l_struct_2E_UiOverlay;
struct l_struct_2E_Vec2;
struct l_struct_2E_Visual;
struct l_struct_2E_XClientMessageEvent;
struct l_struct_2E_XClientMessageEvent_3A__3A__2E__154;
struct l_struct_2E_XEvent;
struct l_struct_2E_XExtData;
struct l_struct_2E_ZipFile;
struct l_struct_2E__IO_marker;
struct l_struct_2E__XGC;
struct l_struct_2E__XPrivate;
struct l_struct_2E__XrmHashBucketRec;
struct l_struct_2E___base_class_type_info_pseudo;
struct l_struct_2E___class_type_info_pseudo;
struct l_struct_2E___gnu_cxx_3A__3A___normal_iterator_3C_char_2A__2C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E_;
struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_;
struct l_struct_2E___mbstate_t_3A__3A__2E__54;
struct l_struct_2E___pointer_type_info_pseudo;
struct l_struct_2E___pthread_list_t;
struct l_struct_2E___si_class_type_info_pseudo;
struct l_struct_2E___type_info_pseudo;
struct l_struct_2E___va_list_tag;
struct l_struct_2E___vmi_class_type_info_pseudo1;
struct l_struct_2E_anon;
struct l_struct_2E_b2AABB;
struct l_struct_2E_b2Block;
struct l_struct_2E_b2BlockAllocator;
struct l_struct_2E_b2Body;
struct l_struct_2E_b2BodyDef;
struct l_struct_2E_b2Bound;
struct l_struct_2E_b2BoundValues;
struct l_struct_2E_b2BroadPhase;
struct l_struct_2E_b2BufferedPair;
struct l_struct_2E_b2Chunk;
struct l_struct_2E_b2CircleContact;
struct l_struct_2E_b2CircleDef;
struct l_struct_2E_b2CircleShape;
struct l_struct_2E_b2Color;
struct l_struct_2E_b2Contact;
struct l_struct_2E_b2ContactConstraint;
struct l_struct_2E_b2ContactConstraintPoint;
struct l_struct_2E_b2ContactEdge;
struct l_struct_2E_b2ContactManager;
struct l_struct_2E_b2ContactPoint;
struct l_struct_2E_b2ContactRegister;
struct l_struct_2E_b2ContactResult;
struct l_struct_2E_b2ContactSolver;
struct l_struct_2E_b2DebugDraw;
struct l_struct_2E_b2DistanceJoint;
struct l_struct_2E_b2DistanceJointDef;
struct l_struct_2E_b2GearJoint;
struct l_struct_2E_b2GearJointDef;
struct l_struct_2E_b2Island;
struct l_struct_2E_b2Jacobian;
struct l_struct_2E_b2Joint;
struct l_struct_2E_b2JointDef;
struct l_struct_2E_b2JointEdge;
struct l_struct_2E_b2Manifold;
struct l_struct_2E_b2ManifoldPoint;
struct l_struct_2E_b2MassData;
struct l_struct_2E_b2MouseJoint;
struct l_struct_2E_b2MouseJointDef;
struct l_struct_2E_b2NullContact;
struct l_struct_2E_b2OBB;
struct l_struct_2E_b2Pair;
struct l_struct_2E_b2PairManager;
struct l_struct_2E_b2PolygonDef;
struct l_struct_2E_b2PolygonShape;
struct l_struct_2E_b2PrismaticJoint;
struct l_struct_2E_b2PrismaticJointDef;
struct l_struct_2E_b2Proxy;
struct l_struct_2E_b2PulleyJoint;
struct l_struct_2E_b2PulleyJointDef;
struct l_struct_2E_b2RevoluteJoint;
struct l_struct_2E_b2RevoluteJointDef;
struct l_struct_2E_b2Shape;
struct l_struct_2E_b2ShapeDef;
struct l_struct_2E_b2StackAllocator;
struct l_struct_2E_b2StackEntry;
struct l_struct_2E_b2Sweep;
struct l_struct_2E_b2TimeStep;
struct l_struct_2E_b2Vec2;
struct l_struct_2E_b2World;
struct l_struct_2E_b2XForm;
struct l_struct_2E_dirent;
struct l_struct_2E_fd_set;
struct l_struct_2E_happyhttp_3A__3A_Connection;
struct l_struct_2E_happyhttp_3A__3A_Response;
struct l_struct_2E_happyhttp_3A__3A_Wobbly;
struct l_struct_2E_hostent;
struct l_struct_2E_mbstate_t;
struct l_struct_2E_private_hwdata;
struct l_struct_2E_pthread_attr_t;
struct l_struct_2E_pthread_mutex_t;
struct l_struct_2E_sockaddr;
struct l_struct_2E_sockaddr_in;
struct l_struct_2E_stat;
struct l_struct_2E_std_3A__3A__Deque_base_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E_;
struct l_struct_2E_std_3A__3A__Deque_base_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E__3A__3A__Deque_impl;
struct l_struct_2E_std_3A__3A__Deque_iterator_3C_happyhttp_3A__3A_Response_2A__2C_happyhttp_3A__3A_Response_2A__26__2C_happyhttp_3A__3A_Response_2A__2A__3E_;
struct l_struct_2E_std_3A__3A__Rb_tree_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A__Select1st_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E_;
struct l_struct_2E_std_3A__3A__Rb_tree_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A__Select1st_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E__3A__3A__Rb_tree_impl_3C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_false_3E_;
struct l_struct_2E_std_3A__3A__Rb_tree_const_iterator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_;
struct l_struct_2E_std_3A__3A__Rb_tree_node_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_;
struct l_struct_2E_std_3A__3A__Rb_tree_node_base;
struct l_struct_2E_std_3A__3A__Vector_base_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_;
struct l_struct_2E_std_3A__3A__Vector_base_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__3A__3A__Vector_impl;
struct l_struct_2E_std_3A__3A___basic_file_3C_char_3E_;
struct l_struct_2E_std_3A__3A___codecvt_abstract_base_3C_char_2C_char_2C___mbstate_t_3E__2E_base;
struct l_struct_2E_std_3A__3A_basic_filebuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_;
struct l_struct_2E_std_3A__3A_basic_ios_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_;
struct l_struct_2E_std_3A__3A_basic_iostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E__2E_base;
struct l_struct_2E_std_3A__3A_basic_istream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E__2E_base;
struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_;
struct l_struct_2E_std_3A__3A_basic_streambuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_;
struct l_struct_2E_std_3A__3A_basic_stringbuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__2C_std_3A__3A_allocator_3C_char_3E__20__3E_;
struct l_struct_2E_std_3A__3A_codecvt_3C_char_2C_char_2C___mbstate_t_3E_;
struct l_struct_2E_std_3A__3A_ctype_3C_char_3E_;
struct l_struct_2E_std_3A__3A_deque_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E_;
struct l_struct_2E_std_3A__3A_ifstream;
struct l_struct_2E_std_3A__3A_ios_base;
struct l_struct_2E_std_3A__3A_ios_base_3A__3A__Callback_list;
struct l_struct_2E_std_3A__3A_ios_base_3A__3A__Words;
struct l_struct_2E_std_3A__3A_istream;
struct l_struct_2E_std_3A__3A_locale;
struct l_struct_2E_std_3A__3A_locale_3A__3A__Impl;
struct l_struct_2E_std_3A__3A_map_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E_;
struct l_struct_2E_std_3A__3A_ofstream;
struct l_struct_2E_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E_;
struct l_struct_2E_std_3A__3A_pair_3C_std_3A__3A__Rb_tree_iterator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_bool_3E_;
struct l_struct_2E_std_3A__3A_string;
struct l_struct_2E_std_3A__3A_stringstream;
struct l_struct_2E_std_3A__3A_type_info;
struct l_struct_2E_std_3A__3A_vector_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_;
struct l_struct_2E_timespec;
struct l_struct_2E_z_stream;
struct l_struct_2E_zip_cd;
struct l_struct_2E_zip_eoc;
struct l_struct_2E_zip_lfh;
struct l_unnamed0;
struct l_unnamed1;
struct l_unnamed2;
struct l_unnamed3;
struct l_unnamed4;
struct l_unnamed5;

/* Typedefs */
typedef struct l_struct_2E__2E_0Features l_struct_2E__2E_0Features;
typedef struct l_struct_2E__2E_0__pthread_mutex_s l_struct_2E__2E_0__pthread_mutex_s;
typedef struct l_struct_2E__2E_1_2E__185 l_struct_2E__2E_1_2E__185;
typedef struct l_struct_2E__2E_2BMPINFOHEADER l_struct_2E__2E_2BMPINFOHEADER;
typedef struct l_struct_2E__2E_3BMPHEADER l_struct_2E__2E_3BMPHEADER;
typedef struct l_struct_2E__2E__125 l_struct_2E__2E__125;
typedef struct l_struct_2E_AlphaBrush_3C_short_20_unsigned_20_int_2C_1u_3E_ l_struct_2E_AlphaBrush_3C_short_20_unsigned_20_int_2C_1u_3E_;
typedef struct l_struct_2E_Array_3C_DemoEntry_3E_ l_struct_2E_Array_3C_DemoEntry_3E_;
typedef struct l_struct_2E_Array_3C_Levels_3A__3A_LevelDesc_2A__3E_ l_struct_2E_Array_3C_Levels_3A__3A_LevelDesc_2A__3E_;
typedef struct l_struct_2E_Array_3C_Overlay_2A__3E_ l_struct_2E_Array_3C_Overlay_2A__3E_;
typedef struct l_struct_2E_Array_3C_OverlayBase_3A__3A_HotSpot_3E_ l_struct_2E_Array_3C_OverlayBase_3A__3A_HotSpot_3E_;
typedef struct l_struct_2E_Array_3C_Stroke_2A__3E_ l_struct_2E_Array_3C_Stroke_2A__3E_;
typedef struct l_struct_2E_Array_3C_Vec2_3E_ l_struct_2E_Array_3C_Vec2_3E_;
typedef struct l_struct_2E_Canvas l_struct_2E_Canvas;
typedef struct l_struct_2E_ClipVertex l_struct_2E_ClipVertex;
typedef struct l_struct_2E_DIR l_struct_2E_DIR;
typedef struct l_struct_2E_DemoEntry l_struct_2E_DemoEntry;
typedef struct l_struct_2E_DemoLog l_struct_2E_DemoLog;
typedef struct l_struct_2E_DemoPlayer l_struct_2E_DemoPlayer;
typedef struct l_struct_2E_DemoRecorder l_struct_2E_DemoRecorder;
typedef struct l_struct_2E_Depth l_struct_2E_Depth;
typedef struct l_struct_2E_Display l_struct_2E_Display;
typedef struct l_struct_2E_EditOverlay l_struct_2E_EditOverlay;
typedef struct l_struct_2E_FILE l_struct_2E_FILE;
typedef struct l_struct_2E_Font l_struct_2E_Font;
typedef struct l_struct_2E_Game l_struct_2E_Game;
typedef struct l_struct_2E_GameControl l_struct_2E_GameControl;
typedef struct l_struct_2E_Http l_struct_2E_Http;
typedef struct l_struct_2E_IconOverlay l_struct_2E_IconOverlay;
typedef struct l_struct_2E_Image l_struct_2E_Image;
typedef struct l_struct_2E_Levels l_struct_2E_Levels;
typedef struct l_struct_2E_Levels_3A__3A_LevelDesc l_struct_2E_Levels_3A__3A_LevelDesc;
typedef struct l_struct_2E_MenuOverlay l_struct_2E_MenuOverlay;
typedef struct l_struct_2E_NextLevelOverlay l_struct_2E_NextLevelOverlay;
typedef struct l_struct_2E_Os l_struct_2E_Os;
typedef struct l_struct_2E_OsFreeDesktop l_struct_2E_OsFreeDesktop;
typedef struct l_struct_2E_OverlayBase l_struct_2E_OverlayBase;
typedef struct l_struct_2E_OverlayBase_3A__3A_HotSpot l_struct_2E_OverlayBase_3A__3A_HotSpot;
typedef struct l_struct_2E_Path l_struct_2E_Path;
typedef struct l_struct_2E_Rect l_struct_2E_Rect;
typedef struct l_struct_2E_SDL_ActiveEvent l_struct_2E_SDL_ActiveEvent;
typedef struct l_struct_2E_SDL_BlitMap l_struct_2E_SDL_BlitMap;
typedef struct l_struct_2E_SDL_Event l_struct_2E_SDL_Event;
typedef struct l_struct_2E_SDL_KeyboardEvent l_struct_2E_SDL_KeyboardEvent;
typedef struct l_struct_2E_SDL_MouseButtonEvent l_struct_2E_SDL_MouseButtonEvent;
typedef struct l_struct_2E_SDL_Palette l_struct_2E_SDL_Palette;
typedef struct l_struct_2E_SDL_PixelFormat l_struct_2E_SDL_PixelFormat;
typedef struct l_struct_2E_SDL_Rect l_struct_2E_SDL_Rect;
typedef struct l_struct_2E_SDL_Surface l_struct_2E_SDL_Surface;
typedef struct l_struct_2E_SDL_SysWMinfo l_struct_2E_SDL_SysWMinfo;
typedef struct l_struct_2E_SDL_SysWMinfo_3A__3A__2E__184 l_struct_2E_SDL_SysWMinfo_3A__3A__2E__184;
typedef struct l_struct_2E_SDL_UserEvent l_struct_2E_SDL_UserEvent;
typedef struct l_struct_2E_SDL_VideoInfo l_struct_2E_SDL_VideoInfo;
typedef struct l_struct_2E_SDL_keysym l_struct_2E_SDL_keysym;
typedef struct l_struct_2E_Scene l_struct_2E_Scene;
typedef struct l_struct_2E_Screen l_struct_2E_Screen;
typedef struct l_struct_2E_ScreenFormat l_struct_2E_ScreenFormat;
typedef struct l_struct_2E_Stroke l_struct_2E_Stroke;
typedef struct l_struct_2E_Stroke_3A__3A_BoxDef l_struct_2E_Stroke_3A__3A_BoxDef;
typedef struct l_struct_2E_Stroke_3A__3A_JointDef l_struct_2E_Stroke_3A__3A_JointDef;
typedef struct l_struct_2E_Transform l_struct_2E_Transform;
typedef struct l_struct_2E_UiOverlay l_struct_2E_UiOverlay;
typedef struct l_struct_2E_Vec2 l_struct_2E_Vec2;
typedef struct l_struct_2E_Visual l_struct_2E_Visual;
typedef struct l_struct_2E_XClientMessageEvent l_struct_2E_XClientMessageEvent;
typedef struct l_struct_2E_XClientMessageEvent_3A__3A__2E__154 l_struct_2E_XClientMessageEvent_3A__3A__2E__154;
typedef struct l_struct_2E_XEvent l_struct_2E_XEvent;
typedef struct l_struct_2E_XExtData l_struct_2E_XExtData;
typedef struct l_struct_2E_ZipFile l_struct_2E_ZipFile;
typedef struct l_struct_2E__IO_marker l_struct_2E__IO_marker;
typedef struct l_struct_2E__XGC l_struct_2E__XGC;
typedef struct l_struct_2E__XPrivate l_struct_2E__XPrivate;
typedef struct l_struct_2E__XrmHashBucketRec l_struct_2E__XrmHashBucketRec;
typedef struct l_struct_2E___base_class_type_info_pseudo l_struct_2E___base_class_type_info_pseudo;
typedef struct l_struct_2E___class_type_info_pseudo l_struct_2E___class_type_info_pseudo;
typedef struct l_struct_2E___gnu_cxx_3A__3A___normal_iterator_3C_char_2A__2C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E_ l_struct_2E___gnu_cxx_3A__3A___normal_iterator_3C_char_2A__2C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E_;
typedef struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_;
typedef struct l_struct_2E___mbstate_t_3A__3A__2E__54 l_struct_2E___mbstate_t_3A__3A__2E__54;
typedef struct l_struct_2E___pointer_type_info_pseudo l_struct_2E___pointer_type_info_pseudo;
typedef struct l_struct_2E___pthread_list_t l_struct_2E___pthread_list_t;
typedef struct l_struct_2E___si_class_type_info_pseudo l_struct_2E___si_class_type_info_pseudo;
typedef struct l_struct_2E___type_info_pseudo l_struct_2E___type_info_pseudo;
typedef struct l_struct_2E___va_list_tag l_struct_2E___va_list_tag;
typedef struct l_struct_2E___vmi_class_type_info_pseudo1 l_struct_2E___vmi_class_type_info_pseudo1;
typedef struct l_struct_2E_anon l_struct_2E_anon;
typedef struct l_struct_2E_b2AABB l_struct_2E_b2AABB;
typedef struct l_struct_2E_b2Block l_struct_2E_b2Block;
typedef struct l_struct_2E_b2BlockAllocator l_struct_2E_b2BlockAllocator;
typedef struct l_struct_2E_b2Body l_struct_2E_b2Body;
typedef struct l_struct_2E_b2BodyDef l_struct_2E_b2BodyDef;
typedef struct l_struct_2E_b2Bound l_struct_2E_b2Bound;
typedef struct l_struct_2E_b2BoundValues l_struct_2E_b2BoundValues;
typedef struct l_struct_2E_b2BroadPhase l_struct_2E_b2BroadPhase;
typedef struct l_struct_2E_b2BufferedPair l_struct_2E_b2BufferedPair;
typedef struct l_struct_2E_b2Chunk l_struct_2E_b2Chunk;
typedef struct l_struct_2E_b2CircleContact l_struct_2E_b2CircleContact;
typedef struct l_struct_2E_b2CircleDef l_struct_2E_b2CircleDef;
typedef struct l_struct_2E_b2CircleShape l_struct_2E_b2CircleShape;
typedef struct l_struct_2E_b2Color l_struct_2E_b2Color;
typedef struct l_struct_2E_b2Contact l_struct_2E_b2Contact;
typedef struct l_struct_2E_b2ContactConstraint l_struct_2E_b2ContactConstraint;
typedef struct l_struct_2E_b2ContactConstraintPoint l_struct_2E_b2ContactConstraintPoint;
typedef struct l_struct_2E_b2ContactEdge l_struct_2E_b2ContactEdge;
typedef struct l_struct_2E_b2ContactManager l_struct_2E_b2ContactManager;
typedef struct l_struct_2E_b2ContactPoint l_struct_2E_b2ContactPoint;
typedef struct l_struct_2E_b2ContactRegister l_struct_2E_b2ContactRegister;
typedef struct l_struct_2E_b2ContactResult l_struct_2E_b2ContactResult;
typedef struct l_struct_2E_b2ContactSolver l_struct_2E_b2ContactSolver;
typedef struct l_struct_2E_b2DebugDraw l_struct_2E_b2DebugDraw;
typedef struct l_struct_2E_b2DistanceJoint l_struct_2E_b2DistanceJoint;
typedef struct l_struct_2E_b2DistanceJointDef l_struct_2E_b2DistanceJointDef;
typedef struct l_struct_2E_b2GearJoint l_struct_2E_b2GearJoint;
typedef struct l_struct_2E_b2GearJointDef l_struct_2E_b2GearJointDef;
typedef struct l_struct_2E_b2Island l_struct_2E_b2Island;
typedef struct l_struct_2E_b2Jacobian l_struct_2E_b2Jacobian;
typedef struct l_struct_2E_b2Joint l_struct_2E_b2Joint;
typedef struct l_struct_2E_b2JointDef l_struct_2E_b2JointDef;
typedef struct l_struct_2E_b2JointEdge l_struct_2E_b2JointEdge;
typedef struct l_struct_2E_b2Manifold l_struct_2E_b2Manifold;
typedef struct l_struct_2E_b2ManifoldPoint l_struct_2E_b2ManifoldPoint;
typedef struct l_struct_2E_b2MassData l_struct_2E_b2MassData;
typedef struct l_struct_2E_b2MouseJoint l_struct_2E_b2MouseJoint;
typedef struct l_struct_2E_b2MouseJointDef l_struct_2E_b2MouseJointDef;
typedef struct l_struct_2E_b2NullContact l_struct_2E_b2NullContact;
typedef struct l_struct_2E_b2OBB l_struct_2E_b2OBB;
typedef struct l_struct_2E_b2Pair l_struct_2E_b2Pair;
typedef struct l_struct_2E_b2PairManager l_struct_2E_b2PairManager;
typedef struct l_struct_2E_b2PolygonDef l_struct_2E_b2PolygonDef;
typedef struct l_struct_2E_b2PolygonShape l_struct_2E_b2PolygonShape;
typedef struct l_struct_2E_b2PrismaticJoint l_struct_2E_b2PrismaticJoint;
typedef struct l_struct_2E_b2PrismaticJointDef l_struct_2E_b2PrismaticJointDef;
typedef struct l_struct_2E_b2Proxy l_struct_2E_b2Proxy;
typedef struct l_struct_2E_b2PulleyJoint l_struct_2E_b2PulleyJoint;
typedef struct l_struct_2E_b2PulleyJointDef l_struct_2E_b2PulleyJointDef;
typedef struct l_struct_2E_b2RevoluteJoint l_struct_2E_b2RevoluteJoint;
typedef struct l_struct_2E_b2RevoluteJointDef l_struct_2E_b2RevoluteJointDef;
typedef struct l_struct_2E_b2Shape l_struct_2E_b2Shape;
typedef struct l_struct_2E_b2ShapeDef l_struct_2E_b2ShapeDef;
typedef struct l_struct_2E_b2StackAllocator l_struct_2E_b2StackAllocator;
typedef struct l_struct_2E_b2StackEntry l_struct_2E_b2StackEntry;
typedef struct l_struct_2E_b2Sweep l_struct_2E_b2Sweep;
typedef struct l_struct_2E_b2TimeStep l_struct_2E_b2TimeStep;
typedef struct l_struct_2E_b2Vec2 l_struct_2E_b2Vec2;
typedef struct l_struct_2E_b2World l_struct_2E_b2World;
typedef struct l_struct_2E_b2XForm l_struct_2E_b2XForm;
typedef struct l_struct_2E_dirent l_struct_2E_dirent;
typedef struct l_struct_2E_fd_set l_struct_2E_fd_set;
typedef struct l_struct_2E_happyhttp_3A__3A_Connection l_struct_2E_happyhttp_3A__3A_Connection;
typedef struct l_struct_2E_happyhttp_3A__3A_Response l_struct_2E_happyhttp_3A__3A_Response;
typedef struct l_struct_2E_happyhttp_3A__3A_Wobbly l_struct_2E_happyhttp_3A__3A_Wobbly;
typedef struct l_struct_2E_hostent l_struct_2E_hostent;
typedef struct l_struct_2E_mbstate_t l_struct_2E_mbstate_t;
typedef struct l_struct_2E_private_hwdata l_struct_2E_private_hwdata;
typedef struct l_struct_2E_pthread_attr_t l_struct_2E_pthread_attr_t;
typedef struct l_struct_2E_pthread_mutex_t l_struct_2E_pthread_mutex_t;
typedef struct l_struct_2E_sockaddr l_struct_2E_sockaddr;
typedef struct l_struct_2E_sockaddr_in l_struct_2E_sockaddr_in;
typedef struct l_struct_2E_stat l_struct_2E_stat;
typedef struct l_struct_2E_std_3A__3A__Deque_base_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E_ l_struct_2E_std_3A__3A__Deque_base_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E_;
typedef struct l_struct_2E_std_3A__3A__Deque_base_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E__3A__3A__Deque_impl l_struct_2E_std_3A__3A__Deque_base_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E__3A__3A__Deque_impl;
typedef struct l_struct_2E_std_3A__3A__Deque_iterator_3C_happyhttp_3A__3A_Response_2A__2C_happyhttp_3A__3A_Response_2A__26__2C_happyhttp_3A__3A_Response_2A__2A__3E_ l_struct_2E_std_3A__3A__Deque_iterator_3C_happyhttp_3A__3A_Response_2A__2C_happyhttp_3A__3A_Response_2A__26__2C_happyhttp_3A__3A_Response_2A__2A__3E_;
typedef struct l_struct_2E_std_3A__3A__Rb_tree_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A__Select1st_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E_ l_struct_2E_std_3A__3A__Rb_tree_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A__Select1st_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E_;
typedef struct l_struct_2E_std_3A__3A__Rb_tree_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A__Select1st_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E__3A__3A__Rb_tree_impl_3C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_false_3E_ l_struct_2E_std_3A__3A__Rb_tree_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A__Select1st_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E__3A__3A__Rb_tree_impl_3C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_false_3E_;
typedef struct l_struct_2E_std_3A__3A__Rb_tree_const_iterator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_ l_struct_2E_std_3A__3A__Rb_tree_const_iterator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_;
typedef struct l_struct_2E_std_3A__3A__Rb_tree_node_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_ l_struct_2E_std_3A__3A__Rb_tree_node_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_;
typedef struct l_struct_2E_std_3A__3A__Rb_tree_node_base l_struct_2E_std_3A__3A__Rb_tree_node_base;
typedef struct l_struct_2E_std_3A__3A__Vector_base_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_ l_struct_2E_std_3A__3A__Vector_base_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_;
typedef struct l_struct_2E_std_3A__3A__Vector_base_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__3A__3A__Vector_impl l_struct_2E_std_3A__3A__Vector_base_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__3A__3A__Vector_impl;
typedef struct l_struct_2E_std_3A__3A___basic_file_3C_char_3E_ l_struct_2E_std_3A__3A___basic_file_3C_char_3E_;
typedef struct l_struct_2E_std_3A__3A___codecvt_abstract_base_3C_char_2C_char_2C___mbstate_t_3E__2E_base l_struct_2E_std_3A__3A___codecvt_abstract_base_3C_char_2C_char_2C___mbstate_t_3E__2E_base;
typedef struct l_struct_2E_std_3A__3A_basic_filebuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ l_struct_2E_std_3A__3A_basic_filebuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_;
typedef struct l_struct_2E_std_3A__3A_basic_ios_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ l_struct_2E_std_3A__3A_basic_ios_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_;
typedef struct l_struct_2E_std_3A__3A_basic_iostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E__2E_base l_struct_2E_std_3A__3A_basic_iostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E__2E_base;
typedef struct l_struct_2E_std_3A__3A_basic_istream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E__2E_base l_struct_2E_std_3A__3A_basic_istream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E__2E_base;
typedef struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_;
typedef struct l_struct_2E_std_3A__3A_basic_streambuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ l_struct_2E_std_3A__3A_basic_streambuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_;
typedef struct l_struct_2E_std_3A__3A_basic_stringbuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__2C_std_3A__3A_allocator_3C_char_3E__20__3E_ l_struct_2E_std_3A__3A_basic_stringbuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__2C_std_3A__3A_allocator_3C_char_3E__20__3E_;
typedef struct l_struct_2E_std_3A__3A_codecvt_3C_char_2C_char_2C___mbstate_t_3E_ l_struct_2E_std_3A__3A_codecvt_3C_char_2C_char_2C___mbstate_t_3E_;
typedef struct l_struct_2E_std_3A__3A_ctype_3C_char_3E_ l_struct_2E_std_3A__3A_ctype_3C_char_3E_;
typedef struct l_struct_2E_std_3A__3A_deque_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E_ l_struct_2E_std_3A__3A_deque_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E_;
typedef struct l_struct_2E_std_3A__3A_ifstream l_struct_2E_std_3A__3A_ifstream;
typedef struct l_struct_2E_std_3A__3A_ios_base l_struct_2E_std_3A__3A_ios_base;
typedef struct l_struct_2E_std_3A__3A_ios_base_3A__3A__Callback_list l_struct_2E_std_3A__3A_ios_base_3A__3A__Callback_list;
typedef struct l_struct_2E_std_3A__3A_ios_base_3A__3A__Words l_struct_2E_std_3A__3A_ios_base_3A__3A__Words;
typedef struct l_struct_2E_std_3A__3A_istream l_struct_2E_std_3A__3A_istream;
typedef struct l_struct_2E_std_3A__3A_locale l_struct_2E_std_3A__3A_locale;
typedef struct l_struct_2E_std_3A__3A_locale_3A__3A__Impl l_struct_2E_std_3A__3A_locale_3A__3A__Impl;
typedef struct l_struct_2E_std_3A__3A_map_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E_ l_struct_2E_std_3A__3A_map_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E_;
typedef struct l_struct_2E_std_3A__3A_ofstream l_struct_2E_std_3A__3A_ofstream;
typedef struct l_struct_2E_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E_ l_struct_2E_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E_;
typedef struct l_struct_2E_std_3A__3A_pair_3C_std_3A__3A__Rb_tree_iterator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_bool_3E_ l_struct_2E_std_3A__3A_pair_3C_std_3A__3A__Rb_tree_iterator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_bool_3E_;
typedef struct l_struct_2E_std_3A__3A_string l_struct_2E_std_3A__3A_string;
typedef struct l_struct_2E_std_3A__3A_stringstream l_struct_2E_std_3A__3A_stringstream;
typedef struct l_struct_2E_std_3A__3A_type_info l_struct_2E_std_3A__3A_type_info;
typedef struct l_struct_2E_std_3A__3A_vector_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_ l_struct_2E_std_3A__3A_vector_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_;
typedef struct l_struct_2E_timespec l_struct_2E_timespec;
typedef struct l_struct_2E_z_stream l_struct_2E_z_stream;
typedef struct l_struct_2E_zip_cd l_struct_2E_zip_cd;
typedef struct l_struct_2E_zip_eoc l_struct_2E_zip_eoc;
typedef struct l_struct_2E_zip_lfh l_struct_2E_zip_lfh;
typedef struct l_unnamed0 l_unnamed0;
typedef struct l_unnamed1 l_unnamed1;
typedef struct l_unnamed2 l_unnamed2;
typedef struct l_unnamed3 l_unnamed3;
typedef struct l_unnamed4 l_unnamed4;
typedef struct l_unnamed5 l_unnamed5;

/* Structure contents */
struct l_struct_2E__2E_0Features {
  unsigned char field0;
  unsigned char field1;
  unsigned char field2;
  unsigned char field3;
};

struct l_struct_2E___pthread_list_t {
  struct l_struct_2E___pthread_list_t *field0;
  struct l_struct_2E___pthread_list_t *field1;
};

struct l_struct_2E__2E_0__pthread_mutex_s {
  unsigned int field0;
  unsigned int field1;
  unsigned int field2;
  unsigned int field3;
  unsigned int field4;
  unsigned int field5;
  struct l_struct_2E___pthread_list_t field6;
};

struct l_struct_2E__2E_1_2E__185 {
  struct l_struct_2E_Display *field0;
  unsigned long long field1;
  void  (*field2) (void);
  void  (*field3) (void);
  unsigned long long field4;
  unsigned long long field5;
  struct l_struct_2E_Display *field6;
};

struct l_struct_2E__2E_2BMPINFOHEADER {
  unsigned int field0;
  unsigned int field1;
  unsigned int field2;
  unsigned short field3;
  unsigned short field4;
  unsigned int field5;
  unsigned int field6;
  unsigned int field7;
  unsigned int field8;
  unsigned int field9;
  unsigned int field10;
};

struct l_struct_2E__2E_3BMPHEADER {
  unsigned short field0;
  unsigned int field1;
  unsigned short field2;
  unsigned short field3;
  unsigned int field4;
};

struct l_struct_2E__2E__125 {
  struct l_struct_2E_XExtData *field0;
  struct l_struct_2E__XPrivate *field1;
  unsigned int field2;
  unsigned int field3;
  unsigned int field4;
  unsigned int field5;
  unsigned char *field6;
  unsigned long long field7;
  unsigned long long field8;
  unsigned long long field9;
  unsigned int field10;
  unsigned long long  (*field11) (struct l_struct_2E_Display *);
  unsigned int field12;
  unsigned int field13;
  unsigned int field14;
  unsigned int field15;
  unsigned int field16;
  struct l_struct_2E_ScreenFormat *field17;
  unsigned int field18;
  unsigned int field19;
  struct l_struct_2E__XPrivate *field20;
  struct l_struct_2E__XPrivate *field21;
  unsigned int field22;
  unsigned long long field23;
  unsigned long long field24;
  unsigned char *field25;
  unsigned char *field26;
  unsigned char *field27;
  unsigned char *field28;
  unsigned int field29;
  struct l_struct_2E__XrmHashBucketRec *field30;
  unsigned int  (*field31) (struct l_struct_2E_Display *);
  unsigned char *field32;
  unsigned int field33;
  unsigned int field34;
  struct l_struct_2E_Screen *field35;
  unsigned long long field36;
  unsigned long long field37;
  unsigned int field38;
  unsigned int field39;
  unsigned char *field40;
  unsigned char *field41;
  unsigned int field42;
  unsigned char *field43;
};

struct l_struct_2E_AlphaBrush_3C_short_20_unsigned_20_int_2C_1u_3E_ {
  unsigned int field0;
  unsigned int field1;
  unsigned int field2;
  unsigned int field3;
};

struct l_struct_2E_Array_3C_DemoEntry_3E_ {
  struct l_struct_2E_DemoEntry *field0;
  unsigned int field1;
  unsigned int field2;
};

struct l_struct_2E_Array_3C_Levels_3A__3A_LevelDesc_2A__3E_ {
  struct l_struct_2E_Levels_3A__3A_LevelDesc **field0;
  unsigned int field1;
  unsigned int field2;
};

struct l_struct_2E_Array_3C_Overlay_2A__3E_ {
  struct l_struct_2E_Os **field0;
  unsigned int field1;
  unsigned int field2;
};

struct l_struct_2E_Array_3C_OverlayBase_3A__3A_HotSpot_3E_ {
  struct l_struct_2E_OverlayBase_3A__3A_HotSpot *field0;
  unsigned int field1;
  unsigned int field2;
};

struct l_struct_2E_Array_3C_Stroke_2A__3E_ {
  struct l_struct_2E_Stroke **field0;
  unsigned int field1;
  unsigned int field2;
};

struct l_struct_2E_Array_3C_Vec2_3E_ {
  struct l_struct_2E_Vec2 *field0;
  unsigned int field1;
  unsigned int field2;
};

struct l_struct_2E_Vec2 {
  unsigned int field0;
  unsigned int field1;
};

struct l_struct_2E_Rect {
  struct l_struct_2E_Vec2 field0;
  struct l_struct_2E_Vec2 field1;
};

struct l_struct_2E_Canvas {
  unsigned int  (**field0) ();
  unsigned char *field1;
  unsigned int field2;
  struct l_struct_2E_Canvas *field3;
  struct l_struct_2E_Rect field4;
};

struct l_struct_2E_b2Vec2 {
  float field0;
  float field1;
};

struct l_struct_2E___mbstate_t_3A__3A__2E__54 {
  unsigned int field0;
};

struct l_struct_2E_ClipVertex {
  struct l_struct_2E_b2Vec2 field0;
  struct l_struct_2E___mbstate_t_3A__3A__2E__54 field1;
};

struct l_struct_2E_SDL_UserEvent {
  unsigned char field0;
  unsigned int field1;
  unsigned char *field2;
  unsigned char *field3;
};

struct l_struct_2E_SDL_Event {
  struct l_struct_2E_SDL_UserEvent field0;
};

struct l_struct_2E_DemoEntry {
  unsigned int field0;
  unsigned int field1;
  struct l_struct_2E_SDL_Event field2;
};

struct l_struct_2E_DemoLog {
  struct l_struct_2E_Array_3C_DemoEntry_3E_ field0;
};

struct l_struct_2E_DemoPlayer {
  unsigned char field0;
  struct l_struct_2E_DemoLog *field1;
  unsigned int field2;
  unsigned int field3;
  unsigned int field4;
};

struct l_struct_2E_DemoRecorder {
  unsigned char field0;
  struct l_struct_2E_DemoLog field1;
  unsigned int field2;
  unsigned int field3;
};

struct l_struct_2E_Depth {
  unsigned int field0;
  unsigned int field1;
  struct l_struct_2E_Visual *field2;
};

struct l_struct_2E_Os {
  unsigned int  (**field0) ();
};

struct l_struct_2E_OverlayBase {
  struct l_struct_2E_Os field0;
  struct l_struct_2E_GameControl *field1;
  unsigned int field2;
  unsigned int field3;
  struct l_struct_2E_Canvas *field4;
  unsigned int field5;
  unsigned int field6;
  unsigned int field7;
  unsigned int field8;
  unsigned char field9;
  unsigned char field10;
  unsigned char field11;
  unsigned char field12;
  struct l_struct_2E_Array_3C_OverlayBase_3A__3A_HotSpot_3E_ field13;
};

struct l_struct_2E___gnu_cxx_3A__3A___normal_iterator_3C_char_2A__2C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E_ {
  unsigned char *field0;
};

struct l_struct_2E_std_3A__3A_string {
  struct l_struct_2E___gnu_cxx_3A__3A___normal_iterator_3C_char_2A__2C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E_ field0;
};

struct l_struct_2E_IconOverlay {
  struct l_struct_2E_OverlayBase field0;
  struct l_struct_2E_std_3A__3A_string field1;
};

struct l_struct_2E_EditOverlay {
  struct l_struct_2E_IconOverlay field0;
  unsigned int field1;
  unsigned int field2;
};

struct l_struct_2E_FILE {
  unsigned int field0;
  unsigned char *field1;
  unsigned char *field2;
  unsigned char *field3;
  unsigned char *field4;
  unsigned char *field5;
  unsigned char *field6;
  unsigned char *field7;
  unsigned char *field8;
  unsigned char *field9;
  unsigned char *field10;
  unsigned char *field11;
  struct l_struct_2E__IO_marker *field12;
  struct l_struct_2E_FILE *field13;
  unsigned int field14;
  unsigned int field15;
  unsigned long long field16;
  unsigned short field17;
  unsigned char field18;
  unsigned char field19[1];
  unsigned char *field20;
  unsigned long long field21;
  unsigned char *field22;
  unsigned char *field23;
  unsigned char *field24;
  unsigned char *field25;
  unsigned long long field26;
  unsigned int field27;
  unsigned char field28[20];
};

struct l_struct_2E_Path {
  struct l_struct_2E_Array_3C_Vec2_3E_ field0;
};

struct l_struct_2E_Font {
  struct l_struct_2E_Path field0[128];
};

struct l_struct_2E_Levels {
  struct l_struct_2E_Array_3C_Levels_3A__3A_LevelDesc_2A__3E_ field0;
};

struct l_struct_2E_GameControl {
  unsigned int  (**field0) ();
  unsigned char field1;
  unsigned char field2;
  unsigned char field3;
  unsigned char field4;
  unsigned int field5;
  unsigned char field6;
  unsigned char field7;
  unsigned char field8;
  struct l_struct_2E_Levels field9;
  unsigned int field10;
};

struct l_struct_2E_Scene {
  struct l_struct_2E_Os field0;
  struct l_struct_2E_b2World *field1;
  struct l_struct_2E_Array_3C_Stroke_2A__3E_ field2;
  struct l_struct_2E_std_3A__3A_string field3;
  struct l_struct_2E_std_3A__3A_string field4;
  struct l_struct_2E_std_3A__3A_string field5;
  struct l_struct_2E_Image *field6;
  unsigned int field7;
};

struct l_struct_2E_Image {
  struct l_struct_2E_Canvas field0;
};

struct l_struct_2E_Game {
  struct l_struct_2E_GameControl field0;
  struct l_struct_2E_Scene field1;
  struct l_struct_2E_Stroke *field2;
  struct l_struct_2E_Stroke *field3;
  struct l_struct_2E_Array_3C_Overlay_2A__3E_ field4;
  struct l_struct_2E_Image field5;
  struct l_struct_2E_Os *field6;
  struct l_struct_2E_Os *field7;
  struct l_struct_2E_DemoRecorder field8;
  struct l_struct_2E_DemoPlayer field9;
  struct l_struct_2E_Os *field10;
};

struct l_struct_2E_Http {
  struct l_struct_2E_FILE *field0;
  unsigned int field1;
  struct l_struct_2E_std_3A__3A_string field2;
  struct l_struct_2E_std_3A__3A_string field3;
};

struct l_struct_2E_Levels_3A__3A_LevelDesc {
  struct l_struct_2E_std_3A__3A_string field0;
  unsigned int field1;
  unsigned int field2;
};

struct l_struct_2E_UiOverlay {
  struct l_struct_2E_OverlayBase field0;
  unsigned int field1;
  unsigned int field2;
  unsigned int field3;
  struct l_struct_2E_Vec2 field4;
};

struct l_struct_2E_MenuOverlay {
  struct l_struct_2E_UiOverlay field0;
};

struct l_struct_2E_NextLevelOverlay {
  struct l_struct_2E_IconOverlay field0;
  unsigned int field1;
  unsigned int field2;
  struct l_struct_2E_Canvas *field3;
  struct l_struct_2E_Font *field4;
  struct l_struct_2E_std_3A__3A_string field5;
};

struct l_struct_2E_OsFreeDesktop {
  struct l_struct_2E_Os field0;
};

struct l_struct_2E_anon {
  void  (*field0) (struct l_struct_2E_Os *);
  unsigned long long field1;
};

struct l_struct_2E_OverlayBase_3A__3A_HotSpot {
  struct l_struct_2E_Rect field0;
  unsigned int field1;
  unsigned char *field2;
  struct l_struct_2E_anon field3;
  void  (*field4) (unsigned char *, unsigned long long , unsigned long long );
};

struct l_struct_2E_SDL_ActiveEvent {
  unsigned char field0;
  unsigned char field1;
  unsigned char field2;
};

struct l_struct_2E_SDL_keysym {
  unsigned char field0;
  unsigned int field1;
  unsigned int field2;
  unsigned short field3;
};

struct l_struct_2E_SDL_KeyboardEvent {
  unsigned char field0;
  unsigned char field1;
  unsigned char field2;
  struct l_struct_2E_SDL_keysym field3;
};

struct l_struct_2E_SDL_MouseButtonEvent {
  unsigned char field0;
  unsigned char field1;
  unsigned char field2;
  unsigned char field3;
  unsigned short field4;
  unsigned short field5;
};

struct l_struct_2E_SDL_Palette {
  unsigned int field0;
  struct l_struct_2E__2E_0Features *field1;
};

struct l_struct_2E_SDL_PixelFormat {
  struct l_struct_2E_SDL_Palette *field0;
  unsigned char field1;
  unsigned char field2;
  unsigned char field3;
  unsigned char field4;
  unsigned char field5;
  unsigned char field6;
  unsigned char field7;
  unsigned char field8;
  unsigned char field9;
  unsigned char field10;
  unsigned int field11;
  unsigned int field12;
  unsigned int field13;
  unsigned int field14;
  unsigned int field15;
  unsigned char field16;
};

struct l_struct_2E_SDL_Rect {
  unsigned short field0;
  unsigned short field1;
  unsigned short field2;
  unsigned short field3;
};

struct l_struct_2E_SDL_Surface {
  unsigned int field0;
  struct l_struct_2E_SDL_PixelFormat *field1;
  unsigned int field2;
  unsigned int field3;
  unsigned short field4;
  unsigned char *field5;
  unsigned int field6;
  struct l_struct_2E_private_hwdata *field7;
  struct l_struct_2E_SDL_Rect field8;
  unsigned int field9;
  unsigned int field10;
  struct l_struct_2E_SDL_BlitMap *field11;
  unsigned int field12;
  unsigned int field13;
};

struct l_struct_2E_SDL_SysWMinfo_3A__3A__2E__184 {
  struct l_struct_2E__2E_1_2E__185 field0;
};

struct l_struct_2E_SDL_SysWMinfo {
  struct l_struct_2E_SDL_ActiveEvent field0;
  unsigned int field1;
  struct l_struct_2E_SDL_SysWMinfo_3A__3A__2E__184 field2;
};

struct l_struct_2E_SDL_VideoInfo {
  unsigned char field0;
  unsigned char field1;
  unsigned short field2;
  unsigned int field3;
  struct l_struct_2E_SDL_PixelFormat *field4;
  unsigned int field5;
  unsigned int field6;
};

struct l_struct_2E_Screen {
  struct l_struct_2E_XExtData *field0;
  struct l_struct_2E_Display *field1;
  unsigned long long field2;
  unsigned int field3;
  unsigned int field4;
  unsigned int field5;
  unsigned int field6;
  unsigned int field7;
  struct l_struct_2E_Depth *field8;
  unsigned int field9;
  struct l_struct_2E_Visual *field10;
  struct l_struct_2E__XGC *field11;
  unsigned long long field12;
  unsigned long long field13;
  unsigned long long field14;
  unsigned int field15;
  unsigned int field16;
  unsigned int field17;
  unsigned int field18;
  unsigned long long field19;
};

struct l_struct_2E_ScreenFormat {
  struct l_struct_2E_XExtData *field0;
  unsigned int field1;
  unsigned int field2;
  unsigned int field3;
};

struct l_struct_2E_Stroke {
  struct l_struct_2E_Path field0;
  unsigned int field1;
  unsigned int field2;
  struct l_struct_2E_Vec2 field3;
  struct l_struct_2E_Path field4;
  struct l_struct_2E_Path field5;
  struct l_struct_2E_Path field6;
  float field7;
  struct l_struct_2E_b2Vec2 field8;
  struct l_struct_2E_Rect field9;
  struct l_struct_2E_Rect field10;
  unsigned char field11;
  struct l_struct_2E_b2Body *field12;
  unsigned char field13[2];
  unsigned int field14;
};

struct l_struct_2E_b2PolygonDef {
  unsigned char field0[44];
  struct l_struct_2E_b2Vec2 field1[8];
  unsigned int field2;
};

struct l_struct_2E_Stroke_3A__3A_BoxDef {
  struct l_struct_2E_b2PolygonDef field0;
};

struct l_struct_2E_b2RevoluteJointDef {
  unsigned char field0[36];
  struct l_struct_2E_b2Vec2 field1;
  struct l_struct_2E_b2Vec2 field2;
  float field3;
  unsigned char field4;
  float field5;
  float field6;
  unsigned char field7;
  float field8;
  float field9;
};

struct l_struct_2E_Stroke_3A__3A_JointDef {
  struct l_struct_2E_b2RevoluteJointDef field0;
};

struct l_struct_2E_b2AABB {
  struct l_struct_2E_b2Vec2 field0;
  struct l_struct_2E_b2Vec2 field1;
};

struct l_struct_2E_Transform {
  unsigned char field0;
  struct l_struct_2E_b2AABB field1;
  struct l_struct_2E_b2AABB field2;
  struct l_struct_2E_Vec2 field3;
};

struct l_struct_2E_Visual {
  struct l_struct_2E_XExtData *field0;
  unsigned long long field1;
  unsigned int field2;
  unsigned long long field3;
  unsigned long long field4;
  unsigned long long field5;
  unsigned int field6;
  unsigned int field7;
};

struct l_struct_2E_XClientMessageEvent_3A__3A__2E__154 {
  unsigned long long field0[5];
};

struct l_struct_2E_XClientMessageEvent {
  unsigned int field0;
  unsigned long long field1;
  unsigned int field2;
  struct l_struct_2E_Display *field3;
  unsigned long long field4;
  unsigned long long field5;
  unsigned int field6;
  struct l_struct_2E_XClientMessageEvent_3A__3A__2E__154 field7;
};

struct l_struct_2E_XEvent {
  unsigned long long field0[24];
};

struct l_struct_2E_XExtData {
  unsigned int field0;
  struct l_struct_2E_XExtData *field1;
  unsigned int  (*field2) (struct l_struct_2E_XExtData *);
  unsigned char *field3;
};

struct l_struct_2E_ZipFile {
  unsigned int field0;
  unsigned int field1;
  unsigned char *field2;
  struct l_struct_2E_zip_eoc *field3;
  struct l_struct_2E_zip_cd *field4;
  unsigned int field5;
  unsigned char *field6;
};

struct l_struct_2E__IO_marker {
  struct l_struct_2E__IO_marker *field0;
  struct l_struct_2E_FILE *field1;
  unsigned int field2;
};

struct l_struct_2E___base_class_type_info_pseudo {
  struct l_struct_2E_std_3A__3A_type_info *field0;
  unsigned long long field1;
};

struct l_struct_2E___type_info_pseudo {
  unsigned char *field0;
  unsigned char *field1;
};

struct l_struct_2E___class_type_info_pseudo {
  struct l_struct_2E___type_info_pseudo field0;
};

struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ {
  unsigned char field0;
} __attribute__ ((packed));

struct l_struct_2E___pointer_type_info_pseudo {
  struct l_struct_2E___type_info_pseudo field0;
  unsigned int field1;
  struct l_struct_2E_std_3A__3A_type_info *field2;
};

struct l_struct_2E___si_class_type_info_pseudo {
  struct l_struct_2E___type_info_pseudo field0;
  struct l_struct_2E_std_3A__3A_type_info *field1;
};

struct l_struct_2E___va_list_tag {
  unsigned int field0;
  unsigned int field1;
  unsigned char *field2;
  unsigned char *field3;
};

struct l_struct_2E___vmi_class_type_info_pseudo1 {
  struct l_struct_2E___type_info_pseudo field0;
  unsigned int field1;
  unsigned int field2;
  struct l_struct_2E___base_class_type_info_pseudo field3[1];
};

struct l_struct_2E_b2Block {
  struct l_struct_2E_b2Block *field0;
};

struct l_struct_2E_b2BlockAllocator {
  struct l_struct_2E_b2Chunk *field0;
  unsigned int field1;
  unsigned int field2;
  struct l_struct_2E_b2Block *field3[14];
};

struct l_struct_2E_b2XForm {
  struct l_struct_2E_b2Vec2 field0;
  struct l_struct_2E_b2AABB field1;
};

struct l_struct_2E_b2Sweep {
  struct l_struct_2E_b2Vec2 field0;
  struct l_struct_2E_b2Vec2 field1;
  struct l_struct_2E_b2Vec2 field2;
  float field3;
  float field4;
  float field5;
};

struct l_struct_2E_b2Body {
  unsigned short field0;
  unsigned short field1;
  struct l_struct_2E_b2XForm field2;
  struct l_struct_2E_b2Sweep field3;
  struct l_struct_2E_b2Vec2 field4;
  float field5;
  struct l_struct_2E_b2Vec2 field6;
  float field7;
  struct l_struct_2E_b2World *field8;
  struct l_struct_2E_b2Body *field9;
  struct l_struct_2E_b2Body *field10;
  struct l_struct_2E_b2Shape *field11;
  unsigned int field12;
  struct l_struct_2E_b2JointEdge *field13;
  struct l_struct_2E_b2ContactEdge *field14;
  float field15;
  float field16;
  float field17;
  float field18;
  float field19;
  float field20;
  float field21;
  unsigned char *field22;
};

struct l_struct_2E_b2MassData {
  float field0;
  struct l_struct_2E_b2Vec2 field1;
  float field2;
};

struct l_struct_2E_b2BodyDef {
  struct l_struct_2E_b2MassData field0;
  unsigned char *field1;
  struct l_struct_2E_b2Vec2 field2;
  float field3;
  float field4;
  float field5;
  unsigned char field6;
  unsigned char field7;
  unsigned char field8;
  unsigned char field9;
};

struct l_struct_2E_b2Bound {
  unsigned short field0;
  unsigned short field1;
  unsigned short field2;
};

struct l_struct_2E_b2BoundValues {
  unsigned short field0[2];
  unsigned short field1[2];
};

struct l_struct_2E_b2Pair {
  unsigned char *field0;
  unsigned short field1;
  unsigned short field2;
  unsigned short field3;
  unsigned short field4;
};

struct l_struct_2E_b2BufferedPair {
  unsigned short field0;
  unsigned short field1;
};

struct l_struct_2E_b2PairManager {
  struct l_struct_2E_b2BroadPhase *field0;
  struct l_struct_2E_Os *field1;
  struct l_struct_2E_b2Pair field2[16384];
  unsigned short field3;
  unsigned int field4;
  struct l_struct_2E_b2BufferedPair field5[16384];
  unsigned int field6;
  unsigned short field7[16384];
};

struct l_struct_2E_b2Proxy {
  unsigned short field0[2];
  unsigned short field1[2];
  unsigned short field2;
  unsigned short field3;
  unsigned char *field4;
};

struct l_struct_2E_b2BroadPhase {
  struct l_struct_2E_b2PairManager field0;
  struct l_struct_2E_b2Proxy field1[2048];
  unsigned short field2;
  struct l_struct_2E_b2Bound field3[2][4096];
  unsigned short field4[2048];
  unsigned int field5;
  struct l_struct_2E_b2AABB field6;
  struct l_struct_2E_b2Vec2 field7;
  unsigned int field8;
  unsigned short field9;
};

struct l_struct_2E_b2Chunk {
  unsigned int field0;
  struct l_struct_2E_b2Block *field1;
};

struct l_struct_2E_b2ManifoldPoint {
  struct l_struct_2E_b2Vec2 field0;
  struct l_struct_2E_b2Vec2 field1;
  float field2;
  float field3;
  float field4;
  struct l_struct_2E___mbstate_t_3A__3A__2E__54 field5;
};

struct l_struct_2E_b2Manifold {
  struct l_struct_2E_b2ManifoldPoint field0[2];
  struct l_struct_2E_b2Vec2 field1;
  unsigned int field2;
};

struct l_struct_2E_b2CircleContact {
  unsigned char field0[124];
  struct l_struct_2E_b2Manifold field1;
};

struct l_struct_2E_b2CircleDef {
  unsigned char field0[44];
  struct l_struct_2E_b2Vec2 field1;
  float field2;
};

struct l_struct_2E_b2Shape {
  unsigned int  (**field0) ();
  unsigned int field1;
  struct l_struct_2E_b2Shape *field2;
  struct l_struct_2E_b2Body *field3;
  float field4;
  float field5;
  float field6;
  float field7;
  unsigned short field8;
  struct l_struct_2E_b2Bound field9;
  unsigned char field10;
  unsigned char *field11;
};

struct l_struct_2E_b2CircleShape {
  struct l_struct_2E_b2Shape field0;
  struct l_struct_2E_b2Vec2 field1;
  float field2;
};

struct l_struct_2E_b2Color {
  float field0;
  float field1;
  float field2;
};

struct l_struct_2E_b2ContactEdge {
  struct l_struct_2E_b2Body *field0;
  struct l_struct_2E_b2Contact *field1;
  struct l_struct_2E_b2ContactEdge *field2;
  struct l_struct_2E_b2ContactEdge *field3;
};

struct l_struct_2E_b2Contact {
  unsigned int  (**field0) ();
  unsigned int field1;
  unsigned int field2;
  struct l_struct_2E_b2Contact *field3;
  struct l_struct_2E_b2Contact *field4;
  struct l_struct_2E_b2ContactEdge field5;
  struct l_struct_2E_b2ContactEdge field6;
  struct l_struct_2E_b2Shape *field7;
  struct l_struct_2E_b2Shape *field8;
  float field9;
  float field10;
  float field11;
};

struct l_struct_2E_b2ContactConstraintPoint {
  struct l_struct_2E_b2Vec2 field0;
  struct l_struct_2E_b2Vec2 field1;
  struct l_struct_2E_b2Vec2 field2;
  struct l_struct_2E_b2Vec2 field3;
  float field4;
  float field5;
  float field6;
  float field7;
  float field8;
  float field9;
  float field10;
  float field11;
};

struct l_struct_2E_b2ContactConstraint {
  struct l_struct_2E_b2ContactConstraintPoint field0[2];
  struct l_struct_2E_b2Vec2 field1;
  struct l_struct_2E_b2Manifold *field2;
  struct l_struct_2E_b2Body *field3;
  struct l_struct_2E_b2Body *field4;
  float field5;
  float field6;
  unsigned int field7;
};

struct l_struct_2E_b2NullContact {
  struct l_struct_2E_b2Contact field0;
};

struct l_struct_2E_b2ContactManager {
  struct l_struct_2E_Os field0;
  struct l_struct_2E_b2World *field1;
  struct l_struct_2E_b2NullContact field2;
  unsigned char field3;
};

struct l_struct_2E_b2ContactPoint {
  struct l_struct_2E_b2Shape *field0;
  struct l_struct_2E_b2Shape *field1;
  struct l_struct_2E_b2Vec2 field2;
  struct l_struct_2E_b2Vec2 field3;
  struct l_struct_2E_b2Vec2 field4;
  float field5;
  float field6;
  float field7;
  struct l_struct_2E___mbstate_t_3A__3A__2E__54 field8;
};

struct l_struct_2E_b2ContactRegister {
  struct l_struct_2E_b2Contact * (*field0) (struct l_struct_2E_b2Shape *, struct l_struct_2E_b2Shape *, struct l_struct_2E_b2BlockAllocator *);
  void  (*field1) (struct l_struct_2E_b2Contact *, struct l_struct_2E_b2BlockAllocator *);
  unsigned char field2;
};

struct l_struct_2E_b2ContactResult {
  struct l_struct_2E_b2Shape *field0;
  struct l_struct_2E_b2Shape *field1;
  struct l_struct_2E_b2Vec2 field2;
  struct l_struct_2E_b2Vec2 field3;
  float field4;
  float field5;
  struct l_struct_2E___mbstate_t_3A__3A__2E__54 field6;
};

struct l_struct_2E_b2TimeStep {
  float field0;
  float field1;
  float field2;
  unsigned int field3;
  unsigned char field4;
  unsigned char field5;
};

struct l_struct_2E_b2ContactSolver {
  struct l_struct_2E_b2TimeStep field0;
  struct l_struct_2E_b2StackAllocator *field1;
  struct l_struct_2E_b2ContactConstraint *field2;
  unsigned int field3;
};

struct l_struct_2E_b2DebugDraw {
  unsigned int  (**field0) ();
  unsigned int field1;
};

struct l_struct_2E_b2JointEdge {
  struct l_struct_2E_b2Body *field0;
  struct l_struct_2E_b2Joint *field1;
  struct l_struct_2E_b2JointEdge *field2;
  struct l_struct_2E_b2JointEdge *field3;
};

struct l_struct_2E_b2Joint {
  unsigned int  (**field0) ();
  unsigned int field1;
  struct l_struct_2E_b2Joint *field2;
  struct l_struct_2E_b2Joint *field3;
  struct l_struct_2E_b2JointEdge field4;
  struct l_struct_2E_b2JointEdge field5;
  struct l_struct_2E_b2Body *field6;
  struct l_struct_2E_b2Body *field7;
  float field8;
  unsigned char field9;
  unsigned char field10;
  unsigned char *field11;
};

struct l_struct_2E_b2DistanceJoint {
  struct l_struct_2E_b2Joint field0;
  struct l_struct_2E_b2Vec2 field1;
  struct l_struct_2E_b2Vec2 field2;
  struct l_struct_2E_b2Vec2 field3;
  float field4;
  float field5;
  float field6;
  float field7;
  float field8;
  float field9;
  float field10;
};

struct l_struct_2E_b2DistanceJointDef {
  unsigned char field0[36];
  struct l_struct_2E_b2Vec2 field1;
  struct l_struct_2E_b2Vec2 field2;
  float field3;
  float field4;
  float field5;
};

struct l_struct_2E_b2Jacobian {
  struct l_struct_2E_b2Vec2 field0;
  float field1;
  struct l_struct_2E_b2Vec2 field2;
  float field3;
};

struct l_struct_2E_b2GearJoint {
  struct l_struct_2E_b2Joint field0;
  struct l_struct_2E_b2Body *field1;
  struct l_struct_2E_b2Body *field2;
  struct l_struct_2E_b2RevoluteJoint *field3;
  struct l_struct_2E_b2PrismaticJoint *field4;
  struct l_struct_2E_b2RevoluteJoint *field5;
  struct l_struct_2E_b2PrismaticJoint *field6;
  struct l_struct_2E_b2Vec2 field7;
  struct l_struct_2E_b2Vec2 field8;
  struct l_struct_2E_b2Vec2 field9;
  struct l_struct_2E_b2Vec2 field10;
  struct l_struct_2E_b2Jacobian field11;
  float field12;
  float field13;
  float field14;
  float field15;
};

struct l_struct_2E_b2JointDef {
  unsigned int field0;
  unsigned char *field1;
  struct l_struct_2E_b2Body *field2;
  struct l_struct_2E_b2Body *field3;
  unsigned char field4;
};

struct l_struct_2E_b2GearJointDef {
  struct l_struct_2E_b2JointDef field0;
  struct l_struct_2E_b2Joint *field1;
  struct l_struct_2E_b2Joint *field2;
  float field3;
};

struct l_struct_2E_b2Island {
  struct l_struct_2E_b2StackAllocator *field0;
  struct l_struct_2E_Os *field1;
  struct l_struct_2E_b2Body **field2;
  struct l_struct_2E_b2Contact **field3;
  struct l_struct_2E_b2Joint **field4;
  unsigned int field5;
  unsigned int field6;
  unsigned int field7;
  unsigned int field8;
  unsigned int field9;
  unsigned int field10;
  unsigned int field11;
};

struct l_struct_2E_b2MouseJoint {
  struct l_struct_2E_b2Joint field0;
  struct l_struct_2E_b2Vec2 field1;
  struct l_struct_2E_b2Vec2 field2;
  struct l_struct_2E_b2Vec2 field3;
  struct l_struct_2E_b2AABB field4;
  struct l_struct_2E_b2Vec2 field5;
  float field6;
  float field7;
  float field8;
};

struct l_struct_2E_b2MouseJointDef {
  unsigned char field0[36];
  struct l_struct_2E_b2Vec2 field1;
  float field2;
  float field3;
  float field4;
  float field5;
  unsigned int field6[1];
};

struct l_struct_2E_b2OBB {
  struct l_struct_2E_b2AABB field0;
  struct l_struct_2E_b2Vec2 field1;
  struct l_struct_2E_b2Vec2 field2;
};

struct l_struct_2E_b2PolygonShape {
  struct l_struct_2E_b2Shape field0;
  struct l_struct_2E_b2Vec2 field1;
  struct l_struct_2E_b2OBB field2;
  struct l_struct_2E_b2Vec2 field3[8];
  struct l_struct_2E_b2Vec2 field4[8];
  struct l_struct_2E_b2Vec2 field5[8];
  unsigned int field6;
};

struct l_struct_2E_b2PrismaticJoint {
  struct l_struct_2E_b2Joint field0;
  struct l_struct_2E_b2Vec2 field1;
  struct l_struct_2E_b2Vec2 field2;
  struct l_struct_2E_b2Vec2 field3;
  struct l_struct_2E_b2Vec2 field4;
  float field5;
  struct l_struct_2E_b2Jacobian field6;
  float field7;
  float field8;
  float field9;
  float field10;
  struct l_struct_2E_b2Jacobian field11;
  float field12;
  float field13;
  float field14;
  float field15;
  float field16;
  float field17;
  float field18;
  float field19;
  unsigned char field20;
  unsigned char field21;
  unsigned int field22;
};

struct l_struct_2E_b2PrismaticJointDef {
  unsigned char field0[36];
  struct l_struct_2E_b2Vec2 field1;
  struct l_struct_2E_b2Vec2 field2;
  struct l_struct_2E_b2Vec2 field3;
  float field4;
  unsigned char field5;
  float field6;
  float field7;
  unsigned char field8;
  float field9;
  float field10;
};

struct l_struct_2E_b2PulleyJoint {
  struct l_struct_2E_b2Joint field0;
  struct l_struct_2E_b2Body *field1;
  struct l_struct_2E_b2Vec2 field2;
  struct l_struct_2E_b2Vec2 field3;
  struct l_struct_2E_b2Vec2 field4;
  struct l_struct_2E_b2Vec2 field5;
  struct l_struct_2E_b2Vec2 field6;
  struct l_struct_2E_b2Vec2 field7;
  float field8;
  float field9;
  float field10;
  float field11;
  float field12;
  float field13;
  float field14;
  float field15;
  float field16;
  float field17;
  float field18;
  float field19;
  float field20;
  unsigned int field21;
  unsigned int field22;
  unsigned int field23;
};

struct l_struct_2E_b2PulleyJointDef {
  unsigned char field0[36];
  struct l_struct_2E_b2Vec2 field1;
  struct l_struct_2E_b2Vec2 field2;
  struct l_struct_2E_b2Vec2 field3;
  struct l_struct_2E_b2Vec2 field4;
  float field5;
  float field6;
  float field7;
  float field8;
  float field9;
};

struct l_struct_2E_b2RevoluteJoint {
  struct l_struct_2E_b2Joint field0;
  struct l_struct_2E_b2Vec2 field1;
  struct l_struct_2E_b2Vec2 field2;
  struct l_struct_2E_b2Vec2 field3;
  float field4;
  float field5;
  float field6;
  struct l_struct_2E_b2AABB field7;
  float field8;
  unsigned char field9;
  float field10;
  float field11;
  unsigned char field12;
  float field13;
  float field14;
  float field15;
  unsigned int field16;
};

struct l_struct_2E_b2ShapeDef {
  unsigned int  (**field0) ();
  unsigned int field1;
  unsigned char *field2;
  float field3;
  float field4;
  float field5;
  unsigned char field6;
  struct l_struct_2E_b2Bound field7;
};

struct l_struct_2E_b2StackEntry {
  unsigned char *field0;
  unsigned int field1;
  unsigned char field2;
};

struct l_struct_2E_b2StackAllocator {
  unsigned char field0[102400];
  unsigned int field1;
  unsigned int field2;
  unsigned int field3;
  struct l_struct_2E_b2StackEntry field4[32];
  unsigned int field5;
};

struct l_struct_2E_b2World {
  struct l_struct_2E_b2BlockAllocator field0;
  struct l_struct_2E_b2StackAllocator field1;
  unsigned char field2;
  struct l_struct_2E_b2BroadPhase *field3;
  struct l_struct_2E_b2ContactManager field4;
  struct l_struct_2E_b2Body *field5;
  struct l_struct_2E_b2Joint *field6;
  struct l_struct_2E_b2Contact *field7;
  unsigned int field8;
  unsigned int field9;
  unsigned int field10;
  struct l_struct_2E_b2Vec2 field11;
  unsigned char field12;
  struct l_struct_2E_b2Body *field13;
  struct l_struct_2E_Os *field14;
  struct l_struct_2E_Os *field15;
  struct l_struct_2E_Os *field16;
  struct l_struct_2E_Os *field17;
  struct l_struct_2E_b2DebugDraw *field18;
  float field19;
  unsigned int field20;
  unsigned char field21;
  unsigned char field22;
  unsigned char field23;
};

struct l_struct_2E_dirent {
  unsigned long long field0;
  unsigned long long field1;
  unsigned short field2;
  unsigned char field3;
  unsigned char field4[256];
};

struct l_struct_2E_fd_set {
  unsigned long long field0[16];
};

struct l_struct_2E_std_3A__3A__Vector_base_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__3A__3A__Vector_impl {
  struct l_struct_2E_std_3A__3A_string *field0;
  struct l_struct_2E_std_3A__3A_string *field1;
  struct l_struct_2E_std_3A__3A_string *field2;
};

struct l_struct_2E_std_3A__3A__Vector_base_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_ {
  struct l_struct_2E_std_3A__3A__Vector_base_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__3A__3A__Vector_impl field0;
};

struct l_struct_2E_std_3A__3A_vector_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_ {
  struct l_struct_2E_std_3A__3A__Vector_base_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_ field0;
};

struct l_struct_2E_std_3A__3A__Deque_iterator_3C_happyhttp_3A__3A_Response_2A__2C_happyhttp_3A__3A_Response_2A__26__2C_happyhttp_3A__3A_Response_2A__2A__3E_ {
  struct l_struct_2E_happyhttp_3A__3A_Response **field0;
  struct l_struct_2E_happyhttp_3A__3A_Response **field1;
  struct l_struct_2E_happyhttp_3A__3A_Response **field2;
  struct l_struct_2E_happyhttp_3A__3A_Response ***field3;
};

struct l_struct_2E_std_3A__3A__Deque_base_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E__3A__3A__Deque_impl {
  struct l_struct_2E_happyhttp_3A__3A_Response ***field0;
  unsigned long long field1;
  struct l_struct_2E_std_3A__3A__Deque_iterator_3C_happyhttp_3A__3A_Response_2A__2C_happyhttp_3A__3A_Response_2A__26__2C_happyhttp_3A__3A_Response_2A__2A__3E_ field2;
  struct l_struct_2E_std_3A__3A__Deque_iterator_3C_happyhttp_3A__3A_Response_2A__2C_happyhttp_3A__3A_Response_2A__26__2C_happyhttp_3A__3A_Response_2A__2A__3E_ field3;
};

struct l_struct_2E_std_3A__3A__Deque_base_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E_ {
  struct l_struct_2E_std_3A__3A__Deque_base_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E__3A__3A__Deque_impl field0;
};

struct l_struct_2E_std_3A__3A_deque_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E_ {
  struct l_struct_2E_std_3A__3A__Deque_base_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E_ field0;
};

struct l_struct_2E_happyhttp_3A__3A_Connection {
  void  (*field0) (struct l_struct_2E_happyhttp_3A__3A_Response *, unsigned char *);
  void  (*field1) (struct l_struct_2E_happyhttp_3A__3A_Response *, unsigned char *, unsigned char *, unsigned int );
  void  (*field2) (struct l_struct_2E_happyhttp_3A__3A_Response *, unsigned char *);
  unsigned char *field3;
  unsigned int field4;
  struct l_struct_2E_std_3A__3A_string field5;
  unsigned int field6;
  unsigned int field7;
  struct l_struct_2E_std_3A__3A_vector_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_ field8;
  struct l_struct_2E_std_3A__3A_deque_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E_ field9;
};

struct l_struct_2E_std_3A__3A__Rb_tree_node_base {
  unsigned int field0;
  struct l_struct_2E_std_3A__3A__Rb_tree_node_base *field1;
  struct l_struct_2E_std_3A__3A__Rb_tree_node_base *field2;
  struct l_struct_2E_std_3A__3A__Rb_tree_node_base *field3;
};

struct l_struct_2E_std_3A__3A__Rb_tree_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A__Select1st_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E__3A__3A__Rb_tree_impl_3C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_false_3E_ {
  struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ field0;
  struct l_struct_2E_std_3A__3A__Rb_tree_node_base field1;
  unsigned long long field2;
};

struct l_struct_2E_std_3A__3A__Rb_tree_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A__Select1st_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E_ {
  struct l_struct_2E_std_3A__3A__Rb_tree_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A__Select1st_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E__3A__3A__Rb_tree_impl_3C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_false_3E_ field0;
};

struct l_struct_2E_std_3A__3A_map_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E_ {
  struct l_struct_2E_std_3A__3A__Rb_tree_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A__Select1st_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E_ field0;
};

struct l_struct_2E_happyhttp_3A__3A_Response {
  unsigned int field0;
  struct l_struct_2E_happyhttp_3A__3A_Connection *field1;
  struct l_struct_2E_std_3A__3A_string field2;
  struct l_struct_2E_std_3A__3A_string field3;
  unsigned int field4;
  unsigned int field5;
  struct l_struct_2E_std_3A__3A_string field6;
  struct l_struct_2E_std_3A__3A_map_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E_ field7;
  unsigned int field8;
  unsigned char field9;
  unsigned int field10;
  unsigned int field11;
  unsigned char field12;
  struct l_struct_2E_std_3A__3A_string field13;
  struct l_struct_2E_std_3A__3A_string field14;
};

struct l_struct_2E_happyhttp_3A__3A_Wobbly {
  unsigned char field0[256];
};

struct l_struct_2E_hostent {
  unsigned char *field0;
  unsigned char **field1;
  unsigned int field2;
  unsigned int field3;
  unsigned char **field4;
};

struct l_struct_2E_mbstate_t {
  unsigned int field0;
  struct l_struct_2E___mbstate_t_3A__3A__2E__54 field1;
};

struct l_struct_2E_pthread_attr_t {
  unsigned long long field0;
  unsigned char field1[48];
};

struct l_struct_2E_pthread_mutex_t {
  struct l_struct_2E__2E_0__pthread_mutex_s field0;
};

struct l_struct_2E_sockaddr {
  unsigned short field0;
  unsigned char field1[14];
};

struct l_struct_2E_sockaddr_in {
  unsigned short field0;
  unsigned short field1;
  struct l_struct_2E___mbstate_t_3A__3A__2E__54 field2;
  unsigned char field3[8];
};

struct l_struct_2E_timespec {
  unsigned long long field0;
  unsigned long long field1;
};

struct l_struct_2E_stat {
  unsigned long long field0;
  unsigned long long field1;
  unsigned long long field2;
  unsigned int field3;
  unsigned int field4;
  unsigned int field5;
  unsigned int field6;
  unsigned long long field7;
  unsigned long long field8;
  unsigned long long field9;
  unsigned long long field10;
  struct l_struct_2E_timespec field11;
  struct l_struct_2E_timespec field12;
  struct l_struct_2E_timespec field13;
  unsigned long long field14[3];
};

struct l_struct_2E_std_3A__3A__Rb_tree_const_iterator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_ {
  struct l_struct_2E_std_3A__3A__Rb_tree_node_base *field0;
};

struct l_struct_2E_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E_ {
  struct l_struct_2E_std_3A__3A_string field0;
  struct l_struct_2E_std_3A__3A_string field1;
};

struct l_struct_2E_std_3A__3A__Rb_tree_node_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_ {
  struct l_struct_2E_std_3A__3A__Rb_tree_node_base field0;
  struct l_struct_2E_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E_ field1;
};

struct l_struct_2E_std_3A__3A___basic_file_3C_char_3E_ {
  struct l_struct_2E_FILE *field0;
  unsigned char field1;
};

struct l_struct_2E_std_3A__3A___codecvt_abstract_base_3C_char_2C_char_2C___mbstate_t_3E__2E_base {
  struct l_struct_2E_b2DebugDraw field0;
};

struct l_struct_2E_std_3A__3A_locale {
  struct l_struct_2E_std_3A__3A_locale_3A__3A__Impl *field0;
};

struct l_struct_2E_std_3A__3A_basic_streambuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ {
  unsigned int  (**field0) ();
  unsigned char *field1;
  unsigned char *field2;
  unsigned char *field3;
  unsigned char *field4;
  unsigned char *field5;
  unsigned char *field6;
  struct l_struct_2E_std_3A__3A_locale field7;
};

struct l_struct_2E_std_3A__3A_basic_filebuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ {
  struct l_struct_2E_std_3A__3A_basic_streambuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ field0;
  struct l_struct_2E_pthread_mutex_t field1;
  struct l_struct_2E_std_3A__3A___basic_file_3C_char_3E_ field2;
  unsigned int field3;
  struct l_struct_2E_mbstate_t field4;
  struct l_struct_2E_mbstate_t field5;
  struct l_struct_2E_mbstate_t field6;
  unsigned char *field7;
  unsigned long long field8;
  unsigned char field9;
  unsigned char field10;
  unsigned char field11;
  unsigned char field12;
  unsigned char *field13;
  unsigned char *field14;
  unsigned char field15;
  struct l_struct_2E_std_3A__3A_codecvt_3C_char_2C_char_2C___mbstate_t_3E_ *field16;
  unsigned char *field17;
  unsigned long long field18;
  unsigned char *field19;
  unsigned char *field20;
};

struct l_struct_2E_std_3A__3A_ios_base_3A__3A__Words {
  unsigned char *field0;
  unsigned long long field1;
};

struct l_struct_2E_std_3A__3A_ios_base {
  unsigned int  (**field0) ();
  unsigned long long field1;
  unsigned long long field2;
  unsigned int field3;
  unsigned int field4;
  unsigned int field5;
  struct l_struct_2E_std_3A__3A_ios_base_3A__3A__Callback_list *field6;
  struct l_struct_2E_std_3A__3A_ios_base_3A__3A__Words field7;
  struct l_struct_2E_std_3A__3A_ios_base_3A__3A__Words field8[8];
  unsigned int field9;
  struct l_struct_2E_std_3A__3A_ios_base_3A__3A__Words *field10;
  struct l_struct_2E_std_3A__3A_locale field11;
};

struct l_struct_2E_std_3A__3A_basic_ios_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ {
  struct l_struct_2E_std_3A__3A_ios_base field0;
  struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *field1;
  unsigned char field2;
  unsigned char field3;
  struct l_struct_2E_std_3A__3A_basic_streambuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *field4;
  struct l_struct_2E_std_3A__3A_ctype_3C_char_3E_ *field5;
  struct l_struct_2E_std_3A__3A___codecvt_abstract_base_3C_char_2C_char_2C___mbstate_t_3E__2E_base *field6;
  struct l_struct_2E_std_3A__3A___codecvt_abstract_base_3C_char_2C_char_2C___mbstate_t_3E__2E_base *field7;
};

struct l_struct_2E_std_3A__3A_basic_istream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E__2E_base {
  unsigned int  (**field0) ();
  unsigned long long field1;
};

struct l_struct_2E_std_3A__3A_basic_iostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E__2E_base {
  struct l_struct_2E_std_3A__3A_basic_istream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E__2E_base field0;
  struct l_struct_2E_Os field1;
};

struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ {
  unsigned int  (**field0) ();
  struct l_struct_2E_std_3A__3A_basic_ios_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ field1;
};

struct l_struct_2E_std_3A__3A_basic_stringbuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__2C_std_3A__3A_allocator_3C_char_3E__20__3E_ {
  struct l_struct_2E_std_3A__3A_basic_streambuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ field0;
  unsigned int field1;
  struct l_struct_2E_std_3A__3A_string field2;
};

struct l_struct_2E_std_3A__3A_codecvt_3C_char_2C_char_2C___mbstate_t_3E_ {
  struct l_struct_2E_std_3A__3A___codecvt_abstract_base_3C_char_2C_char_2C___mbstate_t_3E__2E_base field0;
  unsigned int *field1;
};

struct l_struct_2E_std_3A__3A_ctype_3C_char_3E_ {
  struct l_struct_2E_b2DebugDraw field0;
  unsigned int *field1;
  unsigned char field2;
  unsigned int *field3;
  unsigned int *field4;
  unsigned short *field5;
  unsigned char field6;
  unsigned char field7[256];
  unsigned char field8[256];
  unsigned char field9;
};

struct l_struct_2E_std_3A__3A_ifstream {
  struct l_struct_2E_std_3A__3A_basic_istream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E__2E_base field0;
  struct l_struct_2E_std_3A__3A_basic_filebuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ field1;
  struct l_struct_2E_std_3A__3A_basic_ios_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ field2;
};

struct l_struct_2E_std_3A__3A_ios_base_3A__3A__Callback_list {
  struct l_struct_2E_std_3A__3A_ios_base_3A__3A__Callback_list *field0;
  void  (*field1) (unsigned int , struct l_struct_2E_std_3A__3A_ios_base *, unsigned int );
  unsigned int field2;
  unsigned int field3;
};

struct l_struct_2E_std_3A__3A_istream {
  unsigned int  (**field0) ();
  unsigned long long field1;
  struct l_struct_2E_std_3A__3A_basic_ios_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ field2;
};

struct l_struct_2E_std_3A__3A_locale_3A__3A__Impl {
  unsigned int field0;
  struct l_struct_2E_b2DebugDraw **field1;
  unsigned long long field2;
  struct l_struct_2E_b2DebugDraw **field3;
  unsigned char **field4;
};

struct l_struct_2E_std_3A__3A_ofstream {
  struct l_struct_2E_Os field0;
  struct l_struct_2E_std_3A__3A_basic_filebuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ field1;
  struct l_struct_2E_std_3A__3A_basic_ios_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ field2;
};

struct l_struct_2E_std_3A__3A_pair_3C_std_3A__3A__Rb_tree_iterator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_bool_3E_ {
  struct l_struct_2E_std_3A__3A__Rb_tree_const_iterator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_ field0;
  unsigned char field1;
};

struct l_struct_2E_std_3A__3A_stringstream {
  struct l_struct_2E_std_3A__3A_basic_iostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E__2E_base field0;
  struct l_struct_2E_std_3A__3A_basic_stringbuf_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__2C_std_3A__3A_allocator_3C_char_3E__20__3E_ field1;
  struct l_struct_2E_std_3A__3A_basic_ios_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ field2;
};

struct l_struct_2E_std_3A__3A_type_info {
  unsigned int  (**field0) ();
  unsigned char *field1;
};

struct l_struct_2E_z_stream {
  unsigned char *field0;
  unsigned int field1;
  unsigned long long field2;
  unsigned char *field3;
  unsigned int field4;
  unsigned long long field5;
  unsigned char *field6;
  struct l_struct_2E___mbstate_t_3A__3A__2E__54 *field7;
  unsigned char * (*field8) (unsigned char *, unsigned int , unsigned int );
  void  (*field9) (unsigned char *, unsigned char *);
  unsigned char *field10;
  unsigned int field11;
  unsigned long long field12;
  unsigned long long field13;
};

struct l_struct_2E_zip_cd {
  unsigned int field0;
  unsigned char field1;
  unsigned char field2;
  unsigned char field3;
  unsigned char field4;
  unsigned short field5;
  unsigned short field6;
  unsigned short field7;
  unsigned short field8;
  unsigned int field9;
  unsigned int field10;
  unsigned int field11;
  unsigned short field12;
  unsigned short field13;
  unsigned short field14;
  unsigned short field15;
  unsigned short field16;
  unsigned int field17;
  unsigned int field18;
  unsigned char field19[1];
} __attribute__ ((packed));

struct l_struct_2E_zip_eoc {
  unsigned int field0;
  unsigned short field1;
  unsigned short field2;
  unsigned short field3;
  unsigned short field4;
  unsigned int field5;
  unsigned int field6;
  unsigned short field7;
  unsigned char field8[1];
} __attribute__ ((packed));

struct l_struct_2E_zip_lfh {
  unsigned int field0;
  unsigned short field1;
  unsigned short field2;
  unsigned short field3;
  unsigned short field4;
  unsigned short field5;
  unsigned int field6;
  unsigned int field7;
  unsigned int field8;
  unsigned short field9;
  unsigned short field10;
  unsigned char field11[1];
} __attribute__ ((packed));

struct l_unnamed0 {
  unsigned int field0;
  void  (*field1) (void);
};

struct l_unnamed1 {
  unsigned long long field0[3];
};

struct l_unnamed2 {
  unsigned int field0[2];
};

struct l_unnamed3 {
  void  (*field0) (struct l_struct_2E_MenuOverlay *);
  unsigned long long field1;
};

struct l_unnamed4 {
  void  (*field0) (struct l_struct_2E_NextLevelOverlay *);
  unsigned long long field1;
};

struct l_unnamed5 {
  unsigned long long field0[2];
};


/* External Global Variable Declarations */
extern unsigned int  (*_ZTVN10__cxxabiv117__class_type_infoE[1]) ();
extern unsigned int  (*_ZTVN10__cxxabiv120__si_class_type_infoE[1]) ();
extern struct l_struct_2E___pointer_type_info_pseudo _ZTIPc;
extern unsigned char *__dso_handle;
extern unsigned int  (*_ZTVN10__cxxabiv121__vmi_class_type_infoE[1]) ();
extern struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ _ZSt4cout;
extern struct l_struct_2E___pointer_type_info_pseudo _ZTIPKc;
extern struct l_struct_2E_FILE *stderr;

/* Function Declarations */
double fmod(double, double);
float fmodf(float, float);
long double fmodl(long double, long double);
static float _ZN7Segment10distanceToERK4Vec2(struct l_struct_2E_Rect *llvm_cbe_this, struct l_struct_2E_Vec2 *llvm_cbe_p);
static void _ZN4Rect6expandERK4Vec2(struct l_struct_2E_Rect *llvm_cbe_this, struct l_struct_2E_Vec2 *llvm_cbe_v);
static void _ZN4Path5scaleEf(struct l_struct_2E_Path *llvm_cbe_this, float llvm_cbe_factor);
static void _ZN4Path6rotateERK7b2Mat22(struct l_struct_2E_Path *llvm_cbe_this, struct l_struct_2E_b2AABB *llvm_cbe_rot);
static struct l_struct_2E_Path *_ZN4Path9translateERK4Vec2(struct l_struct_2E_Path *llvm_cbe_this, struct l_struct_2E_Vec2 *llvm_cbe_xlate);
static struct l_struct_2E_Rect _ZNK4Path4bboxEv(struct l_struct_2E_Path *llvm_cbe_this);
unsigned char *realloc(unsigned char *, unsigned long long );
unsigned char *malloc(unsigned long long );
static void _ZN5ArrayI4Vec2EC2Ei(struct l_struct_2E_Array_3C_Vec2_3E_ *llvm_cbe_this);
static void _ZN5ArrayI4Vec2E6appendERKS0_(struct l_struct_2E_Array_3C_Vec2_3E_ *llvm_cbe_this, struct l_struct_2E_Vec2 *llvm_cbe_t);
void free(unsigned char *);
static void _ZN4PathC1EPKc(struct l_struct_2E_Path *llvm_cbe_this, unsigned char *llvm_cbe_s);
unsigned int sscanf(unsigned char *, unsigned char *, ...);
unsigned int __gxx_personality_v0();
unsigned int _Unwind_Resume();
float sqrtf(float );
static float _ZL12calcDistanceRK4Vec2S1_(struct l_struct_2E_Vec2 *llvm_cbe_l1, struct l_struct_2E_Vec2 *llvm_cbe_l2);
static float _ZN6b2Vec29NormalizeEv(struct l_struct_2E_b2Vec2 *llvm_cbe_this);
static void _ZN4Path11simplifySubEiifPb(struct l_struct_2E_Path *llvm_cbe_this, unsigned int llvm_cbe_first, unsigned int llvm_cbe_last, float llvm_cbe_threshold, unsigned char *llvm_cbe_keepflags);
static void _ZN4Path8simplifyEf(struct l_struct_2E_Path *llvm_cbe_this, float llvm_cbe_threshold);
extern unsigned int pthread_once(unsigned int *, void  (*) (void)) __EXTERNAL_WEAK__;
extern unsigned char *pthread_getspecific(unsigned int ) __EXTERNAL_WEAK__;
extern unsigned int pthread_setspecific(unsigned int , unsigned char *) __EXTERNAL_WEAK__;
extern unsigned int pthread_create(unsigned long long *, struct l_struct_2E_pthread_attr_t *, unsigned char * (*) (unsigned char *), unsigned char *) __EXTERNAL_WEAK__;
extern unsigned int pthread_cancel(unsigned long long ) __EXTERNAL_WEAK__;
extern unsigned int pthread_mutex_lock(struct l_struct_2E_pthread_mutex_t *) __EXTERNAL_WEAK__;
extern unsigned int pthread_mutex_trylock(struct l_struct_2E_pthread_mutex_t *) __EXTERNAL_WEAK__;
extern unsigned int pthread_mutex_unlock(struct l_struct_2E_pthread_mutex_t *) __EXTERNAL_WEAK__;
extern unsigned int pthread_mutex_init(struct l_struct_2E_pthread_mutex_t *, struct l_struct_2E___mbstate_t_3A__3A__2E__54 *) __EXTERNAL_WEAK__;
extern unsigned int pthread_key_create(unsigned int *, void  (*) (unsigned char *)) __EXTERNAL_WEAK__;
extern unsigned int pthread_key_delete(unsigned int ) __EXTERNAL_WEAK__;
extern unsigned int pthread_mutexattr_init(struct l_struct_2E___mbstate_t_3A__3A__2E__54 *) __EXTERNAL_WEAK__;
extern unsigned int pthread_mutexattr_settype(struct l_struct_2E___mbstate_t_3A__3A__2E__54 *, unsigned int ) __EXTERNAL_WEAK__;
extern unsigned int pthread_mutexattr_destroy(struct l_struct_2E___mbstate_t_3A__3A__2E__54 *) __EXTERNAL_WEAK__;
static void _ZN6Canvas7setClipEiiii(struct l_struct_2E_Canvas *llvm_cbe_this, unsigned int llvm_cbe_w, unsigned int llvm_cbe_h);
static void _ZN6CanvasD1Ev(struct l_struct_2E_Canvas *llvm_cbe_this);
static void _ZN6CanvasD0Ev(struct l_struct_2E_Canvas *llvm_cbe_this);
unsigned long long _ZNKSs4sizeEv(struct l_struct_2E_std_3A__3A_string *);
unsigned char *_ZNKSsixEm(struct l_struct_2E_std_3A__3A_string *, unsigned long long );
static void _ZN10AlphaBrushItLj3EE3inkEPtii(struct l_struct_2E_AlphaBrush_3C_short_20_unsigned_20_int_2C_1u_3E_ *llvm_cbe_this, unsigned short *llvm_cbe_pix, unsigned int llvm_cbe_step, unsigned int llvm_cbe_a);
static void _ZN10AlphaBrushItLj1EE3inkEPtii(struct l_struct_2E_AlphaBrush_3C_short_20_unsigned_20_int_2C_1u_3E_ *llvm_cbe_this, unsigned short *llvm_cbe_pix, unsigned int llvm_cbe_step, unsigned int llvm_cbe_a);
static void _ZN10AlphaBrushIjLj3EE3inkEPjii(struct l_struct_2E_AlphaBrush_3C_short_20_unsigned_20_int_2C_1u_3E_ *llvm_cbe_this, unsigned int *llvm_cbe_pix, unsigned int llvm_cbe_step, unsigned int llvm_cbe_a);
static void _ZN10AlphaBrushIjLj1EE3inkEPjii(struct l_struct_2E_AlphaBrush_3C_short_20_unsigned_20_int_2C_1u_3E_ *llvm_cbe_this, unsigned int *llvm_cbe_pix, unsigned int llvm_cbe_step, unsigned int llvm_cbe_a);
void _ZdlPv(unsigned char *);
static void _ZN5ImageD0Ev(struct l_struct_2E_Image *llvm_cbe_this);
static void _ZN5ImageD1Ev(struct l_struct_2E_Image *llvm_cbe_this);
static void _ZN6WindowD0Ev(struct l_struct_2E_Image *llvm_cbe_this);
static void _ZN6WindowD1Ev(struct l_struct_2E_Image *llvm_cbe_this);
void _ZNSsC1ERKSs(struct l_struct_2E_std_3A__3A_string *, struct l_struct_2E_std_3A__3A_string *);
struct l_struct_2E_std_3A__3A_string *_ZNSs6appendEPKc(struct l_struct_2E_std_3A__3A_string *, unsigned char *);
void _ZNSsD1Ev(struct l_struct_2E_std_3A__3A_string *);
static void _ZN5ImageC1EPKcb(struct l_struct_2E_Image *llvm_cbe_this, unsigned char *llvm_cbe_file);
void _ZNSaIcEC1Ev(struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ *);
void _ZNSsC1EPKcRKSaIcE(struct l_struct_2E_std_3A__3A_string *, unsigned char *, struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ *);
void _ZNSaIcED1Ev(struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ *);
unsigned char *_ZNKSs5c_strEv(struct l_struct_2E_std_3A__3A_string *);
struct l_struct_2E_SDL_Surface *IMG_Load(unsigned char *);
struct l_struct_2E_std_3A__3A_string *_ZNSsaSERKSs(struct l_struct_2E_std_3A__3A_string *, struct l_struct_2E_std_3A__3A_string *);
unsigned int printf(unsigned char *, ...);
struct l_struct_2E_SDL_Surface *SDL_DisplayFormat(struct l_struct_2E_SDL_Surface *);
void SDL_FreeSurface(struct l_struct_2E_SDL_Surface *);
unsigned char *__cxa_allocate_exception(unsigned long long );
void __cxa_throw(unsigned char *, unsigned char *, void  (*) (unsigned char *));
unsigned int SDL_GetWMInfo(struct l_struct_2E_SDL_SysWMinfo *);
unsigned long long XInternAtom(struct l_struct_2E_Display *, unsigned char *, unsigned int );
unsigned int XSendEvent(struct l_struct_2E_Display *, unsigned long long , unsigned int , unsigned long long , struct l_struct_2E_XEvent *);
unsigned int XSync(struct l_struct_2E_Display *, unsigned int );
static void _ZN6Window6updateERK4Rect(struct l_struct_2E_Image *llvm_cbe_this, struct l_struct_2E_Rect *llvm_cbe_r);
void SDL_UpdateRect(struct l_struct_2E_SDL_Surface *, unsigned int , unsigned int , unsigned int , unsigned int );
unsigned int snprintf(unsigned char *, unsigned long long , unsigned char *, ...);
unsigned int putenv(unsigned char *);
void SDL_WM_SetCaption(unsigned char *, unsigned char *);
struct l_struct_2E_SDL_Surface *SDL_SetVideoMode(unsigned int , unsigned int , unsigned int , unsigned int );
unsigned int SDL_FillRect(struct l_struct_2E_SDL_Surface *, struct l_struct_2E_SDL_Rect *, unsigned int );
static void _ZN6Canvas8drawRectERK4Rectib(struct l_struct_2E_Canvas *llvm_cbe_this, struct l_struct_2E_Rect *llvm_cbe_r, unsigned int llvm_cbe_c, unsigned char llvm_cbe_fill);
static void _ZN6Canvas8drawPathERK4Pathib(struct l_struct_2E_Canvas *llvm_cbe_this, struct l_struct_2E_Path *llvm_cbe_path, unsigned int llvm_cbe_color, unsigned char llvm_cbe_thick);
unsigned int SDL_LockSurface(struct l_struct_2E_SDL_Surface *);
void SDL_UnlockSurface(struct l_struct_2E_SDL_Surface *);
static unsigned int _ZNK6Canvas9readPixelEii(struct l_struct_2E_Canvas *llvm_cbe_this, unsigned int llvm_cbe_x, unsigned int llvm_cbe_y);
struct l_struct_2E_FILE *fopen(unsigned char *, unsigned char *);
unsigned long long fwrite(unsigned char *, unsigned long long , unsigned long long , struct l_struct_2E_FILE *);
unsigned int fclose(struct l_struct_2E_FILE *);
unsigned int SDL_UpperBlit(struct l_struct_2E_SDL_Surface *, struct l_struct_2E_SDL_Rect *, struct l_struct_2E_SDL_Surface *, struct l_struct_2E_SDL_Rect *);
unsigned int SDL_MapRGB(struct l_struct_2E_SDL_PixelFormat *, unsigned char , unsigned char , unsigned char );
static void _ZN6CanvasC1Eii(struct l_struct_2E_Canvas *llvm_cbe_this, unsigned int llvm_cbe_w, unsigned int llvm_cbe_h);
struct l_struct_2E_SDL_VideoInfo *SDL_GetVideoInfo(void);
struct l_struct_2E_SDL_Surface *SDL_CreateRGBSurface(unsigned int , unsigned int , unsigned int , unsigned int , unsigned int , unsigned int , unsigned int , unsigned int );
unsigned char *_Znwm(unsigned long long );
void SDL_GetRGB(unsigned int , struct l_struct_2E_SDL_PixelFormat *, unsigned char *, unsigned char *, unsigned char *);
static void _ZN4PathC1ERKS_(struct l_struct_2E_Path *llvm_cbe_this, struct l_struct_2E_Path *llvm_cbe_unnamed_arg);
static void _ZN4PathaSERKS_(struct l_struct_2E_Path *llvm_cbe_this, struct l_struct_2E_Path *llvm_cbe_unnamed_arg);
unsigned long long _ZNKSs6lengthEv(struct l_struct_2E_std_3A__3A_string *);
static void _ZN4Font4drawEP6Canvas4Vec2RKSsi(struct l_struct_2E_Font *llvm_cbe_this, struct l_struct_2E_Canvas *llvm_cbe_canvas, struct l_struct_2E_Vec2 *llvm_cbe_pt, struct l_struct_2E_std_3A__3A_string *llvm_cbe_text);
static struct l_struct_2E_std_3A__3A_string _ZN6Config8findFileERKSs(struct l_struct_2E_std_3A__3A_string *llvm_cbe_name);
unsigned char *fgets(unsigned char *, unsigned int , struct l_struct_2E_FILE *);
unsigned int _ZNKSs7compareERKSs(struct l_struct_2E_std_3A__3A_string *, struct l_struct_2E_std_3A__3A_string *);
unsigned int _ZNKSs7compareEPKc(struct l_struct_2E_std_3A__3A_string *, unsigned char *);
static unsigned int _ZN6Levels9findLevelEPKc(struct l_struct_2E_Levels *llvm_cbe_this, unsigned char *llvm_cbe_file);
static void _ZN7ZipFileC1ERKSs(struct l_struct_2E_ZipFile *llvm_cbe_this, struct l_struct_2E_std_3A__3A_string *llvm_cbe_fn);
static struct l_struct_2E_std_3A__3A_string _ZN7ZipFile9entryNameEi(struct l_struct_2E_ZipFile *llvm_cbe_this, unsigned int llvm_cbe_n);
unsigned long long _ZNKSs5rfindEcm(struct l_struct_2E_std_3A__3A_string *, signed char , unsigned long long );
struct l_struct_2E_std_3A__3A_string _ZNKSs6substrEmm(struct l_struct_2E_std_3A__3A_string *, unsigned long long , unsigned long long );
static unsigned int _ZL12rankFromPathRKSsi(struct l_struct_2E_std_3A__3A_string *llvm_cbe_p, unsigned int llvm_cbe_defaultrank);
unsigned char *_ZNKSs4dataEv(struct l_struct_2E_std_3A__3A_string *);
static unsigned int _ZN6Levels4loadEiPhi(struct l_struct_2E_Levels *llvm_cbe_this, unsigned int llvm_cbe_i);
unsigned long long fread(unsigned char *, unsigned long long , unsigned long long , struct l_struct_2E_FILE *);
static void _ZN5ArrayIPN6Levels9LevelDescEE14ensureCapacityEi(struct l_struct_2E_Array_3C_Levels_3A__3A_LevelDesc_2A__3E_ *llvm_cbe_this, unsigned int llvm_cbe_c);
static void _ZN6Levels8addLevelERKSsii(struct l_struct_2E_Levels *llvm_cbe_this, struct l_struct_2E_std_3A__3A_string *llvm_cbe_file, unsigned int llvm_cbe_rank, unsigned int llvm_cbe_index);
static void _ZN6Levels7addPathEPKc(struct l_struct_2E_Levels *llvm_cbe_this, unsigned char *llvm_cbe_path);
unsigned long long strlen(unsigned char *);
unsigned int strcasecmp(unsigned char *, unsigned char *);
struct l_struct_2E_DIR *opendir(unsigned char *);
struct l_struct_2E_std_3A__3A_string *_ZNSspLEPKc(struct l_struct_2E_std_3A__3A_string *, unsigned char *);
struct l_struct_2E_dirent *readdir(struct l_struct_2E_DIR *);
unsigned int closedir(struct l_struct_2E_DIR *);
void _ZNSsC1Ev(struct l_struct_2E_std_3A__3A_string *);
void _ZNSsC1EPKcmRKSaIcE(struct l_struct_2E_std_3A__3A_string *, unsigned char *, unsigned long long , struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ *);
void _ZdaPv(unsigned char *);
unsigned int munmap(unsigned char *, unsigned long long );
unsigned int close(unsigned int );
unsigned int open(unsigned char *, unsigned int , ...);
unsigned int fstat(unsigned int , struct l_struct_2E_stat *);
unsigned char *mmap(unsigned char *, unsigned long long , unsigned int , unsigned int , unsigned int , unsigned long long );
unsigned int inflateInit2_(struct l_struct_2E_z_stream *, unsigned int , unsigned char *, unsigned int );
unsigned int inflate(struct l_struct_2E_z_stream *, unsigned int );
unsigned int inflateEnd(struct l_struct_2E_z_stream *);
unsigned char *_Znam(unsigned long long );
static void _GLOBAL__I_levelbuf(void) __ATTRIBUTE_CTOR__;
static unsigned long long _Z5b2MulRK7b2Mat22RK6b2Vec2(struct l_struct_2E_b2AABB *llvm_cbe_A, struct l_struct_2E_b2Vec2 *llvm_cbe_v);
static void _ZN10b2ShapeDefD1Ev(struct l_struct_2E_b2ShapeDef *llvm_cbe_this);
static void _ZN10b2ShapeDefD0Ev(struct l_struct_2E_b2ShapeDef *llvm_cbe_this);
static void _ZN12b2PolygonDefD1Ev(struct l_struct_2E_b2PolygonDef *llvm_cbe_this);
static void _ZN12b2PolygonDefD0Ev(struct l_struct_2E_b2PolygonDef *llvm_cbe_this);
static void _ZN17b2ContactListener3AddEPK14b2ContactPoint(struct l_struct_2E_Os *llvm_cbe_this, struct l_struct_2E_b2ContactPoint *llvm_cbe_point);
static void _ZN17b2ContactListener7PersistEPK14b2ContactPoint(struct l_struct_2E_Os *llvm_cbe_this, struct l_struct_2E_b2ContactPoint *llvm_cbe_point);
static void _ZN17b2ContactListener6RemoveEPK14b2ContactPoint(struct l_struct_2E_Os *llvm_cbe_this, struct l_struct_2E_b2ContactPoint *llvm_cbe_point);
static void _ZN17b2ContactListener6ResultEPK15b2ContactResult(struct l_struct_2E_Os *llvm_cbe_this, struct l_struct_2E_b2ContactResult *llvm_cbe_point);
static struct l_struct_2E_Vec2 _ZNK4Rect8centroidEv(struct l_struct_2E_Rect *llvm_cbe_this);
static unsigned char _ZN11GameControl4saveEPKc(struct l_struct_2E_GameControl *llvm_cbe_this, unsigned char *llvm_cbe_file);
static unsigned char _ZN11GameControl4sendEv(struct l_struct_2E_GameControl *llvm_cbe_this);
static unsigned char _ZN11GameControl4loadEPKc(struct l_struct_2E_GameControl *llvm_cbe_this, unsigned char *llvm_cbe_file);
static void _ZN11GameControl9gotoLevelEib(struct l_struct_2E_GameControl *llvm_cbe_this, unsigned int llvm_cbe_l, unsigned char llvm_cbe_replay);
static void _ZN6Stroke6BoxDefD1Ev(struct l_struct_2E_Stroke_3A__3A_BoxDef *llvm_cbe_this);
static void _ZN6Stroke6BoxDefD0Ev(struct l_struct_2E_Stroke_3A__3A_BoxDef *llvm_cbe_this);
static void _ZN17b2ContactListenerD1Ev(struct l_struct_2E_Os *llvm_cbe_this);
static void _ZN17b2ContactListenerD0Ev(struct l_struct_2E_Os *llvm_cbe_this);
static struct l_struct_2E_Vec2 _ZN4Game10mousePointE9SDL_Event(unsigned long long llvm_cbe_ev_2e_0_2e_0, unsigned long long llvm_cbe_ev_2e_0_2e_1, unsigned long long llvm_cbe_ev_2e_0_2e_2);
static void __tcf_1(unsigned char *llvm_cbe_unnamed_arg);
static void __tcf_0(unsigned char *llvm_cbe_unnamed_arg);
static void _ZN5Scene3AddEPK14b2ContactPoint(struct l_struct_2E_Scene *llvm_cbe_this, struct l_struct_2E_b2ContactPoint *llvm_cbe_point);
static unsigned char _ZN5Scene11isCompletedEv(struct l_struct_2E_Scene *llvm_cbe_this);
float cosf(float );
float sinf(float );
static struct l_struct_2E_b2AABB _ZNK7b2Mat226InvertEv(struct l_struct_2E_b2AABB *llvm_cbe_this);
void __assert_fail(unsigned char *, unsigned char *, unsigned int , unsigned char *);
static void _ZN9Transform3setEffRK4Vec2(struct l_struct_2E_Transform *llvm_cbe_this, float llvm_cbe_scale, float llvm_cbe_rotation, struct l_struct_2E_Vec2 *llvm_cbe_translation);
void _ZNSt8ios_base4InitC1Ev(struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ *);
unsigned int __cxa_atexit(void  (*) (unsigned char *), unsigned char *, unsigned char *);
static void __tcf_2(unsigned char *llvm_cbe_unnamed_arg);
static void _Z24configureScreenTransformii(unsigned int llvm_cbe_w, unsigned int llvm_cbe_h);
void _ZNSt8ios_base4InitD1Ev(struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ *);
static void _ZN5ArrayIP6StrokeE6appendERKS1_(struct l_struct_2E_Array_3C_Stroke_2A__3E_ *llvm_cbe_this, struct l_struct_2E_Stroke **llvm_cbe_t);
static void _ZN4Game11showOverlayEP7Overlay(struct l_struct_2E_Game *llvm_cbe_this, struct l_struct_2E_Os *llvm_cbe_o);
static void _ZN7b2World11DestroyBodyEP6b2Body(struct l_struct_2E_b2World *llvm_cbe_this, struct l_struct_2E_b2Body *llvm_cbe_b);
static void _ZN5Scene5resetEP6Stroke(struct l_struct_2E_Scene *llvm_cbe_this, struct l_struct_2E_Stroke *llvm_cbe_s);
static void _ZN5Scene12deleteStrokeEP6Stroke(struct l_struct_2E_Scene *llvm_cbe_this, struct l_struct_2E_Stroke *llvm_cbe_s);
static void _ZN4Game11hideOverlayEP7Overlay(struct l_struct_2E_Game *llvm_cbe_this, struct l_struct_2E_Os *llvm_cbe_o);
static void _ZN5Scene5clearEv(struct l_struct_2E_Scene *llvm_cbe_this);
static void _ZN7b2World4StepEfi(struct l_struct_2E_b2World *llvm_cbe_this);
static void _ZN5SceneC1Eb(struct l_struct_2E_Scene *llvm_cbe_this, unsigned char llvm_cbe_noWorld);
static void _ZN5SceneD1Ev(struct l_struct_2E_Scene *llvm_cbe_this);
static void _ZN5SceneD0Ev(struct l_struct_2E_Scene *llvm_cbe_this);
static void _ZN11GameControlD0Ev(struct l_struct_2E_GameControl *llvm_cbe_this);
static void _ZN11GameControlD1Ev(struct l_struct_2E_GameControl *llvm_cbe_this);
void __cxa_pure_virtual(void);
static void _ZN6b2Body8SetXFormERK6b2Vec2f(struct l_struct_2E_b2Body *llvm_cbe_this, struct l_struct_2E_b2Vec2 *llvm_cbe_position, float llvm_cbe_angle);
float atan2f(float , float );
static unsigned char _ZN6Stroke9transformEv(struct l_struct_2E_Stroke *llvm_cbe_this);
static void _ZN6Stroke12createBodiesER7b2World(struct l_struct_2E_Stroke *llvm_cbe_this, struct l_struct_2E_b2World *llvm_cbe_world);
static struct l_struct_2E_b2Body *_ZN7b2World10CreateBodyEPK9b2BodyDef(struct l_struct_2E_b2World *llvm_cbe_this, struct l_struct_2E_b2BodyDef *llvm_cbe_def);
static float _ZN6Stroke10distanceToERK4Vec2(struct l_struct_2E_Stroke *llvm_cbe_this, struct l_struct_2E_Vec2 *llvm_cbe_pt);
static struct l_struct_2E_Stroke *_ZN5Scene13strokeAtPointE4Vec2f(struct l_struct_2E_Scene *llvm_cbe_this, struct l_struct_2E_Vec2 *llvm_cbe_pt);
static void _ZN6Stroke16maybeCreateJointER7b2WorldPS_(struct l_struct_2E_Stroke *llvm_cbe_this, struct l_struct_2E_b2World *llvm_cbe_world, struct l_struct_2E_Stroke *llvm_cbe_other);
static void _ZN5Scene12createJointsEP6Stroke(struct l_struct_2E_Scene *llvm_cbe_this, struct l_struct_2E_Stroke *llvm_cbe_s);
static void _ZN5Scene4stepEv(struct l_struct_2E_Scene *llvm_cbe_this);
static void _ZN7b2WorldD1Ev(struct l_struct_2E_b2World *llvm_cbe_this);
unsigned long long _ZNKSs4findEcm(struct l_struct_2E_std_3A__3A_string *, signed char , unsigned long long );
static unsigned char _ZN5Scene4loadERSi(struct l_struct_2E_Scene *llvm_cbe_this, struct l_struct_2E_std_3A__3A_istream *llvm_cbe_in);
struct l_struct_2E_std_3A__3A_istream *_ZSt7getlineIcSt11char_traitsIcESaIcEERSt13basic_istreamIT_T0_ES7_RSbIS4_S5_T1_E(struct l_struct_2E_std_3A__3A_istream *, struct l_struct_2E_std_3A__3A_string *);
unsigned char _ZNKSt9basic_iosIcSt11char_traitsIcEE3eofEv(struct l_struct_2E_std_3A__3A_basic_ios_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *);
void _ZNSt14basic_ifstreamIcSt11char_traitsIcEEC1EPKcSt13_Ios_Openmode(struct l_struct_2E_std_3A__3A_ifstream *, unsigned char *, unsigned int );
void _ZNSt14basic_ifstreamIcSt11char_traitsIcEED1Ev(struct l_struct_2E_std_3A__3A_ifstream *);
static void _ZN5Scene4drawER6CanvasRK4Rect(struct l_struct_2E_Scene *llvm_cbe_this, struct l_struct_2E_Canvas *llvm_cbe_canvas, struct l_struct_2E_Rect *llvm_cbe_area);
static unsigned char _ZN5Scene4loadEPhi(struct l_struct_2E_Scene *llvm_cbe_this, unsigned int llvm_cbe_bufsize);
void _ZNSt18basic_stringstreamIcSt11char_traitsIcESaIcEEC1ERKSsSt13_Ios_Openmode(struct l_struct_2E_std_3A__3A_stringstream *, struct l_struct_2E_std_3A__3A_string *, unsigned int );
void _ZNSt18basic_stringstreamIcSt11char_traitsIcESaIcEED1Ev(struct l_struct_2E_std_3A__3A_stringstream *);
static unsigned char _ZN4Game11renderSceneER6Canvasi(struct l_struct_2E_Game *llvm_cbe_this, struct l_struct_2E_Canvas *llvm_cbe_c, unsigned int llvm_cbe_level);
static struct l_struct_2E_std_3A__3A_string *_ZN6Config10planetRootEv(void);
unsigned int __cxa_guard_acquire(unsigned long long *);
void __cxa_guard_release(unsigned long long *);
void __cxa_guard_abort(unsigned long long *);
struct l_struct_2E_std_3A__3A_string *_ZNSs6appendERKSs(struct l_struct_2E_std_3A__3A_string *, struct l_struct_2E_std_3A__3A_string *);
static unsigned char _ZN4Game4sendEv(struct l_struct_2E_Game *llvm_cbe_this);
struct l_struct_2E_std_3A__3A_string *_ZNSs6appendEmc(struct l_struct_2E_std_3A__3A_string *, unsigned long long , signed char );
void _ZNSt18basic_stringstreamIcSt11char_traitsIcESaIcEEC1ESt13_Ios_Openmode(struct l_struct_2E_std_3A__3A_stringstream *, unsigned int );
struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *_ZStlsISt11char_traitsIcEERSt13basic_ostreamIcT_ES5_c(struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *, signed char );
struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *_ZNSolsEi(struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *, unsigned int );
struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *_ZStlsISt11char_traitsIcEERSt13basic_ostreamIcT_ES5_PKc(struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *, unsigned char *);
struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *_ZNSolsEPFRSoS_E(struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *, struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ * (*) (struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *));
struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *_ZSt4endlIcSt11char_traitsIcEERSt13basic_ostreamIT_T0_ES6_(struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *);
struct l_struct_2E_std_3A__3A_string _ZNKSt18basic_stringstreamIcSt11char_traitsIcESaIcEE3strEv(struct l_struct_2E_std_3A__3A_stringstream *);
void _ZNSt14basic_ofstreamIcSt11char_traitsIcEEC1EPKcSt13_Ios_Openmode(struct l_struct_2E_std_3A__3A_ofstream *, unsigned char *, unsigned int );
unsigned char _ZNSt14basic_ofstreamIcSt11char_traitsIcEE7is_openEv(struct l_struct_2E_std_3A__3A_ofstream *);
struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *_ZStlsIcSt11char_traitsIcESaIcEERSt13basic_ostreamIT_T0_ES7_RKSbIS4_S5_T1_E(struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *, struct l_struct_2E_std_3A__3A_string *);
void _ZNSt14basic_ofstreamIcSt11char_traitsIcEE5closeEv(struct l_struct_2E_std_3A__3A_ofstream *);
void _ZNSt14basic_ofstreamIcSt11char_traitsIcEED1Ev(struct l_struct_2E_std_3A__3A_ofstream *);
struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *_ZNSolsEt(struct l_struct_2E_std_3A__3A_basic_ostream_3C_char_2C_std_3A__3A_char_traits_3C_char_3E__20__3E_ *, unsigned short );
static void _ZN12DemoRecorder4stopEv(struct l_struct_2E_DemoRecorder *llvm_cbe_this);
static void _ZN4GameD1Ev(struct l_struct_2E_Game *llvm_cbe_this);
static void _ZN4GameD0Ev(struct l_struct_2E_Game *llvm_cbe_this);
static unsigned char _ZN4Game4saveEPKc(struct l_struct_2E_Game *llvm_cbe_this, unsigned char *llvm_cbe_file);
static void _ZN4Game9gotoLevelEib(struct l_struct_2E_Game *llvm_cbe_this, unsigned int llvm_cbe_level, unsigned char llvm_cbe_replay);
static struct l_struct_2E_std_3A__3A_string *_ZN6Config11userDataDirEv(void);
unsigned char *getenv(unsigned char *);
struct l_struct_2E_std_3A__3A_string *_ZNSsaSEPKc(struct l_struct_2E_std_3A__3A_string *, unsigned char *);
unsigned int SDL_GetTicks(void);
static void _ZN4Game3runEv(struct l_struct_2E_Game *llvm_cbe_this);
unsigned int SDL_PollEvent(struct l_struct_2E_SDL_Event *);
void SDL_Delay(unsigned int );
static void _Z4initb(unsigned char llvm_cbe_useDummyVideo);
unsigned int SDL_Init(unsigned int );
unsigned int mkdir(unsigned char *, unsigned int );
unsigned int puts(unsigned char *);
unsigned int *__errno_location(void);
unsigned int strcmp(unsigned char *, unsigned char *);
unsigned int stat(unsigned char *, struct l_struct_2E_stat *);
unsigned char *__cxa_begin_catch(unsigned char *);
void __cxa_end_catch(void);
static void _ZN7Overlay6onShowEv(struct l_struct_2E_Os *llvm_cbe_this);
static void _ZN7Overlay6onHideEv(struct l_struct_2E_Os *llvm_cbe_this);
static void _ZN7Overlay6onTickEi(struct l_struct_2E_Os *llvm_cbe_this, unsigned int llvm_cbe_tick);
static void _ZN7OverlayD1Ev(struct l_struct_2E_Os *llvm_cbe_this);
static void _ZN7OverlayD0Ev(struct l_struct_2E_Os *llvm_cbe_this);
static unsigned char _ZN11OverlayBase7isDirtyEv(struct l_struct_2E_OverlayBase *llvm_cbe_this);
static void _ZN11OverlayBase6onHideEv(struct l_struct_2E_OverlayBase *llvm_cbe_this);
static void _ZN11OverlayBase6onTickEi(struct l_struct_2E_OverlayBase *llvm_cbe_this, unsigned int llvm_cbe_tick);
static void _ZN11OverlayBase6onShowEv(struct l_struct_2E_OverlayBase *llvm_cbe_this);
static unsigned char _ZN11OverlayBase9onHotSpotEi(struct l_struct_2E_OverlayBase *llvm_cbe_this, unsigned int llvm_cbe_id);
static void _ZN9UiOverlay6onTickEi(struct l_struct_2E_UiOverlay *llvm_cbe_this, unsigned int llvm_cbe_tick);
static void _ZN11MenuOverlay7doPauseEv(struct l_struct_2E_MenuOverlay *llvm_cbe_this);
static void _ZN11MenuOverlay6onShowEv(struct l_struct_2E_MenuOverlay *llvm_cbe_this);
static void _ZN16NextLevelOverlay6onShowEv(struct l_struct_2E_NextLevelOverlay *llvm_cbe_this);
static void _ZN16NextLevelOverlay6onHideEv(struct l_struct_2E_NextLevelOverlay *llvm_cbe_this);
static void _ZN16NextLevelOverlay11doPrevLevelEv(struct l_struct_2E_NextLevelOverlay *llvm_cbe_this);
static void _ZN16NextLevelOverlay11doNextLevelEv(struct l_struct_2E_NextLevelOverlay *llvm_cbe_this);
static void _ZN16NextLevelOverlay14doActionReplayEv(struct l_struct_2E_NextLevelOverlay *llvm_cbe_this);
static void _ZN16NextLevelOverlay10doContinueEv(struct l_struct_2E_NextLevelOverlay *llvm_cbe_this);
static struct l_struct_2E_Rect _ZN11EditOverlay3posEi(unsigned int llvm_cbe_i);
static unsigned char _ZN11EditOverlay9onHotSpotEi(struct l_struct_2E_EditOverlay *llvm_cbe_this, unsigned int llvm_cbe_i);
static unsigned char _ZN11OverlayBase7onClickEii(struct l_struct_2E_OverlayBase *llvm_cbe_this, unsigned int llvm_cbe_x, unsigned int llvm_cbe_y);
static void _ZZN11OverlayBase10addHotSpotI16NextLevelOverlayEEvRK4RectMT_FvvEEN6Caller4callEPvM7OverlayFvvE(unsigned char *llvm_cbe_o, unsigned long long llvm_cbe_f_2e_0_2e_0, unsigned long long llvm_cbe_f_2e_0_2e_1);
static void _ZZN11OverlayBase10addHotSpotI11MenuOverlayEEvRK4RectMT_FvvEEN6Caller4callEPvM7OverlayFvvE(unsigned char *llvm_cbe_o, unsigned long long llvm_cbe_f_2e_0_2e_0, unsigned long long llvm_cbe_f_2e_0_2e_1);
static unsigned char _ZN11OverlayBase11handleEventER9SDL_Event(struct l_struct_2E_OverlayBase *llvm_cbe_this, struct l_struct_2E_SDL_Event *llvm_cbe_ev);
static struct l_struct_2E_Rect _ZN11OverlayBase9dirtyAreaEv(struct l_struct_2E_OverlayBase *llvm_cbe_this);
static void _ZN11OverlayBase4drawER6Canvas(struct l_struct_2E_OverlayBase *llvm_cbe_this, struct l_struct_2E_Canvas *llvm_cbe_screen);
static void _ZN11OverlayBaseD0Ev(struct l_struct_2E_OverlayBase *llvm_cbe_this);
static void _ZN11OverlayBaseD1Ev(struct l_struct_2E_OverlayBase *llvm_cbe_this);
static void _ZN11OverlayBaseD2Ev(struct l_struct_2E_OverlayBase *llvm_cbe_this);
static void _ZN9UiOverlayD0Ev(struct l_struct_2E_UiOverlay *llvm_cbe_this);
static void _ZN9UiOverlayD1Ev(struct l_struct_2E_UiOverlay *llvm_cbe_this);
static void _ZN11MenuOverlayD0Ev(struct l_struct_2E_MenuOverlay *llvm_cbe_this);
static void _ZN11MenuOverlayD1Ev(struct l_struct_2E_MenuOverlay *llvm_cbe_this);
static void _ZN11IconOverlayD0Ev(struct l_struct_2E_IconOverlay *llvm_cbe_this);
static void _ZN11IconOverlayD1Ev(struct l_struct_2E_IconOverlay *llvm_cbe_this);
static void _ZN11EditOverlayD0Ev(struct l_struct_2E_EditOverlay *llvm_cbe_this);
static void _ZN11EditOverlayD1Ev(struct l_struct_2E_EditOverlay *llvm_cbe_this);
static void _ZN11EditOverlay4drawER6Canvas(struct l_struct_2E_EditOverlay *llvm_cbe_this, struct l_struct_2E_Canvas *llvm_cbe_screen);
static void _ZN16NextLevelOverlayD0Ev(struct l_struct_2E_NextLevelOverlay *llvm_cbe_this);
static void _ZN16NextLevelOverlayD1Ev(struct l_struct_2E_NextLevelOverlay *llvm_cbe_this);
static void _ZN16NextLevelOverlay4drawER6Canvas(struct l_struct_2E_NextLevelOverlay *llvm_cbe_this, struct l_struct_2E_Canvas *llvm_cbe_screen);
static void _ZN11OverlayBaseC2ER11GameControliib(struct l_struct_2E_OverlayBase *llvm_cbe_this, struct l_struct_2E_GameControl *llvm_cbe_game, unsigned int llvm_cbe_x, unsigned int llvm_cbe_y, unsigned char llvm_cbe_dragging_allowed);
static void _ZN5ArrayIN11OverlayBase7HotSpotEE6appendERKS1_(struct l_struct_2E_Array_3C_OverlayBase_3A__3A_HotSpot_3E_ *llvm_cbe_this, struct l_struct_2E_OverlayBase_3A__3A_HotSpot *llvm_cbe_t);
static void _ZN11IconOverlayC2ER11GameControlPKciib(struct l_struct_2E_IconOverlay *llvm_cbe_this, struct l_struct_2E_GameControl *llvm_cbe_game, unsigned char *llvm_cbe_file, unsigned int llvm_cbe_x, unsigned int llvm_cbe_y);
static struct l_struct_2E_Font *_ZN6Config4fontEv(void);
static void _ZN11EditOverlay7outlineER6Canvasii(struct l_struct_2E_EditOverlay *llvm_cbe_this, struct l_struct_2E_Canvas *llvm_cbe_screen, unsigned int llvm_cbe_i, unsigned int llvm_cbe_c);
static void __tcf_270(unsigned char *llvm_cbe_unnamed_arg);
static void _ZL12http_post_cbPKN9happyhttp8ResponseEPvPKhi(struct l_struct_2E_happyhttp_3A__3A_Response *llvm_cbe_r, unsigned char *llvm_cbe_userdata, unsigned char *llvm_cbe_data, unsigned int llvm_cbe_numbytes);
unsigned int strncmp(unsigned char *, unsigned char *, unsigned long long );
unsigned char *strcpy(unsigned char *, unsigned char *);
unsigned char *strchr(unsigned char *, unsigned int );
unsigned int atoi(unsigned char *);
unsigned int fprintf(struct l_struct_2E_FILE *, unsigned char *, ...);
static void _ZL13http_begin_cbPKN9happyhttp8ResponseEPv(struct l_struct_2E_happyhttp_3A__3A_Response *llvm_cbe_r, unsigned char *llvm_cbe_userdata);
static void _ZL16http_complete_cbPKN9happyhttp8ResponseEPv(struct l_struct_2E_happyhttp_3A__3A_Response *llvm_cbe_r, unsigned char *llvm_cbe_userdata);
static void _ZN9happyhttp10ConnectionD1Ev(struct l_struct_2E_happyhttp_3A__3A_Connection *llvm_cbe_this);
unsigned char *__cxa_get_exception_ptr(unsigned char *);
static unsigned char *_ZNK9happyhttp8Response9getheaderEPKc(struct l_struct_2E_happyhttp_3A__3A_Response *llvm_cbe_this, unsigned char *llvm_cbe_name);
unsigned char _ZNKSs5emptyEv(struct l_struct_2E_std_3A__3A_string *);
struct l_struct_2E_std_3A__3A__Rb_tree_node_base *_ZSt18_Rb_tree_decrementPSt18_Rb_tree_node_base(struct l_struct_2E_std_3A__3A__Rb_tree_node_base *);
struct l_struct_2E_std_3A__3A__Rb_tree_node_base *_ZSt18_Rb_tree_incrementPSt18_Rb_tree_node_base(struct l_struct_2E_std_3A__3A__Rb_tree_node_base *);
void __cxa_rethrow(void);
static struct l_struct_2E_std_3A__3A_string *_ZSt22__uninitialized_copy_aIPSsS0_SsET0_T_S2_S1_SaIT1_E(struct l_struct_2E_std_3A__3A_string *llvm_cbe___first, struct l_struct_2E_std_3A__3A_string *llvm_cbe___last, struct l_struct_2E_std_3A__3A_string *llvm_cbe___result);
void _ZSt17__throw_bad_allocv(void);
static struct l_struct_2E_happyhttp_3A__3A_Response ***_ZNSt11_Deque_baseIPN9happyhttp8ResponseESaIS2_EE15_M_allocate_mapEm(struct l_struct_2E_std_3A__3A__Deque_base_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E_ *llvm_cbe_this, unsigned long long llvm_cbe___n);
static struct l_struct_2E_std_3A__3A__Rb_tree_node_base *_ZNSt8_Rb_treeISsSt4pairIKSsSsESt10_Select1stIS2_ESt4lessISsESaIS2_EE9_M_insertEPSt18_Rb_tree_node_baseSA_RKS2_(struct l_struct_2E_std_3A__3A__Rb_tree_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A__Select1st_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E_ *llvm_cbe_this, struct l_struct_2E_std_3A__3A__Rb_tree_node_base *llvm_cbe___x, struct l_struct_2E_std_3A__3A__Rb_tree_node_base *llvm_cbe___p, struct l_struct_2E_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E_ *llvm_cbe___v);
void _ZSt29_Rb_tree_insert_and_rebalancebPSt18_Rb_tree_node_baseS0_RS_(unsigned char , struct l_struct_2E_std_3A__3A__Rb_tree_node_base *, struct l_struct_2E_std_3A__3A__Rb_tree_node_base *, struct l_struct_2E_std_3A__3A__Rb_tree_node_base *);
static struct l_struct_2E_std_3A__3A_pair_3C_std_3A__3A__Rb_tree_iterator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_bool_3E_ _ZNSt8_Rb_treeISsSt4pairIKSsSsESt10_Select1stIS2_ESt4lessISsESaIS2_EE16_M_insert_uniqueERKS2_(struct l_struct_2E_std_3A__3A__Rb_tree_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A__Select1st_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E_ *llvm_cbe_this, struct l_struct_2E_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E_ *llvm_cbe___v);
static void _ZN9happyhttp8Response11FlushHeaderEv(struct l_struct_2E_happyhttp_3A__3A_Response *llvm_cbe_this);
unsigned int tolower(unsigned int );
struct l_struct_2E_std_3A__3A_string *_ZNSspLEc(struct l_struct_2E_std_3A__3A_string *, signed char );
void _ZNSs5clearEv(struct l_struct_2E_std_3A__3A_string *);
static void _ZNSt8_Rb_treeISsSt4pairIKSsSsESt10_Select1stIS2_ESt4lessISsESaIS2_EE8_M_eraseEPSt13_Rb_tree_nodeIS2_E(struct l_struct_2E_std_3A__3A__Rb_tree_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A__Select1st_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__2C_std_3A__3A_less_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E__20__3E_ *llvm_cbe_this, struct l_struct_2E_std_3A__3A__Rb_tree_node_3C_std_3A__3A_pair_3C_const_20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C__20_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_ *llvm_cbe___x);
static void _ZN9happyhttp8ResponseD1Ev(struct l_struct_2E_happyhttp_3A__3A_Response *llvm_cbe_this);
static void _ZNSt5dequeIPN9happyhttp8ResponseESaIS2_EE9pop_frontEv(struct l_struct_2E_std_3A__3A_deque_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E_ *llvm_cbe_this);
static void _ZNSt12_Vector_baseISsSaISsEED2Ev(struct l_struct_2E_std_3A__3A__Vector_base_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_ *llvm_cbe_this);
static void _ZNSt6vectorISsSaISsEED1Ev(struct l_struct_2E_std_3A__3A_vector_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_ *llvm_cbe_this);
static void _ZNSt11_Deque_baseIPN9happyhttp8ResponseESaIS2_EED2Ev(struct l_struct_2E_std_3A__3A__Deque_base_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E_ *llvm_cbe_this);
static void _ZNSt5dequeIPN9happyhttp8ResponseESaIS2_EED1Ev(struct l_struct_2E_std_3A__3A_deque_3C_happyhttp_3A__3A_Response_2A__2C_std_3A__3A_allocator_3C_happyhttp_3A__3A_Response_2A__3E__20__3E_ *llvm_cbe_this);
unsigned long long strtol(unsigned char *, unsigned char **, unsigned int );
unsigned char *_ZNSs5beginEv(struct l_struct_2E_std_3A__3A_string *);
unsigned char *_ZNSs3endEv(struct l_struct_2E_std_3A__3A_string *);
unsigned int isspace(unsigned int );
static void _ZNSt6vectorISsSaISsEE9push_backERKSs(struct l_struct_2E_std_3A__3A_vector_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__2C_std_3A__3A_allocator_3C_std_3A__3A_basic_string_3C_char_2C__20_std_3A__3A_char_traits_3C_char_3E__2C__20_std_3A__3A_allocator_3C_char_3E__20__3E__20__3E__20__3E_ *llvm_cbe_this, struct l_struct_2E_std_3A__3A_string *llvm_cbe___x);
static void _ZSt4copyIPPPN9happyhttp8ResponseES4_ET0_T_S6_S5_(struct l_struct_2E_happyhttp_3A__3A_Response ***llvm_cbe___first, struct l_struct_2E_happyhttp_3A__3A_Response ***llvm_cbe___last, struct l_struct_2E_happyhttp_3A__3A_Response ***llvm_cbe___result);
static void _ZN9happyhttp10Connection5closeEv(struct l_struct_2E_happyhttp_3A__3A_Connection *llvm_cbe_this);
static void _ZN9happyhttp6WobblyC1EPKcz(struct l_struct_2E_happyhttp_3A__3A_Wobbly *llvm_cbe_this, unsigned char *llvm_cbe_fmt, ...);
unsigned int vsnprintf(unsigned char *, unsigned long long , unsigned char *, struct l_struct_2E___va_list_tag *);
unsigned int _ZNKSs7compareEmmPKc(struct l_struct_2E_std_3A__3A_string *, unsigned long long , unsigned long long , unsigned char *);
static void _ZN9happyhttp10Connection9putheaderEPKcS2_(struct l_struct_2E_happyhttp_3A__3A_Connection *llvm_cbe_this, unsigned char *llvm_cbe_header, unsigned char *llvm_cbe_value);
unsigned int sprintf(unsigned char *, unsigned char *, ...);
unsigned int inet_addr(unsigned char *);
struct l_struct_2E_hostent *gethostbyname(unsigned char *);
unsigned char *strerror(unsigned int );
unsigned short htons(unsigned short );
unsigned int socket(unsigned int , unsigned int , unsigned int );
unsigned int connect(unsigned int , struct l_struct_2E_sockaddr *, unsigned int );
static void _ZN9happyhttp10Connection4sendEPKhi(struct l_struct_2E_happyhttp_3A__3A_Connection *llvm_cbe_this, unsigned char *llvm_cbe_buf, unsigned int llvm_cbe_numbytes);
unsigned long long send(unsigned int , unsigned char *, unsigned long long , unsigned int );
struct l_struct_2E_std_3A__3A_string *_ZNSspLERKSs(struct l_struct_2E_std_3A__3A_string *, struct l_struct_2E_std_3A__3A_string *);
unsigned int select(unsigned int , struct l_struct_2E_fd_set *, struct l_struct_2E_fd_set *, struct l_struct_2E_fd_set *, struct l_struct_2E_timespec *);
unsigned long long recv(unsigned int , unsigned char *, unsigned long long , unsigned int );
unsigned int SDL_SetAlpha(struct l_struct_2E_SDL_Surface *, unsigned int , unsigned char );
unsigned int SDL_SetColorKey(struct l_struct_2E_SDL_Surface *, unsigned int , unsigned int );
static void _ZN2Os4pollEv(struct l_struct_2E_Os *llvm_cbe_this);
static unsigned char *_ZN2Os13getLaunchFileEv(struct l_struct_2E_Os *llvm_cbe_this);
static unsigned char *_ZN13OsFreeDesktop10saveDialogEPKc(struct l_struct_2E_OsFreeDesktop *llvm_cbe_this, unsigned char *llvm_cbe_path);
static unsigned char _ZN13OsFreeDesktop11openBrowserEPKc(struct l_struct_2E_OsFreeDesktop *llvm_cbe_this, unsigned char *llvm_cbe_url);
unsigned int main(unsigned int llvm_cbe_argc, unsigned char **llvm_cbe_argv);
unsigned int system(unsigned char *);
static unsigned long long _Z6b2MulTRK7b2Mat22RK6b2Vec2(struct l_struct_2E_b2AABB *llvm_cbe_A, struct l_struct_2E_b2Vec2 *llvm_cbe_v);
static unsigned long long _Z5b2MulRK7b2XFormRK6b2Vec2(struct l_struct_2E_b2XForm *llvm_cbe_T, struct l_struct_2E_b2Vec2 *llvm_cbe_v);
static unsigned long long _Z5b2AbsRK6b2Vec2(struct l_struct_2E_b2Vec2 *llvm_cbe_a);
static unsigned char _ZNK14b2PolygonShape9TestPointERK7b2XFormRK6b2Vec2(struct l_struct_2E_b2PolygonShape *llvm_cbe_this, struct l_struct_2E_b2XForm *llvm_cbe_xf, struct l_struct_2E_b2Vec2 *llvm_cbe_p);
static void _ZNK14b2PolygonShape11ComputeAABBEP6b2AABBRK7b2XForm(struct l_struct_2E_b2PolygonShape *llvm_cbe_this, struct l_struct_2E_b2AABB *llvm_cbe_aabb, struct l_struct_2E_b2XForm *llvm_cbe_xf);
static unsigned long long _ZNK14b2PolygonShape7SupportERK7b2XFormRK6b2Vec2(struct l_struct_2E_b2PolygonShape *llvm_cbe_this, struct l_struct_2E_b2XForm *llvm_cbe_xf, struct l_struct_2E_b2Vec2 *llvm_cbe_d);
static unsigned long long _Z5b2MinRK6b2Vec2S1_(struct l_struct_2E_b2Vec2 *llvm_cbe_a, struct l_struct_2E_b2Vec2 *llvm_cbe_b);
static unsigned long long _Z5b2MaxRK6b2Vec2S1_(struct l_struct_2E_b2Vec2 *llvm_cbe_a, struct l_struct_2E_b2Vec2 *llvm_cbe_b);
static void _ZNK14b2PolygonShape16ComputeSweptAABBEP6b2AABBRK7b2XFormS4_(struct l_struct_2E_b2PolygonShape *llvm_cbe_this, struct l_struct_2E_b2AABB *llvm_cbe_aabb, struct l_struct_2E_b2XForm *llvm_cbe_transform1, struct l_struct_2E_b2XForm *llvm_cbe_transform2);
static void _ZN14b2PolygonShapeD0Ev(struct l_struct_2E_b2PolygonShape *llvm_cbe_this);
static unsigned char _ZNK14b2PolygonShape11TestSegmentERK7b2XFormPfP6b2Vec2RK9b2Segmentf(struct l_struct_2E_b2PolygonShape *llvm_cbe_this, struct l_struct_2E_b2XForm *llvm_cbe_xf, float *llvm_cbe_lambda, struct l_struct_2E_b2Vec2 *llvm_cbe_normal, struct l_struct_2E_b2AABB *llvm_cbe_segment, float llvm_cbe_maxLambda);
static void _ZNK14b2PolygonShape11ComputeMassEP10b2MassData(struct l_struct_2E_b2PolygonShape *llvm_cbe_this, struct l_struct_2E_b2MassData *llvm_cbe_massData);
static void _ZN14b2PolygonShapeD1Ev(struct l_struct_2E_b2PolygonShape *llvm_cbe_this);
static void _ZN14b2PolygonShape17UpdateSweepRadiusERK6b2Vec2(struct l_struct_2E_b2PolygonShape *llvm_cbe_this, struct l_struct_2E_b2Vec2 *llvm_cbe_center);
static unsigned long long _ZNK7b2Mat225SolveERK6b2Vec2(struct l_struct_2E_b2AABB *llvm_cbe_this, struct l_struct_2E_b2Vec2 *llvm_cbe_b);
static struct l_struct_2E_b2AABB _ZplRK7b2Mat22S1_(struct l_struct_2E_b2AABB *llvm_cbe_A, struct l_struct_2E_b2AABB *llvm_cbe_B);
static unsigned long long _Z6b2MulTRK7b2XFormRK6b2Vec2(struct l_struct_2E_b2XForm *llvm_cbe_T, struct l_struct_2E_b2Vec2 *llvm_cbe_v);
static void _ZN7b2Joint23InitPositionConstraintsEv(struct l_struct_2E_b2Joint *llvm_cbe_this);
static unsigned long long _ZNK15b2RevoluteJoint10GetAnchor1Ev(struct l_struct_2E_b2RevoluteJoint *llvm_cbe_this);
static unsigned long long _ZNK15b2RevoluteJoint10GetAnchor2Ev(struct l_struct_2E_b2RevoluteJoint *llvm_cbe_this);
static unsigned long long _ZNK15b2RevoluteJoint16GetReactionForceEv(struct l_struct_2E_b2RevoluteJoint *llvm_cbe_this);
static float _ZNK15b2RevoluteJoint17GetReactionTorqueEv(struct l_struct_2E_b2RevoluteJoint *llvm_cbe_this);
static void _ZN15b2RevoluteJoint24SolveVelocityConstraintsERK10b2TimeStep(struct l_struct_2E_b2RevoluteJoint *llvm_cbe_this, struct l_struct_2E_b2TimeStep *llvm_cbe_step);
static void _ZN7b2JointD1Ev(struct l_struct_2E_b2Joint *llvm_cbe_this);
static void _ZN7b2JointD0Ev(struct l_struct_2E_b2Joint *llvm_cbe_this);
static void _ZN15b2RevoluteJointD0Ev(struct l_struct_2E_b2RevoluteJoint *llvm_cbe_this);
static void _ZN15b2RevoluteJointD1Ev(struct l_struct_2E_b2RevoluteJoint *llvm_cbe_this);
static void _ZN15b2RevoluteJoint23InitVelocityConstraintsERK10b2TimeStep(struct l_struct_2E_b2RevoluteJoint *llvm_cbe_this, struct l_struct_2E_b2TimeStep *llvm_cbe_step);
static unsigned char _ZN15b2RevoluteJoint24SolvePositionConstraintsEv(struct l_struct_2E_b2RevoluteJoint *llvm_cbe_this);
static void _ZN6b2Body20SynchronizeTransformEv(struct l_struct_2E_b2Body *llvm_cbe_this);
static unsigned char _ZN6b2Body17SynchronizeShapesEv(struct l_struct_2E_b2Body *llvm_cbe_this);
static unsigned char _ZN7b2Shape11SynchronizeEP12b2BroadPhaseRK7b2XFormS4_(struct l_struct_2E_b2Shape *llvm_cbe_this, struct l_struct_2E_b2BroadPhase *llvm_cbe_broadPhase, struct l_struct_2E_b2XForm *llvm_cbe_transform1, struct l_struct_2E_b2XForm *llvm_cbe_transform2);
static void _ZN9b2ContactD1Ev(struct l_struct_2E_b2Contact *llvm_cbe_this);
static void _ZN9b2ContactD0Ev(struct l_struct_2E_b2Contact *llvm_cbe_this);
static struct l_struct_2E_b2Manifold *_ZN13b2NullContact12GetManifoldsEv(struct l_struct_2E_b2NullContact *llvm_cbe_this);
static void _ZN13b2NullContactD1Ev(struct l_struct_2E_b2NullContact *llvm_cbe_this);
static void _ZN13b2NullContactD0Ev(struct l_struct_2E_b2NullContact *llvm_cbe_this);
static void _ZN13b2NullContact8EvaluateEP17b2ContactListener(struct l_struct_2E_b2NullContact *llvm_cbe_this, struct l_struct_2E_Os *llvm_cbe_unnamed_arg);
static void _ZN14b2PairCallbackD1Ev(struct l_struct_2E_Os *llvm_cbe_this);
static void _ZN14b2PairCallbackD0Ev(struct l_struct_2E_Os *llvm_cbe_this);
static void _ZN7b2World9DrawShapeEP7b2ShapeRK7b2XFormRK7b2Colorb(struct l_struct_2E_b2World *llvm_cbe_this, struct l_struct_2E_b2Shape *llvm_cbe_shape, struct l_struct_2E_b2XForm *llvm_cbe_xf, struct l_struct_2E_b2Color *llvm_cbe_color, unsigned char llvm_cbe_core);
static unsigned char *_ZN16b2StackAllocator8AllocateEi(struct l_struct_2E_b2StackAllocator *llvm_cbe_this, unsigned int llvm_cbe_size);
static void _ZN16b2StackAllocator4FreeEPv(struct l_struct_2E_b2StackAllocator *llvm_cbe_this, unsigned char *llvm_cbe_p);
static void _ZN7b2Sweep7AdvanceEf(struct l_struct_2E_b2Sweep *llvm_cbe_this, float llvm_cbe_t);
static void _ZN9b2Contact6UpdateEP17b2ContactListener(struct l_struct_2E_b2Contact *llvm_cbe_this, struct l_struct_2E_Os *llvm_cbe_listener);
static unsigned char *_ZN16b2BlockAllocator8AllocateEi(struct l_struct_2E_b2BlockAllocator *llvm_cbe_this, unsigned int llvm_cbe_size);
static void _ZN16b2ContactManagerD1Ev(struct l_struct_2E_b2ContactManager *llvm_cbe_this);
static void _ZN16b2BlockAllocatorD1Ev(struct l_struct_2E_b2BlockAllocator *llvm_cbe_this);
static void _ZNK7b2Sweep8GetXFormEP7b2XFormf(struct l_struct_2E_b2Sweep *llvm_cbe_this, struct l_struct_2E_b2XForm *llvm_cbe_xf, float llvm_cbe_t);
static void _ZN7b2ShapeD1Ev(struct l_struct_2E_b2Shape *llvm_cbe_this);
static void _ZN7b2ShapeD0Ev(struct l_struct_2E_b2Shape *llvm_cbe_this);
static unsigned char _ZNK12b2BroadPhase7InRangeERK6b2AABB(struct l_struct_2E_b2BroadPhase *llvm_cbe_this, struct l_struct_2E_b2AABB *llvm_cbe_aabb);
static void _ZN12b2BroadPhase12DestroyProxyEi(struct l_struct_2E_b2BroadPhase *llvm_cbe_this, unsigned int llvm_cbe_proxyId);
static unsigned short _ZN12b2BroadPhase11CreateProxyERK6b2AABBPv(struct l_struct_2E_b2BroadPhase *llvm_cbe_this, struct l_struct_2E_b2AABB *llvm_cbe_aabb, unsigned char *llvm_cbe_userData);
static unsigned char *_ZN16b2ContactManager9PairAddedEPvS0_(struct l_struct_2E_b2ContactManager *llvm_cbe_this, unsigned char *llvm_cbe_proxyUserData1, unsigned char *llvm_cbe_proxyUserData2);
static unsigned long long _ZNK6b2Body31GetLinearVelocityFromLocalPointERK6b2Vec2(struct l_struct_2E_b2Body *llvm_cbe_this, struct l_struct_2E_b2Vec2 *llvm_cbe_localPoint);
static void _ZN16b2ContactManagerD0Ev(struct l_struct_2E_b2ContactManager *llvm_cbe_this);
static void _ZN16b2ContactManager11PairRemovedEPvS0_S0_(struct l_struct_2E_b2ContactManager *llvm_cbe_this, unsigned char *llvm_cbe_proxyUserData1, unsigned char *llvm_cbe_proxyUserData2, unsigned char *llvm_cbe_pairUserData);
static unsigned int _ZL12BinarySearchP7b2Boundit(struct l_struct_2E_b2Bound *llvm_cbe_bounds, unsigned int llvm_cbe_count, unsigned short llvm_cbe_value);
static void _ZN12b2BroadPhase5QueryEPiS0_ttP7b2Boundii(struct l_struct_2E_b2BroadPhase *llvm_cbe_this, unsigned int *llvm_cbe_lowerQueryOut, unsigned int *llvm_cbe_upperQueryOut, unsigned short llvm_cbe_lowerValue, unsigned short llvm_cbe_upperValue, struct l_struct_2E_b2Bound *llvm_cbe_bounds, unsigned int llvm_cbe_boundCount, unsigned int llvm_cbe_axis);
static void _ZN12b2BroadPhase13ComputeBoundsEPtS0_RK6b2AABB(struct l_struct_2E_b2BroadPhase *llvm_cbe_this, unsigned short *llvm_cbe_lowerValues, unsigned short *llvm_cbe_upperValues, struct l_struct_2E_b2AABB *llvm_cbe_aabb);
static unsigned char _ZN12b2BroadPhase11TestOverlapERK13b2BoundValuesP7b2Proxy(struct l_struct_2E_b2BroadPhase *llvm_cbe_this, struct l_struct_2E_b2BoundValues *llvm_cbe_b, struct l_struct_2E_b2Proxy *llvm_cbe_p);
static void _ZN13b2PairManager6CommitEv(struct l_struct_2E_b2PairManager *llvm_cbe_this);
unsigned int finite(double );
static unsigned char _ZNK6b2AABB7IsValidEv(struct l_struct_2E_b2AABB *llvm_cbe_this);
static void _ZN13b2PairManager15AddBufferedPairEii(struct l_struct_2E_b2PairManager *llvm_cbe_this, unsigned int llvm_cbe_id1, unsigned int llvm_cbe_id2);
static void _ZN13b2PairManager18RemoveBufferedPairEii(struct l_struct_2E_b2PairManager *llvm_cbe_this, unsigned int llvm_cbe_id1, unsigned int llvm_cbe_id2);
static void _ZN8b2Island6ReportEP19b2ContactConstraint(struct l_struct_2E_b2Island *llvm_cbe_this, struct l_struct_2E_b2ContactConstraint *llvm_cbe_constraints);
static void _ZN15b2ContactSolverC1ERK10b2TimeStepPP9b2ContactiP16b2StackAllocator(struct l_struct_2E_b2ContactSolver *llvm_cbe_this, struct l_struct_2E_b2TimeStep *llvm_cbe_step, struct l_struct_2E_b2Contact **llvm_cbe_contacts, unsigned int llvm_cbe_contactCount, struct l_struct_2E_b2StackAllocator *llvm_cbe_allocator);
static void _ZN15b2ContactSolver24SolveVelocityConstraintsEv(struct l_struct_2E_b2ContactSolver *llvm_cbe_this);
static unsigned char _ZN15b2ContactSolver24SolvePositionConstraintsEf(struct l_struct_2E_b2ContactSolver *llvm_cbe_this, float llvm_cbe_baumgarte);
static void _ZN9b2ContactC2EP7b2ShapeS1_(struct l_struct_2E_b2Contact *llvm_cbe_this, struct l_struct_2E_b2Shape *llvm_cbe_s1, struct l_struct_2E_b2Shape *llvm_cbe_s2);
static struct l_struct_2E_b2Contact *_ZN15b2CircleContact6CreateEP7b2ShapeS1_P16b2BlockAllocator(struct l_struct_2E_b2Shape *llvm_cbe_shape1, struct l_struct_2E_b2Shape *llvm_cbe_shape2, struct l_struct_2E_b2BlockAllocator *llvm_cbe_allocator);
static void _ZN15b2CircleContact7DestroyEP9b2ContactP16b2BlockAllocator(struct l_struct_2E_b2Contact *llvm_cbe_contact, struct l_struct_2E_b2BlockAllocator *llvm_cbe_allocator);
static struct l_struct_2E_b2Contact *_ZN22b2PolyAndCircleContact6CreateEP7b2ShapeS1_P16b2BlockAllocator(struct l_struct_2E_b2Shape *llvm_cbe_shape1, struct l_struct_2E_b2Shape *llvm_cbe_shape2, struct l_struct_2E_b2BlockAllocator *llvm_cbe_allocator);
static void _ZN22b2PolyAndCircleContact7DestroyEP9b2ContactP16b2BlockAllocator(struct l_struct_2E_b2Contact *llvm_cbe_contact, struct l_struct_2E_b2BlockAllocator *llvm_cbe_allocator);
static struct l_struct_2E_b2Contact *_ZN16b2PolygonContact6CreateEP7b2ShapeS1_P16b2BlockAllocator(struct l_struct_2E_b2Shape *llvm_cbe_shape1, struct l_struct_2E_b2Shape *llvm_cbe_shape2, struct l_struct_2E_b2BlockAllocator *llvm_cbe_allocator);
static void _ZN16b2PolygonContact7DestroyEP9b2ContactP16b2BlockAllocator(struct l_struct_2E_b2Contact *llvm_cbe_contact, struct l_struct_2E_b2BlockAllocator *llvm_cbe_allocator);
static void _GLOBAL__I_b2_defaultFilter(void) __ATTRIBUTE_CTOR__;
static unsigned char _ZN15b2ContactFilter13ShouldCollideEP7b2ShapeS1_(struct l_struct_2E_Os *llvm_cbe_this, struct l_struct_2E_b2Shape *llvm_cbe_shape1, struct l_struct_2E_b2Shape *llvm_cbe_shape2);
static void _ZN15b2ContactFilterD1Ev(struct l_struct_2E_Os *llvm_cbe_this);
static void _ZN15b2ContactFilterD0Ev(struct l_struct_2E_Os *llvm_cbe_this);
static void __tcf_0219(unsigned char *llvm_cbe_unnamed_arg);
static unsigned long long _ZNK13b2PulleyJoint10GetAnchor1Ev(struct l_struct_2E_b2PulleyJoint *llvm_cbe_this);
static unsigned long long _ZNK13b2PulleyJoint10GetAnchor2Ev(struct l_struct_2E_b2PulleyJoint *llvm_cbe_this);
static unsigned long long _ZNK13b2PulleyJoint16GetReactionForceEv(struct l_struct_2E_b2PulleyJoint *llvm_cbe_this);
static float _ZNK13b2PulleyJoint17GetReactionTorqueEv(struct l_struct_2E_b2PulleyJoint *llvm_cbe_this);
static void _ZN13b2PulleyJoint24SolveVelocityConstraintsERK10b2TimeStep(struct l_struct_2E_b2PulleyJoint *llvm_cbe_this, struct l_struct_2E_b2TimeStep *llvm_cbe_step);
static void _ZN13b2PulleyJointD0Ev(struct l_struct_2E_b2PulleyJoint *llvm_cbe_this);
static void _ZN13b2PulleyJointD1Ev(struct l_struct_2E_b2PulleyJoint *llvm_cbe_this);
static void _ZN13b2PulleyJoint23InitVelocityConstraintsERK10b2TimeStep(struct l_struct_2E_b2PulleyJoint *llvm_cbe_this, struct l_struct_2E_b2TimeStep *llvm_cbe_step);
static unsigned char _ZN13b2PulleyJoint24SolvePositionConstraintsEv(struct l_struct_2E_b2PulleyJoint *llvm_cbe_this);
static float _ZN10b2Jacobian7ComputeERK6b2Vec2fS2_f(struct l_struct_2E_b2Jacobian *llvm_cbe_this, struct l_struct_2E_b2Vec2 *llvm_cbe_x1, float llvm_cbe_a1, struct l_struct_2E_b2Vec2 *llvm_cbe_x2, float llvm_cbe_a2);
static void _ZN11b2GearJoint24SolveVelocityConstraintsERK10b2TimeStep(struct l_struct_2E_b2GearJoint *llvm_cbe_this, struct l_struct_2E_b2TimeStep *llvm_cbe_step);
static unsigned long long _ZNK11b2GearJoint10GetAnchor1Ev(struct l_struct_2E_b2GearJoint *llvm_cbe_this);
static unsigned long long _ZNK11b2GearJoint10GetAnchor2Ev(struct l_struct_2E_b2GearJoint *llvm_cbe_this);
static unsigned long long _ZNK11b2GearJoint16GetReactionForceEv(struct l_struct_2E_b2GearJoint *llvm_cbe_this);
static float _ZNK11b2GearJoint17GetReactionTorqueEv(struct l_struct_2E_b2GearJoint *llvm_cbe_this);
static void _ZN11b2GearJointD0Ev(struct l_struct_2E_b2GearJoint *llvm_cbe_this);
static void _ZN11b2GearJointD1Ev(struct l_struct_2E_b2GearJoint *llvm_cbe_this);
static void _ZN11b2GearJoint23InitVelocityConstraintsERK10b2TimeStep(struct l_struct_2E_b2GearJoint *llvm_cbe_this, struct l_struct_2E_b2TimeStep *llvm_cbe_step);
static unsigned char _ZN11b2GearJoint24SolvePositionConstraintsEv(struct l_struct_2E_b2GearJoint *llvm_cbe_this);
static float _ZNK16b2PrismaticJoint19GetJointTranslationEv(struct l_struct_2E_b2PrismaticJoint *llvm_cbe_this);
static unsigned char _ZL8InPointsRK6b2Vec2PS0_i(struct l_struct_2E_b2Vec2 *llvm_cbe_w, struct l_struct_2E_b2Vec2 *llvm_cbe_points, unsigned int llvm_cbe_pointCount);
static unsigned int _ZL10ProcessTwoP6b2Vec2S0_S0_S0_S0_(struct l_struct_2E_b2Vec2 *llvm_cbe_x1, struct l_struct_2E_b2Vec2 *llvm_cbe_x2, struct l_struct_2E_b2Vec2 *llvm_cbe_p1s, struct l_struct_2E_b2Vec2 *llvm_cbe_p2s, struct l_struct_2E_b2Vec2 *llvm_cbe_points);
static unsigned int _ZL12ProcessThreeP6b2Vec2S0_S0_S0_S0_(struct l_struct_2E_b2Vec2 *llvm_cbe_x1, struct l_struct_2E_b2Vec2 *llvm_cbe_x2, struct l_struct_2E_b2Vec2 *llvm_cbe_p1s, struct l_struct_2E_b2Vec2 *llvm_cbe_p2s, struct l_struct_2E_b2Vec2 *llvm_cbe_points);
static float _ZL10DistancePCP6b2Vec2S0_PK14b2PolygonShapeRK7b2XFormPK13b2CircleShapeS6_(struct l_struct_2E_b2Vec2 *llvm_cbe_x1, struct l_struct_2E_b2Vec2 *llvm_cbe_x2, struct l_struct_2E_b2PolygonShape *llvm_cbe_polygon, struct l_struct_2E_b2XForm *llvm_cbe_xf1, struct l_struct_2E_b2CircleShape *llvm_cbe_circle, struct l_struct_2E_b2XForm *llvm_cbe_xf2);
static unsigned char _ZN12b2MouseJoint24SolvePositionConstraintsEv(struct l_struct_2E_b2MouseJoint *llvm_cbe_this);
static unsigned long long _ZNK12b2MouseJoint10GetAnchor1Ev(struct l_struct_2E_b2MouseJoint *llvm_cbe_this);
static unsigned long long _ZNK12b2MouseJoint10GetAnchor2Ev(struct l_struct_2E_b2MouseJoint *llvm_cbe_this);
static unsigned long long _ZNK12b2MouseJoint16GetReactionForceEv(struct l_struct_2E_b2MouseJoint *llvm_cbe_this);
static float _ZNK12b2MouseJoint17GetReactionTorqueEv(struct l_struct_2E_b2MouseJoint *llvm_cbe_this);
static void _ZN12b2MouseJointD0Ev(struct l_struct_2E_b2MouseJoint *llvm_cbe_this);
static void _ZN12b2MouseJointD1Ev(struct l_struct_2E_b2MouseJoint *llvm_cbe_this);
static void _ZN12b2MouseJoint23InitVelocityConstraintsERK10b2TimeStep(struct l_struct_2E_b2MouseJoint *llvm_cbe_this, struct l_struct_2E_b2TimeStep *llvm_cbe_step);
static void _ZN12b2MouseJoint24SolveVelocityConstraintsERK10b2TimeStep(struct l_struct_2E_b2MouseJoint *llvm_cbe_this, struct l_struct_2E_b2TimeStep *llvm_cbe_step);
static unsigned char _ZNK13b2CircleShape9TestPointERK7b2XFormRK6b2Vec2(struct l_struct_2E_b2CircleShape *llvm_cbe_this, struct l_struct_2E_b2XForm *llvm_cbe_transform, struct l_struct_2E_b2Vec2 *llvm_cbe_p);
static void _ZNK13b2CircleShape11ComputeAABBEP6b2AABBRK7b2XForm(struct l_struct_2E_b2CircleShape *llvm_cbe_this, struct l_struct_2E_b2AABB *llvm_cbe_aabb, struct l_struct_2E_b2XForm *llvm_cbe_transform);
static void _ZNK13b2CircleShape11ComputeMassEP10b2MassData(struct l_struct_2E_b2CircleShape *llvm_cbe_this, struct l_struct_2E_b2MassData *llvm_cbe_massData);
static void _ZNK13b2CircleShape16ComputeSweptAABBEP6b2AABBRK7b2XFormS4_(struct l_struct_2E_b2CircleShape *llvm_cbe_this, struct l_struct_2E_b2AABB *llvm_cbe_aabb, struct l_struct_2E_b2XForm *llvm_cbe_transform1, struct l_struct_2E_b2XForm *llvm_cbe_transform2);
static void _ZN13b2CircleShapeD0Ev(struct l_struct_2E_b2CircleShape *llvm_cbe_this);
static unsigned char _ZNK13b2CircleShape11TestSegmentERK7b2XFormPfP6b2Vec2RK9b2Segmentf(struct l_struct_2E_b2CircleShape *llvm_cbe_this, struct l_struct_2E_b2XForm *llvm_cbe_transform, float *llvm_cbe_lambda, struct l_struct_2E_b2Vec2 *llvm_cbe_normal, struct l_struct_2E_b2AABB *llvm_cbe_segment, float llvm_cbe_maxLambda);
static void _ZN13b2CircleShapeD1Ev(struct l_struct_2E_b2CircleShape *llvm_cbe_this);
static void _ZN13b2CircleShape17UpdateSweepRadiusERK6b2Vec2(struct l_struct_2E_b2CircleShape *llvm_cbe_this, struct l_struct_2E_b2Vec2 *llvm_cbe_center);
static struct l_struct_2E_b2Pair *_ZN13b2PairManager4FindEiij(struct l_struct_2E_b2PairManager *llvm_cbe_this, unsigned int llvm_cbe_proxyId1, unsigned int llvm_cbe_proxyId2, unsigned int llvm_cbe_hash);
static struct l_struct_2E_b2Pair *_ZN13b2PairManager4FindEii(struct l_struct_2E_b2PairManager *llvm_cbe_this, unsigned int llvm_cbe_proxyId1, unsigned int llvm_cbe_proxyId2);
static struct l_struct_2E_b2Manifold *_ZN15b2CircleContact12GetManifoldsEv(struct l_struct_2E_b2CircleContact *llvm_cbe_this);
static void _ZN15b2CircleContactD0Ev(struct l_struct_2E_b2CircleContact *llvm_cbe_this);
static void _ZN15b2CircleContactD1Ev(struct l_struct_2E_b2CircleContact *llvm_cbe_this);
static void _ZN15b2CircleContact8EvaluateEP17b2ContactListener(struct l_struct_2E_b2CircleContact *llvm_cbe_this, struct l_struct_2E_Os *llvm_cbe_listener);
static void _ZN15b2DistanceJoint24SolveVelocityConstraintsERK10b2TimeStep(struct l_struct_2E_b2DistanceJoint *llvm_cbe_this, struct l_struct_2E_b2TimeStep *llvm_cbe_step);
static unsigned long long _ZNK15b2DistanceJoint10GetAnchor1Ev(struct l_struct_2E_b2DistanceJoint *llvm_cbe_this);
static unsigned long long _ZNK15b2DistanceJoint10GetAnchor2Ev(struct l_struct_2E_b2DistanceJoint *llvm_cbe_this);
static unsigned long long _ZNK15b2DistanceJoint16GetReactionForceEv(struct l_struct_2E_b2DistanceJoint *llvm_cbe_this);
static float _ZNK15b2DistanceJoint17GetReactionTorqueEv(struct l_struct_2E_b2DistanceJoint *llvm_cbe_this);
static void _ZN15b2DistanceJointD0Ev(struct l_struct_2E_b2DistanceJoint *llvm_cbe_this);
static void _ZN15b2DistanceJointD1Ev(struct l_struct_2E_b2DistanceJoint *llvm_cbe_this);
static void _ZN15b2DistanceJoint23InitVelocityConstraintsERK10b2TimeStep(struct l_struct_2E_b2DistanceJoint *llvm_cbe_this, struct l_struct_2E_b2TimeStep *llvm_cbe_step);
static unsigned char _ZN15b2DistanceJoint24SolvePositionConstraintsEv(struct l_struct_2E_b2DistanceJoint *llvm_cbe_this);
static struct l_struct_2E_b2Manifold *_ZN16b2PolygonContact12GetManifoldsEv(struct l_struct_2E_b2CircleContact *llvm_cbe_this);
static void _ZN16b2PolygonContactD0Ev(struct l_struct_2E_b2CircleContact *llvm_cbe_this);
static void _ZN16b2PolygonContactD1Ev(struct l_struct_2E_b2CircleContact *llvm_cbe_this);
static void _ZN16b2PolygonContact8EvaluateEP17b2ContactListener(struct l_struct_2E_b2CircleContact *llvm_cbe_this, struct l_struct_2E_Os *llvm_cbe_listener);
static unsigned long long _ZNK16b2PrismaticJoint10GetAnchor1Ev(struct l_struct_2E_b2PrismaticJoint *llvm_cbe_this);
static unsigned long long _ZNK16b2PrismaticJoint10GetAnchor2Ev(struct l_struct_2E_b2PrismaticJoint *llvm_cbe_this);
static unsigned long long _ZNK16b2PrismaticJoint16GetReactionForceEv(struct l_struct_2E_b2PrismaticJoint *llvm_cbe_this);
static float _ZNK16b2PrismaticJoint17GetReactionTorqueEv(struct l_struct_2E_b2PrismaticJoint *llvm_cbe_this);
static void _ZN16b2PrismaticJoint24SolveVelocityConstraintsERK10b2TimeStep(struct l_struct_2E_b2PrismaticJoint *llvm_cbe_this, struct l_struct_2E_b2TimeStep *llvm_cbe_step);
static void _ZN16b2PrismaticJointD0Ev(struct l_struct_2E_b2PrismaticJoint *llvm_cbe_this);
static void _ZN16b2PrismaticJointD1Ev(struct l_struct_2E_b2PrismaticJoint *llvm_cbe_this);
static void _ZN16b2PrismaticJoint23InitVelocityConstraintsERK10b2TimeStep(struct l_struct_2E_b2PrismaticJoint *llvm_cbe_this, struct l_struct_2E_b2TimeStep *llvm_cbe_step);
static unsigned char _ZN16b2PrismaticJoint24SolvePositionConstraintsEv(struct l_struct_2E_b2PrismaticJoint *llvm_cbe_this);
static struct l_struct_2E_b2Manifold *_ZN22b2PolyAndCircleContact12GetManifoldsEv(struct l_struct_2E_b2CircleContact *llvm_cbe_this);
static void _ZN22b2PolyAndCircleContactD0Ev(struct l_struct_2E_b2CircleContact *llvm_cbe_this);
static void _ZN22b2PolyAndCircleContactD1Ev(struct l_struct_2E_b2CircleContact *llvm_cbe_this);
static void _ZN22b2PolyAndCircleContact8EvaluateEP17b2ContactListener(struct l_struct_2E_b2CircleContact *llvm_cbe_this, struct l_struct_2E_Os *llvm_cbe_listener);
static unsigned int _ZL17ClipSegmentToLineP10ClipVertexS0_RK6b2Vec2f(struct l_struct_2E_ClipVertex *llvm_cbe_vOut, struct l_struct_2E_ClipVertex *llvm_cbe_vIn, struct l_struct_2E_b2Vec2 *llvm_cbe_normal, float llvm_cbe_offset);
static float _ZL14EdgeSeparationPK14b2PolygonShapeRK7b2XFormiS1_S4_(struct l_struct_2E_b2PolygonShape *llvm_cbe_poly1, struct l_struct_2E_b2XForm *llvm_cbe_xf1, unsigned int llvm_cbe_edge1, struct l_struct_2E_b2PolygonShape *llvm_cbe_poly2, struct l_struct_2E_b2XForm *llvm_cbe_xf2);
static float _ZL17FindMaxSeparationPiPK14b2PolygonShapeRK7b2XFormS2_S5_(unsigned int *llvm_cbe_edgeIndex, struct l_struct_2E_b2PolygonShape *llvm_cbe_poly1, struct l_struct_2E_b2XForm *llvm_cbe_xf1, struct l_struct_2E_b2PolygonShape *llvm_cbe_poly2, struct l_struct_2E_b2XForm *llvm_cbe_xf2);
void abort(void);
unsigned char *memcpy(unsigned char *, unsigned char *, unsigned long long );
unsigned char *memset(unsigned char *, unsigned int , unsigned long long );
unsigned char *memmove(unsigned char *, unsigned char *, unsigned long long );


/* Global Variable Declarations */
static unsigned char _2E_str[6];
static unsigned long long _ZGVZN6Config11userDataDirEvE1d;
static unsigned long long _ZGVZN6Config10planetRootEvE1d;
static unsigned int  (*_ZTV6Canvas[4]) ();
static struct l_struct_2E___class_type_info_pseudo _ZTI6Canvas;
static unsigned char _ZTS6Canvas[8];
static unsigned int  (*_ZTV5Image[4]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI5Image;
static unsigned char _ZTS5Image[7];
static unsigned int  (*_ZTV6Window[4]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI6Window;
static unsigned char _ZTS6Window[8];
static unsigned char _2E_str1[6];
static unsigned char _2E_str12[26];
static unsigned char _2E_str2[17];
static unsigned char _2E_str3[50];
static unsigned char _2E_str4[16];
static unsigned char _2E_str5[19];
static unsigned char _2E_str6[25];
static unsigned char _2E_str7[25];
static unsigned char _2E_str8[3];
static unsigned char _2E_str9[3];
static unsigned char _2E_str11[4];
static unsigned char _2E_str213[20];
static unsigned char _2E_str314[30];
static unsigned char _2E_str415[19];
static unsigned char _2E_str516[14];
static unsigned char _2E_str617[36];
static unsigned char _2E_str718[5];
static unsigned char _2E_str819[5];
static unsigned char _2E_str920[2];
static unsigned char _2E_str10[21];
static unsigned char _2E_str22[12];
static unsigned char _2E_str123[14];
static unsigned char _2E_str224[8];
static unsigned char levelbuf[65536];
static unsigned int  (*_ZTV10b2ShapeDef[4]) ();
static struct l_struct_2E___class_type_info_pseudo _ZTI10b2ShapeDef;
static unsigned char _ZTS10b2ShapeDef[13];
static unsigned int  (*_ZTV12b2PolygonDef[4]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI12b2PolygonDef;
static unsigned char _ZTS12b2PolygonDef[15];
static unsigned int  (*_ZTVN6Stroke6BoxDefE[4]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTIN6Stroke6BoxDefE;
static unsigned char _ZTSN6Stroke6BoxDefE[17];
static unsigned int  (*_ZTV17b2ContactListener[8]) ();
static struct l_struct_2E___class_type_info_pseudo _ZTI17b2ContactListener;
static unsigned char _ZTS17b2ContactListener[20];
static struct l_struct_2E_Transform worldToScreen;
static unsigned int _ZZN4Game14handleModEventER9SDL_EventE3mod;
static struct l_struct_2E_std_3A__3A_string _ZZN6Config10planetRootEvE1d;
static struct l_struct_2E_std_3A__3A_string _ZZN6Config11userDataDirEvE1d;
static unsigned char _2E_str25[12];
static unsigned char _2E_str126[63];
static unsigned char _ZZNK7b2Mat226InvertEvE19__PRETTY_FUNCTION__[32];
static struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ _ZStL8__ioinit;
static unsigned int SCREEN_WIDTH;
static unsigned int SCREEN_HEIGHT;
static struct l_struct_2E_Rect FULLSCREEN_RECT;
static unsigned char _2E_str227[18];
static unsigned int  (*_ZTV5Scene[8]) ();
static struct l_struct_2E___vmi_class_type_info_pseudo1 _ZTI5Scene;
static unsigned char _ZTS5Scene[7];
static unsigned int  (*_ZTV11GameControl[9]) ();
static struct l_struct_2E___class_type_info_pseudo _ZTI11GameControl;
static unsigned char _ZTS11GameControl[14];
static struct l_struct_2E_Rect BOUNDS_RECT;
static unsigned char _2E_str328[19];
static struct l_struct_2E_Image *_ZN5Scene9g_bgImageE;
static unsigned char _2E_str429[10];
static unsigned char _2E_str530[41];
static unsigned char _2E_str631[40];
static unsigned char _2E_str833[13];
static unsigned char _2E_str934[19];
static unsigned char _2E_str1035[8];
static unsigned char _2E_str1136[25];
static unsigned char _2E_str1237[28];
static unsigned char _2E_str13[15];
static unsigned char _2E_str14[2];
static unsigned char _2E_str15[14];
static unsigned char _2E_str16[8];
static unsigned char _2E_str17[9];
static unsigned char _2E_str18[13];
static unsigned char _2E_str19[3];
static unsigned char _2E_str20[2];
static unsigned char _2E_str21[2];
static unsigned char _2E_str2238[2];
static unsigned char _2E_str23[2];
static unsigned char _2E_str24[2];
static unsigned char _2E_str2539[2];
static unsigned char _2E_str26[2];
static unsigned char _2E_str27[28];
static unsigned char _2E_str28[6];
static unsigned int  (*_ZTV4Game[9]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI4Game;
static unsigned char _ZTS4Game[6];
static unsigned char _2E_str29[15];
static unsigned char _2E_str30[9];
static unsigned char _2E_str31[5];
static unsigned char _2E_str32[15];
static unsigned char _2E_str33[14];
static unsigned char _2E_str34[27];
static unsigned char _2E_str35[10];
static unsigned char _2E_str37[14];
static unsigned char _2E_str38[22];
static unsigned char _2E_str39[31];
static unsigned char _2E_str40[24];
static unsigned char _2E_str41[16];
static unsigned char _2E_str42[17];
static unsigned char _2E_str43[26];
static unsigned char _2E_str44[5];
static unsigned char _2E_str45[8];
static unsigned char _2E_str46[10];
static unsigned char _2E_str47[6];
static unsigned char _2E_str48[19];
static unsigned char _2E_str49[5];
static unsigned char _2E_str50[9];
static unsigned char _2E_str51[5];
static unsigned char _2E_str52[25];
static unsigned char _2E_str53[13];
static unsigned int  (*_ZTV7Overlay[11]) ();
static struct l_struct_2E___class_type_info_pseudo _ZTI7Overlay;
static unsigned char _ZTS7Overlay[9];
static unsigned int  (*_ZTV11OverlayBase[13]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI11OverlayBase;
static unsigned char _ZTS11OverlayBase[14];
static unsigned int  (*_ZTV9UiOverlay[13]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI9UiOverlay;
static unsigned char _ZTS9UiOverlay[11];
static unsigned int  (*_ZTV11MenuOverlay[13]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI11MenuOverlay;
static unsigned char _ZTS11MenuOverlay[14];
static unsigned int  (*_ZTV11IconOverlay[13]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI11IconOverlay;
static unsigned char _ZTS11IconOverlay[14];
static unsigned int  (*_ZTV11EditOverlay[13]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI11EditOverlay;
static unsigned char _ZTS11EditOverlay[14];
static unsigned int  (*_ZTV16NextLevelOverlay[13]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI16NextLevelOverlay;
static unsigned char _ZTS16NextLevelOverlay[19];
static unsigned char _2E_str54[390];
static unsigned char _2E_str155[9];
static unsigned char _2E_str256[7];
static unsigned char _2E_str357[14];
static unsigned char _2E_str458[9];
static unsigned char _2E_str559[11];
static unsigned char _2E_str660[16];
static unsigned char _2E_str761[9];
static unsigned long long _ZGVZN6Config4fontEvE1f;
static unsigned char _2E_str63[9];
static struct l_struct_2E_Font _ZZN6Config4fontEvE1f;
static unsigned char _2E_str265[3];
static unsigned int brushColours[12];
static unsigned char _2E_str71[8];
static unsigned char _2E_str172[35];
static unsigned char _2E_str374[5];
static unsigned char _2E_str475[17];
static unsigned char _2E_str576[21];
static struct l_struct_2E___class_type_info_pseudo _ZTIN9happyhttp6WobblyE;
static unsigned char _ZTSN9happyhttp6WobblyE[20];
static unsigned char _2E_str1081[19];
static unsigned char _2E_str183[14];
static unsigned char _ZZN9happyhttp8Response18ProcessDataChunkedEPKhiE19__PRETTY_FUNCTION__[71];
static unsigned char _2E_str284[17];
static unsigned char _2E_str385[22];
static unsigned char _ZZNK9happyhttp8Response9getreasonEvE19__PRETTY_FUNCTION__[51];
static unsigned char _ZZNK9happyhttp8Response9getstatusEvE19__PRETTY_FUNCTION__[43];
static unsigned char _2E_str486[11];
static unsigned char _2E_str587[6];
static unsigned char _2E_str688[11];
static unsigned char _2E_str789[18];
static unsigned char _2E_str890[8];
static unsigned char _2E_str991[15];
static unsigned char _2E_str1092[5];
static unsigned char _2E_str1294[19];
static unsigned char _2E_str1395[10];
static unsigned char _2E_str1496[8];
static unsigned char _2E_str1597[21];
static unsigned char _2E_str1698[14];
static unsigned char _ZZN9happyhttp8Response4pumpEPKhiE19__PRETTY_FUNCTION__[57];
static unsigned char _2E_str1799[18];
static unsigned char _2E_str18100[31];
static unsigned char _2E_str19101[19];
static unsigned char _2E_str20102[3];
static unsigned char _2E_str21103[3];
static unsigned char _2E_str22104[23];
static unsigned char _2E_str23105[15];
static unsigned char _2E_str24106[5];
static unsigned char _2E_str25107[16];
static unsigned char _2E_str26108[9];
static struct l_struct_2E___mbstate_t_3A__3A__2E__54 _ZZN9happyhttp7atoaddrEPKcE5saddr;
static unsigned char _2E_str27109[7];
static unsigned char _2E_str28110[24];
static unsigned char _2E_str29111[9];
static unsigned char _2E_str30112[10];
static unsigned char _2E_str31113[7];
static unsigned char _2E_str32114[19];
static unsigned char _2E_str33115[1];
static unsigned char _2E_str34116[3];
static unsigned char _2E_str36118[15];
static unsigned char _2E_str37119[7];
static unsigned char _2E_str38120[10];
static unsigned char _ZZN9happyhttp10Connection4pumpEvE19__PRETTY_FUNCTION__[35];
static unsigned char _2E_str39121[7];
static unsigned char _2E_str40122[15];
static unsigned char _2E_str41123[10];
static struct l_struct_2E___class_type_info_pseudo _ZTI2Os;
static unsigned char _ZTS2Os[4];
static unsigned int  (*_ZTV13OsFreeDesktop[6]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI13OsFreeDesktop;
static unsigned char _ZTS13OsFreeDesktop[16];
static unsigned long long _ZGVZN2Os3getEvE2os;
static struct l_struct_2E_OsFreeDesktop _ZZN2Os3getEvE2os;
static unsigned char _2E_str124[12];
static unsigned int  (*_ZTV14b2PolygonShape[10]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI14b2PolygonShape;
static unsigned char _ZTS14b2PolygonShape[17];
static struct l_struct_2E___class_type_info_pseudo _ZTI7b2Shape;
static unsigned char _2E_str125[19];
static unsigned char _2E_str1126[49];
static unsigned char _ZZNK14b2PolygonShape11ComputeMassEP10b2MassDataE19__PRETTY_FUNCTION__[60];
static unsigned char _2E_str2127[22];
static unsigned char _2E_str3128[36];
static unsigned char _ZZNK14b2PolygonShape11TestSegmentERK7b2XFormPfP6b2Vec2RK9b2SegmentfE19__PRETTY_FUNCTION__[109];
static unsigned char _2E_str5130[52];
static unsigned char _ZZNK7b2Mat225SolveERK6b2Vec2E19__PRETTY_FUNCTION__[43];
static unsigned char _2E_str6131[11];
static unsigned char _ZZL15ComputeCentroidPK6b2Vec2iE19__PRETTY_FUNCTION__[45];
static unsigned char _2E_str7132[31];
static unsigned char _ZZL10ComputeOBBP5b2OBBPK6b2Vec2iE19__PRETTY_FUNCTION__[46];
static unsigned char _2E_str8133[24];
static unsigned char _2E_str9134[26];
static unsigned char _2E_str10135[28];
static unsigned char _ZZN14b2PolygonShapeC4EPK10b2ShapeDefE19__PRETTY_FUNCTION__[50];
static unsigned char _2E_str11136[61];
static unsigned char _2E_str12137[55];
static unsigned char _2E_str13138[12];
static unsigned char _2E_str14139[12];
static unsigned int  (*_ZTV7b2Joint[12]) ();
static struct l_struct_2E___class_type_info_pseudo _ZTI7b2Joint;
static unsigned char _ZTS7b2Joint[9];
static unsigned int  (*_ZTV15b2RevoluteJoint[12]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI15b2RevoluteJoint;
static unsigned char _ZTS15b2RevoluteJoint[18];
static unsigned char _2E_str146[25];
static unsigned char _2E_str1147[33];
static unsigned char _ZZN6b2BodyD4EvE19__PRETTY_FUNCTION__[18];
static unsigned char _2E_str2148[23];
static unsigned char _ZZN6b2BodyC4EPK9b2BodyDefP7b2WorldE19__PRETTY_FUNCTION__[43];
static unsigned char _ZZN6b2Body8SetXFormERK6b2Vec2fE19__PRETTY_FUNCTION__[46];
static unsigned char _ZZN6b2Body17SetMassFromShapesEvE19__PRETTY_FUNCTION__[33];
static unsigned char _2E_str3149[11];
static unsigned char _ZZN6b2Body11CreateShapeEP10b2ShapeDefE19__PRETTY_FUNCTION__[42];
static unsigned int  (*_ZTV9b2Contact[6]) ();
static struct l_struct_2E___class_type_info_pseudo _ZTI9b2Contact;
static unsigned char _ZTS9b2Contact[11];
static unsigned int  (*_ZTV13b2NullContact[6]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI13b2NullContact;
static unsigned char _ZTS13b2NullContact[16];
static unsigned int  (*_ZTV14b2PairCallback[6]) ();
static struct l_struct_2E___class_type_info_pseudo _ZTI14b2PairCallback;
static unsigned char _ZTS14b2PairCallback[17];
static unsigned int  (*_ZTV16b2ContactManager[6]) ();
static unsigned char _2E_str153[37];
static unsigned char _2E_str1154[34];
static unsigned char _ZZN7b2World9DrawShapeEP7b2ShapeRK7b2XFormRK7b2ColorbE19__PRETTY_FUNCTION__[72];
static unsigned char _2E_str2155[29];
static unsigned char _2E_str3156[33];
static unsigned char _ZZN8b2Island3AddEP6b2BodyE19__PRETTY_FUNCTION__[28];
static unsigned char _2E_str4157[35];
static unsigned char _ZZN8b2Island3AddEP9b2ContactE19__PRETTY_FUNCTION__[31];
static unsigned char _2E_str5158[31];
static unsigned char _ZZN8b2Island3AddEP7b2JointE19__PRETTY_FUNCTION__[29];
static unsigned char _2E_str6159[10];
static unsigned char _ZZN7b2World8SolveTOIERK10b2TimeStepE19__PRETTY_FUNCTION__[42];
static unsigned char _2E_str7160[27];
static unsigned char _2E_str8161[23];
static unsigned char _2E_str9162[28];
static unsigned char _ZZN7b2World5SolveERK10b2TimeStepE19__PRETTY_FUNCTION__[39];
static unsigned char _2E_str10163[16];
static unsigned char _ZZN7b2World12DestroyJointEP7b2JointE19__PRETTY_FUNCTION__[37];
static unsigned char _2E_str11164[17];
static unsigned char _ZZN7b2World11CreateJointEPK10b2JointDefE19__PRETTY_FUNCTION__[49];
static unsigned char _2E_str12165[16];
static unsigned char _ZZN7b2World11DestroyBodyEP6b2BodyE19__PRETTY_FUNCTION__[35];
static unsigned char _ZZN7b2World10CreateBodyEPK9b2BodyDefE19__PRETTY_FUNCTION__[46];
static struct l_struct_2E_Os b2_defaultFilter;
static unsigned char _2E_str166[23];
static unsigned char _2E_str1167[42];
static unsigned char _ZZ14b2TimeOfImpactPK7b2ShapeRK7b2SweepS1_S4_E19__PRETTY_FUNCTION__[87];
static unsigned char _2E_str2168[34];
static unsigned int b2_byteCount;
static unsigned char _2E_str169[21];
static unsigned char _2E_str1170[35];
static unsigned char _ZZ6b2FreePvE19__PRETTY_FUNCTION__[19];
static unsigned char _2E_str171[6];
static unsigned char _2E_str1172[41];
static unsigned char _ZZN7b2Joint7DestroyEPS_P16b2BlockAllocatorE19__PRETTY_FUNCTION__[58];
static unsigned char _ZZN7b2Joint6CreateEPK10b2JointDefP16b2BlockAllocatorE19__PRETTY_FUNCTION__[70];
static unsigned int  (*_ZTV7b2Shape[10]) ();
static unsigned char _ZTS7b2Shape[9];
static unsigned char _2E_str173[26];
static unsigned char _2E_str1174[42];
static unsigned char _ZZN7b2Shape11CreateProxyEP12b2BroadPhaseRK7b2XFormE19__PRETTY_FUNCTION__[57];
static unsigned char _2E_str2175[8];
static unsigned char _ZZN7b2ShapeD4EvE19__PRETTY_FUNCTION__[28];
static unsigned char _ZZN7b2Shape7DestroyEPS_P16b2BlockAllocatorE19__PRETTY_FUNCTION__[58];
static unsigned char _ZZN7b2Shape6CreateEPK10b2ShapeDefP16b2BlockAllocatorE19__PRETTY_FUNCTION__[70];
static unsigned int _ZN16b2BlockAllocator12s_blockSizesE[14];
static unsigned char _2E_str177[36];
static unsigned char _2E_str1178[41];
static unsigned char _ZZN16b2BlockAllocator4FreeEPviE19__PRETTY_FUNCTION__[42];
static unsigned char _ZN16b2BlockAllocator17s_blockSizeLookupE[641];
static unsigned char _2E_str2179[36];
static bool _ZN16b2BlockAllocator28s_blockSizeLookupInitializedE_2E_b;
static unsigned char _2E_str3180[18];
static unsigned char _ZZN16b2BlockAllocatorC4EvE19__PRETTY_FUNCTION__[37];
static unsigned char _ZZN16b2BlockAllocator8AllocateEiE19__PRETTY_FUNCTION__[40];
static unsigned char _2E_str4181[39];
static unsigned char _2E_str184[13];
static unsigned char _2E_str1185[41];
static unsigned char _ZZN16b2StackAllocatorD4EvE19__PRETTY_FUNCTION__[38];
static unsigned char _2E_str2186[18];
static unsigned char _2E_str3187[17];
static unsigned char _ZZN16b2StackAllocator4FreeEPvE19__PRETTY_FUNCTION__[35];
static unsigned char _2E_str4188[17];
static unsigned char _2E_str5189[34];
static unsigned char _ZZN16b2StackAllocator8AllocateEiE19__PRETTY_FUNCTION__[40];
static struct l_struct_2E___si_class_type_info_pseudo _ZTI16b2ContactManager;
static unsigned char _ZTS16b2ContactManager[19];
static unsigned char _2E_str1191[40];
static unsigned char _2E_str7197[35];
static unsigned char _ZZN12b2BroadPhase21IncrementOverlapCountEiE19__PRETTY_FUNCTION__[48];
static unsigned char _2E_str8198[7];
static unsigned char _ZZN12b2BroadPhase5QueryEPiS0_ttP7b2BoundiiE19__PRETTY_FUNCTION__[81];
static unsigned char _2E_str9199[38];
static unsigned char _ZZN12b2BroadPhase13ComputeBoundsEPtS0_RK6b2AABBE19__PRETTY_FUNCTION__[66];
static unsigned char _2E_str10200[38];
static unsigned char _2E_str11201[34];
static unsigned char _2E_str12202[17];
static unsigned char _2E_str13203[40];
static unsigned char _ZZN12b2BroadPhase11TestOverlapERK13b2BoundValuesP7b2ProxyE19__PRETTY_FUNCTION__[63];
static unsigned char _2E_str14204[40];
static unsigned char _2E_str15205[41];
static unsigned char _ZZN12b2BroadPhase11TestOverlapEP7b2ProxyS1_E19__PRETTY_FUNCTION__[51];
static unsigned char _2E_str16206[41];
static unsigned char _2E_str17207[41];
static unsigned char _2E_str18208[41];
static unsigned char _ZZN12b2BroadPhase9MoveProxyEiRK6b2AABBE19__PRETTY_FUNCTION__[51];
static unsigned char _2E_str20210[50];
static unsigned char _ZZN12b2BroadPhase12DestroyProxyEiE19__PRETTY_FUNCTION__[39];
static unsigned char _2E_str21211[41];
static unsigned char _2E_str22212[29];
static unsigned char _ZZN12b2BroadPhase11CreateProxyERK6b2AABBPvE19__PRETTY_FUNCTION__[55];
static unsigned char _2E_str23213[28];
static unsigned char _2E_str24214[20];
static unsigned char _ZZN12b2BroadPhaseC4ERK6b2AABBP14b2PairCallbackE19__PRETTY_FUNCTION__[59];
static struct l_struct_2E_b2ContactRegister _ZN9b2Contact11s_registersE[2][2];
static bool _ZN9b2Contact13s_initializedE_2E_b;
static unsigned char _2E_str215[22];
static unsigned char _2E_str1216[45];
static unsigned char _ZZN9b2Contact7DestroyEPS_P16b2BlockAllocatorE19__PRETTY_FUNCTION__[62];
static unsigned char _2E_str2217[51];
static unsigned char _2E_str3218[51];
static unsigned char _ZZN9b2Contact6CreateEP7b2ShapeS1_P16b2BlockAllocatorE19__PRETTY_FUNCTION__[75];
static unsigned int  (*_ZTV15b2ContactFilter[5]) ();
static struct l_struct_2E___class_type_info_pseudo _ZTI15b2ContactFilter;
static unsigned char _ZTS15b2ContactFilter[18];
static unsigned int  (*_ZTV13b2PulleyJoint[12]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI13b2PulleyJoint;
static unsigned char _ZTS13b2PulleyJoint[16];
static unsigned char _2E_str221[30];
static unsigned char _2E_str1222[47];
static unsigned char _ZZN13b2PulleyJoint23InitVelocityConstraintsERK10b2TimeStepE19__PRETTY_FUNCTION__[71];
static unsigned char _2E_str2223[30];
static unsigned char _2E_str3224[30];
static unsigned char _2E_str5226[19];
static unsigned char _ZZN13b2PulleyJointC4EPK16b2PulleyJointDefE19__PRETTY_FUNCTION__[54];
static unsigned int  (*_ZTV11b2GearJoint[12]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI11b2GearJoint;
static unsigned char _ZTS11b2GearJoint[14];
static unsigned char _2E_str228[9];
static unsigned char _2E_str1229[45];
static unsigned char _ZZN11b2GearJoint23InitVelocityConstraintsERK10b2TimeStepE19__PRETTY_FUNCTION__[69];
static unsigned char _2E_str2230[54];
static unsigned char _ZZN11b2GearJointC4EPK14b2GearJointDefE19__PRETTY_FUNCTION__[48];
static unsigned char _2E_str3231[54];
static unsigned char _2E_str4232[36];
static unsigned char _2E_str5233[36];
static unsigned char _2E_str234[23];
static unsigned char _2E_str1235[38];
static unsigned char _ZZL12ProcessThreeP6b2Vec2S0_S0_S0_S0_E19__PRETTY_FUNCTION__[64];
static unsigned char _2E_str2236[23];
static unsigned char _2E_str3237[36];
static unsigned char _2E_str4238[15];
static unsigned char _2E_str5239[15];
static unsigned char _2E_str6240[13];
static unsigned int  (*_ZTV12b2MouseJoint[12]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI12b2MouseJoint;
static unsigned char _ZTS12b2MouseJoint[15];
static unsigned char _2E_str2244[23];
static unsigned char _2E_str3245[46];
static unsigned char _ZZN12b2MouseJointC4EPK15b2MouseJointDefE19__PRETTY_FUNCTION__[51];
static unsigned int  (*_ZTV13b2CircleShape[10]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI13b2CircleShape;
static unsigned char _ZTS13b2CircleShape[16];
static unsigned char _2E_str246[27];
static unsigned char _2E_str1247[48];
static unsigned char _ZZN13b2CircleShapeC4EPK10b2ShapeDefE19__PRETTY_FUNCTION__[48];
static unsigned char _2E_str248[16];
static unsigned char _2E_str1249[41];
static unsigned char _ZZN13b2PairManager10RemovePairEiiE19__PRETTY_FUNCTION__[46];
static unsigned char _2E_str3251[20];
static unsigned char _ZZN13b2PairManager4FindEiijE19__PRETTY_FUNCTION__[50];
static unsigned char _2E_str4252[55];
static unsigned char _ZZN13b2PairManager7AddPairEiiE19__PRETTY_FUNCTION__[45];
static unsigned char _2E_str5253[43];
static unsigned char _ZZN13b2PairManager15AddBufferedPairEiiE19__PRETTY_FUNCTION__[50];
static unsigned char _2E_str6254[32];
static unsigned char _2E_str7255[25];
static unsigned char _2E_str8256[33];
static unsigned char _ZZN13b2PairManager18RemoveBufferedPairEiiE19__PRETTY_FUNCTION__[53];
static unsigned char _2E_str9257[24];
static unsigned char _2E_str11259[19];
static unsigned char _ZZN13b2PairManager6CommitEvE19__PRETTY_FUNCTION__[29];
static unsigned char _2E_str12260[65];
static unsigned char _2E_str13261[18];
static unsigned char _2E_str14262[18];
static unsigned char _2E_str15263[50];
static unsigned int  (*_ZTV15b2CircleContact[6]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI15b2CircleContact;
static unsigned char _ZTS15b2CircleContact[18];
static unsigned char _2E_str264[37];
static unsigned char _2E_str1265[51];
static unsigned char _ZZN15b2CircleContactC4EP7b2ShapeS1_E19__PRETTY_FUNCTION__[53];
static unsigned char _2E_str2266[37];
static unsigned char _2E_str268[23];
static unsigned char _2E_str1269[51];
static unsigned char _ZZN15b2ContactSolverC4ERK10b2TimeStepPP9b2ContactiP16b2StackAllocatorE19__PRETTY_FUNCTION__[91];
static unsigned char _2E_str2270[25];
static unsigned char _2E_str3271[26];
static unsigned char _2E_str4272[25];
static unsigned char _2E_str5273[28];
static unsigned char _2E_str6274[26];
static unsigned char _2E_str7275[27];
static unsigned int  (*_ZTV15b2DistanceJoint[12]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI15b2DistanceJoint;
static unsigned char _ZTS15b2DistanceJoint[18];
static unsigned char _2E_str277[25];
static unsigned char _2E_str1278[49];
static unsigned char _ZZN15b2DistanceJoint23InitVelocityConstraintsERK10b2TimeStepE19__PRETTY_FUNCTION__[73];
static unsigned int  (*_ZTV16b2PolygonContact[6]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI16b2PolygonContact;
static unsigned char _ZTS16b2PolygonContact[19];
static unsigned char _2E_str279[38];
static unsigned char _2E_str1280[49];
static unsigned char _ZZN16b2PolygonContactC4EP7b2ShapeS1_E19__PRETTY_FUNCTION__[55];
static unsigned char _2E_str2281[38];
static unsigned int  (*_ZTV16b2PrismaticJoint[12]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI16b2PrismaticJoint;
static unsigned char _ZTS16b2PrismaticJoint[19];
static unsigned char _2E_str1283[50];
static unsigned char _2E_str2284[30];
static unsigned char _ZZN16b2PrismaticJoint23InitVelocityConstraintsERK10b2TimeStepE19__PRETTY_FUNCTION__[74];
static unsigned char _2E_str3285[29];
static unsigned int  (*_ZTV22b2PolyAndCircleContact[6]) ();
static struct l_struct_2E___si_class_type_info_pseudo _ZTI22b2PolyAndCircleContact;
static unsigned char _ZTS22b2PolyAndCircleContact[25];
static unsigned char _2E_str1289[58];
static unsigned char _ZZN22b2PolyAndCircleContactC4EP7b2ShapeS1_E19__PRETTY_FUNCTION__[67];
static unsigned char _2E_str1292[43];
static unsigned char _ZZ25b2CollidePolygonAndCircleP10b2ManifoldPK14b2PolygonShapeRK7b2XFormPK13b2CircleShapeS6_E19__PRETTY_FUNCTION__[121];
static unsigned char _2E_str293[29];
static unsigned char _2E_str1295[41];
static unsigned char _ZZL16FindIncidentEdgeP10ClipVertexPK14b2PolygonShapeRK7b2XFormiS3_S6_E19__PRETTY_FUNCTION__[120];
static unsigned char _ZZL14EdgeSeparationPK14b2PolygonShapeRK7b2XFormiS1_S4_E19__PRETTY_FUNCTION__[108];


/* Global Variable Definitions and Initialization */
static unsigned char _2E_str[6] = "%f,%f";
static unsigned long long _ZGVZN6Config11userDataDirEvE1d;
static unsigned long long _ZGVZN6Config10planetRootEvE1d;
static unsigned int  (*_ZTV6Canvas[4]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI6Canvas)), ((unsigned int  (*) ())_ZN6CanvasD1Ev), ((unsigned int  (*) ())_ZN6CanvasD0Ev) };
static struct l_struct_2E___class_type_info_pseudo _ZTI6Canvas = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv117__class_type_infoE)) + 16ull)), ((&_ZTS6Canvas[((signed int )0u)])) } };
static unsigned char _ZTS6Canvas[8] = "6Canvas";
static unsigned int  (*_ZTV5Image[4]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI5Image)), ((unsigned int  (*) ())_ZN5ImageD1Ev), ((unsigned int  (*) ())_ZN5ImageD0Ev) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI5Image = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS5Image[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI6Canvas)) };
static unsigned char _ZTS5Image[7] = "5Image";
static unsigned int  (*_ZTV6Window[4]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI6Window)), ((unsigned int  (*) ())_ZN6WindowD1Ev), ((unsigned int  (*) ())_ZN6WindowD0Ev) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI6Window = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS6Window[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI6Canvas)) };
static unsigned char _ZTS6Window[8] = "6Window";
static unsigned char _2E_str1[6] = "data/";
static unsigned char _2E_str12[26] = "/usr/share/numptyphysics/";
static unsigned char _2E_str2[17] = "loaded image %s\n";
static unsigned char _2E_str3[50] = "warning image %s not converted to display format\n";
static unsigned char _2E_str4[16] = "image not found";
static unsigned char _2E_str5[19] = "_NET_ACTIVE_WINDOW";
static unsigned char _2E_str6[25] = "SDL_VIDEO_X11_WMCLASS=%s";
static unsigned char _2E_str7[25] = "Unable to set video mode";
static unsigned char _2E_str8[3] = "wb";
static unsigned char _2E_str9[3] = "rt";
static unsigned char _2E_str11[4] = "end";
static unsigned char _2E_str213[20] = "invalid level index";
static unsigned char _2E_str314[30] = "addLevel %s already present!\n";
static unsigned char _2E_str415[19] = "addLevel %s at %d\n";
static unsigned char _2E_str516[14] = "top level %s\n";
static unsigned char _2E_str617[36] = "found collection %s with %d levels\n";
static unsigned char _2E_str718[5] = ".npz";
static unsigned char _2E_str819[5] = ".nph";
static unsigned char _2E_str920[2] = "/";
static unsigned char _2E_str10[21] = "bogus level path %s\n";
static unsigned char _2E_str22[12] = "mmap failed";
static unsigned char _2E_str123[14] = "bad zip magic";
static unsigned char _2E_str224[8] = "1.2.3.3";
static unsigned char levelbuf[65536];
static unsigned int  (*_ZTV10b2ShapeDef[4]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI10b2ShapeDef)), ((unsigned int  (*) ())_ZN10b2ShapeDefD1Ev), ((unsigned int  (*) ())_ZN10b2ShapeDefD0Ev) };
static struct l_struct_2E___class_type_info_pseudo _ZTI10b2ShapeDef = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv117__class_type_infoE)) + 16ull)), ((&_ZTS10b2ShapeDef[((signed int )0u)])) } };
static unsigned char _ZTS10b2ShapeDef[13] = "10b2ShapeDef";
static unsigned int  (*_ZTV12b2PolygonDef[4]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI12b2PolygonDef)), ((unsigned int  (*) ())_ZN12b2PolygonDefD1Ev), ((unsigned int  (*) ())_ZN12b2PolygonDefD0Ev) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI12b2PolygonDef = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS12b2PolygonDef[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI10b2ShapeDef)) };
static unsigned char _ZTS12b2PolygonDef[15] = "12b2PolygonDef";
static unsigned int  (*_ZTVN6Stroke6BoxDefE[4]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTIN6Stroke6BoxDefE)), ((unsigned int  (*) ())_ZN6Stroke6BoxDefD1Ev), ((unsigned int  (*) ())_ZN6Stroke6BoxDefD0Ev) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTIN6Stroke6BoxDefE = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTSN6Stroke6BoxDefE[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI12b2PolygonDef)) };
static unsigned char _ZTSN6Stroke6BoxDefE[17] = "N6Stroke6BoxDefE";
static unsigned int  (*_ZTV17b2ContactListener[8]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI17b2ContactListener)), ((unsigned int  (*) ())_ZN17b2ContactListenerD1Ev), ((unsigned int  (*) ())_ZN17b2ContactListenerD0Ev), ((unsigned int  (*) ())_ZN17b2ContactListener3AddEPK14b2ContactPoint), ((unsigned int  (*) ())_ZN17b2ContactListener7PersistEPK14b2ContactPoint), ((unsigned int  (*) ())_ZN17b2ContactListener6RemoveEPK14b2ContactPoint), ((unsigned int  (*) ())_ZN17b2ContactListener6ResultEPK15b2ContactResult) };
static struct l_struct_2E___class_type_info_pseudo _ZTI17b2ContactListener = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv117__class_type_infoE)) + 16ull)), ((&_ZTS17b2ContactListener[((signed int )0u)])) } };
static unsigned char _ZTS17b2ContactListener[20] = "17b2ContactListener";
static struct l_struct_2E_Transform worldToScreen;
static unsigned int _ZZN4Game14handleModEventER9SDL_EventE3mod;
static struct l_struct_2E_std_3A__3A_string _ZZN6Config10planetRootEvE1d;
static struct l_struct_2E_std_3A__3A_string _ZZN6Config11userDataDirEvE1d;
static unsigned char _2E_str25[12] = "det != 0.0f";
static unsigned char _2E_str126[63] = "Box2D/Include/../Source/Collision/Shapes/../../Common/b2Math.h";
static unsigned char _ZZNK7b2Mat226InvertEvE19__PRETTY_FUNCTION__[32] = "b2Mat22 b2Mat22::Invert() const";
static struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ _ZStL8__ioinit;
static unsigned int SCREEN_WIDTH = 800u;
static unsigned int SCREEN_HEIGHT = 480u;
static struct l_struct_2E_Rect FULLSCREEN_RECT = { { 0u, 0u }, { 799u, 479u } };
static unsigned char _2E_str227[18] = "showMessage \"%s\"\n";
static unsigned int  (*_ZTV5Scene[8]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI5Scene)), ((unsigned int  (*) ())_ZN5SceneD1Ev), ((unsigned int  (*) ())_ZN5SceneD0Ev), ((unsigned int  (*) ())_ZN5Scene3AddEPK14b2ContactPoint), ((unsigned int  (*) ())_ZN17b2ContactListener7PersistEPK14b2ContactPoint), ((unsigned int  (*) ())_ZN17b2ContactListener6RemoveEPK14b2ContactPoint), ((unsigned int  (*) ())_ZN17b2ContactListener6ResultEPK15b2ContactResult) };
static struct l_struct_2E___vmi_class_type_info_pseudo1 _ZTI5Scene = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv121__vmi_class_type_infoE)) + 16ull)), ((&_ZTS5Scene[((signed int )0u)])) }, 0u, 1u, { { ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI17b2ContactListener)), 0ull } } };
static unsigned char _ZTS5Scene[7] = "5Scene";
static unsigned int  (*_ZTV11GameControl[9]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI11GameControl)), ((unsigned int  (*) ())_ZN11GameControlD1Ev), ((unsigned int  (*) ())_ZN11GameControlD0Ev), ((unsigned int  (*) ())_ZN11GameControl4saveEPKc), ((unsigned int  (*) ())_ZN11GameControl4sendEv), ((unsigned int  (*) ())_ZN11GameControl4loadEPKc), ((unsigned int  (*) ())_ZN11GameControl9gotoLevelEib), ((unsigned int  (*) ())__cxa_pure_virtual) };
static struct l_struct_2E___class_type_info_pseudo _ZTI11GameControl = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv117__class_type_infoE)) + 16ull)), ((&_ZTS11GameControl[((signed int )0u)])) } };
static unsigned char _ZTS11GameControl[14] = "11GameControl";
static struct l_struct_2E_Rect BOUNDS_RECT = { { 4294967096u, 4294966816u }, { 1000u, 480u } };
static unsigned char _2E_str328[19] = "invalid stroke def";
static struct l_struct_2E_Image *_ZN5Scene9g_bgImageE;
static unsigned char _2E_str429[10] = "paper.jpg";
static unsigned char _2E_str530[41] = "http://timsab.homeip.net/~tim/planet.cgi";
static unsigned char _2E_str631[40] = "/tmp/mailto:numptyphysics@gmail.com.nph";
static unsigned char _2E_str833[13] = "NP-Upload-Id";
static unsigned char _2E_str934[19] = "uploaded as id %s\n";
static unsigned char _2E_str1035[8] = "?level=";
static unsigned char _2E_str1136[25] = "Unable to launch browser";
static unsigned char _2E_str1237[28] = "UploadFailed: unknown error";
static unsigned char _2E_str13[15] = "UploadFailed: ";
static unsigned char _2E_str14[2] = ":";
static unsigned char _2E_str15[14] = "saving to %s\n";
static unsigned char _2E_str16[8] = "Title: ";
static unsigned char _2E_str17[9] = "Author: ";
static unsigned char _2E_str18[13] = "Background: ";
static unsigned char _2E_str19[3] = "E:";
static unsigned char _2E_str20[2] = " ";
static unsigned char _2E_str21[2] = "K";
static unsigned char _2E_str2238[2] = "k";
static unsigned char _2E_str23[2] = "B";
static unsigned char _2E_str24[2] = ",";
static unsigned char _2E_str2539[2] = "b";
static unsigned char _2E_str26[2] = "M";
static unsigned char _2E_str27[28] = "stop recording: %d events:\n";
static unsigned char _2E_str28[6] = "  %s\n";
static unsigned int  (*_ZTV4Game[9]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI4Game)), ((unsigned int  (*) ())_ZN4GameD1Ev), ((unsigned int  (*) ())_ZN4GameD0Ev), ((unsigned int  (*) ())_ZN4Game4saveEPKc), ((unsigned int  (*) ())_ZN4Game4sendEv), ((unsigned int  (*) ())_ZN11GameControl4loadEPKc), ((unsigned int  (*) ())_ZN4Game9gotoLevelEib), ((unsigned int  (*) ())_ZN4Game11renderSceneER6Canvasi) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI4Game = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS4Game[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI11GameControl)) };
static unsigned char _ZTS4Game[6] = "4Game";
static unsigned char _2E_str29[15] = "Numpty Physics";
static unsigned char _2E_str30[9] = "NPhysics";
static unsigned char _2E_str31[5] = "HOME";
static unsigned char _2E_str32[15] = ".numptyphysics";
static unsigned char _2E_str33[14] = "L99_saved.nph";
static unsigned char _2E_str34[27] = "start playback: %d events\n";
static unsigned char _2E_str35[10] = "pause.png";
static unsigned char _2E_str37[14] = "overrun %dms\n";
static unsigned char _2E_str38[22] = "SDL_VIDEODRIVER=dummy";
static unsigned char _2E_str39[31] = "SDL_VIDEO_X11_WMCLASS=NPhysics";
static unsigned char _2E_str40[24] = "Couldn't initialize SDL";
static unsigned char _2E_str41[16] = "/.numptyphysics";
static unsigned char _2E_str42[17] = "created user dir";
static unsigned char _2E_str43[26] = "failed to create user dir";
static unsigned char _2E_str44[5] = "-bmp";
static unsigned char _2E_str45[8] = "-rotate";
static unsigned char _2E_str46[10] = "-geometry";
static unsigned char _2E_str47[6] = "%dx%d";
static unsigned char _2E_str48[19] = "generating bmp %s\n";
static unsigned char _2E_str49[5] = ".bmp";
static unsigned char _2E_str50[9] = "Game.cpp";
static unsigned char _2E_str51[5] = "data";
static unsigned char _2E_str52[25] = "/usr/share/numptyphysics";
static unsigned char _2E_str53[13] = "*** CAUGHT: ";
static unsigned int  (*_ZTV7Overlay[11]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI7Overlay)), ((unsigned int  (*) ())_ZN7OverlayD1Ev), ((unsigned int  (*) ())_ZN7OverlayD0Ev), ((unsigned int  (*) ())__cxa_pure_virtual), ((unsigned int  (*) ())__cxa_pure_virtual), ((unsigned int  (*) ())_ZN7Overlay6onShowEv), ((unsigned int  (*) ())_ZN7Overlay6onHideEv), ((unsigned int  (*) ())_ZN7Overlay6onTickEi), ((unsigned int  (*) ())__cxa_pure_virtual), ((unsigned int  (*) ())__cxa_pure_virtual) };
static struct l_struct_2E___class_type_info_pseudo _ZTI7Overlay = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv117__class_type_infoE)) + 16ull)), ((&_ZTS7Overlay[((signed int )0u)])) } };
static unsigned char _ZTS7Overlay[9] = "7Overlay";
static unsigned int  (*_ZTV11OverlayBase[13]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI11OverlayBase)), ((unsigned int  (*) ())_ZN11OverlayBaseD1Ev), ((unsigned int  (*) ())_ZN11OverlayBaseD0Ev), ((unsigned int  (*) ())_ZN11OverlayBase7isDirtyEv), ((unsigned int  (*) ())_ZN11OverlayBase9dirtyAreaEv), ((unsigned int  (*) ())_ZN11OverlayBase6onShowEv), ((unsigned int  (*) ())_ZN11OverlayBase6onHideEv), ((unsigned int  (*) ())_ZN11OverlayBase6onTickEi), ((unsigned int  (*) ())_ZN11OverlayBase4drawER6Canvas), ((unsigned int  (*) ())_ZN11OverlayBase11handleEventER9SDL_Event), ((unsigned int  (*) ())_ZN11OverlayBase7onClickEii), ((unsigned int  (*) ())_ZN11OverlayBase9onHotSpotEi) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI11OverlayBase = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS11OverlayBase[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI7Overlay)) };
static unsigned char _ZTS11OverlayBase[14] = "11OverlayBase";
static unsigned int  (*_ZTV9UiOverlay[13]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI9UiOverlay)), ((unsigned int  (*) ())_ZN9UiOverlayD1Ev), ((unsigned int  (*) ())_ZN9UiOverlayD0Ev), ((unsigned int  (*) ())_ZN11OverlayBase7isDirtyEv), ((unsigned int  (*) ())_ZN11OverlayBase9dirtyAreaEv), ((unsigned int  (*) ())_ZN11OverlayBase6onShowEv), ((unsigned int  (*) ())_ZN11OverlayBase6onHideEv), ((unsigned int  (*) ())_ZN9UiOverlay6onTickEi), ((unsigned int  (*) ())_ZN11OverlayBase4drawER6Canvas), ((unsigned int  (*) ())_ZN11OverlayBase11handleEventER9SDL_Event), ((unsigned int  (*) ())_ZN11OverlayBase7onClickEii), ((unsigned int  (*) ())_ZN11OverlayBase9onHotSpotEi) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI9UiOverlay = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS9UiOverlay[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI11OverlayBase)) };
static unsigned char _ZTS9UiOverlay[11] = "9UiOverlay";
static unsigned int  (*_ZTV11MenuOverlay[13]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI11MenuOverlay)), ((unsigned int  (*) ())_ZN11MenuOverlayD1Ev), ((unsigned int  (*) ())_ZN11MenuOverlayD0Ev), ((unsigned int  (*) ())_ZN11OverlayBase7isDirtyEv), ((unsigned int  (*) ())_ZN11OverlayBase9dirtyAreaEv), ((unsigned int  (*) ())_ZN11MenuOverlay6onShowEv), ((unsigned int  (*) ())_ZN11OverlayBase6onHideEv), ((unsigned int  (*) ())_ZN9UiOverlay6onTickEi), ((unsigned int  (*) ())_ZN11OverlayBase4drawER6Canvas), ((unsigned int  (*) ())_ZN11OverlayBase11handleEventER9SDL_Event), ((unsigned int  (*) ())_ZN11OverlayBase7onClickEii), ((unsigned int  (*) ())_ZN11OverlayBase9onHotSpotEi) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI11MenuOverlay = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS11MenuOverlay[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI9UiOverlay)) };
static unsigned char _ZTS11MenuOverlay[14] = "11MenuOverlay";
static unsigned int  (*_ZTV11IconOverlay[13]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI11IconOverlay)), ((unsigned int  (*) ())_ZN11IconOverlayD1Ev), ((unsigned int  (*) ())_ZN11IconOverlayD0Ev), ((unsigned int  (*) ())_ZN11OverlayBase7isDirtyEv), ((unsigned int  (*) ())_ZN11OverlayBase9dirtyAreaEv), ((unsigned int  (*) ())_ZN11OverlayBase6onShowEv), ((unsigned int  (*) ())_ZN11OverlayBase6onHideEv), ((unsigned int  (*) ())_ZN11OverlayBase6onTickEi), ((unsigned int  (*) ())_ZN11OverlayBase4drawER6Canvas), ((unsigned int  (*) ())_ZN11OverlayBase11handleEventER9SDL_Event), ((unsigned int  (*) ())_ZN11OverlayBase7onClickEii), ((unsigned int  (*) ())_ZN11OverlayBase9onHotSpotEi) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI11IconOverlay = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS11IconOverlay[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI11OverlayBase)) };
static unsigned char _ZTS11IconOverlay[14] = "11IconOverlay";
static unsigned int  (*_ZTV11EditOverlay[13]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI11EditOverlay)), ((unsigned int  (*) ())_ZN11EditOverlayD1Ev), ((unsigned int  (*) ())_ZN11EditOverlayD0Ev), ((unsigned int  (*) ())_ZN11OverlayBase7isDirtyEv), ((unsigned int  (*) ())_ZN11OverlayBase9dirtyAreaEv), ((unsigned int  (*) ())_ZN11OverlayBase6onShowEv), ((unsigned int  (*) ())_ZN11OverlayBase6onHideEv), ((unsigned int  (*) ())_ZN11OverlayBase6onTickEi), ((unsigned int  (*) ())_ZN11EditOverlay4drawER6Canvas), ((unsigned int  (*) ())_ZN11OverlayBase11handleEventER9SDL_Event), ((unsigned int  (*) ())_ZN11OverlayBase7onClickEii), ((unsigned int  (*) ())_ZN11EditOverlay9onHotSpotEi) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI11EditOverlay = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS11EditOverlay[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI11IconOverlay)) };
static unsigned char _ZTS11EditOverlay[14] = "11EditOverlay";
static unsigned int  (*_ZTV16NextLevelOverlay[13]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI16NextLevelOverlay)), ((unsigned int  (*) ())_ZN16NextLevelOverlayD1Ev), ((unsigned int  (*) ())_ZN16NextLevelOverlayD0Ev), ((unsigned int  (*) ())_ZN11OverlayBase7isDirtyEv), ((unsigned int  (*) ())_ZN11OverlayBase9dirtyAreaEv), ((unsigned int  (*) ())_ZN16NextLevelOverlay6onShowEv), ((unsigned int  (*) ())_ZN16NextLevelOverlay6onHideEv), ((unsigned int  (*) ())_ZN11OverlayBase6onTickEi), ((unsigned int  (*) ())_ZN16NextLevelOverlay4drawER6Canvas), ((unsigned int  (*) ())_ZN11OverlayBase11handleEventER9SDL_Event), ((unsigned int  (*) ())_ZN11OverlayBase7onClickEii), ((unsigned int  (*) ())_ZN11OverlayBase9onHotSpotEi) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI16NextLevelOverlay = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS16NextLevelOverlay[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI11IconOverlay)) };
static unsigned char _ZTS16NextLevelOverlay[19] = "16NextLevelOverlay";
static unsigned char _2E_str54[390] = "48,18 47,25 48,25 47,27 48,27 47,29 48,29 47,31 48,33 47,34 48,35 47,40 48,45 49,43 48,43 49,41 48,39 49,38 48,37 47,36 50,34 49,31 44,31 42,30 40,30 36,32 37,33 36,38 35,45 34,47 35,53 34,54 36,56 37,58 38,59 41,59 42,61 43,62 45,62 47,63 49,63 51,64 59,64 61,62 63,62 64,60 66,60 68,58 69,54 70,52 69,52 68,46 67,46 66,42 63,36 62,36 61,34 60,33 59,33 58,32 54,32 53,31 50,31 54,31 53,33";
static unsigned char _2E_str155[9] = "next.png";
static unsigned char _2E_str256[7] = "BRAVO!";
static unsigned char _2E_str357[14] = "Action Replay";
static unsigned char _2E_str458[9] = "Continue";
static unsigned char _2E_str559[11] = "theend.png";
static unsigned char _2E_str660[16] = "no more levels!";
static unsigned char _2E_str761[9] = "edit.png";
static unsigned long long _ZGVZN6Config4fontEvE1f;
static unsigned char _2E_str63[9] = "font.npf";
static struct l_struct_2E_Font _ZZN6Config4fontEvE1f;
static unsigned char _2E_str265[3] = "rb";
static unsigned int brushColours[12] = { 12058624u, 15649024u, 119u, 1083152u, 1052688u, 9127187u, 8900346u, 15624871u, 11680494u, 64154u, 16744192u, 7109515u };
static unsigned char _2E_str71[8] = "http://";
static unsigned char _2E_str172[35] = "Http::get host=%s port=%d file=%s\n";
static unsigned char _2E_str374[5] = "POST";
static unsigned char _2E_str475[17] = "http::post pump\n";
static unsigned char _2E_str576[21] = "http_get wobbly: %s\n";
static struct l_struct_2E___class_type_info_pseudo _ZTIN9happyhttp6WobblyE = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv117__class_type_infoE)) + 16ull)), ((&_ZTSN9happyhttp6WobblyE[((signed int )0u)])) } };
static unsigned char _ZTSN9happyhttp6WobblyE[20] = "N9happyhttp6WobblyE";
static unsigned char _2E_str1081[19] = "http status=%d %s\n";
static unsigned char _2E_str183[14] = "happyhttp.cpp";
static unsigned char _ZZN9happyhttp8Response18ProcessDataChunkedEPKhiE19__PRETTY_FUNCTION__[71] = "int happyhttp::Response::ProcessDataChunked(const unsigned char*, int)";
static unsigned char _2E_str284[17] = "m_ChunkLeft >= 0";
static unsigned char _2E_str385[22] = "m_State != STATUSLINE";
static unsigned char _ZZNK9happyhttp8Response9getreasonEvE19__PRETTY_FUNCTION__[51] = "const char* happyhttp::Response::getreason() const";
static unsigned char _ZZNK9happyhttp8Response9getstatusEvE19__PRETTY_FUNCTION__[43] = "int happyhttp::Response::getstatus() const";
static unsigned char _2E_str486[11] = "connection";
static unsigned char _2E_str587[6] = "close";
static unsigned char _2E_str688[11] = "keep-alive";
static unsigned char _2E_str789[18] = "transfer-encoding";
static unsigned char _2E_str890[8] = "chunked";
static unsigned char _2E_str991[15] = "content-length";
static unsigned char _2E_str1092[5] = "HEAD";
static unsigned char _2E_str1294[19] = "BadStatusLine (%s)";
static unsigned char _2E_str1395[10] = "HTTP:/1.0";
static unsigned char _2E_str1496[8] = "HTTP/1.";
static unsigned char _2E_str1597[21] = "UnknownProtocol (%s)";
static unsigned char _2E_str1698[14] = "datasize != 0";
static unsigned char _ZZN9happyhttp8Response4pumpEPKhiE19__PRETTY_FUNCTION__[57] = "int happyhttp::Response::pump(const unsigned char*, int)";
static unsigned char _2E_str1799[18] = "m_Chunked == true";
static unsigned char _2E_str18100[31] = "Connection closed unexpectedly";
static unsigned char _2E_str19101[19] = "putheader() failed";
static unsigned char _2E_str20102[3] = ": ";
static unsigned char _2E_str21103[3] = "%d";
static unsigned char _2E_str22104[23] = "Request already issued";
static unsigned char _2E_str23105[15] = "%s %s HTTP/1.1";
static unsigned char _2E_str24106[5] = "Host";
static unsigned char _2E_str25107[16] = "Accept-Encoding";
static unsigned char _2E_str26108[9] = "identity";
static struct l_struct_2E___mbstate_t_3A__3A__2E__54 _ZZN9happyhttp7atoaddrEPKcE5saddr;
static unsigned char _2E_str27109[7] = "%s: %s";
static unsigned char _2E_str28110[24] = "Invalid network address";
static unsigned char _2E_str29111[9] = "socket()";
static unsigned char _2E_str30112[10] = "connect()";
static unsigned char _2E_str31113[7] = "send()";
static unsigned char _2E_str32114[19] = "Cannot send header";
static unsigned char _2E_str33115[1];
static unsigned char _2E_str34116[3] = "\r\n";
static unsigned char _2E_str36118[15] = "Content-Length";
static unsigned char _2E_str37119[7] = "select";
static unsigned char _2E_str38120[10] = "m_Sock >0";
static unsigned char _ZZN9happyhttp10Connection4pumpEvE19__PRETTY_FUNCTION__[35] = "void happyhttp::Connection::pump()";
static unsigned char _2E_str39121[7] = "recv()";
static unsigned char _2E_str40122[15] = "r->completed()";
static unsigned char _2E_str41123[10] = "used == a";
static struct l_struct_2E___class_type_info_pseudo _ZTI2Os = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv117__class_type_infoE)) + 16ull)), ((&_ZTS2Os[((signed int )0u)])) } };
static unsigned char _ZTS2Os[4] = "2Os";
static unsigned int  (*_ZTV13OsFreeDesktop[6]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI13OsFreeDesktop)), ((unsigned int  (*) ())_ZN2Os4pollEv), ((unsigned int  (*) ())_ZN2Os13getLaunchFileEv), ((unsigned int  (*) ())_ZN13OsFreeDesktop11openBrowserEPKc), ((unsigned int  (*) ())_ZN13OsFreeDesktop10saveDialogEPKc) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI13OsFreeDesktop = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS13OsFreeDesktop[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI2Os)) };
static unsigned char _ZTS13OsFreeDesktop[16] = "13OsFreeDesktop";
static unsigned long long _ZGVZN2Os3getEvE2os;
static struct l_struct_2E_OsFreeDesktop _ZZN2Os3getEvE2os;
static unsigned char _2E_str124[12] = "xdg-open %s";
static unsigned int  (*_ZTV14b2PolygonShape[10]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI14b2PolygonShape)), ((unsigned int  (*) ())_ZNK14b2PolygonShape9TestPointERK7b2XFormRK6b2Vec2), ((unsigned int  (*) ())_ZNK14b2PolygonShape11TestSegmentERK7b2XFormPfP6b2Vec2RK9b2Segmentf), ((unsigned int  (*) ())_ZNK14b2PolygonShape11ComputeAABBEP6b2AABBRK7b2XForm), ((unsigned int  (*) ())_ZNK14b2PolygonShape16ComputeSweptAABBEP6b2AABBRK7b2XFormS4_), ((unsigned int  (*) ())_ZNK14b2PolygonShape11ComputeMassEP10b2MassData), ((unsigned int  (*) ())_ZN14b2PolygonShapeD1Ev), ((unsigned int  (*) ())_ZN14b2PolygonShapeD0Ev), ((unsigned int  (*) ())_ZN14b2PolygonShape17UpdateSweepRadiusERK6b2Vec2) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI14b2PolygonShape = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS14b2PolygonShape[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI7b2Shape)) };
static unsigned char _ZTS14b2PolygonShape[17] = "14b2PolygonShape";
static struct l_struct_2E___class_type_info_pseudo _ZTI7b2Shape = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv117__class_type_infoE)) + 16ull)), ((&_ZTS7b2Shape[((signed int )0u)])) } };
static unsigned char _2E_str125[19] = "m_vertexCount >= 3";
static unsigned char _2E_str1126[49] = "Box2D/Source/Collision/Shapes/b2PolygonShape.cpp";
static unsigned char _ZZNK14b2PolygonShape11ComputeMassEP10b2MassDataE19__PRETTY_FUNCTION__[60] = "virtual void b2PolygonShape::ComputeMass(b2MassData*) const";
static unsigned char _2E_str2127[22] = "area > 1.19209290e-7F";
static unsigned char _2E_str3128[36] = "0.0f <= lower && lower <= maxLambda";
static unsigned char _ZZNK14b2PolygonShape11TestSegmentERK7b2XFormPfP6b2Vec2RK9b2SegmentfE19__PRETTY_FUNCTION__[109] = "virtual bool b2PolygonShape::TestSegment(const b2XForm&, float32*, b2Vec2*, const b2Segment&, float32) const";
static unsigned char _2E_str5130[52] = "Box2D/Source/Collision/Shapes/../../Common/b2Math.h";
static unsigned char _ZZNK7b2Mat225SolveERK6b2Vec2E19__PRETTY_FUNCTION__[43] = "b2Vec2 b2Mat22::Solve(const b2Vec2&) const";
static unsigned char _2E_str6131[11] = "count >= 3";
static unsigned char _ZZL15ComputeCentroidPK6b2Vec2iE19__PRETTY_FUNCTION__[45] = "b2Vec2 ComputeCentroid(const b2Vec2*, int32)";
static unsigned char _2E_str7132[31] = "count <= b2_maxPolygonVertices";
static unsigned char _ZZL10ComputeOBBP5b2OBBPK6b2Vec2iE19__PRETTY_FUNCTION__[46] = "void ComputeOBB(b2OBB*, const b2Vec2*, int32)";
static unsigned char _2E_str8133[24] = "length > 1.19209290e-7F";
static unsigned char _2E_str9134[26] = "minArea < 3.40282347e+38F";
static unsigned char _2E_str10135[28] = "def->type == e_polygonShape";
static unsigned char _ZZN14b2PolygonShapeC4EPK10b2ShapeDefE19__PRETTY_FUNCTION__[50] = "b2PolygonShape::b2PolygonShape(const b2ShapeDef*)";
static unsigned char _2E_str11136[61] = "3 <= m_vertexCount && m_vertexCount <= b2_maxPolygonVertices";
static unsigned char _2E_str12137[55] = "edge.LengthSquared() > 1.19209290e-7F * 1.19209290e-7F";
static unsigned char _2E_str13138[12] = "d.x >= 0.0f";
static unsigned char _2E_str14139[12] = "d.y >= 0.0f";
static unsigned int  (*_ZTV7b2Joint[12]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI7b2Joint)), ((unsigned int  (*) ())__cxa_pure_virtual), ((unsigned int  (*) ())__cxa_pure_virtual), ((unsigned int  (*) ())__cxa_pure_virtual), ((unsigned int  (*) ())__cxa_pure_virtual), ((unsigned int  (*) ())_ZN7b2JointD1Ev), ((unsigned int  (*) ())_ZN7b2JointD0Ev), ((unsigned int  (*) ())__cxa_pure_virtual), ((unsigned int  (*) ())__cxa_pure_virtual), ((unsigned int  (*) ())_ZN7b2Joint23InitPositionConstraintsEv), ((unsigned int  (*) ())__cxa_pure_virtual) };
static struct l_struct_2E___class_type_info_pseudo _ZTI7b2Joint = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv117__class_type_infoE)) + 16ull)), ((&_ZTS7b2Joint[((signed int )0u)])) } };
static unsigned char _ZTS7b2Joint[9] = "7b2Joint";
static unsigned int  (*_ZTV15b2RevoluteJoint[12]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI15b2RevoluteJoint)), ((unsigned int  (*) ())_ZNK15b2RevoluteJoint10GetAnchor1Ev), ((unsigned int  (*) ())_ZNK15b2RevoluteJoint10GetAnchor2Ev), ((unsigned int  (*) ())_ZNK15b2RevoluteJoint16GetReactionForceEv), ((unsigned int  (*) ())_ZNK15b2RevoluteJoint17GetReactionTorqueEv), ((unsigned int  (*) ())_ZN15b2RevoluteJointD1Ev), ((unsigned int  (*) ())_ZN15b2RevoluteJointD0Ev), ((unsigned int  (*) ())_ZN15b2RevoluteJoint23InitVelocityConstraintsERK10b2TimeStep), ((unsigned int  (*) ())_ZN15b2RevoluteJoint24SolveVelocityConstraintsERK10b2TimeStep), ((unsigned int  (*) ())_ZN7b2Joint23InitPositionConstraintsEv), ((unsigned int  (*) ())_ZN15b2RevoluteJoint24SolvePositionConstraintsEv) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI15b2RevoluteJoint = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS15b2RevoluteJoint[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI7b2Joint)) };
static unsigned char _ZTS15b2RevoluteJoint[18] = "15b2RevoluteJoint";
static unsigned char _2E_str146[25] = "m_world->m_lock == false";
static unsigned char _2E_str1147[33] = "Box2D/Source/Dynamics/b2Body.cpp";
static unsigned char _ZZN6b2BodyD4EvE19__PRETTY_FUNCTION__[18] = "b2Body::~b2Body()";
static unsigned char _2E_str2148[23] = "world->m_lock == false";
static unsigned char _ZZN6b2BodyC4EPK9b2BodyDefP7b2WorldE19__PRETTY_FUNCTION__[43] = "b2Body::b2Body(const b2BodyDef*, b2World*)";
static unsigned char _ZZN6b2Body8SetXFormERK6b2Vec2fE19__PRETTY_FUNCTION__[46] = "bool b2Body::SetXForm(const b2Vec2&, float32)";
static unsigned char _ZZN6b2Body17SetMassFromShapesEvE19__PRETTY_FUNCTION__[33] = "void b2Body::SetMassFromShapes()";
static unsigned char _2E_str3149[11] = "m_I > 0.0f";
static unsigned char _ZZN6b2Body11CreateShapeEP10b2ShapeDefE19__PRETTY_FUNCTION__[42] = "b2Shape* b2Body::CreateShape(b2ShapeDef*)";
static unsigned int  (*_ZTV9b2Contact[6]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI9b2Contact)), ((unsigned int  (*) ())__cxa_pure_virtual), ((unsigned int  (*) ())_ZN9b2ContactD1Ev), ((unsigned int  (*) ())_ZN9b2ContactD0Ev), ((unsigned int  (*) ())__cxa_pure_virtual) };
static struct l_struct_2E___class_type_info_pseudo _ZTI9b2Contact = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv117__class_type_infoE)) + 16ull)), ((&_ZTS9b2Contact[((signed int )0u)])) } };
static unsigned char _ZTS9b2Contact[11] = "9b2Contact";
static unsigned int  (*_ZTV13b2NullContact[6]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI13b2NullContact)), ((unsigned int  (*) ())_ZN13b2NullContact12GetManifoldsEv), ((unsigned int  (*) ())_ZN13b2NullContactD1Ev), ((unsigned int  (*) ())_ZN13b2NullContactD0Ev), ((unsigned int  (*) ())_ZN13b2NullContact8EvaluateEP17b2ContactListener) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI13b2NullContact = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS13b2NullContact[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI9b2Contact)) };
static unsigned char _ZTS13b2NullContact[16] = "13b2NullContact";
static unsigned int  (*_ZTV14b2PairCallback[6]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI14b2PairCallback)), ((unsigned int  (*) ())_ZN14b2PairCallbackD1Ev), ((unsigned int  (*) ())_ZN14b2PairCallbackD0Ev), ((unsigned int  (*) ())__cxa_pure_virtual), ((unsigned int  (*) ())__cxa_pure_virtual) };
static struct l_struct_2E___class_type_info_pseudo _ZTI14b2PairCallback = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv117__class_type_infoE)) + 16ull)), ((&_ZTS14b2PairCallback[((signed int )0u)])) } };
static unsigned char _ZTS14b2PairCallback[17] = "14b2PairCallback";
static unsigned int  (*_ZTV16b2ContactManager[6]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI16b2ContactManager)), ((unsigned int  (*) ())_ZN16b2ContactManagerD1Ev), ((unsigned int  (*) ())_ZN16b2ContactManagerD0Ev), ((unsigned int  (*) ())_ZN16b2ContactManager9PairAddedEPvS0_), ((unsigned int  (*) ())_ZN16b2ContactManager11PairRemovedEPvS0_S0_) };
static unsigned char _2E_str153[37] = "vertexCount <= b2_maxPolygonVertices";
static unsigned char _2E_str1154[34] = "Box2D/Source/Dynamics/b2World.cpp";
static unsigned char _ZZN7b2World9DrawShapeEP7b2ShapeRK7b2XFormRK7b2ColorbE19__PRETTY_FUNCTION__[72] = "void b2World::DrawShape(b2Shape*, const b2XForm&, const b2Color&, bool)";
static unsigned char _2E_str2155[29] = "m_bodyCount < m_bodyCapacity";
static unsigned char _2E_str3156[33] = "Box2D/Source/Dynamics/b2Island.h";
static unsigned char _ZZN8b2Island3AddEP6b2BodyE19__PRETTY_FUNCTION__[28] = "void b2Island::Add(b2Body*)";
static unsigned char _2E_str4157[35] = "m_contactCount < m_contactCapacity";
static unsigned char _ZZN8b2Island3AddEP9b2ContactE19__PRETTY_FUNCTION__[31] = "void b2Island::Add(b2Contact*)";
static unsigned char _2E_str5158[31] = "m_jointCount < m_jointCapacity";
static unsigned char _ZZN8b2Island3AddEP7b2JointE19__PRETTY_FUNCTION__[29] = "void b2Island::Add(b2Joint*)";
static unsigned char _2E_str6159[10] = "t0 < 1.0f";
static unsigned char _ZZN7b2World8SolveTOIERK10b2TimeStepE19__PRETTY_FUNCTION__[42] = "void b2World::SolveTOI(const b2TimeStep&)";
static unsigned char _2E_str7160[27] = "0.0f <= toi && toi <= 1.0f";
static unsigned char _2E_str8161[23] = "stackCount < stackSize";
static unsigned char _2E_str9162[28] = "subStep.dt > 1.19209290e-7F";
static unsigned char _ZZN7b2World5SolveERK10b2TimeStepE19__PRETTY_FUNCTION__[39] = "void b2World::Solve(const b2TimeStep&)";
static unsigned char _2E_str10163[16] = "m_lock == false";
static unsigned char _ZZN7b2World12DestroyJointEP7b2JointE19__PRETTY_FUNCTION__[37] = "void b2World::DestroyJoint(b2Joint*)";
static unsigned char _2E_str11164[17] = "m_jointCount > 0";
static unsigned char _ZZN7b2World11CreateJointEPK10b2JointDefE19__PRETTY_FUNCTION__[49] = "b2Joint* b2World::CreateJoint(const b2JointDef*)";
static unsigned char _2E_str12165[16] = "m_bodyCount > 0";
static unsigned char _ZZN7b2World11DestroyBodyEP6b2BodyE19__PRETTY_FUNCTION__[35] = "void b2World::DestroyBody(b2Body*)";
static unsigned char _ZZN7b2World10CreateBodyEPK9b2BodyDefE19__PRETTY_FUNCTION__[46] = "b2Body* b2World::CreateBody(const b2BodyDef*)";
static struct l_struct_2E_Os b2_defaultFilter;
static unsigned char _2E_str166[23] = "sweep1.t0 == sweep2.t0";
static unsigned char _2E_str1167[42] = "Box2D/Source/Collision/b2TimeOfImpact.cpp";
static unsigned char _ZZ14b2TimeOfImpactPK7b2ShapeRK7b2SweepS1_S4_E19__PRETTY_FUNCTION__[87] = "float32 b2TimeOfImpact(const b2Shape*, const b2Sweep&, const b2Shape*, const b2Sweep&)";
static unsigned char _2E_str2168[34] = "1.0f - sweep1.t0 > 1.19209290e-7F";
static unsigned int b2_byteCount;
static unsigned char _2E_str169[21] = "b2_byteCount >= size";
static unsigned char _2E_str1170[35] = "Box2D/Source/Common/b2Settings.cpp";
static unsigned char _ZZ6b2FreePvE19__PRETTY_FUNCTION__[19] = "void b2Free(void*)";
static unsigned char _2E_str171[6] = "false";
static unsigned char _2E_str1172[41] = "Box2D/Source/Dynamics/Joints/b2Joint.cpp";
static unsigned char _ZZN7b2Joint7DestroyEPS_P16b2BlockAllocatorE19__PRETTY_FUNCTION__[58] = "static void b2Joint::Destroy(b2Joint*, b2BlockAllocator*)";
static unsigned char _ZZN7b2Joint6CreateEPK10b2JointDefP16b2BlockAllocatorE19__PRETTY_FUNCTION__[70] = "static b2Joint* b2Joint::Create(const b2JointDef*, b2BlockAllocator*)";
static unsigned int  (*_ZTV7b2Shape[10]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI7b2Shape)), ((unsigned int  (*) ())__cxa_pure_virtual), ((unsigned int  (*) ())__cxa_pure_virtual), ((unsigned int  (*) ())__cxa_pure_virtual), ((unsigned int  (*) ())__cxa_pure_virtual), ((unsigned int  (*) ())__cxa_pure_virtual), ((unsigned int  (*) ())_ZN7b2ShapeD1Ev), ((unsigned int  (*) ())_ZN7b2ShapeD0Ev), ((unsigned int  (*) ())__cxa_pure_virtual) };
static unsigned char _ZTS7b2Shape[9] = "7b2Shape";
static unsigned char _2E_str173[26] = "m_proxyId == b2_nullProxy";
static unsigned char _2E_str1174[42] = "Box2D/Source/Collision/Shapes/b2Shape.cpp";
static unsigned char _ZZN7b2Shape11CreateProxyEP12b2BroadPhaseRK7b2XFormE19__PRETTY_FUNCTION__[57] = "void b2Shape::CreateProxy(b2BroadPhase*, const b2XForm&)";
static unsigned char _2E_str2175[8] = "inRange";
static unsigned char _ZZN7b2ShapeD4EvE19__PRETTY_FUNCTION__[28] = "virtual b2Shape::~b2Shape()";
static unsigned char _ZZN7b2Shape7DestroyEPS_P16b2BlockAllocatorE19__PRETTY_FUNCTION__[58] = "static void b2Shape::Destroy(b2Shape*, b2BlockAllocator*)";
static unsigned char _ZZN7b2Shape6CreateEPK10b2ShapeDefP16b2BlockAllocatorE19__PRETTY_FUNCTION__[70] = "static b2Shape* b2Shape::Create(const b2ShapeDef*, b2BlockAllocator*)";
static unsigned int _ZN16b2BlockAllocator12s_blockSizesE[14] = { 16u, 32u, 64u, 96u, 128u, 160u, 192u, 224u, 256u, 320u, 384u, 448u, 512u, 640u };
static unsigned char _2E_str177[36] = "0 < size && size <= b2_maxBlockSize";
static unsigned char _2E_str1178[41] = "Box2D/Source/Common/b2BlockAllocator.cpp";
static unsigned char _ZZN16b2BlockAllocator4FreeEPviE19__PRETTY_FUNCTION__[42] = "void b2BlockAllocator::Free(void*, int32)";
static unsigned char _ZN16b2BlockAllocator17s_blockSizeLookupE[641];
static unsigned char _2E_str2179[36] = "0 <= index && index < b2_blockSizes";
static bool _ZN16b2BlockAllocator28s_blockSizeLookupInitializedE_2E_b;
static unsigned char _2E_str3180[18] = "j < b2_blockSizes";
static unsigned char _ZZN16b2BlockAllocatorC4EvE19__PRETTY_FUNCTION__[37] = "b2BlockAllocator::b2BlockAllocator()";
static unsigned char _ZZN16b2BlockAllocator8AllocateEiE19__PRETTY_FUNCTION__[40] = "void* b2BlockAllocator::Allocate(int32)";
static unsigned char _2E_str4181[39] = "blockCount * blockSize <= b2_chunkSize";
static unsigned char _2E_str184[13] = "m_index == 0";
static unsigned char _2E_str1185[41] = "Box2D/Source/Common/b2StackAllocator.cpp";
static unsigned char _ZZN16b2StackAllocatorD4EvE19__PRETTY_FUNCTION__[38] = "b2StackAllocator::~b2StackAllocator()";
static unsigned char _2E_str2186[18] = "m_entryCount == 0";
static unsigned char _2E_str3187[17] = "m_entryCount > 0";
static unsigned char _ZZN16b2StackAllocator4FreeEPvE19__PRETTY_FUNCTION__[35] = "void b2StackAllocator::Free(void*)";
static unsigned char _2E_str4188[17] = "p == entry->data";
static unsigned char _2E_str5189[34] = "m_entryCount < b2_maxStackEntries";
static unsigned char _ZZN16b2StackAllocator8AllocateEiE19__PRETTY_FUNCTION__[40] = "void* b2StackAllocator::Allocate(int32)";
static struct l_struct_2E___si_class_type_info_pseudo _ZTI16b2ContactManager = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS16b2ContactManager[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI14b2PairCallback)) };
static unsigned char _ZTS16b2ContactManager[19] = "16b2ContactManager";
static unsigned char _2E_str1191[40] = "Box2D/Source/Collision/b2BroadPhase.cpp";
static unsigned char _2E_str7197[35] = "m_queryResultCount < b2_maxProxies";
static unsigned char _ZZN12b2BroadPhase21IncrementOverlapCountEiE19__PRETTY_FUNCTION__[48] = "void b2BroadPhase::IncrementOverlapCount(int32)";
static unsigned char _2E_str8198[7] = "i >= 0";
static unsigned char _ZZN12b2BroadPhase5QueryEPiS0_ttP7b2BoundiiE19__PRETTY_FUNCTION__[81] = "void b2BroadPhase::Query(int32*, int32*, uint16, uint16, b2Bound*, int32, int32)";
static unsigned char _2E_str9199[38] = "aabb.upperBound.x > aabb.lowerBound.x";
static unsigned char _ZZN12b2BroadPhase13ComputeBoundsEPtS0_RK6b2AABBE19__PRETTY_FUNCTION__[66] = "void b2BroadPhase::ComputeBounds(uint16*, uint16*, const b2AABB&)";
static unsigned char _2E_str10200[38] = "aabb.upperBound.y > aabb.lowerBound.y";
static unsigned char _2E_str11201[34] = "m_queryResults[i] < b2_maxProxies";
static unsigned char _2E_str12202[17] = "proxy->IsValid()";
static unsigned char _2E_str13203[40] = "p->lowerBounds[axis] < 2 * m_proxyCount";
static unsigned char _ZZN12b2BroadPhase11TestOverlapERK13b2BoundValuesP7b2ProxyE19__PRETTY_FUNCTION__[63] = "bool b2BroadPhase::TestOverlap(const b2BoundValues&, b2Proxy*)";
static unsigned char _2E_str14204[40] = "p->upperBounds[axis] < 2 * m_proxyCount";
static unsigned char _2E_str15205[41] = "p1->lowerBounds[axis] < 2 * m_proxyCount";
static unsigned char _ZZN12b2BroadPhase11TestOverlapEP7b2ProxyS1_E19__PRETTY_FUNCTION__[51] = "bool b2BroadPhase::TestOverlap(b2Proxy*, b2Proxy*)";
static unsigned char _2E_str16206[41] = "p1->upperBounds[axis] < 2 * m_proxyCount";
static unsigned char _2E_str17207[41] = "p2->lowerBounds[axis] < 2 * m_proxyCount";
static unsigned char _2E_str18208[41] = "p2->upperBounds[axis] < 2 * m_proxyCount";
static unsigned char _ZZN12b2BroadPhase9MoveProxyEiRK6b2AABBE19__PRETTY_FUNCTION__[51] = "void b2BroadPhase::MoveProxy(int32, const b2AABB&)";
static unsigned char _2E_str20210[50] = "0 < m_proxyCount && m_proxyCount <= b2_maxProxies";
static unsigned char _ZZN12b2BroadPhase12DestroyProxyEiE19__PRETTY_FUNCTION__[39] = "void b2BroadPhase::DestroyProxy(int32)";
static unsigned char _2E_str21211[41] = "m_proxyPool[m_queryResults[i]].IsValid()";
static unsigned char _2E_str22212[29] = "m_proxyCount < b2_maxProxies";
static unsigned char _ZZN12b2BroadPhase11CreateProxyERK6b2AABBPvE19__PRETTY_FUNCTION__[55] = "uint16 b2BroadPhase::CreateProxy(const b2AABB&, void*)";
static unsigned char _2E_str23213[28] = "m_freeProxy != b2_nullProxy";
static unsigned char _2E_str24214[20] = "worldAABB.IsValid()";
static unsigned char _ZZN12b2BroadPhaseC4ERK6b2AABBP14b2PairCallbackE19__PRETTY_FUNCTION__[59] = "b2BroadPhase::b2BroadPhase(const b2AABB&, b2PairCallback*)";
static struct l_struct_2E_b2ContactRegister _ZN9b2Contact11s_registersE[2][2];
static bool _ZN9b2Contact13s_initializedE_2E_b;
static unsigned char _2E_str215[22] = "s_initialized == true";
static unsigned char _2E_str1216[45] = "Box2D/Source/Dynamics/Contacts/b2Contact.cpp";
static unsigned char _ZZN9b2Contact7DestroyEPS_P16b2BlockAllocatorE19__PRETTY_FUNCTION__[62] = "static void b2Contact::Destroy(b2Contact*, b2BlockAllocator*)";
static unsigned char _2E_str2217[51] = "e_unknownShape < type1 && type1 < e_shapeTypeCount";
static unsigned char _2E_str3218[51] = "e_unknownShape < type2 && type2 < e_shapeTypeCount";
static unsigned char _ZZN9b2Contact6CreateEP7b2ShapeS1_P16b2BlockAllocatorE19__PRETTY_FUNCTION__[75] = "static b2Contact* b2Contact::Create(b2Shape*, b2Shape*, b2BlockAllocator*)";
static unsigned int  (*_ZTV15b2ContactFilter[5]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI15b2ContactFilter)), ((unsigned int  (*) ())_ZN15b2ContactFilterD1Ev), ((unsigned int  (*) ())_ZN15b2ContactFilterD0Ev), ((unsigned int  (*) ())_ZN15b2ContactFilter13ShouldCollideEP7b2ShapeS1_) };
static struct l_struct_2E___class_type_info_pseudo _ZTI15b2ContactFilter = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv117__class_type_infoE)) + 16ull)), ((&_ZTS15b2ContactFilter[((signed int )0u)])) } };
static unsigned char _ZTS15b2ContactFilter[18] = "15b2ContactFilter";
static unsigned int  (*_ZTV13b2PulleyJoint[12]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI13b2PulleyJoint)), ((unsigned int  (*) ())_ZNK13b2PulleyJoint10GetAnchor1Ev), ((unsigned int  (*) ())_ZNK13b2PulleyJoint10GetAnchor2Ev), ((unsigned int  (*) ())_ZNK13b2PulleyJoint16GetReactionForceEv), ((unsigned int  (*) ())_ZNK13b2PulleyJoint17GetReactionTorqueEv), ((unsigned int  (*) ())_ZN13b2PulleyJointD1Ev), ((unsigned int  (*) ())_ZN13b2PulleyJointD0Ev), ((unsigned int  (*) ())_ZN13b2PulleyJoint23InitVelocityConstraintsERK10b2TimeStep), ((unsigned int  (*) ())_ZN13b2PulleyJoint24SolveVelocityConstraintsERK10b2TimeStep), ((unsigned int  (*) ())_ZN7b2Joint23InitPositionConstraintsEv), ((unsigned int  (*) ())_ZN13b2PulleyJoint24SolvePositionConstraintsEv) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI13b2PulleyJoint = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS13b2PulleyJoint[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI7b2Joint)) };
static unsigned char _ZTS13b2PulleyJoint[16] = "13b2PulleyJoint";
static unsigned char _2E_str221[30] = "m_limitMass1 > 1.19209290e-7F";
static unsigned char _2E_str1222[47] = "Box2D/Source/Dynamics/Joints/b2PulleyJoint.cpp";
static unsigned char _ZZN13b2PulleyJoint23InitVelocityConstraintsERK10b2TimeStepE19__PRETTY_FUNCTION__[71] = "virtual void b2PulleyJoint::InitVelocityConstraints(const b2TimeStep&)";
static unsigned char _2E_str2223[30] = "m_limitMass2 > 1.19209290e-7F";
static unsigned char _2E_str3224[30] = "m_pulleyMass > 1.19209290e-7F";
static unsigned char _2E_str5226[19] = "def->ratio != 0.0f";
static unsigned char _ZZN13b2PulleyJointC4EPK16b2PulleyJointDefE19__PRETTY_FUNCTION__[54] = "b2PulleyJoint::b2PulleyJoint(const b2PulleyJointDef*)";
static unsigned int  (*_ZTV11b2GearJoint[12]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI11b2GearJoint)), ((unsigned int  (*) ())_ZNK11b2GearJoint10GetAnchor1Ev), ((unsigned int  (*) ())_ZNK11b2GearJoint10GetAnchor2Ev), ((unsigned int  (*) ())_ZNK11b2GearJoint16GetReactionForceEv), ((unsigned int  (*) ())_ZNK11b2GearJoint17GetReactionTorqueEv), ((unsigned int  (*) ())_ZN11b2GearJointD1Ev), ((unsigned int  (*) ())_ZN11b2GearJointD0Ev), ((unsigned int  (*) ())_ZN11b2GearJoint23InitVelocityConstraintsERK10b2TimeStep), ((unsigned int  (*) ())_ZN11b2GearJoint24SolveVelocityConstraintsERK10b2TimeStep), ((unsigned int  (*) ())_ZN7b2Joint23InitPositionConstraintsEv), ((unsigned int  (*) ())_ZN11b2GearJoint24SolvePositionConstraintsEv) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI11b2GearJoint = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS11b2GearJoint[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI7b2Joint)) };
static unsigned char _ZTS11b2GearJoint[14] = "11b2GearJoint";
static unsigned char _2E_str228[9] = "K > 0.0f";
static unsigned char _2E_str1229[45] = "Box2D/Source/Dynamics/Joints/b2GearJoint.cpp";
static unsigned char _ZZN11b2GearJoint23InitVelocityConstraintsERK10b2TimeStepE19__PRETTY_FUNCTION__[69] = "virtual void b2GearJoint::InitVelocityConstraints(const b2TimeStep&)";
static unsigned char _2E_str2230[54] = "type1 == e_revoluteJoint || type1 == e_prismaticJoint";
static unsigned char _ZZN11b2GearJointC4EPK14b2GearJointDefE19__PRETTY_FUNCTION__[48] = "b2GearJoint::b2GearJoint(const b2GearJointDef*)";
static unsigned char _2E_str3231[54] = "type2 == e_revoluteJoint || type2 == e_prismaticJoint";
static unsigned char _2E_str4232[36] = "def->joint1->GetBody1()->IsStatic()";
static unsigned char _2E_str5233[36] = "def->joint2->GetBody1()->IsStatic()";
static unsigned char _2E_str234[23] = "sn > 0.0f || tn > 0.0f";
static unsigned char _2E_str1235[38] = "Box2D/Source/Collision/b2Distance.cpp";
static unsigned char _ZZL12ProcessThreeP6b2Vec2S0_S0_S0_S0_E19__PRETTY_FUNCTION__[64] = "int32 ProcessThree(b2Vec2*, b2Vec2*, b2Vec2*, b2Vec2*, b2Vec2*)";
static unsigned char _2E_str2236[23] = "sd > 0.0f || un > 0.0f";
static unsigned char _2E_str3237[36] = "vc > 0.0f || sn > 0.0f || sd > 0.0f";
static unsigned char _2E_str4238[15] = "un + ud > 0.0f";
static unsigned char _2E_str5239[15] = "tn + td > 0.0f";
static unsigned char _2E_str6240[13] = "denom > 0.0f";
static unsigned int  (*_ZTV12b2MouseJoint[12]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI12b2MouseJoint)), ((unsigned int  (*) ())_ZNK12b2MouseJoint10GetAnchor1Ev), ((unsigned int  (*) ())_ZNK12b2MouseJoint10GetAnchor2Ev), ((unsigned int  (*) ())_ZNK12b2MouseJoint16GetReactionForceEv), ((unsigned int  (*) ())_ZNK12b2MouseJoint17GetReactionTorqueEv), ((unsigned int  (*) ())_ZN12b2MouseJointD1Ev), ((unsigned int  (*) ())_ZN12b2MouseJointD0Ev), ((unsigned int  (*) ())_ZN12b2MouseJoint23InitVelocityConstraintsERK10b2TimeStep), ((unsigned int  (*) ())_ZN12b2MouseJoint24SolveVelocityConstraintsERK10b2TimeStep), ((unsigned int  (*) ())_ZN7b2Joint23InitPositionConstraintsEv), ((unsigned int  (*) ())_ZN12b2MouseJoint24SolvePositionConstraintsEv) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI12b2MouseJoint = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS12b2MouseJoint[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI7b2Joint)) };
static unsigned char _ZTS12b2MouseJoint[15] = "12b2MouseJoint";
static unsigned char _2E_str2244[23] = "d + k > 1.19209290e-7F";
static unsigned char _2E_str3245[46] = "Box2D/Source/Dynamics/Joints/b2MouseJoint.cpp";
static unsigned char _ZZN12b2MouseJointC4EPK15b2MouseJointDefE19__PRETTY_FUNCTION__[51] = "b2MouseJoint::b2MouseJoint(const b2MouseJointDef*)";
static unsigned int  (*_ZTV13b2CircleShape[10]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI13b2CircleShape)), ((unsigned int  (*) ())_ZNK13b2CircleShape9TestPointERK7b2XFormRK6b2Vec2), ((unsigned int  (*) ())_ZNK13b2CircleShape11TestSegmentERK7b2XFormPfP6b2Vec2RK9b2Segmentf), ((unsigned int  (*) ())_ZNK13b2CircleShape11ComputeAABBEP6b2AABBRK7b2XForm), ((unsigned int  (*) ())_ZNK13b2CircleShape16ComputeSweptAABBEP6b2AABBRK7b2XFormS4_), ((unsigned int  (*) ())_ZNK13b2CircleShape11ComputeMassEP10b2MassData), ((unsigned int  (*) ())_ZN13b2CircleShapeD1Ev), ((unsigned int  (*) ())_ZN13b2CircleShapeD0Ev), ((unsigned int  (*) ())_ZN13b2CircleShape17UpdateSweepRadiusERK6b2Vec2) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI13b2CircleShape = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS13b2CircleShape[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI7b2Shape)) };
static unsigned char _ZTS13b2CircleShape[16] = "13b2CircleShape";
static unsigned char _2E_str246[27] = "def->type == e_circleShape";
static unsigned char _2E_str1247[48] = "Box2D/Source/Collision/Shapes/b2CircleShape.cpp";
static unsigned char _ZZN13b2CircleShapeC4EPK10b2ShapeDefE19__PRETTY_FUNCTION__[48] = "b2CircleShape::b2CircleShape(const b2ShapeDef*)";
static unsigned char _2E_str248[16] = "m_pairCount > 0";
static unsigned char _2E_str1249[41] = "Box2D/Source/Collision/b2PairManager.cpp";
static unsigned char _ZZN13b2PairManager10RemovePairEiiE19__PRETTY_FUNCTION__[46] = "void* b2PairManager::RemovePair(int32, int32)";
static unsigned char _2E_str3251[20] = "index < b2_maxPairs";
static unsigned char _ZZN13b2PairManager4FindEiijE19__PRETTY_FUNCTION__[50] = "b2Pair* b2PairManager::Find(int32, int32, uint32)";
static unsigned char _2E_str4252[55] = "m_pairCount < b2_maxPairs && m_freePair != b2_nullPair";
static unsigned char _ZZN13b2PairManager7AddPairEiiE19__PRETTY_FUNCTION__[45] = "b2Pair* b2PairManager::AddPair(int32, int32)";
static unsigned char _2E_str5253[43] = "id1 != b2_nullProxy && id2 != b2_nullProxy";
static unsigned char _ZZN13b2PairManager15AddBufferedPairEiiE19__PRETTY_FUNCTION__[50] = "void b2PairManager::AddBufferedPair(int32, int32)";
static unsigned char _2E_str6254[32] = "m_pairBufferCount < b2_maxPairs";
static unsigned char _2E_str7255[25] = "pair->IsFinal() == false";
static unsigned char _2E_str8256[33] = "m_pairBufferCount <= m_pairCount";
static unsigned char _ZZN13b2PairManager18RemoveBufferedPairEiiE19__PRETTY_FUNCTION__[53] = "void b2PairManager::RemoveBufferedPair(int32, int32)";
static unsigned char _2E_str9257[24] = "pair->IsFinal() == true";
static unsigned char _2E_str11259[19] = "pair->IsBuffered()";
static unsigned char _ZZN13b2PairManager6CommitEvE19__PRETTY_FUNCTION__[29] = "void b2PairManager::Commit()";
static unsigned char _2E_str12260[65] = "pair->proxyId1 < b2_maxProxies && pair->proxyId2 < b2_maxProxies";
static unsigned char _2E_str13261[18] = "proxy1->IsValid()";
static unsigned char _2E_str14262[18] = "proxy2->IsValid()";
static unsigned char _2E_str15263[50] = "m_broadPhase->TestOverlap(proxy1, proxy2) == true";
static unsigned int  (*_ZTV15b2CircleContact[6]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI15b2CircleContact)), ((unsigned int  (*) ())_ZN15b2CircleContact12GetManifoldsEv), ((unsigned int  (*) ())_ZN15b2CircleContactD1Ev), ((unsigned int  (*) ())_ZN15b2CircleContactD0Ev), ((unsigned int  (*) ())_ZN15b2CircleContact8EvaluateEP17b2ContactListener) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI15b2CircleContact = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS15b2CircleContact[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI9b2Contact)) };
static unsigned char _ZTS15b2CircleContact[18] = "15b2CircleContact";
static unsigned char _2E_str264[37] = "m_shape1->GetType() == e_circleShape";
static unsigned char _2E_str1265[51] = "Box2D/Source/Dynamics/Contacts/b2CircleContact.cpp";
static unsigned char _ZZN15b2CircleContactC4EP7b2ShapeS1_E19__PRETTY_FUNCTION__[53] = "b2CircleContact::b2CircleContact(b2Shape*, b2Shape*)";
static unsigned char _2E_str2266[37] = "m_shape2->GetType() == e_circleShape";
static unsigned char _2E_str268[23] = "contacts[i]->IsSolid()";
static unsigned char _2E_str1269[51] = "Box2D/Source/Dynamics/Contacts/b2ContactSolver.cpp";
static unsigned char _ZZN15b2ContactSolverC4ERK10b2TimeStepPP9b2ContactiP16b2StackAllocatorE19__PRETTY_FUNCTION__[91] = "b2ContactSolver::b2ContactSolver(const b2TimeStep&, b2Contact**, int32, b2StackAllocator*)";
static unsigned char _2E_str2270[25] = "manifold->pointCount > 0";
static unsigned char _2E_str3271[26] = "count < m_constraintCount";
static unsigned char _2E_str4272[25] = "kNormal > 1.19209290e-7F";
static unsigned char _2E_str5273[28] = "kEqualized > 1.19209290e-7F";
static unsigned char _2E_str6274[26] = "kTangent > 1.19209290e-7F";
static unsigned char _2E_str7275[27] = "count == m_constraintCount";
static unsigned int  (*_ZTV15b2DistanceJoint[12]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI15b2DistanceJoint)), ((unsigned int  (*) ())_ZNK15b2DistanceJoint10GetAnchor1Ev), ((unsigned int  (*) ())_ZNK15b2DistanceJoint10GetAnchor2Ev), ((unsigned int  (*) ())_ZNK15b2DistanceJoint16GetReactionForceEv), ((unsigned int  (*) ())_ZNK15b2DistanceJoint17GetReactionTorqueEv), ((unsigned int  (*) ())_ZN15b2DistanceJointD1Ev), ((unsigned int  (*) ())_ZN15b2DistanceJointD0Ev), ((unsigned int  (*) ())_ZN15b2DistanceJoint23InitVelocityConstraintsERK10b2TimeStep), ((unsigned int  (*) ())_ZN15b2DistanceJoint24SolveVelocityConstraintsERK10b2TimeStep), ((unsigned int  (*) ())_ZN7b2Joint23InitPositionConstraintsEv), ((unsigned int  (*) ())_ZN15b2DistanceJoint24SolvePositionConstraintsEv) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI15b2DistanceJoint = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS15b2DistanceJoint[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI7b2Joint)) };
static unsigned char _ZTS15b2DistanceJoint[18] = "15b2DistanceJoint";
static unsigned char _2E_str277[25] = "invMass > 1.19209290e-7F";
static unsigned char _2E_str1278[49] = "Box2D/Source/Dynamics/Joints/b2DistanceJoint.cpp";
static unsigned char _ZZN15b2DistanceJoint23InitVelocityConstraintsERK10b2TimeStepE19__PRETTY_FUNCTION__[73] = "virtual void b2DistanceJoint::InitVelocityConstraints(const b2TimeStep&)";
static unsigned int  (*_ZTV16b2PolygonContact[6]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI16b2PolygonContact)), ((unsigned int  (*) ())_ZN16b2PolygonContact12GetManifoldsEv), ((unsigned int  (*) ())_ZN16b2PolygonContactD1Ev), ((unsigned int  (*) ())_ZN16b2PolygonContactD0Ev), ((unsigned int  (*) ())_ZN16b2PolygonContact8EvaluateEP17b2ContactListener) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI16b2PolygonContact = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS16b2PolygonContact[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI9b2Contact)) };
static unsigned char _ZTS16b2PolygonContact[19] = "16b2PolygonContact";
static unsigned char _2E_str279[38] = "m_shape1->GetType() == e_polygonShape";
static unsigned char _2E_str1280[49] = "Box2D/Source/Dynamics/Contacts/b2PolyContact.cpp";
static unsigned char _ZZN16b2PolygonContactC4EP7b2ShapeS1_E19__PRETTY_FUNCTION__[55] = "b2PolygonContact::b2PolygonContact(b2Shape*, b2Shape*)";
static unsigned char _2E_str2281[38] = "m_shape2->GetType() == e_polygonShape";
static unsigned int  (*_ZTV16b2PrismaticJoint[12]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI16b2PrismaticJoint)), ((unsigned int  (*) ())_ZNK16b2PrismaticJoint10GetAnchor1Ev), ((unsigned int  (*) ())_ZNK16b2PrismaticJoint10GetAnchor2Ev), ((unsigned int  (*) ())_ZNK16b2PrismaticJoint16GetReactionForceEv), ((unsigned int  (*) ())_ZNK16b2PrismaticJoint17GetReactionTorqueEv), ((unsigned int  (*) ())_ZN16b2PrismaticJointD1Ev), ((unsigned int  (*) ())_ZN16b2PrismaticJointD0Ev), ((unsigned int  (*) ())_ZN16b2PrismaticJoint23InitVelocityConstraintsERK10b2TimeStep), ((unsigned int  (*) ())_ZN16b2PrismaticJoint24SolveVelocityConstraintsERK10b2TimeStep), ((unsigned int  (*) ())_ZN7b2Joint23InitPositionConstraintsEv), ((unsigned int  (*) ())_ZN16b2PrismaticJoint24SolvePositionConstraintsEv) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI16b2PrismaticJoint = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS16b2PrismaticJoint[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI7b2Joint)) };
static unsigned char _ZTS16b2PrismaticJoint[19] = "16b2PrismaticJoint";
static unsigned char _2E_str1283[50] = "Box2D/Source/Dynamics/Joints/b2PrismaticJoint.cpp";
static unsigned char _2E_str2284[30] = "m_linearMass > 1.19209290e-7F";
static unsigned char _ZZN16b2PrismaticJoint23InitVelocityConstraintsERK10b2TimeStepE19__PRETTY_FUNCTION__[74] = "virtual void b2PrismaticJoint::InitVelocityConstraints(const b2TimeStep&)";
static unsigned char _2E_str3285[29] = "m_motorMass > 1.19209290e-7F";
static unsigned int  (*_ZTV22b2PolyAndCircleContact[6]) () = { ((unsigned int  (*) ())/*NULL*/0), ((unsigned int  (*) ())(&_ZTI22b2PolyAndCircleContact)), ((unsigned int  (*) ())_ZN22b2PolyAndCircleContact12GetManifoldsEv), ((unsigned int  (*) ())_ZN22b2PolyAndCircleContactD1Ev), ((unsigned int  (*) ())_ZN22b2PolyAndCircleContactD0Ev), ((unsigned int  (*) ())_ZN22b2PolyAndCircleContact8EvaluateEP17b2ContactListener) };
static struct l_struct_2E___si_class_type_info_pseudo _ZTI22b2PolyAndCircleContact = { { ((unsigned char *)(unsigned long)(((unsigned long long )(unsigned long)(&_ZTVN10__cxxabiv120__si_class_type_infoE)) + 16ull)), ((&_ZTS22b2PolyAndCircleContact[((signed int )0u)])) }, ((struct l_struct_2E_std_3A__3A_type_info *)(&_ZTI9b2Contact)) };
static unsigned char _ZTS22b2PolyAndCircleContact[25] = "22b2PolyAndCircleContact";
static unsigned char _2E_str1289[58] = "Box2D/Source/Dynamics/Contacts/b2PolyAndCircleContact.cpp";
static unsigned char _ZZN22b2PolyAndCircleContactC4EP7b2ShapeS1_E19__PRETTY_FUNCTION__[67] = "b2PolyAndCircleContact::b2PolyAndCircleContact(b2Shape*, b2Shape*)";
static unsigned char _2E_str1292[43] = "Box2D/Source/Collision/b2CollideCircle.cpp";
static unsigned char _ZZ25b2CollidePolygonAndCircleP10b2ManifoldPK14b2PolygonShapeRK7b2XFormPK13b2CircleShapeS6_E19__PRETTY_FUNCTION__[121] = "void b2CollidePolygonAndCircle(b2Manifold*, const b2PolygonShape*, const b2XForm&, const b2CircleShape*, const b2XForm&)";
static unsigned char _2E_str293[29] = "0 <= edge1 && edge1 < count1";
static unsigned char _2E_str1295[41] = "Box2D/Source/Collision/b2CollidePoly.cpp";
static unsigned char _ZZL16FindIncidentEdgeP10ClipVertexPK14b2PolygonShapeRK7b2XFormiS3_S6_E19__PRETTY_FUNCTION__[120] = "void FindIncidentEdge(ClipVertex*, const b2PolygonShape*, const b2XForm&, int32, const b2PolygonShape*, const b2XForm&)";
static unsigned char _ZZL14EdgeSeparationPK14b2PolygonShapeRK7b2XFormiS1_S4_E19__PRETTY_FUNCTION__[108] = "float32 EdgeSeparation(const b2PolygonShape*, const b2XForm&, int32, const b2PolygonShape*, const b2XForm&)";


/* Function Bodies */
static inline int llvm_fcmp_ord(double X, double Y) { return X == X && Y == Y; }
static inline int llvm_fcmp_uno(double X, double Y) { return X != X || Y != Y; }
static inline int llvm_fcmp_ueq(double X, double Y) { return X == Y || llvm_fcmp_uno(X, Y); }
static inline int llvm_fcmp_une(double X, double Y) { return X != Y; }
static inline int llvm_fcmp_ult(double X, double Y) { return X <  Y || llvm_fcmp_uno(X, Y); }
static inline int llvm_fcmp_ugt(double X, double Y) { return X >  Y || llvm_fcmp_uno(X, Y); }
static inline int llvm_fcmp_ule(double X, double Y) { return X <= Y || llvm_fcmp_uno(X, Y); }
static inline int llvm_fcmp_uge(double X, double Y) { return X >= Y || llvm_fcmp_uno(X, Y); }
static inline int llvm_fcmp_oeq(double X, double Y) { return X == Y ; }
static inline int llvm_fcmp_one(double X, double Y) { return X != Y && llvm_fcmp_ord(X, Y); }
static inline int llvm_fcmp_olt(double X, double Y) { return X <  Y ; }
static inline int llvm_fcmp_ogt(double X, double Y) { return X >  Y ; }
static inline int llvm_fcmp_ole(double X, double Y) { return X <= Y ; }
static inline int llvm_fcmp_oge(double X, double Y) { return X >= Y ; }

static float _ZN7Segment10distanceToERK4Vec2(struct l_struct_2E_Rect *llvm_cbe_this, struct l_struct_2E_Vec2 *llvm_cbe_p) {
  unsigned char llvm_cbe_withinLine;    /* Address-exposed local */
  struct l_struct_2E_Vec2 *llvm_cbe_tmp2;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp4;
  unsigned int llvm_cbe_tmp5_2e_i_2e_i;
  unsigned int llvm_cbe_tmp8_2e_i_2e_i;
  unsigned int *llvm_cbe_tmp11_2e_i_2e_i;
  unsigned int llvm_cbe_tmp12_2e_i_2e_i;
  unsigned int *llvm_cbe_tmp14_2e_i_2e_i;
  unsigned int llvm_cbe_tmp15_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp18_2e_i168_2e_i49__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp21_2e_i171_2e_i56__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp21_2e_i171_2e_i565758_2e_ins;
  float llvm_cbe_tmp24_2e_i174_2e_i48;
  llvmBitCastUnion llvm_cbe_tmp24_2e_i174_2e_i48__BITCAST_TEMPORARY;
  float llvm_cbe_tmp27_2e_i177_2e_i54;
  llvmBitCastUnion llvm_cbe_tmp27_2e_i177_2e_i54__BITCAST_TEMPORARY;
  unsigned int llvm_cbe_tmp5_2e_i120_2e_i;
  unsigned int llvm_cbe_tmp12_2e_i127_2e_i;
  llvmBitCastUnion llvm_cbe_tmp18_2e_i105_2e_i35__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp21_2e_i108_2e_i42__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp21_2e_i108_2e_i424344_2e_ins;
  float llvm_cbe_tmp24_2e_i_2e_i34;
  llvmBitCastUnion llvm_cbe_tmp24_2e_i_2e_i34__BITCAST_TEMPORARY;
  float llvm_cbe_tmp27_2e_i_2e_i40;
  llvmBitCastUnion llvm_cbe_tmp27_2e_i_2e_i40__BITCAST_TEMPORARY;
  float llvm_cbe_tmp16_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp8_2e_i69_2e_i;
  float llvm_cbe_tmp13_2e_i74_2e_i;
  float llvm_cbe_tmp20_2e_i_2e_i;
  float llvm_cbe_l_2e_i_2e_0_2e_0;
  float llvm_cbe_l_2e_i_2e_0_2e_0__PHI_TEMPORARY;
  float llvm_cbe_l_2e_i_2e_1_2e_0;
  float llvm_cbe_l_2e_i_2e_1_2e_0__PHI_TEMPORARY;
  float llvm_cbe_storemerge_2e_i79_2e_i;
  float llvm_cbe_storemerge_2e_i79_2e_i__PHI_TEMPORARY;
  float llvm_cbe_tmp15_2e_i57_2e_i;
  float llvm_cbe_tmp15_2e_i39_2e_i;
  float llvm_cbe_tmp5_2e_i21_2e_i;
  float llvm_cbe_storemerge_2e_i_2e_i;
  float llvm_cbe_storemerge_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp3_2e_i12;
  unsigned int llvm_cbe_tmp6_2e_i15;
  unsigned char llvm_cbe_tmp16;
  float llvm_cbe_tmp32;
  float llvm_cbe_tmp36;

  llvm_cbe_tmp2 = (&llvm_cbe_this->field1);
  llvm_cbe_tmp4 = (&llvm_cbe_this->field0);
  llvm_cbe_tmp5_2e_i_2e_i = *((&llvm_cbe_this->field1.field1));
  llvm_cbe_tmp8_2e_i_2e_i = *((&llvm_cbe_this->field0.field1));
  llvm_cbe_tmp11_2e_i_2e_i = (&llvm_cbe_this->field1.field0);
  llvm_cbe_tmp12_2e_i_2e_i = *llvm_cbe_tmp11_2e_i_2e_i;
  llvm_cbe_tmp14_2e_i_2e_i = (&llvm_cbe_this->field0.field0);
  llvm_cbe_tmp15_2e_i_2e_i = *llvm_cbe_tmp14_2e_i_2e_i;
  llvm_cbe_tmp21_2e_i171_2e_i565758_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp18_2e_i168_2e_i49__BITCAST_TEMPORARY.Float = (((float )(signed int )(llvm_cbe_tmp12_2e_i_2e_i - llvm_cbe_tmp15_2e_i_2e_i))), llvm_cbe_tmp18_2e_i168_2e_i49__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp21_2e_i171_2e_i56__BITCAST_TEMPORARY.Float = (((float )(signed int )(llvm_cbe_tmp5_2e_i_2e_i - llvm_cbe_tmp8_2e_i_2e_i))), llvm_cbe_tmp21_2e_i171_2e_i56__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp24_2e_i174_2e_i48 = (llvm_cbe_tmp24_2e_i174_2e_i48__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp21_2e_i171_2e_i565758_2e_ins)), llvm_cbe_tmp24_2e_i174_2e_i48__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp27_2e_i177_2e_i54 = (llvm_cbe_tmp27_2e_i177_2e_i54__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp21_2e_i171_2e_i565758_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp27_2e_i177_2e_i54__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp5_2e_i120_2e_i = *((&llvm_cbe_p->field1));
  llvm_cbe_tmp12_2e_i127_2e_i = *((&llvm_cbe_p->field0));
  llvm_cbe_tmp21_2e_i108_2e_i424344_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp18_2e_i105_2e_i35__BITCAST_TEMPORARY.Float = (((float )(signed int )(llvm_cbe_tmp12_2e_i127_2e_i - llvm_cbe_tmp15_2e_i_2e_i))), llvm_cbe_tmp18_2e_i105_2e_i35__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp21_2e_i108_2e_i42__BITCAST_TEMPORARY.Float = (((float )(signed int )(llvm_cbe_tmp5_2e_i120_2e_i - llvm_cbe_tmp8_2e_i_2e_i))), llvm_cbe_tmp21_2e_i108_2e_i42__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp24_2e_i_2e_i34 = (llvm_cbe_tmp24_2e_i_2e_i34__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp21_2e_i108_2e_i424344_2e_ins)), llvm_cbe_tmp24_2e_i_2e_i34__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp27_2e_i_2e_i40 = (llvm_cbe_tmp27_2e_i_2e_i40__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp21_2e_i108_2e_i424344_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp27_2e_i_2e_i40__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp16_2e_i_2e_i_2e_i = sqrtf((((float )((((float )(llvm_cbe_tmp24_2e_i174_2e_i48 * llvm_cbe_tmp24_2e_i174_2e_i48))) + (((float )(llvm_cbe_tmp27_2e_i177_2e_i54 * llvm_cbe_tmp27_2e_i177_2e_i54)))))));
  if ((llvm_fcmp_olt(llvm_cbe_tmp16_2e_i_2e_i_2e_i, 0x1p-23))) {
    llvm_cbe_l_2e_i_2e_0_2e_0__PHI_TEMPORARY = llvm_cbe_tmp24_2e_i174_2e_i48;   /* for PHI node */
    llvm_cbe_l_2e_i_2e_1_2e_0__PHI_TEMPORARY = llvm_cbe_tmp27_2e_i177_2e_i54;   /* for PHI node */
    llvm_cbe_storemerge_2e_i79_2e_i__PHI_TEMPORARY = 0x0p+0;   /* for PHI node */
    goto llvm_cbe__ZN6b2Vec29NormalizeEv_2e_exit_2e_i;
  } else {
    goto llvm_cbe_bb6_2e_i78_2e_i;
  }

llvm_cbe_bb6_2e_i78_2e_i:
  llvm_cbe_tmp8_2e_i69_2e_i = ((float )(0x1p+0 / llvm_cbe_tmp16_2e_i_2e_i_2e_i));
  llvm_cbe_tmp13_2e_i74_2e_i = ((float )(llvm_cbe_tmp24_2e_i174_2e_i48 * llvm_cbe_tmp8_2e_i69_2e_i));
  llvm_cbe_tmp20_2e_i_2e_i = ((float )(llvm_cbe_tmp27_2e_i177_2e_i54 * llvm_cbe_tmp8_2e_i69_2e_i));
  llvm_cbe_l_2e_i_2e_0_2e_0__PHI_TEMPORARY = llvm_cbe_tmp13_2e_i74_2e_i;   /* for PHI node */
  llvm_cbe_l_2e_i_2e_1_2e_0__PHI_TEMPORARY = llvm_cbe_tmp20_2e_i_2e_i;   /* for PHI node */
  llvm_cbe_storemerge_2e_i79_2e_i__PHI_TEMPORARY = llvm_cbe_tmp16_2e_i_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe__ZN6b2Vec29NormalizeEv_2e_exit_2e_i;

llvm_cbe__ZN6b2Vec29NormalizeEv_2e_exit_2e_i:
  llvm_cbe_l_2e_i_2e_0_2e_0 = llvm_cbe_l_2e_i_2e_0_2e_0__PHI_TEMPORARY;
  llvm_cbe_l_2e_i_2e_1_2e_0 = llvm_cbe_l_2e_i_2e_1_2e_0__PHI_TEMPORARY;
  llvm_cbe_storemerge_2e_i79_2e_i = llvm_cbe_storemerge_2e_i79_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp15_2e_i57_2e_i = ((float )((((float )(llvm_cbe_tmp24_2e_i_2e_i34 * llvm_cbe_l_2e_i_2e_1_2e_0))) - (((float )(llvm_cbe_tmp27_2e_i_2e_i40 * llvm_cbe_l_2e_i_2e_0_2e_0)))));
  llvm_cbe_tmp15_2e_i39_2e_i = ((float )((((float )(llvm_cbe_l_2e_i_2e_0_2e_0 * llvm_cbe_tmp24_2e_i_2e_i34))) + (((float )(llvm_cbe_l_2e_i_2e_1_2e_0 * llvm_cbe_tmp27_2e_i_2e_i40)))));
  *(&llvm_cbe_withinLine) = (((unsigned char )((((unsigned char )(bool )((((llvm_fcmp_ult(llvm_cbe_tmp15_2e_i39_2e_i, 0x0p+0)) | (llvm_fcmp_ugt(llvm_cbe_tmp15_2e_i39_2e_i, llvm_cbe_storemerge_2e_i79_2e_i)))&1)))) ^ ((unsigned char )1))));
  if ((llvm_fcmp_ule(llvm_cbe_tmp15_2e_i57_2e_i, 0x0p+0))) {
    goto llvm_cbe_bb_2e_i_2e_i;
  } else {
    llvm_cbe_storemerge_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp15_2e_i57_2e_i;   /* for PHI node */
    goto llvm_cbe__ZL18calcDistanceToLineRK4Vec2S1_S1_Pb_2e_exit;
  }

llvm_cbe_bb_2e_i_2e_i:
  llvm_cbe_tmp5_2e_i21_2e_i = ((float )(-(llvm_cbe_tmp15_2e_i57_2e_i)));
  llvm_cbe_storemerge_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp5_2e_i21_2e_i;   /* for PHI node */
  goto llvm_cbe__ZL18calcDistanceToLineRK4Vec2S1_S1_Pb_2e_exit;

llvm_cbe__ZL18calcDistanceToLineRK4Vec2S1_S1_Pb_2e_exit:
  llvm_cbe_storemerge_2e_i_2e_i = llvm_cbe_storemerge_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp3_2e_i12 = *llvm_cbe_tmp14_2e_i_2e_i;
  llvm_cbe_tmp6_2e_i15 = *llvm_cbe_tmp11_2e_i_2e_i;
  if ((llvm_cbe_tmp3_2e_i12 == llvm_cbe_tmp6_2e_i15)) {
    goto llvm_cbe_bb28;
  } else {
    goto llvm_cbe_bb;
  }

llvm_cbe_bb:
  llvm_cbe_tmp16 = *(&llvm_cbe_withinLine);
  if ((llvm_cbe_tmp16 == ((unsigned char )0))) {
    goto llvm_cbe_bb28;
  } else {
    goto llvm_cbe_return;
  }

llvm_cbe_bb28:
  llvm_cbe_tmp32 = _ZL12calcDistanceRK4Vec2S1_(llvm_cbe_p, llvm_cbe_tmp4);
  llvm_cbe_tmp36 = _ZL12calcDistanceRK4Vec2S1_(llvm_cbe_p, llvm_cbe_tmp2);
  return ((((llvm_fcmp_olt(llvm_cbe_tmp36, llvm_cbe_tmp32))) ? (llvm_cbe_tmp36) : (llvm_cbe_tmp32)));
llvm_cbe_return:
  return llvm_cbe_storemerge_2e_i_2e_i;
}


static void _ZN4Rect6expandERK4Vec2(struct l_struct_2E_Rect *llvm_cbe_this, struct l_struct_2E_Vec2 *llvm_cbe_v) {
  unsigned int *llvm_cbe_tmp6_2e_i;
  unsigned int llvm_cbe_tmp7_2e_i;
  unsigned int llvm_cbe_tmp10_2e_i;
  unsigned int *llvm_cbe_tmp15_2e_i;
  unsigned int llvm_cbe_tmp16_2e_i;
  unsigned int llvm_cbe_tmp19_2e_i;
  unsigned int llvm_cbe_tmp7_2e_i14;
  unsigned int llvm_cbe_tmp10_2e_i17;
  unsigned int llvm_cbe_tmp16_2e_i31;
  unsigned int llvm_cbe_tmp19_2e_i34;

  llvm_cbe_tmp6_2e_i = (&llvm_cbe_v->field0);
  llvm_cbe_tmp7_2e_i = *llvm_cbe_tmp6_2e_i;
  llvm_cbe_tmp10_2e_i = *((&llvm_cbe_this->field0.field0));
  llvm_cbe_tmp15_2e_i = (&llvm_cbe_v->field1);
  llvm_cbe_tmp16_2e_i = *llvm_cbe_tmp15_2e_i;
  llvm_cbe_tmp19_2e_i = *((&llvm_cbe_this->field0.field1));
  *((&llvm_cbe_this->field0.field0)) = ((((((signed int )llvm_cbe_tmp10_2e_i) < ((signed int )llvm_cbe_tmp7_2e_i))) ? (llvm_cbe_tmp10_2e_i) : (llvm_cbe_tmp7_2e_i)));
  *((&llvm_cbe_this->field0.field1)) = ((((((signed int )llvm_cbe_tmp19_2e_i) < ((signed int )llvm_cbe_tmp16_2e_i))) ? (llvm_cbe_tmp19_2e_i) : (llvm_cbe_tmp16_2e_i)));
  llvm_cbe_tmp7_2e_i14 = *llvm_cbe_tmp6_2e_i;
  llvm_cbe_tmp10_2e_i17 = *((&llvm_cbe_this->field1.field0));
  llvm_cbe_tmp16_2e_i31 = *llvm_cbe_tmp15_2e_i;
  llvm_cbe_tmp19_2e_i34 = *((&llvm_cbe_this->field1.field1));
  *((&llvm_cbe_this->field1.field0)) = ((((((signed int )llvm_cbe_tmp10_2e_i17) < ((signed int )llvm_cbe_tmp7_2e_i14))) ? (llvm_cbe_tmp7_2e_i14) : (llvm_cbe_tmp10_2e_i17)));
  *((&llvm_cbe_this->field1.field1)) = ((((((signed int )llvm_cbe_tmp19_2e_i34) < ((signed int )llvm_cbe_tmp16_2e_i31))) ? (llvm_cbe_tmp16_2e_i31) : (llvm_cbe_tmp19_2e_i34)));
  return;
}


static void _ZN4Path5scaleEf(struct l_struct_2E_Path *llvm_cbe_this, float llvm_cbe_factor) {
  unsigned int *llvm_cbe_tmp2_2e_i2;
  struct l_struct_2E_Vec2 **llvm_cbe_tmp2_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp3_2e_i;
  unsigned long long llvm_cbe_tmp45_2e_i;
  unsigned int *llvm_cbe_tmp9;
  unsigned int llvm_cbe_tmp10;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp3_2e_i19;
  unsigned int *llvm_cbe_tmp24;
  unsigned int llvm_cbe_tmp25;
  unsigned int llvm_cbe_tmp32;
  unsigned int llvm_cbe_storemerge;
  unsigned int llvm_cbe_storemerge__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp3_2e_i3;

  llvm_cbe_tmp2_2e_i2 = (&llvm_cbe_this->field0.field1);
  llvm_cbe_tmp2_2e_i = (&llvm_cbe_this->field0.field0);
  llvm_cbe_storemerge__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb33;

  do {     /* Syntactic loop 'bb33' to make GCC happy */
llvm_cbe_bb33:
  llvm_cbe_storemerge = llvm_cbe_storemerge__PHI_TEMPORARY;
  llvm_cbe_tmp3_2e_i3 = *llvm_cbe_tmp2_2e_i2;
  if ((((signed int )llvm_cbe_tmp3_2e_i3) > ((signed int )llvm_cbe_storemerge))) {
    goto llvm_cbe_bb;
  } else {
    goto llvm_cbe_return;
  }

llvm_cbe_bb:
  llvm_cbe_tmp3_2e_i = *llvm_cbe_tmp2_2e_i;
  llvm_cbe_tmp45_2e_i = ((signed long long )(signed int )llvm_cbe_storemerge);
  llvm_cbe_tmp9 = (&llvm_cbe_tmp3_2e_i[((signed long long )llvm_cbe_tmp45_2e_i)].field0);
  llvm_cbe_tmp10 = *llvm_cbe_tmp9;
  *llvm_cbe_tmp9 = (((signed int )(((float )((((float )(signed int )llvm_cbe_tmp10)) * llvm_cbe_factor)))));
  llvm_cbe_tmp3_2e_i19 = *llvm_cbe_tmp2_2e_i;
  llvm_cbe_tmp24 = (&llvm_cbe_tmp3_2e_i19[((signed long long )llvm_cbe_tmp45_2e_i)].field1);
  llvm_cbe_tmp25 = *llvm_cbe_tmp24;
  *llvm_cbe_tmp24 = (((signed int )(((float )((((float )(signed int )llvm_cbe_tmp25)) * llvm_cbe_factor)))));
  llvm_cbe_tmp32 = llvm_cbe_storemerge + 1u;
  llvm_cbe_storemerge__PHI_TEMPORARY = llvm_cbe_tmp32;   /* for PHI node */
  goto llvm_cbe_bb33;

  } while (1); /* end of syntactic loop 'bb33' */
llvm_cbe_return:
  return;
}


static void _ZN4Path6rotateERK7b2Mat22(struct l_struct_2E_Path *llvm_cbe_this, struct l_struct_2E_b2AABB *llvm_cbe_rot) {
  float llvm_cbe_tmp6;
  float llvm_cbe_tmp10;
  float llvm_cbe_tmp14;
  float llvm_cbe_tmp18;
  unsigned int *llvm_cbe_tmp2_2e_i;
  struct l_struct_2E_Vec2 **llvm_cbe_tmp2_2e_i43;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp3_2e_i44;
  unsigned long long llvm_cbe_tmp45_2e_i46;
  unsigned int llvm_cbe_tmp28;
  float llvm_cbe_tmp2829;
  unsigned int llvm_cbe_tmp37;
  float llvm_cbe_tmp3738;
  unsigned int llvm_cbe_tmp71;
  unsigned int llvm_cbe_storemerge;
  unsigned int llvm_cbe_storemerge__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp3_2e_i;

  llvm_cbe_tmp6 = *((&llvm_cbe_rot->field0.field0));
  llvm_cbe_tmp10 = *((&llvm_cbe_rot->field0.field1));
  llvm_cbe_tmp14 = *((&llvm_cbe_rot->field1.field0));
  llvm_cbe_tmp18 = *((&llvm_cbe_rot->field1.field1));
  llvm_cbe_tmp2_2e_i = (&llvm_cbe_this->field0.field1);
  llvm_cbe_tmp2_2e_i43 = (&llvm_cbe_this->field0.field0);
  llvm_cbe_storemerge__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb72;

  do {     /* Syntactic loop 'bb72' to make GCC happy */
llvm_cbe_bb72:
  llvm_cbe_storemerge = llvm_cbe_storemerge__PHI_TEMPORARY;
  llvm_cbe_tmp3_2e_i = *llvm_cbe_tmp2_2e_i;
  if ((((signed int )llvm_cbe_tmp3_2e_i) > ((signed int )llvm_cbe_storemerge))) {
    goto llvm_cbe_bb;
  } else {
    goto llvm_cbe_return;
  }

llvm_cbe_bb:
  llvm_cbe_tmp3_2e_i44 = *llvm_cbe_tmp2_2e_i43;
  llvm_cbe_tmp45_2e_i46 = ((signed long long )(signed int )llvm_cbe_storemerge);
  llvm_cbe_tmp28 = *((&llvm_cbe_tmp3_2e_i44[((signed long long )llvm_cbe_tmp45_2e_i46)].field0));
  llvm_cbe_tmp2829 = ((float )(signed int )llvm_cbe_tmp28);
  llvm_cbe_tmp37 = *((&llvm_cbe_tmp3_2e_i44[((signed long long )llvm_cbe_tmp45_2e_i46)].field1));
  llvm_cbe_tmp3738 = ((float )(signed int )llvm_cbe_tmp37);
  *((&llvm_cbe_tmp3_2e_i44[((signed long long )llvm_cbe_tmp45_2e_i46)].field0)) = (((signed int )(((float )((((float )(llvm_cbe_tmp2829 * llvm_cbe_tmp6))) + (((float )(llvm_cbe_tmp3738 * llvm_cbe_tmp14))))))));
  *((&llvm_cbe_tmp3_2e_i44[((signed long long )llvm_cbe_tmp45_2e_i46)].field1)) = (((signed int )(((float )((((float )(llvm_cbe_tmp2829 * llvm_cbe_tmp10))) + (((float )(llvm_cbe_tmp3738 * llvm_cbe_tmp18))))))));
  llvm_cbe_tmp71 = llvm_cbe_storemerge + 1u;
  llvm_cbe_storemerge__PHI_TEMPORARY = llvm_cbe_tmp71;   /* for PHI node */
  goto llvm_cbe_bb72;

  } while (1); /* end of syntactic loop 'bb72' */
llvm_cbe_return:
  return;
}


static struct l_struct_2E_Path *_ZN4Path9translateERK4Vec2(struct l_struct_2E_Path *llvm_cbe_this, struct l_struct_2E_Vec2 *llvm_cbe_xlate) {
  unsigned int *llvm_cbe_tmp2_2e_i2;
  struct l_struct_2E_Vec2 **llvm_cbe_tmp2_2e_i;
  unsigned int *llvm_cbe_tmp4_2e_i8;
  unsigned int *llvm_cbe_tmp13_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp3_2e_i;
  unsigned long long llvm_cbe_tmp45_2e_i;
  unsigned int *llvm_cbe_tmp1_2e_i5;
  unsigned int llvm_cbe_tmp2_2e_i6;
  unsigned int llvm_cbe_tmp5_2e_i;
  unsigned int *llvm_cbe_tmp10_2e_i;
  unsigned int llvm_cbe_tmp11_2e_i;
  unsigned int llvm_cbe_tmp14_2e_i;
  unsigned int llvm_cbe_tmp7;
  unsigned int llvm_cbe_storemerge;
  unsigned int llvm_cbe_storemerge__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp3_2e_i3;

  llvm_cbe_tmp2_2e_i2 = (&llvm_cbe_this->field0.field1);
  llvm_cbe_tmp2_2e_i = (&llvm_cbe_this->field0.field0);
  llvm_cbe_tmp4_2e_i8 = (&llvm_cbe_xlate->field0);
  llvm_cbe_tmp13_2e_i = (&llvm_cbe_xlate->field1);
  llvm_cbe_storemerge__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb8;

  do {     /* Syntactic loop 'bb8' to make GCC happy */
llvm_cbe_bb8:
  llvm_cbe_storemerge = llvm_cbe_storemerge__PHI_TEMPORARY;
  llvm_cbe_tmp3_2e_i3 = *llvm_cbe_tmp2_2e_i2;
  if ((((signed int )llvm_cbe_tmp3_2e_i3) > ((signed int )llvm_cbe_storemerge))) {
    goto llvm_cbe_bb;
  } else {
    goto llvm_cbe_return;
  }

llvm_cbe_bb:
  llvm_cbe_tmp3_2e_i = *llvm_cbe_tmp2_2e_i;
  llvm_cbe_tmp45_2e_i = ((signed long long )(signed int )llvm_cbe_storemerge);
  llvm_cbe_tmp1_2e_i5 = (&llvm_cbe_tmp3_2e_i[((signed long long )llvm_cbe_tmp45_2e_i)].field0);
  llvm_cbe_tmp2_2e_i6 = *llvm_cbe_tmp1_2e_i5;
  llvm_cbe_tmp5_2e_i = *llvm_cbe_tmp4_2e_i8;
  *llvm_cbe_tmp1_2e_i5 = (llvm_cbe_tmp2_2e_i6 + llvm_cbe_tmp5_2e_i);
  llvm_cbe_tmp10_2e_i = (&llvm_cbe_tmp3_2e_i[((signed long long )llvm_cbe_tmp45_2e_i)].field1);
  llvm_cbe_tmp11_2e_i = *llvm_cbe_tmp10_2e_i;
  llvm_cbe_tmp14_2e_i = *llvm_cbe_tmp13_2e_i;
  *llvm_cbe_tmp10_2e_i = (llvm_cbe_tmp11_2e_i + llvm_cbe_tmp14_2e_i);
  llvm_cbe_tmp7 = llvm_cbe_storemerge + 1u;
  llvm_cbe_storemerge__PHI_TEMPORARY = llvm_cbe_tmp7;   /* for PHI node */
  goto llvm_cbe_bb8;

  } while (1); /* end of syntactic loop 'bb8' */
llvm_cbe_return:
  return llvm_cbe_this;
}


static struct l_struct_2E_Rect _ZNK4Path4bboxEv(struct l_struct_2E_Path *llvm_cbe_this) {
  struct l_struct_2E_Rect StructReturn;  /* Struct return temporary */
  struct l_struct_2E_Rect *llvm_cbe_agg_2e_result = &StructReturn;
  struct l_struct_2E_Vec2 **llvm_cbe_tmp2_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp3_2e_i;
  unsigned int *llvm_cbe_tmp1_2e_i_2e_i;
  unsigned int llvm_cbe_tmp2_2e_i_2e_i;
  unsigned int *llvm_cbe_tmp6_2e_i_2e_i;
  unsigned int llvm_cbe_tmp7_2e_i_2e_i;
  unsigned int llvm_cbe_tmp2_2e_i4_2e_i;
  unsigned int llvm_cbe_tmp7_2e_i9_2e_i;
  unsigned int *llvm_cbe_tmp2_2e_i2;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp3_2e_i19;
  unsigned int llvm_cbe_tmp17;
  unsigned int llvm_cbe_storemerge;
  unsigned int llvm_cbe_storemerge__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp3_2e_i3;

  llvm_cbe_tmp2_2e_i = (&llvm_cbe_this->field0.field0);
  llvm_cbe_tmp3_2e_i = *llvm_cbe_tmp2_2e_i;
  llvm_cbe_tmp1_2e_i_2e_i = (&llvm_cbe_tmp3_2e_i->field0);
  llvm_cbe_tmp2_2e_i_2e_i = *llvm_cbe_tmp1_2e_i_2e_i;
  *((&llvm_cbe_agg_2e_result->field0.field0)) = llvm_cbe_tmp2_2e_i_2e_i;
  llvm_cbe_tmp6_2e_i_2e_i = (&llvm_cbe_tmp3_2e_i->field1);
  llvm_cbe_tmp7_2e_i_2e_i = *llvm_cbe_tmp6_2e_i_2e_i;
  *((&llvm_cbe_agg_2e_result->field0.field1)) = llvm_cbe_tmp7_2e_i_2e_i;
  llvm_cbe_tmp2_2e_i4_2e_i = *llvm_cbe_tmp1_2e_i_2e_i;
  *((&llvm_cbe_agg_2e_result->field1.field0)) = llvm_cbe_tmp2_2e_i4_2e_i;
  llvm_cbe_tmp7_2e_i9_2e_i = *llvm_cbe_tmp6_2e_i_2e_i;
  *((&llvm_cbe_agg_2e_result->field1.field1)) = llvm_cbe_tmp7_2e_i9_2e_i;
  llvm_cbe_tmp2_2e_i2 = (&llvm_cbe_this->field0.field1);
  llvm_cbe_storemerge__PHI_TEMPORARY = 1u;   /* for PHI node */
  goto llvm_cbe_bb18;

  do {     /* Syntactic loop 'bb18' to make GCC happy */
llvm_cbe_bb18:
  llvm_cbe_storemerge = llvm_cbe_storemerge__PHI_TEMPORARY;
  llvm_cbe_tmp3_2e_i3 = *llvm_cbe_tmp2_2e_i2;
  if ((((signed int )llvm_cbe_tmp3_2e_i3) > ((signed int )llvm_cbe_storemerge))) {
    goto llvm_cbe_bb;
  } else {
    goto llvm_cbe_return;
  }

llvm_cbe_bb:
  llvm_cbe_tmp3_2e_i19 = *llvm_cbe_tmp2_2e_i;
  _ZN4Rect6expandERK4Vec2(llvm_cbe_agg_2e_result, ((&llvm_cbe_tmp3_2e_i19[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge)))])));
  llvm_cbe_tmp17 = llvm_cbe_storemerge + 1u;
  llvm_cbe_storemerge__PHI_TEMPORARY = llvm_cbe_tmp17;   /* for PHI node */
  goto llvm_cbe_bb18;

  } while (1); /* end of syntactic loop 'bb18' */
llvm_cbe_return:
  return StructReturn;
}


static void _ZN5ArrayI4Vec2EC2Ei(struct l_struct_2E_Array_3C_Vec2_3E_ *llvm_cbe_this) {
  struct l_struct_2E_Vec2 **llvm_cbe_tmp1;
  unsigned int *llvm_cbe_tmp5;
  unsigned char *llvm_cbe_tmp28_2e_i;

  llvm_cbe_tmp1 = (&llvm_cbe_this->field0);
  *llvm_cbe_tmp1 = ((struct l_struct_2E_Vec2 *)/*NULL*/0);
  *((&llvm_cbe_this->field1)) = 0u;
  llvm_cbe_tmp5 = (&llvm_cbe_this->field2);
  *llvm_cbe_tmp5 = 0u;
  llvm_cbe_tmp28_2e_i = malloc(0ull);
  *llvm_cbe_tmp1 = (((struct l_struct_2E_Vec2 *)llvm_cbe_tmp28_2e_i));
  *llvm_cbe_tmp5 = 0u;
  return;
}


static void _ZN5ArrayI4Vec2E6appendERKS0_(struct l_struct_2E_Array_3C_Vec2_3E_ *llvm_cbe_this, struct l_struct_2E_Vec2 *llvm_cbe_t) {
  unsigned int *llvm_cbe_tmp2;
  unsigned int llvm_cbe_tmp3;
  unsigned int llvm_cbe_tmp4;
  unsigned int *llvm_cbe_tmp1_2e_i;
  unsigned int llvm_cbe_tmp2_2e_i;
  unsigned int llvm_cbe_storemerge_2e_i;
  unsigned int llvm_cbe_tmp22_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_i__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp27_2e_i_2e_i;
  struct l_struct_2E_Vec2 **llvm_cbe_tmp17_2e_i_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp18_2e_i_2e_i;
  unsigned char *llvm_cbe_tmp20_2e_i_2e_i;
  unsigned char *llvm_cbe_tmp28_2e_i_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp8;
  unsigned int llvm_cbe_tmp11;
  unsigned long long llvm_cbe_tmp1213;
  unsigned int llvm_cbe_tmp18;
  unsigned int llvm_cbe_tmp21;

  llvm_cbe_tmp2 = (&llvm_cbe_this->field1);
  llvm_cbe_tmp3 = *llvm_cbe_tmp2;
  llvm_cbe_tmp4 = llvm_cbe_tmp3 + 1u;
  llvm_cbe_tmp1_2e_i = (&llvm_cbe_this->field2);
  llvm_cbe_tmp2_2e_i = *llvm_cbe_tmp1_2e_i;
  if ((((signed int )llvm_cbe_tmp2_2e_i) < ((signed int )llvm_cbe_tmp4))) {
    goto llvm_cbe_bb_2e_i;
  } else {
    goto llvm_cbe__ZN5ArrayI4Vec2E14ensureCapacityEi_2e_exit;
  }

llvm_cbe_bb_2e_i:
  llvm_cbe_storemerge_2e_i = (((llvm_cbe_tmp2_2e_i == 0u)) ? (4u) : (llvm_cbe_tmp2_2e_i));
  llvm_cbe_storemerge1_2e_i__PHI_TEMPORARY = llvm_cbe_storemerge_2e_i;   /* for PHI node */
  goto llvm_cbe_bb23_2e_i;

  do {     /* Syntactic loop 'bb23.i' to make GCC happy */
llvm_cbe_bb23_2e_i:
  llvm_cbe_storemerge1_2e_i = llvm_cbe_storemerge1_2e_i__PHI_TEMPORARY;
  if ((((signed int )llvm_cbe_storemerge1_2e_i) < ((signed int )llvm_cbe_tmp4))) {
    goto llvm_cbe_bb19_2e_i;
  } else {
    goto llvm_cbe_bb29_2e_i;
  }

llvm_cbe_bb19_2e_i:
  llvm_cbe_tmp22_2e_i = llvm_cbe_storemerge1_2e_i << 1u;
  llvm_cbe_storemerge1_2e_i__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i;   /* for PHI node */
  goto llvm_cbe_bb23_2e_i;

  } while (1); /* end of syntactic loop 'bb23.i' */
llvm_cbe_bb29_2e_i:
  if ((((signed int )llvm_cbe_tmp3) > ((signed int )llvm_cbe_storemerge1_2e_i))) {
    goto llvm_cbe__ZN5ArrayI4Vec2E14ensureCapacityEi_2e_exit;
  } else {
    goto llvm_cbe_bb_2e_i_2e_i;
  }

llvm_cbe_bb_2e_i_2e_i:
  llvm_cbe_tmp27_2e_i_2e_i = (((signed long long )(signed int )llvm_cbe_storemerge1_2e_i)) << 3ull;
  if ((llvm_cbe_tmp2_2e_i == 0u)) {
    goto llvm_cbe_bb24_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb12_2e_i_2e_i;
  }

llvm_cbe_bb12_2e_i_2e_i:
  llvm_cbe_tmp17_2e_i_2e_i = (&llvm_cbe_this->field0);
  llvm_cbe_tmp18_2e_i_2e_i = *llvm_cbe_tmp17_2e_i_2e_i;
  llvm_cbe_tmp20_2e_i_2e_i = realloc((((unsigned char *)llvm_cbe_tmp18_2e_i_2e_i)), llvm_cbe_tmp27_2e_i_2e_i);
  *llvm_cbe_tmp17_2e_i_2e_i = (((struct l_struct_2E_Vec2 *)llvm_cbe_tmp20_2e_i_2e_i));
  goto llvm_cbe_bb32_2e_i_2e_i;

llvm_cbe_bb24_2e_i_2e_i:
  llvm_cbe_tmp28_2e_i_2e_i = malloc(llvm_cbe_tmp27_2e_i_2e_i);
  *((&llvm_cbe_this->field0)) = (((struct l_struct_2E_Vec2 *)llvm_cbe_tmp28_2e_i_2e_i));
  goto llvm_cbe_bb32_2e_i_2e_i;

llvm_cbe_bb32_2e_i_2e_i:
  *llvm_cbe_tmp1_2e_i = llvm_cbe_storemerge1_2e_i;
  goto llvm_cbe__ZN5ArrayI4Vec2E14ensureCapacityEi_2e_exit;

llvm_cbe__ZN5ArrayI4Vec2E14ensureCapacityEi_2e_exit:
  llvm_cbe_tmp8 = *((&llvm_cbe_this->field0));
  llvm_cbe_tmp11 = *llvm_cbe_tmp2;
  llvm_cbe_tmp1213 = ((signed long long )(signed int )llvm_cbe_tmp11);
  llvm_cbe_tmp18 = *((&llvm_cbe_t->field0));
  *((&llvm_cbe_tmp8[((signed long long )llvm_cbe_tmp1213)].field0)) = llvm_cbe_tmp18;
  llvm_cbe_tmp21 = *((&llvm_cbe_t->field1));
  *((&llvm_cbe_tmp8[((signed long long )llvm_cbe_tmp1213)].field1)) = llvm_cbe_tmp21;
  *llvm_cbe_tmp2 = (llvm_cbe_tmp11 + 1u);
  return;
}


static void _ZN4PathC1EPKc(struct l_struct_2E_Path *llvm_cbe_this, unsigned char *llvm_cbe_s) {
  float llvm_cbe_y;    /* Address-exposed local */
  float llvm_cbe_x;    /* Address-exposed local */
  struct l_struct_2E_Vec2 llvm_cbe_tmp;    /* Address-exposed local */
  struct l_struct_2E_Array_3C_Vec2_3E_ *llvm_cbe_tmp2;
  unsigned int *llvm_cbe_tmp1_2e_i;
  unsigned int *llvm_cbe_tmp4_2e_i;
  float llvm_cbe_tmp3;
  float llvm_cbe_tmp5;
  unsigned char *llvm_cbe_tmp11;
  unsigned char *llvm_cbe_s_addr_2e_0;
  unsigned char *llvm_cbe_s_addr_2e_0__PHI_TEMPORARY;
  unsigned char llvm_cbe_tmp14;
  unsigned char *llvm_cbe_tmp32;
  unsigned char *llvm_cbe_s_addr_2e_2;
  unsigned char *llvm_cbe_s_addr_2e_2__PHI_TEMPORARY;
  unsigned char llvm_cbe_tmp36;
  unsigned char *llvm_cbe_s_addr_2e_1;
  unsigned char *llvm_cbe_s_addr_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp49;

  llvm_cbe_tmp2 = (&llvm_cbe_this->field0);
  _ZN5ArrayI4Vec2EC2Ei(llvm_cbe_tmp2);
  llvm_cbe_tmp1_2e_i = (&llvm_cbe_tmp.field0);
  llvm_cbe_tmp4_2e_i = (&llvm_cbe_tmp.field1);
  llvm_cbe_s_addr_2e_1__PHI_TEMPORARY = llvm_cbe_s;   /* for PHI node */
  goto llvm_cbe_bb46;

  do {     /* Syntactic loop 'bb46' to make GCC happy */
llvm_cbe_bb46:
  llvm_cbe_s_addr_2e_1 = llvm_cbe_s_addr_2e_1__PHI_TEMPORARY;
  llvm_cbe_tmp49 = sscanf(llvm_cbe_s_addr_2e_1, ((&_2E_str[((signed long long )0ull)])), (&llvm_cbe_x), (&llvm_cbe_y));
  if ((llvm_cbe_tmp49 == 2u)) {
    goto llvm_cbe_bb;
  } else {
    goto llvm_cbe_return;
  }

  do {     /* Syntactic loop 'bb33' to make GCC happy */
llvm_cbe_bb33:
  llvm_cbe_s_addr_2e_2 = llvm_cbe_s_addr_2e_2__PHI_TEMPORARY;
  llvm_cbe_tmp36 = *llvm_cbe_s_addr_2e_2;
  switch (llvm_cbe_tmp36) {
  default:
    llvm_cbe_s_addr_2e_1__PHI_TEMPORARY = llvm_cbe_s_addr_2e_2;   /* for PHI node */
    goto llvm_cbe_bb46;
;
  case ((unsigned char )32):
    goto llvm_cbe_bb30;
  case ((unsigned char )9):
    goto llvm_cbe_bb30;
  }
llvm_cbe_bb30:
  llvm_cbe_tmp32 = (&llvm_cbe_s_addr_2e_2[((signed long long )1ull)]);
  llvm_cbe_s_addr_2e_2__PHI_TEMPORARY = llvm_cbe_tmp32;   /* for PHI node */
  goto llvm_cbe_bb33;

  } while (1); /* end of syntactic loop 'bb33' */
  do {     /* Syntactic loop 'bb12' to make GCC happy */
llvm_cbe_bb12:
  llvm_cbe_s_addr_2e_0 = llvm_cbe_s_addr_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp14 = *llvm_cbe_s_addr_2e_0;
  switch (llvm_cbe_tmp14) {
  default:
    goto llvm_cbe_bb9;
;
  case ((unsigned char )0):
    llvm_cbe_s_addr_2e_2__PHI_TEMPORARY = llvm_cbe_s_addr_2e_0;   /* for PHI node */
    goto llvm_cbe_bb33;
  case ((unsigned char )32):
    llvm_cbe_s_addr_2e_2__PHI_TEMPORARY = llvm_cbe_s_addr_2e_0;   /* for PHI node */
    goto llvm_cbe_bb33;
  case ((unsigned char )9):
    llvm_cbe_s_addr_2e_2__PHI_TEMPORARY = llvm_cbe_s_addr_2e_0;   /* for PHI node */
    goto llvm_cbe_bb33;
  }
llvm_cbe_bb9:
  llvm_cbe_tmp11 = (&llvm_cbe_s_addr_2e_0[((signed long long )1ull)]);
  llvm_cbe_s_addr_2e_0__PHI_TEMPORARY = llvm_cbe_tmp11;   /* for PHI node */
  goto llvm_cbe_bb12;

  } while (1); /* end of syntactic loop 'bb12' */
llvm_cbe_bb:
  llvm_cbe_tmp3 = *(&llvm_cbe_y);
  llvm_cbe_tmp5 = *(&llvm_cbe_x);
  *llvm_cbe_tmp1_2e_i = (((signed int )llvm_cbe_tmp5));
  *llvm_cbe_tmp4_2e_i = (((signed int )llvm_cbe_tmp3));
  _ZN5ArrayI4Vec2E6appendERKS0_(llvm_cbe_tmp2, (&llvm_cbe_tmp));
  llvm_cbe_s_addr_2e_0__PHI_TEMPORARY = llvm_cbe_s_addr_2e_1;   /* for PHI node */
  goto llvm_cbe_bb12;

  } while (1); /* end of syntactic loop 'bb46' */
llvm_cbe_return:
  return;
}


static float _ZL12calcDistanceRK4Vec2S1_(struct l_struct_2E_Vec2 *llvm_cbe_l1, struct l_struct_2E_Vec2 *llvm_cbe_l2) {
  unsigned int llvm_cbe_tmp5_2e_i;
  unsigned int llvm_cbe_tmp8_2e_i;
  unsigned int llvm_cbe_tmp12_2e_i;
  unsigned int llvm_cbe_tmp15_2e_i;
  llvmBitCastUnion llvm_cbe_tmp18_2e_i65__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp21_2e_i72__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp21_2e_i727374_2e_ins;
  float llvm_cbe_tmp24_2e_i64;
  llvmBitCastUnion llvm_cbe_tmp24_2e_i64__BITCAST_TEMPORARY;
  float llvm_cbe_tmp27_2e_i70;
  llvmBitCastUnion llvm_cbe_tmp27_2e_i70__BITCAST_TEMPORARY;
  float llvm_cbe_tmp16_2e_i30;

  llvm_cbe_tmp5_2e_i = *((&llvm_cbe_l1->field1));
  llvm_cbe_tmp8_2e_i = *((&llvm_cbe_l2->field1));
  llvm_cbe_tmp12_2e_i = *((&llvm_cbe_l1->field0));
  llvm_cbe_tmp15_2e_i = *((&llvm_cbe_l2->field0));
  llvm_cbe_tmp21_2e_i727374_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp18_2e_i65__BITCAST_TEMPORARY.Float = (((float )(signed int )(llvm_cbe_tmp12_2e_i - llvm_cbe_tmp15_2e_i))), llvm_cbe_tmp18_2e_i65__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp21_2e_i72__BITCAST_TEMPORARY.Float = (((float )(signed int )(llvm_cbe_tmp5_2e_i - llvm_cbe_tmp8_2e_i))), llvm_cbe_tmp21_2e_i72__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp24_2e_i64 = (llvm_cbe_tmp24_2e_i64__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp21_2e_i727374_2e_ins)), llvm_cbe_tmp24_2e_i64__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp27_2e_i70 = (llvm_cbe_tmp27_2e_i70__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp21_2e_i727374_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp27_2e_i70__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp16_2e_i30 = sqrtf((((float )((((float )(llvm_cbe_tmp24_2e_i64 * llvm_cbe_tmp24_2e_i64))) + (((float )(llvm_cbe_tmp27_2e_i70 * llvm_cbe_tmp27_2e_i70)))))));
  return llvm_cbe_tmp16_2e_i30;
}


static float _ZN6b2Vec29NormalizeEv(struct l_struct_2E_b2Vec2 *llvm_cbe_this) {
  float *llvm_cbe_tmp2_2e_i;
  float llvm_cbe_tmp3_2e_i;
  float *llvm_cbe_tmp9_2e_i;
  float llvm_cbe_tmp10_2e_i;
  float llvm_cbe_tmp16_2e_i;
  float llvm_cbe_tmp8;
  float llvm_cbe_tmp11;
  float llvm_cbe_tmp18;

  llvm_cbe_tmp2_2e_i = (&llvm_cbe_this->field0);
  llvm_cbe_tmp3_2e_i = *llvm_cbe_tmp2_2e_i;
  llvm_cbe_tmp9_2e_i = (&llvm_cbe_this->field1);
  llvm_cbe_tmp10_2e_i = *llvm_cbe_tmp9_2e_i;
  llvm_cbe_tmp16_2e_i = sqrtf((((float )((((float )(llvm_cbe_tmp3_2e_i * llvm_cbe_tmp3_2e_i))) + (((float )(llvm_cbe_tmp10_2e_i * llvm_cbe_tmp10_2e_i)))))));
  if ((llvm_fcmp_olt(llvm_cbe_tmp16_2e_i, 0x1p-23))) {
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb6;
  }

llvm_cbe_bb6:
  llvm_cbe_tmp8 = ((float )(0x1p+0 / llvm_cbe_tmp16_2e_i));
  llvm_cbe_tmp11 = *llvm_cbe_tmp2_2e_i;
  *llvm_cbe_tmp2_2e_i = (((float )(llvm_cbe_tmp11 * llvm_cbe_tmp8)));
  llvm_cbe_tmp18 = *llvm_cbe_tmp9_2e_i;
  *llvm_cbe_tmp9_2e_i = (((float )(llvm_cbe_tmp18 * llvm_cbe_tmp8)));
  return llvm_cbe_tmp16_2e_i;
llvm_cbe_return:
  return 0x0p+0;
}


static void _ZN4Path11simplifySubEiifPb(struct l_struct_2E_Path *llvm_cbe_this, unsigned int llvm_cbe_first, unsigned int llvm_cbe_last, float llvm_cbe_threshold, unsigned char *llvm_cbe_keepflags) {
  struct l_struct_2E_Rect llvm_cbe_s;    /* Address-exposed local */
  struct l_struct_2E_Vec2 **llvm_cbe_tmp2_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp3_2e_i;
  unsigned long long llvm_cbe_tmp45_2e_i;
  unsigned long long llvm_cbe_tmp45_2e_i8;
  unsigned int llvm_cbe_tmp2_2e_i_2e_i;
  unsigned int llvm_cbe_tmp7_2e_i_2e_i;
  unsigned int llvm_cbe_tmp2_2e_i4_2e_i;
  unsigned int llvm_cbe_tmp7_2e_i9_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp3_2e_i16;
  float llvm_cbe_tmp21;
  unsigned int llvm_cbe_furthestIndex_2e_0;
  float llvm_cbe_furthestDist_2e_0;
  unsigned int llvm_cbe_furthestIndex_2e_1;
  unsigned int llvm_cbe_furthestIndex_2e_1__PHI_TEMPORARY;
  float llvm_cbe_furthestDist_2e_1;
  float llvm_cbe_furthestDist_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge_2e_in;
  unsigned int llvm_cbe_storemerge_2e_in__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge;

  if ((((signed int )(llvm_cbe_last - llvm_cbe_first)) > ((signed int )1u))) {
    goto llvm_cbe_bb;
  } else {
    goto llvm_cbe_return;
  }

llvm_cbe_bb:
  llvm_cbe_tmp2_2e_i = (&llvm_cbe_this->field0.field0);
  llvm_cbe_tmp3_2e_i = *llvm_cbe_tmp2_2e_i;
  llvm_cbe_tmp45_2e_i = ((signed long long )(signed int )llvm_cbe_last);
  llvm_cbe_tmp45_2e_i8 = ((signed long long )(signed int )llvm_cbe_first);
  llvm_cbe_tmp2_2e_i_2e_i = *((&llvm_cbe_tmp3_2e_i[((signed long long )llvm_cbe_tmp45_2e_i8)].field0));
  *((&llvm_cbe_s.field0.field0)) = llvm_cbe_tmp2_2e_i_2e_i;
  llvm_cbe_tmp7_2e_i_2e_i = *((&llvm_cbe_tmp3_2e_i[((signed long long )llvm_cbe_tmp45_2e_i8)].field1));
  *((&llvm_cbe_s.field0.field1)) = llvm_cbe_tmp7_2e_i_2e_i;
  llvm_cbe_tmp2_2e_i4_2e_i = *((&llvm_cbe_tmp3_2e_i[((signed long long )llvm_cbe_tmp45_2e_i)].field0));
  *((&llvm_cbe_s.field1.field0)) = llvm_cbe_tmp2_2e_i4_2e_i;
  llvm_cbe_tmp7_2e_i9_2e_i = *((&llvm_cbe_tmp3_2e_i[((signed long long )llvm_cbe_tmp45_2e_i)].field1));
  *((&llvm_cbe_s.field1.field1)) = llvm_cbe_tmp7_2e_i9_2e_i;
  llvm_cbe_furthestIndex_2e_1__PHI_TEMPORARY = 0u;   /* for PHI node */
  llvm_cbe_furthestDist_2e_1__PHI_TEMPORARY = llvm_cbe_threshold;   /* for PHI node */
  llvm_cbe_storemerge_2e_in__PHI_TEMPORARY = llvm_cbe_first;   /* for PHI node */
  goto llvm_cbe_bb33;

  do {     /* Syntactic loop 'bb33' to make GCC happy */
llvm_cbe_bb33:
  llvm_cbe_furthestIndex_2e_1 = llvm_cbe_furthestIndex_2e_1__PHI_TEMPORARY;
  llvm_cbe_furthestDist_2e_1 = llvm_cbe_furthestDist_2e_1__PHI_TEMPORARY;
  llvm_cbe_storemerge_2e_in = llvm_cbe_storemerge_2e_in__PHI_TEMPORARY;
  llvm_cbe_storemerge = llvm_cbe_storemerge_2e_in + 1u;
  if ((((signed int )llvm_cbe_storemerge) < ((signed int )llvm_cbe_last))) {
    goto llvm_cbe_bb16;
  } else {
    goto llvm_cbe_bb39;
  }

llvm_cbe_bb16:
  llvm_cbe_tmp3_2e_i16 = *llvm_cbe_tmp2_2e_i;
  llvm_cbe_tmp21 = _ZN7Segment10distanceToERK4Vec2((&llvm_cbe_s), ((&llvm_cbe_tmp3_2e_i16[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge)))])));
  llvm_cbe_furthestIndex_2e_0 = (((llvm_fcmp_ogt(llvm_cbe_tmp21, llvm_cbe_furthestDist_2e_1))) ? (llvm_cbe_storemerge) : (llvm_cbe_furthestIndex_2e_1));
  llvm_cbe_furthestDist_2e_0 = (((llvm_fcmp_ogt(llvm_cbe_tmp21, llvm_cbe_furthestDist_2e_1))) ? (llvm_cbe_tmp21) : (llvm_cbe_furthestDist_2e_1));
  llvm_cbe_furthestIndex_2e_1__PHI_TEMPORARY = llvm_cbe_furthestIndex_2e_0;   /* for PHI node */
  llvm_cbe_furthestDist_2e_1__PHI_TEMPORARY = llvm_cbe_furthestDist_2e_0;   /* for PHI node */
  llvm_cbe_storemerge_2e_in__PHI_TEMPORARY = llvm_cbe_storemerge;   /* for PHI node */
  goto llvm_cbe_bb33;

  } while (1); /* end of syntactic loop 'bb33' */
llvm_cbe_bb39:
  if ((llvm_cbe_furthestIndex_2e_1 == 0u)) {
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb44;
  }

llvm_cbe_bb44:
  *((&llvm_cbe_keepflags[((signed long long )(((signed long long )(signed int )llvm_cbe_furthestIndex_2e_1)))])) = ((unsigned char )1);
  _ZN4Path11simplifySubEiifPb(llvm_cbe_this, llvm_cbe_first, llvm_cbe_furthestIndex_2e_1, llvm_cbe_threshold, llvm_cbe_keepflags);
  _ZN4Path11simplifySubEiifPb(llvm_cbe_this, llvm_cbe_furthestIndex_2e_1, llvm_cbe_last, llvm_cbe_threshold, llvm_cbe_keepflags);
  return;
llvm_cbe_return:
  return;
}


static void _ZN4Path8simplifyEf(struct l_struct_2E_Path *llvm_cbe_this, float llvm_cbe_threshold) {
  unsigned int *llvm_cbe_tmp2_2e_i;
  unsigned int llvm_cbe_tmp3_2e_i;
  unsigned char *llvm_cbe_tmp21;
  unsigned char *ltmp_0_1;
  unsigned int llvm_cbe_tmp3_2e_i74;
  unsigned int llvm_cbe_tmp29;
  struct l_struct_2E_Vec2 **llvm_cbe_tmp2_2e_i66;
  unsigned long long llvm_cbe_tmp4749;
  unsigned char llvm_cbe_tmp51;
  unsigned int llvm_cbe_tmp55;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp3_2e_i67;
  unsigned long long llvm_cbe_tmp45_2e_i69;
  unsigned int llvm_cbe_tmp66;
  unsigned int llvm_cbe_tmp70;
  unsigned int llvm_cbe_k_2e_0;
  unsigned int llvm_cbe_k_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp73;
  unsigned int llvm_cbe_k_2e_1;
  unsigned int llvm_cbe_k_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge;
  unsigned int llvm_cbe_storemerge__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp3_2e_i50;
  unsigned int *llvm_cbe_tmp1_2e_i38;
  unsigned int llvm_cbe_tmp2_2e_i39;
  unsigned int llvm_cbe_tmp3_2e_i33;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp3_2e_i26;
  unsigned long long llvm_cbe_tmp45_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp6_2e_i20;
  unsigned int llvm_cbe_tmp3_2e_i9;
  unsigned int llvm_cbe_tmp6_2e_i;
  unsigned int llvm_cbe_tmp2_2e_i3;
  unsigned char *ltmp_1_1;
  unsigned int llvm_cbe_tmp33_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_in;
  unsigned int llvm_cbe_storemerge1_2e_in__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge1;

  llvm_cbe_tmp2_2e_i = (&llvm_cbe_this->field0.field1);
  llvm_cbe_tmp3_2e_i = *llvm_cbe_tmp2_2e_i;
  llvm_cbe_tmp21 = (unsigned char *) alloca(sizeof(unsigned char ) * llvm_cbe_tmp3_2e_i);
  ltmp_0_1 = memset(llvm_cbe_tmp21, (((unsigned int )(unsigned char )((unsigned char )0))), (((signed long long )(signed int )llvm_cbe_tmp3_2e_i)));
  llvm_cbe_tmp3_2e_i74 = *llvm_cbe_tmp2_2e_i;
  llvm_cbe_tmp29 = llvm_cbe_tmp3_2e_i74 + 4294967295u;
  *((&llvm_cbe_tmp21[((signed long long )(((signed long long )(signed int )llvm_cbe_tmp29)))])) = ((unsigned char )1);
  *llvm_cbe_tmp21 = ((unsigned char )1);
  _ZN4Path11simplifySubEiifPb(llvm_cbe_this, 0u, llvm_cbe_tmp29, llvm_cbe_threshold, llvm_cbe_tmp21);
  llvm_cbe_tmp2_2e_i66 = (&llvm_cbe_this->field0.field0);
  llvm_cbe_k_2e_1__PHI_TEMPORARY = 0u;   /* for PHI node */
  llvm_cbe_storemerge__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb74;

  do {     /* Syntactic loop 'bb74' to make GCC happy */
llvm_cbe_bb74:
  llvm_cbe_k_2e_1 = llvm_cbe_k_2e_1__PHI_TEMPORARY;
  llvm_cbe_storemerge = llvm_cbe_storemerge__PHI_TEMPORARY;
  llvm_cbe_tmp3_2e_i50 = *llvm_cbe_tmp2_2e_i;
  if ((((signed int )llvm_cbe_tmp3_2e_i50) > ((signed int )llvm_cbe_storemerge))) {
    goto llvm_cbe_bb;
  } else {
    goto llvm_cbe_bb83;
  }

llvm_cbe_bb71:
  llvm_cbe_k_2e_0 = llvm_cbe_k_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp73 = llvm_cbe_storemerge + 1u;
  llvm_cbe_k_2e_1__PHI_TEMPORARY = llvm_cbe_k_2e_0;   /* for PHI node */
  llvm_cbe_storemerge__PHI_TEMPORARY = llvm_cbe_tmp73;   /* for PHI node */
  goto llvm_cbe_bb74;

llvm_cbe_bb:
  llvm_cbe_tmp4749 = ((signed long long )(signed int )llvm_cbe_storemerge);
  llvm_cbe_tmp51 = *((&llvm_cbe_tmp21[((signed long long )llvm_cbe_tmp4749)]));
  if ((llvm_cbe_tmp51 == ((unsigned char )0))) {
    llvm_cbe_k_2e_0__PHI_TEMPORARY = llvm_cbe_k_2e_1;   /* for PHI node */
    goto llvm_cbe_bb71;
  } else {
    goto llvm_cbe_bb52;
  }

llvm_cbe_bb52:
  llvm_cbe_tmp55 = llvm_cbe_k_2e_1 + 1u;
  llvm_cbe_tmp3_2e_i67 = *llvm_cbe_tmp2_2e_i66;
  llvm_cbe_tmp45_2e_i69 = ((signed long long )(signed int )llvm_cbe_k_2e_1);
  llvm_cbe_tmp66 = *((&llvm_cbe_tmp3_2e_i67[((signed long long )llvm_cbe_tmp4749)].field0));
  *((&llvm_cbe_tmp3_2e_i67[((signed long long )llvm_cbe_tmp45_2e_i69)].field0)) = llvm_cbe_tmp66;
  llvm_cbe_tmp70 = *((&llvm_cbe_tmp3_2e_i67[((signed long long )llvm_cbe_tmp4749)].field1));
  *((&llvm_cbe_tmp3_2e_i67[((signed long long )llvm_cbe_tmp45_2e_i69)].field1)) = llvm_cbe_tmp70;
  llvm_cbe_k_2e_0__PHI_TEMPORARY = llvm_cbe_tmp55;   /* for PHI node */
  goto llvm_cbe_bb71;

  } while (1); /* end of syntactic loop 'bb74' */
llvm_cbe_bb83:
  llvm_cbe_tmp1_2e_i38 = (&llvm_cbe_this->field0.field1);
  llvm_cbe_tmp2_2e_i39 = *llvm_cbe_tmp1_2e_i38;
  *llvm_cbe_tmp1_2e_i38 = (llvm_cbe_tmp2_2e_i39 + (llvm_cbe_k_2e_1 - llvm_cbe_tmp3_2e_i50));
  llvm_cbe_tmp3_2e_i33 = *llvm_cbe_tmp2_2e_i;
  llvm_cbe_storemerge1_2e_in__PHI_TEMPORARY = llvm_cbe_tmp3_2e_i33;   /* for PHI node */
  goto llvm_cbe_bb115;

  do {     /* Syntactic loop 'bb115' to make GCC happy */
llvm_cbe_bb115:
  llvm_cbe_storemerge1_2e_in = llvm_cbe_storemerge1_2e_in__PHI_TEMPORARY;
  llvm_cbe_storemerge1 = llvm_cbe_storemerge1_2e_in + 4294967295u;
  if ((((signed int )llvm_cbe_storemerge1) > ((signed int )0u))) {
    goto llvm_cbe_bb95;
  } else {
    goto llvm_cbe_bb120;
  }

llvm_cbe_bb95:
  llvm_cbe_tmp3_2e_i26 = *llvm_cbe_tmp2_2e_i66;
  llvm_cbe_tmp45_2e_i = ((signed long long )(signed int )llvm_cbe_storemerge1);
  llvm_cbe_tmp6_2e_i20 = (&llvm_cbe_tmp3_2e_i26[((signed long long )llvm_cbe_tmp45_2e_i)]);
  llvm_cbe_tmp3_2e_i9 = *((&llvm_cbe_tmp3_2e_i26[((signed long long )llvm_cbe_tmp45_2e_i)].field0));
  llvm_cbe_tmp6_2e_i = *((&llvm_cbe_tmp3_2e_i26[((signed long long )(((signed long long )(signed int )(llvm_cbe_storemerge1_2e_in + 4294967294u))))].field0));
  if ((llvm_cbe_tmp3_2e_i9 == llvm_cbe_tmp6_2e_i)) {
    goto llvm_cbe_bb108;
  } else {
    llvm_cbe_storemerge1_2e_in__PHI_TEMPORARY = llvm_cbe_storemerge1;   /* for PHI node */
    goto llvm_cbe_bb115;
  }

llvm_cbe__ZN5ArrayI4Vec2E5eraseEi_2e_exit:
  llvm_cbe_tmp33_2e_i = *llvm_cbe_tmp1_2e_i38;
  *llvm_cbe_tmp1_2e_i38 = (llvm_cbe_tmp33_2e_i + 4294967295u);
  llvm_cbe_storemerge1_2e_in__PHI_TEMPORARY = llvm_cbe_storemerge1;   /* for PHI node */
  goto llvm_cbe_bb115;

llvm_cbe_bb108:
  llvm_cbe_tmp2_2e_i3 = *llvm_cbe_tmp1_2e_i38;
  if ((((signed int )(llvm_cbe_tmp2_2e_i3 + 4294967295u)) > ((signed int )llvm_cbe_storemerge1))) {
    goto llvm_cbe_bb_2e_i;
  } else {
    goto llvm_cbe__ZN5ArrayI4Vec2E5eraseEi_2e_exit;
  }

llvm_cbe_bb_2e_i:
  ltmp_1_1 = memcpy((((unsigned char *)llvm_cbe_tmp6_2e_i20)), (((unsigned char *)((&llvm_cbe_tmp3_2e_i26[((signed long long )(llvm_cbe_tmp45_2e_i + 1ull))])))), ((((signed long long )(signed int )((llvm_cbe_tmp2_2e_i3 - llvm_cbe_storemerge1) + 4294967295u))) << 3ull));
  goto llvm_cbe__ZN5ArrayI4Vec2E5eraseEi_2e_exit;

  } while (1); /* end of syntactic loop 'bb115' */
llvm_cbe_bb120:
  return;
}


static void _ZN6Canvas7setClipEiiii(struct l_struct_2E_Canvas *llvm_cbe_this, unsigned int llvm_cbe_w, unsigned int llvm_cbe_h) {
  *((&llvm_cbe_this->field4.field0.field0)) = 0u;
  *((&llvm_cbe_this->field4.field0.field1)) = 0u;
  *((&llvm_cbe_this->field4.field1.field0)) = (llvm_cbe_w + 4294967295u);
  *((&llvm_cbe_this->field4.field1.field1)) = (llvm_cbe_h + 4294967295u);
  return;
}


static void _ZN6CanvasD1Ev(struct l_struct_2E_Canvas *llvm_cbe_this) {
  *((&llvm_cbe_this->field0)) = ((&_ZTV6Canvas[((signed long long )2ull)]));
  return;
}


static void _ZN6CanvasD0Ev(struct l_struct_2E_Canvas *llvm_cbe_this) {
  *((&llvm_cbe_this->field0)) = ((&_ZTV6Canvas[((signed long long )2ull)]));
  _ZdlPv((((unsigned char *)llvm_cbe_this)));
  return;
}


static void _ZN10AlphaBrushItLj3EE3inkEPtii(struct l_struct_2E_AlphaBrush_3C_short_20_unsigned_20_int_2C_1u_3E_ *llvm_cbe_this, unsigned short *llvm_cbe_pix, unsigned int llvm_cbe_step, unsigned int llvm_cbe_a) {
  unsigned int llvm_cbe_tmp1;
  unsigned int *llvm_cbe_tmp3;
  unsigned int llvm_cbe_tmp4;
  unsigned int *llvm_cbe_tmp6;
  unsigned int llvm_cbe_tmp7;
  unsigned int *llvm_cbe_tmp9;
  unsigned int llvm_cbe_tmp10;
  unsigned long long llvm_cbe_tmp1112;
  unsigned short *llvm_cbe_tmp15;
  unsigned short llvm_cbe_tmp5_2e_i;
  unsigned int llvm_cbe_tmp20;
  unsigned int llvm_cbe_tmp25;
  unsigned int llvm_cbe_tmp28;
  unsigned int llvm_cbe_tmp31;
  unsigned short *llvm_cbe_tmp35;
  unsigned short llvm_cbe_tmp5_2e_i12;

  llvm_cbe_tmp1 = 255u - llvm_cbe_a;
  llvm_cbe_tmp3 = (&llvm_cbe_this->field2);
  llvm_cbe_tmp4 = *llvm_cbe_tmp3;
  llvm_cbe_tmp6 = (&llvm_cbe_this->field1);
  llvm_cbe_tmp7 = *llvm_cbe_tmp6;
  llvm_cbe_tmp9 = (&llvm_cbe_this->field0);
  llvm_cbe_tmp10 = *llvm_cbe_tmp9;
  llvm_cbe_tmp1112 = ((signed long long )(signed int )llvm_cbe_step);
  llvm_cbe_tmp15 = (&llvm_cbe_pix[((signed long long )(-(llvm_cbe_tmp1112)))]);
  llvm_cbe_tmp5_2e_i = *llvm_cbe_tmp15;
  *llvm_cbe_tmp15 = (((unsigned short )((((unsigned short )((((unsigned short )((((unsigned short )((((unsigned short )(llvm_cbe_tmp10 * llvm_cbe_a))) + (((unsigned short )(((((unsigned int )(unsigned short )(((unsigned short )(((unsigned short )(((unsigned short )llvm_cbe_tmp5_2e_i) >> ((unsigned short )((unsigned short )8))))))))) & 248u) * llvm_cbe_tmp1)))))) & ((unsigned short )-2048)))) | (((unsigned short )((((unsigned short )(((unsigned int )(((unsigned int )((llvm_cbe_tmp7 * llvm_cbe_a) + (((((unsigned int )(unsigned short )(((unsigned short )(((unsigned short )(((unsigned short )llvm_cbe_tmp5_2e_i) >> ((unsigned short )((unsigned short )3))))))))) & 252u) * llvm_cbe_tmp1))) >> ((unsigned int )5u)))))) & ((unsigned short )2016))))))) | (((unsigned short )((((unsigned short )(((unsigned int )(((unsigned int )((llvm_cbe_tmp4 * llvm_cbe_a) + ((((((unsigned int )(unsigned short )llvm_cbe_tmp5_2e_i)) << 3u) & 248u) * llvm_cbe_tmp1))) >> ((unsigned int )11u)))))) & ((unsigned short )31)))))));
  llvm_cbe_tmp20 = *((&llvm_cbe_this->field3));
  *llvm_cbe_pix = (((unsigned short )llvm_cbe_tmp20));
  llvm_cbe_tmp25 = *llvm_cbe_tmp3;
  llvm_cbe_tmp28 = *llvm_cbe_tmp6;
  llvm_cbe_tmp31 = *llvm_cbe_tmp9;
  llvm_cbe_tmp35 = (&llvm_cbe_pix[((signed long long )llvm_cbe_tmp1112)]);
  llvm_cbe_tmp5_2e_i12 = *llvm_cbe_tmp35;
  *llvm_cbe_tmp35 = (((unsigned short )((((unsigned short )((((unsigned short )((((unsigned short )((((unsigned short )(llvm_cbe_tmp1 * llvm_cbe_tmp31))) + (((unsigned short )(((((unsigned int )(unsigned short )(((unsigned short )(((unsigned short )(((unsigned short )llvm_cbe_tmp5_2e_i12) >> ((unsigned short )((unsigned short )8))))))))) & 248u) * llvm_cbe_a)))))) & ((unsigned short )-2048)))) | (((unsigned short )((((unsigned short )(((unsigned int )(((unsigned int )((llvm_cbe_tmp1 * llvm_cbe_tmp28) + (((((unsigned int )(unsigned short )(((unsigned short )(((unsigned short )(((unsigned short )llvm_cbe_tmp5_2e_i12) >> ((unsigned short )((unsigned short )3))))))))) & 252u) * llvm_cbe_a))) >> ((unsigned int )5u)))))) & ((unsigned short )2016))))))) | (((unsigned short )((((unsigned short )(((unsigned int )(((unsigned int )((llvm_cbe_tmp1 * llvm_cbe_tmp25) + ((((((unsigned int )(unsigned short )llvm_cbe_tmp5_2e_i12)) << 3u) & 248u) * llvm_cbe_a))) >> ((unsigned int )11u)))))) & ((unsigned short )31)))))));
  return;
}


static void _ZN10AlphaBrushItLj1EE3inkEPtii(struct l_struct_2E_AlphaBrush_3C_short_20_unsigned_20_int_2C_1u_3E_ *llvm_cbe_this, unsigned short *llvm_cbe_pix, unsigned int llvm_cbe_step, unsigned int llvm_cbe_a) {
  unsigned int llvm_cbe_tmp1;
  unsigned int *llvm_cbe_tmp3;
  unsigned int llvm_cbe_tmp4;
  unsigned int *llvm_cbe_tmp6;
  unsigned int llvm_cbe_tmp7;
  unsigned int *llvm_cbe_tmp9;
  unsigned int llvm_cbe_tmp10;
  unsigned short *llvm_cbe_tmp15;
  unsigned short llvm_cbe_tmp5_2e_i;
  unsigned int llvm_cbe_tmp20;
  unsigned int llvm_cbe_tmp23;
  unsigned int llvm_cbe_tmp26;
  unsigned short llvm_cbe_tmp5_2e_i12;

  llvm_cbe_tmp1 = 255u - llvm_cbe_a;
  llvm_cbe_tmp3 = (&llvm_cbe_this->field2);
  llvm_cbe_tmp4 = *llvm_cbe_tmp3;
  llvm_cbe_tmp6 = (&llvm_cbe_this->field1);
  llvm_cbe_tmp7 = *llvm_cbe_tmp6;
  llvm_cbe_tmp9 = (&llvm_cbe_this->field0);
  llvm_cbe_tmp10 = *llvm_cbe_tmp9;
  llvm_cbe_tmp15 = (&llvm_cbe_pix[((signed long long )(-((((signed long long )(signed int )llvm_cbe_step)))))]);
  llvm_cbe_tmp5_2e_i = *llvm_cbe_tmp15;
  *llvm_cbe_tmp15 = (((unsigned short )((((unsigned short )((((unsigned short )((((unsigned short )((((unsigned short )(llvm_cbe_tmp10 * llvm_cbe_a))) + (((unsigned short )(((((unsigned int )(unsigned short )(((unsigned short )(((unsigned short )(((unsigned short )llvm_cbe_tmp5_2e_i) >> ((unsigned short )((unsigned short )8))))))))) & 248u) * llvm_cbe_tmp1)))))) & ((unsigned short )-2048)))) | (((unsigned short )((((unsigned short )(((unsigned int )(((unsigned int )((llvm_cbe_tmp7 * llvm_cbe_a) + (((((unsigned int )(unsigned short )(((unsigned short )(((unsigned short )(((unsigned short )llvm_cbe_tmp5_2e_i) >> ((unsigned short )((unsigned short )3))))))))) & 252u) * llvm_cbe_tmp1))) >> ((unsigned int )5u)))))) & ((unsigned short )2016))))))) | (((unsigned short )((((unsigned short )(((unsigned int )(((unsigned int )((llvm_cbe_tmp4 * llvm_cbe_a) + ((((((unsigned int )(unsigned short )llvm_cbe_tmp5_2e_i)) << 3u) & 248u) * llvm_cbe_tmp1))) >> ((unsigned int )11u)))))) & ((unsigned short )31)))))));
  llvm_cbe_tmp20 = *llvm_cbe_tmp3;
  llvm_cbe_tmp23 = *llvm_cbe_tmp6;
  llvm_cbe_tmp26 = *llvm_cbe_tmp9;
  llvm_cbe_tmp5_2e_i12 = *llvm_cbe_pix;
  *llvm_cbe_pix = (((unsigned short )((((unsigned short )((((unsigned short )((((unsigned short )((((unsigned short )(llvm_cbe_tmp1 * llvm_cbe_tmp26))) + (((unsigned short )(((((unsigned int )(unsigned short )(((unsigned short )(((unsigned short )(((unsigned short )llvm_cbe_tmp5_2e_i12) >> ((unsigned short )((unsigned short )8))))))))) & 248u) * llvm_cbe_a)))))) & ((unsigned short )-2048)))) | (((unsigned short )((((unsigned short )(((unsigned int )(((unsigned int )((llvm_cbe_tmp1 * llvm_cbe_tmp23) + (((((unsigned int )(unsigned short )(((unsigned short )(((unsigned short )(((unsigned short )llvm_cbe_tmp5_2e_i12) >> ((unsigned short )((unsigned short )3))))))))) & 252u) * llvm_cbe_a))) >> ((unsigned int )5u)))))) & ((unsigned short )2016))))))) | (((unsigned short )((((unsigned short )(((unsigned int )(((unsigned int )((llvm_cbe_tmp1 * llvm_cbe_tmp20) + ((((((unsigned int )(unsigned short )llvm_cbe_tmp5_2e_i12)) << 3u) & 248u) * llvm_cbe_a))) >> ((unsigned int )11u)))))) & ((unsigned short )31)))))));
  return;
}


static void _ZN10AlphaBrushIjLj3EE3inkEPjii(struct l_struct_2E_AlphaBrush_3C_short_20_unsigned_20_int_2C_1u_3E_ *llvm_cbe_this, unsigned int *llvm_cbe_pix, unsigned int llvm_cbe_step, unsigned int llvm_cbe_a) {
  unsigned int llvm_cbe_tmp1;
  unsigned int *llvm_cbe_tmp3;
  unsigned int llvm_cbe_tmp4;
  unsigned int *llvm_cbe_tmp6;
  unsigned int llvm_cbe_tmp7;
  unsigned int *llvm_cbe_tmp9;
  unsigned int llvm_cbe_tmp10;
  unsigned long long llvm_cbe_tmp1112;
  unsigned int *llvm_cbe_tmp15;
  unsigned int llvm_cbe_tmp4_2e_i;
  unsigned int llvm_cbe_tmp20;
  unsigned int llvm_cbe_tmp24;
  unsigned int llvm_cbe_tmp27;
  unsigned int llvm_cbe_tmp30;
  unsigned int *llvm_cbe_tmp34;
  unsigned int llvm_cbe_tmp4_2e_i11;

  llvm_cbe_tmp1 = 255u - llvm_cbe_a;
  llvm_cbe_tmp3 = (&llvm_cbe_this->field2);
  llvm_cbe_tmp4 = *llvm_cbe_tmp3;
  llvm_cbe_tmp6 = (&llvm_cbe_this->field1);
  llvm_cbe_tmp7 = *llvm_cbe_tmp6;
  llvm_cbe_tmp9 = (&llvm_cbe_this->field0);
  llvm_cbe_tmp10 = *llvm_cbe_tmp9;
  llvm_cbe_tmp1112 = ((signed long long )(signed int )llvm_cbe_step);
  llvm_cbe_tmp15 = (&llvm_cbe_pix[((signed long long )(-(llvm_cbe_tmp1112)))]);
  llvm_cbe_tmp4_2e_i = *llvm_cbe_tmp15;
  *llvm_cbe_tmp15 = ((((((llvm_cbe_tmp10 * llvm_cbe_a) + (((((unsigned int )(((unsigned int )llvm_cbe_tmp4_2e_i) >> ((unsigned int )16u)))) & 255u) * llvm_cbe_tmp1)) << 8u) & 16711680u) | (((llvm_cbe_tmp7 * llvm_cbe_a) + (((((unsigned int )(((unsigned int )llvm_cbe_tmp4_2e_i) >> ((unsigned int )8u)))) & 255u) * llvm_cbe_tmp1)) & 65280u)) | (((unsigned int )(((unsigned int )((llvm_cbe_tmp4 * llvm_cbe_a) + ((llvm_cbe_tmp4_2e_i & 255u) * llvm_cbe_tmp1))) >> ((unsigned int )8u)))));
  llvm_cbe_tmp20 = *((&llvm_cbe_this->field3));
  *llvm_cbe_pix = llvm_cbe_tmp20;
  llvm_cbe_tmp24 = *llvm_cbe_tmp3;
  llvm_cbe_tmp27 = *llvm_cbe_tmp6;
  llvm_cbe_tmp30 = *llvm_cbe_tmp9;
  llvm_cbe_tmp34 = (&llvm_cbe_pix[((signed long long )llvm_cbe_tmp1112)]);
  llvm_cbe_tmp4_2e_i11 = *llvm_cbe_tmp34;
  *llvm_cbe_tmp34 = ((((((llvm_cbe_tmp1 * llvm_cbe_tmp30) + (((((unsigned int )(((unsigned int )llvm_cbe_tmp4_2e_i11) >> ((unsigned int )16u)))) & 255u) * llvm_cbe_a)) << 8u) & 16711680u) | (((llvm_cbe_tmp1 * llvm_cbe_tmp27) + (((((unsigned int )(((unsigned int )llvm_cbe_tmp4_2e_i11) >> ((unsigned int )8u)))) & 255u) * llvm_cbe_a)) & 65280u)) | (((unsigned int )(((unsigned int )((llvm_cbe_tmp1 * llvm_cbe_tmp24) + ((llvm_cbe_tmp4_2e_i11 & 255u) * llvm_cbe_a))) >> ((unsigned int )8u)))));
  return;
}


static void _ZN10AlphaBrushIjLj1EE3inkEPjii(struct l_struct_2E_AlphaBrush_3C_short_20_unsigned_20_int_2C_1u_3E_ *llvm_cbe_this, unsigned int *llvm_cbe_pix, unsigned int llvm_cbe_step, unsigned int llvm_cbe_a) {
  unsigned int llvm_cbe_tmp1;
  unsigned int *llvm_cbe_tmp3;
  unsigned int llvm_cbe_tmp4;
  unsigned int *llvm_cbe_tmp6;
  unsigned int llvm_cbe_tmp7;
  unsigned int *llvm_cbe_tmp9;
  unsigned int llvm_cbe_tmp10;
  unsigned int *llvm_cbe_tmp15;
  unsigned int llvm_cbe_tmp4_2e_i;
  unsigned int llvm_cbe_tmp20;
  unsigned int llvm_cbe_tmp23;
  unsigned int llvm_cbe_tmp26;
  unsigned int llvm_cbe_tmp4_2e_i11;

  llvm_cbe_tmp1 = 255u - llvm_cbe_a;
  llvm_cbe_tmp3 = (&llvm_cbe_this->field2);
  llvm_cbe_tmp4 = *llvm_cbe_tmp3;
  llvm_cbe_tmp6 = (&llvm_cbe_this->field1);
  llvm_cbe_tmp7 = *llvm_cbe_tmp6;
  llvm_cbe_tmp9 = (&llvm_cbe_this->field0);
  llvm_cbe_tmp10 = *llvm_cbe_tmp9;
  llvm_cbe_tmp15 = (&llvm_cbe_pix[((signed long long )(-((((signed long long )(signed int )llvm_cbe_step)))))]);
  llvm_cbe_tmp4_2e_i = *llvm_cbe_tmp15;
  *llvm_cbe_tmp15 = ((((((llvm_cbe_tmp10 * llvm_cbe_a) + (((((unsigned int )(((unsigned int )llvm_cbe_tmp4_2e_i) >> ((unsigned int )16u)))) & 255u) * llvm_cbe_tmp1)) << 8u) & 16711680u) | (((llvm_cbe_tmp7 * llvm_cbe_a) + (((((unsigned int )(((unsigned int )llvm_cbe_tmp4_2e_i) >> ((unsigned int )8u)))) & 255u) * llvm_cbe_tmp1)) & 65280u)) | (((unsigned int )(((unsigned int )((llvm_cbe_tmp4 * llvm_cbe_a) + ((llvm_cbe_tmp4_2e_i & 255u) * llvm_cbe_tmp1))) >> ((unsigned int )8u)))));
  llvm_cbe_tmp20 = *llvm_cbe_tmp3;
  llvm_cbe_tmp23 = *llvm_cbe_tmp6;
  llvm_cbe_tmp26 = *llvm_cbe_tmp9;
  llvm_cbe_tmp4_2e_i11 = *llvm_cbe_pix;
  *llvm_cbe_pix = ((((((llvm_cbe_tmp1 * llvm_cbe_tmp26) + (((((unsigned int )(((unsigned int )llvm_cbe_tmp4_2e_i11) >> ((unsigned int )16u)))) & 255u) * llvm_cbe_a)) << 8u) & 16711680u) | (((llvm_cbe_tmp1 * llvm_cbe_tmp23) + (((((unsigned int )(((unsigned int )llvm_cbe_tmp4_2e_i11) >> ((unsigned int )8u)))) & 255u) * llvm_cbe_a)) & 65280u)) | (((unsigned int )(((unsigned int )((llvm_cbe_tmp1 * llvm_cbe_tmp20) + ((llvm_cbe_tmp4_2e_i11 & 255u) * llvm_cbe_a))) >> ((unsigned int )8u)))));
  return;
}


static void _ZN5ImageD0Ev(struct l_struct_2E_Image *llvm_cbe_this) {
  *((&llvm_cbe_this->field0.field0)) = ((&_ZTV6Canvas[((signed long long )2ull)]));
  _ZdlPv((((unsigned char *)llvm_cbe_this)));
  return;
}


static void _ZN5ImageD1Ev(struct l_struct_2E_Image *llvm_cbe_this) {
  *((&llvm_cbe_this->field0.field0)) = ((&_ZTV6Canvas[((signed long long )2ull)]));
  return;
}


static void _ZN6WindowD0Ev(struct l_struct_2E_Image *llvm_cbe_this) {
  *((&llvm_cbe_this->field0.field0)) = ((&_ZTV6Canvas[((signed long long )2ull)]));
  _ZdlPv((((unsigned char *)llvm_cbe_this)));
  return;
}


static void _ZN6WindowD1Ev(struct l_struct_2E_Image *llvm_cbe_this) {
  *((&llvm_cbe_this->field0.field0)) = ((&_ZTV6Canvas[((signed long long )2ull)]));
  return;
}


static void _ZN5ImageC1EPKcb(struct l_struct_2E_Image *llvm_cbe_this, unsigned char *llvm_cbe_file) {
  struct l_struct_2E_std_3A__3A_string llvm_cbe_f;    /* Address-exposed local */
  struct l_struct_2E_std_3A__3A_string llvm_cbe_tmp1;    /* Address-exposed local */
  struct l_struct_2E_std_3A__3A_string llvm_cbe_tmp2;    /* Address-exposed local */
  struct l_struct_2E_std_3A__3A_string llvm_cbe_tmp3;    /* Address-exposed local */
  struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ llvm_cbe_tmp4;    /* Address-exposed local */
  struct l_struct_2E_std_3A__3A_string llvm_cbe_tmp5;    /* Address-exposed local */
  struct l_struct_2E_std_3A__3A_string llvm_cbe_tmp6;    /* Address-exposed local */
  struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ llvm_cbe_tmp7;    /* Address-exposed local */
  struct l_struct_2E_Canvas *llvm_cbe_tmp9;
  unsigned char **llvm_cbe_tmp4_2e_i;
  struct l_struct_2E_std_3A__3A_string *llvm_cbe_tmp9_2e_i80;
  unsigned char *llvm_cbe_tmp21;
  struct l_struct_2E_SDL_Surface *llvm_cbe_tmp23;
  struct l_struct_2E_std_3A__3A_string *llvm_cbe_tmp38;
  struct l_struct_2E_std_3A__3A_string *llvm_cbe_tmp9_2e_i55;
  unsigned char *llvm_cbe_tmp55;
  struct l_struct_2E_SDL_Surface *llvm_cbe_tmp57;
  struct l_struct_2E_SDL_Surface *llvm_cbe_img_2e_0;
  struct l_struct_2E_SDL_Surface *llvm_cbe_img_2e_0__PHI_TEMPORARY;
  struct l_struct_2E_std_3A__3A_string *llvm_cbe_tmp9_2e_i30;
  unsigned char *llvm_cbe_tmp73;
  unsigned int llvm_cbe_tmp76;
  struct l_struct_2E_SDL_Surface *llvm_cbe_tmp97;
  unsigned char **llvm_cbe_tmp105;
  unsigned char *llvm_cbe_tmp106;
  struct l_struct_2E_std_3A__3A_string *llvm_cbe_tmp9_2e_i16;
  unsigned char *llvm_cbe_tmp117;
  unsigned int llvm_cbe_tmp120;
  unsigned char *llvm_cbe_tmp2_2e_i4;
  unsigned char *llvm_cbe_tmp3_2e_i_2e_i8;
  struct l_struct_2E_SDL_Surface *llvm_cbe_tmp34_2e_i_2e_i;
  unsigned int llvm_cbe_tmp6_2e_i_2e_i;
  unsigned int llvm_cbe_tmp6_2e_i6_2e_i;
  unsigned char *llvm_cbe_tmp138;

  llvm_cbe_tmp9 = (&llvm_cbe_this->field0);
  *((&llvm_cbe_this->field0.field0)) = ((&_ZTV6Canvas[((signed long long )2ull)]));
  llvm_cbe_tmp4_2e_i = (&llvm_cbe_this->field0.field1);
  *llvm_cbe_tmp4_2e_i = ((unsigned char *)/*NULL*/0);
  *((&llvm_cbe_this->field0.field2)) = 0u;
  *((&llvm_cbe_this->field0.field3)) = ((struct l_struct_2E_Canvas *)/*NULL*/0);
  _ZN6Canvas7setClipEiiii(llvm_cbe_tmp9, 0u, 0u);
  *((&llvm_cbe_this->field0.field0)) = ((&_ZTV5Image[((signed long long )2ull)]));
  _ZNSaIcEC1Ev((&llvm_cbe_tmp7));
  _ZNSsC1EPKcRKSaIcE((&llvm_cbe_f), ((&_2E_str1[((signed long long )0ull)])), (&llvm_cbe_tmp7));
  _ZNSaIcED1Ev((&llvm_cbe_tmp7));
  _ZNSsC1ERKSs((&llvm_cbe_tmp6), (&llvm_cbe_f));
  llvm_cbe_tmp9_2e_i80 = _ZNSs6appendEPKc((&llvm_cbe_tmp6), llvm_cbe_file);
  llvm_cbe_tmp21 = _ZNKSs5c_strEv((&llvm_cbe_tmp6));
  llvm_cbe_tmp23 = IMG_Load(llvm_cbe_tmp21);
  _ZNSsD1Ev((&llvm_cbe_tmp6));
  if ((llvm_cbe_tmp23 == ((struct l_struct_2E_SDL_Surface *)/*NULL*/0))) {
    goto llvm_cbe_bb34;
  } else {
    llvm_cbe_img_2e_0__PHI_TEMPORARY = llvm_cbe_tmp23;   /* for PHI node */
    goto llvm_cbe_bb64;
  }

llvm_cbe_bb34:
  _ZNSaIcEC1Ev((&llvm_cbe_tmp4));
  _ZNSsC1EPKcRKSaIcE((&llvm_cbe_tmp5), ((&_2E_str12[((signed long long )0ull)])), (&llvm_cbe_tmp4));
  llvm_cbe_tmp38 = _ZNSsaSERKSs((&llvm_cbe_f), (&llvm_cbe_tmp5));
  _ZNSsD1Ev((&llvm_cbe_tmp5));
  _ZNSaIcED1Ev((&llvm_cbe_tmp4));
  _ZNSsC1ERKSs((&llvm_cbe_tmp3), (&llvm_cbe_f));
  llvm_cbe_tmp9_2e_i55 = _ZNSs6appendEPKc((&llvm_cbe_tmp3), llvm_cbe_file);
  llvm_cbe_tmp55 = _ZNKSs5c_strEv((&llvm_cbe_tmp3));
  llvm_cbe_tmp57 = IMG_Load(llvm_cbe_tmp55);
  _ZNSsD1Ev((&llvm_cbe_tmp3));
  llvm_cbe_img_2e_0__PHI_TEMPORARY = llvm_cbe_tmp57;   /* for PHI node */
  goto llvm_cbe_bb64;

llvm_cbe_bb64:
  llvm_cbe_img_2e_0 = llvm_cbe_img_2e_0__PHI_TEMPORARY;
  if ((llvm_cbe_img_2e_0 == ((struct l_struct_2E_SDL_Surface *)/*NULL*/0))) {
    goto llvm_cbe_bb137;
  } else {
    goto llvm_cbe_bb69;
  }

llvm_cbe_bb69:
  _ZNSsC1ERKSs((&llvm_cbe_tmp2), (&llvm_cbe_f));
  llvm_cbe_tmp9_2e_i30 = _ZNSs6appendEPKc((&llvm_cbe_tmp2), llvm_cbe_file);
  llvm_cbe_tmp73 = _ZNKSs5c_strEv((&llvm_cbe_tmp2));
  llvm_cbe_tmp76 = printf(((&_2E_str2[((signed long long )0ull)])), llvm_cbe_tmp73);
  _ZNSsD1Ev((&llvm_cbe_tmp2));
  llvm_cbe_tmp97 = SDL_DisplayFormat(llvm_cbe_img_2e_0);
  *((&llvm_cbe_this->field0.field1)) = (((unsigned char *)llvm_cbe_tmp97));
  llvm_cbe_tmp105 = (&llvm_cbe_this->field0.field1);
  llvm_cbe_tmp106 = *llvm_cbe_tmp105;
  if ((llvm_cbe_tmp106 == ((unsigned char *)/*NULL*/0))) {
    goto llvm_cbe_bb113;
  } else {
    goto llvm_cbe_bb110;
  }

llvm_cbe_bb110:
  SDL_FreeSurface(llvm_cbe_img_2e_0);
  goto llvm_cbe_bb133;

llvm_cbe_bb113:
  _ZNSsC1ERKSs((&llvm_cbe_tmp1), (&llvm_cbe_f));
  llvm_cbe_tmp9_2e_i16 = _ZNSs6appendEPKc((&llvm_cbe_tmp1), llvm_cbe_file);
  llvm_cbe_tmp117 = _ZNKSs5c_strEv((&llvm_cbe_tmp1));
  llvm_cbe_tmp120 = printf(((&_2E_str3[((signed long long )0ull)])), llvm_cbe_tmp117);
  _ZNSsD1Ev((&llvm_cbe_tmp1));
  *llvm_cbe_tmp105 = (((unsigned char *)llvm_cbe_img_2e_0));
  goto llvm_cbe_bb133;

llvm_cbe_bb133:
  llvm_cbe_tmp2_2e_i4 = *llvm_cbe_tmp105;
  if ((llvm_cbe_tmp2_2e_i4 == ((unsigned char *)/*NULL*/0))) {
    goto llvm_cbe_bb10_2e_i;
  } else {
    goto llvm_cbe_bb_2e_i;
  }

llvm_cbe_bb_2e_i:
  llvm_cbe_tmp3_2e_i_2e_i8 = *llvm_cbe_tmp4_2e_i;
  llvm_cbe_tmp34_2e_i_2e_i = ((struct l_struct_2E_SDL_Surface *)llvm_cbe_tmp3_2e_i_2e_i8);
  llvm_cbe_tmp6_2e_i_2e_i = *((&llvm_cbe_tmp34_2e_i_2e_i->field3));
  llvm_cbe_tmp6_2e_i6_2e_i = *((&llvm_cbe_tmp34_2e_i_2e_i->field2));
  _ZN6Canvas7setClipEiiii(llvm_cbe_tmp9, llvm_cbe_tmp6_2e_i6_2e_i, llvm_cbe_tmp6_2e_i_2e_i);
  goto llvm_cbe_bb144;

llvm_cbe_bb10_2e_i:
  _ZN6Canvas7setClipEiiii(llvm_cbe_tmp9, 0u, 0u);
  goto llvm_cbe_bb144;

llvm_cbe_bb137:
  llvm_cbe_tmp138 = __cxa_allocate_exception(8ull);
  *(((unsigned char **)llvm_cbe_tmp138)) = ((&_2E_str4[((signed long long )0ull)]));
  __cxa_throw(llvm_cbe_tmp138, ((unsigned char *)(&_ZTIPc)), ((void  (*) (unsigned char *))/*NULL*/0));
  /*UNREACHABLE*/;
llvm_cbe_bb144:
  _ZNSsD1Ev((&llvm_cbe_f));
  return;
}


static void _ZN6Window6updateERK4Rect(struct l_struct_2E_Image *llvm_cbe_this, struct l_struct_2E_Rect *llvm_cbe_r) {
  unsigned int llvm_cbe_tmp3;
  unsigned char *llvm_cbe_tmp3_2e_i;
  struct l_struct_2E_SDL_Surface *llvm_cbe_tmp34_2e_i;
  unsigned int llvm_cbe_tmp6_2e_i;
  unsigned int llvm_cbe_tmp12;
  unsigned int llvm_cbe_tmp6_2e_i88;
  unsigned int llvm_cbe_storemerge_2e_i80;
  unsigned int llvm_cbe_storemerge_2e_i67;
  unsigned int llvm_cbe_tmp39;
  unsigned int llvm_cbe_tmp43;
  unsigned int llvm_cbe_tmp48;
  unsigned int llvm_cbe_tmp52;
  unsigned int llvm_cbe_tmp56;
  unsigned int llvm_cbe_storemerge_2e_i15;
  unsigned int llvm_cbe_tmp60;
  unsigned int llvm_cbe_storemerge_2e_i;

  llvm_cbe_tmp3 = *((&llvm_cbe_r->field0.field0));
  llvm_cbe_tmp3_2e_i = *((&llvm_cbe_this->field0.field1));
  llvm_cbe_tmp34_2e_i = ((struct l_struct_2E_SDL_Surface *)llvm_cbe_tmp3_2e_i);
  llvm_cbe_tmp6_2e_i = *((&llvm_cbe_tmp34_2e_i->field2));
  if ((((signed int )llvm_cbe_tmp3) < ((signed int )llvm_cbe_tmp6_2e_i))) {
    goto llvm_cbe_bb;
  } else {
    goto llvm_cbe_return;
  }

llvm_cbe_bb:
  llvm_cbe_tmp12 = *((&llvm_cbe_r->field0.field1));
  llvm_cbe_tmp6_2e_i88 = *((&llvm_cbe_tmp34_2e_i->field3));
  if ((((signed int )llvm_cbe_tmp12) < ((signed int )llvm_cbe_tmp6_2e_i88))) {
    goto llvm_cbe_bb25;
  } else {
    goto llvm_cbe_return;
  }

llvm_cbe_bb25:
  llvm_cbe_storemerge_2e_i80 = (((((signed int )llvm_cbe_tmp3) > ((signed int )0u))) ? (llvm_cbe_tmp3) : (0u));
  llvm_cbe_storemerge_2e_i67 = (((((signed int )llvm_cbe_tmp12) > ((signed int )0u))) ? (llvm_cbe_tmp12) : (0u));
  llvm_cbe_tmp39 = *((&llvm_cbe_r->field1.field0));
  llvm_cbe_tmp43 = llvm_cbe_tmp6_2e_i + 4294967295u;
  llvm_cbe_tmp48 = *((&llvm_cbe_r->field1.field1));
  llvm_cbe_tmp52 = llvm_cbe_tmp6_2e_i88 + 4294967295u;
  llvm_cbe_tmp56 = ((((((signed int )llvm_cbe_tmp43) < ((signed int )llvm_cbe_tmp39))) ? (llvm_cbe_tmp43) : (llvm_cbe_tmp39))) - llvm_cbe_storemerge_2e_i80;
  llvm_cbe_storemerge_2e_i15 = (((((signed int )llvm_cbe_tmp56) > ((signed int )0u))) ? (llvm_cbe_tmp56) : (0u));
  llvm_cbe_tmp60 = ((((((signed int )llvm_cbe_tmp52) < ((signed int )llvm_cbe_tmp48))) ? (llvm_cbe_tmp52) : (llvm_cbe_tmp48))) - llvm_cbe_storemerge_2e_i67;
  llvm_cbe_storemerge_2e_i = (((((signed int )llvm_cbe_tmp60) > ((signed int )0u))) ? (llvm_cbe_tmp60) : (0u));
  if (((((((signed int )llvm_cbe_storemerge_2e_i15) > ((signed int )0u)) & (((signed int )llvm_cbe_storemerge_2e_i) > ((signed int )0u)))&1))) {
    goto llvm_cbe_bb71;
  } else {
    goto llvm_cbe_return;
  }

llvm_cbe_bb71:
  SDL_UpdateRect(llvm_cbe_tmp34_2e_i, llvm_cbe_storemerge_2e_i80, llvm_cbe_storemerge_2e_i67, llvm_cbe_storemerge_2e_i15, llvm_cbe_storemerge_2e_i);
  return;
llvm_cbe_return:
  return;
}


static void _ZN6Canvas8drawRectERK4Rectib(struct l_struct_2E_Canvas *llvm_cbe_this, struct l_struct_2E_Rect *llvm_cbe_r, unsigned int llvm_cbe_c, unsigned char llvm_cbe_fill) {
  struct l_struct_2E_SDL_Rect llvm_cbe_r_2e_i;    /* Address-exposed local */
  unsigned long long llvm_cbe_r1_2e_i;    /* Address-exposed local */
  struct l_struct_2E_SDL_Rect *llvm_cbe_tmpcast;
  unsigned int llvm_cbe_tmp5;
  unsigned int llvm_cbe_tmp9;
  unsigned int llvm_cbe_tmp10;
  unsigned int llvm_cbe_tmp14;
  unsigned int llvm_cbe_tmp18;
  unsigned int llvm_cbe_tmp19;
  unsigned char *llvm_cbe_tmp21_2e_i;
  unsigned int llvm_cbe_tmp23_2e_i;
  unsigned short llvm_cbe_tmp2930_2e_i;
  unsigned short llvm_cbe_tmp3233_2e_i;
  unsigned short llvm_cbe_tmp3536_2e_i;
  unsigned short llvm_cbe_tmp3839_2e_i;
  unsigned short *llvm_cbe_tmp41_2e_i;
  unsigned short *llvm_cbe_tmp44_2e_i;
  unsigned short *llvm_cbe_tmp47_2e_i;
  unsigned short *llvm_cbe_tmp50_2e_i;
  unsigned char **llvm_cbe_tmp56_2e_i;
  unsigned char *llvm_cbe_tmp57_2e_i;
  unsigned int llvm_cbe_tmp59_2e_i;
  unsigned short llvm_cbe_tmp61_2e_i;
  unsigned char *llvm_cbe_tmp71_2e_i;
  unsigned int llvm_cbe_tmp73_2e_i;
  unsigned char *llvm_cbe_tmp90_2e_i;
  unsigned int llvm_cbe_tmp92_2e_i;
  unsigned short llvm_cbe_tmp94_2e_i;
  unsigned char *llvm_cbe_tmp103_2e_i;
  unsigned int llvm_cbe_tmp105_2e_i;

  llvm_cbe_tmpcast = ((struct l_struct_2E_SDL_Rect *)(&llvm_cbe_r1_2e_i));
  llvm_cbe_tmp5 = *((&llvm_cbe_r->field1.field1));
  llvm_cbe_tmp9 = *((&llvm_cbe_r->field0.field1));
  llvm_cbe_tmp10 = llvm_cbe_tmp5 - llvm_cbe_tmp9;
  llvm_cbe_tmp14 = *((&llvm_cbe_r->field1.field0));
  llvm_cbe_tmp18 = *((&llvm_cbe_r->field0.field0));
  llvm_cbe_tmp19 = llvm_cbe_tmp14 - llvm_cbe_tmp18;
  if ((llvm_cbe_fill == ((unsigned char )0))) {
    goto llvm_cbe_bb24_2e_i;
  } else {
    goto llvm_cbe_bb_2e_i;
  }

llvm_cbe_bb_2e_i:
  *(&llvm_cbe_r1_2e_i) = 0ull;
  *(((unsigned short *)(&llvm_cbe_r1_2e_i))) = (((unsigned short )llvm_cbe_tmp18));
  *((&llvm_cbe_tmpcast->field1)) = (((unsigned short )llvm_cbe_tmp9));
  *((&llvm_cbe_tmpcast->field2)) = (((unsigned short )llvm_cbe_tmp19));
  *((&llvm_cbe_tmpcast->field3)) = (((unsigned short )llvm_cbe_tmp10));
  llvm_cbe_tmp21_2e_i = *((&llvm_cbe_this->field1));
  llvm_cbe_tmp23_2e_i = SDL_FillRect((((struct l_struct_2E_SDL_Surface *)llvm_cbe_tmp21_2e_i)), llvm_cbe_tmpcast, llvm_cbe_c);
  return;
llvm_cbe_bb24_2e_i:
  llvm_cbe_tmp2930_2e_i = ((unsigned short )llvm_cbe_tmp18);
  llvm_cbe_tmp3233_2e_i = ((unsigned short )llvm_cbe_tmp9);
  llvm_cbe_tmp3536_2e_i = ((unsigned short )llvm_cbe_tmp19);
  llvm_cbe_tmp3839_2e_i = ((unsigned short )llvm_cbe_tmp10);
  llvm_cbe_tmp41_2e_i = (&llvm_cbe_r_2e_i.field0);
  *llvm_cbe_tmp41_2e_i = llvm_cbe_tmp2930_2e_i;
  llvm_cbe_tmp44_2e_i = (&llvm_cbe_r_2e_i.field1);
  *llvm_cbe_tmp44_2e_i = llvm_cbe_tmp3233_2e_i;
  llvm_cbe_tmp47_2e_i = (&llvm_cbe_r_2e_i.field2);
  *llvm_cbe_tmp47_2e_i = llvm_cbe_tmp3536_2e_i;
  llvm_cbe_tmp50_2e_i = (&llvm_cbe_r_2e_i.field3);
  *llvm_cbe_tmp50_2e_i = ((unsigned short )1);
  llvm_cbe_tmp56_2e_i = (&llvm_cbe_this->field1);
  llvm_cbe_tmp57_2e_i = *llvm_cbe_tmp56_2e_i;
  llvm_cbe_tmp59_2e_i = SDL_FillRect((((struct l_struct_2E_SDL_Surface *)llvm_cbe_tmp57_2e_i)), (&llvm_cbe_r_2e_i), llvm_cbe_c);
  llvm_cbe_tmp61_2e_i = *llvm_cbe_tmp44_2e_i;
  *llvm_cbe_tmp44_2e_i = (((unsigned short )((((unsigned short )(llvm_cbe_tmp61_2e_i + llvm_cbe_tmp3839_2e_i))) + ((unsigned short )-1))));
  llvm_cbe_tmp71_2e_i = *llvm_cbe_tmp56_2e_i;
  llvm_cbe_tmp73_2e_i = SDL_FillRect((((struct l_struct_2E_SDL_Surface *)llvm_cbe_tmp71_2e_i)), (&llvm_cbe_r_2e_i), llvm_cbe_c);
  *llvm_cbe_tmp41_2e_i = llvm_cbe_tmp2930_2e_i;
  *llvm_cbe_tmp44_2e_i = llvm_cbe_tmp3233_2e_i;
  *llvm_cbe_tmp50_2e_i = llvm_cbe_tmp3839_2e_i;
  *llvm_cbe_tmp47_2e_i = ((unsigned short )1);
  llvm_cbe_tmp90_2e_i = *llvm_cbe_tmp56_2e_i;
  llvm_cbe_tmp92_2e_i = SDL_FillRect((((struct l_struct_2E_SDL_Surface *)llvm_cbe_tmp90_2e_i)), (&llvm_cbe_r_2e_i), llvm_cbe_c);
  llvm_cbe_tmp94_2e_i = *llvm_cbe_tmp41_2e_i;
  *llvm_cbe_tmp41_2e_i = (((unsigned short )((((unsigned short )(llvm_cbe_tmp94_2e_i + llvm_cbe_tmp3536_2e_i))) + ((unsigned short )-1))));
  llvm_cbe_tmp103_2e_i = *llvm_cbe_tmp56_2e_i;
  llvm_cbe_tmp105_2e_i = SDL_FillRect((((struct l_struct_2E_SDL_Surface *)llvm_cbe_tmp103_2e_i)), (&llvm_cbe_r_2e_i), llvm_cbe_c);
  return;
}


static void _ZN6Canvas8drawPathERK4Pathib(struct l_struct_2E_Canvas *llvm_cbe_this, struct l_struct_2E_Path *llvm_cbe_path, unsigned int llvm_cbe_color, unsigned char llvm_cbe_thick) {
  unsigned int llvm_cbe_abs39_2e_i_2e_reg2mem;    /* Address-exposed local */
  unsigned int llvm_cbe_storemerge1_2e_i_2e_reg2mem;    /* Address-exposed local */
  unsigned int llvm_cbe_abs39_2e_i132_2e_reg2mem;    /* Address-exposed local */
  unsigned int llvm_cbe_storemerge1_2e_i128_2e_reg2mem;    /* Address-exposed local */
  unsigned int llvm_cbe_abs41_2e_i_2e_reg2mem;    /* Address-exposed local */
  unsigned int llvm_cbe_storemerge1_2e_i332_2e_reg2mem;    /* Address-exposed local */
  unsigned int llvm_cbe_abs41_2e_i496_2e_reg2mem;    /* Address-exposed local */
  unsigned int llvm_cbe_storemerge1_2e_i492_2e_reg2mem;    /* Address-exposed local */
  struct l_struct_2E_AlphaBrush_3C_short_20_unsigned_20_int_2C_1u_3E_ llvm_cbe_brush_2e_i421;    /* Address-exposed local */
  struct l_struct_2E_AlphaBrush_3C_short_20_unsigned_20_int_2C_1u_3E_ llvm_cbe_brush_2e_i275;    /* Address-exposed local */
  struct l_struct_2E_AlphaBrush_3C_short_20_unsigned_20_int_2C_1u_3E_ llvm_cbe_brush_2e_i62;    /* Address-exposed local */
  struct l_struct_2E_AlphaBrush_3C_short_20_unsigned_20_int_2C_1u_3E_ llvm_cbe_brush_2e_i;    /* Address-exposed local */
  unsigned int llvm_cbe_tmp2_2e_i_2e_i;
  unsigned int llvm_cbe_tmp7_2e_i_2e_i;
  unsigned int llvm_cbe_tmp2_2e_i4_2e_i;
  unsigned int llvm_cbe_tmp7_2e_i9_2e_i;
  unsigned int llvm_cbe_tmp5;
  unsigned int llvm_cbe_tmp11;
  unsigned int llvm_cbe_tmp17;
  unsigned int llvm_cbe_tmp23;
  unsigned int llvm_cbe_tmp3_2e_i_2e_i761;
  struct l_struct_2E_Vec2 **llvm_cbe_tmp2_2e_i_2e_i750;
  unsigned int llvm_cbe_i_2e_0;
  unsigned int llvm_cbe_i_2e_0__PHI_TEMPORARY;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp3_2e_i_2e_i751;
  unsigned long long llvm_cbe_tmp45_2e_i_2e_i753;
  unsigned int llvm_cbe_tmp3_2e_i703;
  unsigned int llvm_cbe_tmp12_2e_i710;
  unsigned int llvm_cbe_tmp23_2e_i718;
  unsigned int llvm_cbe_tmp29;
  unsigned char **llvm_cbe_tmp55;
  unsigned char *llvm_cbe_tmp56;
  unsigned int llvm_cbe_tmp58;
  unsigned short llvm_cbe_tmp115116117143;
  unsigned int llvm_cbe_tmp1_2e_i_2e_i301;
  unsigned int *llvm_cbe_tmp3_2e_i_2e_i303;
  unsigned int *llvm_cbe_tmp5_2e_i_2e_i305;
  unsigned int *llvm_cbe_tmp7_2e_i_2e_i307;
  unsigned int *llvm_cbe_tmp9_2e_i_2e_i309;
  unsigned int llvm_cbe_tmp3_2e_i_2e_i_2e_i312;
  unsigned int llvm_cbe_tmp9_2e_i_2e_i_2e_i316;
  unsigned int llvm_cbe_tmp14_2e_i_2e_i_2e_i;
  unsigned int *llvm_cbe_tmp3_2e_i_2e_i449;
  unsigned int *llvm_cbe_tmp5_2e_i_2e_i451;
  unsigned int *llvm_cbe_tmp7_2e_i_2e_i453;
  unsigned int *llvm_cbe_tmp9_2e_i_2e_i455;
  unsigned int *llvm_cbe_tmp2_2e_i_2e_i30;
  unsigned int *llvm_cbe_tmp4_2e_i_2e_i32;
  unsigned int *llvm_cbe_tmp6_2e_i_2e_i34;
  unsigned int *llvm_cbe_tmp8_2e_i_2e_i36;
  unsigned int llvm_cbe_tmp2_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp6_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp9_2e_i_2e_i_2e_i;
  unsigned int *llvm_cbe_tmp2_2e_i_2e_i89;
  unsigned int *llvm_cbe_tmp4_2e_i_2e_i91;
  unsigned int *llvm_cbe_tmp6_2e_i_2e_i93;
  unsigned int *llvm_cbe_tmp8_2e_i_2e_i95;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp3_2e_i_2e_i693;
  unsigned long long llvm_cbe_tmp45_2e_i_2e_i695;
  unsigned int llvm_cbe_tmp3_2e_i645;
  unsigned int llvm_cbe_tmp12_2e_i652;
  unsigned int llvm_cbe_tmp23_2e_i660;
  unsigned long long llvm_cbe_tmp45_2e_i_2e_i637;
  unsigned char *llvm_cbe_tmp74;
  struct l_struct_2E_SDL_Surface *llvm_cbe_tmp7475;
  struct l_struct_2E_SDL_PixelFormat *llvm_cbe_tmp77;
  unsigned char llvm_cbe_tmp79;
  unsigned int llvm_cbe_tmp126;
  unsigned int llvm_cbe_tmp129;
  unsigned short llvm_cbe_tmp135;
  unsigned int llvm_cbe_tmp135136;
  unsigned char *llvm_cbe_tmp142;
  unsigned short *llvm_cbe_tmp10_2e_i295;
  unsigned int llvm_cbe_tmp13_2e_i298765;
  unsigned int llvm_cbe_tmp20_2e_i474;
  unsigned int llvm_cbe_tmp23_2e_i477;
  unsigned int llvm_cbe_storemerge_2e_i482;
  unsigned int llvm_cbe_abs_2e_i486;
  unsigned int llvm_cbe_storemerge1_2e_i492_2e_reload;
  unsigned int llvm_cbe_tmp48_2e_i501;
  unsigned int llvm_cbe_pixStride_2e_i422_2e_0;
  unsigned int llvm_cbe_pixStride_2e_i422_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_abs41_2e_i496_2e_reload778;
  unsigned int llvm_cbe_tmp57_2e_i508;
  unsigned int llvm_cbe_abs41_2e_i496_2e_reload773;
  unsigned int llvm_cbe_tmp62_2e_i513;
  unsigned int llvm_cbe_storemerge2_2e_i519;
  unsigned int llvm_cbe_storemerge3_2e_i531;
  unsigned long long llvm_cbe_tmp9899_2e_i544;
  unsigned long long llvm_cbe_tmp112113_2e_i556;
  unsigned int llvm_cbe_abs41_2e_i496_2e_reload;
  unsigned int llvm_cbe_tmp93_2e_i538;
  unsigned int llvm_cbe_tmp96_2e_i541;
  unsigned short *llvm_cbe_tmp100_2e_i545;
  unsigned int llvm_cbe_tmp109_2e_i552;
  unsigned short *llvm_cbe_tmp114_2e_i557;
  unsigned short *llvm_cbe_pix_2e_i431_2e_0;
  unsigned short *llvm_cbe_pix_2e_i431_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_cycle_2e_i428_2e_0;
  unsigned int llvm_cbe_cycle_2e_i428_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_alpha_2e_i425_2e_0;
  unsigned int llvm_cbe_alpha_2e_i425_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_count1_2e_i420_2e_0;
  unsigned int llvm_cbe_count1_2e_i420_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp117_2e_i560;
  unsigned int llvm_cbe_abs41_2e_i496_2e_reload777;
  unsigned int llvm_cbe_tmp126_2e_i565;
  unsigned int llvm_cbe_abs41_2e_i496_2e_reload776;
  unsigned int llvm_cbe_tmp133_2e_i572;
  unsigned int llvm_cbe_tmp136_2e_i576;
  unsigned int llvm_cbe_storemerge4_2e_i581;
  unsigned int llvm_cbe_storemerge1_2e_i492_2e_reload772;
  unsigned int llvm_cbe_storemerge5_2e_i593;
  unsigned long long llvm_cbe_tmp169170_2e_i605;
  unsigned long long llvm_cbe_tmp183184_2e_i617;
  unsigned int llvm_cbe_tmp164_2e_i599;
  unsigned int llvm_cbe_tmp167_2e_i602;
  unsigned short *llvm_cbe_tmp171_2e_i606;
  unsigned int llvm_cbe_abs41_2e_i496_2e_reload775;
  unsigned int llvm_cbe_abs41_2e_i496_2e_reload774;
  unsigned int llvm_cbe_tmp180_2e_i613;
  unsigned short *llvm_cbe_tmp185_2e_i618;
  unsigned short *llvm_cbe_pix_2e_i431_2e_1;
  unsigned short *llvm_cbe_pix_2e_i431_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_cycle_2e_i428_2e_1;
  unsigned int llvm_cbe_cycle_2e_i428_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_alpha_2e_i425_2e_1;
  unsigned int llvm_cbe_alpha_2e_i425_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_count_2e_i419_2e_0;
  unsigned int llvm_cbe_count_2e_i419_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp188_2e_i621;
  unsigned int llvm_cbe_tmp20_2e_i320;
  unsigned int llvm_cbe_tmp23_2e_i323;
  unsigned int llvm_cbe_storemerge_2e_i326;
  unsigned int llvm_cbe_abs_2e_i329;
  unsigned int llvm_cbe_storemerge1_2e_i332_2e_reload;
  unsigned int llvm_cbe_tmp48_2e_i;
  unsigned int llvm_cbe_pixStride_2e_i276_2e_0;
  unsigned int llvm_cbe_pixStride_2e_i276_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_abs41_2e_i_2e_reload790;
  unsigned int llvm_cbe_tmp57_2e_i338;
  unsigned int llvm_cbe_abs41_2e_i_2e_reload785;
  unsigned int llvm_cbe_tmp62_2e_i343;
  unsigned int llvm_cbe_storemerge2_2e_i346;
  unsigned int llvm_cbe_storemerge3_2e_i351;
  unsigned long long llvm_cbe_tmp9899_2e_i;
  unsigned long long llvm_cbe_tmp112113_2e_i;
  unsigned int llvm_cbe_abs41_2e_i_2e_reload;
  unsigned int llvm_cbe_tmp93_2e_i357;
  unsigned int llvm_cbe_tmp96_2e_i360;
  unsigned short *llvm_cbe_tmp100_2e_i362;
  unsigned int llvm_cbe_tmp109_2e_i367;
  unsigned short *llvm_cbe_tmp114_2e_i;
  unsigned int llvm_cbe_count1_2e_i274_2e_0;
  unsigned int llvm_cbe_count1_2e_i274_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_alpha_2e_i279_2e_0;
  unsigned int llvm_cbe_alpha_2e_i279_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_cycle_2e_i282_2e_0;
  unsigned int llvm_cbe_cycle_2e_i282_2e_0__PHI_TEMPORARY;
  unsigned short *llvm_cbe_pix_2e_i285_2e_0;
  unsigned short *llvm_cbe_pix_2e_i285_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp117_2e_i;
  unsigned int llvm_cbe_abs41_2e_i_2e_reload789;
  unsigned int llvm_cbe_tmp126_2e_i373;
  unsigned int llvm_cbe_abs41_2e_i_2e_reload788;
  unsigned int llvm_cbe_tmp133_2e_i;
  unsigned int llvm_cbe_tmp136_2e_i;
  unsigned int llvm_cbe_storemerge4_2e_i382;
  unsigned int llvm_cbe_storemerge1_2e_i332_2e_reload784;
  unsigned int llvm_cbe_storemerge5_2e_i387;
  unsigned long long llvm_cbe_tmp169170_2e_i;
  unsigned long long llvm_cbe_tmp183184_2e_i;
  unsigned int llvm_cbe_tmp164_2e_i392;
  unsigned int llvm_cbe_tmp167_2e_i395;
  unsigned short *llvm_cbe_tmp171_2e_i397;
  unsigned int llvm_cbe_abs41_2e_i_2e_reload787;
  unsigned int llvm_cbe_abs41_2e_i_2e_reload786;
  unsigned int llvm_cbe_tmp180_2e_i402;
  unsigned short *llvm_cbe_tmp185_2e_i;
  unsigned int llvm_cbe_count_2e_i273_2e_0;
  unsigned int llvm_cbe_count_2e_i273_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_alpha_2e_i279_2e_1;
  unsigned int llvm_cbe_alpha_2e_i279_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_cycle_2e_i282_2e_1;
  unsigned int llvm_cbe_cycle_2e_i282_2e_1__PHI_TEMPORARY;
  unsigned short *llvm_cbe_pix_2e_i285_2e_1;
  unsigned short *llvm_cbe_pix_2e_i285_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp188_2e_i;
  unsigned int llvm_cbe_tmp185;
  unsigned int llvm_cbe_tmp188;
  unsigned short llvm_cbe_tmp194;
  unsigned int llvm_cbe_tmp194195;
  unsigned char *llvm_cbe_tmp201;
  unsigned int *llvm_cbe_tmp10_2e_i25;
  unsigned int llvm_cbe_tmp13_2e_i27769;
  unsigned int llvm_cbe_tmp18_2e_i110;
  unsigned int llvm_cbe_tmp21_2e_i113;
  unsigned int llvm_cbe_storemerge_2e_i118;
  unsigned int llvm_cbe_abs_2e_i122;
  unsigned int llvm_cbe_storemerge1_2e_i128_2e_reload;
  unsigned int llvm_cbe_tmp47_2e_i137;
  unsigned int llvm_cbe_pixStride_2e_i63_2e_0;
  unsigned int llvm_cbe_pixStride_2e_i63_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_abs39_2e_i132_2e_reload802;
  unsigned int llvm_cbe_tmp56_2e_i144;
  unsigned int llvm_cbe_abs39_2e_i132_2e_reload797;
  unsigned int llvm_cbe_tmp61_2e_i149;
  unsigned int llvm_cbe_storemerge2_2e_i155;
  unsigned int llvm_cbe_storemerge3_2e_i167;
  unsigned long long llvm_cbe_tmp9798_2e_i180;
  unsigned long long llvm_cbe_tmp111112_2e_i192;
  unsigned int llvm_cbe_abs39_2e_i132_2e_reload;
  unsigned int llvm_cbe_tmp92_2e_i174;
  unsigned int llvm_cbe_tmp95_2e_i177;
  unsigned int *llvm_cbe_tmp99_2e_i181;
  unsigned int llvm_cbe_tmp108_2e_i188;
  unsigned int *llvm_cbe_tmp113_2e_i193;
  unsigned int llvm_cbe_count1_2e_i61_2e_0;
  unsigned int llvm_cbe_count1_2e_i61_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_alpha_2e_i66_2e_0;
  unsigned int llvm_cbe_alpha_2e_i66_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_cycle_2e_i69_2e_0;
  unsigned int llvm_cbe_cycle_2e_i69_2e_0__PHI_TEMPORARY;
  unsigned int *llvm_cbe_pix_2e_i72_2e_0;
  unsigned int *llvm_cbe_pix_2e_i72_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp116_2e_i196;
  unsigned int llvm_cbe_abs39_2e_i132_2e_reload801;
  unsigned int llvm_cbe_tmp125_2e_i201;
  unsigned int llvm_cbe_abs39_2e_i132_2e_reload800;
  unsigned int llvm_cbe_tmp132_2e_i208;
  unsigned int llvm_cbe_tmp135_2e_i212;
  unsigned int llvm_cbe_storemerge4_2e_i217;
  unsigned int llvm_cbe_storemerge1_2e_i128_2e_reload796;
  unsigned int llvm_cbe_storemerge5_2e_i229;
  unsigned long long llvm_cbe_tmp168169_2e_i241;
  unsigned long long llvm_cbe_tmp182183_2e_i253;
  unsigned int llvm_cbe_tmp163_2e_i235;
  unsigned int llvm_cbe_tmp166_2e_i238;
  unsigned int *llvm_cbe_tmp170_2e_i242;
  unsigned int llvm_cbe_abs39_2e_i132_2e_reload799;
  unsigned int llvm_cbe_abs39_2e_i132_2e_reload798;
  unsigned int llvm_cbe_tmp179_2e_i249;
  unsigned int *llvm_cbe_tmp184_2e_i254;
  unsigned int llvm_cbe_count_2e_i60_2e_0;
  unsigned int llvm_cbe_count_2e_i60_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_alpha_2e_i66_2e_1;
  unsigned int llvm_cbe_alpha_2e_i66_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_cycle_2e_i69_2e_1;
  unsigned int llvm_cbe_cycle_2e_i69_2e_1__PHI_TEMPORARY;
  unsigned int *llvm_cbe_pix_2e_i72_2e_1;
  unsigned int *llvm_cbe_pix_2e_i72_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp187_2e_i257;
  unsigned int llvm_cbe_tmp18_2e_i;
  unsigned int llvm_cbe_tmp21_2e_i40;
  unsigned int llvm_cbe_storemerge_2e_i44;
  unsigned int llvm_cbe_abs_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_i_2e_reload;
  unsigned int llvm_cbe_tmp47_2e_i;
  unsigned int llvm_cbe_pixStride_2e_i_2e_0;
  unsigned int llvm_cbe_pixStride_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_abs39_2e_i_2e_reload814;
  unsigned int llvm_cbe_tmp56_2e_i;
  unsigned int llvm_cbe_abs39_2e_i_2e_reload809;
  unsigned int llvm_cbe_tmp61_2e_i;
  unsigned int llvm_cbe_storemerge2_2e_i;
  unsigned int llvm_cbe_storemerge3_2e_i;
  unsigned long long llvm_cbe_tmp9798_2e_i;
  unsigned long long llvm_cbe_tmp111112_2e_i;
  unsigned int llvm_cbe_abs39_2e_i_2e_reload;
  unsigned int llvm_cbe_tmp92_2e_i;
  unsigned int llvm_cbe_tmp95_2e_i;
  unsigned int *llvm_cbe_tmp99_2e_i;
  unsigned int llvm_cbe_tmp108_2e_i;
  unsigned int *llvm_cbe_tmp113_2e_i;
  unsigned int llvm_cbe_count1_2e_i_2e_0;
  unsigned int llvm_cbe_count1_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_alpha_2e_i_2e_0;
  unsigned int llvm_cbe_alpha_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_cycle_2e_i_2e_0;
  unsigned int llvm_cbe_cycle_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int *llvm_cbe_pix_2e_i_2e_0;
  unsigned int *llvm_cbe_pix_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp116_2e_i;
  unsigned int llvm_cbe_abs39_2e_i_2e_reload813;
  unsigned int llvm_cbe_tmp125_2e_i;
  unsigned int llvm_cbe_abs39_2e_i_2e_reload812;
  unsigned int llvm_cbe_tmp132_2e_i;
  unsigned int llvm_cbe_tmp135_2e_i;
  unsigned int llvm_cbe_storemerge4_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_i_2e_reload808;
  unsigned int llvm_cbe_storemerge5_2e_i;
  unsigned long long llvm_cbe_tmp168169_2e_i;
  unsigned long long llvm_cbe_tmp182183_2e_i;
  unsigned int llvm_cbe_tmp163_2e_i;
  unsigned int llvm_cbe_tmp166_2e_i;
  unsigned int *llvm_cbe_tmp170_2e_i;
  unsigned int llvm_cbe_abs39_2e_i_2e_reload811;
  unsigned int llvm_cbe_abs39_2e_i_2e_reload810;
  unsigned int llvm_cbe_tmp179_2e_i;
  unsigned int *llvm_cbe_tmp184_2e_i;
  unsigned int llvm_cbe_count_2e_i_2e_0;
  unsigned int llvm_cbe_count_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_alpha_2e_i_2e_1;
  unsigned int llvm_cbe_alpha_2e_i_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_cycle_2e_i_2e_1;
  unsigned int llvm_cbe_cycle_2e_i_2e_1__PHI_TEMPORARY;
  unsigned int *llvm_cbe_pix_2e_i_2e_1;
  unsigned int *llvm_cbe_pix_2e_i_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp187_2e_i;
  unsigned int llvm_cbe_i_2e_1;
  unsigned int llvm_cbe_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp45_2e_i_2e_i;
  unsigned int llvm_cbe_tmp3_2e_i4;
  unsigned int llvm_cbe_tmp12_2e_i;
  unsigned int llvm_cbe_tmp23_2e_i;
  unsigned int llvm_cbe_tmp206;
  unsigned int llvm_cbe_i_2e_3_2e_in;
  unsigned int llvm_cbe_i_2e_3_2e_in__PHI_TEMPORARY;
  unsigned int llvm_cbe_i_2e_3;
  unsigned char *llvm_cbe_tmp241;

  llvm_cbe_tmp2_2e_i_2e_i = *((&llvm_cbe_this->field4.field0.field0));
  llvm_cbe_tmp7_2e_i_2e_i = *((&llvm_cbe_this->field4.field0.field1));
  llvm_cbe_tmp2_2e_i4_2e_i = *((&llvm_cbe_this->field4.field1.field0));
  llvm_cbe_tmp7_2e_i9_2e_i = *((&llvm_cbe_this->field4.field1.field1));
  llvm_cbe_tmp5 = llvm_cbe_tmp2_2e_i_2e_i + 1u;
  llvm_cbe_tmp11 = llvm_cbe_tmp7_2e_i_2e_i + 1u;
  llvm_cbe_tmp17 = llvm_cbe_tmp2_2e_i4_2e_i + 4294967295u;
  llvm_cbe_tmp23 = llvm_cbe_tmp7_2e_i9_2e_i + 4294967295u;
  llvm_cbe_tmp3_2e_i_2e_i761 = *((&llvm_cbe_path->field0.field1));
  llvm_cbe_tmp2_2e_i_2e_i750 = (&llvm_cbe_path->field0.field0);
  llvm_cbe_i_2e_0__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb30;

  do {     /* Syntactic loop 'bb30' to make GCC happy */
llvm_cbe_bb30:
  llvm_cbe_i_2e_0 = llvm_cbe_i_2e_0__PHI_TEMPORARY;
  if ((((signed int )llvm_cbe_i_2e_0) < ((signed int )llvm_cbe_tmp3_2e_i_2e_i761))) {
    goto llvm_cbe_bb35;
  } else {
    goto llvm_cbe_bb51;
  }

llvm_cbe_bb47:
  llvm_cbe_tmp29 = llvm_cbe_i_2e_0 + 1u;
  llvm_cbe_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp29;   /* for PHI node */
  goto llvm_cbe_bb30;

llvm_cbe_bb35:
  llvm_cbe_tmp3_2e_i_2e_i751 = *llvm_cbe_tmp2_2e_i_2e_i750;
  llvm_cbe_tmp45_2e_i_2e_i753 = ((signed long long )(signed int )llvm_cbe_i_2e_0);
  llvm_cbe_tmp3_2e_i703 = *((&llvm_cbe_tmp3_2e_i_2e_i751[((signed long long )llvm_cbe_tmp45_2e_i_2e_i753)].field0));
  if ((((signed int )llvm_cbe_tmp3_2e_i703) < ((signed int )llvm_cbe_tmp5))) {
    goto llvm_cbe_bb47;
  } else {
    goto llvm_cbe_bb_2e_i715;
  }

llvm_cbe_bb_2e_i715:
  llvm_cbe_tmp12_2e_i710 = *((&llvm_cbe_tmp3_2e_i_2e_i751[((signed long long )llvm_cbe_tmp45_2e_i_2e_i753)].field0));
  if ((((signed int )llvm_cbe_tmp12_2e_i710) > ((signed int )llvm_cbe_tmp17))) {
    goto llvm_cbe_bb47;
  } else {
    goto llvm_cbe_bb20_2e_i723;
  }

llvm_cbe_bb20_2e_i723:
  llvm_cbe_tmp23_2e_i718 = *((&llvm_cbe_tmp3_2e_i_2e_i751[((signed long long )llvm_cbe_tmp45_2e_i_2e_i753)].field1));
  if (((((((signed int )llvm_cbe_tmp23_2e_i718) < ((signed int )llvm_cbe_tmp11)) | (((signed int )llvm_cbe_tmp23_2e_i718) > ((signed int )llvm_cbe_tmp23)))&1))) {
    goto llvm_cbe_bb47;
  } else {
    goto llvm_cbe_bb51;
  }

  } while (1); /* end of syntactic loop 'bb30' */
llvm_cbe_bb51:
  llvm_cbe_tmp55 = (&llvm_cbe_this->field1);
  llvm_cbe_tmp56 = *llvm_cbe_tmp55;
  llvm_cbe_tmp58 = SDL_LockSurface((((struct l_struct_2E_SDL_Surface *)llvm_cbe_tmp56)));
  llvm_cbe_tmp115116117143 = ((unsigned short )llvm_cbe_color);
  llvm_cbe_tmp1_2e_i_2e_i301 = llvm_cbe_color & 65535u;
  llvm_cbe_tmp3_2e_i_2e_i303 = (&llvm_cbe_brush_2e_i275.field3);
  llvm_cbe_tmp5_2e_i_2e_i305 = (&llvm_cbe_brush_2e_i275.field2);
  llvm_cbe_tmp7_2e_i_2e_i307 = (&llvm_cbe_brush_2e_i275.field1);
  llvm_cbe_tmp9_2e_i_2e_i309 = (&llvm_cbe_brush_2e_i275.field0);
  llvm_cbe_tmp3_2e_i_2e_i_2e_i312 = (((unsigned int )(unsigned short )(((unsigned short )(((unsigned short )(((unsigned short )llvm_cbe_tmp115116117143) >> ((unsigned short )((unsigned short )8))))))))) & 248u;
  llvm_cbe_tmp9_2e_i_2e_i_2e_i316 = (((unsigned int )(unsigned short )(((unsigned short )(((unsigned short )(((unsigned short )llvm_cbe_tmp115116117143) >> ((unsigned short )((unsigned short )3))))))))) & 252u;
  llvm_cbe_tmp14_2e_i_2e_i_2e_i = (llvm_cbe_tmp1_2e_i_2e_i301 << 3u) & 248u;
  llvm_cbe_tmp3_2e_i_2e_i449 = (&llvm_cbe_brush_2e_i421.field3);
  llvm_cbe_tmp5_2e_i_2e_i451 = (&llvm_cbe_brush_2e_i421.field2);
  llvm_cbe_tmp7_2e_i_2e_i453 = (&llvm_cbe_brush_2e_i421.field1);
  llvm_cbe_tmp9_2e_i_2e_i455 = (&llvm_cbe_brush_2e_i421.field0);
  llvm_cbe_tmp2_2e_i_2e_i30 = (&llvm_cbe_brush_2e_i.field3);
  llvm_cbe_tmp4_2e_i_2e_i32 = (&llvm_cbe_brush_2e_i.field2);
  llvm_cbe_tmp6_2e_i_2e_i34 = (&llvm_cbe_brush_2e_i.field1);
  llvm_cbe_tmp8_2e_i_2e_i36 = (&llvm_cbe_brush_2e_i.field0);
  llvm_cbe_tmp2_2e_i_2e_i_2e_i = (((unsigned int )(((unsigned int )llvm_cbe_color) >> ((unsigned int )16u)))) & 255u;
  llvm_cbe_tmp6_2e_i_2e_i_2e_i = (((unsigned int )(((unsigned int )llvm_cbe_color) >> ((unsigned int )8u)))) & 255u;
  llvm_cbe_tmp9_2e_i_2e_i_2e_i = llvm_cbe_color & 255u;
  llvm_cbe_tmp2_2e_i_2e_i89 = (&llvm_cbe_brush_2e_i62.field3);
  llvm_cbe_tmp4_2e_i_2e_i91 = (&llvm_cbe_brush_2e_i62.field2);
  llvm_cbe_tmp6_2e_i_2e_i93 = (&llvm_cbe_brush_2e_i62.field1);
  llvm_cbe_tmp8_2e_i_2e_i95 = (&llvm_cbe_brush_2e_i62.field0);
  llvm_cbe_i_2e_3_2e_in__PHI_TEMPORARY = llvm_cbe_i_2e_0;   /* for PHI node */
  goto llvm_cbe_bb232;

  do {     /* Syntactic loop 'bb232' to make GCC happy */
llvm_cbe_bb232:
  llvm_cbe_i_2e_3_2e_in = llvm_cbe_i_2e_3_2e_in__PHI_TEMPORARY;
  llvm_cbe_i_2e_3 = llvm_cbe_i_2e_3_2e_in + 1u;
  if ((((signed int )llvm_cbe_i_2e_3) < ((signed int )llvm_cbe_tmp3_2e_i_2e_i761))) {
    goto llvm_cbe_bb59;
  } else {
    goto llvm_cbe_bb238;
  }

llvm_cbe_bb67:
  llvm_cbe_tmp45_2e_i_2e_i637 = ((signed long long )(signed int )llvm_cbe_i_2e_3_2e_in);
  llvm_cbe_tmp74 = *llvm_cbe_tmp55;
  llvm_cbe_tmp7475 = ((struct l_struct_2E_SDL_Surface *)llvm_cbe_tmp74);
  llvm_cbe_tmp77 = *((&llvm_cbe_tmp7475->field1));
  llvm_cbe_tmp79 = *((&llvm_cbe_tmp77->field2));
  switch ((((unsigned int )(unsigned char )llvm_cbe_tmp79))) {
  default:
    llvm_cbe_i_2e_3_2e_in__PHI_TEMPORARY = llvm_cbe_i_2e_3;   /* for PHI node */
    goto llvm_cbe_bb232;
;
  case 2u:
    goto llvm_cbe_bb81;
    break;
  case 4u:
    goto llvm_cbe_bb145;
  }
llvm_cbe_bb20_2e_i665:
  llvm_cbe_tmp23_2e_i660 = *((&llvm_cbe_tmp3_2e_i_2e_i693[((signed long long )llvm_cbe_tmp45_2e_i_2e_i695)].field1));
  if (((((((signed int )llvm_cbe_tmp23_2e_i660) < ((signed int )llvm_cbe_tmp11)) | (((signed int )llvm_cbe_tmp23_2e_i660) > ((signed int )llvm_cbe_tmp23)))&1))) {
    llvm_cbe_i_2e_1__PHI_TEMPORARY = llvm_cbe_i_2e_3;   /* for PHI node */
    goto llvm_cbe_bb207;
  } else {
    goto llvm_cbe_bb67;
  }

llvm_cbe_bb_2e_i657:
  llvm_cbe_tmp12_2e_i652 = *((&llvm_cbe_tmp3_2e_i_2e_i693[((signed long long )llvm_cbe_tmp45_2e_i_2e_i695)].field0));
  if ((((signed int )llvm_cbe_tmp12_2e_i652) > ((signed int )llvm_cbe_tmp17))) {
    llvm_cbe_i_2e_1__PHI_TEMPORARY = llvm_cbe_i_2e_3;   /* for PHI node */
    goto llvm_cbe_bb207;
  } else {
    goto llvm_cbe_bb20_2e_i665;
  }

llvm_cbe_bb59:
  llvm_cbe_tmp3_2e_i_2e_i693 = *llvm_cbe_tmp2_2e_i_2e_i750;
  llvm_cbe_tmp45_2e_i_2e_i695 = ((signed long long )(signed int )llvm_cbe_i_2e_3);
  llvm_cbe_tmp3_2e_i645 = *((&llvm_cbe_tmp3_2e_i_2e_i693[((signed long long )llvm_cbe_tmp45_2e_i_2e_i695)].field0));
  if ((((signed int )llvm_cbe_tmp3_2e_i645) < ((signed int )llvm_cbe_tmp5))) {
    llvm_cbe_i_2e_1__PHI_TEMPORARY = llvm_cbe_i_2e_3;   /* for PHI node */
    goto llvm_cbe_bb207;
  } else {
    goto llvm_cbe_bb_2e_i657;
  }

  do {     /* Syntactic loop 'bb115.i562' to make GCC happy */
llvm_cbe_bb115_2e_i562:
  llvm_cbe_pix_2e_i431_2e_0 = llvm_cbe_pix_2e_i431_2e_0__PHI_TEMPORARY;
  llvm_cbe_cycle_2e_i428_2e_0 = llvm_cbe_cycle_2e_i428_2e_0__PHI_TEMPORARY;
  llvm_cbe_alpha_2e_i425_2e_0 = llvm_cbe_alpha_2e_i425_2e_0__PHI_TEMPORARY;
  llvm_cbe_count1_2e_i420_2e_0 = llvm_cbe_count1_2e_i420_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp117_2e_i560 = llvm_cbe_count1_2e_i420_2e_0 + 4294967295u;
  if ((llvm_cbe_tmp117_2e_i560 == 4294967295u)) {
    llvm_cbe_i_2e_3_2e_in__PHI_TEMPORARY = llvm_cbe_i_2e_3;   /* for PHI node */
    goto llvm_cbe_bb232;
  } else {
    goto llvm_cbe_bb86_2e_i549;
  }

llvm_cbe_bb86_2e_i549:
  _ZN10AlphaBrushItLj3EE3inkEPtii((&llvm_cbe_brush_2e_i421), llvm_cbe_pix_2e_i431_2e_0, llvm_cbe_pixStride_2e_i422_2e_0, llvm_cbe_alpha_2e_i425_2e_0);
  llvm_cbe_abs41_2e_i496_2e_reload = *(&llvm_cbe_abs41_2e_i496_2e_reg2mem);
  llvm_cbe_tmp93_2e_i538 = llvm_cbe_cycle_2e_i428_2e_0 + llvm_cbe_abs41_2e_i496_2e_reload;
  llvm_cbe_tmp96_2e_i541 = llvm_cbe_alpha_2e_i425_2e_0 - llvm_cbe_tmp62_2e_i513;
  llvm_cbe_tmp100_2e_i545 = (&llvm_cbe_pix_2e_i431_2e_0[((signed long long )llvm_cbe_tmp9899_2e_i544)]);
  if ((((signed int )llvm_cbe_tmp93_2e_i538) > ((signed int )llvm_cbe_abs_2e_i486))) {
    goto llvm_cbe_bb106_2e_i558;
  } else {
    llvm_cbe_pix_2e_i431_2e_0__PHI_TEMPORARY = llvm_cbe_tmp100_2e_i545;   /* for PHI node */
    llvm_cbe_cycle_2e_i428_2e_0__PHI_TEMPORARY = llvm_cbe_tmp93_2e_i538;   /* for PHI node */
    llvm_cbe_alpha_2e_i425_2e_0__PHI_TEMPORARY = llvm_cbe_tmp96_2e_i541;   /* for PHI node */
    llvm_cbe_count1_2e_i420_2e_0__PHI_TEMPORARY = llvm_cbe_tmp117_2e_i560;   /* for PHI node */
    goto llvm_cbe_bb115_2e_i562;
  }

llvm_cbe_bb106_2e_i558:
  llvm_cbe_tmp109_2e_i552 = llvm_cbe_tmp93_2e_i538 - llvm_cbe_abs_2e_i486;
  llvm_cbe_tmp114_2e_i557 = (&llvm_cbe_pix_2e_i431_2e_0[((signed long long )(llvm_cbe_tmp9899_2e_i544 + llvm_cbe_tmp112113_2e_i556))]);
  llvm_cbe_pix_2e_i431_2e_0__PHI_TEMPORARY = llvm_cbe_tmp114_2e_i557;   /* for PHI node */
  llvm_cbe_cycle_2e_i428_2e_0__PHI_TEMPORARY = llvm_cbe_tmp109_2e_i552;   /* for PHI node */
  llvm_cbe_alpha_2e_i425_2e_0__PHI_TEMPORARY = llvm_cbe_storemerge2_2e_i519;   /* for PHI node */
  llvm_cbe_count1_2e_i420_2e_0__PHI_TEMPORARY = llvm_cbe_tmp117_2e_i560;   /* for PHI node */
  goto llvm_cbe_bb115_2e_i562;

  } while (1); /* end of syntactic loop 'bb115.i562' */
llvm_cbe_bb55_2e_i516:
  llvm_cbe_tmp57_2e_i508 = ((signed int )(((signed int )llvm_cbe_abs_2e_i486) >> ((signed int )1u)));
  llvm_cbe_abs41_2e_i496_2e_reload773 = *(&llvm_cbe_abs41_2e_i496_2e_reg2mem);
  llvm_cbe_tmp62_2e_i513 = ((signed int )(((signed int )(llvm_cbe_abs41_2e_i496_2e_reload773 * 255u)) / ((signed int )(llvm_cbe_abs_2e_i486 + 1u))));
  llvm_cbe_storemerge2_2e_i519 = (((((signed int )(-(llvm_cbe_tmp62_2e_i513))) < ((signed int )0u))) ? (255u) : (0u));
  llvm_cbe_storemerge3_2e_i531 = ((((((signed int )llvm_cbe_storemerge_2e_i482) > ((signed int )0u))) ? (llvm_cbe_tmp12_2e_i652) : (llvm_cbe_tmp129))) - ((((((signed int )llvm_cbe_storemerge_2e_i482) > ((signed int )0u))) ? (llvm_cbe_tmp129) : (llvm_cbe_tmp12_2e_i652)));
  llvm_cbe_tmp9899_2e_i544 = ((signed long long )(signed int )llvm_cbe_storemerge_2e_i482);
  llvm_cbe_tmp112113_2e_i556 = ((signed long long )(signed int )llvm_cbe_pixStride_2e_i422_2e_0);
  llvm_cbe_pix_2e_i431_2e_0__PHI_TEMPORARY = llvm_cbe_tmp10_2e_i295;   /* for PHI node */
  llvm_cbe_cycle_2e_i428_2e_0__PHI_TEMPORARY = llvm_cbe_tmp57_2e_i508;   /* for PHI node */
  llvm_cbe_alpha_2e_i425_2e_0__PHI_TEMPORARY = 127u;   /* for PHI node */
  llvm_cbe_count1_2e_i420_2e_0__PHI_TEMPORARY = llvm_cbe_storemerge3_2e_i531;   /* for PHI node */
  goto llvm_cbe_bb115_2e_i562;

llvm_cbe_bb49_2e_i506:
  llvm_cbe_pixStride_2e_i422_2e_0 = llvm_cbe_pixStride_2e_i422_2e_0__PHI_TEMPORARY;
  llvm_cbe_abs41_2e_i496_2e_reload778 = *(&llvm_cbe_abs41_2e_i496_2e_reg2mem);
  if ((((signed int )llvm_cbe_abs41_2e_i496_2e_reload778) < ((signed int )llvm_cbe_abs_2e_i486))) {
    goto llvm_cbe_bb55_2e_i516;
  } else {
    goto llvm_cbe_bb124_2e_i578;
  }

llvm_cbe_bb37_2e_i499:
  *(&llvm_cbe_storemerge1_2e_i492_2e_reg2mem) = 1u;
  *(&llvm_cbe_abs41_2e_i496_2e_reg2mem) = ((((((signed int )llvm_cbe_tmp23_2e_i477) > ((signed int )4294967295u))) ? (llvm_cbe_tmp23_2e_i477) : ((-(llvm_cbe_tmp23_2e_i477)))));
  llvm_cbe_storemerge1_2e_i492_2e_reload = *(&llvm_cbe_storemerge1_2e_i492_2e_reg2mem);
  if ((((signed int )llvm_cbe_storemerge1_2e_i492_2e_reload) < ((signed int )0u))) {
    goto llvm_cbe_bb46_2e_i502;
  } else {
    llvm_cbe_pixStride_2e_i422_2e_0__PHI_TEMPORARY = llvm_cbe_tmp13_2e_i298765;   /* for PHI node */
    goto llvm_cbe_bb49_2e_i506;
  }

llvm_cbe_bb84:
  *llvm_cbe_tmp3_2e_i_2e_i449 = llvm_cbe_tmp1_2e_i_2e_i301;
  *llvm_cbe_tmp9_2e_i_2e_i455 = llvm_cbe_tmp3_2e_i_2e_i_2e_i312;
  *llvm_cbe_tmp7_2e_i_2e_i453 = llvm_cbe_tmp9_2e_i_2e_i_2e_i316;
  *llvm_cbe_tmp5_2e_i_2e_i451 = llvm_cbe_tmp14_2e_i_2e_i_2e_i;
  llvm_cbe_tmp20_2e_i474 = llvm_cbe_tmp12_2e_i652 - llvm_cbe_tmp129;
  llvm_cbe_tmp23_2e_i477 = llvm_cbe_tmp23_2e_i660 - llvm_cbe_tmp126;
  llvm_cbe_storemerge_2e_i482 = (((((signed int )llvm_cbe_tmp20_2e_i474) < ((signed int )0u))) ? (4294967295u) : (1u));
  llvm_cbe_abs_2e_i486 = (((((signed int )llvm_cbe_tmp20_2e_i474) > ((signed int )4294967295u))) ? (llvm_cbe_tmp20_2e_i474) : ((-(llvm_cbe_tmp20_2e_i474))));
  if ((((signed int )llvm_cbe_tmp23_2e_i477) < ((signed int )0u))) {
    goto llvm_cbe_bb37_2e_i499_2e_thread;
  } else {
    goto llvm_cbe_bb37_2e_i499;
  }

llvm_cbe_bb81:
  llvm_cbe_tmp126 = *((&llvm_cbe_tmp3_2e_i_2e_i693[((signed long long )llvm_cbe_tmp45_2e_i_2e_i637)].field1));
  llvm_cbe_tmp129 = *((&llvm_cbe_tmp3_2e_i_2e_i693[((signed long long )llvm_cbe_tmp45_2e_i_2e_i637)].field0));
  llvm_cbe_tmp135 = *((&llvm_cbe_tmp7475->field4));
  llvm_cbe_tmp135136 = ((unsigned int )(unsigned short )llvm_cbe_tmp135);
  llvm_cbe_tmp142 = *((&llvm_cbe_tmp7475->field5));
  llvm_cbe_tmp10_2e_i295 = (&(((unsigned short *)((&llvm_cbe_tmp142[((signed long long )(((signed long long )(signed int )(llvm_cbe_tmp135136 * llvm_cbe_tmp126))))]))))[((signed long long )(((signed long long )(signed int )llvm_cbe_tmp129)))]);
  llvm_cbe_tmp13_2e_i298765 = ((unsigned int )(((unsigned int )llvm_cbe_tmp135136) >> ((unsigned int )1u)));
  if ((llvm_cbe_thick == ((unsigned char )0))) {
    goto llvm_cbe_bb114;
  } else {
    goto llvm_cbe_bb84;
  }

llvm_cbe_bb46_2e_i502:
  llvm_cbe_tmp48_2e_i501 = -(llvm_cbe_tmp13_2e_i298765);
  llvm_cbe_pixStride_2e_i422_2e_0__PHI_TEMPORARY = llvm_cbe_tmp48_2e_i501;   /* for PHI node */
  goto llvm_cbe_bb49_2e_i506;

llvm_cbe_bb37_2e_i499_2e_thread:
  *(&llvm_cbe_storemerge1_2e_i492_2e_reg2mem) = 4294967295u;
  *(&llvm_cbe_abs41_2e_i496_2e_reg2mem) = ((((((signed int )llvm_cbe_tmp23_2e_i477) > ((signed int )4294967295u))) ? (llvm_cbe_tmp23_2e_i477) : ((-(llvm_cbe_tmp23_2e_i477)))));
  goto llvm_cbe_bb46_2e_i502;

  do {     /* Syntactic loop 'bb186.i623' to make GCC happy */
llvm_cbe_bb186_2e_i623:
  llvm_cbe_pix_2e_i431_2e_1 = llvm_cbe_pix_2e_i431_2e_1__PHI_TEMPORARY;
  llvm_cbe_cycle_2e_i428_2e_1 = llvm_cbe_cycle_2e_i428_2e_1__PHI_TEMPORARY;
  llvm_cbe_alpha_2e_i425_2e_1 = llvm_cbe_alpha_2e_i425_2e_1__PHI_TEMPORARY;
  llvm_cbe_count_2e_i419_2e_0 = llvm_cbe_count_2e_i419_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp188_2e_i621 = llvm_cbe_count_2e_i419_2e_0 + 4294967295u;
  if ((llvm_cbe_tmp188_2e_i621 == 4294967295u)) {
    llvm_cbe_i_2e_3_2e_in__PHI_TEMPORARY = llvm_cbe_i_2e_3;   /* for PHI node */
    goto llvm_cbe_bb232;
  } else {
    goto llvm_cbe_bb159_2e_i610;
  }

llvm_cbe_bb159_2e_i610:
  _ZN10AlphaBrushItLj3EE3inkEPtii((&llvm_cbe_brush_2e_i421), llvm_cbe_pix_2e_i431_2e_1, 1u, llvm_cbe_alpha_2e_i425_2e_1);
  llvm_cbe_tmp164_2e_i599 = llvm_cbe_cycle_2e_i428_2e_1 + llvm_cbe_abs_2e_i486;
  llvm_cbe_tmp167_2e_i602 = llvm_cbe_alpha_2e_i425_2e_1 + llvm_cbe_tmp136_2e_i576;
  llvm_cbe_tmp171_2e_i606 = (&llvm_cbe_pix_2e_i431_2e_1[((signed long long )llvm_cbe_tmp169170_2e_i605)]);
  llvm_cbe_abs41_2e_i496_2e_reload775 = *(&llvm_cbe_abs41_2e_i496_2e_reg2mem);
  if ((((signed int )llvm_cbe_tmp164_2e_i599) > ((signed int )llvm_cbe_abs41_2e_i496_2e_reload775))) {
    goto llvm_cbe_bb177_2e_i619;
  } else {
    llvm_cbe_pix_2e_i431_2e_1__PHI_TEMPORARY = llvm_cbe_tmp171_2e_i606;   /* for PHI node */
    llvm_cbe_cycle_2e_i428_2e_1__PHI_TEMPORARY = llvm_cbe_tmp164_2e_i599;   /* for PHI node */
    llvm_cbe_alpha_2e_i425_2e_1__PHI_TEMPORARY = llvm_cbe_tmp167_2e_i602;   /* for PHI node */
    llvm_cbe_count_2e_i419_2e_0__PHI_TEMPORARY = llvm_cbe_tmp188_2e_i621;   /* for PHI node */
    goto llvm_cbe_bb186_2e_i623;
  }

llvm_cbe_bb177_2e_i619:
  llvm_cbe_abs41_2e_i496_2e_reload774 = *(&llvm_cbe_abs41_2e_i496_2e_reg2mem);
  llvm_cbe_tmp180_2e_i613 = llvm_cbe_tmp164_2e_i599 - llvm_cbe_abs41_2e_i496_2e_reload774;
  llvm_cbe_tmp185_2e_i618 = (&llvm_cbe_pix_2e_i431_2e_1[((signed long long )(llvm_cbe_tmp169170_2e_i605 + llvm_cbe_tmp183184_2e_i617))]);
  llvm_cbe_pix_2e_i431_2e_1__PHI_TEMPORARY = llvm_cbe_tmp185_2e_i618;   /* for PHI node */
  llvm_cbe_cycle_2e_i428_2e_1__PHI_TEMPORARY = llvm_cbe_tmp180_2e_i613;   /* for PHI node */
  llvm_cbe_alpha_2e_i425_2e_1__PHI_TEMPORARY = llvm_cbe_storemerge4_2e_i581;   /* for PHI node */
  llvm_cbe_count_2e_i419_2e_0__PHI_TEMPORARY = llvm_cbe_tmp188_2e_i621;   /* for PHI node */
  goto llvm_cbe_bb186_2e_i623;

  } while (1); /* end of syntactic loop 'bb186.i623' */
llvm_cbe_bb124_2e_i578:
  llvm_cbe_abs41_2e_i496_2e_reload777 = *(&llvm_cbe_abs41_2e_i496_2e_reg2mem);
  llvm_cbe_tmp126_2e_i565 = ((signed int )(((signed int )llvm_cbe_abs41_2e_i496_2e_reload777) >> ((signed int )1u)));
  llvm_cbe_abs41_2e_i496_2e_reload776 = *(&llvm_cbe_abs41_2e_i496_2e_reg2mem);
  llvm_cbe_tmp133_2e_i572 = ((signed int )(((signed int )(llvm_cbe_abs_2e_i486 * 255u)) / ((signed int )(llvm_cbe_abs41_2e_i496_2e_reload776 + 1u))));
  llvm_cbe_tmp136_2e_i576 = ((((((signed int )llvm_cbe_tmp133_2e_i572) > ((signed int )4294967295u))) ? (llvm_cbe_tmp133_2e_i572) : ((-(llvm_cbe_tmp133_2e_i572))))) * (-(llvm_cbe_storemerge_2e_i482));
  llvm_cbe_storemerge4_2e_i581 = (((((signed int )llvm_cbe_tmp136_2e_i576) < ((signed int )0u))) ? (255u) : (0u));
  llvm_cbe_storemerge1_2e_i492_2e_reload772 = *(&llvm_cbe_storemerge1_2e_i492_2e_reg2mem);
  llvm_cbe_storemerge5_2e_i593 = ((((((signed int )llvm_cbe_storemerge1_2e_i492_2e_reload772) > ((signed int )0u))) ? (llvm_cbe_tmp23_2e_i660) : (llvm_cbe_tmp126))) - ((((((signed int )llvm_cbe_storemerge1_2e_i492_2e_reload772) > ((signed int )0u))) ? (llvm_cbe_tmp126) : (llvm_cbe_tmp23_2e_i660)));
  llvm_cbe_tmp169170_2e_i605 = ((signed long long )(signed int )llvm_cbe_pixStride_2e_i422_2e_0);
  llvm_cbe_tmp183184_2e_i617 = ((signed long long )(signed int )llvm_cbe_storemerge_2e_i482);
  llvm_cbe_pix_2e_i431_2e_1__PHI_TEMPORARY = llvm_cbe_tmp10_2e_i295;   /* for PHI node */
  llvm_cbe_cycle_2e_i428_2e_1__PHI_TEMPORARY = llvm_cbe_tmp126_2e_i565;   /* for PHI node */
  llvm_cbe_alpha_2e_i425_2e_1__PHI_TEMPORARY = 127u;   /* for PHI node */
  llvm_cbe_count_2e_i419_2e_0__PHI_TEMPORARY = llvm_cbe_storemerge5_2e_i593;   /* for PHI node */
  goto llvm_cbe_bb186_2e_i623;

  do {     /* Syntactic loop 'bb115.i' to make GCC happy */
llvm_cbe_bb115_2e_i:
  llvm_cbe_count1_2e_i274_2e_0 = llvm_cbe_count1_2e_i274_2e_0__PHI_TEMPORARY;
  llvm_cbe_alpha_2e_i279_2e_0 = llvm_cbe_alpha_2e_i279_2e_0__PHI_TEMPORARY;
  llvm_cbe_cycle_2e_i282_2e_0 = llvm_cbe_cycle_2e_i282_2e_0__PHI_TEMPORARY;
  llvm_cbe_pix_2e_i285_2e_0 = llvm_cbe_pix_2e_i285_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp117_2e_i = llvm_cbe_count1_2e_i274_2e_0 + 4294967295u;
  if ((llvm_cbe_tmp117_2e_i == 4294967295u)) {
    llvm_cbe_i_2e_3_2e_in__PHI_TEMPORARY = llvm_cbe_i_2e_3;   /* for PHI node */
    goto llvm_cbe_bb232;
  } else {
    goto llvm_cbe_bb86_2e_i;
  }

llvm_cbe_bb86_2e_i:
  _ZN10AlphaBrushItLj1EE3inkEPtii((&llvm_cbe_brush_2e_i275), llvm_cbe_pix_2e_i285_2e_0, llvm_cbe_pixStride_2e_i276_2e_0, llvm_cbe_alpha_2e_i279_2e_0);
  llvm_cbe_abs41_2e_i_2e_reload = *(&llvm_cbe_abs41_2e_i_2e_reg2mem);
  llvm_cbe_tmp93_2e_i357 = llvm_cbe_cycle_2e_i282_2e_0 + llvm_cbe_abs41_2e_i_2e_reload;
  llvm_cbe_tmp96_2e_i360 = llvm_cbe_alpha_2e_i279_2e_0 - llvm_cbe_tmp62_2e_i343;
  llvm_cbe_tmp100_2e_i362 = (&llvm_cbe_pix_2e_i285_2e_0[((signed long long )llvm_cbe_tmp9899_2e_i)]);
  if ((((signed int )llvm_cbe_tmp93_2e_i357) > ((signed int )llvm_cbe_abs_2e_i329))) {
    goto llvm_cbe_bb106_2e_i;
  } else {
    llvm_cbe_count1_2e_i274_2e_0__PHI_TEMPORARY = llvm_cbe_tmp117_2e_i;   /* for PHI node */
    llvm_cbe_alpha_2e_i279_2e_0__PHI_TEMPORARY = llvm_cbe_tmp96_2e_i360;   /* for PHI node */
    llvm_cbe_cycle_2e_i282_2e_0__PHI_TEMPORARY = llvm_cbe_tmp93_2e_i357;   /* for PHI node */
    llvm_cbe_pix_2e_i285_2e_0__PHI_TEMPORARY = llvm_cbe_tmp100_2e_i362;   /* for PHI node */
    goto llvm_cbe_bb115_2e_i;
  }

llvm_cbe_bb106_2e_i:
  llvm_cbe_tmp109_2e_i367 = llvm_cbe_tmp93_2e_i357 - llvm_cbe_abs_2e_i329;
  llvm_cbe_tmp114_2e_i = (&llvm_cbe_pix_2e_i285_2e_0[((signed long long )(llvm_cbe_tmp9899_2e_i + llvm_cbe_tmp112113_2e_i))]);
  llvm_cbe_count1_2e_i274_2e_0__PHI_TEMPORARY = llvm_cbe_tmp117_2e_i;   /* for PHI node */
  llvm_cbe_alpha_2e_i279_2e_0__PHI_TEMPORARY = llvm_cbe_storemerge2_2e_i346;   /* for PHI node */
  llvm_cbe_cycle_2e_i282_2e_0__PHI_TEMPORARY = llvm_cbe_tmp109_2e_i367;   /* for PHI node */
  llvm_cbe_pix_2e_i285_2e_0__PHI_TEMPORARY = llvm_cbe_tmp114_2e_i;   /* for PHI node */
  goto llvm_cbe_bb115_2e_i;

  } while (1); /* end of syntactic loop 'bb115.i' */
llvm_cbe_bb55_2e_i:
  llvm_cbe_tmp57_2e_i338 = ((signed int )(((signed int )llvm_cbe_abs_2e_i329) >> ((signed int )1u)));
  llvm_cbe_abs41_2e_i_2e_reload785 = *(&llvm_cbe_abs41_2e_i_2e_reg2mem);
  llvm_cbe_tmp62_2e_i343 = ((signed int )(((signed int )(llvm_cbe_abs41_2e_i_2e_reload785 * 255u)) / ((signed int )(llvm_cbe_abs_2e_i329 + 1u))));
  llvm_cbe_storemerge2_2e_i346 = (((((signed int )(-(llvm_cbe_tmp62_2e_i343))) < ((signed int )0u))) ? (255u) : (0u));
  llvm_cbe_storemerge3_2e_i351 = ((((((signed int )llvm_cbe_storemerge_2e_i326) > ((signed int )0u))) ? (llvm_cbe_tmp12_2e_i652) : (llvm_cbe_tmp129))) - ((((((signed int )llvm_cbe_storemerge_2e_i326) > ((signed int )0u))) ? (llvm_cbe_tmp129) : (llvm_cbe_tmp12_2e_i652)));
  llvm_cbe_tmp9899_2e_i = ((signed long long )(signed int )llvm_cbe_storemerge_2e_i326);
  llvm_cbe_tmp112113_2e_i = ((signed long long )(signed int )llvm_cbe_pixStride_2e_i276_2e_0);
  llvm_cbe_count1_2e_i274_2e_0__PHI_TEMPORARY = llvm_cbe_storemerge3_2e_i351;   /* for PHI node */
  llvm_cbe_alpha_2e_i279_2e_0__PHI_TEMPORARY = 127u;   /* for PHI node */
  llvm_cbe_cycle_2e_i282_2e_0__PHI_TEMPORARY = llvm_cbe_tmp57_2e_i338;   /* for PHI node */
  llvm_cbe_pix_2e_i285_2e_0__PHI_TEMPORARY = llvm_cbe_tmp10_2e_i295;   /* for PHI node */
  goto llvm_cbe_bb115_2e_i;

llvm_cbe_bb49_2e_i:
  llvm_cbe_pixStride_2e_i276_2e_0 = llvm_cbe_pixStride_2e_i276_2e_0__PHI_TEMPORARY;
  llvm_cbe_abs41_2e_i_2e_reload790 = *(&llvm_cbe_abs41_2e_i_2e_reg2mem);
  if ((((signed int )llvm_cbe_abs41_2e_i_2e_reload790) < ((signed int )llvm_cbe_abs_2e_i329))) {
    goto llvm_cbe_bb55_2e_i;
  } else {
    goto llvm_cbe_bb124_2e_i;
  }

llvm_cbe_bb37_2e_i:
  *(&llvm_cbe_storemerge1_2e_i332_2e_reg2mem) = 1u;
  *(&llvm_cbe_abs41_2e_i_2e_reg2mem) = ((((((signed int )llvm_cbe_tmp23_2e_i323) > ((signed int )4294967295u))) ? (llvm_cbe_tmp23_2e_i323) : ((-(llvm_cbe_tmp23_2e_i323)))));
  llvm_cbe_storemerge1_2e_i332_2e_reload = *(&llvm_cbe_storemerge1_2e_i332_2e_reg2mem);
  if ((((signed int )llvm_cbe_storemerge1_2e_i332_2e_reload) < ((signed int )0u))) {
    goto llvm_cbe_bb46_2e_i;
  } else {
    llvm_cbe_pixStride_2e_i276_2e_0__PHI_TEMPORARY = llvm_cbe_tmp13_2e_i298765;   /* for PHI node */
    goto llvm_cbe_bb49_2e_i;
  }

llvm_cbe_bb114:
  *llvm_cbe_tmp3_2e_i_2e_i303 = llvm_cbe_tmp1_2e_i_2e_i301;
  *llvm_cbe_tmp9_2e_i_2e_i309 = llvm_cbe_tmp3_2e_i_2e_i_2e_i312;
  *llvm_cbe_tmp7_2e_i_2e_i307 = llvm_cbe_tmp9_2e_i_2e_i_2e_i316;
  *llvm_cbe_tmp5_2e_i_2e_i305 = llvm_cbe_tmp14_2e_i_2e_i_2e_i;
  llvm_cbe_tmp20_2e_i320 = llvm_cbe_tmp12_2e_i652 - llvm_cbe_tmp129;
  llvm_cbe_tmp23_2e_i323 = llvm_cbe_tmp23_2e_i660 - llvm_cbe_tmp126;
  llvm_cbe_storemerge_2e_i326 = (((((signed int )llvm_cbe_tmp20_2e_i320) < ((signed int )0u))) ? (4294967295u) : (1u));
  llvm_cbe_abs_2e_i329 = (((((signed int )llvm_cbe_tmp20_2e_i320) > ((signed int )4294967295u))) ? (llvm_cbe_tmp20_2e_i320) : ((-(llvm_cbe_tmp20_2e_i320))));
  if ((((signed int )llvm_cbe_tmp23_2e_i323) < ((signed int )0u))) {
    goto llvm_cbe_bb37_2e_i_2e_thread;
  } else {
    goto llvm_cbe_bb37_2e_i;
  }

llvm_cbe_bb46_2e_i:
  llvm_cbe_tmp48_2e_i = -(llvm_cbe_tmp13_2e_i298765);
  llvm_cbe_pixStride_2e_i276_2e_0__PHI_TEMPORARY = llvm_cbe_tmp48_2e_i;   /* for PHI node */
  goto llvm_cbe_bb49_2e_i;

llvm_cbe_bb37_2e_i_2e_thread:
  *(&llvm_cbe_storemerge1_2e_i332_2e_reg2mem) = 4294967295u;
  *(&llvm_cbe_abs41_2e_i_2e_reg2mem) = ((((((signed int )llvm_cbe_tmp23_2e_i323) > ((signed int )4294967295u))) ? (llvm_cbe_tmp23_2e_i323) : ((-(llvm_cbe_tmp23_2e_i323)))));
  goto llvm_cbe_bb46_2e_i;

  do {     /* Syntactic loop 'bb186.i' to make GCC happy */
llvm_cbe_bb186_2e_i:
  llvm_cbe_count_2e_i273_2e_0 = llvm_cbe_count_2e_i273_2e_0__PHI_TEMPORARY;
  llvm_cbe_alpha_2e_i279_2e_1 = llvm_cbe_alpha_2e_i279_2e_1__PHI_TEMPORARY;
  llvm_cbe_cycle_2e_i282_2e_1 = llvm_cbe_cycle_2e_i282_2e_1__PHI_TEMPORARY;
  llvm_cbe_pix_2e_i285_2e_1 = llvm_cbe_pix_2e_i285_2e_1__PHI_TEMPORARY;
  llvm_cbe_tmp188_2e_i = llvm_cbe_count_2e_i273_2e_0 + 4294967295u;
  if ((llvm_cbe_tmp188_2e_i == 4294967295u)) {
    llvm_cbe_i_2e_3_2e_in__PHI_TEMPORARY = llvm_cbe_i_2e_3;   /* for PHI node */
    goto llvm_cbe_bb232;
  } else {
    goto llvm_cbe_bb159_2e_i;
  }

llvm_cbe_bb159_2e_i:
  _ZN10AlphaBrushItLj1EE3inkEPtii((&llvm_cbe_brush_2e_i275), llvm_cbe_pix_2e_i285_2e_1, 1u, llvm_cbe_alpha_2e_i279_2e_1);
  llvm_cbe_tmp164_2e_i392 = llvm_cbe_cycle_2e_i282_2e_1 + llvm_cbe_abs_2e_i329;
  llvm_cbe_tmp167_2e_i395 = llvm_cbe_alpha_2e_i279_2e_1 + llvm_cbe_tmp136_2e_i;
  llvm_cbe_tmp171_2e_i397 = (&llvm_cbe_pix_2e_i285_2e_1[((signed long long )llvm_cbe_tmp169170_2e_i)]);
  llvm_cbe_abs41_2e_i_2e_reload787 = *(&llvm_cbe_abs41_2e_i_2e_reg2mem);
  if ((((signed int )llvm_cbe_tmp164_2e_i392) > ((signed int )llvm_cbe_abs41_2e_i_2e_reload787))) {
    goto llvm_cbe_bb177_2e_i;
  } else {
    llvm_cbe_count_2e_i273_2e_0__PHI_TEMPORARY = llvm_cbe_tmp188_2e_i;   /* for PHI node */
    llvm_cbe_alpha_2e_i279_2e_1__PHI_TEMPORARY = llvm_cbe_tmp167_2e_i395;   /* for PHI node */
    llvm_cbe_cycle_2e_i282_2e_1__PHI_TEMPORARY = llvm_cbe_tmp164_2e_i392;   /* for PHI node */
    llvm_cbe_pix_2e_i285_2e_1__PHI_TEMPORARY = llvm_cbe_tmp171_2e_i397;   /* for PHI node */
    goto llvm_cbe_bb186_2e_i;
  }

llvm_cbe_bb177_2e_i:
  llvm_cbe_abs41_2e_i_2e_reload786 = *(&llvm_cbe_abs41_2e_i_2e_reg2mem);
  llvm_cbe_tmp180_2e_i402 = llvm_cbe_tmp164_2e_i392 - llvm_cbe_abs41_2e_i_2e_reload786;
  llvm_cbe_tmp185_2e_i = (&llvm_cbe_pix_2e_i285_2e_1[((signed long long )(llvm_cbe_tmp169170_2e_i + llvm_cbe_tmp183184_2e_i))]);
  llvm_cbe_count_2e_i273_2e_0__PHI_TEMPORARY = llvm_cbe_tmp188_2e_i;   /* for PHI node */
  llvm_cbe_alpha_2e_i279_2e_1__PHI_TEMPORARY = llvm_cbe_storemerge4_2e_i382;   /* for PHI node */
  llvm_cbe_cycle_2e_i282_2e_1__PHI_TEMPORARY = llvm_cbe_tmp180_2e_i402;   /* for PHI node */
  llvm_cbe_pix_2e_i285_2e_1__PHI_TEMPORARY = llvm_cbe_tmp185_2e_i;   /* for PHI node */
  goto llvm_cbe_bb186_2e_i;

  } while (1); /* end of syntactic loop 'bb186.i' */
llvm_cbe_bb124_2e_i:
  llvm_cbe_abs41_2e_i_2e_reload789 = *(&llvm_cbe_abs41_2e_i_2e_reg2mem);
  llvm_cbe_tmp126_2e_i373 = ((signed int )(((signed int )llvm_cbe_abs41_2e_i_2e_reload789) >> ((signed int )1u)));
  llvm_cbe_abs41_2e_i_2e_reload788 = *(&llvm_cbe_abs41_2e_i_2e_reg2mem);
  llvm_cbe_tmp133_2e_i = ((signed int )(((signed int )(llvm_cbe_abs_2e_i329 * 255u)) / ((signed int )(llvm_cbe_abs41_2e_i_2e_reload788 + 1u))));
  llvm_cbe_tmp136_2e_i = ((((((signed int )llvm_cbe_tmp133_2e_i) > ((signed int )4294967295u))) ? (llvm_cbe_tmp133_2e_i) : ((-(llvm_cbe_tmp133_2e_i))))) * (-(llvm_cbe_storemerge_2e_i326));
  llvm_cbe_storemerge4_2e_i382 = (((((signed int )llvm_cbe_tmp136_2e_i) < ((signed int )0u))) ? (255u) : (0u));
  llvm_cbe_storemerge1_2e_i332_2e_reload784 = *(&llvm_cbe_storemerge1_2e_i332_2e_reg2mem);
  llvm_cbe_storemerge5_2e_i387 = ((((((signed int )llvm_cbe_storemerge1_2e_i332_2e_reload784) > ((signed int )0u))) ? (llvm_cbe_tmp23_2e_i660) : (llvm_cbe_tmp126))) - ((((((signed int )llvm_cbe_storemerge1_2e_i332_2e_reload784) > ((signed int )0u))) ? (llvm_cbe_tmp126) : (llvm_cbe_tmp23_2e_i660)));
  llvm_cbe_tmp169170_2e_i = ((signed long long )(signed int )llvm_cbe_pixStride_2e_i276_2e_0);
  llvm_cbe_tmp183184_2e_i = ((signed long long )(signed int )llvm_cbe_storemerge_2e_i326);
  llvm_cbe_count_2e_i273_2e_0__PHI_TEMPORARY = llvm_cbe_storemerge5_2e_i387;   /* for PHI node */
  llvm_cbe_alpha_2e_i279_2e_1__PHI_TEMPORARY = 127u;   /* for PHI node */
  llvm_cbe_cycle_2e_i282_2e_1__PHI_TEMPORARY = llvm_cbe_tmp126_2e_i373;   /* for PHI node */
  llvm_cbe_pix_2e_i285_2e_1__PHI_TEMPORARY = llvm_cbe_tmp10_2e_i295;   /* for PHI node */
  goto llvm_cbe_bb186_2e_i;

  do {     /* Syntactic loop 'bb114.i198' to make GCC happy */
llvm_cbe_bb114_2e_i198:
  llvm_cbe_count1_2e_i61_2e_0 = llvm_cbe_count1_2e_i61_2e_0__PHI_TEMPORARY;
  llvm_cbe_alpha_2e_i66_2e_0 = llvm_cbe_alpha_2e_i66_2e_0__PHI_TEMPORARY;
  llvm_cbe_cycle_2e_i69_2e_0 = llvm_cbe_cycle_2e_i69_2e_0__PHI_TEMPORARY;
  llvm_cbe_pix_2e_i72_2e_0 = llvm_cbe_pix_2e_i72_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp116_2e_i196 = llvm_cbe_count1_2e_i61_2e_0 + 4294967295u;
  if ((llvm_cbe_tmp116_2e_i196 == 4294967295u)) {
    llvm_cbe_i_2e_3_2e_in__PHI_TEMPORARY = llvm_cbe_i_2e_3;   /* for PHI node */
    goto llvm_cbe_bb232;
  } else {
    goto llvm_cbe_bb85_2e_i185;
  }

llvm_cbe_bb85_2e_i185:
  _ZN10AlphaBrushIjLj3EE3inkEPjii((&llvm_cbe_brush_2e_i62), llvm_cbe_pix_2e_i72_2e_0, llvm_cbe_pixStride_2e_i63_2e_0, llvm_cbe_alpha_2e_i66_2e_0);
  llvm_cbe_abs39_2e_i132_2e_reload = *(&llvm_cbe_abs39_2e_i132_2e_reg2mem);
  llvm_cbe_tmp92_2e_i174 = llvm_cbe_cycle_2e_i69_2e_0 + llvm_cbe_abs39_2e_i132_2e_reload;
  llvm_cbe_tmp95_2e_i177 = llvm_cbe_alpha_2e_i66_2e_0 - llvm_cbe_tmp61_2e_i149;
  llvm_cbe_tmp99_2e_i181 = (&llvm_cbe_pix_2e_i72_2e_0[((signed long long )llvm_cbe_tmp9798_2e_i180)]);
  if ((((signed int )llvm_cbe_tmp92_2e_i174) > ((signed int )llvm_cbe_abs_2e_i122))) {
    goto llvm_cbe_bb105_2e_i194;
  } else {
    llvm_cbe_count1_2e_i61_2e_0__PHI_TEMPORARY = llvm_cbe_tmp116_2e_i196;   /* for PHI node */
    llvm_cbe_alpha_2e_i66_2e_0__PHI_TEMPORARY = llvm_cbe_tmp95_2e_i177;   /* for PHI node */
    llvm_cbe_cycle_2e_i69_2e_0__PHI_TEMPORARY = llvm_cbe_tmp92_2e_i174;   /* for PHI node */
    llvm_cbe_pix_2e_i72_2e_0__PHI_TEMPORARY = llvm_cbe_tmp99_2e_i181;   /* for PHI node */
    goto llvm_cbe_bb114_2e_i198;
  }

llvm_cbe_bb105_2e_i194:
  llvm_cbe_tmp108_2e_i188 = llvm_cbe_tmp92_2e_i174 - llvm_cbe_abs_2e_i122;
  llvm_cbe_tmp113_2e_i193 = (&llvm_cbe_pix_2e_i72_2e_0[((signed long long )(llvm_cbe_tmp9798_2e_i180 + llvm_cbe_tmp111112_2e_i192))]);
  llvm_cbe_count1_2e_i61_2e_0__PHI_TEMPORARY = llvm_cbe_tmp116_2e_i196;   /* for PHI node */
  llvm_cbe_alpha_2e_i66_2e_0__PHI_TEMPORARY = llvm_cbe_storemerge2_2e_i155;   /* for PHI node */
  llvm_cbe_cycle_2e_i69_2e_0__PHI_TEMPORARY = llvm_cbe_tmp108_2e_i188;   /* for PHI node */
  llvm_cbe_pix_2e_i72_2e_0__PHI_TEMPORARY = llvm_cbe_tmp113_2e_i193;   /* for PHI node */
  goto llvm_cbe_bb114_2e_i198;

  } while (1); /* end of syntactic loop 'bb114.i198' */
llvm_cbe_bb54_2e_i152:
  llvm_cbe_tmp56_2e_i144 = ((signed int )(((signed int )llvm_cbe_abs_2e_i122) >> ((signed int )1u)));
  llvm_cbe_abs39_2e_i132_2e_reload797 = *(&llvm_cbe_abs39_2e_i132_2e_reg2mem);
  llvm_cbe_tmp61_2e_i149 = ((signed int )(((signed int )(llvm_cbe_abs39_2e_i132_2e_reload797 * 255u)) / ((signed int )(llvm_cbe_abs_2e_i122 + 1u))));
  llvm_cbe_storemerge2_2e_i155 = (((((signed int )(-(llvm_cbe_tmp61_2e_i149))) < ((signed int )0u))) ? (255u) : (0u));
  llvm_cbe_storemerge3_2e_i167 = ((((((signed int )llvm_cbe_storemerge_2e_i118) > ((signed int )0u))) ? (llvm_cbe_tmp12_2e_i652) : (llvm_cbe_tmp188))) - ((((((signed int )llvm_cbe_storemerge_2e_i118) > ((signed int )0u))) ? (llvm_cbe_tmp188) : (llvm_cbe_tmp12_2e_i652)));
  llvm_cbe_tmp9798_2e_i180 = ((signed long long )(signed int )llvm_cbe_storemerge_2e_i118);
  llvm_cbe_tmp111112_2e_i192 = ((signed long long )(signed int )llvm_cbe_pixStride_2e_i63_2e_0);
  llvm_cbe_count1_2e_i61_2e_0__PHI_TEMPORARY = llvm_cbe_storemerge3_2e_i167;   /* for PHI node */
  llvm_cbe_alpha_2e_i66_2e_0__PHI_TEMPORARY = 127u;   /* for PHI node */
  llvm_cbe_cycle_2e_i69_2e_0__PHI_TEMPORARY = llvm_cbe_tmp56_2e_i144;   /* for PHI node */
  llvm_cbe_pix_2e_i72_2e_0__PHI_TEMPORARY = llvm_cbe_tmp10_2e_i25;   /* for PHI node */
  goto llvm_cbe_bb114_2e_i198;

llvm_cbe_bb48_2e_i142:
  llvm_cbe_pixStride_2e_i63_2e_0 = llvm_cbe_pixStride_2e_i63_2e_0__PHI_TEMPORARY;
  llvm_cbe_abs39_2e_i132_2e_reload802 = *(&llvm_cbe_abs39_2e_i132_2e_reg2mem);
  if ((((signed int )llvm_cbe_abs39_2e_i132_2e_reload802) < ((signed int )llvm_cbe_abs_2e_i122))) {
    goto llvm_cbe_bb54_2e_i152;
  } else {
    goto llvm_cbe_bb123_2e_i214;
  }

llvm_cbe_bb35_2e_i135:
  *(&llvm_cbe_storemerge1_2e_i128_2e_reg2mem) = 1u;
  *(&llvm_cbe_abs39_2e_i132_2e_reg2mem) = ((((((signed int )llvm_cbe_tmp21_2e_i113) > ((signed int )4294967295u))) ? (llvm_cbe_tmp21_2e_i113) : ((-(llvm_cbe_tmp21_2e_i113)))));
  llvm_cbe_storemerge1_2e_i128_2e_reload = *(&llvm_cbe_storemerge1_2e_i128_2e_reg2mem);
  if ((((signed int )llvm_cbe_storemerge1_2e_i128_2e_reload) < ((signed int )0u))) {
    goto llvm_cbe_bb44_2e_i138;
  } else {
    llvm_cbe_pixStride_2e_i63_2e_0__PHI_TEMPORARY = llvm_cbe_tmp13_2e_i27769;   /* for PHI node */
    goto llvm_cbe_bb48_2e_i142;
  }

llvm_cbe_bb148:
  *llvm_cbe_tmp2_2e_i_2e_i89 = llvm_cbe_color;
  *llvm_cbe_tmp8_2e_i_2e_i95 = llvm_cbe_tmp2_2e_i_2e_i_2e_i;
  *llvm_cbe_tmp6_2e_i_2e_i93 = llvm_cbe_tmp6_2e_i_2e_i_2e_i;
  *llvm_cbe_tmp4_2e_i_2e_i91 = llvm_cbe_tmp9_2e_i_2e_i_2e_i;
  llvm_cbe_tmp18_2e_i110 = llvm_cbe_tmp12_2e_i652 - llvm_cbe_tmp188;
  llvm_cbe_tmp21_2e_i113 = llvm_cbe_tmp23_2e_i660 - llvm_cbe_tmp185;
  llvm_cbe_storemerge_2e_i118 = (((((signed int )llvm_cbe_tmp18_2e_i110) < ((signed int )0u))) ? (4294967295u) : (1u));
  llvm_cbe_abs_2e_i122 = (((((signed int )llvm_cbe_tmp18_2e_i110) > ((signed int )4294967295u))) ? (llvm_cbe_tmp18_2e_i110) : ((-(llvm_cbe_tmp18_2e_i110))));
  if ((((signed int )llvm_cbe_tmp21_2e_i113) < ((signed int )0u))) {
    goto llvm_cbe_bb35_2e_i135_2e_thread;
  } else {
    goto llvm_cbe_bb35_2e_i135;
  }

llvm_cbe_bb145:
  llvm_cbe_tmp185 = *((&llvm_cbe_tmp3_2e_i_2e_i693[((signed long long )llvm_cbe_tmp45_2e_i_2e_i637)].field1));
  llvm_cbe_tmp188 = *((&llvm_cbe_tmp3_2e_i_2e_i693[((signed long long )llvm_cbe_tmp45_2e_i_2e_i637)].field0));
  llvm_cbe_tmp194 = *((&llvm_cbe_tmp7475->field4));
  llvm_cbe_tmp194195 = ((unsigned int )(unsigned short )llvm_cbe_tmp194);
  llvm_cbe_tmp201 = *((&llvm_cbe_tmp7475->field5));
  llvm_cbe_tmp10_2e_i25 = (&(((unsigned int *)((&llvm_cbe_tmp201[((signed long long )(((signed long long )(signed int )(llvm_cbe_tmp194195 * llvm_cbe_tmp185))))]))))[((signed long long )(((signed long long )(signed int )llvm_cbe_tmp188)))]);
  llvm_cbe_tmp13_2e_i27769 = ((unsigned int )(((unsigned int )llvm_cbe_tmp194195) >> ((unsigned int )2u)));
  if ((llvm_cbe_thick == ((unsigned char )0))) {
    goto llvm_cbe_bb175;
  } else {
    goto llvm_cbe_bb148;
  }

llvm_cbe_bb44_2e_i138:
  llvm_cbe_tmp47_2e_i137 = -(llvm_cbe_tmp13_2e_i27769);
  llvm_cbe_pixStride_2e_i63_2e_0__PHI_TEMPORARY = llvm_cbe_tmp47_2e_i137;   /* for PHI node */
  goto llvm_cbe_bb48_2e_i142;

llvm_cbe_bb35_2e_i135_2e_thread:
  *(&llvm_cbe_storemerge1_2e_i128_2e_reg2mem) = 4294967295u;
  *(&llvm_cbe_abs39_2e_i132_2e_reg2mem) = ((((((signed int )llvm_cbe_tmp21_2e_i113) > ((signed int )4294967295u))) ? (llvm_cbe_tmp21_2e_i113) : ((-(llvm_cbe_tmp21_2e_i113)))));
  goto llvm_cbe_bb44_2e_i138;

  do {     /* Syntactic loop 'bb185.i259' to make GCC happy */
llvm_cbe_bb185_2e_i259:
  llvm_cbe_count_2e_i60_2e_0 = llvm_cbe_count_2e_i60_2e_0__PHI_TEMPORARY;
  llvm_cbe_alpha_2e_i66_2e_1 = llvm_cbe_alpha_2e_i66_2e_1__PHI_TEMPORARY;
  llvm_cbe_cycle_2e_i69_2e_1 = llvm_cbe_cycle_2e_i69_2e_1__PHI_TEMPORARY;
  llvm_cbe_pix_2e_i72_2e_1 = llvm_cbe_pix_2e_i72_2e_1__PHI_TEMPORARY;
  llvm_cbe_tmp187_2e_i257 = llvm_cbe_count_2e_i60_2e_0 + 4294967295u;
  if ((llvm_cbe_tmp187_2e_i257 == 4294967295u)) {
    llvm_cbe_i_2e_3_2e_in__PHI_TEMPORARY = llvm_cbe_i_2e_3;   /* for PHI node */
    goto llvm_cbe_bb232;
  } else {
    goto llvm_cbe_bb158_2e_i246;
  }

llvm_cbe_bb158_2e_i246:
  _ZN10AlphaBrushIjLj3EE3inkEPjii((&llvm_cbe_brush_2e_i62), llvm_cbe_pix_2e_i72_2e_1, 1u, llvm_cbe_alpha_2e_i66_2e_1);
  llvm_cbe_tmp163_2e_i235 = llvm_cbe_cycle_2e_i69_2e_1 + llvm_cbe_abs_2e_i122;
  llvm_cbe_tmp166_2e_i238 = llvm_cbe_alpha_2e_i66_2e_1 + llvm_cbe_tmp135_2e_i212;
  llvm_cbe_tmp170_2e_i242 = (&llvm_cbe_pix_2e_i72_2e_1[((signed long long )llvm_cbe_tmp168169_2e_i241)]);
  llvm_cbe_abs39_2e_i132_2e_reload799 = *(&llvm_cbe_abs39_2e_i132_2e_reg2mem);
  if ((((signed int )llvm_cbe_tmp163_2e_i235) > ((signed int )llvm_cbe_abs39_2e_i132_2e_reload799))) {
    goto llvm_cbe_bb176_2e_i255;
  } else {
    llvm_cbe_count_2e_i60_2e_0__PHI_TEMPORARY = llvm_cbe_tmp187_2e_i257;   /* for PHI node */
    llvm_cbe_alpha_2e_i66_2e_1__PHI_TEMPORARY = llvm_cbe_tmp166_2e_i238;   /* for PHI node */
    llvm_cbe_cycle_2e_i69_2e_1__PHI_TEMPORARY = llvm_cbe_tmp163_2e_i235;   /* for PHI node */
    llvm_cbe_pix_2e_i72_2e_1__PHI_TEMPORARY = llvm_cbe_tmp170_2e_i242;   /* for PHI node */
    goto llvm_cbe_bb185_2e_i259;
  }

llvm_cbe_bb176_2e_i255:
  llvm_cbe_abs39_2e_i132_2e_reload798 = *(&llvm_cbe_abs39_2e_i132_2e_reg2mem);
  llvm_cbe_tmp179_2e_i249 = llvm_cbe_tmp163_2e_i235 - llvm_cbe_abs39_2e_i132_2e_reload798;
  llvm_cbe_tmp184_2e_i254 = (&llvm_cbe_pix_2e_i72_2e_1[((signed long long )(llvm_cbe_tmp168169_2e_i241 + llvm_cbe_tmp182183_2e_i253))]);
  llvm_cbe_count_2e_i60_2e_0__PHI_TEMPORARY = llvm_cbe_tmp187_2e_i257;   /* for PHI node */
  llvm_cbe_alpha_2e_i66_2e_1__PHI_TEMPORARY = llvm_cbe_storemerge4_2e_i217;   /* for PHI node */
  llvm_cbe_cycle_2e_i69_2e_1__PHI_TEMPORARY = llvm_cbe_tmp179_2e_i249;   /* for PHI node */
  llvm_cbe_pix_2e_i72_2e_1__PHI_TEMPORARY = llvm_cbe_tmp184_2e_i254;   /* for PHI node */
  goto llvm_cbe_bb185_2e_i259;

  } while (1); /* end of syntactic loop 'bb185.i259' */
llvm_cbe_bb123_2e_i214:
  llvm_cbe_abs39_2e_i132_2e_reload801 = *(&llvm_cbe_abs39_2e_i132_2e_reg2mem);
  llvm_cbe_tmp125_2e_i201 = ((signed int )(((signed int )llvm_cbe_abs39_2e_i132_2e_reload801) >> ((signed int )1u)));
  llvm_cbe_abs39_2e_i132_2e_reload800 = *(&llvm_cbe_abs39_2e_i132_2e_reg2mem);
  llvm_cbe_tmp132_2e_i208 = ((signed int )(((signed int )(llvm_cbe_abs_2e_i122 * 255u)) / ((signed int )(llvm_cbe_abs39_2e_i132_2e_reload800 + 1u))));
  llvm_cbe_tmp135_2e_i212 = ((((((signed int )llvm_cbe_tmp132_2e_i208) > ((signed int )4294967295u))) ? (llvm_cbe_tmp132_2e_i208) : ((-(llvm_cbe_tmp132_2e_i208))))) * (-(llvm_cbe_storemerge_2e_i118));
  llvm_cbe_storemerge4_2e_i217 = (((((signed int )llvm_cbe_tmp135_2e_i212) < ((signed int )0u))) ? (255u) : (0u));
  llvm_cbe_storemerge1_2e_i128_2e_reload796 = *(&llvm_cbe_storemerge1_2e_i128_2e_reg2mem);
  llvm_cbe_storemerge5_2e_i229 = ((((((signed int )llvm_cbe_storemerge1_2e_i128_2e_reload796) > ((signed int )0u))) ? (llvm_cbe_tmp23_2e_i660) : (llvm_cbe_tmp185))) - ((((((signed int )llvm_cbe_storemerge1_2e_i128_2e_reload796) > ((signed int )0u))) ? (llvm_cbe_tmp185) : (llvm_cbe_tmp23_2e_i660)));
  llvm_cbe_tmp168169_2e_i241 = ((signed long long )(signed int )llvm_cbe_pixStride_2e_i63_2e_0);
  llvm_cbe_tmp182183_2e_i253 = ((signed long long )(signed int )llvm_cbe_storemerge_2e_i118);
  llvm_cbe_count_2e_i60_2e_0__PHI_TEMPORARY = llvm_cbe_storemerge5_2e_i229;   /* for PHI node */
  llvm_cbe_alpha_2e_i66_2e_1__PHI_TEMPORARY = 127u;   /* for PHI node */
  llvm_cbe_cycle_2e_i69_2e_1__PHI_TEMPORARY = llvm_cbe_tmp125_2e_i201;   /* for PHI node */
  llvm_cbe_pix_2e_i72_2e_1__PHI_TEMPORARY = llvm_cbe_tmp10_2e_i25;   /* for PHI node */
  goto llvm_cbe_bb185_2e_i259;

  do {     /* Syntactic loop 'bb114.i' to make GCC happy */
llvm_cbe_bb114_2e_i:
  llvm_cbe_count1_2e_i_2e_0 = llvm_cbe_count1_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_alpha_2e_i_2e_0 = llvm_cbe_alpha_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_cycle_2e_i_2e_0 = llvm_cbe_cycle_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_pix_2e_i_2e_0 = llvm_cbe_pix_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp116_2e_i = llvm_cbe_count1_2e_i_2e_0 + 4294967295u;
  if ((llvm_cbe_tmp116_2e_i == 4294967295u)) {
    llvm_cbe_i_2e_3_2e_in__PHI_TEMPORARY = llvm_cbe_i_2e_3;   /* for PHI node */
    goto llvm_cbe_bb232;
  } else {
    goto llvm_cbe_bb85_2e_i;
  }

llvm_cbe_bb85_2e_i:
  _ZN10AlphaBrushIjLj1EE3inkEPjii((&llvm_cbe_brush_2e_i), llvm_cbe_pix_2e_i_2e_0, llvm_cbe_pixStride_2e_i_2e_0, llvm_cbe_alpha_2e_i_2e_0);
  llvm_cbe_abs39_2e_i_2e_reload = *(&llvm_cbe_abs39_2e_i_2e_reg2mem);
  llvm_cbe_tmp92_2e_i = llvm_cbe_cycle_2e_i_2e_0 + llvm_cbe_abs39_2e_i_2e_reload;
  llvm_cbe_tmp95_2e_i = llvm_cbe_alpha_2e_i_2e_0 - llvm_cbe_tmp61_2e_i;
  llvm_cbe_tmp99_2e_i = (&llvm_cbe_pix_2e_i_2e_0[((signed long long )llvm_cbe_tmp9798_2e_i)]);
  if ((((signed int )llvm_cbe_tmp92_2e_i) > ((signed int )llvm_cbe_abs_2e_i))) {
    goto llvm_cbe_bb105_2e_i;
  } else {
    llvm_cbe_count1_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp116_2e_i;   /* for PHI node */
    llvm_cbe_alpha_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp95_2e_i;   /* for PHI node */
    llvm_cbe_cycle_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp92_2e_i;   /* for PHI node */
    llvm_cbe_pix_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp99_2e_i;   /* for PHI node */
    goto llvm_cbe_bb114_2e_i;
  }

llvm_cbe_bb105_2e_i:
  llvm_cbe_tmp108_2e_i = llvm_cbe_tmp92_2e_i - llvm_cbe_abs_2e_i;
  llvm_cbe_tmp113_2e_i = (&llvm_cbe_pix_2e_i_2e_0[((signed long long )(llvm_cbe_tmp9798_2e_i + llvm_cbe_tmp111112_2e_i))]);
  llvm_cbe_count1_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp116_2e_i;   /* for PHI node */
  llvm_cbe_alpha_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_storemerge2_2e_i;   /* for PHI node */
  llvm_cbe_cycle_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp108_2e_i;   /* for PHI node */
  llvm_cbe_pix_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp113_2e_i;   /* for PHI node */
  goto llvm_cbe_bb114_2e_i;

  } while (1); /* end of syntactic loop 'bb114.i' */
llvm_cbe_bb54_2e_i:
  llvm_cbe_tmp56_2e_i = ((signed int )(((signed int )llvm_cbe_abs_2e_i) >> ((signed int )1u)));
  llvm_cbe_abs39_2e_i_2e_reload809 = *(&llvm_cbe_abs39_2e_i_2e_reg2mem);
  llvm_cbe_tmp61_2e_i = ((signed int )(((signed int )(llvm_cbe_abs39_2e_i_2e_reload809 * 255u)) / ((signed int )(llvm_cbe_abs_2e_i + 1u))));
  llvm_cbe_storemerge2_2e_i = (((((signed int )(-(llvm_cbe_tmp61_2e_i))) < ((signed int )0u))) ? (255u) : (0u));
  llvm_cbe_storemerge3_2e_i = ((((((signed int )llvm_cbe_storemerge_2e_i44) > ((signed int )0u))) ? (llvm_cbe_tmp12_2e_i652) : (llvm_cbe_tmp188))) - ((((((signed int )llvm_cbe_storemerge_2e_i44) > ((signed int )0u))) ? (llvm_cbe_tmp188) : (llvm_cbe_tmp12_2e_i652)));
  llvm_cbe_tmp9798_2e_i = ((signed long long )(signed int )llvm_cbe_storemerge_2e_i44);
  llvm_cbe_tmp111112_2e_i = ((signed long long )(signed int )llvm_cbe_pixStride_2e_i_2e_0);
  llvm_cbe_count1_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_storemerge3_2e_i;   /* for PHI node */
  llvm_cbe_alpha_2e_i_2e_0__PHI_TEMPORARY = 127u;   /* for PHI node */
  llvm_cbe_cycle_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp56_2e_i;   /* for PHI node */
  llvm_cbe_pix_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp10_2e_i25;   /* for PHI node */
  goto llvm_cbe_bb114_2e_i;

llvm_cbe_bb48_2e_i:
  llvm_cbe_pixStride_2e_i_2e_0 = llvm_cbe_pixStride_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_abs39_2e_i_2e_reload814 = *(&llvm_cbe_abs39_2e_i_2e_reg2mem);
  if ((((signed int )llvm_cbe_abs39_2e_i_2e_reload814) < ((signed int )llvm_cbe_abs_2e_i))) {
    goto llvm_cbe_bb54_2e_i;
  } else {
    goto llvm_cbe_bb123_2e_i;
  }

llvm_cbe_bb35_2e_i:
  *(&llvm_cbe_storemerge1_2e_i_2e_reg2mem) = 1u;
  *(&llvm_cbe_abs39_2e_i_2e_reg2mem) = ((((((signed int )llvm_cbe_tmp21_2e_i40) > ((signed int )4294967295u))) ? (llvm_cbe_tmp21_2e_i40) : ((-(llvm_cbe_tmp21_2e_i40)))));
  llvm_cbe_storemerge1_2e_i_2e_reload = *(&llvm_cbe_storemerge1_2e_i_2e_reg2mem);
  if ((((signed int )llvm_cbe_storemerge1_2e_i_2e_reload) < ((signed int )0u))) {
    goto llvm_cbe_bb44_2e_i;
  } else {
    llvm_cbe_pixStride_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp13_2e_i27769;   /* for PHI node */
    goto llvm_cbe_bb48_2e_i;
  }

llvm_cbe_bb175:
  *llvm_cbe_tmp2_2e_i_2e_i30 = llvm_cbe_color;
  *llvm_cbe_tmp8_2e_i_2e_i36 = llvm_cbe_tmp2_2e_i_2e_i_2e_i;
  *llvm_cbe_tmp6_2e_i_2e_i34 = llvm_cbe_tmp6_2e_i_2e_i_2e_i;
  *llvm_cbe_tmp4_2e_i_2e_i32 = llvm_cbe_tmp9_2e_i_2e_i_2e_i;
  llvm_cbe_tmp18_2e_i = llvm_cbe_tmp12_2e_i652 - llvm_cbe_tmp188;
  llvm_cbe_tmp21_2e_i40 = llvm_cbe_tmp23_2e_i660 - llvm_cbe_tmp185;
  llvm_cbe_storemerge_2e_i44 = (((((signed int )llvm_cbe_tmp18_2e_i) < ((signed int )0u))) ? (4294967295u) : (1u));
  llvm_cbe_abs_2e_i = (((((signed int )llvm_cbe_tmp18_2e_i) > ((signed int )4294967295u))) ? (llvm_cbe_tmp18_2e_i) : ((-(llvm_cbe_tmp18_2e_i))));
  if ((((signed int )llvm_cbe_tmp21_2e_i40) < ((signed int )0u))) {
    goto llvm_cbe_bb35_2e_i_2e_thread;
  } else {
    goto llvm_cbe_bb35_2e_i;
  }

llvm_cbe_bb44_2e_i:
  llvm_cbe_tmp47_2e_i = -(llvm_cbe_tmp13_2e_i27769);
  llvm_cbe_pixStride_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp47_2e_i;   /* for PHI node */
  goto llvm_cbe_bb48_2e_i;

llvm_cbe_bb35_2e_i_2e_thread:
  *(&llvm_cbe_storemerge1_2e_i_2e_reg2mem) = 4294967295u;
  *(&llvm_cbe_abs39_2e_i_2e_reg2mem) = ((((((signed int )llvm_cbe_tmp21_2e_i40) > ((signed int )4294967295u))) ? (llvm_cbe_tmp21_2e_i40) : ((-(llvm_cbe_tmp21_2e_i40)))));
  goto llvm_cbe_bb44_2e_i;

  do {     /* Syntactic loop 'bb185.i' to make GCC happy */
llvm_cbe_bb185_2e_i:
  llvm_cbe_count_2e_i_2e_0 = llvm_cbe_count_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_alpha_2e_i_2e_1 = llvm_cbe_alpha_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_cycle_2e_i_2e_1 = llvm_cbe_cycle_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_pix_2e_i_2e_1 = llvm_cbe_pix_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_tmp187_2e_i = llvm_cbe_count_2e_i_2e_0 + 4294967295u;
  if ((llvm_cbe_tmp187_2e_i == 4294967295u)) {
    llvm_cbe_i_2e_3_2e_in__PHI_TEMPORARY = llvm_cbe_i_2e_3;   /* for PHI node */
    goto llvm_cbe_bb232;
  } else {
    goto llvm_cbe_bb158_2e_i;
  }

llvm_cbe_bb158_2e_i:
  _ZN10AlphaBrushIjLj1EE3inkEPjii((&llvm_cbe_brush_2e_i), llvm_cbe_pix_2e_i_2e_1, 1u, llvm_cbe_alpha_2e_i_2e_1);
  llvm_cbe_tmp163_2e_i = llvm_cbe_cycle_2e_i_2e_1 + llvm_cbe_abs_2e_i;
  llvm_cbe_tmp166_2e_i = llvm_cbe_alpha_2e_i_2e_1 + llvm_cbe_tmp135_2e_i;
  llvm_cbe_tmp170_2e_i = (&llvm_cbe_pix_2e_i_2e_1[((signed long long )llvm_cbe_tmp168169_2e_i)]);
  llvm_cbe_abs39_2e_i_2e_reload811 = *(&llvm_cbe_abs39_2e_i_2e_reg2mem);
  if ((((signed int )llvm_cbe_tmp163_2e_i) > ((signed int )llvm_cbe_abs39_2e_i_2e_reload811))) {
    goto llvm_cbe_bb176_2e_i;
  } else {
    llvm_cbe_count_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp187_2e_i;   /* for PHI node */
    llvm_cbe_alpha_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp166_2e_i;   /* for PHI node */
    llvm_cbe_cycle_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp163_2e_i;   /* for PHI node */
    llvm_cbe_pix_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp170_2e_i;   /* for PHI node */
    goto llvm_cbe_bb185_2e_i;
  }

llvm_cbe_bb176_2e_i:
  llvm_cbe_abs39_2e_i_2e_reload810 = *(&llvm_cbe_abs39_2e_i_2e_reg2mem);
  llvm_cbe_tmp179_2e_i = llvm_cbe_tmp163_2e_i - llvm_cbe_abs39_2e_i_2e_reload810;
  llvm_cbe_tmp184_2e_i = (&llvm_cbe_pix_2e_i_2e_1[((signed long long )(llvm_cbe_tmp168169_2e_i + llvm_cbe_tmp182183_2e_i))]);
  llvm_cbe_count_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp187_2e_i;   /* for PHI node */
  llvm_cbe_alpha_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_storemerge4_2e_i;   /* for PHI node */
  llvm_cbe_cycle_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp179_2e_i;   /* for PHI node */
  llvm_cbe_pix_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp184_2e_i;   /* for PHI node */
  goto llvm_cbe_bb185_2e_i;

  } while (1); /* end of syntactic loop 'bb185.i' */
llvm_cbe_bb123_2e_i:
  llvm_cbe_abs39_2e_i_2e_reload813 = *(&llvm_cbe_abs39_2e_i_2e_reg2mem);
  llvm_cbe_tmp125_2e_i = ((signed int )(((signed int )llvm_cbe_abs39_2e_i_2e_reload813) >> ((signed int )1u)));
  llvm_cbe_abs39_2e_i_2e_reload812 = *(&llvm_cbe_abs39_2e_i_2e_reg2mem);
  llvm_cbe_tmp132_2e_i = ((signed int )(((signed int )(llvm_cbe_abs_2e_i * 255u)) / ((signed int )(llvm_cbe_abs39_2e_i_2e_reload812 + 1u))));
  llvm_cbe_tmp135_2e_i = ((((((signed int )llvm_cbe_tmp132_2e_i) > ((signed int )4294967295u))) ? (llvm_cbe_tmp132_2e_i) : ((-(llvm_cbe_tmp132_2e_i))))) * (-(llvm_cbe_storemerge_2e_i44));
  llvm_cbe_storemerge4_2e_i = (((((signed int )llvm_cbe_tmp135_2e_i) < ((signed int )0u))) ? (255u) : (0u));
  llvm_cbe_storemerge1_2e_i_2e_reload808 = *(&llvm_cbe_storemerge1_2e_i_2e_reg2mem);
  llvm_cbe_storemerge5_2e_i = ((((((signed int )llvm_cbe_storemerge1_2e_i_2e_reload808) > ((signed int )0u))) ? (llvm_cbe_tmp23_2e_i660) : (llvm_cbe_tmp185))) - ((((((signed int )llvm_cbe_storemerge1_2e_i_2e_reload808) > ((signed int )0u))) ? (llvm_cbe_tmp185) : (llvm_cbe_tmp23_2e_i660)));
  llvm_cbe_tmp168169_2e_i = ((signed long long )(signed int )llvm_cbe_pixStride_2e_i_2e_0);
  llvm_cbe_tmp182183_2e_i = ((signed long long )(signed int )llvm_cbe_storemerge_2e_i44);
  llvm_cbe_count_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_storemerge5_2e_i;   /* for PHI node */
  llvm_cbe_alpha_2e_i_2e_1__PHI_TEMPORARY = 127u;   /* for PHI node */
  llvm_cbe_cycle_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp125_2e_i;   /* for PHI node */
  llvm_cbe_pix_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp10_2e_i25;   /* for PHI node */
  goto llvm_cbe_bb185_2e_i;

  do {     /* Syntactic loop 'bb207' to make GCC happy */
llvm_cbe_bb207:
  llvm_cbe_i_2e_1 = llvm_cbe_i_2e_1__PHI_TEMPORARY;
  if ((((signed int )llvm_cbe_i_2e_1) < ((signed int )llvm_cbe_tmp3_2e_i_2e_i761))) {
    goto llvm_cbe_bb213;
  } else {
    llvm_cbe_i_2e_3_2e_in__PHI_TEMPORARY = llvm_cbe_i_2e_1;   /* for PHI node */
    goto llvm_cbe_bb232;
  }

llvm_cbe_bb225:
  llvm_cbe_tmp206 = llvm_cbe_i_2e_1 + 1u;
  llvm_cbe_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp206;   /* for PHI node */
  goto llvm_cbe_bb207;

llvm_cbe_bb213:
  llvm_cbe_tmp45_2e_i_2e_i = ((signed long long )(signed int )llvm_cbe_i_2e_1);
  llvm_cbe_tmp3_2e_i4 = *((&llvm_cbe_tmp3_2e_i_2e_i693[((signed long long )llvm_cbe_tmp45_2e_i_2e_i)].field0));
  if ((((signed int )llvm_cbe_tmp3_2e_i4) < ((signed int )llvm_cbe_tmp5))) {
    goto llvm_cbe_bb225;
  } else {
    goto llvm_cbe_bb_2e_i;
  }

llvm_cbe_bb_2e_i:
  llvm_cbe_tmp12_2e_i = *((&llvm_cbe_tmp3_2e_i_2e_i693[((signed long long )llvm_cbe_tmp45_2e_i_2e_i)].field0));
  if ((((signed int )llvm_cbe_tmp12_2e_i) > ((signed int )llvm_cbe_tmp17))) {
    goto llvm_cbe_bb225;
  } else {
    goto llvm_cbe_bb20_2e_i;
  }

llvm_cbe_bb20_2e_i:
  llvm_cbe_tmp23_2e_i = *((&llvm_cbe_tmp3_2e_i_2e_i693[((signed long long )llvm_cbe_tmp45_2e_i_2e_i)].field1));
  if (((((((signed int )llvm_cbe_tmp23_2e_i) < ((signed int )llvm_cbe_tmp11)) | (((signed int )llvm_cbe_tmp23_2e_i) > ((signed int )llvm_cbe_tmp23)))&1))) {
    goto llvm_cbe_bb225;
  } else {
    llvm_cbe_i_2e_3_2e_in__PHI_TEMPORARY = llvm_cbe_i_2e_1;   /* for PHI node */
    goto llvm_cbe_bb232;
  }

  } while (1); /* end of syntactic loop 'bb207' */
  } while (1); /* end of syntactic loop 'bb232' */
llvm_cbe_bb238:
  llvm_cbe_tmp241 = *llvm_cbe_tmp55;
  SDL_UnlockSurface((((struct l_struct_2E_SDL_Surface *)llvm_cbe_tmp241)));
  return;
}


static unsigned int _ZNK6Canvas9readPixelEii(struct l_struct_2E_Canvas *llvm_cbe_this, unsigned int llvm_cbe_x, unsigned int llvm_cbe_y) {
  unsigned char **llvm_cbe_tmp2;
  unsigned char *llvm_cbe_tmp3;
  struct l_struct_2E_SDL_Surface *llvm_cbe_tmp34;
  struct l_struct_2E_SDL_PixelFormat *llvm_cbe_tmp6;
  unsigned char llvm_cbe_tmp8;
  unsigned short llvm_cbe_tmp15;
  unsigned char *llvm_cbe_tmp24;
  unsigned char *llvm_cbe_tmp27;
  unsigned int llvm_cbe_tmp32;
  unsigned short llvm_cbe_tmp40;
  unsigned int llvm_cbe_tmp4041;
  unsigned int llvm_cbe_tmp48;
  unsigned int llvm_cbe_c_2e_0;
  unsigned int llvm_cbe_c_2e_0__PHI_TEMPORARY;
  unsigned char *llvm_cbe_tmp53;

  llvm_cbe_tmp2 = (&llvm_cbe_this->field1);
  llvm_cbe_tmp3 = *llvm_cbe_tmp2;
  llvm_cbe_tmp34 = ((struct l_struct_2E_SDL_Surface *)llvm_cbe_tmp3);
  llvm_cbe_tmp6 = *((&llvm_cbe_tmp34->field1));
  llvm_cbe_tmp8 = *((&llvm_cbe_tmp6->field2));
  llvm_cbe_tmp15 = *((&llvm_cbe_tmp34->field4));
  llvm_cbe_tmp24 = *((&llvm_cbe_tmp34->field5));
  llvm_cbe_tmp27 = (&llvm_cbe_tmp24[((signed long long )(((unsigned long long )(unsigned int )((((unsigned int )(unsigned short )llvm_cbe_tmp15)) * llvm_cbe_y))))]);
  llvm_cbe_tmp32 = SDL_LockSurface(llvm_cbe_tmp34);
  switch ((((unsigned int )(unsigned char )llvm_cbe_tmp8))) {
  default:
    llvm_cbe_c_2e_0__PHI_TEMPORARY = 0u;   /* for PHI node */
    goto llvm_cbe_bb50;
;
  case 2u:
    goto llvm_cbe_bb;
    break;
  case 4u:
    goto llvm_cbe_bb42;
  }
llvm_cbe_bb:
  llvm_cbe_tmp40 = *((&(((unsigned short *)llvm_cbe_tmp27))[((signed long long )(((signed long long )(signed int )llvm_cbe_x)))]));
  llvm_cbe_tmp4041 = ((unsigned int )(unsigned short )llvm_cbe_tmp40);
  llvm_cbe_c_2e_0__PHI_TEMPORARY = llvm_cbe_tmp4041;   /* for PHI node */
  goto llvm_cbe_bb50;

llvm_cbe_bb42:
  llvm_cbe_tmp48 = *((&(((unsigned int *)llvm_cbe_tmp27))[((signed long long )(((signed long long )(signed int )llvm_cbe_x)))]));
  llvm_cbe_c_2e_0__PHI_TEMPORARY = llvm_cbe_tmp48;   /* for PHI node */
  goto llvm_cbe_bb50;

llvm_cbe_bb50:
  llvm_cbe_c_2e_0 = llvm_cbe_c_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp53 = *llvm_cbe_tmp2;
  SDL_UnlockSurface((((struct l_struct_2E_SDL_Surface *)llvm_cbe_tmp53)));
  return llvm_cbe_c_2e_0;
}


static void _ZN6CanvasC1Eii(struct l_struct_2E_Canvas *llvm_cbe_this, unsigned int llvm_cbe_w, unsigned int llvm_cbe_h) {
  unsigned char **llvm_cbe_tmp4;
  struct l_struct_2E_SDL_VideoInfo *llvm_cbe_tmp11;
  struct l_struct_2E_SDL_PixelFormat *llvm_cbe_tmp13;
  unsigned char llvm_cbe_tmp15;
  struct l_struct_2E_SDL_VideoInfo *llvm_cbe_tmp18;
  struct l_struct_2E_SDL_PixelFormat *llvm_cbe_tmp20;
  unsigned int llvm_cbe_tmp22;
  struct l_struct_2E_SDL_VideoInfo *llvm_cbe_tmp23;
  struct l_struct_2E_SDL_PixelFormat *llvm_cbe_tmp25;
  unsigned int llvm_cbe_tmp27;
  struct l_struct_2E_SDL_VideoInfo *llvm_cbe_tmp28;
  struct l_struct_2E_SDL_PixelFormat *llvm_cbe_tmp30;
  unsigned int llvm_cbe_tmp32;
  struct l_struct_2E_SDL_VideoInfo *llvm_cbe_tmp33;
  struct l_struct_2E_SDL_PixelFormat *llvm_cbe_tmp35;
  unsigned int llvm_cbe_tmp37;
  struct l_struct_2E_SDL_VideoInfo *llvm_cbe_tmp38;
  struct l_struct_2E_SDL_PixelFormat *llvm_cbe_tmp40;
  unsigned char llvm_cbe_tmp42;
  struct l_struct_2E_SDL_Surface *llvm_cbe_tmp46;
  unsigned char *llvm_cbe_tmp4649;
  struct l_struct_2E_SDL_Surface *llvm_cbe_tmp53;
  unsigned char *llvm_cbe_tmp5356;
  unsigned char *llvm_cbe_storemerge;
  unsigned char *llvm_cbe_storemerge__PHI_TEMPORARY;
  unsigned char *llvm_cbe_tmp2_2e_i3_2e_rle;
  unsigned char *llvm_cbe_tmp2_2e_i3_2e_rle__PHI_TEMPORARY;
  struct l_struct_2E_SDL_Surface *llvm_cbe_tmp34_2e_i_2e_i;
  unsigned int llvm_cbe_tmp6_2e_i_2e_i;
  unsigned int llvm_cbe_tmp6_2e_i6_2e_i;

  *((&llvm_cbe_this->field0)) = ((&_ZTV6Canvas[((signed long long )2ull)]));
  llvm_cbe_tmp4 = (&llvm_cbe_this->field1);
  *llvm_cbe_tmp4 = ((unsigned char *)/*NULL*/0);
  *((&llvm_cbe_this->field2)) = 0u;
  *((&llvm_cbe_this->field3)) = ((struct l_struct_2E_Canvas *)/*NULL*/0);
  llvm_cbe_tmp11 = SDL_GetVideoInfo();
  llvm_cbe_tmp13 = *((&llvm_cbe_tmp11->field4));
  llvm_cbe_tmp15 = *((&llvm_cbe_tmp13->field1));
  switch ((((unsigned int )(unsigned char )llvm_cbe_tmp15))) {
  default:
    goto llvm_cbe_bb50;
;
  case 16u:
    goto llvm_cbe_bb;
    break;
  case 32u:
    goto llvm_cbe_bb;
    break;
  }
llvm_cbe_bb:
  llvm_cbe_tmp18 = SDL_GetVideoInfo();
  llvm_cbe_tmp20 = *((&llvm_cbe_tmp18->field4));
  llvm_cbe_tmp22 = *((&llvm_cbe_tmp20->field14));
  llvm_cbe_tmp23 = SDL_GetVideoInfo();
  llvm_cbe_tmp25 = *((&llvm_cbe_tmp23->field4));
  llvm_cbe_tmp27 = *((&llvm_cbe_tmp25->field13));
  llvm_cbe_tmp28 = SDL_GetVideoInfo();
  llvm_cbe_tmp30 = *((&llvm_cbe_tmp28->field4));
  llvm_cbe_tmp32 = *((&llvm_cbe_tmp30->field12));
  llvm_cbe_tmp33 = SDL_GetVideoInfo();
  llvm_cbe_tmp35 = *((&llvm_cbe_tmp33->field4));
  llvm_cbe_tmp37 = *((&llvm_cbe_tmp35->field11));
  llvm_cbe_tmp38 = SDL_GetVideoInfo();
  llvm_cbe_tmp40 = *((&llvm_cbe_tmp38->field4));
  llvm_cbe_tmp42 = *((&llvm_cbe_tmp40->field1));
  llvm_cbe_tmp46 = SDL_CreateRGBSurface(0u, llvm_cbe_w, llvm_cbe_h, (((unsigned int )(unsigned char )llvm_cbe_tmp42)), llvm_cbe_tmp37, llvm_cbe_tmp32, llvm_cbe_tmp27, llvm_cbe_tmp22);
  llvm_cbe_tmp4649 = ((unsigned char *)llvm_cbe_tmp46);
  llvm_cbe_storemerge__PHI_TEMPORARY = llvm_cbe_tmp4649;   /* for PHI node */
  llvm_cbe_tmp2_2e_i3_2e_rle__PHI_TEMPORARY = llvm_cbe_tmp4649;   /* for PHI node */
  goto llvm_cbe_bb57;

llvm_cbe_bb50:
  llvm_cbe_tmp53 = SDL_CreateRGBSurface(0u, llvm_cbe_w, llvm_cbe_h, 32u, 16711680u, 65280u, 255u, 4278190080u);
  llvm_cbe_tmp5356 = ((unsigned char *)llvm_cbe_tmp53);
  llvm_cbe_storemerge__PHI_TEMPORARY = llvm_cbe_tmp5356;   /* for PHI node */
  llvm_cbe_tmp2_2e_i3_2e_rle__PHI_TEMPORARY = llvm_cbe_tmp5356;   /* for PHI node */
  goto llvm_cbe_bb57;

llvm_cbe_bb57:
  llvm_cbe_storemerge = llvm_cbe_storemerge__PHI_TEMPORARY;
  llvm_cbe_tmp2_2e_i3_2e_rle = llvm_cbe_tmp2_2e_i3_2e_rle__PHI_TEMPORARY;
  *llvm_cbe_tmp4 = llvm_cbe_storemerge;
  if ((llvm_cbe_tmp2_2e_i3_2e_rle == ((unsigned char *)/*NULL*/0))) {
    goto llvm_cbe_bb10_2e_i;
  } else {
    goto llvm_cbe_bb_2e_i;
  }

llvm_cbe_bb_2e_i:
  llvm_cbe_tmp34_2e_i_2e_i = ((struct l_struct_2E_SDL_Surface *)llvm_cbe_tmp2_2e_i3_2e_rle);
  llvm_cbe_tmp6_2e_i_2e_i = *((&llvm_cbe_tmp34_2e_i_2e_i->field3));
  llvm_cbe_tmp6_2e_i6_2e_i = *((&llvm_cbe_tmp34_2e_i_2e_i->field2));
  _ZN6Canvas7setClipEiiii(llvm_cbe_this, llvm_cbe_tmp6_2e_i6_2e_i, llvm_cbe_tmp6_2e_i_2e_i);
  return;
llvm_cbe_bb10_2e_i:
  _ZN6Canvas7setClipEiiii(llvm_cbe_this, 0u, 0u);
  return;
}


static void _ZN4PathC1ERKS_(struct l_struct_2E_Path *llvm_cbe_this, struct l_struct_2E_Path *llvm_cbe_unnamed_arg) {
  struct l_struct_2E_Vec2 **llvm_cbe_tmp1_2e_i;
  unsigned int *llvm_cbe_tmp3_2e_i;
  unsigned int *llvm_cbe_tmp5_2e_i;
  unsigned int *llvm_cbe_tmp2_2e_i_2e_i;
  unsigned int llvm_cbe_tmp3_2e_i_2e_i;
  unsigned char *llvm_cbe_tmp28_2e_i_2e_i;
  unsigned char *llvm_cbe_tmp23_2e_i_2e_rle;
  unsigned char *llvm_cbe_tmp23_2e_i_2e_rle__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp3_2e_i7_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp20_2e_i;
  unsigned char *ltmp_2_1;
  unsigned int llvm_cbe_tmp3_2e_i3_2e_i;

  llvm_cbe_tmp1_2e_i = (&llvm_cbe_this->field0.field0);
  *llvm_cbe_tmp1_2e_i = ((struct l_struct_2E_Vec2 *)/*NULL*/0);
  llvm_cbe_tmp3_2e_i = (&llvm_cbe_this->field0.field1);
  *llvm_cbe_tmp3_2e_i = 0u;
  llvm_cbe_tmp5_2e_i = (&llvm_cbe_this->field0.field2);
  *llvm_cbe_tmp5_2e_i = 0u;
  llvm_cbe_tmp2_2e_i_2e_i = (&llvm_cbe_unnamed_arg->field0.field1);
  llvm_cbe_tmp3_2e_i_2e_i = *llvm_cbe_tmp2_2e_i_2e_i;
  if ((llvm_cbe_tmp3_2e_i_2e_i == 0u)) {
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb_2e_i;
  }

llvm_cbe_bb_2e_i:
  if ((((signed int )llvm_cbe_tmp3_2e_i_2e_i) < ((signed int )0u))) {
    llvm_cbe_tmp23_2e_i_2e_rle__PHI_TEMPORARY = ((unsigned char *)/*NULL*/0);   /* for PHI node */
    goto llvm_cbe__ZN5ArrayI4Vec2E8capacityEi_2e_exit_2e_i;
  } else {
    goto llvm_cbe_bb24_2e_i_2e_i;
  }

llvm_cbe_bb24_2e_i_2e_i:
  llvm_cbe_tmp28_2e_i_2e_i = malloc(((((signed long long )(signed int )llvm_cbe_tmp3_2e_i_2e_i)) << 3ull));
  *llvm_cbe_tmp1_2e_i = (((struct l_struct_2E_Vec2 *)llvm_cbe_tmp28_2e_i_2e_i));
  *llvm_cbe_tmp5_2e_i = llvm_cbe_tmp3_2e_i_2e_i;
  llvm_cbe_tmp23_2e_i_2e_rle__PHI_TEMPORARY = llvm_cbe_tmp28_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe__ZN5ArrayI4Vec2E8capacityEi_2e_exit_2e_i;

llvm_cbe__ZN5ArrayI4Vec2E8capacityEi_2e_exit_2e_i:
  llvm_cbe_tmp23_2e_i_2e_rle = llvm_cbe_tmp23_2e_i_2e_rle__PHI_TEMPORARY;
  llvm_cbe_tmp3_2e_i7_2e_i = *llvm_cbe_tmp2_2e_i_2e_i;
  llvm_cbe_tmp20_2e_i = *((&llvm_cbe_unnamed_arg->field0.field0));
  ltmp_2_1 = memcpy(llvm_cbe_tmp23_2e_i_2e_rle, (((unsigned char *)llvm_cbe_tmp20_2e_i)), ((((signed long long )(signed int )llvm_cbe_tmp3_2e_i7_2e_i)) << 3ull));
  llvm_cbe_tmp3_2e_i3_2e_i = *llvm_cbe_tmp2_2e_i_2e_i;
  *llvm_cbe_tmp3_2e_i = llvm_cbe_tmp3_2e_i3_2e_i;
  return;
llvm_cbe_return:
  return;
}


static void _ZN4PathaSERKS_(struct l_struct_2E_Path *llvm_cbe_this, struct l_struct_2E_Path *llvm_cbe_unnamed_arg) {
  unsigned int *llvm_cbe_tmp2_2e_i;
  unsigned int *llvm_cbe_tmp2_2e_i_2e_i;
  unsigned int llvm_cbe_tmp3_2e_i_2e_i;
  unsigned int *llvm_cbe_tmp7_2e_i_2e_i;
  unsigned int llvm_cbe_tmp8_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp27_2e_i_2e_i;
  struct l_struct_2E_Vec2 **llvm_cbe_tmp17_2e_i_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp18_2e_i_2e_i;
  unsigned char *llvm_cbe_tmp20_2e_i_2e_i;
  unsigned char *llvm_cbe_tmp28_2e_i_2e_i;
  unsigned int llvm_cbe_tmp3_2e_i7_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp17_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp20_2e_i;
  unsigned char *ltmp_3_1;
  unsigned int llvm_cbe_tmp3_2e_i3_2e_i;

  llvm_cbe_tmp2_2e_i = (&llvm_cbe_this->field0.field1);
  *llvm_cbe_tmp2_2e_i = 0u;
  llvm_cbe_tmp2_2e_i_2e_i = (&llvm_cbe_unnamed_arg->field0.field1);
  llvm_cbe_tmp3_2e_i_2e_i = *llvm_cbe_tmp2_2e_i_2e_i;
  if ((llvm_cbe_tmp3_2e_i_2e_i == 0u)) {
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb_2e_i;
  }

llvm_cbe_bb_2e_i:
  if ((((signed int )llvm_cbe_tmp3_2e_i_2e_i) < ((signed int )0u))) {
    goto llvm_cbe__ZN5ArrayI4Vec2E8capacityEi_2e_exit_2e_i;
  } else {
    goto llvm_cbe_bb_2e_i_2e_i;
  }

llvm_cbe_bb_2e_i_2e_i:
  llvm_cbe_tmp7_2e_i_2e_i = (&llvm_cbe_this->field0.field2);
  llvm_cbe_tmp8_2e_i_2e_i = *llvm_cbe_tmp7_2e_i_2e_i;
  llvm_cbe_tmp27_2e_i_2e_i = (((signed long long )(signed int )llvm_cbe_tmp3_2e_i_2e_i)) << 3ull;
  if ((llvm_cbe_tmp8_2e_i_2e_i == 0u)) {
    goto llvm_cbe_bb24_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb12_2e_i_2e_i;
  }

llvm_cbe_bb12_2e_i_2e_i:
  llvm_cbe_tmp17_2e_i_2e_i = (&llvm_cbe_this->field0.field0);
  llvm_cbe_tmp18_2e_i_2e_i = *llvm_cbe_tmp17_2e_i_2e_i;
  llvm_cbe_tmp20_2e_i_2e_i = realloc((((unsigned char *)llvm_cbe_tmp18_2e_i_2e_i)), llvm_cbe_tmp27_2e_i_2e_i);
  *llvm_cbe_tmp17_2e_i_2e_i = (((struct l_struct_2E_Vec2 *)llvm_cbe_tmp20_2e_i_2e_i));
  goto llvm_cbe_bb32_2e_i_2e_i;

llvm_cbe_bb24_2e_i_2e_i:
  llvm_cbe_tmp28_2e_i_2e_i = malloc(llvm_cbe_tmp27_2e_i_2e_i);
  *((&llvm_cbe_this->field0.field0)) = (((struct l_struct_2E_Vec2 *)llvm_cbe_tmp28_2e_i_2e_i));
  goto llvm_cbe_bb32_2e_i_2e_i;

llvm_cbe_bb32_2e_i_2e_i:
  *llvm_cbe_tmp7_2e_i_2e_i = llvm_cbe_tmp3_2e_i_2e_i;
  goto llvm_cbe__ZN5ArrayI4Vec2E8capacityEi_2e_exit_2e_i;

llvm_cbe__ZN5ArrayI4Vec2E8capacityEi_2e_exit_2e_i:
  llvm_cbe_tmp3_2e_i7_2e_i = *llvm_cbe_tmp2_2e_i_2e_i;
  llvm_cbe_tmp17_2e_i = *((&llvm_cbe_unnamed_arg->field0.field0));
  llvm_cbe_tmp20_2e_i = *((&llvm_cbe_this->field0.field0));
  ltmp_3_1 = memcpy((((unsigned char *)llvm_cbe_tmp20_2e_i)), (((unsigned char *)llvm_cbe_tmp17_2e_i)), ((((signed long long )(signed int )llvm_cbe_tmp3_2e_i7_2e_i)) << 3ull));
  llvm_cbe_tmp3_2e_i3_2e_i = *llvm_cbe_tmp2_2e_i_2e_i;
  *llvm_cbe_tmp2_2e_i = llvm_cbe_tmp3_2e_i3_2e_i;
  return;
llvm_cbe_return:
  return;
}


static void _ZN4Font4drawEP6Canvas4Vec2RKSsi(struct l_struct_2E_Font *llvm_cbe_this, struct l_struct_2E_Canvas *llvm_cbe_canvas, struct l_struct_2E_Vec2 *llvm_cbe_pt, struct l_struct_2E_std_3A__3A_string *llvm_cbe_text) {
  unsigned char llvm_cbe_c_2e_0_2e_reg2mem;    /* Address-exposed local */
  struct l_struct_2E_Path llvm_cbe_p;    /* Address-exposed local */
  struct l_struct_2E_Rect llvm_cbe_r;    /* Address-exposed local */
  struct l_struct_2E_Rect llvm_cbe_tmp;    /* Address-exposed local */
  unsigned int *llvm_cbe_tmp70;
  struct l_struct_2E_Path *llvm_cbe_tmp74;
  unsigned int *llvm_cbe_tmp3_2e_i3;
  unsigned int *llvm_cbe_tmp7_2e_i;
  unsigned int *llvm_cbe_tmp3_2e_i6;
  unsigned int *llvm_cbe_tmp7_2e_i9;
  struct l_struct_2E_Vec2 **llvm_cbe_tmp1_2e_i_2e_i16;
  struct l_struct_2E_Vec2 **llvm_cbe_tmp6_2e_i_2e_i20;
  unsigned char *llvm_cbe_tmp4;
  unsigned char llvm_cbe_tmp5;
  unsigned char llvm_cbe_tmp9;
  unsigned char llvm_cbe_c_2e_0;
  unsigned char llvm_cbe_c_2e_0__PHI_TEMPORARY;
  unsigned char llvm_cbe_c_2e_0_2e_reload25;
  unsigned long long llvm_cbe_tmp171821;
  unsigned int llvm_cbe_tmp3_2e_i;
  struct l_struct_2E_Path *llvm_cbe_tmp40;
  struct l_struct_2E_Path *llvm_cbe_tmp48;
  unsigned int llvm_cbe_tmp54;
  unsigned int llvm_cbe_tmp4_2e_i7;
  unsigned int llvm_cbe_tmp8_2e_i10;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp2_2e_i_2e_i17;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp7_2e_i_2e_i21;
  unsigned char llvm_cbe_c_2e_0_2e_reload;
  unsigned int llvm_cbe_tmp71;
  unsigned int llvm_cbe_tmp4_2e_i;
  unsigned int llvm_cbe_tmp8_2e_i;
  unsigned int llvm_cbe_tmp81;
  unsigned int llvm_cbe_storemerge1;
  unsigned int llvm_cbe_storemerge1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp8384;
  unsigned long long llvm_cbe_tmp86;

  llvm_cbe_tmp70 = (&llvm_cbe_pt->field0);
  llvm_cbe_tmp74 = (&llvm_cbe_this->field0[((signed long long )69ull)]);
  llvm_cbe_tmp3_2e_i3 = (&llvm_cbe_tmp.field1.field0);
  llvm_cbe_tmp7_2e_i = (&llvm_cbe_tmp.field0.field0);
  llvm_cbe_tmp3_2e_i6 = (&llvm_cbe_r.field1.field0);
  llvm_cbe_tmp7_2e_i9 = (&llvm_cbe_r.field0.field0);
  llvm_cbe_tmp1_2e_i_2e_i16 = (&llvm_cbe_p.field0.field0);
  llvm_cbe_tmp6_2e_i_2e_i20 = (&llvm_cbe_p.field0.field0);
  llvm_cbe_storemerge1__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb82;

  do {     /* Syntactic loop 'bb82' to make GCC happy */
llvm_cbe_bb82:
  llvm_cbe_storemerge1 = llvm_cbe_storemerge1__PHI_TEMPORARY;
  llvm_cbe_tmp8384 = ((signed long long )(signed int )llvm_cbe_storemerge1);
  llvm_cbe_tmp86 = _ZNKSs6lengthEv(llvm_cbe_text);
  if ((((unsigned long long )llvm_cbe_tmp8384) < ((unsigned long long )llvm_cbe_tmp86))) {
    goto llvm_cbe_bb;
  } else {
    goto llvm_cbe_return;
  }

llvm_cbe_bb79:
  llvm_cbe_tmp81 = llvm_cbe_storemerge1 + 1u;
  llvm_cbe_storemerge1__PHI_TEMPORARY = llvm_cbe_tmp81;   /* for PHI node */
  goto llvm_cbe_bb82;

llvm_cbe_bb34:
  llvm_cbe_tmp40 = (&llvm_cbe_this->field0[((signed long long )llvm_cbe_tmp171821)]);
  llvm_cbe_r = _ZNK4Path4bboxEv(llvm_cbe_tmp40);
  _ZN4PathC1ERKS_((&llvm_cbe_p), llvm_cbe_tmp40);
  llvm_cbe_tmp48 = _ZN4Path9translateERK4Vec2((&llvm_cbe_p), llvm_cbe_pt);
  _ZN6Canvas8drawPathERK4Pathib(llvm_cbe_canvas, (&llvm_cbe_p), 0u, ((unsigned char )0));
  llvm_cbe_tmp54 = *llvm_cbe_tmp70;
  llvm_cbe_tmp4_2e_i7 = *llvm_cbe_tmp3_2e_i6;
  llvm_cbe_tmp8_2e_i10 = *llvm_cbe_tmp7_2e_i9;
  *llvm_cbe_tmp70 = (llvm_cbe_tmp54 + ((llvm_cbe_tmp4_2e_i7 - llvm_cbe_tmp8_2e_i10) + 2u));
  llvm_cbe_tmp2_2e_i_2e_i17 = *llvm_cbe_tmp1_2e_i_2e_i16;
  if ((llvm_cbe_tmp2_2e_i_2e_i17 == ((struct l_struct_2E_Vec2 *)/*NULL*/0))) {
    goto llvm_cbe_bb79;
  } else {
    goto llvm_cbe_bb_2e_i_2e_i23;
  }

llvm_cbe_bb16:
  llvm_cbe_c_2e_0_2e_reload25 = *(&llvm_cbe_c_2e_0_2e_reg2mem);
  llvm_cbe_tmp171821 = ((signed long long )(signed char )llvm_cbe_c_2e_0_2e_reload25);
  llvm_cbe_tmp3_2e_i = *((&llvm_cbe_this->field0[((signed long long )llvm_cbe_tmp171821)].field0.field1));
  if ((((signed int )llvm_cbe_tmp3_2e_i) < ((signed int )2u))) {
    goto llvm_cbe_bb63;
  } else {
    goto llvm_cbe_bb34;
  }

llvm_cbe_bb11_2e_thread:
  *(&llvm_cbe_c_2e_0_2e_reg2mem) = ((unsigned char )32);
  goto llvm_cbe_bb16;

llvm_cbe_bb:
  llvm_cbe_tmp4 = _ZNKSsixEm(llvm_cbe_text, llvm_cbe_tmp8384);
  llvm_cbe_tmp5 = *llvm_cbe_tmp4;
  switch (llvm_cbe_tmp5) {
  default:
    llvm_cbe_c_2e_0__PHI_TEMPORARY = llvm_cbe_tmp5;   /* for PHI node */
    goto llvm_cbe_bb11;
;
  case ((unsigned char )95):
    goto llvm_cbe_bb11_2e_thread;
  case ((unsigned char )97):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )98):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )99):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )100):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )101):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )102):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )103):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )104):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )105):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )106):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )107):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )108):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )109):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )110):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )111):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )112):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )113):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )114):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )115):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )116):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )117):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )118):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )119):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )120):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )121):
    goto llvm_cbe_bb7;
    break;
  case ((unsigned char )122):
    goto llvm_cbe_bb7;
    break;
  }
llvm_cbe_bb11:
  llvm_cbe_c_2e_0 = llvm_cbe_c_2e_0__PHI_TEMPORARY;
  *(&llvm_cbe_c_2e_0_2e_reg2mem) = llvm_cbe_c_2e_0;
  if ((((signed char )llvm_cbe_c_2e_0) < ((signed char )((unsigned char )0)))) {
    goto llvm_cbe_bb63;
  } else {
    goto llvm_cbe_bb16;
  }

llvm_cbe_bb7:
  llvm_cbe_tmp9 = ((unsigned char )(llvm_cbe_tmp5 + ((unsigned char )-32)));
  llvm_cbe_c_2e_0__PHI_TEMPORARY = llvm_cbe_tmp9;   /* for PHI node */
  goto llvm_cbe_bb11;

llvm_cbe_bb_2e_i_2e_i23:
  llvm_cbe_tmp7_2e_i_2e_i21 = *llvm_cbe_tmp6_2e_i_2e_i20;
  free((((unsigned char *)llvm_cbe_tmp7_2e_i_2e_i21)));
  goto llvm_cbe_bb79;

llvm_cbe_bb63:
  llvm_cbe_c_2e_0_2e_reload = *(&llvm_cbe_c_2e_0_2e_reg2mem);
  if ((llvm_cbe_c_2e_0_2e_reload == ((unsigned char )32))) {
    goto llvm_cbe_bb68;
  } else {
    goto llvm_cbe_bb79;
  }

llvm_cbe_bb68:
  llvm_cbe_tmp71 = *llvm_cbe_tmp70;
  llvm_cbe_tmp = _ZNK4Path4bboxEv(llvm_cbe_tmp74);
  llvm_cbe_tmp4_2e_i = *llvm_cbe_tmp3_2e_i3;
  llvm_cbe_tmp8_2e_i = *llvm_cbe_tmp7_2e_i;
  *llvm_cbe_tmp70 = (llvm_cbe_tmp71 + ((llvm_cbe_tmp4_2e_i - llvm_cbe_tmp8_2e_i) + 1u));
  goto llvm_cbe_bb79;

  } while (1); /* end of syntactic loop 'bb82' */
llvm_cbe_return:
  return;
}


static struct l_struct_2E_std_3A__3A_string _ZN6Config8findFileERKSs(struct l_struct_2E_std_3A__3A_string *llvm_cbe_name) {
  struct l_struct_2E_std_3A__3A_string StructReturn;  /* Struct return temporary */
  struct l_struct_2E_std_3A__3A_string *llvm_cbe_agg_2e_result = &StructReturn;
  struct l_struct_2E_std_3A__3A_string llvm_cbe_p;    /* Address-exposed local */
  struct l_struct_2E_std_3A__3A_string llvm_cbe_tmp;    /* Address-exposed local */
  struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ llvm_cbe_tmp18;    /* Address-exposed local */
  struct l_struct_2E_std_3A__3A_string llvm_cbe_tmp20;    /* Address-exposed local */
  struct l_struct_2E_std_3A__3A_string llvm_cbe_tmp22;    /* Address-exposed local */
  struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ llvm_cbe_tmp24;    /* Address-exposed local */
  struct l_struct_2E_std_3A__3A_string *llvm_cbe_tmp9_2e_i;
  unsigned char *llvm_cbe_tmp34;
  struct l_struct_2E_FILE *llvm_cbe_tmp37;
  struct l_struct_2E_std_3A__3A_string *llvm_cbe_tmp52;
  struct l_struct_2E_std_3A__3A_string *llvm_cbe_tmp9_2e_i38;
  unsigned char *llvm_cbe_tmp69;
  struct l_struct_2E_FILE *llvm_cbe_tmp72;
  struct l_struct_2E_FILE *llvm_cbe_fd_2e_0;
  struct l_struct_2E_FILE *llvm_cbe_fd_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp87;
  struct l_struct_2E_std_3A__3A_string *llvm_cbe_tmp9_2e_i14;

  _ZNSaIcEC1Ev((&llvm_cbe_tmp24));
  _ZNSsC1EPKcRKSaIcE((&llvm_cbe_p), ((&_2E_str1[((signed long long )0ull)])), (&llvm_cbe_tmp24));
  _ZNSaIcED1Ev((&llvm_cbe_tmp24));
  _ZNSsC1ERKSs((&llvm_cbe_tmp22), (&llvm_cbe_p));
  llvm_cbe_tmp9_2e_i = _ZNSs6appendERKSs((&llvm_cbe_tmp22), llvm_cbe_name);
  llvm_cbe_tmp34 = _ZNKSs5c_strEv((&llvm_cbe_tmp22));
  llvm_cbe_tmp37 = fopen(llvm_cbe_tmp34, ((&_2E_str265[((signed long long )0ull)])));
  _ZNSsD1Ev((&llvm_cbe_tmp22));
  if ((llvm_cbe_tmp37 == ((struct l_struct_2E_FILE *)/*NULL*/0))) {
    goto llvm_cbe_bb48;
  } else {
    llvm_cbe_fd_2e_0__PHI_TEMPORARY = llvm_cbe_tmp37;   /* for PHI node */
    goto llvm_cbe_bb79;
  }

llvm_cbe_bb48:
  _ZNSaIcEC1Ev((&llvm_cbe_tmp18));
  _ZNSsC1EPKcRKSaIcE((&llvm_cbe_tmp20), ((&_2E_str12[((signed long long )0ull)])), (&llvm_cbe_tmp18));
  llvm_cbe_tmp52 = _ZNSsaSERKSs((&llvm_cbe_p), (&llvm_cbe_tmp20));
  _ZNSsD1Ev((&llvm_cbe_tmp20));
  _ZNSaIcED1Ev((&llvm_cbe_tmp18));
  _ZNSsC1ERKSs((&llvm_cbe_tmp), (&llvm_cbe_p));
  llvm_cbe_tmp9_2e_i38 = _ZNSs6appendERKSs((&llvm_cbe_tmp), llvm_cbe_name);
  llvm_cbe_tmp69 = _ZNKSs5c_strEv((&llvm_cbe_tmp));
  llvm_cbe_tmp72 = fopen(llvm_cbe_tmp69, ((&_2E_str265[((signed long long )0ull)])));
  _ZNSsD1Ev((&llvm_cbe_tmp));
  llvm_cbe_fd_2e_0__PHI_TEMPORARY = llvm_cbe_tmp72;   /* for PHI node */
  goto llvm_cbe_bb79;

llvm_cbe_bb79:
  llvm_cbe_fd_2e_0 = llvm_cbe_fd_2e_0__PHI_TEMPORARY;
  if ((llvm_cbe_fd_2e_0 == ((struct l_struct_2E_FILE *)/*NULL*/0))) {
    goto llvm_cbe_bb91;
  } else {
    goto llvm_cbe_bb84;
  }

llvm_cbe_bb84:
  llvm_cbe_tmp87 = fclose(llvm_cbe_fd_2e_0);
  _ZNSsC1ERKSs(llvm_cbe_agg_2e_result, (&llvm_cbe_p));
  llvm_cbe_tmp9_2e_i14 = _ZNSs6appendERKSs(llvm_cbe_agg_2e_result, llvm_cbe_name);
  goto llvm_cbe_bb100;

llvm_cbe_bb91:
  _ZNSsC1ERKSs(llvm_cbe_agg_2e_result, llvm_cbe_name);
  goto llvm_cbe_bb100;

llvm_cbe_bb100:
  _ZNSsD1Ev((&llvm_cbe_p));
  return StructReturn;
}


static unsigned int _ZN6Levels9findLevelEPKc(struct l_struct_2E_Levels *llvm_cbe_this, unsigned char *llvm_cbe_file) {
  unsigned int *llvm_cbe_tmp2_2e_i3;
  struct l_struct_2E_Levels_3A__3A_LevelDesc ***llvm_cbe_tmp2_2e_i_2e_i;
  struct l_struct_2E_Levels_3A__3A_LevelDesc **llvm_cbe_tmp3_2e_i_2e_i;
  struct l_struct_2E_Levels_3A__3A_LevelDesc *llvm_cbe_tmp5;
  unsigned int llvm_cbe_tmp3_2e_i8;
  unsigned int llvm_cbe_tmp14;
  unsigned int llvm_cbe_storemerge1;
  unsigned int llvm_cbe_storemerge1__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp3_2e_i;
  unsigned int llvm_cbe_storemerge;
  unsigned int llvm_cbe_storemerge__PHI_TEMPORARY;

  llvm_cbe_tmp2_2e_i3 = (&llvm_cbe_this->field0.field1);
  llvm_cbe_tmp2_2e_i_2e_i = (&llvm_cbe_this->field0.field0);
  llvm_cbe_storemerge1__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb15;

  do {     /* Syntactic loop 'bb15' to make GCC happy */
llvm_cbe_bb15:
  llvm_cbe_storemerge1 = llvm_cbe_storemerge1__PHI_TEMPORARY;
  llvm_cbe_tmp3_2e_i = *llvm_cbe_tmp2_2e_i3;
  if ((((signed int )llvm_cbe_tmp3_2e_i) > ((signed int )llvm_cbe_storemerge1))) {
    goto llvm_cbe_bb;
  } else {
    llvm_cbe_storemerge__PHI_TEMPORARY = 4294967295u;   /* for PHI node */
    goto llvm_cbe_return;
  }

llvm_cbe_bb12:
  llvm_cbe_tmp14 = llvm_cbe_storemerge1 + 1u;
  llvm_cbe_storemerge1__PHI_TEMPORARY = llvm_cbe_tmp14;   /* for PHI node */
  goto llvm_cbe_bb15;

llvm_cbe_bb:
  llvm_cbe_tmp3_2e_i_2e_i = *llvm_cbe_tmp2_2e_i_2e_i;
  llvm_cbe_tmp5 = *((&llvm_cbe_tmp3_2e_i_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge1)))]));
  llvm_cbe_tmp3_2e_i8 = _ZNKSs7compareEPKc(((&llvm_cbe_tmp5->field0)), llvm_cbe_file);
  if ((llvm_cbe_tmp3_2e_i8 == 0u)) {
    llvm_cbe_storemerge__PHI_TEMPORARY = llvm_cbe_storemerge1;   /* for PHI node */
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb12;
  }

  } while (1); /* end of syntactic loop 'bb15' */
llvm_cbe_return:
  llvm_cbe_storemerge = llvm_cbe_storemerge__PHI_TEMPORARY;
  return llvm_cbe_storemerge;
}


static void _ZN7ZipFileC1ERKSs(struct l_struct_2E_ZipFile *llvm_cbe_this, struct l_struct_2E_std_3A__3A_string *llvm_cbe_fn) {
  struct l_struct_2E_stat llvm_cbe_stat;    /* Address-exposed local */
  unsigned char *llvm_cbe_tmp5;
  unsigned int llvm_cbe_tmp6;
  unsigned int *llvm_cbe_tmp8;
  unsigned int llvm_cbe_tmp12;
  unsigned long long llvm_cbe_tmp14;
  unsigned int llvm_cbe_tmp1415;
  unsigned int *llvm_cbe_tmp17;
  unsigned int llvm_cbe_tmp20;
  unsigned char *llvm_cbe_tmp25;
  unsigned char *llvm_cbe_tmp33;
  unsigned int llvm_cbe_tmp44;
  unsigned char *llvm_cbe_tmp49;
  unsigned int llvm_cbe_tmp60;
  unsigned char *llvm_cbe_tmp63;
  struct l_struct_2E_zip_eoc *llvm_cbe_tmp6364;
  unsigned int llvm_cbe_tmp74;
  unsigned char *llvm_cbe_tmp76;
  unsigned short llvm_cbe_tmp98;

  *((&llvm_cbe_this->field6)) = ((unsigned char *)/*NULL*/0);
  llvm_cbe_tmp5 = _ZNKSs5c_strEv(llvm_cbe_fn);
  llvm_cbe_tmp6 = open(llvm_cbe_tmp5, 0u);
  llvm_cbe_tmp8 = (&llvm_cbe_this->field0);
  *llvm_cbe_tmp8 = llvm_cbe_tmp6;
  llvm_cbe_tmp12 = fstat(llvm_cbe_tmp6, (&llvm_cbe_stat));
  llvm_cbe_tmp14 = *((&llvm_cbe_stat.field8));
  llvm_cbe_tmp1415 = ((unsigned int )llvm_cbe_tmp14);
  llvm_cbe_tmp17 = (&llvm_cbe_this->field1);
  *llvm_cbe_tmp17 = llvm_cbe_tmp1415;
  llvm_cbe_tmp20 = *llvm_cbe_tmp8;
  llvm_cbe_tmp25 = mmap(((unsigned char *)/*NULL*/0), (((signed long long )(signed int )llvm_cbe_tmp1415)), 1u, 2u, llvm_cbe_tmp20, 0ull);
  *((&llvm_cbe_this->field2)) = llvm_cbe_tmp25;
  if ((llvm_cbe_tmp25 == ((unsigned char *)/*NULL*/0))) {
    goto llvm_cbe_bb;
  } else {
    goto llvm_cbe_bb38;
  }

llvm_cbe_bb:
  llvm_cbe_tmp33 = __cxa_allocate_exception(8ull);
  *(((unsigned char **)llvm_cbe_tmp33)) = ((&_2E_str22[((signed long long )0ull)]));
  __cxa_throw(llvm_cbe_tmp33, ((unsigned char *)(&_ZTIPc)), ((void  (*) (unsigned char *))/*NULL*/0));
  /*UNREACHABLE*/;
llvm_cbe_bb38:
  llvm_cbe_tmp44 = *(((unsigned int *)llvm_cbe_tmp25));
  if ((llvm_cbe_tmp44 == 67324752u)) {
    goto llvm_cbe_bb54;
  } else {
    goto llvm_cbe_bb48;
  }

llvm_cbe_bb48:
  llvm_cbe_tmp49 = __cxa_allocate_exception(8ull);
  *(((unsigned char **)llvm_cbe_tmp49)) = ((&_2E_str123[((signed long long )0ull)]));
  __cxa_throw(llvm_cbe_tmp49, ((unsigned char *)(&_ZTIPc)), ((void  (*) (unsigned char *))/*NULL*/0));
  /*UNREACHABLE*/;
llvm_cbe_bb54:
  llvm_cbe_tmp60 = *llvm_cbe_tmp17;
  llvm_cbe_tmp63 = (&llvm_cbe_tmp25[((signed long long )((((signed long long )(signed int )llvm_cbe_tmp60)) + 18446744073709551594ull))]);
  llvm_cbe_tmp6364 = ((struct l_struct_2E_zip_eoc *)llvm_cbe_tmp63);
  *((&llvm_cbe_this->field3)) = llvm_cbe_tmp6364;
  llvm_cbe_tmp74 = ((struct __attribute__ ((packed, aligned(1))) {unsigned int data; } *)((&llvm_cbe_tmp6364->field6)))->data;
  llvm_cbe_tmp76 = (&llvm_cbe_tmp25[((signed long long )(((unsigned long long )(unsigned int )llvm_cbe_tmp74)))]);
  *((&llvm_cbe_this->field4)) = (((struct l_struct_2E_zip_cd *)llvm_cbe_tmp76));
  if (((((llvm_cbe_tmp63 == ((unsigned char *)/*NULL*/0)) | (llvm_cbe_tmp76 == ((unsigned char *)/*NULL*/0)))&1))) {
    goto llvm_cbe_bb102;
  } else {
    goto llvm_cbe_bb93;
  }

llvm_cbe_bb93:
  llvm_cbe_tmp98 = ((struct __attribute__ ((packed, aligned(1))) {unsigned short data; } *)((&llvm_cbe_tmp6364->field3)))->data;
  *((&llvm_cbe_this->field5)) = (((unsigned int )(unsigned short )llvm_cbe_tmp98));
  return;
llvm_cbe_bb102:
  *((&llvm_cbe_this->field5)) = 0u;
  return;
}


static struct l_struct_2E_std_3A__3A_string _ZN7ZipFile9entryNameEi(struct l_struct_2E_ZipFile *llvm_cbe_this, unsigned int llvm_cbe_n) {
  struct l_struct_2E_std_3A__3A_string StructReturn;  /* Struct return temporary */
  struct l_struct_2E_std_3A__3A_string *llvm_cbe_agg_2e_result = &StructReturn;
  struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ llvm_cbe_tmp;    /* Address-exposed local */
  unsigned int llvm_cbe_tmp14;
  struct l_struct_2E_zip_cd *llvm_cbe_tmp24;
  struct l_struct_2E_zip_eoc *llvm_cbe_tmp53;
  struct l_struct_2E_zip_cd *llvm_cbe_tmp5354;
  unsigned short llvm_cbe_tmp31;
  unsigned short llvm_cbe_tmp37;
  unsigned short llvm_cbe_tmp43;
  struct l_struct_2E_zip_cd *llvm_cbe_tmp4647;
  unsigned int llvm_cbe_tmp49;
  struct l_struct_2E_zip_cd *llvm_cbe_cd_2e_0;
  struct l_struct_2E_zip_cd *llvm_cbe_cd_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge;
  unsigned int llvm_cbe_storemerge__PHI_TEMPORARY;
  unsigned char *llvm_cbe_tmp68;
  unsigned int llvm_cbe_tmp71;
  unsigned char *llvm_cbe_tmp73;
  struct l_struct_2E_zip_lfh *llvm_cbe_tmp7374;
  unsigned short llvm_cbe_tmp83;

  if ((((signed int )llvm_cbe_n) < ((signed int )0u))) {
    goto llvm_cbe_bb19;
  } else {
    goto llvm_cbe_bb;
  }

llvm_cbe_bb:
  llvm_cbe_tmp14 = *((&llvm_cbe_this->field5));
  if ((((signed int )llvm_cbe_tmp14) > ((signed int )llvm_cbe_n))) {
    goto llvm_cbe_bb21;
  } else {
    goto llvm_cbe_bb19;
  }

llvm_cbe_bb19:
  _ZNSsC1Ev(llvm_cbe_agg_2e_result);
  return StructReturn;
llvm_cbe_bb21:
  llvm_cbe_tmp24 = *((&llvm_cbe_this->field4));
  llvm_cbe_tmp53 = *((&llvm_cbe_this->field3));
  llvm_cbe_tmp5354 = ((struct l_struct_2E_zip_cd *)llvm_cbe_tmp53);
  llvm_cbe_cd_2e_0__PHI_TEMPORARY = llvm_cbe_tmp24;   /* for PHI node */
  llvm_cbe_storemerge__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb50;

  do {     /* Syntactic loop 'bb50' to make GCC happy */
llvm_cbe_bb50:
  llvm_cbe_cd_2e_0 = llvm_cbe_cd_2e_0__PHI_TEMPORARY;
  llvm_cbe_storemerge = llvm_cbe_storemerge__PHI_TEMPORARY;
  if (((((((unsigned long long )llvm_cbe_tmp5354) > ((unsigned long long )llvm_cbe_cd_2e_0)) & (((signed int )llvm_cbe_storemerge) < ((signed int )llvm_cbe_n)))&1))) {
    goto llvm_cbe_bb25;
  } else {
    goto llvm_cbe_bb65;
  }

llvm_cbe_bb25:
  llvm_cbe_tmp31 = ((struct __attribute__ ((packed, aligned(1))) {unsigned short data; } *)((&llvm_cbe_cd_2e_0->field12)))->data;
  llvm_cbe_tmp37 = ((struct __attribute__ ((packed, aligned(1))) {unsigned short data; } *)((&llvm_cbe_cd_2e_0->field13)))->data;
  llvm_cbe_tmp43 = ((struct __attribute__ ((packed, aligned(1))) {unsigned short data; } *)((&llvm_cbe_cd_2e_0->field14)))->data;
  llvm_cbe_tmp4647 = ((struct l_struct_2E_zip_cd *)((&(((unsigned char *)llvm_cbe_cd_2e_0))[((signed long long )((((((unsigned long long )(unsigned short )llvm_cbe_tmp31)) + 46ull) + (((unsigned long long )(unsigned short )llvm_cbe_tmp37))) + (((unsigned long long )(unsigned short )llvm_cbe_tmp43))))])));
  llvm_cbe_tmp49 = llvm_cbe_storemerge + 1u;
  llvm_cbe_cd_2e_0__PHI_TEMPORARY = llvm_cbe_tmp4647;   /* for PHI node */
  llvm_cbe_storemerge__PHI_TEMPORARY = llvm_cbe_tmp49;   /* for PHI node */
  goto llvm_cbe_bb50;

  } while (1); /* end of syntactic loop 'bb50' */
llvm_cbe_bb65:
  llvm_cbe_tmp68 = *((&llvm_cbe_this->field2));
  llvm_cbe_tmp71 = ((struct __attribute__ ((packed, aligned(1))) {unsigned int data; } *)((&llvm_cbe_cd_2e_0->field18)))->data;
  llvm_cbe_tmp73 = (&llvm_cbe_tmp68[((signed long long )(((unsigned long long )(unsigned int )llvm_cbe_tmp71)))]);
  llvm_cbe_tmp7374 = ((struct l_struct_2E_zip_lfh *)llvm_cbe_tmp73);
  if ((llvm_cbe_tmp73 == ((unsigned char *)/*NULL*/0))) {
    goto llvm_cbe_bb93;
  } else {
    goto llvm_cbe_bb79;
  }

llvm_cbe_bb79:
  _ZNSaIcEC1Ev((&llvm_cbe_tmp));
  llvm_cbe_tmp83 = ((struct __attribute__ ((packed, aligned(1))) {unsigned short data; } *)((&llvm_cbe_tmp7374->field9)))->data;
  _ZNSsC1EPKcmRKSaIcE(llvm_cbe_agg_2e_result, ((&llvm_cbe_tmp7374->field11[((signed long long )0ull)])), (((unsigned long long )(unsigned short )llvm_cbe_tmp83)), (&llvm_cbe_tmp));
  _ZNSaIcED1Ev((&llvm_cbe_tmp));
  return StructReturn;
llvm_cbe_bb93:
  _ZNSsC1Ev(llvm_cbe_agg_2e_result);
  return StructReturn;
}


static unsigned int _ZL12rankFromPathRKSsi(struct l_struct_2E_std_3A__3A_string *llvm_cbe_p, unsigned int llvm_cbe_defaultrank) {
  unsigned char *llvm_cbe_tmp2;
  unsigned long long llvm_cbe_tmp7;
  unsigned char *llvm_cbe_tmp14;
  unsigned char llvm_cbe_tmp16;
  unsigned int llvm_cbe_tmp31;
  unsigned int llvm_cbe_rank_2e_0;
  unsigned int llvm_cbe_rank_2e_0__PHI_TEMPORARY;
  unsigned char *llvm_cbe_tmp14_2e_pn;
  unsigned char *llvm_cbe_tmp14_2e_pn__PHI_TEMPORARY;
  unsigned char *llvm_cbe_c_2e_0;
  unsigned char llvm_cbe_tmp36;
  unsigned int llvm_cbe_storemerge;
  unsigned int llvm_cbe_storemerge__PHI_TEMPORARY;

  llvm_cbe_tmp2 = _ZNKSs4dataEv(llvm_cbe_p);
  llvm_cbe_tmp7 = _ZNKSs5rfindEcm(llvm_cbe_p, ((unsigned char )47), 18446744073709551615ull);
  if ((llvm_cbe_tmp7 == 18446744073709551615ull)) {
    llvm_cbe_storemerge__PHI_TEMPORARY = llvm_cbe_defaultrank;   /* for PHI node */
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb;
  }

llvm_cbe_bb:
  llvm_cbe_tmp14 = (&llvm_cbe_tmp2[((signed long long )(llvm_cbe_tmp7 + 1ull))]);
  llvm_cbe_tmp16 = *llvm_cbe_tmp14;
  if ((llvm_cbe_tmp16 == ((unsigned char )76))) {
    llvm_cbe_rank_2e_0__PHI_TEMPORARY = 0u;   /* for PHI node */
    llvm_cbe_tmp14_2e_pn__PHI_TEMPORARY = llvm_cbe_tmp14;   /* for PHI node */
    goto llvm_cbe_bb34;
  } else {
    llvm_cbe_storemerge__PHI_TEMPORARY = llvm_cbe_defaultrank;   /* for PHI node */
    goto llvm_cbe_return;
  }

  do {     /* Syntactic loop 'bb34' to make GCC happy */
llvm_cbe_bb34:
  llvm_cbe_rank_2e_0 = llvm_cbe_rank_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp14_2e_pn = llvm_cbe_tmp14_2e_pn__PHI_TEMPORARY;
  llvm_cbe_c_2e_0 = (&llvm_cbe_tmp14_2e_pn[((signed long long )1ull)]);
  llvm_cbe_tmp36 = *llvm_cbe_c_2e_0;
  if ((((unsigned char )(((unsigned char )(llvm_cbe_tmp36 + ((unsigned char )-48))))) < ((unsigned char )((unsigned char )10)))) {
    goto llvm_cbe_bb24;
  } else {
    llvm_cbe_storemerge__PHI_TEMPORARY = llvm_cbe_rank_2e_0;   /* for PHI node */
    goto llvm_cbe_return;
  }

llvm_cbe_bb24:
  llvm_cbe_tmp31 = ((llvm_cbe_rank_2e_0 * 10u) + (((signed int )(signed char )llvm_cbe_tmp36))) + 4294967248u;
  llvm_cbe_rank_2e_0__PHI_TEMPORARY = llvm_cbe_tmp31;   /* for PHI node */
  llvm_cbe_tmp14_2e_pn__PHI_TEMPORARY = llvm_cbe_c_2e_0;   /* for PHI node */
  goto llvm_cbe_bb34;

  } while (1); /* end of syntactic loop 'bb34' */
llvm_cbe_return:
  llvm_cbe_storemerge = llvm_cbe_storemerge__PHI_TEMPORARY;
  return llvm_cbe_storemerge;
}


static unsigned int _ZN6Levels4loadEiPhi(struct l_struct_2E_Levels *llvm_cbe_this, unsigned int llvm_cbe_i) {
  unsigned int llvm_cbe_l_2e_4_2e_reg2mem;    /* Address-exposed local */
  struct l_struct_2E_z_stream llvm_cbe_stream_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_ZipFile llvm_cbe_zf;    /* Address-exposed local */
  struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ llvm_cbe_tmp2;    /* Address-exposed local */
  struct l_struct_2E_std_3A__3A_string llvm_cbe_tmp3;    /* Address-exposed local */
  unsigned int llvm_cbe_tmp3_2e_i;
  struct l_struct_2E_Levels_3A__3A_LevelDesc ***llvm_cbe_tmp2_2e_i_2e_i120;
  struct l_struct_2E_Levels_3A__3A_LevelDesc **llvm_cbe_tmp3_2e_i_2e_i121;
  unsigned long long llvm_cbe_tmp45_2e_i_2e_i123;
  struct l_struct_2E_Levels_3A__3A_LevelDesc *llvm_cbe_tmp15;
  unsigned int llvm_cbe_tmp17;
  struct l_struct_2E_Levels_3A__3A_LevelDesc **llvm_cbe_tmp3_2e_i_2e_i137;
  struct l_struct_2E_Levels_3A__3A_LevelDesc *llvm_cbe_tmp27;
  unsigned char *llvm_cbe_tmp30;
  struct l_struct_2E_Levels_3A__3A_LevelDesc **llvm_cbe_tmp3_2e_i_2e_i105;
  struct l_struct_2E_Levels_3A__3A_LevelDesc *llvm_cbe_tmp49;
  unsigned int llvm_cbe_tmp51;
  unsigned int llvm_cbe_tmp3_2e_i93;
  struct l_struct_2E_zip_cd *llvm_cbe_tmp16_2e_i53;
  struct l_struct_2E_zip_eoc *llvm_cbe_tmp46_2e_i;
  struct l_struct_2E_zip_cd *llvm_cbe_tmp4647_2e_i;
  unsigned short llvm_cbe_tmp23_2e_i58;
  unsigned short llvm_cbe_tmp29_2e_i;
  unsigned short llvm_cbe_tmp36_2e_i63;
  struct l_struct_2E_zip_cd *llvm_cbe_tmp3940_2e_i;
  unsigned int llvm_cbe_tmp42_2e_i;
  struct l_struct_2E_zip_cd *llvm_cbe_cd_2e_i_2e_0;
  struct l_struct_2E_zip_cd *llvm_cbe_cd_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge_2e_i;
  unsigned int llvm_cbe_storemerge_2e_i__PHI_TEMPORARY;
  unsigned char *llvm_cbe_tmp61_2e_i;
  unsigned int llvm_cbe_tmp64_2e_i;
  unsigned long long llvm_cbe_tmp6465_2e_i;
  unsigned char *llvm_cbe_tmp66_2e_i;
  struct l_struct_2E_zip_lfh *llvm_cbe_tmp6667_2e_i;
  unsigned int llvm_cbe_tmp75_2e_i;
  unsigned short llvm_cbe_tmp82_2e_i;
  unsigned short llvm_cbe_tmp88_2e_i;
  unsigned char *llvm_cbe_tmp91_2e_i;
  unsigned short llvm_cbe_tmp94_2e_i;
  unsigned char **llvm_cbe_tmp99_2e_i;
  unsigned char *llvm_cbe_tmp100_2e_i;
  unsigned char *llvm_cbe_tmp113_2e_i70;
  unsigned int llvm_cbe_tmp118_2e_i;
  unsigned int *llvm_cbe_tmp4_2e_i_2e_i67;
  unsigned int llvm_cbe_tmp13_2e_i_2e_i71;
  unsigned int llvm_cbe_tmp19_2e_i_2e_i72;
  unsigned int llvm_cbe_tmp25_2e_i_2e_i73;
  unsigned int llvm_cbe_tmp37_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp46_2e_i_2e_i;
  unsigned int llvm_cbe_tmp4647_2e_i_2e_i;
  unsigned int llvm_cbe_tmp49_2e_i_2e_i74;
  unsigned int llvm_cbe_l_2e_4;
  unsigned int llvm_cbe_l_2e_4__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp_2e_i_2e_i_2e_0;
  unsigned int llvm_cbe_tmp_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_l_2e_4_2e_reload143;
  unsigned char *llvm_cbe_tmp132_2e_i;
  unsigned int llvm_cbe_l_2e_4_2e_reload;
  unsigned int llvm_cbe_l_2e_1;
  unsigned int llvm_cbe_l_2e_1__PHI_TEMPORARY;
  unsigned char *llvm_cbe_tmp1_2e_i45_2e_0;
  unsigned char *llvm_cbe_tmp1_2e_i45_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_l_2e_2;
  unsigned int llvm_cbe_l_2e_2__PHI_TEMPORARY;
  unsigned char *ltmp_4_1;
  unsigned int llvm_cbe_l_2e_3;
  unsigned int llvm_cbe_l_2e_3__PHI_TEMPORARY;
  unsigned char *llvm_cbe_tmp2_2e_i11;
  unsigned char *llvm_cbe_tmp11_2e_i19;
  unsigned int llvm_cbe_tmp18_2e_i24;
  unsigned int llvm_cbe_tmp23_2e_i29;
  unsigned int llvm_cbe_tmp27_2e_i33;
  unsigned int llvm_cbe_tmp36_2e_i39;
  unsigned char *llvm_cbe_tmp96;
  struct l_struct_2E_FILE *llvm_cbe_tmp98;
  unsigned long long llvm_cbe_tmp108;
  unsigned int llvm_cbe_tmp111;
  unsigned char *llvm_cbe_tmp116;
  unsigned int llvm_cbe_l_2e_0;
  unsigned int llvm_cbe_l_2e_0__PHI_TEMPORARY;

  llvm_cbe_tmp3_2e_i = *((&llvm_cbe_this->field0.field1));
  if ((((signed int )llvm_cbe_tmp3_2e_i) > ((signed int )llvm_cbe_i))) {
    goto llvm_cbe_bb;
  } else {
    goto llvm_cbe_bb115;
  }

llvm_cbe_bb:
  llvm_cbe_tmp2_2e_i_2e_i120 = (&llvm_cbe_this->field0.field0);
  llvm_cbe_tmp3_2e_i_2e_i121 = *llvm_cbe_tmp2_2e_i_2e_i120;
  llvm_cbe_tmp45_2e_i_2e_i123 = ((signed long long )(signed int )llvm_cbe_i);
  llvm_cbe_tmp15 = *((&llvm_cbe_tmp3_2e_i_2e_i121[((signed long long )llvm_cbe_tmp45_2e_i_2e_i123)]));
  llvm_cbe_tmp17 = *((&llvm_cbe_tmp15->field1));
  if ((((signed int )llvm_cbe_tmp17) > ((signed int )4294967295u))) {
    goto llvm_cbe_bb22;
  } else {
    goto llvm_cbe_bb89;
  }

llvm_cbe_bb22:
  _ZNSaIcEC1Ev((&llvm_cbe_tmp2));
  llvm_cbe_tmp3_2e_i_2e_i137 = *llvm_cbe_tmp2_2e_i_2e_i120;
  llvm_cbe_tmp27 = *((&llvm_cbe_tmp3_2e_i_2e_i137[((signed long long )llvm_cbe_tmp45_2e_i_2e_i123)]));
  llvm_cbe_tmp30 = _ZNKSs5c_strEv(((&llvm_cbe_tmp27->field0)));
  _ZNSsC1EPKcRKSaIcE((&llvm_cbe_tmp3), llvm_cbe_tmp30, (&llvm_cbe_tmp2));
  _ZN7ZipFileC1ERKSs((&llvm_cbe_zf), (&llvm_cbe_tmp3));
  _ZNSsD1Ev((&llvm_cbe_tmp3));
  _ZNSaIcED1Ev((&llvm_cbe_tmp2));
  llvm_cbe_tmp3_2e_i_2e_i105 = *llvm_cbe_tmp2_2e_i_2e_i120;
  llvm_cbe_tmp49 = *((&llvm_cbe_tmp3_2e_i_2e_i105[((signed long long )llvm_cbe_tmp45_2e_i_2e_i123)]));
  llvm_cbe_tmp51 = *((&llvm_cbe_tmp49->field1));
  llvm_cbe_tmp3_2e_i93 = *((&llvm_cbe_zf.field5));
  if ((((signed int )llvm_cbe_tmp51) < ((signed int )llvm_cbe_tmp3_2e_i93))) {
    goto llvm_cbe_invcont61;
  } else {
    llvm_cbe_l_2e_3__PHI_TEMPORARY = 0u;   /* for PHI node */
    goto llvm_cbe_bb83;
  }

llvm_cbe_invcont61:
  if (((((((signed int )llvm_cbe_tmp3_2e_i93) > ((signed int )llvm_cbe_tmp51)) & (((signed int )llvm_cbe_tmp51) > ((signed int )4294967295u)))&1))) {
    goto llvm_cbe_bb13_2e_i;
  } else {
    llvm_cbe_tmp1_2e_i45_2e_0__PHI_TEMPORARY = ((unsigned char *)/*NULL*/0);   /* for PHI node */
    llvm_cbe_l_2e_2__PHI_TEMPORARY = 0u;   /* for PHI node */
    goto llvm_cbe_invcont66;
  }

llvm_cbe_bb13_2e_i:
  llvm_cbe_tmp16_2e_i53 = *((&llvm_cbe_zf.field4));
  llvm_cbe_tmp46_2e_i = *((&llvm_cbe_zf.field3));
  llvm_cbe_tmp4647_2e_i = ((struct l_struct_2E_zip_cd *)llvm_cbe_tmp46_2e_i);
  llvm_cbe_cd_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp16_2e_i53;   /* for PHI node */
  llvm_cbe_storemerge_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb43_2e_i;

  do {     /* Syntactic loop 'bb43.i' to make GCC happy */
llvm_cbe_bb43_2e_i:
  llvm_cbe_cd_2e_i_2e_0 = llvm_cbe_cd_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_storemerge_2e_i = llvm_cbe_storemerge_2e_i__PHI_TEMPORARY;
  if (((((((unsigned long long )llvm_cbe_tmp4647_2e_i) > ((unsigned long long )llvm_cbe_cd_2e_i_2e_0)) & (((signed int )llvm_cbe_storemerge_2e_i) < ((signed int )llvm_cbe_tmp51)))&1))) {
    goto llvm_cbe_bb17_2e_i;
  } else {
    goto llvm_cbe_bb58_2e_i;
  }

llvm_cbe_bb17_2e_i:
  llvm_cbe_tmp23_2e_i58 = ((struct __attribute__ ((packed, aligned(1))) {unsigned short data; } *)((&llvm_cbe_cd_2e_i_2e_0->field12)))->data;
  llvm_cbe_tmp29_2e_i = ((struct __attribute__ ((packed, aligned(1))) {unsigned short data; } *)((&llvm_cbe_cd_2e_i_2e_0->field13)))->data;
  llvm_cbe_tmp36_2e_i63 = ((struct __attribute__ ((packed, aligned(1))) {unsigned short data; } *)((&llvm_cbe_cd_2e_i_2e_0->field14)))->data;
  llvm_cbe_tmp3940_2e_i = ((struct l_struct_2E_zip_cd *)((&(((unsigned char *)llvm_cbe_cd_2e_i_2e_0))[((signed long long )((((((unsigned long long )(unsigned short )llvm_cbe_tmp23_2e_i58)) + 46ull) + (((unsigned long long )(unsigned short )llvm_cbe_tmp29_2e_i))) + (((unsigned long long )(unsigned short )llvm_cbe_tmp36_2e_i63))))])));
  llvm_cbe_tmp42_2e_i = llvm_cbe_storemerge_2e_i + 1u;
  llvm_cbe_cd_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp3940_2e_i;   /* for PHI node */
  llvm_cbe_storemerge_2e_i__PHI_TEMPORARY = llvm_cbe_tmp42_2e_i;   /* for PHI node */
  goto llvm_cbe_bb43_2e_i;

  } while (1); /* end of syntactic loop 'bb43.i' */
llvm_cbe_bb58_2e_i:
  llvm_cbe_tmp61_2e_i = *((&llvm_cbe_zf.field2));
  llvm_cbe_tmp64_2e_i = ((struct __attribute__ ((packed, aligned(1))) {unsigned int data; } *)((&llvm_cbe_cd_2e_i_2e_0->field18)))->data;
  llvm_cbe_tmp6465_2e_i = ((unsigned long long )(unsigned int )llvm_cbe_tmp64_2e_i);
  llvm_cbe_tmp66_2e_i = (&llvm_cbe_tmp61_2e_i[((signed long long )llvm_cbe_tmp6465_2e_i)]);
  llvm_cbe_tmp6667_2e_i = ((struct l_struct_2E_zip_lfh *)llvm_cbe_tmp66_2e_i);
  if ((llvm_cbe_tmp66_2e_i == ((unsigned char *)/*NULL*/0))) {
    llvm_cbe_l_2e_1__PHI_TEMPORARY = 0u;   /* for PHI node */
    goto llvm_cbe_bb133_2e_i;
  } else {
    goto llvm_cbe_bb72_2e_i;
  }

llvm_cbe_bb72_2e_i:
  llvm_cbe_tmp75_2e_i = ((struct __attribute__ ((packed, aligned(1))) {unsigned int data; } *)((&llvm_cbe_tmp6667_2e_i->field8)))->data;
  llvm_cbe_tmp82_2e_i = ((struct __attribute__ ((packed, aligned(1))) {unsigned short data; } *)((&llvm_cbe_tmp6667_2e_i->field9)))->data;
  llvm_cbe_tmp88_2e_i = ((struct __attribute__ ((packed, aligned(1))) {unsigned short data; } *)((&llvm_cbe_tmp6667_2e_i->field10)))->data;
  llvm_cbe_tmp91_2e_i = (&llvm_cbe_tmp61_2e_i[((signed long long )(llvm_cbe_tmp6465_2e_i + (((((unsigned long long )(unsigned short )llvm_cbe_tmp82_2e_i)) + 30ull) + (((unsigned long long )(unsigned short )llvm_cbe_tmp88_2e_i)))))]);
  llvm_cbe_tmp94_2e_i = ((struct __attribute__ ((packed, aligned(1))) {unsigned short data; } *)((&llvm_cbe_tmp6667_2e_i->field3)))->data;
  switch (llvm_cbe_tmp94_2e_i) {
  default:
    llvm_cbe_l_2e_1__PHI_TEMPORARY = llvm_cbe_tmp75_2e_i;   /* for PHI node */
    goto llvm_cbe_bb133_2e_i;
;
  case ((unsigned short )0):
    llvm_cbe_tmp1_2e_i45_2e_0__PHI_TEMPORARY = llvm_cbe_tmp91_2e_i;   /* for PHI node */
    llvm_cbe_l_2e_2__PHI_TEMPORARY = llvm_cbe_tmp75_2e_i;   /* for PHI node */
    goto llvm_cbe_invcont66;
  case ((unsigned short )8):
    goto llvm_cbe_bb97_2e_i;
    break;
  }
llvm_cbe_bb97_2e_i:
  llvm_cbe_tmp99_2e_i = (&llvm_cbe_zf.field6);
  llvm_cbe_tmp100_2e_i = *llvm_cbe_tmp99_2e_i;
  if ((llvm_cbe_tmp100_2e_i == ((unsigned char *)/*NULL*/0))) {
    goto llvm_cbe_bb108_2e_i;
  } else {
    goto llvm_cbe_bb104_2e_i;
  }

llvm_cbe_bb104_2e_i:
  _ZdaPv(llvm_cbe_tmp100_2e_i);
  goto llvm_cbe_bb108_2e_i;

llvm_cbe_bb108_2e_i:
  llvm_cbe_tmp113_2e_i70 = _Znam((((signed long long )(signed int )llvm_cbe_tmp75_2e_i)));
  *llvm_cbe_tmp99_2e_i = llvm_cbe_tmp113_2e_i70;
  llvm_cbe_tmp118_2e_i = ((struct __attribute__ ((packed, aligned(1))) {unsigned int data; } *)((&llvm_cbe_tmp6667_2e_i->field7)))->data;
  *((&llvm_cbe_stream_2e_i_2e_i.field0)) = llvm_cbe_tmp91_2e_i;
  llvm_cbe_tmp4_2e_i_2e_i67 = (&llvm_cbe_stream_2e_i_2e_i.field1);
  *llvm_cbe_tmp4_2e_i_2e_i67 = llvm_cbe_tmp118_2e_i;
  *((&llvm_cbe_stream_2e_i_2e_i.field3)) = llvm_cbe_tmp113_2e_i70;
  *((&llvm_cbe_stream_2e_i_2e_i.field4)) = llvm_cbe_tmp75_2e_i;
  *((&llvm_cbe_stream_2e_i_2e_i.field8)) = ((unsigned char * (*) (unsigned char *, unsigned int , unsigned int ))/*NULL*/0);
  *((&llvm_cbe_stream_2e_i_2e_i.field9)) = ((void  (*) (unsigned char *, unsigned char *))/*NULL*/0);
  llvm_cbe_tmp13_2e_i_2e_i71 = inflateInit2_((&llvm_cbe_stream_2e_i_2e_i), 4294967281u, ((&_2E_str224[((signed long long )0ull)])), 112u);
  if ((llvm_cbe_tmp13_2e_i_2e_i71 == 0u)) {
    goto llvm_cbe_bb18_2e_i_2e_i;
  } else {
    llvm_cbe_l_2e_4__PHI_TEMPORARY = llvm_cbe_tmp75_2e_i;   /* for PHI node */
    llvm_cbe_tmp_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp13_2e_i_2e_i71;   /* for PHI node */
    goto llvm_cbe__Z14uncompress_intPhPiPKhi_2e_exit_2e_i;
  }

llvm_cbe_bb18_2e_i_2e_i:
  llvm_cbe_tmp19_2e_i_2e_i72 = inflate((&llvm_cbe_stream_2e_i_2e_i), 4u);
  if ((llvm_cbe_tmp19_2e_i_2e_i72 == 1u)) {
    goto llvm_cbe_bb44_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb24_2e_i_2e_i;
  }

llvm_cbe_bb24_2e_i_2e_i:
  llvm_cbe_tmp25_2e_i_2e_i73 = inflateEnd((&llvm_cbe_stream_2e_i_2e_i));
  switch (llvm_cbe_tmp19_2e_i_2e_i72) {
  default:
    llvm_cbe_l_2e_4__PHI_TEMPORARY = llvm_cbe_tmp75_2e_i;   /* for PHI node */
    llvm_cbe_tmp_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp19_2e_i_2e_i72;   /* for PHI node */
    goto llvm_cbe__Z14uncompress_intPhPiPKhi_2e_exit_2e_i;
;
  case 2u:
    goto llvm_cbe__Z14uncompress_intPhPiPKhi_2e_exit_2e_i_2e_thread;
  case 4294967291u:
    goto llvm_cbe_bb35_2e_i_2e_i;
    break;
  }
llvm_cbe_bb35_2e_i_2e_i:
  llvm_cbe_tmp37_2e_i_2e_i = *llvm_cbe_tmp4_2e_i_2e_i67;
  if ((llvm_cbe_tmp37_2e_i_2e_i == 0u)) {
    goto llvm_cbe__Z14uncompress_intPhPiPKhi_2e_exit_2e_i_2e_thread;
  } else {
    llvm_cbe_l_2e_4__PHI_TEMPORARY = llvm_cbe_tmp75_2e_i;   /* for PHI node */
    llvm_cbe_tmp_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp19_2e_i_2e_i72;   /* for PHI node */
    goto llvm_cbe__Z14uncompress_intPhPiPKhi_2e_exit_2e_i;
  }

llvm_cbe__Z14uncompress_intPhPiPKhi_2e_exit_2e_i_2e_thread:
  *(&llvm_cbe_l_2e_4_2e_reg2mem) = llvm_cbe_tmp75_2e_i;
  llvm_cbe_l_2e_1__PHI_TEMPORARY = llvm_cbe_tmp75_2e_i;   /* for PHI node */
  goto llvm_cbe_bb133_2e_i;

llvm_cbe_bb44_2e_i_2e_i:
  llvm_cbe_tmp46_2e_i_2e_i = *((&llvm_cbe_stream_2e_i_2e_i.field5));
  llvm_cbe_tmp4647_2e_i_2e_i = ((unsigned int )llvm_cbe_tmp46_2e_i_2e_i);
  llvm_cbe_tmp49_2e_i_2e_i74 = inflateEnd((&llvm_cbe_stream_2e_i_2e_i));
  llvm_cbe_l_2e_4__PHI_TEMPORARY = llvm_cbe_tmp4647_2e_i_2e_i;   /* for PHI node */
  llvm_cbe_tmp_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp49_2e_i_2e_i74;   /* for PHI node */
  goto llvm_cbe__Z14uncompress_intPhPiPKhi_2e_exit_2e_i;

llvm_cbe__Z14uncompress_intPhPiPKhi_2e_exit_2e_i:
  llvm_cbe_l_2e_4 = llvm_cbe_l_2e_4__PHI_TEMPORARY;
  llvm_cbe_tmp_2e_i_2e_i_2e_0 = llvm_cbe_tmp_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  *(&llvm_cbe_l_2e_4_2e_reg2mem) = llvm_cbe_l_2e_4;
  llvm_cbe_l_2e_4_2e_reload143 = *(&llvm_cbe_l_2e_4_2e_reg2mem);
  if ((llvm_cbe_tmp_2e_i_2e_i_2e_0 == 0u)) {
    goto llvm_cbe_bb129_2e_i;
  } else {
    llvm_cbe_l_2e_1__PHI_TEMPORARY = llvm_cbe_l_2e_4_2e_reload143;   /* for PHI node */
    goto llvm_cbe_bb133_2e_i;
  }

llvm_cbe_bb129_2e_i:
  llvm_cbe_tmp132_2e_i = *llvm_cbe_tmp99_2e_i;
  llvm_cbe_l_2e_4_2e_reload = *(&llvm_cbe_l_2e_4_2e_reg2mem);
  llvm_cbe_tmp1_2e_i45_2e_0__PHI_TEMPORARY = llvm_cbe_tmp132_2e_i;   /* for PHI node */
  llvm_cbe_l_2e_2__PHI_TEMPORARY = llvm_cbe_l_2e_4_2e_reload;   /* for PHI node */
  goto llvm_cbe_invcont66;

llvm_cbe_bb133_2e_i:
  llvm_cbe_l_2e_1 = llvm_cbe_l_2e_1__PHI_TEMPORARY;
  llvm_cbe_tmp1_2e_i45_2e_0__PHI_TEMPORARY = ((unsigned char *)/*NULL*/0);   /* for PHI node */
  llvm_cbe_l_2e_2__PHI_TEMPORARY = llvm_cbe_l_2e_1;   /* for PHI node */
  goto llvm_cbe_invcont66;

llvm_cbe_invcont66:
  llvm_cbe_tmp1_2e_i45_2e_0 = llvm_cbe_tmp1_2e_i45_2e_0__PHI_TEMPORARY;
  llvm_cbe_l_2e_2 = llvm_cbe_l_2e_2__PHI_TEMPORARY;
  if (((((llvm_cbe_tmp1_2e_i45_2e_0 == ((unsigned char *)/*NULL*/0)) | (((signed int )llvm_cbe_l_2e_2) > ((signed int )65536u)))&1))) {
    llvm_cbe_l_2e_3__PHI_TEMPORARY = llvm_cbe_l_2e_2;   /* for PHI node */
    goto llvm_cbe_bb83;
  } else {
    goto llvm_cbe_bb78;
  }

llvm_cbe_bb78:
  ltmp_4_1 = memcpy(((&levelbuf[((signed long long )0ull)])), llvm_cbe_tmp1_2e_i45_2e_0, (((signed long long )(signed int )llvm_cbe_l_2e_2)));
  llvm_cbe_l_2e_3__PHI_TEMPORARY = llvm_cbe_l_2e_2;   /* for PHI node */
  goto llvm_cbe_bb83;

llvm_cbe_bb83:
  llvm_cbe_l_2e_3 = llvm_cbe_l_2e_3__PHI_TEMPORARY;
  llvm_cbe_tmp2_2e_i11 = *((&llvm_cbe_zf.field6));
  if ((llvm_cbe_tmp2_2e_i11 == ((unsigned char *)/*NULL*/0))) {
    goto llvm_cbe_bb8_2e_i21;
  } else {
    goto llvm_cbe_bb_2e_i16;
  }

llvm_cbe_bb_2e_i16:
  _ZdaPv(llvm_cbe_tmp2_2e_i11);
  goto llvm_cbe_bb8_2e_i21;

llvm_cbe_bb8_2e_i21:
  llvm_cbe_tmp11_2e_i19 = *((&llvm_cbe_zf.field2));
  if ((llvm_cbe_tmp11_2e_i19 == ((unsigned char *)/*NULL*/0))) {
    goto llvm_cbe_bb24_2e_i35;
  } else {
    goto llvm_cbe_bb15_2e_i30;
  }

llvm_cbe_bb15_2e_i30:
  llvm_cbe_tmp18_2e_i24 = *((&llvm_cbe_zf.field1));
  llvm_cbe_tmp23_2e_i29 = munmap(llvm_cbe_tmp11_2e_i19, (((signed long long )(signed int )llvm_cbe_tmp18_2e_i24)));
  goto llvm_cbe_bb24_2e_i35;

llvm_cbe_bb24_2e_i35:
  llvm_cbe_tmp27_2e_i33 = *((&llvm_cbe_zf.field0));
  if ((llvm_cbe_tmp27_2e_i33 == 0u)) {
    llvm_cbe_l_2e_0__PHI_TEMPORARY = llvm_cbe_l_2e_3;   /* for PHI node */
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb31_2e_i40;
  }

llvm_cbe_bb31_2e_i40:
  llvm_cbe_tmp36_2e_i39 = close(llvm_cbe_tmp27_2e_i33);
  return llvm_cbe_l_2e_3;
llvm_cbe_bb89:
  llvm_cbe_tmp96 = _ZNKSs5c_strEv(((&llvm_cbe_tmp15->field0)));
  llvm_cbe_tmp98 = fopen(llvm_cbe_tmp96, ((&_2E_str9[((signed long long )0ull)])));
  if ((llvm_cbe_tmp98 == ((struct l_struct_2E_FILE *)/*NULL*/0))) {
    llvm_cbe_l_2e_0__PHI_TEMPORARY = 0u;   /* for PHI node */
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb103;
  }

llvm_cbe_bb103:
  llvm_cbe_tmp108 = fread(((&levelbuf[((signed long long )0ull)])), 1ull, 65536ull, llvm_cbe_tmp98);
  llvm_cbe_tmp111 = fclose(llvm_cbe_tmp98);
  return (((unsigned int )llvm_cbe_tmp108));
llvm_cbe_bb115:
  llvm_cbe_tmp116 = __cxa_allocate_exception(8ull);
  *(((unsigned char **)llvm_cbe_tmp116)) = ((&_2E_str213[((signed long long )0ull)]));
  __cxa_throw(llvm_cbe_tmp116, ((unsigned char *)(&_ZTIPc)), ((void  (*) (unsigned char *))/*NULL*/0));
  /*UNREACHABLE*/;
llvm_cbe_return:
  llvm_cbe_l_2e_0 = llvm_cbe_l_2e_0__PHI_TEMPORARY;
  return llvm_cbe_l_2e_0;
}


static void _ZN5ArrayIPN6Levels9LevelDescEE14ensureCapacityEi(struct l_struct_2E_Array_3C_Levels_3A__3A_LevelDesc_2A__3E_ *llvm_cbe_this, unsigned int llvm_cbe_c) {
  unsigned int *llvm_cbe_tmp1;
  unsigned int llvm_cbe_tmp2;
  unsigned int llvm_cbe_storemerge;
  unsigned int llvm_cbe_tmp22;
  unsigned int llvm_cbe_storemerge1;
  unsigned int llvm_cbe_storemerge1__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp2_2e_i;
  unsigned long long llvm_cbe_tmp27_2e_i;
  struct l_struct_2E_Levels_3A__3A_LevelDesc ***llvm_cbe_tmp17_2e_i;
  struct l_struct_2E_Levels_3A__3A_LevelDesc **llvm_cbe_tmp18_2e_i;
  unsigned char *llvm_cbe_tmp20_2e_i;
  unsigned char *llvm_cbe_tmp28_2e_i;

  llvm_cbe_tmp1 = (&llvm_cbe_this->field2);
  llvm_cbe_tmp2 = *llvm_cbe_tmp1;
  if ((((signed int )llvm_cbe_tmp2) < ((signed int )llvm_cbe_c))) {
    goto llvm_cbe_bb;
  } else {
    goto llvm_cbe_return;
  }

llvm_cbe_bb:
  llvm_cbe_storemerge = (((llvm_cbe_tmp2 == 0u)) ? (4u) : (llvm_cbe_tmp2));
  llvm_cbe_storemerge1__PHI_TEMPORARY = llvm_cbe_storemerge;   /* for PHI node */
  goto llvm_cbe_bb23;

  do {     /* Syntactic loop 'bb23' to make GCC happy */
llvm_cbe_bb23:
  llvm_cbe_storemerge1 = llvm_cbe_storemerge1__PHI_TEMPORARY;
  if ((((signed int )llvm_cbe_storemerge1) < ((signed int )llvm_cbe_c))) {
    goto llvm_cbe_bb19;
  } else {
    goto llvm_cbe_bb29;
  }

llvm_cbe_bb19:
  llvm_cbe_tmp22 = llvm_cbe_storemerge1 << 1u;
  llvm_cbe_storemerge1__PHI_TEMPORARY = llvm_cbe_tmp22;   /* for PHI node */
  goto llvm_cbe_bb23;

  } while (1); /* end of syntactic loop 'bb23' */
llvm_cbe_bb29:
  llvm_cbe_tmp2_2e_i = *((&llvm_cbe_this->field1));
  if ((((signed int )llvm_cbe_tmp2_2e_i) > ((signed int )llvm_cbe_storemerge1))) {
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb_2e_i;
  }

llvm_cbe_bb_2e_i:
  llvm_cbe_tmp27_2e_i = (((signed long long )(signed int )llvm_cbe_storemerge1)) << 3ull;
  if ((llvm_cbe_tmp2 == 0u)) {
    goto llvm_cbe_bb24_2e_i;
  } else {
    goto llvm_cbe_bb12_2e_i;
  }

llvm_cbe_bb12_2e_i:
  llvm_cbe_tmp17_2e_i = (&llvm_cbe_this->field0);
  llvm_cbe_tmp18_2e_i = *llvm_cbe_tmp17_2e_i;
  llvm_cbe_tmp20_2e_i = realloc((((unsigned char *)llvm_cbe_tmp18_2e_i)), llvm_cbe_tmp27_2e_i);
  *llvm_cbe_tmp17_2e_i = (((struct l_struct_2E_Levels_3A__3A_LevelDesc **)llvm_cbe_tmp20_2e_i));
  goto llvm_cbe_bb32_2e_i;

llvm_cbe_bb24_2e_i:
  llvm_cbe_tmp28_2e_i = malloc(llvm_cbe_tmp27_2e_i);
  *((&llvm_cbe_this->field0)) = (((struct l_struct_2E_Levels_3A__3A_LevelDesc **)llvm_cbe_tmp28_2e_i));
  goto llvm_cbe_bb32_2e_i;

llvm_cbe_bb32_2e_i:
  *llvm_cbe_tmp1 = llvm_cbe_storemerge1;
  return;
llvm_cbe_return:
  return;
}


static void _ZN6Levels8addLevelERKSsii(struct l_struct_2E_Levels *llvm_cbe_this, struct l_struct_2E_std_3A__3A_string *llvm_cbe_file, unsigned int llvm_cbe_rank, unsigned int llvm_cbe_index) {
  unsigned char *llvm_cbe_tmp2;
  struct l_struct_2E_Levels_3A__3A_LevelDesc *llvm_cbe_tmp23;
  unsigned int *llvm_cbe_tmp2_2e_i12;
  struct l_struct_2E_Array_3C_Levels_3A__3A_LevelDesc_2A__3E_ *llvm_cbe_tmp15;
  struct l_struct_2E_Levels_3A__3A_LevelDesc ***llvm_cbe_tmp2_2e_i_2e_i73;
  struct l_struct_2E_Levels_3A__3A_LevelDesc **llvm_cbe_tmp3_2e_i_2e_i74;
  unsigned long long llvm_cbe_tmp45_2e_i_2e_i76;
  struct l_struct_2E_Levels_3A__3A_LevelDesc *llvm_cbe_tmp18;
  unsigned int llvm_cbe_tmp3_2e_i62;
  struct l_struct_2E_Levels_3A__3A_LevelDesc **llvm_cbe_tmp3_2e_i_2e_i53;
  struct l_struct_2E_Levels_3A__3A_LevelDesc *llvm_cbe_tmp29;
  unsigned int llvm_cbe_tmp31;
  unsigned char *llvm_cbe_tmp44;
  unsigned int llvm_cbe_tmp46;
  struct l_struct_2E_Levels_3A__3A_LevelDesc **llvm_cbe_tmp3_2e_i_2e_i39;
  struct l_struct_2E_Levels_3A__3A_LevelDesc *llvm_cbe_tmp52;
  unsigned int llvm_cbe_tmp54;
  unsigned char *llvm_cbe_tmp62;
  unsigned int llvm_cbe_tmp65;
  unsigned int *llvm_cbe_tmp1_2e_i18;
  unsigned int llvm_cbe_tmp2_2e_i19;
  struct l_struct_2E_Levels_3A__3A_LevelDesc **llvm_cbe_tmp7_2e_i_2e_i;
  unsigned int llvm_cbe_tmp10_2e_i_2e_i;
  unsigned int llvm_cbe_tmp16_2e_i30;
  struct l_struct_2E_Levels_3A__3A_LevelDesc *llvm_cbe_tmp30_2e_i;
  unsigned int llvm_cbe_storemerge_2e_in_2e_i;
  unsigned int llvm_cbe_storemerge_2e_in_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge_2e_i;
  struct l_struct_2E_Levels_3A__3A_LevelDesc **llvm_cbe_tmp44_2e_i;
  unsigned int llvm_cbe_tmp53_2e_i;
  unsigned int llvm_cbe_storemerge_2e_in;
  unsigned int llvm_cbe_storemerge_2e_in__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp71;
  unsigned int llvm_cbe_storemerge1;
  unsigned int llvm_cbe_storemerge1__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp3_2e_i13;
  unsigned char *llvm_cbe_tmp83;
  unsigned int llvm_cbe_tmp85;
  unsigned int *llvm_cbe_tmp1_2e_i4;
  unsigned int llvm_cbe_tmp2_2e_i5;
  struct l_struct_2E_Levels_3A__3A_LevelDesc **llvm_cbe_tmp7_2e_i10;
  unsigned int llvm_cbe_tmp10_2e_i;

  llvm_cbe_tmp2 = _Znwm(16ull);
  llvm_cbe_tmp23 = ((struct l_struct_2E_Levels_3A__3A_LevelDesc *)llvm_cbe_tmp2);
  _ZNSsC1ERKSs((((struct l_struct_2E_std_3A__3A_string *)llvm_cbe_tmp2)), llvm_cbe_file);
  *((&llvm_cbe_tmp23->field1)) = llvm_cbe_index;
  *((&llvm_cbe_tmp23->field2)) = llvm_cbe_rank;
  llvm_cbe_tmp2_2e_i12 = (&llvm_cbe_this->field0.field1);
  llvm_cbe_tmp15 = (&llvm_cbe_this->field0);
  llvm_cbe_tmp2_2e_i_2e_i73 = (&llvm_cbe_this->field0.field0);
  llvm_cbe_storemerge1__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb72;

llvm_cbe_bb42:
  llvm_cbe_tmp44 = _ZNKSs5c_strEv(llvm_cbe_file);
  llvm_cbe_tmp46 = printf(((&_2E_str314[((signed long long )0ull)])), llvm_cbe_tmp44);
  return;
llvm_cbe_bb60:
  llvm_cbe_tmp62 = _ZNKSs5c_strEv(llvm_cbe_file);
  llvm_cbe_tmp65 = printf(((&_2E_str415[((signed long long )0ull)])), llvm_cbe_tmp62, llvm_cbe_storemerge1);
  llvm_cbe_tmp1_2e_i18 = (&llvm_cbe_this->field0.field1);
  llvm_cbe_tmp2_2e_i19 = *llvm_cbe_tmp1_2e_i18;
  _ZN5ArrayIPN6Levels9LevelDescEE14ensureCapacityEi(llvm_cbe_tmp15, (llvm_cbe_tmp2_2e_i19 + 1u));
  if ((llvm_cbe_tmp2_2e_i19 == llvm_cbe_storemerge1)) {
    goto llvm_cbe_bb_2e_i;
  } else {
    goto llvm_cbe_bb8_2e_i;
  }

llvm_cbe_bb_2e_i:
  llvm_cbe_tmp7_2e_i_2e_i = *llvm_cbe_tmp2_2e_i_2e_i73;
  llvm_cbe_tmp10_2e_i_2e_i = *llvm_cbe_tmp1_2e_i18;
  *((&llvm_cbe_tmp7_2e_i_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_tmp10_2e_i_2e_i)))])) = llvm_cbe_tmp23;
  llvm_cbe_storemerge_2e_in__PHI_TEMPORARY = llvm_cbe_tmp10_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe__ZN5ArrayIPN6Levels9LevelDescEE6insertEiRKS2__2e_exit;

llvm_cbe_bb8_2e_i:
  llvm_cbe_tmp16_2e_i30 = *llvm_cbe_tmp1_2e_i18;
  llvm_cbe_storemerge_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp16_2e_i30;   /* for PHI node */
  goto llvm_cbe_bb35_2e_i;

  do {     /* Syntactic loop 'bb35.i' to make GCC happy */
llvm_cbe_bb35_2e_i:
  llvm_cbe_storemerge_2e_in_2e_i = llvm_cbe_storemerge_2e_in_2e_i__PHI_TEMPORARY;
  llvm_cbe_storemerge_2e_i = llvm_cbe_storemerge_2e_in_2e_i + 4294967295u;
  llvm_cbe_tmp44_2e_i = *llvm_cbe_tmp2_2e_i_2e_i73;
  if ((((signed int )llvm_cbe_storemerge_2e_i) < ((signed int )llvm_cbe_storemerge1))) {
    goto llvm_cbe_bb41_2e_i;
  } else {
    goto llvm_cbe_bb18_2e_i;
  }

llvm_cbe_bb18_2e_i:
  llvm_cbe_tmp30_2e_i = *((&llvm_cbe_tmp44_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge_2e_i)))]));
  *((&llvm_cbe_tmp44_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge_2e_in_2e_i)))])) = llvm_cbe_tmp30_2e_i;
  llvm_cbe_storemerge_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_storemerge_2e_i;   /* for PHI node */
  goto llvm_cbe_bb35_2e_i;

  } while (1); /* end of syntactic loop 'bb35.i' */
llvm_cbe_bb41_2e_i:
  *((&llvm_cbe_tmp44_2e_i[((signed long long )llvm_cbe_tmp45_2e_i_2e_i76)])) = llvm_cbe_tmp23;
  llvm_cbe_tmp53_2e_i = *llvm_cbe_tmp1_2e_i18;
  llvm_cbe_storemerge_2e_in__PHI_TEMPORARY = llvm_cbe_tmp53_2e_i;   /* for PHI node */
  goto llvm_cbe__ZN5ArrayIPN6Levels9LevelDescEE6insertEiRKS2__2e_exit;

llvm_cbe__ZN5ArrayIPN6Levels9LevelDescEE6insertEiRKS2__2e_exit:
  llvm_cbe_storemerge_2e_in = llvm_cbe_storemerge_2e_in__PHI_TEMPORARY;
  *llvm_cbe_tmp1_2e_i18 = (llvm_cbe_storemerge_2e_in + 1u);
  return;
  do {     /* Syntactic loop 'bb72' to make GCC happy */
llvm_cbe_bb72:
  llvm_cbe_storemerge1 = llvm_cbe_storemerge1__PHI_TEMPORARY;
  llvm_cbe_tmp3_2e_i13 = *llvm_cbe_tmp2_2e_i12;
  if ((((signed int )llvm_cbe_tmp3_2e_i13) > ((signed int )llvm_cbe_storemerge1))) {
    goto llvm_cbe_bb13;
  } else {
    goto llvm_cbe_bb81;
  }

llvm_cbe_bb69:
  llvm_cbe_tmp71 = llvm_cbe_storemerge1 + 1u;
  llvm_cbe_storemerge1__PHI_TEMPORARY = llvm_cbe_tmp71;   /* for PHI node */
  goto llvm_cbe_bb72;

llvm_cbe_bb47:
  llvm_cbe_tmp3_2e_i_2e_i39 = *llvm_cbe_tmp2_2e_i_2e_i73;
  llvm_cbe_tmp52 = *((&llvm_cbe_tmp3_2e_i_2e_i39[((signed long long )llvm_cbe_tmp45_2e_i_2e_i76)]));
  llvm_cbe_tmp54 = *((&llvm_cbe_tmp52->field2));
  if ((((signed int )llvm_cbe_tmp54) > ((signed int )llvm_cbe_rank))) {
    goto llvm_cbe_bb60;
  } else {
    goto llvm_cbe_bb69;
  }

llvm_cbe_bb13:
  llvm_cbe_tmp3_2e_i_2e_i74 = *llvm_cbe_tmp2_2e_i_2e_i73;
  llvm_cbe_tmp45_2e_i_2e_i76 = ((signed long long )(signed int )llvm_cbe_storemerge1);
  llvm_cbe_tmp18 = *((&llvm_cbe_tmp3_2e_i_2e_i74[((signed long long )llvm_cbe_tmp45_2e_i_2e_i76)]));
  llvm_cbe_tmp3_2e_i62 = _ZNKSs7compareERKSs(((&llvm_cbe_tmp18->field0)), llvm_cbe_file);
  if ((llvm_cbe_tmp3_2e_i62 == 0u)) {
    goto llvm_cbe_bb24;
  } else {
    goto llvm_cbe_bb47;
  }

llvm_cbe_bb24:
  llvm_cbe_tmp3_2e_i_2e_i53 = *llvm_cbe_tmp2_2e_i_2e_i73;
  llvm_cbe_tmp29 = *((&llvm_cbe_tmp3_2e_i_2e_i53[((signed long long )llvm_cbe_tmp45_2e_i_2e_i76)]));
  llvm_cbe_tmp31 = *((&llvm_cbe_tmp29->field1));
  if ((llvm_cbe_tmp31 == llvm_cbe_index)) {
    goto llvm_cbe_bb42;
  } else {
    goto llvm_cbe_bb47;
  }

  } while (1); /* end of syntactic loop 'bb72' */
llvm_cbe_bb81:
  llvm_cbe_tmp83 = _ZNKSs5c_strEv(llvm_cbe_file);
  llvm_cbe_tmp85 = printf(((&_2E_str516[((signed long long )0ull)])), llvm_cbe_tmp83);
  llvm_cbe_tmp1_2e_i4 = (&llvm_cbe_this->field0.field1);
  llvm_cbe_tmp2_2e_i5 = *llvm_cbe_tmp1_2e_i4;
  _ZN5ArrayIPN6Levels9LevelDescEE14ensureCapacityEi(llvm_cbe_tmp15, (llvm_cbe_tmp2_2e_i5 + 1u));
  llvm_cbe_tmp7_2e_i10 = *llvm_cbe_tmp2_2e_i_2e_i73;
  llvm_cbe_tmp10_2e_i = *llvm_cbe_tmp1_2e_i4;
  *((&llvm_cbe_tmp7_2e_i10[((signed long long )(((signed long long )(signed int )llvm_cbe_tmp10_2e_i)))])) = llvm_cbe_tmp23;
  *llvm_cbe_tmp1_2e_i4 = (llvm_cbe_tmp10_2e_i + 1u);
  return;
}


static void _ZN6Levels7addPathEPKc(struct l_struct_2E_Levels *llvm_cbe_this, unsigned char *llvm_cbe_path) {
  struct l_struct_2E_ZipFile llvm_cbe_zf_2e_i;    /* Address-exposed local */
  struct l_struct_2E_std_3A__3A_string llvm_cbe_tmp1_2e_i;    /* Address-exposed local */
  struct l_struct_2E_std_3A__3A_string llvm_cbe_full;    /* Address-exposed local */
  struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ llvm_cbe_tmp2;    /* Address-exposed local */
  struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ llvm_cbe_tmp3;    /* Address-exposed local */
  struct l_struct_2E_std_3A__3A_string llvm_cbe_tmp4;    /* Address-exposed local */
  struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ llvm_cbe_tmp5;    /* Address-exposed local */
  struct l_struct_2E_std_3A__3A_string llvm_cbe_tmp6;    /* Address-exposed local */
  struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ llvm_cbe_tmp7;    /* Address-exposed local */
  struct l_struct_2E_std_3A__3A_string llvm_cbe_tmp8;    /* Address-exposed local */
  struct l_struct_2E___gnu_cxx_3A__3A_new_allocator_3C_happyhttp_3A__3A_Response_2A__2A__3E_ llvm_cbe_tmp9;    /* Address-exposed local */
  struct l_struct_2E_std_3A__3A_string llvm_cbe_tmp10;    /* Address-exposed local */
  unsigned long long llvm_cbe_tmp12;
  unsigned char *llvm_cbe_tmp18;
  unsigned int llvm_cbe_tmp20;
  unsigned int llvm_cbe_tmp25;
  unsigned int *llvm_cbe_tmp2_2e_i_2e_i;
  unsigned int llvm_cbe_tmp3_2e_i_2e_i;
  unsigned char *llvm_cbe_tmp5_2e_i;
  unsigned int llvm_cbe_tmp8_2e_i;
  unsigned int llvm_cbe_tmp13_2e_i;
  unsigned int llvm_cbe_tmp25_2e_i;
  unsigned int llvm_cbe_storemerge_2e_i;
  unsigned int llvm_cbe_storemerge_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp3_2e_i39_2e_i;
  unsigned char *llvm_cbe_tmp2_2e_i6_2e_i;
  unsigned char *llvm_cbe_tmp11_2e_i14_2e_i;
  unsigned int llvm_cbe_tmp18_2e_i19_2e_i;
  unsigned int llvm_cbe_tmp23_2e_i24_2e_i;
  unsigned int llvm_cbe_tmp27_2e_i28_2e_i;
  unsigned int llvm_cbe_tmp36_2e_i34_2e_i6;
  unsigned int llvm_cbe_tmp60;
  unsigned int llvm_cbe_tmp68;
  struct l_struct_2E_DIR *llvm_cbe_tmp100;
  unsigned char *llvm_cbe_tmp109;
  unsigned char llvm_cbe_tmp110;
  struct l_struct_2E_std_3A__3A_string *llvm_cbe_tmp119;
  struct l_struct_2E_std_3A__3A_string *llvm_cbe_tmp130;
  unsigned char *llvm_cbe_tmp132;
  struct l_struct_2E_dirent *llvm_cbe_tmp143;
  unsigned int llvm_cbe_tmp151;
  unsigned int llvm_cbe_tmp155;

  llvm_cbe_tmp12 = strlen(llvm_cbe_path);
  llvm_cbe_tmp18 = (&llvm_cbe_path[((signed long long )((((signed long long )(signed int )(((unsigned int )llvm_cbe_tmp12)))) + 18446744073709551612ull))]);
  llvm_cbe_tmp20 = strcasecmp(llvm_cbe_tmp18, ((&_2E_str718[((signed long long )0ull)])));
  if ((llvm_cbe_tmp20 == 0u)) {
    goto llvm_cbe_bb;
  } else {
    goto llvm_cbe_bb53;
  }

llvm_cbe_bb:
  _ZNSaIcEC1Ev((&llvm_cbe_tmp9));
  _ZNSsC1EPKcRKSaIcE((&llvm_cbe_tmp10), llvm_cbe_path, (&llvm_cbe_tmp9));
  llvm_cbe_tmp25 = _ZL12rankFromPathRKSsi((&llvm_cbe_tmp10), 9999u);
  _ZNSaIcEC1Ev((&llvm_cbe_tmp7));
  _ZNSsC1EPKcRKSaIcE((&llvm_cbe_tmp8), llvm_cbe_path, (&llvm_cbe_tmp7));
  _ZN7ZipFileC1ERKSs((&llvm_cbe_zf_2e_i), (&llvm_cbe_tmp8));
  llvm_cbe_tmp2_2e_i_2e_i = (&llvm_cbe_zf_2e_i.field5);
  llvm_cbe_tmp3_2e_i_2e_i = *llvm_cbe_tmp2_2e_i_2e_i;
  llvm_cbe_tmp5_2e_i = _ZNKSs5c_strEv((&llvm_cbe_tmp8));
  llvm_cbe_tmp8_2e_i = printf(((&_2E_str617[((signed long long )0ull)])), llvm_cbe_tmp5_2e_i, llvm_cbe_tmp3_2e_i_2e_i);
  llvm_cbe_storemerge_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb26_2e_i;

  do {     /* Syntactic loop 'bb26.i' to make GCC happy */
llvm_cbe_bb26_2e_i:
  llvm_cbe_storemerge_2e_i = llvm_cbe_storemerge_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp3_2e_i39_2e_i = *llvm_cbe_tmp2_2e_i_2e_i;
  if ((((signed int )llvm_cbe_tmp3_2e_i39_2e_i) > ((signed int )llvm_cbe_storemerge_2e_i))) {
    goto llvm_cbe_bb_2e_i;
  } else {
    goto llvm_cbe_bb32_2e_i;
  }

llvm_cbe_bb_2e_i:
  llvm_cbe_tmp1_2e_i = _ZN7ZipFile9entryNameEi((&llvm_cbe_zf_2e_i), llvm_cbe_storemerge_2e_i);
  llvm_cbe_tmp13_2e_i = _ZL12rankFromPathRKSsi((&llvm_cbe_tmp1_2e_i), llvm_cbe_tmp25);
  _ZN6Levels8addLevelERKSsii(llvm_cbe_this, (&llvm_cbe_tmp8), llvm_cbe_tmp13_2e_i, llvm_cbe_storemerge_2e_i);
  _ZNSsD1Ev((&llvm_cbe_tmp1_2e_i));
  llvm_cbe_tmp25_2e_i = llvm_cbe_storemerge_2e_i + 1u;
  llvm_cbe_storemerge_2e_i__PHI_TEMPORARY = llvm_cbe_tmp25_2e_i;   /* for PHI node */
  goto llvm_cbe_bb26_2e_i;

  } while (1); /* end of syntactic loop 'bb26.i' */
llvm_cbe_bb32_2e_i:
  llvm_cbe_tmp2_2e_i6_2e_i = *((&llvm_cbe_zf_2e_i.field6));
  if ((llvm_cbe_tmp2_2e_i6_2e_i == ((unsigned char *)/*NULL*/0))) {
    goto llvm_cbe_bb8_2e_i16_2e_i;
  } else {
    goto llvm_cbe_bb_2e_i11_2e_i;
  }

llvm_cbe_bb_2e_i11_2e_i:
  _ZdaPv(llvm_cbe_tmp2_2e_i6_2e_i);
  goto llvm_cbe_bb8_2e_i16_2e_i;

llvm_cbe_bb8_2e_i16_2e_i:
  llvm_cbe_tmp11_2e_i14_2e_i = *((&llvm_cbe_zf_2e_i.field2));
  if ((llvm_cbe_tmp11_2e_i14_2e_i == ((unsigned char *)/*NULL*/0))) {
    goto llvm_cbe_bb24_2e_i30_2e_i;
  } else {
    goto llvm_cbe_bb15_2e_i25_2e_i;
  }

llvm_cbe_bb15_2e_i25_2e_i:
  llvm_cbe_tmp18_2e_i19_2e_i = *((&llvm_cbe_zf_2e_i.field1));
  llvm_cbe_tmp23_2e_i24_2e_i = munmap(llvm_cbe_tmp11_2e_i14_2e_i, (((signed long long )(signed int )llvm_cbe_tmp18_2e_i19_2e_i)));
  goto llvm_cbe_bb24_2e_i30_2e_i;

llvm_cbe_bb24_2e_i30_2e_i:
  llvm_cbe_tmp27_2e_i28_2e_i = *((&llvm_cbe_zf_2e_i.field0));
  if ((llvm_cbe_tmp27_2e_i28_2e_i == 0u)) {
    goto llvm_cbe_invcont29;
  } else {
    goto llvm_cbe_bb31_2e_i35_2e_i;
  }

llvm_cbe_bb31_2e_i35_2e_i:
  llvm_cbe_tmp36_2e_i34_2e_i6 = close(llvm_cbe_tmp27_2e_i28_2e_i);
  goto llvm_cbe_invcont29;

llvm_cbe_invcont29:
  _ZNSsD1Ev((&llvm_cbe_tmp8));
  _ZNSaIcED1Ev((&llvm_cbe_tmp7));
  _ZNSsD1Ev((&llvm_cbe_tmp10));
  _ZNSaIcED1Ev((&llvm_cbe_tmp9));
  return;
llvm_cbe_bb53:
  llvm_cbe_tmp60 = strcasecmp(llvm_cbe_tmp18, ((&_2E_str819[((signed long long )0ull)])));
  if ((llvm_cbe_tmp60 == 0u)) {
    goto llvm_cbe_bb64;
  } else {
    goto llvm_cbe_bb98;
  }

llvm_cbe_bb64:
  _ZNSaIcEC1Ev((&llvm_cbe_tmp5));
  _ZNSsC1EPKcRKSaIcE((&llvm_cbe_tmp6), llvm_cbe_path, (&llvm_cbe_tmp5));
  llvm_cbe_tmp68 = _ZL12rankFromPathRKSsi((&llvm_cbe_tmp6), 9999u);
  _ZNSaIcEC1Ev((&llvm_cbe_tmp3));
  _ZNSsC1EPKcRKSaIcE((&llvm_cbe_tmp4), llvm_cbe_path, (&llvm_cbe_tmp3));
  _ZN6Levels8addLevelERKSsii(llvm_cbe_this, (&llvm_cbe_tmp4), llvm_cbe_tmp68, 4294967295u);
  _ZNSsD1Ev((&llvm_cbe_tmp4));
  _ZNSaIcED1Ev((&llvm_cbe_tmp3));
  _ZNSsD1Ev((&llvm_cbe_tmp6));
  _ZNSaIcED1Ev((&llvm_cbe_tmp5));
  return;
llvm_cbe_bb98:
  llvm_cbe_tmp100 = opendir(llvm_cbe_path);
  if ((llvm_cbe_tmp100 == ((struct l_struct_2E_DIR *)/*NULL*/0))) {
    goto llvm_cbe_bb152;
  } else {
    goto llvm_cbe_bb141;
  }

  do {     /* Syntactic loop 'bb141' to make GCC happy */
llvm_cbe_bb141:
  llvm_cbe_tmp143 = readdir(llvm_cbe_tmp100);
  if ((llvm_cbe_tmp143 == ((struct l_struct_2E_dirent *)/*NULL*/0))) {
    goto llvm_cbe_bb149;
  } else {
    goto llvm_cbe_bb106;
  }

llvm_cbe_bb106:
  llvm_cbe_tmp109 = (&llvm_cbe_tmp143->field4[((signed long long )0ull)]);
  llvm_cbe_tmp110 = *llvm_cbe_tmp109;
  if ((llvm_cbe_tmp110 == ((unsigned char )46))) {
    goto llvm_cbe_bb141;
  } else {
    goto llvm_cbe_bb114;
  }

llvm_cbe_bb114:
  _ZNSaIcEC1Ev((&llvm_cbe_tmp2));
  _ZNSsC1EPKcRKSaIcE((&llvm_cbe_full), llvm_cbe_path, (&llvm_cbe_tmp2));
  _ZNSaIcED1Ev((&llvm_cbe_tmp2));
  llvm_cbe_tmp119 = _ZNSspLEPKc((&llvm_cbe_full), ((&_2E_str920[((signed long long )0ull)])));
  llvm_cbe_tmp130 = _ZNSspLEPKc((&llvm_cbe_full), llvm_cbe_tmp109);
  llvm_cbe_tmp132 = _ZNKSs5c_strEv((&llvm_cbe_full));
  _ZN6Levels7addPathEPKc(llvm_cbe_this, llvm_cbe_tmp132);
  _ZNSsD1Ev((&llvm_cbe_full));
  goto llvm_cbe_bb141;

  } while (1); /* end of syntactic loop 'bb141' */
llvm_cbe_bb149:
  llvm_cbe_tmp151 = closedir(llvm_cbe_tmp100);
  return;
llvm_cbe_bb152:
  llvm_cbe_tmp155 = printf(((&_2E_str10[((signed long long )0ull)])), llvm_cbe_path);
  return;
}


static void _GLOBAL__I_levelbuf(void) {
  struct l_struct_2E_Vec2 llvm_cbe_tmp_2e_i;    /* Address-exposed local */
  unsigned int llvm_cbe_tmp9_2e_i;

  _ZNSt8ios_base4InitC1Ev((&_ZStL8__ioinit));
  llvm_cbe_tmp9_2e_i = __cxa_atexit(__tcf_2, ((unsigned char *)/*NULL*/0), ((unsigned char *)(&__dso_handle)));
  *((&llvm_cbe_tmp_2e_i.field0)) = 240u;
  *((&llvm_cbe_tmp_2e_i.field1)) = 0u;
  _ZN9Transform3setEffRK4Vec2((&worldToScreen), 0x1p-1, 0x1.921fb6p+0, (&llvm_cbe_tmp_2e_i));
  return;
}


static unsigned long long _Z5b2MulRK7b2Mat22RK6b2Vec2(struct l_struct_2E_b2AABB *llvm_cbe_A, struct l_struct_2E_b2Vec2 *llvm_cbe_v) {
  float llvm_cbe_tmp7;
  float llvm_cbe_tmp15;
  float llvm_cbe_tmp4;
  float llvm_cbe_tmp12;
  float llvm_cbe_tmp21;
  float llvm_cbe_tmp29;
  llvmBitCastUnion llvm_cbe_tmp4354__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp4661__BITCAST_TEMPORARY;

  llvm_cbe_tmp7 = *((&llvm_cbe_v->field0));
  llvm_cbe_tmp15 = *((&llvm_cbe_v->field1));
  llvm_cbe_tmp4 = *((&llvm_cbe_A->field0.field1));
  llvm_cbe_tmp12 = *((&llvm_cbe_A->field1.field1));
  llvm_cbe_tmp21 = *((&llvm_cbe_A->field0.field0));
  llvm_cbe_tmp29 = *((&llvm_cbe_A->field1.field0));
  return ((((unsigned long long )(unsigned int )((llvm_cbe_tmp4354__BITCAST_TEMPORARY.Float = (((float )((((float )(llvm_cbe_tmp21 * llvm_cbe_tmp7))) + (((float )(llvm_cbe_tmp29 * llvm_cbe_tmp15)))))), llvm_cbe_tmp4354__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp4661__BITCAST_TEMPORARY.Float = (((float )((((float )(llvm_cbe_tmp4 * llvm_cbe_tmp7))) + (((float )(llvm_cbe_tmp12 * llvm_cbe_tmp15)))))), llvm_cbe_tmp4661__BITCAST_TEMPORARY.Int32)))) << 32ull));
}


static void _ZN10b2ShapeDefD1Ev(struct l_struct_2E_b2ShapeDef *llvm_cbe_this) {
  *((&llvm_cbe_this->field0)) = ((&_ZTV10b2ShapeDef[((signed long long )2ull)]));
  return;
}


static void _ZN10b2ShapeDefD0Ev(struct l_struct_2E_b2ShapeDef *llvm_cbe_this) {
  *((&llvm_cbe_this->field0)) = ((&_ZTV10b2ShapeDef[((signed long long )2ull)]));
  _ZdlPv((((unsigned char *)llvm_cbe_this)));
  return;
}


static void _ZN12b2PolygonDefD1Ev(struct l_struct_2E_b2PolygonDef *llvm_cbe_this) {
  *(((unsigned int  (***) ())llvm_cbe_this)) = ((&_ZTV10b2ShapeDef[((signed long long )2ull)]));
  return;
}


static void _ZN12b2PolygonDefD0Ev(struct l_struct_2E_b2PolygonDef *llvm_cbe_this) {
  *(((unsigned int  (***) ())llvm_cbe_this)) = ((&_ZTV10b2ShapeDef[((signed long long )2ull)]));
  _ZdlPv(((&llvm_cbe_this->field0[((signed int )0u)])));
  return;
}


static void _ZN17b2ContactListener3AddEPK14b2ContactPoint(struct l_struct_2E_Os *llvm_cbe_this, struct l_struct_2E_b2ContactPoint *llvm_cbe_point) {
  return;
}


static void _ZN17b2ContactListener7PersistEPK14b2ContactPoint(struct l_struct_2E_Os *llvm_cbe_this, struct l_struct_2E_b2ContactPoint *llvm_cbe_point) {
  return;
}


static void _ZN17b2ContactListener6RemoveEPK14b2ContactPoint(struct l_struct_2E_Os *llvm_cbe_this, struct l_struct_2E_b2ContactPoint *llvm_cbe_point) {
  return;
}


static void _ZN17b2ContactListener6ResultEPK15b2ContactResult(struct l_struct_2E_Os *llvm_cbe_this, struct l_struct_2E_b2ContactResult *llvm_cbe_point) {
  return;
}


static struct l_struct_2E_Vec2 _ZNK4Rect8centroidEv(struct l_struct_2E_Rect *llvm_cbe_this) {
  struct l_struct_2E_Vec2 StructReturn;  /* Struct return temporary */
  struct l_struct_2E_Vec2 *llvm_cbe_agg_2e_result = &StructReturn;
  unsigned int llvm_cbe_tmp5_2e_i;
  unsigned int llvm_cbe_tmp8_2e_i;
  unsigned int llvm_cbe_tmp12_2e_i;
  unsigned int llvm_cbe_tmp15_2e_i;

  llvm_cbe_tmp5_2e_i = *((&llvm_cbe_this->field0.field1));
  llvm_cbe_tmp8_2e_i = *((&llvm_cbe_this->field1.field1));
  llvm_cbe_tmp12_2e_i = *((&llvm_cbe_this->field0.field0));
  llvm_cbe_tmp15_2e_i = *((&llvm_cbe_this->field1.field0));
  *((&llvm_cbe_agg_2e_result->field0)) = (((signed int )(((signed int )(llvm_cbe_tmp12_2e_i + llvm_cbe_tmp15_2e_i)) / ((signed int )2u))));
  *((&llvm_cbe_agg_2e_result->field1)) = (((signed int )(((signed int )(llvm_cbe_tmp5_2e_i + llvm_cbe_tmp8_2e_i)) / ((signed int )2u))));
  return StructReturn;
}


static unsigned char _ZN11GameControl4saveEPKc(struct l_struct_2E_GameControl *llvm_cbe_this, unsigned char *llvm_cbe_file) {
  return ((unsigned char )0);
}


static unsigned char _ZN11GameControl4sendEv(struct l_struct_2E_GameControl *llvm_cbe_this) {
  return ((unsigned char )0);
}


static unsigned char _ZN11GameControl4loadEPKc(struct l_struct_2E_GameControl *llvm_cbe_this, unsigned char *llvm_cbe_file) {
  return ((unsigned char )0);
}


static void _ZN11GameControl9gotoLevelEib(struct l_struct_2E_GameControl *llvm_cbe_this, unsigned int llvm_cbe_l, unsigned char llvm_cbe_replay) {
  return;
}


static void _ZN6Stroke6BoxDefD1Ev(struct l_struct_2E_Stroke_3A__3A_BoxDef *llvm_cbe_this) {
  *(((unsigned int  (***) ())llvm_cbe_this)) = ((&_ZTV10b2ShapeDef[((signed long long )2ull)]));
  return;
}


static void _ZN6Stroke6BoxDefD0Ev(struct l_struct_2E_Stroke_3A__3A_BoxDef *llvm_cbe_this) {
  *(((unsigned int  (***) ())llvm_cbe_this)) = ((&_ZTV10b2ShapeDef[((signed long long )2ull)]));
  _ZdlPv(((&llvm_cbe_this->field0.field0[((signed int )0u)])));
  return;
}


static void _ZN17b2ContactListenerD1Ev(struct l_struct_2E_Os *llvm_cbe_this) {
  *((&llvm_cbe_this->field0)) = ((&_ZTV17b2ContactListener[((signed long long )2ull)]));
  return;
}


static void _ZN17b2ContactListenerD0Ev(struct l_struct_2E_Os *llvm_cbe_this) {
  *((&llvm_cbe_this->field0)) = ((&_ZTV17b2ContactListener[((signed long long )2ull)]));
  _ZdlPv((((unsigned char *)llvm_cbe_this)));
  return;
}


static struct l_struct_2E_Vec2 _ZN4Game10mousePointE9SDL_Event(unsigned long long llvm_cbe_ev_2e_0_2e_0, unsigned long long llvm_cbe_ev_2e_0_2e_1, unsigned long long llvm_cbe_ev_2e_0_2e_2) {
  struct l_struct_2E_Vec2 StructReturn;  /* Struct return temporary */
  struct l_struct_2E_Vec2 *llvm_cbe_agg_2e_result = &StructReturn;
  struct l_struct_2E_b2Vec2 llvm_cbe_tmp3_2e_i5;    /* Address-exposed local */
  struct l_struct_2E_SDL_Event llvm_cbe_ev_addr;    /* Address-exposed local */
  struct l_unnamed1 *llvm_cbe_tmp;
  struct l_struct_2E_SDL_MouseButtonEvent *llvm_cbe_tmp89;
  unsigned short llvm_cbe_tmp11;
  unsigned int llvm_cbe_tmp1112;
  unsigned short llvm_cbe_tmp16;
  unsigned int llvm_cbe_tmp1617;
  unsigned int *llvm_cbe_tmp1_2e_i;
  unsigned int *llvm_cbe_tmp4_2e_i;
  unsigned char llvm_cbe_tmp8_2e_i;
  unsigned int llvm_cbe_tmp8_2e_i_2e_i;
  unsigned int llvm_cbe_tmp15_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp18_2e_i_2e_i19__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp21_2e_i_2e_i26__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp21_2e_i_2e_i262728_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp24_2e_i_2e_i18__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp27_2e_i_2e_i24__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp24_2e_i;
  llvmBitCastUnion llvm_cbe_tmp28_2e_i10__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp31_2e_i14__BITCAST_TEMPORARY;

  llvm_cbe_tmp = ((struct l_unnamed1 *)(&llvm_cbe_ev_addr));
  *(((unsigned long long *)(&llvm_cbe_ev_addr))) = llvm_cbe_ev_2e_0_2e_0;
  *((&llvm_cbe_tmp->field0[((signed int )1u)])) = llvm_cbe_ev_2e_0_2e_1;
  *((&llvm_cbe_tmp->field0[((signed int )2u)])) = llvm_cbe_ev_2e_0_2e_2;
  llvm_cbe_tmp89 = ((struct l_struct_2E_SDL_MouseButtonEvent *)(&llvm_cbe_ev_addr));
  llvm_cbe_tmp11 = *((&llvm_cbe_tmp89->field5));
  llvm_cbe_tmp1112 = ((unsigned int )(unsigned short )llvm_cbe_tmp11);
  llvm_cbe_tmp16 = *((&llvm_cbe_tmp89->field4));
  llvm_cbe_tmp1617 = ((unsigned int )(unsigned short )llvm_cbe_tmp16);
  llvm_cbe_tmp1_2e_i = (&llvm_cbe_agg_2e_result->field0);
  *llvm_cbe_tmp1_2e_i = llvm_cbe_tmp1617;
  llvm_cbe_tmp4_2e_i = (&llvm_cbe_agg_2e_result->field1);
  *llvm_cbe_tmp4_2e_i = llvm_cbe_tmp1112;
  llvm_cbe_tmp8_2e_i = *((&worldToScreen.field0));
  if ((llvm_cbe_tmp8_2e_i == ((unsigned char )0))) {
    goto llvm_cbe_bb_2e_i;
  } else {
    goto llvm_cbe_return;
  }

llvm_cbe_bb_2e_i:
  llvm_cbe_tmp8_2e_i_2e_i = *((&worldToScreen.field3.field1));
  llvm_cbe_tmp15_2e_i_2e_i = *((&worldToScreen.field3.field0));
  llvm_cbe_tmp21_2e_i_2e_i262728_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp18_2e_i_2e_i19__BITCAST_TEMPORARY.Float = (((float )(signed int )(llvm_cbe_tmp1617 - llvm_cbe_tmp15_2e_i_2e_i))), llvm_cbe_tmp18_2e_i_2e_i19__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp21_2e_i_2e_i26__BITCAST_TEMPORARY.Float = (((float )(signed int )(llvm_cbe_tmp1112 - llvm_cbe_tmp8_2e_i_2e_i))), llvm_cbe_tmp21_2e_i_2e_i26__BITCAST_TEMPORARY.Int32)))) << 32ull);
  *((&llvm_cbe_tmp3_2e_i5.field0)) = ((llvm_cbe_tmp24_2e_i_2e_i18__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp21_2e_i_2e_i262728_2e_ins)), llvm_cbe_tmp24_2e_i_2e_i18__BITCAST_TEMPORARY.Float));
  *((&llvm_cbe_tmp3_2e_i5.field1)) = ((llvm_cbe_tmp27_2e_i_2e_i24__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp21_2e_i_2e_i262728_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp27_2e_i_2e_i24__BITCAST_TEMPORARY.Float));
  llvm_cbe_tmp24_2e_i = _Z5b2MulRK7b2Mat22RK6b2Vec2(((&worldToScreen.field2)), (&llvm_cbe_tmp3_2e_i5));
  *llvm_cbe_tmp1_2e_i = (((signed int )((llvm_cbe_tmp28_2e_i10__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp24_2e_i)), llvm_cbe_tmp28_2e_i10__BITCAST_TEMPORARY.Float))));
  *llvm_cbe_tmp4_2e_i = (((signed int )((llvm_cbe_tmp31_2e_i14__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp24_2e_i) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp31_2e_i14__BITCAST_TEMPORARY.Float))));
  return StructReturn;
llvm_cbe_return:
  return StructReturn;
}


static void __tcf_1(unsigned char *llvm_cbe_unnamed_arg) {
  _ZNSsD1Ev((&_ZZN6Config10planetRootEvE1d));
  return;
}


static void __tcf_0(unsigned char *llvm_cbe_unnamed_arg) {
  _ZNSsD1Ev((&_ZZN6Config11userDataDirEvE1d));
  return;
}


static void _ZN5Scene3AddEPK14b2ContactPoint(struct l_struct_2E_Scene *llvm_cbe_this, struct l_struct_2E_b2ContactPoint *llvm_cbe_point) {
  struct l_struct_2E_b2Shape *llvm_cbe_tmp2;
  struct l_struct_2E_b2Body *llvm_cbe_tmp3_2e_i;
  unsigned char *llvm_cbe_tmp3_2e_i55;
  struct l_struct_2E_Stroke *llvm_cbe_tmp45;
  struct l_struct_2E_b2Shape *llvm_cbe_tmp8;
  struct l_struct_2E_b2Body *llvm_cbe_tmp3_2e_i51;
  unsigned char *llvm_cbe_tmp3_2e_i47;
  struct l_struct_2E_Stroke *llvm_cbe_tmp1011;
  unsigned int llvm_cbe_tmp3_2e_i38;
  struct l_struct_2E_Stroke *llvm_cbe_s2_2e_0;
  unsigned int llvm_cbe_tmp3_2e_i17;
  unsigned int *llvm_cbe_tmp2_2e_i7;
  unsigned int llvm_cbe_tmp3_2e_i8;
  unsigned int llvm_cbe_tmp4_2e_i;

  llvm_cbe_tmp2 = *((&llvm_cbe_point->field0));
  llvm_cbe_tmp3_2e_i = *((&llvm_cbe_tmp2->field3));
  llvm_cbe_tmp3_2e_i55 = *((&llvm_cbe_tmp3_2e_i->field22));
  llvm_cbe_tmp45 = ((struct l_struct_2E_Stroke *)llvm_cbe_tmp3_2e_i55);
  llvm_cbe_tmp8 = *((&llvm_cbe_point->field1));
  llvm_cbe_tmp3_2e_i51 = *((&llvm_cbe_tmp8->field3));
  llvm_cbe_tmp3_2e_i47 = *((&llvm_cbe_tmp3_2e_i51->field22));
  llvm_cbe_tmp1011 = ((struct l_struct_2E_Stroke *)llvm_cbe_tmp3_2e_i47);
  if (((((llvm_cbe_tmp3_2e_i55 == ((unsigned char *)/*NULL*/0)) | (llvm_cbe_tmp3_2e_i47 == ((unsigned char *)/*NULL*/0)))&1))) {
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb19;
  }

llvm_cbe_bb19:
  llvm_cbe_tmp3_2e_i38 = *((&llvm_cbe_tmp1011->field2));
  llvm_cbe_s2_2e_0 = ((((llvm_cbe_tmp3_2e_i38 & 2u) == 0u)) ? (llvm_cbe_tmp1011) : (llvm_cbe_tmp45));
  llvm_cbe_tmp3_2e_i17 = *((&(((((llvm_cbe_tmp3_2e_i38 & 2u) == 0u)) ? (llvm_cbe_tmp45) : (llvm_cbe_tmp1011)))->field2));
  if (((llvm_cbe_tmp3_2e_i17 & 2u) == 0u)) {
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb31;
  }

llvm_cbe_bb31:
  llvm_cbe_tmp2_2e_i7 = (&llvm_cbe_s2_2e_0->field2);
  llvm_cbe_tmp3_2e_i8 = *llvm_cbe_tmp2_2e_i7;
  if (((llvm_cbe_tmp3_2e_i8 & 4u) == 0u)) {
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb43;
  }

llvm_cbe_bb43:
  llvm_cbe_tmp4_2e_i = llvm_cbe_tmp3_2e_i8 | 64u;
  *llvm_cbe_tmp2_2e_i7 = llvm_cbe_tmp4_2e_i;
  if (((llvm_cbe_tmp4_2e_i & 2u) == 0u)) {
    goto llvm_cbe_bb17_2e_i;
  } else {
    goto llvm_cbe_bb_2e_i;
  }

llvm_cbe_bb_2e_i:
  *((&llvm_cbe_s2_2e_0->field1)) = 12058624u;
  return;
llvm_cbe_bb17_2e_i:
  if (((llvm_cbe_tmp4_2e_i & 4u) == 0u)) {
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb25_2e_i;
  }

llvm_cbe_bb25_2e_i:
  *((&llvm_cbe_s2_2e_0->field1)) = 15649024u;
  return;
llvm_cbe_return:
  return;
}


static unsigned char _ZN5Scene11isCompletedEv(struct l_struct_2E_Scene *llvm_cbe_this) {
  unsigned int llvm_cbe_tmp3_2e_i;
  struct l_struct_2E_Stroke ***llvm_cbe_tmp2_2e_i_2e_i;
  struct l_struct_2E_Stroke **llvm_cbe_tmp3_2e_i_2e_i;
  struct l_struct_2E_Stroke *llvm_cbe_tmp5;
  unsigned int llvm_cbe_tmp3_2e_i29;
  unsigned int llvm_cbe_tmp3_2e_i8;
  unsigned int llvm_cbe_tmp30;
  unsigned int llvm_cbe_storemerge2;
  unsigned int llvm_cbe_storemerge2__PHI_TEMPORARY;
  unsigned char llvm_cbe_storemerge1;
  unsigned char llvm_cbe_storemerge1__PHI_TEMPORARY;

  llvm_cbe_tmp3_2e_i = *((&llvm_cbe_this->field2.field1));
  llvm_cbe_tmp2_2e_i_2e_i = (&llvm_cbe_this->field2.field0);
  llvm_cbe_storemerge2__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb31;

  do {     /* Syntactic loop 'bb31' to make GCC happy */
llvm_cbe_bb31:
  llvm_cbe_storemerge2 = llvm_cbe_storemerge2__PHI_TEMPORARY;
  if ((((signed int )llvm_cbe_tmp3_2e_i) > ((signed int )llvm_cbe_storemerge2))) {
    goto llvm_cbe_bb;
  } else {
    llvm_cbe_storemerge1__PHI_TEMPORARY = ((unsigned char )1);   /* for PHI node */
    goto llvm_cbe_return;
  }

llvm_cbe_bb28:
  llvm_cbe_tmp30 = llvm_cbe_storemerge2 + 1u;
  llvm_cbe_storemerge2__PHI_TEMPORARY = llvm_cbe_tmp30;   /* for PHI node */
  goto llvm_cbe_bb31;

llvm_cbe_bb:
  llvm_cbe_tmp3_2e_i_2e_i = *llvm_cbe_tmp2_2e_i_2e_i;
  llvm_cbe_tmp5 = *((&llvm_cbe_tmp3_2e_i_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge2)))]));
  llvm_cbe_tmp3_2e_i29 = *((&llvm_cbe_tmp5->field2));
  if (((llvm_cbe_tmp3_2e_i29 & 4u) == 0u)) {
    goto llvm_cbe_bb28;
  } else {
    goto llvm_cbe_bb9;
  }

llvm_cbe_bb9:
  llvm_cbe_tmp3_2e_i8 = *((&llvm_cbe_tmp5->field14));
  if ((((signed int )llvm_cbe_tmp3_2e_i8) > ((signed int )79u))) {
    goto llvm_cbe_bb28;
  } else {
    llvm_cbe_storemerge1__PHI_TEMPORARY = ((unsigned char )0);   /* for PHI node */
    goto llvm_cbe_return;
  }

  } while (1); /* end of syntactic loop 'bb31' */
llvm_cbe_return:
  llvm_cbe_storemerge1 = llvm_cbe_storemerge1__PHI_TEMPORARY;
  return llvm_cbe_storemerge1;
}


static struct l_struct_2E_b2AABB _ZNK7b2Mat226InvertEv(struct l_struct_2E_b2AABB *llvm_cbe_this) {
  struct l_struct_2E_b2AABB StructReturn;  /* Struct return temporary */
  struct l_struct_2E_b2AABB *llvm_cbe_agg_2e_result = &StructReturn;
  float llvm_cbe_tmp4;
  float llvm_cbe_tmp8;
  float llvm_cbe_tmp12;
  float llvm_cbe_tmp16;
  float llvm_cbe_tmp23;
  float llvm_cbe_tmp32;
  float llvm_cbe_tmp39;

  llvm_cbe_tmp4 = *((&llvm_cbe_this->field0.field0));
  llvm_cbe_tmp8 = *((&llvm_cbe_this->field1.field0));
  llvm_cbe_tmp12 = *((&llvm_cbe_this->field0.field1));
  llvm_cbe_tmp16 = *((&llvm_cbe_this->field1.field1));
  llvm_cbe_tmp23 = ((float )((((float )(llvm_cbe_tmp4 * llvm_cbe_tmp16))) - (((float )(llvm_cbe_tmp8 * llvm_cbe_tmp12)))));
  if ((llvm_fcmp_oeq(llvm_cbe_tmp23, 0x0p+0))) {
    goto llvm_cbe_bb;
  } else {
    goto llvm_cbe_bb30;
  }

llvm_cbe_bb:
  __assert_fail(((&_2E_str25[((signed long long )0ull)])), ((&_2E_str126[((signed long long )0ull)])), 347u, ((&_ZZNK7b2Mat226InvertEvE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb30:
  llvm_cbe_tmp32 = ((float )(0x1p+0 / llvm_cbe_tmp23));
  llvm_cbe_tmp39 = ((float )(-(llvm_cbe_tmp32)));
  *((&llvm_cbe_agg_2e_result->field0.field0)) = (((float )(llvm_cbe_tmp32 * llvm_cbe_tmp16)));
  *((&llvm_cbe_agg_2e_result->field0.field1)) = (((float )(llvm_cbe_tmp12 * llvm_cbe_tmp39)));
  *((&llvm_cbe_agg_2e_result->field1.field0)) = (((float )(llvm_cbe_tmp8 * llvm_cbe_tmp39)));
  *((&llvm_cbe_agg_2e_result->field1.field1)) = (((float )(llvm_cbe_tmp32 * llvm_cbe_tmp4)));
  return StructReturn;
}


static void _ZN9Transform3setEffRK4Vec2(struct l_struct_2E_Transform *llvm_cbe_this, float llvm_cbe_scale, float llvm_cbe_rotation, struct l_struct_2E_Vec2 *llvm_cbe_translation) {
  unsigned int llvm_cbe_tmp3_2e_i4;
  float llvm_cbe_tmp1_2e_i8;
  float llvm_cbe_tmp3_2e_i10;
  unsigned int llvm_cbe_tmp32;
  unsigned int llvm_cbe_tmp35;
  float *llvm_cbe_tmp39;
  float llvm_cbe_tmp40;
  float *llvm_cbe_tmp50;
  float llvm_cbe_tmp51;
  float *llvm_cbe_tmp62;
  float llvm_cbe_tmp63;
  float *llvm_cbe_tmp73;
  float llvm_cbe_tmp74;

  if (((((llvm_fcmp_une(llvm_cbe_scale, 0x0p+0)) | (llvm_fcmp_une(llvm_cbe_rotation, 0x0p+0)))&1))) {
    goto llvm_cbe_bb23;
  } else {
    goto llvm_cbe_bb8;
  }

llvm_cbe_bb8:
  llvm_cbe_tmp3_2e_i4 = *((&llvm_cbe_translation->field0));
  if ((llvm_cbe_tmp3_2e_i4 == 0u)) {
    goto llvm_cbe_bb20;
  } else {
    goto llvm_cbe_bb23;
  }

llvm_cbe_bb20:
  *((&llvm_cbe_this->field0)) = ((unsigned char )1);
  return;
llvm_cbe_bb23:
  llvm_cbe_tmp1_2e_i8 = cosf(llvm_cbe_rotation);
  llvm_cbe_tmp3_2e_i10 = sinf(llvm_cbe_rotation);
  *((&llvm_cbe_this->field1.field0.field0)) = llvm_cbe_tmp1_2e_i8;
  *((&llvm_cbe_this->field1.field1.field0)) = (((float )(-(llvm_cbe_tmp3_2e_i10))));
  *((&llvm_cbe_this->field1.field0.field1)) = llvm_cbe_tmp3_2e_i10;
  *((&llvm_cbe_this->field1.field1.field1)) = llvm_cbe_tmp1_2e_i8;
  llvm_cbe_tmp32 = *((&llvm_cbe_translation->field0));
  *((&llvm_cbe_this->field3.field0)) = llvm_cbe_tmp32;
  llvm_cbe_tmp35 = *((&llvm_cbe_translation->field1));
  *((&llvm_cbe_this->field3.field1)) = llvm_cbe_tmp35;
  llvm_cbe_tmp39 = (&llvm_cbe_this->field1.field0.field0);
  llvm_cbe_tmp40 = *llvm_cbe_tmp39;
  *llvm_cbe_tmp39 = (((float )(llvm_cbe_tmp40 * llvm_cbe_scale)));
  llvm_cbe_tmp50 = (&llvm_cbe_this->field1.field0.field1);
  llvm_cbe_tmp51 = *llvm_cbe_tmp50;
  *llvm_cbe_tmp50 = (((float )(llvm_cbe_tmp51 * llvm_cbe_scale)));
  llvm_cbe_tmp62 = (&llvm_cbe_this->field1.field1.field0);
  llvm_cbe_tmp63 = *llvm_cbe_tmp62;
  *llvm_cbe_tmp62 = (((float )(llvm_cbe_tmp63 * llvm_cbe_scale)));
  llvm_cbe_tmp73 = (&llvm_cbe_this->field1.field1.field1);
  llvm_cbe_tmp74 = *llvm_cbe_tmp73;
  *llvm_cbe_tmp73 = (((float )(llvm_cbe_tmp74 * llvm_cbe_scale)));
  *(((&llvm_cbe_this->field2))) = _ZNK7b2Mat226InvertEv(((&llvm_cbe_this->field1)));
  *((&llvm_cbe_this->field0)) = ((unsigned char )0);
  return;
}


static void __tcf_2(unsigned char *llvm_cbe_unnamed_arg) {
  _ZNSt8ios_base4InitD1Ev((&_ZStL8__ioinit));
  return;
}


static void _Z24configureScreenTransformii(unsigned int llvm_cbe_w, unsigned int llvm_cbe_h) {
  struct l_struct_2E_Vec2 llvm_cbe_tr;    /* Address-exposed local */
  struct l_struct_2E_Vec2 llvm_cbe_tmp1;    /* Address-exposed local */
  unsigned int *llvm_cbe_tmp1_2e_i12;
  unsigned int *llvm_cbe_tmp4_2e_i15;
  unsigned int llvm_cbe_h_addr_2e_0;
  unsigned int llvm_cbe_h_addr_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_w_addr_2e_0;
  unsigned int llvm_cbe_w_addr_2e_0__PHI_TEMPORARY;
  float llvm_cbe_rot_2e_0;
  float llvm_cbe_rot_2e_0__PHI_TEMPORARY;
  float llvm_cbe_tmp50;
  float llvm_cbe_tmp53;

  *(&SCREEN_WIDTH) = llvm_cbe_w;
  *(&SCREEN_HEIGHT) = llvm_cbe_h;
  *((&FULLSCREEN_RECT.field0.field0)) = 0u;
  *((&FULLSCREEN_RECT.field0.field1)) = 0u;
  *((&FULLSCREEN_RECT.field1.field0)) = (llvm_cbe_w + 4294967295u);
  *((&FULLSCREEN_RECT.field1.field1)) = (llvm_cbe_h + 4294967295u);
  if (((((llvm_cbe_w == 800u) & (llvm_cbe_h == 480u))&1))) {
    goto llvm_cbe_bb32;
  } else {
    goto llvm_cbe_bb33;
  }

llvm_cbe_bb32:
  *((&llvm_cbe_tmp1.field0)) = 0u;
  *((&llvm_cbe_tmp1.field1)) = 0u;
  _ZN9Transform3setEffRK4Vec2((&worldToScreen), 0x0p+0, 0x0p+0, (&llvm_cbe_tmp1));
  return;
llvm_cbe_bb33:
  llvm_cbe_tmp1_2e_i12 = (&llvm_cbe_tr.field0);
  *llvm_cbe_tmp1_2e_i12 = 0u;
  llvm_cbe_tmp4_2e_i15 = (&llvm_cbe_tr.field1);
  *llvm_cbe_tmp4_2e_i15 = 0u;
  if ((((signed int )llvm_cbe_h) > ((signed int )llvm_cbe_w))) {
    goto llvm_cbe_bb39;
  } else {
    llvm_cbe_h_addr_2e_0__PHI_TEMPORARY = llvm_cbe_h;   /* for PHI node */
    llvm_cbe_w_addr_2e_0__PHI_TEMPORARY = llvm_cbe_w;   /* for PHI node */
    llvm_cbe_rot_2e_0__PHI_TEMPORARY = 0x0p+0;   /* for PHI node */
    goto llvm_cbe_bb47;
  }

llvm_cbe_bb39:
  *llvm_cbe_tmp1_2e_i12 = llvm_cbe_w;
  *llvm_cbe_tmp4_2e_i15 = 0u;
  llvm_cbe_h_addr_2e_0__PHI_TEMPORARY = llvm_cbe_w;   /* for PHI node */
  llvm_cbe_w_addr_2e_0__PHI_TEMPORARY = llvm_cbe_h;   /* for PHI node */
  llvm_cbe_rot_2e_0__PHI_TEMPORARY = 0x1.921fb6p+0;   /* for PHI node */
  goto llvm_cbe_bb47;

llvm_cbe_bb47:
  llvm_cbe_h_addr_2e_0 = llvm_cbe_h_addr_2e_0__PHI_TEMPORARY;
  llvm_cbe_w_addr_2e_0 = llvm_cbe_w_addr_2e_0__PHI_TEMPORARY;
  llvm_cbe_rot_2e_0 = llvm_cbe_rot_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp50 = ((float )((((float )(signed int )llvm_cbe_w_addr_2e_0)) / 0x1.9p+9));
  llvm_cbe_tmp53 = ((float )((((float )(signed int )llvm_cbe_h_addr_2e_0)) / 0x1.ep+8));
  if ((llvm_fcmp_olt(llvm_cbe_tmp50, llvm_cbe_tmp53))) {
    goto llvm_cbe_bb59;
  } else {
    goto llvm_cbe_bb62;
  }

llvm_cbe_bb59:
  _ZN9Transform3setEffRK4Vec2((&worldToScreen), llvm_cbe_tmp50, llvm_cbe_rot_2e_0, (&llvm_cbe_tr));
  return;
llvm_cbe_bb62:
  _ZN9Transform3setEffRK4Vec2((&worldToScreen), llvm_cbe_tmp53, llvm_cbe_rot_2e_0, (&llvm_cbe_tr));
  return;
}


static void _ZN5ArrayIP6StrokeE6appendERKS1_(struct l_struct_2E_Array_3C_Stroke_2A__3E_ *llvm_cbe_this, struct l_struct_2E_Stroke **llvm_cbe_t) {
  unsigned int *llvm_cbe_tmp1;
  unsigned int llvm_cbe_tmp2;
  unsigned int llvm_cbe_tmp3;
  unsigned int *llvm_cbe_tmp1_2e_i;
  unsigned int llvm_cbe_tmp2_2e_i;
  unsigned int llvm_cbe_storemerge_2e_i;
  unsigned int llvm_cbe_tmp22_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_i__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp27_2e_i_2e_i;
  struct l_struct_2E_Stroke ***llvm_cbe_tmp17_2e_i_2e_i;
  struct l_struct_2E_Stroke **llvm_cbe_tmp18_2e_i_2e_i;
  unsigned char *llvm_cbe_tmp20_2e_i_2e_i;
  unsigned char *llvm_cbe_tmp28_2e_i_2e_i;
  struct l_struct_2E_Stroke **llvm_cbe_tmp7;
  unsigned int llvm_cbe_tmp10;
  struct l_struct_2E_Stroke *llvm_cbe_tmp12;

  llvm_cbe_tmp1 = (&llvm_cbe_this->field1);
  llvm_cbe_tmp2 = *llvm_cbe_tmp1;
  llvm_cbe_tmp3 = llvm_cbe_tmp2 + 1u;
  llvm_cbe_tmp1_2e_i = (&llvm_cbe_this->field2);
  llvm_cbe_tmp2_2e_i = *llvm_cbe_tmp1_2e_i;
  if ((((signed int )llvm_cbe_tmp2_2e_i) < ((signed int )llvm_cbe_tmp3))) {
    goto llvm_cbe_bb_2e_i;
  } else {
    goto llvm_cbe__ZN5ArrayIP6StrokeE14ensureCapacityEi_2e_exit;
  }

llvm_cbe_bb_2e_i:
  llvm_cbe_storemerge_2e_i = (((llvm_cbe_tmp2_2e_i == 0u)) ? (4u) : (llvm_cbe_tmp2_2e_i));
  llvm_cbe_storemerge1_2e_i__PHI_TEMPORARY = llvm_cbe_storemerge_2e_i;   /* for PHI node */
  goto llvm_cbe_bb23_2e_i;

  do {     /* Syntactic loop 'bb23.i' to make GCC happy */
llvm_cbe_bb23_2e_i:
  llvm_cbe_storemerge1_2e_i = llvm_cbe_storemerge1_2e_i__PHI_TEMPORARY;
  if ((((signed int )llvm_cbe_storemerge1_2e_i) < ((signed int )llvm_cbe_tmp3))) {
    goto llvm_cbe_bb19_2e_i;
  } else {
    goto llvm_cbe_bb29_2e_i;
  }

llvm_cbe_bb19_2e_i:
  llvm_cbe_tmp22_2e_i = llvm_cbe_storemerge1_2e_i << 1u;
  llvm_cbe_storemerge1_2e_i__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i;   /* for PHI node */
  goto llvm_cbe_bb23_2e_i;

  } while (1); /* end of syntactic loop 'bb23.i' */
llvm_cbe_bb29_2e_i:
  if ((((signed int )llvm_cbe_tmp2) > ((signed int )llvm_cbe_storemerge1_2e_i))) {
    goto llvm_cbe__ZN5ArrayIP6StrokeE14ensureCapacityEi_2e_exit;
  } else {
    goto llvm_cbe_bb_2e_i_2e_i;
  }

llvm_cbe_bb_2e_i_2e_i:
  llvm_cbe_tmp27_2e_i_2e_i = (((signed long long )(signed int )llvm_cbe_storemerge1_2e_i)) << 3ull;
  if ((llvm_cbe_tmp2_2e_i == 0u)) {
    goto llvm_cbe_bb24_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb12_2e_i_2e_i;
  }

llvm_cbe_bb12_2e_i_2e_i:
  llvm_cbe_tmp17_2e_i_2e_i = (&llvm_cbe_this->field0);
  llvm_cbe_tmp18_2e_i_2e_i = *llvm_cbe_tmp17_2e_i_2e_i;
  llvm_cbe_tmp20_2e_i_2e_i = realloc((((unsigned char *)llvm_cbe_tmp18_2e_i_2e_i)), llvm_cbe_tmp27_2e_i_2e_i);
  *llvm_cbe_tmp17_2e_i_2e_i = (((struct l_struct_2E_Stroke **)llvm_cbe_tmp20_2e_i_2e_i));
  goto llvm_cbe_bb32_2e_i_2e_i;

llvm_cbe_bb24_2e_i_2e_i:
  llvm_cbe_tmp28_2e_i_2e_i = malloc(llvm_cbe_tmp27_2e_i_2e_i);
  *((&llvm_cbe_this->field0)) = (((struct l_struct_2E_Stroke **)llvm_cbe_tmp28_2e_i_2e_i));
  goto llvm_cbe_bb32_2e_i_2e_i;

llvm_cbe_bb32_2e_i_2e_i:
  *llvm_cbe_tmp1_2e_i = llvm_cbe_storemerge1_2e_i;
  goto llvm_cbe__ZN5ArrayIP6StrokeE14ensureCapacityEi_2e_exit;

llvm_cbe__ZN5ArrayIP6StrokeE14ensureCapacityEi_2e_exit:
  llvm_cbe_tmp7 = *((&llvm_cbe_this->field0));
  llvm_cbe_tmp10 = *llvm_cbe_tmp1;
  llvm_cbe_tmp12 = *llvm_cbe_t;
  *((&llvm_cbe_tmp7[((signed long long )(((signed long long )(signed int )llvm_cbe_tmp10)))])) = llvm_cbe_tmp12;
  *llvm_cbe_tmp1 = (llvm_cbe_tmp10 + 1u);
  return;
}


static void _ZN4Game11showOverlayEP7Overlay(struct l_struct_2E_Game *llvm_cbe_this, struct l_struct_2E_Os *llvm_cbe_o) {
  unsigned int *llvm_cbe_tmp1_2e_i;
  unsigned int llvm_cbe_tmp2_2e_i;
  unsigned int llvm_cbe_tmp3_2e_i;
  unsigned int *llvm_cbe_tmp1_2e_i_2e_i;
  unsigned int llvm_cbe_tmp2_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge_2e_i_2e_i;
  unsigned int llvm_cbe_tmp22_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_i_2e_i__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp27_2e_i_2e_i_2e_i;
  struct l_struct_2E_Os ***llvm_cbe_tmp17_2e_i_2e_i_2e_i;
  struct l_struct_2E_Os **llvm_cbe_tmp18_2e_i_2e_i_2e_i;
  unsigned char *llvm_cbe_tmp20_2e_i_2e_i_2e_i;
  unsigned char *llvm_cbe_tmp28_2e_i_2e_i_2e_i;
  struct l_struct_2E_Os **llvm_cbe_tmp7_2e_i;
  unsigned int llvm_cbe_tmp10_2e_i;
  unsigned int  (**llvm_cbe_tmp5) ();
  unsigned int  (*llvm_cbe_tmp7) ();

  llvm_cbe_tmp1_2e_i = (&llvm_cbe_this->field4.field1);
  llvm_cbe_tmp2_2e_i = *llvm_cbe_tmp1_2e_i;
  llvm_cbe_tmp3_2e_i = llvm_cbe_tmp2_2e_i + 1u;
  llvm_cbe_tmp1_2e_i_2e_i = (&llvm_cbe_this->field4.field2);
  llvm_cbe_tmp2_2e_i_2e_i = *llvm_cbe_tmp1_2e_i_2e_i;
  if ((((signed int )llvm_cbe_tmp2_2e_i_2e_i) < ((signed int )llvm_cbe_tmp3_2e_i))) {
    goto llvm_cbe_bb_2e_i_2e_i;
  } else {
    goto llvm_cbe__ZN5ArrayIP7OverlayE6appendERKS1__2e_exit;
  }

llvm_cbe_bb_2e_i_2e_i:
  llvm_cbe_storemerge_2e_i_2e_i = (((llvm_cbe_tmp2_2e_i_2e_i == 0u)) ? (4u) : (llvm_cbe_tmp2_2e_i_2e_i));
  llvm_cbe_storemerge1_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_storemerge_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb23_2e_i_2e_i;

  do {     /* Syntactic loop 'bb23.i.i' to make GCC happy */
llvm_cbe_bb23_2e_i_2e_i:
  llvm_cbe_storemerge1_2e_i_2e_i = llvm_cbe_storemerge1_2e_i_2e_i__PHI_TEMPORARY;
  if ((((signed int )llvm_cbe_storemerge1_2e_i_2e_i) < ((signed int )llvm_cbe_tmp3_2e_i))) {
    goto llvm_cbe_bb19_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb29_2e_i_2e_i;
  }

llvm_cbe_bb19_2e_i_2e_i:
  llvm_cbe_tmp22_2e_i_2e_i = llvm_cbe_storemerge1_2e_i_2e_i << 1u;
  llvm_cbe_storemerge1_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb23_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb23.i.i' */
llvm_cbe_bb29_2e_i_2e_i:
  if ((((signed int )llvm_cbe_tmp2_2e_i) > ((signed int )llvm_cbe_storemerge1_2e_i_2e_i))) {
    goto llvm_cbe__ZN5ArrayIP7OverlayE6appendERKS1__2e_exit;
  } else {
    goto llvm_cbe_bb_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb_2e_i_2e_i_2e_i:
  llvm_cbe_tmp27_2e_i_2e_i_2e_i = (((signed long long )(signed int )llvm_cbe_storemerge1_2e_i_2e_i)) << 3ull;
  if ((llvm_cbe_tmp2_2e_i_2e_i == 0u)) {
    goto llvm_cbe_bb24_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb12_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb12_2e_i_2e_i_2e_i:
  llvm_cbe_tmp17_2e_i_2e_i_2e_i = (&llvm_cbe_this->field4.field0);
  llvm_cbe_tmp18_2e_i_2e_i_2e_i = *llvm_cbe_tmp17_2e_i_2e_i_2e_i;
  llvm_cbe_tmp20_2e_i_2e_i_2e_i = realloc((((unsigned char *)llvm_cbe_tmp18_2e_i_2e_i_2e_i)), llvm_cbe_tmp27_2e_i_2e_i_2e_i);
  *llvm_cbe_tmp17_2e_i_2e_i_2e_i = (((struct l_struct_2E_Os **)llvm_cbe_tmp20_2e_i_2e_i_2e_i));
  goto llvm_cbe_bb32_2e_i_2e_i_2e_i;

llvm_cbe_bb24_2e_i_2e_i_2e_i:
  llvm_cbe_tmp28_2e_i_2e_i_2e_i = malloc(llvm_cbe_tmp27_2e_i_2e_i_2e_i);
  *((&llvm_cbe_this->field4.field0)) = (((struct l_struct_2E_Os **)llvm_cbe_tmp28_2e_i_2e_i_2e_i));
  goto llvm_cbe_bb32_2e_i_2e_i_2e_i;

llvm_cbe_bb32_2e_i_2e_i_2e_i:
  *llvm_cbe_tmp1_2e_i_2e_i = llvm_cbe_storemerge1_2e_i_2e_i;
  goto llvm_cbe__ZN5ArrayIP7OverlayE6appendERKS1__2e_exit;

llvm_cbe__ZN5ArrayIP7OverlayE6appendERKS1__2e_exit:
  llvm_cbe_tmp7_2e_i = *((&llvm_cbe_this->field4.field0));
  llvm_cbe_tmp10_2e_i = *llvm_cbe_tmp1_2e_i;
  *((&llvm_cbe_tmp7_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_tmp10_2e_i)))])) = llvm_cbe_o;
  *llvm_cbe_tmp1_2e_i = (llvm_cbe_tmp10_2e_i + 1u);
  llvm_cbe_tmp5 = *((&llvm_cbe_o->field0));
  llvm_cbe_tmp7 = *((&llvm_cbe_tmp5[((signed long long )4ull)]));
  (((void  (*) (struct l_struct_2E_Os *))llvm_cbe_tmp7))(llvm_cbe_o);
  return;
}


static void _ZN7b2World11DestroyBodyEP6b2Body(struct l_struct_2E_b2World *llvm_cbe_this, struct l_struct_2E_b2Body *llvm_cbe_b) {
  struct l_struct_2E_b2AABB llvm_cbe_aabb_2e_i_2e_i;    /* Address-exposed local */
  unsigned int *llvm_cbe_tmp1;
  unsigned int llvm_cbe_tmp2;
  unsigned char *llvm_cbe_tmp10;
  unsigned char llvm_cbe_tmp11;
  struct l_struct_2E_b2JointEdge *llvm_cbe_tmp25;
  struct l_struct_2E_Os **llvm_cbe_tmp32;
  struct l_struct_2E_b2Joint **llvm_cbe_tmp41_2e_i;
  unsigned int *llvm_cbe_tmp182_2e_i;
  struct l_struct_2E_b2BroadPhase **llvm_cbe_tmp225_2e_i;
  struct l_struct_2E_b2JointEdge *llvm_cbe_tmp30;
  struct l_struct_2E_Os *llvm_cbe_tmp33;
  unsigned int  (**llvm_cbe_tmp46) ();
  unsigned int  (*llvm_cbe_tmp48) ();
  struct l_struct_2E_b2Joint *llvm_cbe_tmp51;
  struct l_struct_2E_b2Joint *llvm_cbe_tmp59;
  unsigned char llvm_cbe_tmp2_2e_i;
  unsigned char llvm_cbe_tmp9_2e_i;
  struct l_struct_2E_b2Joint **llvm_cbe_tmp11_2e_i;
  struct l_struct_2E_b2Joint *llvm_cbe_tmp12_2e_i;
  struct l_struct_2E_b2Joint *llvm_cbe_tmp22_2e_i;
  struct l_struct_2E_b2Joint **llvm_cbe_tmp26_2e_i;
  struct l_struct_2E_b2Joint *llvm_cbe_tmp27_2e_i;
  struct l_struct_2E_b2Joint *llvm_cbe_tmp37_2e_i;
  struct l_struct_2E_b2Joint *llvm_cbe_tmp42_2e_i;
  struct l_struct_2E_b2Joint *llvm_cbe_tmp50_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp56_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp59_2e_i;
  unsigned short *llvm_cbe_tmp1_2e_i_2e_i;
  unsigned short llvm_cbe_tmp2_2e_i_2e_i;
  unsigned short *llvm_cbe_tmp1_2e_i33_2e_i;
  unsigned short llvm_cbe_tmp2_2e_i34_2e_i;
  struct l_struct_2E_b2JointEdge **llvm_cbe_tmp64_2e_i;
  struct l_struct_2E_b2JointEdge *llvm_cbe_tmp65_2e_i;
  struct l_struct_2E_b2JointEdge *llvm_cbe_tmp77_2e_i;
  struct l_struct_2E_b2JointEdge **llvm_cbe_tmp82_2e_i;
  struct l_struct_2E_b2JointEdge *llvm_cbe_tmp83_2e_i;
  struct l_struct_2E_b2JointEdge *llvm_cbe_tmp95_2e_i;
  struct l_struct_2E_b2JointEdge **llvm_cbe_tmp101_2e_i;
  struct l_struct_2E_b2JointEdge *llvm_cbe_tmp102_2e_i;
  struct l_struct_2E_b2JointEdge *llvm_cbe_tmp110_2e_i;
  struct l_struct_2E_b2JointEdge **llvm_cbe_tmp122_2e_i;
  struct l_struct_2E_b2JointEdge *llvm_cbe_tmp123_2e_i;
  struct l_struct_2E_b2JointEdge *llvm_cbe_tmp135_2e_i;
  struct l_struct_2E_b2JointEdge **llvm_cbe_tmp140_2e_i;
  struct l_struct_2E_b2JointEdge *llvm_cbe_tmp141_2e_i;
  struct l_struct_2E_b2JointEdge *llvm_cbe_tmp153_2e_i;
  struct l_struct_2E_b2JointEdge **llvm_cbe_tmp159_2e_i;
  struct l_struct_2E_b2JointEdge *llvm_cbe_tmp160_2e_i;
  struct l_struct_2E_b2JointEdge *llvm_cbe_tmp168_2e_i;
  unsigned int  (**llvm_cbe_tmp2_2e_i13_2e_i) ();
  unsigned int  (*llvm_cbe_tmp4_2e_i15_2e_i) ();
  unsigned int llvm_cbe_tmp9_2e_i18_2e_i;
  unsigned char llvm_cbe_tmp20_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2Block **llvm_cbe_tmp42_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2Block *llvm_cbe_tmp43_2e_i_2e_i_2e_i;
  unsigned char llvm_cbe_tmp20_2e_i163_2e_i_2e_i;
  struct l_struct_2E_b2Block **llvm_cbe_tmp42_2e_i176_2e_i_2e_i;
  struct l_struct_2E_b2Block *llvm_cbe_tmp43_2e_i177_2e_i_2e_i;
  unsigned char llvm_cbe_tmp20_2e_i126_2e_i_2e_i;
  struct l_struct_2E_b2Block **llvm_cbe_tmp42_2e_i139_2e_i_2e_i;
  struct l_struct_2E_b2Block *llvm_cbe_tmp43_2e_i140_2e_i_2e_i;
  unsigned char llvm_cbe_tmp20_2e_i89_2e_i_2e_i;
  struct l_struct_2E_b2Block **llvm_cbe_tmp42_2e_i102_2e_i_2e_i;
  struct l_struct_2E_b2Block *llvm_cbe_tmp43_2e_i103_2e_i_2e_i;
  unsigned char llvm_cbe_tmp20_2e_i52_2e_i_2e_i;
  struct l_struct_2E_b2Block **llvm_cbe_tmp42_2e_i65_2e_i_2e_i;
  struct l_struct_2E_b2Block *llvm_cbe_tmp43_2e_i66_2e_i_2e_i;
  unsigned char llvm_cbe_tmp20_2e_i15_2e_i_2e_i;
  struct l_struct_2E_b2Block **llvm_cbe_tmp42_2e_i28_2e_i_2e_i;
  struct l_struct_2E_b2Block *llvm_cbe_tmp43_2e_i29_2e_i_2e_i;
  unsigned int llvm_cbe_tmp183_2e_i;
  unsigned int llvm_cbe_tmp205_2e_i;
  unsigned int llvm_cbe_tmp208_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_storemerge_2e_i;
  struct l_struct_2E_b2Shape **llvm_cbe_tmp219_2e_i;
  struct l_struct_2E_b2XForm *llvm_cbe_tmp2_2e_i9_2e_i;
  struct l_struct_2E_b2BroadPhase *llvm_cbe_tmp226_2e_i;
  unsigned short *llvm_cbe_tmp1_2e_i3_2e_i;
  unsigned short llvm_cbe_tmp2_2e_i4_2e_i;
  unsigned int  (**llvm_cbe_tmp12_2e_i_2e_i) ();
  unsigned int  (*llvm_cbe_tmp14_2e_i_2e_i) ();
  unsigned char llvm_cbe_tmp19_2e_i_2e_i;
  unsigned short llvm_cbe_tmp26_2e_i_2e_i;
  struct l_struct_2E_b2Shape **llvm_cbe_tmp229_2e_i;
  struct l_struct_2E_b2Shape **llvm_cbe_storemerge1_2e_in_2e_i;
  struct l_struct_2E_b2Shape **llvm_cbe_storemerge1_2e_in_2e_i__PHI_TEMPORARY;
  struct l_struct_2E_b2Shape *llvm_cbe_storemerge1_2e_i;
  struct l_struct_2E_b2JointEdge *llvm_cbe_jn_2e_0;
  struct l_struct_2E_b2JointEdge *llvm_cbe_jn_2e_0__PHI_TEMPORARY;
  struct l_struct_2E_b2Shape *llvm_cbe_tmp69;
  struct l_struct_2E_b2Shape *llvm_cbe_tmp74;
  struct l_struct_2E_Os *llvm_cbe_tmp77;
  unsigned int  (**llvm_cbe_tmp89) ();
  unsigned int  (*llvm_cbe_tmp91) ();
  unsigned short *llvm_cbe_tmp1_2e_i58;
  unsigned short llvm_cbe_tmp2_2e_i59;
  struct l_struct_2E_b2BroadPhase *llvm_cbe_tmp100;
  unsigned int llvm_cbe_tmp3_2e_i_2e_i33;
  unsigned int  (**llvm_cbe_tmp5_2e_i) ();
  unsigned int  (*llvm_cbe_tmp7_2e_i36) ();
  unsigned char llvm_cbe_tmp20_2e_i16_2e_i;
  struct l_struct_2E_b2Block **llvm_cbe_tmp42_2e_i29_2e_i;
  struct l_struct_2E_b2Block *llvm_cbe_tmp43_2e_i30_2e_i;
  unsigned int  (**llvm_cbe_tmp16_2e_i) ();
  unsigned int  (*llvm_cbe_tmp18_2e_i43) ();
  unsigned char llvm_cbe_tmp20_2e_i_2e_i;
  struct l_struct_2E_b2Block **llvm_cbe_tmp42_2e_i_2e_i;
  struct l_struct_2E_b2Block *llvm_cbe_tmp43_2e_i_2e_i;
  struct l_struct_2E_b2Shape *llvm_cbe_s_2e_0;
  struct l_struct_2E_b2Shape *llvm_cbe_s_2e_0__PHI_TEMPORARY;
  struct l_struct_2E_b2Body **llvm_cbe_tmp112;
  struct l_struct_2E_b2Body *llvm_cbe_tmp113;
  struct l_struct_2E_b2Body *llvm_cbe_tmp123;
  struct l_struct_2E_b2Body **llvm_cbe_tmp127;
  struct l_struct_2E_b2Body *llvm_cbe_tmp128;
  struct l_struct_2E_b2Body *llvm_cbe_tmp138;
  struct l_struct_2E_b2Body **llvm_cbe_tmp142;
  struct l_struct_2E_b2Body *llvm_cbe_tmp143;
  struct l_struct_2E_b2Body *llvm_cbe_tmp151;
  unsigned int llvm_cbe_tmp157;
  struct l_struct_2E_b2World *llvm_cbe_tmp2_2e_i23;
  unsigned char llvm_cbe_tmp4_2e_i25;
  unsigned char llvm_cbe_tmp20_2e_i7;
  struct l_struct_2E_b2Block **llvm_cbe_tmp42_2e_i15;
  struct l_struct_2E_b2Block *llvm_cbe_tmp43_2e_i16;

  llvm_cbe_tmp1 = (&llvm_cbe_this->field8);
  llvm_cbe_tmp2 = *llvm_cbe_tmp1;
  if ((((signed int )llvm_cbe_tmp2) < ((signed int )1u))) {
    goto llvm_cbe_bb;
  } else {
    goto llvm_cbe_bb8;
  }

llvm_cbe_bb:
  __assert_fail(((&_2E_str12165[((signed long long )0ull)])), ((&_2E_str1154[((signed long long )0ull)])), 123u, ((&_ZZN7b2World11DestroyBodyEP6b2BodyE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb8:
  llvm_cbe_tmp10 = (&llvm_cbe_this->field2);
  llvm_cbe_tmp11 = *llvm_cbe_tmp10;
  if ((llvm_cbe_tmp11 == ((unsigned char )0))) {
    goto llvm_cbe_bb22;
  } else {
    goto llvm_cbe_bb13;
  }

llvm_cbe_bb13:
  __assert_fail(((&_2E_str10163[((signed long long )0ull)])), ((&_2E_str1154[((signed long long )0ull)])), 124u, ((&_ZZN7b2World11DestroyBodyEP6b2BodyE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb22:
  llvm_cbe_tmp25 = *((&llvm_cbe_b->field13));
  llvm_cbe_tmp32 = (&llvm_cbe_this->field14);
  llvm_cbe_tmp41_2e_i = (&llvm_cbe_this->field6);
  llvm_cbe_tmp182_2e_i = (&llvm_cbe_this->field10);
  llvm_cbe_tmp225_2e_i = (&llvm_cbe_this->field3);
  llvm_cbe_jn_2e_0__PHI_TEMPORARY = llvm_cbe_tmp25;   /* for PHI node */
  goto llvm_cbe_bb61;

llvm_cbe_bb_2e_i:
  __assert_fail(((&_2E_str10163[((signed long long )0ull)])), ((&_2E_str1154[((signed long long )0ull)])), 230u, ((&_ZZN7b2World12DestroyJointEP7b2JointE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb31_2e_i_2e_i_2e_i:
  __assert_fail(((&_2E_str2179[((signed long long )0ull)])), ((&_2E_str1178[((signed long long )0ull)])), 161u, ((&_ZZN16b2BlockAllocator4FreeEPviE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb31_2e_i170_2e_i_2e_i:
  __assert_fail(((&_2E_str2179[((signed long long )0ull)])), ((&_2E_str1178[((signed long long )0ull)])), 161u, ((&_ZZN16b2BlockAllocator4FreeEPviE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb31_2e_i133_2e_i_2e_i:
  __assert_fail(((&_2E_str2179[((signed long long )0ull)])), ((&_2E_str1178[((signed long long )0ull)])), 161u, ((&_ZZN16b2BlockAllocator4FreeEPviE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb31_2e_i96_2e_i_2e_i:
  __assert_fail(((&_2E_str2179[((signed long long )0ull)])), ((&_2E_str1178[((signed long long )0ull)])), 161u, ((&_ZZN16b2BlockAllocator4FreeEPviE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb31_2e_i59_2e_i_2e_i:
  __assert_fail(((&_2E_str2179[((signed long long )0ull)])), ((&_2E_str1178[((signed long long )0ull)])), 161u, ((&_ZZN16b2BlockAllocator4FreeEPviE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb31_2e_i22_2e_i_2e_i:
  __assert_fail(((&_2E_str2179[((signed long long )0ull)])), ((&_2E_str1178[((signed long long )0ull)])), 161u, ((&_ZZN16b2BlockAllocator4FreeEPviE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb33_2e_i_2e_i:
  __assert_fail(((&_2E_str171[((signed long long )0ull)])), ((&_2E_str1172[((signed long long )0ull)])), 119u, ((&_ZZN7b2Joint7DestroyEPS_P16b2BlockAllocatorE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb187_2e_i:
  __assert_fail(((&_2E_str11164[((signed long long )0ull)])), ((&_2E_str1154[((signed long long )0ull)])), 298u, ((&_ZZN7b2World12DestroyJointEP7b2JointE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
  do {     /* Syntactic loop 'bb61' to make GCC happy */
llvm_cbe_bb61:
  llvm_cbe_jn_2e_0 = llvm_cbe_jn_2e_0__PHI_TEMPORARY;
  if ((llvm_cbe_jn_2e_0 == ((struct l_struct_2E_b2JointEdge *)/*NULL*/0))) {
    goto llvm_cbe_bb66;
  } else {
    goto llvm_cbe_bb26;
  }

llvm_cbe_bb191_2e_i:
  *llvm_cbe_tmp182_2e_i = (llvm_cbe_tmp183_2e_i + 4294967295u);
  if ((llvm_cbe_tmp9_2e_i == ((unsigned char )0))) {
    goto llvm_cbe_bb202_2e_i;
  } else {
    llvm_cbe_jn_2e_0__PHI_TEMPORARY = llvm_cbe_tmp30;   /* for PHI node */
    goto llvm_cbe_bb61;
  }

llvm_cbe__ZN7b2Joint7DestroyEPS_P16b2BlockAllocator_2e_exit_2e_i:
  llvm_cbe_tmp183_2e_i = *llvm_cbe_tmp182_2e_i;
  if ((((signed int )llvm_cbe_tmp183_2e_i) < ((signed int )1u))) {
    goto llvm_cbe_bb187_2e_i;
  } else {
    goto llvm_cbe_bb191_2e_i;
  }

llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit_2e_i_2e_i:
  llvm_cbe_tmp42_2e_i_2e_i_2e_i = (&llvm_cbe_this->field0.field3[((signed long long )(((unsigned long long )(unsigned char )llvm_cbe_tmp20_2e_i_2e_i_2e_i)))]);
  llvm_cbe_tmp43_2e_i_2e_i_2e_i = *llvm_cbe_tmp42_2e_i_2e_i_2e_i;
  *(((struct l_struct_2E_b2Block **)llvm_cbe_tmp59)) = llvm_cbe_tmp43_2e_i_2e_i_2e_i;
  *llvm_cbe_tmp42_2e_i_2e_i_2e_i = (((struct l_struct_2E_b2Block *)llvm_cbe_tmp59));
  goto llvm_cbe__ZN7b2Joint7DestroyEPS_P16b2BlockAllocator_2e_exit_2e_i;

llvm_cbe_bb16_2e_i_2e_i_2e_i:
  llvm_cbe_tmp20_2e_i_2e_i_2e_i = *((&_ZN16b2BlockAllocator17s_blockSizeLookupE[((signed long long )184ull)]));
  if ((((unsigned char )llvm_cbe_tmp20_2e_i_2e_i_2e_i) < ((unsigned char )((unsigned char )14)))) {
    goto llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb31_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb171_2e_i:
  *llvm_cbe_tmp122_2e_i = ((struct l_struct_2E_b2JointEdge *)/*NULL*/0);
  *llvm_cbe_tmp140_2e_i = ((struct l_struct_2E_b2JointEdge *)/*NULL*/0);
  llvm_cbe_tmp2_2e_i13_2e_i = *((&llvm_cbe_tmp59->field0));
  llvm_cbe_tmp4_2e_i15_2e_i = *((&llvm_cbe_tmp2_2e_i13_2e_i[((signed long long )4ull)]));
  (((void  (*) (struct l_struct_2E_b2Joint *))llvm_cbe_tmp4_2e_i15_2e_i))(llvm_cbe_tmp59);
  llvm_cbe_tmp9_2e_i18_2e_i = *((&llvm_cbe_tmp59->field1));
  switch (llvm_cbe_tmp9_2e_i18_2e_i) {
  default:
    goto llvm_cbe_bb33_2e_i_2e_i;
;
  case 1u:
    goto llvm_cbe_bb16_2e_i92_2e_i_2e_i;
  case 2u:
    goto llvm_cbe_bb16_2e_i129_2e_i_2e_i;
  case 3u:
    goto llvm_cbe_bb16_2e_i_2e_i_2e_i;
    break;
  case 4u:
    goto llvm_cbe_bb16_2e_i55_2e_i_2e_i;
  case 5u:
    goto llvm_cbe_bb16_2e_i166_2e_i_2e_i;
  case 6u:
    goto llvm_cbe_bb16_2e_i18_2e_i_2e_i;
  }
llvm_cbe_bb155_2e_i:
  llvm_cbe_tmp159_2e_i = (&llvm_cbe_tmp59_2e_i->field13);
  llvm_cbe_tmp160_2e_i = *llvm_cbe_tmp159_2e_i;
  if ((((&llvm_cbe_tmp59->field5)) == llvm_cbe_tmp160_2e_i)) {
    goto llvm_cbe_bb164_2e_i;
  } else {
    goto llvm_cbe_bb171_2e_i;
  }

llvm_cbe_bb137_2e_i:
  llvm_cbe_tmp140_2e_i = (&llvm_cbe_tmp59->field5.field3);
  llvm_cbe_tmp141_2e_i = *llvm_cbe_tmp140_2e_i;
  if ((llvm_cbe_tmp141_2e_i == ((struct l_struct_2E_b2JointEdge *)/*NULL*/0))) {
    goto llvm_cbe_bb155_2e_i;
  } else {
    goto llvm_cbe_bb145_2e_i;
  }

llvm_cbe_bb113_2e_i:
  *llvm_cbe_tmp64_2e_i = ((struct l_struct_2E_b2JointEdge *)/*NULL*/0);
  *llvm_cbe_tmp82_2e_i = ((struct l_struct_2E_b2JointEdge *)/*NULL*/0);
  llvm_cbe_tmp122_2e_i = (&llvm_cbe_tmp59->field5.field2);
  llvm_cbe_tmp123_2e_i = *llvm_cbe_tmp122_2e_i;
  if ((llvm_cbe_tmp123_2e_i == ((struct l_struct_2E_b2JointEdge *)/*NULL*/0))) {
    goto llvm_cbe_bb137_2e_i;
  } else {
    goto llvm_cbe_bb127_2e_i;
  }

llvm_cbe_bb97_2e_i:
  llvm_cbe_tmp101_2e_i = (&llvm_cbe_tmp56_2e_i->field13);
  llvm_cbe_tmp102_2e_i = *llvm_cbe_tmp101_2e_i;
  if ((((&llvm_cbe_tmp59->field4)) == llvm_cbe_tmp102_2e_i)) {
    goto llvm_cbe_bb106_2e_i;
  } else {
    goto llvm_cbe_bb113_2e_i;
  }

llvm_cbe_bb79_2e_i:
  llvm_cbe_tmp82_2e_i = (&llvm_cbe_tmp59->field4.field3);
  llvm_cbe_tmp83_2e_i = *llvm_cbe_tmp82_2e_i;
  if ((llvm_cbe_tmp83_2e_i == ((struct l_struct_2E_b2JointEdge *)/*NULL*/0))) {
    goto llvm_cbe_bb97_2e_i;
  } else {
    goto llvm_cbe_bb87_2e_i;
  }

llvm_cbe_bb53_2e_i:
  llvm_cbe_tmp56_2e_i = *((&llvm_cbe_tmp59->field6));
  llvm_cbe_tmp59_2e_i = *((&llvm_cbe_tmp59->field7));
  llvm_cbe_tmp1_2e_i_2e_i = (&llvm_cbe_tmp56_2e_i->field0);
  llvm_cbe_tmp2_2e_i_2e_i = *llvm_cbe_tmp1_2e_i_2e_i;
  *llvm_cbe_tmp1_2e_i_2e_i = (((unsigned short )(llvm_cbe_tmp2_2e_i_2e_i & ((unsigned short )-9))));
  *((&llvm_cbe_tmp56_2e_i->field21)) = 0x0p+0;
  llvm_cbe_tmp1_2e_i33_2e_i = (&llvm_cbe_tmp59_2e_i->field0);
  llvm_cbe_tmp2_2e_i34_2e_i = *llvm_cbe_tmp1_2e_i33_2e_i;
  *llvm_cbe_tmp1_2e_i33_2e_i = (((unsigned short )(llvm_cbe_tmp2_2e_i34_2e_i & ((unsigned short )-9))));
  *((&llvm_cbe_tmp59_2e_i->field21)) = 0x0p+0;
  llvm_cbe_tmp64_2e_i = (&llvm_cbe_tmp59->field4.field2);
  llvm_cbe_tmp65_2e_i = *llvm_cbe_tmp64_2e_i;
  if ((llvm_cbe_tmp65_2e_i == ((struct l_struct_2E_b2JointEdge *)/*NULL*/0))) {
    goto llvm_cbe_bb79_2e_i;
  } else {
    goto llvm_cbe_bb69_2e_i;
  }

llvm_cbe_bb39_2e_i:
  llvm_cbe_tmp42_2e_i = *llvm_cbe_tmp41_2e_i;
  if ((llvm_cbe_tmp42_2e_i == llvm_cbe_tmp59)) {
    goto llvm_cbe_bb47_2e_i;
  } else {
    goto llvm_cbe_bb53_2e_i;
  }

llvm_cbe_bb24_2e_i:
  llvm_cbe_tmp26_2e_i = (&llvm_cbe_tmp59->field3);
  llvm_cbe_tmp27_2e_i = *llvm_cbe_tmp26_2e_i;
  if ((llvm_cbe_tmp27_2e_i == ((struct l_struct_2E_b2Joint *)/*NULL*/0))) {
    goto llvm_cbe_bb39_2e_i;
  } else {
    goto llvm_cbe_bb31_2e_i;
  }

llvm_cbe_bb6_2e_i:
  llvm_cbe_tmp9_2e_i = *((&llvm_cbe_tmp59->field10));
  llvm_cbe_tmp11_2e_i = (&llvm_cbe_tmp59->field2);
  llvm_cbe_tmp12_2e_i = *llvm_cbe_tmp11_2e_i;
  if ((llvm_cbe_tmp12_2e_i == ((struct l_struct_2E_b2Joint *)/*NULL*/0))) {
    goto llvm_cbe_bb24_2e_i;
  } else {
    goto llvm_cbe_bb16_2e_i;
  }

llvm_cbe_bb56:
  llvm_cbe_tmp59 = *((&llvm_cbe_jn_2e_0->field1));
  llvm_cbe_tmp2_2e_i = *llvm_cbe_tmp10;
  if ((llvm_cbe_tmp2_2e_i == ((unsigned char )0))) {
    goto llvm_cbe_bb6_2e_i;
  } else {
    goto llvm_cbe_bb_2e_i;
  }

llvm_cbe_bb26:
  llvm_cbe_tmp30 = *((&llvm_cbe_jn_2e_0->field3));
  llvm_cbe_tmp33 = *llvm_cbe_tmp32;
  if ((llvm_cbe_tmp33 == ((struct l_struct_2E_Os *)/*NULL*/0))) {
    goto llvm_cbe_bb56;
  } else {
    goto llvm_cbe_bb38;
  }

llvm_cbe_bb38:
  llvm_cbe_tmp46 = *((&llvm_cbe_tmp33->field0));
  llvm_cbe_tmp48 = *((&llvm_cbe_tmp46[((signed long long )2ull)]));
  llvm_cbe_tmp51 = *((&llvm_cbe_jn_2e_0->field1));
  (((void  (*) (struct l_struct_2E_Os *, struct l_struct_2E_b2Joint *))llvm_cbe_tmp48))(llvm_cbe_tmp33, llvm_cbe_tmp51);
  goto llvm_cbe_bb56;

llvm_cbe_bb16_2e_i:
  llvm_cbe_tmp22_2e_i = *((&llvm_cbe_tmp59->field3));
  *((&llvm_cbe_tmp12_2e_i->field3)) = llvm_cbe_tmp22_2e_i;
  goto llvm_cbe_bb24_2e_i;

llvm_cbe_bb31_2e_i:
  llvm_cbe_tmp37_2e_i = *llvm_cbe_tmp11_2e_i;
  *((&llvm_cbe_tmp27_2e_i->field2)) = llvm_cbe_tmp37_2e_i;
  goto llvm_cbe_bb39_2e_i;

llvm_cbe_bb47_2e_i:
  llvm_cbe_tmp50_2e_i = *llvm_cbe_tmp26_2e_i;
  *llvm_cbe_tmp41_2e_i = llvm_cbe_tmp50_2e_i;
  goto llvm_cbe_bb53_2e_i;

llvm_cbe_bb69_2e_i:
  llvm_cbe_tmp77_2e_i = *((&llvm_cbe_tmp59->field4.field3));
  *((&llvm_cbe_tmp65_2e_i->field3)) = llvm_cbe_tmp77_2e_i;
  goto llvm_cbe_bb79_2e_i;

llvm_cbe_bb87_2e_i:
  llvm_cbe_tmp95_2e_i = *llvm_cbe_tmp64_2e_i;
  *((&llvm_cbe_tmp83_2e_i->field2)) = llvm_cbe_tmp95_2e_i;
  goto llvm_cbe_bb97_2e_i;

llvm_cbe_bb106_2e_i:
  llvm_cbe_tmp110_2e_i = *llvm_cbe_tmp82_2e_i;
  *llvm_cbe_tmp101_2e_i = llvm_cbe_tmp110_2e_i;
  goto llvm_cbe_bb113_2e_i;

llvm_cbe_bb127_2e_i:
  llvm_cbe_tmp135_2e_i = *((&llvm_cbe_tmp59->field5.field3));
  *((&llvm_cbe_tmp123_2e_i->field3)) = llvm_cbe_tmp135_2e_i;
  goto llvm_cbe_bb137_2e_i;

llvm_cbe_bb145_2e_i:
  llvm_cbe_tmp153_2e_i = *llvm_cbe_tmp122_2e_i;
  *((&llvm_cbe_tmp141_2e_i->field2)) = llvm_cbe_tmp153_2e_i;
  goto llvm_cbe_bb155_2e_i;

llvm_cbe_bb164_2e_i:
  llvm_cbe_tmp168_2e_i = *llvm_cbe_tmp140_2e_i;
  *llvm_cbe_tmp159_2e_i = llvm_cbe_tmp168_2e_i;
  goto llvm_cbe_bb171_2e_i;

llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit185_2e_i_2e_i:
  llvm_cbe_tmp42_2e_i176_2e_i_2e_i = (&llvm_cbe_this->field0.field3[((signed long long )(((unsigned long long )(unsigned char )llvm_cbe_tmp20_2e_i163_2e_i_2e_i)))]);
  llvm_cbe_tmp43_2e_i177_2e_i_2e_i = *llvm_cbe_tmp42_2e_i176_2e_i_2e_i;
  *(((struct l_struct_2E_b2Block **)llvm_cbe_tmp59)) = llvm_cbe_tmp43_2e_i177_2e_i_2e_i;
  *llvm_cbe_tmp42_2e_i176_2e_i_2e_i = (((struct l_struct_2E_b2Block *)llvm_cbe_tmp59));
  goto llvm_cbe__ZN7b2Joint7DestroyEPS_P16b2BlockAllocator_2e_exit_2e_i;

llvm_cbe_bb16_2e_i166_2e_i_2e_i:
  llvm_cbe_tmp20_2e_i163_2e_i_2e_i = *((&_ZN16b2BlockAllocator17s_blockSizeLookupE[((signed long long )192ull)]));
  if ((((unsigned char )llvm_cbe_tmp20_2e_i163_2e_i_2e_i) < ((unsigned char )((unsigned char )14)))) {
    goto llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit185_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb31_2e_i170_2e_i_2e_i;
  }

llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit148_2e_i_2e_i:
  llvm_cbe_tmp42_2e_i139_2e_i_2e_i = (&llvm_cbe_this->field0.field3[((signed long long )(((unsigned long long )(unsigned char )llvm_cbe_tmp20_2e_i126_2e_i_2e_i)))]);
  llvm_cbe_tmp43_2e_i140_2e_i_2e_i = *llvm_cbe_tmp42_2e_i139_2e_i_2e_i;
  *(((struct l_struct_2E_b2Block **)llvm_cbe_tmp59)) = llvm_cbe_tmp43_2e_i140_2e_i_2e_i;
  *llvm_cbe_tmp42_2e_i139_2e_i_2e_i = (((struct l_struct_2E_b2Block *)llvm_cbe_tmp59));
  goto llvm_cbe__ZN7b2Joint7DestroyEPS_P16b2BlockAllocator_2e_exit_2e_i;

llvm_cbe_bb16_2e_i129_2e_i_2e_i:
  llvm_cbe_tmp20_2e_i126_2e_i_2e_i = *((&_ZN16b2BlockAllocator17s_blockSizeLookupE[((signed long long )272ull)]));
  if ((((unsigned char )llvm_cbe_tmp20_2e_i126_2e_i_2e_i) < ((unsigned char )((unsigned char )14)))) {
    goto llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit148_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb31_2e_i133_2e_i_2e_i;
  }

llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit111_2e_i_2e_i:
  llvm_cbe_tmp42_2e_i102_2e_i_2e_i = (&llvm_cbe_this->field0.field3[((signed long long )(((unsigned long long )(unsigned char )llvm_cbe_tmp20_2e_i89_2e_i_2e_i)))]);
  llvm_cbe_tmp43_2e_i103_2e_i_2e_i = *llvm_cbe_tmp42_2e_i102_2e_i_2e_i;
  *(((struct l_struct_2E_b2Block **)llvm_cbe_tmp59)) = llvm_cbe_tmp43_2e_i103_2e_i_2e_i;
  *llvm_cbe_tmp42_2e_i102_2e_i_2e_i = (((struct l_struct_2E_b2Block *)llvm_cbe_tmp59));
  goto llvm_cbe__ZN7b2Joint7DestroyEPS_P16b2BlockAllocator_2e_exit_2e_i;

llvm_cbe_bb16_2e_i92_2e_i_2e_i:
  llvm_cbe_tmp20_2e_i89_2e_i_2e_i = *((&_ZN16b2BlockAllocator17s_blockSizeLookupE[((signed long long )216ull)]));
  if ((((unsigned char )llvm_cbe_tmp20_2e_i89_2e_i_2e_i) < ((unsigned char )((unsigned char )14)))) {
    goto llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit111_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb31_2e_i96_2e_i_2e_i;
  }

llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit74_2e_i_2e_i:
  llvm_cbe_tmp42_2e_i65_2e_i_2e_i = (&llvm_cbe_this->field0.field3[((signed long long )(((unsigned long long )(unsigned char )llvm_cbe_tmp20_2e_i52_2e_i_2e_i)))]);
  llvm_cbe_tmp43_2e_i66_2e_i_2e_i = *llvm_cbe_tmp42_2e_i65_2e_i_2e_i;
  *(((struct l_struct_2E_b2Block **)llvm_cbe_tmp59)) = llvm_cbe_tmp43_2e_i66_2e_i_2e_i;
  *llvm_cbe_tmp42_2e_i65_2e_i_2e_i = (((struct l_struct_2E_b2Block *)llvm_cbe_tmp59));
  goto llvm_cbe__ZN7b2Joint7DestroyEPS_P16b2BlockAllocator_2e_exit_2e_i;

llvm_cbe_bb16_2e_i55_2e_i_2e_i:
  llvm_cbe_tmp20_2e_i52_2e_i_2e_i = *((&_ZN16b2BlockAllocator17s_blockSizeLookupE[((signed long long )248ull)]));
  if ((((unsigned char )llvm_cbe_tmp20_2e_i52_2e_i_2e_i) < ((unsigned char )((unsigned char )14)))) {
    goto llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit74_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb31_2e_i59_2e_i_2e_i;
  }

llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit37_2e_i_2e_i:
  llvm_cbe_tmp42_2e_i28_2e_i_2e_i = (&llvm_cbe_this->field0.field3[((signed long long )(((unsigned long long )(unsigned char )llvm_cbe_tmp20_2e_i15_2e_i_2e_i)))]);
  llvm_cbe_tmp43_2e_i29_2e_i_2e_i = *llvm_cbe_tmp42_2e_i28_2e_i_2e_i;
  *(((struct l_struct_2E_b2Block **)llvm_cbe_tmp59)) = llvm_cbe_tmp43_2e_i29_2e_i_2e_i;
  *llvm_cbe_tmp42_2e_i28_2e_i_2e_i = (((struct l_struct_2E_b2Block *)llvm_cbe_tmp59));
  goto llvm_cbe__ZN7b2Joint7DestroyEPS_P16b2BlockAllocator_2e_exit_2e_i;

llvm_cbe_bb16_2e_i18_2e_i_2e_i:
  llvm_cbe_tmp20_2e_i15_2e_i_2e_i = *((&_ZN16b2BlockAllocator17s_blockSizeLookupE[((signed long long )248ull)]));
  if ((((unsigned char )llvm_cbe_tmp20_2e_i15_2e_i_2e_i) < ((unsigned char )((unsigned char )14)))) {
    goto llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit37_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb31_2e_i22_2e_i_2e_i;
  }

  do {     /* Syntactic loop 'bb231.i' to make GCC happy */
llvm_cbe_bb231_2e_i:
  llvm_cbe_storemerge1_2e_in_2e_i = llvm_cbe_storemerge1_2e_in_2e_i__PHI_TEMPORARY;
  llvm_cbe_storemerge1_2e_i = *llvm_cbe_storemerge1_2e_in_2e_i;
  if ((llvm_cbe_storemerge1_2e_i == ((struct l_struct_2E_b2Shape *)/*NULL*/0))) {
    llvm_cbe_jn_2e_0__PHI_TEMPORARY = llvm_cbe_tmp30;   /* for PHI node */
    goto llvm_cbe_bb61;
  } else {
    goto llvm_cbe_bb221_2e_i;
  }

llvm_cbe__ZN7b2Shape13RefilterProxyEP12b2BroadPhaseRK7b2XForm_2e_exit_2e_i:
  llvm_cbe_tmp229_2e_i = (&llvm_cbe_storemerge1_2e_i->field2);
  llvm_cbe_storemerge1_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp229_2e_i;   /* for PHI node */
  goto llvm_cbe_bb231_2e_i;

llvm_cbe_bb221_2e_i:
  llvm_cbe_tmp226_2e_i = *llvm_cbe_tmp225_2e_i;
  llvm_cbe_tmp1_2e_i3_2e_i = (&llvm_cbe_storemerge1_2e_i->field8);
  llvm_cbe_tmp2_2e_i4_2e_i = *llvm_cbe_tmp1_2e_i3_2e_i;
  if ((llvm_cbe_tmp2_2e_i4_2e_i == ((unsigned short )-1))) {
    goto llvm_cbe__ZN7b2Shape13RefilterProxyEP12b2BroadPhaseRK7b2XForm_2e_exit_2e_i;
  } else {
    goto llvm_cbe_bb_2e_i_2e_i;
  }

llvm_cbe_bb22_2e_i_2e_i:
  llvm_cbe_tmp26_2e_i_2e_i = _ZN12b2BroadPhase11CreateProxyERK6b2AABBPv(llvm_cbe_tmp226_2e_i, (&llvm_cbe_aabb_2e_i_2e_i), (((unsigned char *)llvm_cbe_storemerge1_2e_i)));
  *llvm_cbe_tmp1_2e_i3_2e_i = llvm_cbe_tmp26_2e_i_2e_i;
  goto llvm_cbe__ZN7b2Shape13RefilterProxyEP12b2BroadPhaseRK7b2XForm_2e_exit_2e_i;

llvm_cbe_bb_2e_i_2e_i:
  _ZN12b2BroadPhase12DestroyProxyEi(llvm_cbe_tmp226_2e_i, (((unsigned int )(unsigned short )llvm_cbe_tmp2_2e_i4_2e_i)));
  llvm_cbe_tmp12_2e_i_2e_i = *((&llvm_cbe_storemerge1_2e_i->field0));
  llvm_cbe_tmp14_2e_i_2e_i = *((&llvm_cbe_tmp12_2e_i_2e_i[((signed long long )2ull)]));
  (((void  (*) (struct l_struct_2E_b2Shape *, struct l_struct_2E_b2AABB *, struct l_struct_2E_b2XForm *))llvm_cbe_tmp14_2e_i_2e_i))(llvm_cbe_storemerge1_2e_i, (&llvm_cbe_aabb_2e_i_2e_i), llvm_cbe_tmp2_2e_i9_2e_i);
  llvm_cbe_tmp19_2e_i_2e_i = _ZNK12b2BroadPhase7InRangeERK6b2AABB(llvm_cbe_tmp226_2e_i, (&llvm_cbe_aabb_2e_i_2e_i));
  if ((llvm_cbe_tmp19_2e_i_2e_i == ((unsigned char )0))) {
    goto llvm_cbe_bb29_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb22_2e_i_2e_i;
  }

llvm_cbe_bb29_2e_i_2e_i:
  *llvm_cbe_tmp1_2e_i3_2e_i = ((unsigned short )-1);
  goto llvm_cbe__ZN7b2Shape13RefilterProxyEP12b2BroadPhaseRK7b2XForm_2e_exit_2e_i;

  } while (1); /* end of syntactic loop 'bb231.i' */
llvm_cbe_bb202_2e_i:
  llvm_cbe_tmp205_2e_i = *((&llvm_cbe_tmp56_2e_i->field12));
  llvm_cbe_tmp208_2e_i = *((&llvm_cbe_tmp59_2e_i->field12));
  llvm_cbe_storemerge_2e_i = (((((signed int )llvm_cbe_tmp205_2e_i) < ((signed int )llvm_cbe_tmp208_2e_i))) ? (llvm_cbe_tmp56_2e_i) : (llvm_cbe_tmp59_2e_i));
  llvm_cbe_tmp219_2e_i = (&llvm_cbe_storemerge_2e_i->field11);
  llvm_cbe_tmp2_2e_i9_2e_i = (&llvm_cbe_storemerge_2e_i->field2);
  llvm_cbe_storemerge1_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp219_2e_i;   /* for PHI node */
  goto llvm_cbe_bb231_2e_i;

  } while (1); /* end of syntactic loop 'bb61' */
llvm_cbe_bb66:
  llvm_cbe_tmp69 = *((&llvm_cbe_b->field11));
  llvm_cbe_s_2e_0__PHI_TEMPORARY = llvm_cbe_tmp69;   /* for PHI node */
  goto llvm_cbe_bb105;

llvm_cbe_bb31_2e_i23_2e_i:
  __assert_fail(((&_2E_str2179[((signed long long )0ull)])), ((&_2E_str1178[((signed long long )0ull)])), 161u, ((&_ZZN16b2BlockAllocator4FreeEPviE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb31_2e_i_2e_i:
  __assert_fail(((&_2E_str2179[((signed long long )0ull)])), ((&_2E_str1178[((signed long long )0ull)])), 161u, ((&_ZZN16b2BlockAllocator4FreeEPviE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb24_2e_i55:
  __assert_fail(((&_2E_str171[((signed long long )0ull)])), ((&_2E_str1174[((signed long long )0ull)])), 65u, ((&_ZZN7b2Shape7DestroyEPS_P16b2BlockAllocatorE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
  do {     /* Syntactic loop 'bb105' to make GCC happy */
llvm_cbe_bb105:
  llvm_cbe_s_2e_0 = llvm_cbe_s_2e_0__PHI_TEMPORARY;
  if ((llvm_cbe_s_2e_0 == ((struct l_struct_2E_b2Shape *)/*NULL*/0))) {
    goto llvm_cbe_bb110;
  } else {
    goto llvm_cbe_bb70;
  }

llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit38_2e_i:
  llvm_cbe_tmp42_2e_i29_2e_i = (&llvm_cbe_this->field0.field3[((signed long long )(((unsigned long long )(unsigned char )llvm_cbe_tmp20_2e_i16_2e_i)))]);
  llvm_cbe_tmp43_2e_i30_2e_i = *llvm_cbe_tmp42_2e_i29_2e_i;
  *(((struct l_struct_2E_b2Block **)llvm_cbe_s_2e_0)) = llvm_cbe_tmp43_2e_i30_2e_i;
  *llvm_cbe_tmp42_2e_i29_2e_i = (((struct l_struct_2E_b2Block *)llvm_cbe_s_2e_0));
  llvm_cbe_s_2e_0__PHI_TEMPORARY = llvm_cbe_tmp74;   /* for PHI node */
  goto llvm_cbe_bb105;

llvm_cbe_bb_2e_i41:
  llvm_cbe_tmp5_2e_i = *((&llvm_cbe_s_2e_0->field0));
  llvm_cbe_tmp7_2e_i36 = *((&llvm_cbe_tmp5_2e_i[((signed long long )5ull)]));
  (((void  (*) (struct l_struct_2E_b2Shape *))llvm_cbe_tmp7_2e_i36))(llvm_cbe_s_2e_0);
  llvm_cbe_tmp20_2e_i16_2e_i = *((&_ZN16b2BlockAllocator17s_blockSizeLookupE[((signed long long )88ull)]));
  if ((((unsigned char )llvm_cbe_tmp20_2e_i16_2e_i) < ((unsigned char )((unsigned char )14)))) {
    goto llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit38_2e_i;
  } else {
    goto llvm_cbe_bb31_2e_i23_2e_i;
  }

llvm_cbe__ZN7b2Shape12DestroyProxyEP12b2BroadPhase_2e_exit:
  llvm_cbe_tmp3_2e_i_2e_i33 = *((&llvm_cbe_s_2e_0->field1));
  switch (llvm_cbe_tmp3_2e_i_2e_i33) {
  default:
    goto llvm_cbe_bb24_2e_i55;
;
  case 0u:
    goto llvm_cbe_bb_2e_i41;
    break;
  case 1u:
    goto llvm_cbe_bb13_2e_i;
  }
llvm_cbe_bb97:
  llvm_cbe_tmp1_2e_i58 = (&llvm_cbe_s_2e_0->field8);
  llvm_cbe_tmp2_2e_i59 = *llvm_cbe_tmp1_2e_i58;
  if ((llvm_cbe_tmp2_2e_i59 == ((unsigned short )-1))) {
    goto llvm_cbe__ZN7b2Shape12DestroyProxyEP12b2BroadPhase_2e_exit;
  } else {
    goto llvm_cbe_bb_2e_i68;
  }

llvm_cbe_bb70:
  llvm_cbe_tmp74 = *((&llvm_cbe_s_2e_0->field2));
  llvm_cbe_tmp77 = *llvm_cbe_tmp32;
  if ((llvm_cbe_tmp77 == ((struct l_struct_2E_Os *)/*NULL*/0))) {
    goto llvm_cbe_bb97;
  } else {
    goto llvm_cbe_bb81;
  }

llvm_cbe_bb81:
  llvm_cbe_tmp89 = *((&llvm_cbe_tmp77->field0));
  llvm_cbe_tmp91 = *((&llvm_cbe_tmp89[((signed long long )3ull)]));
  (((void  (*) (struct l_struct_2E_Os *, struct l_struct_2E_b2Shape *))llvm_cbe_tmp91))(llvm_cbe_tmp77, llvm_cbe_s_2e_0);
  goto llvm_cbe_bb97;

llvm_cbe_bb_2e_i68:
  llvm_cbe_tmp100 = *llvm_cbe_tmp225_2e_i;
  _ZN12b2BroadPhase12DestroyProxyEi(llvm_cbe_tmp100, (((unsigned int )(unsigned short )llvm_cbe_tmp2_2e_i59)));
  *llvm_cbe_tmp1_2e_i58 = ((unsigned short )-1);
  goto llvm_cbe__ZN7b2Shape12DestroyProxyEP12b2BroadPhase_2e_exit;

llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit_2e_i:
  llvm_cbe_tmp42_2e_i_2e_i = (&llvm_cbe_this->field0.field3[((signed long long )(((unsigned long long )(unsigned char )llvm_cbe_tmp20_2e_i_2e_i)))]);
  llvm_cbe_tmp43_2e_i_2e_i = *llvm_cbe_tmp42_2e_i_2e_i;
  *(((struct l_struct_2E_b2Block **)llvm_cbe_s_2e_0)) = llvm_cbe_tmp43_2e_i_2e_i;
  *llvm_cbe_tmp42_2e_i_2e_i = (((struct l_struct_2E_b2Block *)llvm_cbe_s_2e_0));
  llvm_cbe_s_2e_0__PHI_TEMPORARY = llvm_cbe_tmp74;   /* for PHI node */
  goto llvm_cbe_bb105;

llvm_cbe_bb13_2e_i:
  llvm_cbe_tmp16_2e_i = *((&llvm_cbe_s_2e_0->field0));
  llvm_cbe_tmp18_2e_i43 = *((&llvm_cbe_tmp16_2e_i[((signed long long )5ull)]));
  (((void  (*) (struct l_struct_2E_b2Shape *))llvm_cbe_tmp18_2e_i43))(llvm_cbe_s_2e_0);
  llvm_cbe_tmp20_2e_i_2e_i = *((&_ZN16b2BlockAllocator17s_blockSizeLookupE[((signed long long )312ull)]));
  if ((((unsigned char )llvm_cbe_tmp20_2e_i_2e_i) < ((unsigned char )((unsigned char )14)))) {
    goto llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit_2e_i;
  } else {
    goto llvm_cbe_bb31_2e_i_2e_i;
  }

  } while (1); /* end of syntactic loop 'bb105' */
llvm_cbe_bb110:
  llvm_cbe_tmp112 = (&llvm_cbe_b->field9);
  llvm_cbe_tmp113 = *llvm_cbe_tmp112;
  if ((llvm_cbe_tmp113 == ((struct l_struct_2E_b2Body *)/*NULL*/0))) {
    goto llvm_cbe_bb125;
  } else {
    goto llvm_cbe_bb117;
  }

llvm_cbe_bb117:
  llvm_cbe_tmp123 = *((&llvm_cbe_b->field10));
  *((&llvm_cbe_tmp113->field10)) = llvm_cbe_tmp123;
  goto llvm_cbe_bb125;

llvm_cbe_bb125:
  llvm_cbe_tmp127 = (&llvm_cbe_b->field10);
  llvm_cbe_tmp128 = *llvm_cbe_tmp127;
  if ((llvm_cbe_tmp128 == ((struct l_struct_2E_b2Body *)/*NULL*/0))) {
    goto llvm_cbe_bb140;
  } else {
    goto llvm_cbe_bb132;
  }

llvm_cbe_bb132:
  llvm_cbe_tmp138 = *llvm_cbe_tmp112;
  *((&llvm_cbe_tmp128->field9)) = llvm_cbe_tmp138;
  goto llvm_cbe_bb140;

llvm_cbe_bb140:
  llvm_cbe_tmp142 = (&llvm_cbe_this->field5);
  llvm_cbe_tmp143 = *llvm_cbe_tmp142;
  if ((llvm_cbe_tmp143 == llvm_cbe_b)) {
    goto llvm_cbe_bb148;
  } else {
    goto llvm_cbe_bb154;
  }

llvm_cbe_bb148:
  llvm_cbe_tmp151 = *llvm_cbe_tmp127;
  *llvm_cbe_tmp142 = llvm_cbe_tmp151;
  goto llvm_cbe_bb154;

llvm_cbe_bb154:
  llvm_cbe_tmp157 = *llvm_cbe_tmp1;
  *llvm_cbe_tmp1 = (llvm_cbe_tmp157 + 4294967295u);
  llvm_cbe_tmp2_2e_i23 = *((&llvm_cbe_b->field8));
  llvm_cbe_tmp4_2e_i25 = *((&llvm_cbe_tmp2_2e_i23->field2));
  if ((llvm_cbe_tmp4_2e_i25 == ((unsigned char )0))) {
    goto llvm_cbe_bb16_2e_i9;
  } else {
    goto llvm_cbe_bb_2e_i27;
  }

llvm_cbe_bb_2e_i27:
  __assert_fail(((&_2E_str146[((signed long long )0ull)])), ((&_2E_str1147[((signed long long )0ull)])), 111u, ((&_ZZN6b2BodyD4EvE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb16_2e_i9:
  llvm_cbe_tmp20_2e_i7 = *((&_ZN16b2BlockAllocator17s_blockSizeLookupE[((signed long long )184ull)]));
  if ((((unsigned char )llvm_cbe_tmp20_2e_i7) < ((unsigned char )((unsigned char )14)))) {
    goto llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit;
  } else {
    goto llvm_cbe_bb31_2e_i12;
  }

llvm_cbe_bb31_2e_i12:
  __assert_fail(((&_2E_str2179[((signed long long )0ull)])), ((&_2E_str1178[((signed long long )0ull)])), 161u, ((&_ZZN16b2BlockAllocator4FreeEPviE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe__ZN16b2BlockAllocator4FreeEPvi_2e_exit:
  llvm_cbe_tmp42_2e_i15 = (&llvm_cbe_this->field0.field3[((signed long long )(((unsigned long long )(unsigned char )llvm_cbe_tmp20_2e_i7)))]);
  llvm_cbe_tmp43_2e_i16 = *llvm_cbe_tmp42_2e_i15;
  *(((struct l_struct_2E_b2Block **)llvm_cbe_b)) = llvm_cbe_tmp43_2e_i16;
  *llvm_cbe_tmp42_2e_i15 = (((struct l_struct_2E_b2Block *)llvm_cbe_b));
  return;
}


static void _ZN5Scene5resetEP6Stroke(struct l_struct_2E_Scene *llvm_cbe_this, struct l_struct_2E_Stroke *llvm_cbe_s) {
  unsigned int *llvm_cbe_tmp2_2e_i3;
  struct l_struct_2E_b2World **llvm_cbe_tmp21;
  struct l_struct_2E_Stroke ***llvm_cbe_tmp2_2e_i_2e_i18;
  struct l_struct_2E_Stroke **llvm_cbe_tmp3_2e_i_2e_i;
  struct l_struct_2E_Stroke *llvm_cbe_tmp8;
  struct l_struct_2E_b2World *llvm_cbe_tmp22;
  struct l_struct_2E_Stroke **llvm_cbe_tmp3_2e_i_2e_i19;
  struct l_struct_2E_Stroke *llvm_cbe_tmp27;
  struct l_struct_2E_b2Body **llvm_cbe_tmp1_2e_i6;
  struct l_struct_2E_b2Body *llvm_cbe_tmp2_2e_i7;
  unsigned int llvm_cbe_tmp26_2e_i;
  unsigned int llvm_cbe_tmp29_2e_i;
  unsigned int llvm_cbe_tmp30;
  unsigned int llvm_cbe_storemerge1;
  unsigned int llvm_cbe_storemerge1__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp3_2e_i;

  llvm_cbe_tmp2_2e_i3 = (&llvm_cbe_this->field2.field1);
  llvm_cbe_tmp21 = (&llvm_cbe_this->field1);
  llvm_cbe_tmp2_2e_i_2e_i18 = (&llvm_cbe_this->field2.field0);
  llvm_cbe_storemerge1__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb31;

  do {     /* Syntactic loop 'bb31' to make GCC happy */
llvm_cbe_bb31:
  llvm_cbe_storemerge1 = llvm_cbe_storemerge1__PHI_TEMPORARY;
  llvm_cbe_tmp3_2e_i = *llvm_cbe_tmp2_2e_i3;
  if ((((signed int )llvm_cbe_tmp3_2e_i) > ((signed int )llvm_cbe_storemerge1))) {
    goto llvm_cbe_bb;
  } else {
    goto llvm_cbe_return;
  }

llvm_cbe_bb28:
  llvm_cbe_tmp30 = llvm_cbe_storemerge1 + 1u;
  llvm_cbe_storemerge1__PHI_TEMPORARY = llvm_cbe_tmp30;   /* for PHI node */
  goto llvm_cbe_bb31;

llvm_cbe_bb3:
  llvm_cbe_tmp3_2e_i_2e_i = *llvm_cbe_tmp2_2e_i_2e_i18;
  llvm_cbe_tmp8 = *((&llvm_cbe_tmp3_2e_i_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge1)))]));
  if ((llvm_cbe_tmp8 == llvm_cbe_s)) {
    goto llvm_cbe_bb19;
  } else {
    goto llvm_cbe_bb28;
  }

llvm_cbe_bb:
  if ((llvm_cbe_s == ((struct l_struct_2E_Stroke *)/*NULL*/0))) {
    goto llvm_cbe_bb19;
  } else {
    goto llvm_cbe_bb3;
  }

llvm_cbe__ZN6Stroke5resetEP7b2World_2e_exit:
  *llvm_cbe_tmp1_2e_i6 = ((struct l_struct_2E_b2Body *)/*NULL*/0);
  *((&llvm_cbe_tmp27->field7)) = 0x1.cp+2;
  llvm_cbe_tmp26_2e_i = *((&llvm_cbe_tmp27->field3.field0));
  *((&llvm_cbe_tmp27->field10.field0.field0)) = llvm_cbe_tmp26_2e_i;
  llvm_cbe_tmp29_2e_i = *((&llvm_cbe_tmp27->field3.field1));
  *((&llvm_cbe_tmp27->field10.field0.field1)) = llvm_cbe_tmp29_2e_i;
  *((&llvm_cbe_tmp27->field10.field1.field0)) = llvm_cbe_tmp26_2e_i;
  *((&llvm_cbe_tmp27->field10.field1.field1)) = llvm_cbe_tmp29_2e_i;
  *((&llvm_cbe_tmp27->field13[((signed long long )1ull)])) = ((unsigned char )0);
  *((&llvm_cbe_tmp27->field13[((signed long long )0ull)])) = ((unsigned char )0);
  _ZN4PathaSERKS_(((&llvm_cbe_tmp27->field4)), ((&llvm_cbe_tmp27->field0)));
  *((&llvm_cbe_tmp27->field14)) = 0u;
  *((&llvm_cbe_tmp27->field11)) = ((unsigned char )0);
  goto llvm_cbe_bb28;

llvm_cbe_bb19:
  llvm_cbe_tmp22 = *llvm_cbe_tmp21;
  llvm_cbe_tmp3_2e_i_2e_i19 = *llvm_cbe_tmp2_2e_i_2e_i18;
  llvm_cbe_tmp27 = *((&llvm_cbe_tmp3_2e_i_2e_i19[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge1)))]));
  llvm_cbe_tmp1_2e_i6 = (&llvm_cbe_tmp27->field12);
  llvm_cbe_tmp2_2e_i7 = *llvm_cbe_tmp1_2e_i6;
  if (((((llvm_cbe_tmp2_2e_i7 == ((struct l_struct_2E_b2Body *)/*NULL*/0)) | (llvm_cbe_tmp22 == ((struct l_struct_2E_b2World *)/*NULL*/0)))&1))) {
    goto llvm_cbe__ZN6Stroke5resetEP7b2World_2e_exit;
  } else {
    goto llvm_cbe_bb9_2e_i;
  }

llvm_cbe_bb9_2e_i:
  _ZN7b2World11DestroyBodyEP6b2Body(llvm_cbe_tmp22, llvm_cbe_tmp2_2e_i7);
  goto llvm_cbe__ZN6Stroke5resetEP7b2World_2e_exit;

  } while (1); /* end of syntactic loop 'bb31' */
llvm_cbe_return:
  return;
}


static void _ZN5Scene12deleteStrokeEP6Stroke(struct l_struct_2E_Scene *llvm_cbe_this, struct l_struct_2E_Stroke *llvm_cbe_s) {
  unsigned int *llvm_cbe_tmp19_2e_i;
  unsigned int llvm_cbe_tmp20_2e_i;
  struct l_struct_2E_Stroke ***llvm_cbe_tmp2_2e_i;
  struct l_struct_2E_Stroke **llvm_cbe_tmp3_2e_i;
  struct l_struct_2E_Stroke *llvm_cbe_tmp7_2e_i;
  unsigned int llvm_cbe_tmp16_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge_2e_i;
  unsigned int llvm_cbe_storemerge_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp8;
  unsigned int llvm_cbe_tmp20_2e_i39;
  struct l_struct_2E_Stroke **llvm_cbe_tmp3_2e_i22;
  struct l_struct_2E_Stroke *llvm_cbe_tmp7_2e_i26;
  unsigned int llvm_cbe_tmp16_2e_i34;
  unsigned int llvm_cbe_storemerge1_2e_i36;
  unsigned int llvm_cbe_storemerge1_2e_i36__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge_2e_i44;
  unsigned int llvm_cbe_storemerge_2e_i44__PHI_TEMPORARY;
  struct l_struct_2E_Stroke **llvm_cbe_tmp17_2e_i;
  unsigned long long llvm_cbe_tmp1819_2e_i;
  unsigned char *ltmp_5_1;
  unsigned int llvm_cbe_tmp33_2e_i;

  if ((llvm_cbe_s == ((struct l_struct_2E_Stroke *)/*NULL*/0))) {
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb;
  }

llvm_cbe_bb:
  llvm_cbe_tmp19_2e_i = (&llvm_cbe_this->field2.field1);
  llvm_cbe_tmp20_2e_i = *llvm_cbe_tmp19_2e_i;
  llvm_cbe_tmp2_2e_i = (&llvm_cbe_this->field2.field0);
  llvm_cbe_storemerge1_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb17_2e_i;

  do {     /* Syntactic loop 'bb17.i' to make GCC happy */
llvm_cbe_bb17_2e_i:
  llvm_cbe_storemerge1_2e_i = llvm_cbe_storemerge1_2e_i__PHI_TEMPORARY;
  if ((((signed int )llvm_cbe_tmp20_2e_i) > ((signed int )llvm_cbe_storemerge1_2e_i))) {
    goto llvm_cbe_bb_2e_i;
  } else {
    llvm_cbe_storemerge_2e_i__PHI_TEMPORARY = 4294967295u;   /* for PHI node */
    goto llvm_cbe__ZN5ArrayIP6StrokeE7indexOfERKS1__2e_exit;
  }

llvm_cbe_bb14_2e_i:
  llvm_cbe_tmp16_2e_i = llvm_cbe_storemerge1_2e_i + 1u;
  llvm_cbe_storemerge1_2e_i__PHI_TEMPORARY = llvm_cbe_tmp16_2e_i;   /* for PHI node */
  goto llvm_cbe_bb17_2e_i;

llvm_cbe_bb_2e_i:
  llvm_cbe_tmp3_2e_i = *llvm_cbe_tmp2_2e_i;
  llvm_cbe_tmp7_2e_i = *((&llvm_cbe_tmp3_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge1_2e_i)))]));
  if ((llvm_cbe_tmp7_2e_i == llvm_cbe_s)) {
    llvm_cbe_storemerge_2e_i__PHI_TEMPORARY = llvm_cbe_storemerge1_2e_i;   /* for PHI node */
    goto llvm_cbe__ZN5ArrayIP6StrokeE7indexOfERKS1__2e_exit;
  } else {
    goto llvm_cbe_bb14_2e_i;
  }

  } while (1); /* end of syntactic loop 'bb17.i' */
llvm_cbe__ZN5ArrayIP6StrokeE7indexOfERKS1__2e_exit:
  llvm_cbe_storemerge_2e_i = llvm_cbe_storemerge_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp8 = *((&llvm_cbe_this->field7));
  if ((((signed int )llvm_cbe_tmp8) > ((signed int )llvm_cbe_storemerge_2e_i))) {
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb13;
  }

llvm_cbe_bb13:
  _ZN5Scene5resetEP6Stroke(llvm_cbe_this, llvm_cbe_s);
  llvm_cbe_tmp20_2e_i39 = *llvm_cbe_tmp19_2e_i;
  llvm_cbe_storemerge1_2e_i36__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb17_2e_i42;

  do {     /* Syntactic loop 'bb17.i42' to make GCC happy */
llvm_cbe_bb17_2e_i42:
  llvm_cbe_storemerge1_2e_i36 = llvm_cbe_storemerge1_2e_i36__PHI_TEMPORARY;
  if ((((signed int )llvm_cbe_tmp20_2e_i39) > ((signed int )llvm_cbe_storemerge1_2e_i36))) {
    goto llvm_cbe_bb_2e_i30;
  } else {
    llvm_cbe_storemerge_2e_i44__PHI_TEMPORARY = 4294967295u;   /* for PHI node */
    goto llvm_cbe__ZN5ArrayIP6StrokeE7indexOfERKS1__2e_exit46;
  }

llvm_cbe_bb14_2e_i35:
  llvm_cbe_tmp16_2e_i34 = llvm_cbe_storemerge1_2e_i36 + 1u;
  llvm_cbe_storemerge1_2e_i36__PHI_TEMPORARY = llvm_cbe_tmp16_2e_i34;   /* for PHI node */
  goto llvm_cbe_bb17_2e_i42;

llvm_cbe_bb_2e_i30:
  llvm_cbe_tmp3_2e_i22 = *llvm_cbe_tmp2_2e_i;
  llvm_cbe_tmp7_2e_i26 = *((&llvm_cbe_tmp3_2e_i22[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge1_2e_i36)))]));
  if ((llvm_cbe_tmp7_2e_i26 == llvm_cbe_s)) {
    llvm_cbe_storemerge_2e_i44__PHI_TEMPORARY = llvm_cbe_storemerge1_2e_i36;   /* for PHI node */
    goto llvm_cbe__ZN5ArrayIP6StrokeE7indexOfERKS1__2e_exit46;
  } else {
    goto llvm_cbe_bb14_2e_i35;
  }

  } while (1); /* end of syntactic loop 'bb17.i42' */
llvm_cbe__ZN5ArrayIP6StrokeE7indexOfERKS1__2e_exit46:
  llvm_cbe_storemerge_2e_i44 = llvm_cbe_storemerge_2e_i44__PHI_TEMPORARY;
  if ((((signed int )(llvm_cbe_tmp20_2e_i39 + 4294967295u)) > ((signed int )llvm_cbe_storemerge_2e_i44))) {
    goto llvm_cbe_bb_2e_i15;
  } else {
    goto llvm_cbe__ZN5ArrayIP6StrokeE5eraseEi_2e_exit;
  }

llvm_cbe_bb_2e_i15:
  llvm_cbe_tmp17_2e_i = *llvm_cbe_tmp2_2e_i;
  llvm_cbe_tmp1819_2e_i = ((signed long long )(signed int )llvm_cbe_storemerge_2e_i44);
  ltmp_5_1 = memcpy((((unsigned char *)((&llvm_cbe_tmp17_2e_i[((signed long long )llvm_cbe_tmp1819_2e_i)])))), (((unsigned char *)((&llvm_cbe_tmp17_2e_i[((signed long long )(llvm_cbe_tmp1819_2e_i + 1ull))])))), ((((signed long long )(signed int )((llvm_cbe_tmp20_2e_i39 - llvm_cbe_storemerge_2e_i44) + 4294967295u))) << 3ull));
  goto llvm_cbe__ZN5ArrayIP6StrokeE5eraseEi_2e_exit;

llvm_cbe__ZN5ArrayIP6StrokeE5eraseEi_2e_exit:
  llvm_cbe_tmp33_2e_i = *llvm_cbe_tmp19_2e_i;
  *llvm_cbe_tmp19_2e_i = (llvm_cbe_tmp33_2e_i + 4294967295u);
  return;
llvm_cbe_return:
  return;
}


static void _ZN4Game11hideOverlayEP7Overlay(struct l_struct_2E_Game *llvm_cbe_this, struct l_struct_2E_Os *llvm_cbe_o) {
  unsigned int  (**llvm_cbe_tmp3) ();
  unsigned int  (*llvm_cbe_tmp5) ();
  unsigned int *llvm_cbe_tmp19_2e_i;
  unsigned int llvm_cbe_tmp20_2e_i;
  struct l_struct_2E_Os ***llvm_cbe_tmp2_2e_i;
  struct l_struct_2E_Os **llvm_cbe_tmp3_2e_i;
  struct l_struct_2E_Os *llvm_cbe_tmp7_2e_i;
  unsigned int llvm_cbe_tmp16_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge_2e_i;
  unsigned int llvm_cbe_storemerge_2e_i__PHI_TEMPORARY;
  struct l_struct_2E_Os **llvm_cbe_tmp17_2e_i;
  unsigned long long llvm_cbe_tmp1819_2e_i;
  unsigned char *ltmp_6_1;
  unsigned int llvm_cbe_tmp33_2e_i;

  llvm_cbe_tmp3 = *((&llvm_cbe_o->field0));
  llvm_cbe_tmp5 = *((&llvm_cbe_tmp3[((signed long long )5ull)]));
  (((void  (*) (struct l_struct_2E_Os *))llvm_cbe_tmp5))(llvm_cbe_o);
  llvm_cbe_tmp19_2e_i = (&llvm_cbe_this->field4.field1);
  llvm_cbe_tmp20_2e_i = *llvm_cbe_tmp19_2e_i;
  llvm_cbe_tmp2_2e_i = (&llvm_cbe_this->field4.field0);
  llvm_cbe_storemerge1_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb17_2e_i;

  do {     /* Syntactic loop 'bb17.i' to make GCC happy */
llvm_cbe_bb17_2e_i:
  llvm_cbe_storemerge1_2e_i = llvm_cbe_storemerge1_2e_i__PHI_TEMPORARY;
  if ((((signed int )llvm_cbe_tmp20_2e_i) > ((signed int )llvm_cbe_storemerge1_2e_i))) {
    goto llvm_cbe_bb_2e_i;
  } else {
    llvm_cbe_storemerge_2e_i__PHI_TEMPORARY = 4294967295u;   /* for PHI node */
    goto llvm_cbe__ZN5ArrayIP7OverlayE7indexOfERKS1__2e_exit;
  }

llvm_cbe_bb14_2e_i:
  llvm_cbe_tmp16_2e_i = llvm_cbe_storemerge1_2e_i + 1u;
  llvm_cbe_storemerge1_2e_i__PHI_TEMPORARY = llvm_cbe_tmp16_2e_i;   /* for PHI node */
  goto llvm_cbe_bb17_2e_i;

llvm_cbe_bb_2e_i:
  llvm_cbe_tmp3_2e_i = *llvm_cbe_tmp2_2e_i;
  llvm_cbe_tmp7_2e_i = *((&llvm_cbe_tmp3_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge1_2e_i)))]));
  if ((llvm_cbe_tmp7_2e_i == llvm_cbe_o)) {
    llvm_cbe_storemerge_2e_i__PHI_TEMPORARY = llvm_cbe_storemerge1_2e_i;   /* for PHI node */
    goto llvm_cbe__ZN5ArrayIP7OverlayE7indexOfERKS1__2e_exit;
  } else {
    goto llvm_cbe_bb14_2e_i;
  }

  } while (1); /* end of syntactic loop 'bb17.i' */
llvm_cbe__ZN5ArrayIP7OverlayE7indexOfERKS1__2e_exit:
  llvm_cbe_storemerge_2e_i = llvm_cbe_storemerge_2e_i__PHI_TEMPORARY;
  if ((((signed int )(llvm_cbe_tmp20_2e_i + 4294967295u)) > ((signed int )llvm_cbe_storemerge_2e_i))) {
    goto llvm_cbe_bb_2e_i15;
  } else {
    goto llvm_cbe__ZN5ArrayIP7OverlayE5eraseEi_2e_exit;
  }

llvm_cbe_bb_2e_i15:
  llvm_cbe_tmp17_2e_i = *llvm_cbe_tmp2_2e_i;
  llvm_cbe_tmp1819_2e_i = ((signed long long )(signed int )llvm_cbe_storemerge_2e_i);
  ltmp_6_1 = memcpy((((unsigned char *)((&llvm_cbe_tmp17_2e_i[((signed long long )llvm_cbe_tmp1819_2e_i)])))), (((unsigned char *)((&llvm_cbe_tmp17_2e_i[((signed long long )(llvm_cbe_tmp1819_2e_i + 1ull))])))), ((((signed long long )(signed int )((llvm_cbe_tmp20_2e_i - llvm_cbe_storemerge_2e_i) + 4294967295u))) << 3ull));
  goto llvm_cbe__ZN5ArrayIP7OverlayE5eraseEi_2e_exit;

llvm_cbe__ZN5ArrayIP7OverlayE5eraseEi_2e_exit:
  llvm_cbe_tmp33_2e_i = *llvm_cbe_tmp19_2e_i;
  *llvm_cbe_tmp19_2e_i = (llvm_cbe_tmp33_2e_i + 4294967295u);
  *((&llvm_cbe_this->field0.field3)) = ((unsigned char )1);
  return;
}


static void _ZN5Scene5clearEv(struct l_struct_2E_Scene *llvm_cbe_this) {
  unsigned int *llvm_cbe_tmp2_2e_i6;
  struct l_struct_2E_Stroke ***llvm_cbe_tmp2_2e_i_2e_i;
  unsigned int *llvm_cbe_tmp1_2e_i11;
  struct l_struct_2E_Stroke **llvm_cbe_tmp3_2e_i_2e_i;
  struct l_struct_2E_Stroke *llvm_cbe_tmp5;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp2_2e_i_2e_i_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp7_2e_i_2e_i_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp2_2e_i_2e_i60_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp7_2e_i_2e_i64_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp2_2e_i_2e_i38_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp7_2e_i_2e_i42_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp2_2e_i_2e_i16_2e_i;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp7_2e_i_2e_i20_2e_i;
  unsigned int llvm_cbe_tmp2_2e_i12;
  struct l_struct_2E_Stroke **llvm_cbe_tmp17_2e_i;
  unsigned char *ltmp_7_1;
  unsigned int llvm_cbe_tmp33_2e_i;
  unsigned int llvm_cbe_tmp3_2e_i7;
  struct l_struct_2E_b2World *llvm_cbe_tmp27;

  _ZN5Scene5resetEP6Stroke(llvm_cbe_this, ((struct l_struct_2E_Stroke *)/*NULL*/0));
  llvm_cbe_tmp2_2e_i6 = (&llvm_cbe_this->field2.field1);
  llvm_cbe_tmp2_2e_i_2e_i = (&llvm_cbe_this->field2.field0);
  llvm_cbe_tmp1_2e_i11 = (&llvm_cbe_this->field2.field1);
  goto llvm_cbe_bb16;

  do {     /* Syntactic loop 'bb16' to make GCC happy */
llvm_cbe_bb16:
  llvm_cbe_tmp3_2e_i7 = *llvm_cbe_tmp2_2e_i6;
  if ((llvm_cbe_tmp3_2e_i7 == 0u)) {
    goto llvm_cbe_bb24;
  } else {
    goto llvm_cbe_bb;
  }

llvm_cbe__ZN5ArrayIP6StrokeE5eraseEi_2e_exit:
  llvm_cbe_tmp33_2e_i = *llvm_cbe_tmp1_2e_i11;
  *llvm_cbe_tmp1_2e_i11 = (llvm_cbe_tmp33_2e_i + 4294967295u);
  goto llvm_cbe_bb16;

llvm_cbe_bb13:
  llvm_cbe_tmp2_2e_i12 = *llvm_cbe_tmp1_2e_i11;
  if ((((signed int )(llvm_cbe_tmp2_2e_i12 + 4294967295u)) > ((signed int )0u))) {
    goto llvm_cbe_bb_2e_i;
  } else {
    goto llvm_cbe__ZN5ArrayIP6StrokeE5eraseEi_2e_exit;
  }

llvm_cbe_bb:
  llvm_cbe_tmp3_2e_i_2e_i = *llvm_cbe_tmp2_2e_i_2e_i;
  llvm_cbe_tmp5 = *llvm_cbe_tmp3_2e_i_2e_i;
  if ((llvm_cbe_tmp5 == ((struct l_struct_2E_Stroke *)/*NULL*/0))) {
    goto llvm_cbe_bb13;
  } else {
    goto llvm_cbe_bb9;
  }

llvm_cbe__ZN6StrokeD1Ev_2e_exit:
  _ZdlPv((((unsigned char *)llvm_cbe_tmp5)));
  goto llvm_cbe_bb13;

llvm_cbe__ZN4PathD1Ev_2e_exit45_2e_i:
  llvm_cbe_tmp2_2e_i_2e_i16_2e_i = *((&llvm_cbe_tmp5->field0.field0.field0));
  if ((llvm_cbe_tmp2_2e_i_2e_i16_2e_i == ((struct l_struct_2E_Vec2 *)/*NULL*/0))) {
    goto llvm_cbe__ZN6StrokeD1Ev_2e_exit;
  } else {
    goto llvm_cbe_bb_2e_i_2e_i22_2e_i;
  }

llvm_cbe__ZN4PathD1Ev_2e_exit67_2e_i:
  llvm_cbe_tmp2_2e_i_2e_i38_2e_i = *((&llvm_cbe_tmp5->field4.field0.field0));
  if ((llvm_cbe_tmp2_2e_i_2e_i38_2e_i == ((struct l_struct_2E_Vec2 *)/*NULL*/0))) {
    goto llvm_cbe__ZN4PathD1Ev_2e_exit45_2e_i;
  } else {
    goto llvm_cbe_bb_2e_i_2e_i44_2e_i;
  }

llvm_cbe__ZN4PathD1Ev_2e_exit_2e_i:
  llvm_cbe_tmp2_2e_i_2e_i60_2e_i = *((&llvm_cbe_tmp5->field5.field0.field0));
  if ((llvm_cbe_tmp2_2e_i_2e_i60_2e_i == ((struct l_struct_2E_Vec2 *)/*NULL*/0))) {
    goto llvm_cbe__ZN4PathD1Ev_2e_exit67_2e_i;
  } else {
    goto llvm_cbe_bb_2e_i_2e_i66_2e_i;
  }

llvm_cbe_bb9:
  llvm_cbe_tmp2_2e_i_2e_i_2e_i = *((&llvm_cbe_tmp5->field6.field0.field0));
  if ((llvm_cbe_tmp2_2e_i_2e_i_2e_i == ((struct l_struct_2E_Vec2 *)/*NULL*/0))) {
    goto llvm_cbe__ZN4PathD1Ev_2e_exit_2e_i;
  } else {
    goto llvm_cbe_bb_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb_2e_i_2e_i_2e_i:
  llvm_cbe_tmp7_2e_i_2e_i_2e_i = *((&llvm_cbe_tmp5->field6.field0.field0));
  free((((unsigned char *)llvm_cbe_tmp7_2e_i_2e_i_2e_i)));
  goto llvm_cbe__ZN4PathD1Ev_2e_exit_2e_i;

llvm_cbe_bb_2e_i_2e_i66_2e_i:
  llvm_cbe_tmp7_2e_i_2e_i64_2e_i = *((&llvm_cbe_tmp5->field5.field0.field0));
  free((((unsigned char *)llvm_cbe_tmp7_2e_i_2e_i64_2e_i)));
  goto llvm_cbe__ZN4PathD1Ev_2e_exit67_2e_i;

llvm_cbe_bb_2e_i_2e_i44_2e_i:
  llvm_cbe_tmp7_2e_i_2e_i42_2e_i = *((&llvm_cbe_tmp5->field4.field0.field0));
  free((((unsigned char *)llvm_cbe_tmp7_2e_i_2e_i42_2e_i)));
  goto llvm_cbe__ZN4PathD1Ev_2e_exit45_2e_i;

llvm_cbe_bb_2e_i_2e_i22_2e_i:
  llvm_cbe_tmp7_2e_i_2e_i20_2e_i = *((&llvm_cbe_tmp5->field0.field0.field0));
  free((((unsigned char *)llvm_cbe_tmp7_2e_i_2e_i20_2e_i)));
  goto llvm_cbe__ZN6StrokeD1Ev_2e_exit;

llvm_cbe_bb_2e_i:
  llvm_cbe_tmp17_2e_i = *llvm_cbe_tmp2_2e_i_2e_i;
  ltmp_7_1 = memcpy((((unsigned char *)llvm_cbe_tmp17_2e_i)), (((unsigned char *)((&llvm_cbe_tmp17_2e_i[((signed long long )1ull)])))), ((((signed long long )(signed int )(llvm_cbe_tmp2_2e_i12 + 4294967295u))) << 3ull));
  goto llvm_cbe__ZN5ArrayIP6StrokeE5eraseEi_2e_exit;

  } while (1); /* end of syntactic loop 'bb16' */
llvm_cbe_bb24:
  llvm_cbe_tmp27 = *((&llvm_cbe_this->field1));
  if ((llvm_cbe_tmp27 == ((struct l_struct_2E_b2World *)/*NULL*/0))) {
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb31;
  }

llvm_cbe_bb31:
  _ZN7b2World4StepEfi(llvm_cbe_tmp27);
  return;
llvm_cbe_return:
  return;
}


static void _ZN7b2World4StepEfi(struct l_struct_2E_b2World *llvm_cbe_this) {
  unsigned int llvm_cbe_stackCount_2e_i_2e_0_2e_reg2mem;    /* Address-exposed local */
  float llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reg2mem;    /* Address-exposed local */
  unsigned long long llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_1_2e_reg2mem;    /* Address-exposed local */
  unsigned long long llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_1_2e_reg2mem;    /* Address-exposed local */
  float llvm_cbe_storemerge_2e_i_2e_i313_2e_i_2e_i_2e_reg2mem;    /* Address-exposed local */
  float llvm_cbe_storemerge_2e_i_2e_i_2e_i_2e_i824_2e_reg2mem;    /* Address-exposed local */
  unsigned int llvm_cbe_stackCount_2e_i513_2e_0_2e_reg2mem;    /* Address-exposed local */
  struct l_struct_2E_b2ContactSolver llvm_cbe_contactSolver_2e_i_2e_i492;    /* Address-exposed local */
  struct l_struct_2E_b2Island llvm_cbe_island_2e_i520;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_w_2e_i_2e_i_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_v_2e_i_2e_i_2e_i_2e_i24;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_points_2e_i_2e_i_2e_i_2e_i[3];    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_p2s_2e_i_2e_i_2e_i_2e_i[3];    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_p1s_2e_i_2e_i_2e_i_2e_i[3];    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_tmp7_2e_i_2e_i172_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2XForm llvm_cbe_xf2_2e_i_2e_i29;    /* Address-exposed local */
  struct l_struct_2E_b2XForm llvm_cbe_xf1_2e_i_2e_i30;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_p2_2e_i_2e_i31;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_p1_2e_i_2e_i32;    /* Address-exposed local */
  struct l_struct_2E_b2ContactSolver llvm_cbe_contactSolver_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2TimeStep llvm_cbe_subStep_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Island llvm_cbe_island_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_s2_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_s1_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Color llvm_cbe_color_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_p2_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_p1_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_x2_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_x1_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2XForm llvm_cbe_xf_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_vs_2e_i[4];    /* Address-exposed local */
  struct l_struct_2E_b2Color llvm_cbe_color_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_vs3_2e_i[4];    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_vs6_2e_i[4];    /* Address-exposed local */
  struct l_struct_2E_b2Color llvm_cbe_color7_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_x2_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_x1_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Color llvm_cbe_color10_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Color llvm_cbe_tmp24_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Color llvm_cbe_tmp39_2e_i10;    /* Address-exposed local */
  struct l_struct_2E_b2Color llvm_cbe_tmp40_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Color llvm_cbe_tmp41_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2TimeStep llvm_cbe_step;    /* Address-exposed local */
  unsigned char *llvm_cbe_tmp1;
  float *llvm_cbe_tmp2;
  unsigned int *llvm_cbe_tmp4;
  float *llvm_cbe_tmp16;
  float llvm_cbe_tmp17;
  float *llvm_cbe_tmp20;
  unsigned char *llvm_cbe_tmp22;
  unsigned char llvm_cbe_tmp23;
  unsigned char llvm_cbe_tmp27;
  unsigned char *llvm_cbe_tmp28;
  struct l_struct_2E_b2World *llvm_cbe_tmp2_2e_i;
  struct l_struct_2E_b2Contact **llvm_cbe_tmp3_2e_i;
  struct l_struct_2E_b2World **llvm_cbe_tmp29_2e_i;
  struct l_struct_2E_b2Shape *llvm_cbe_tmp3_2e_i_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp3_2e_i8_2e_i;
  unsigned short llvm_cbe_tmp3_2e_i15_2e_i;
  struct l_struct_2E_b2Shape *llvm_cbe_tmp3_2e_i27_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp3_2e_i23_2e_i;
  unsigned short llvm_cbe_tmp3_2e_i12_2e_i;
  struct l_struct_2E_b2World *llvm_cbe_tmp30_2e_i;
  struct l_struct_2E_Os *llvm_cbe_tmp32_2e_i;
  struct l_struct_2E_b2Contact **llvm_cbe_tmp2_2e_i3_2e_i;
  struct l_struct_2E_b2Contact **llvm_cbe_storemerge1_2e_i_2e_in;
  struct l_struct_2E_b2Contact **llvm_cbe_storemerge1_2e_i_2e_in__PHI_TEMPORARY;
  struct l_struct_2E_b2Contact *llvm_cbe_storemerge1_2e_i;
  float llvm_cbe_tmp32;
  unsigned int *llvm_cbe_tmp5_2e_i524;
  struct l_struct_2E_Os *llvm_cbe_tmp8_2e_i525;
  struct l_struct_2E_b2StackAllocator *llvm_cbe_tmp10_2e_i;
  unsigned int llvm_cbe_tmp13_2e_i528;
  unsigned int llvm_cbe_tmp16_2e_i531;
  unsigned int *llvm_cbe_tmp18_2e_i533;
  unsigned int llvm_cbe_tmp19_2e_i534;
  unsigned int *llvm_cbe_tmp1_2e_i_2e_i536;
  unsigned int *llvm_cbe_tmp4_2e_i_2e_i539;
  unsigned int *llvm_cbe_tmp7_2e_i_2e_i542;
  unsigned int *llvm_cbe_tmp10_2e_i_2e_i545;
  unsigned int *llvm_cbe_tmp12_2e_i_2e_i547;
  unsigned int *llvm_cbe_tmp14_2e_i_2e_i549;
  struct l_struct_2E_b2StackAllocator **llvm_cbe_tmp16_2e_i_2e_i551;
  unsigned char *llvm_cbe_tmp28_2e_i_2e_i561;
  struct l_struct_2E_b2Body ***llvm_cbe_tmp31_2e_i_2e_i564;
  struct l_struct_2E_b2StackAllocator *llvm_cbe_tmp38_2e_i_2e_i569;
  unsigned char *llvm_cbe_tmp39_2e_i_2e_i570;
  struct l_struct_2E_b2Contact ***llvm_cbe_tmp42_2e_i_2e_i573;
  struct l_struct_2E_b2StackAllocator *llvm_cbe_tmp49_2e_i_2e_i578;
  unsigned char *llvm_cbe_tmp50_2e_i_2e_i579;
  struct l_struct_2E_b2Joint ***llvm_cbe_tmp53_2e_i_2e_i582;
  unsigned int *llvm_cbe_tmp55_2e_i_2e_i584;
  struct l_struct_2E_b2Body **llvm_cbe_tmp21_2e_i586;
  unsigned short *llvm_cbe_tmp24_2e_i588;
  unsigned short llvm_cbe_tmp25_2e_i589;
  struct l_struct_2E_b2Body **llvm_cbe_tmp30_2e_i594;
  struct l_struct_2E_b2Body **llvm_cbe_storemerge_2e_in_2e_i596;
  struct l_struct_2E_b2Body **llvm_cbe_storemerge_2e_in_2e_i596__PHI_TEMPORARY;
  struct l_struct_2E_b2Body *llvm_cbe_storemerge_2e_i597;
  struct l_struct_2E_b2Contact **llvm_cbe_tmp38_2e_i600;
  unsigned int *llvm_cbe_tmp42_2e_i602;
  unsigned int llvm_cbe_tmp43_2e_i603;
  struct l_struct_2E_b2Contact **llvm_cbe_tmp48_2e_i608;
  struct l_struct_2E_b2Contact **llvm_cbe_storemerge1_2e_in_2e_i609;
  struct l_struct_2E_b2Contact **llvm_cbe_storemerge1_2e_in_2e_i609__PHI_TEMPORARY;
  struct l_struct_2E_b2Contact *llvm_cbe_storemerge1_2e_i610;
  struct l_struct_2E_b2Joint **llvm_cbe_tmp57_2e_i612;
  struct l_struct_2E_b2Joint **llvm_cbe_tmp63_2e_i;
  struct l_struct_2E_b2Joint **llvm_cbe_storemerge2_2e_in_2e_i;
  struct l_struct_2E_b2Joint **llvm_cbe_storemerge2_2e_in_2e_i__PHI_TEMPORARY;
  struct l_struct_2E_b2Joint *llvm_cbe_storemerge2_2e_i617;
  unsigned int llvm_cbe_tmp73_2e_i619;
  unsigned char *llvm_cbe_tmp80_2e_i622;
  struct l_struct_2E_b2Body **llvm_cbe_tmp8081_2e_i;
  unsigned char *llvm_cbe_tmp283_2e_i740;
  float *llvm_cbe_tmp2_2e_i71_2e_i_2e_i;
  float *llvm_cbe_tmp9_2e_i78_2e_i_2e_i;
  unsigned int *llvm_cbe_tmp200_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2ContactConstraint **llvm_cbe_tmp14_2e_i350_2e_i_2e_i;
  struct l_struct_2E_b2StackAllocator **llvm_cbe_tmp4_2e_i25_2e_i_2e_i;
  unsigned short *llvm_cbe_tmp87_2e_i;
  unsigned short llvm_cbe_tmp88_2e_i626;
  unsigned short llvm_cbe_tmp3_2e_i54_2e_i;
  unsigned short llvm_cbe_tmp109_2e_i;
  unsigned int llvm_cbe_stackCount_2e_i513_2e_0_2e_reload;
  unsigned int llvm_cbe_tmp115_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp120_2e_i;
  unsigned int llvm_cbe_tmp2_2e_i72_2e_i;
  unsigned int llvm_cbe_tmp5_2e_i75_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_tmp14_2e_i79_2e_i;
  unsigned short *llvm_cbe_tmp123_2e_i648;
  unsigned short llvm_cbe_tmp124_2e_i649;
  unsigned short llvm_cbe_tmp3_2e_i184_2e_i;
  struct l_struct_2E_b2ContactEdge **llvm_cbe_tmp134_2e_i655;
  struct l_struct_2E_b2Contact **llvm_cbe_tmp138_2e_i657;
  struct l_struct_2E_b2Contact *llvm_cbe_tmp139_2e_i;
  unsigned int llvm_cbe_tmp141_2e_i659;
  unsigned int llvm_cbe_tmp3_2e_i180_2e_i;
  unsigned int llvm_cbe_tmp2_2e_i160_2e_i;
  unsigned int llvm_cbe_tmp5_2e_i163_2e_i;
  struct l_struct_2E_b2Contact **llvm_cbe_tmp14_2e_i168_2e_i;
  struct l_struct_2E_b2Contact *llvm_cbe_tmp161_2e_i671;
  unsigned int *llvm_cbe_tmp165_2e_i675;
  unsigned int llvm_cbe_tmp166_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp171_2e_i;
  unsigned short *llvm_cbe_tmp173_2e_i;
  unsigned short llvm_cbe_tmp174_2e_i;
  unsigned int llvm_cbe_tmp197_2e_i687;
  unsigned short llvm_cbe_tmp200_2e_i;
  unsigned int llvm_cbe_stackCount_2e_i513_2e_1;
  unsigned int llvm_cbe_stackCount_2e_i513_2e_1__PHI_TEMPORARY;
  struct l_struct_2E_b2ContactEdge **llvm_cbe_tmp206_2e_i;
  unsigned int llvm_cbe_stackCount_2e_i513_2e_2;
  unsigned int llvm_cbe_stackCount_2e_i513_2e_2__PHI_TEMPORARY;
  struct l_struct_2E_b2ContactEdge **llvm_cbe_storemerge3_2e_in_2e_i693;
  struct l_struct_2E_b2ContactEdge **llvm_cbe_storemerge3_2e_in_2e_i693__PHI_TEMPORARY;
  struct l_struct_2E_b2ContactEdge *llvm_cbe_storemerge3_2e_i694;
  struct l_struct_2E_b2JointEdge **llvm_cbe_tmp215_2e_i697;
  struct l_struct_2E_b2Joint **llvm_cbe_tmp219_2e_i699;
  struct l_struct_2E_b2Joint *llvm_cbe_tmp220_2e_i700;
  unsigned char llvm_cbe_tmp222_2e_i702;
  unsigned int llvm_cbe_tmp2_2e_i139_2e_i;
  unsigned int llvm_cbe_tmp5_2e_i142_2e_i;
  struct l_struct_2E_b2Joint **llvm_cbe_tmp14_2e_i147_2e_i;
  struct l_struct_2E_b2Joint *llvm_cbe_tmp230_2e_i712;
  struct l_struct_2E_b2Body *llvm_cbe_tmp234_2e_i;
  unsigned short *llvm_cbe_tmp236_2e_i716;
  unsigned short llvm_cbe_tmp237_2e_i717;
  unsigned int llvm_cbe_tmp260_2e_i728;
  unsigned short llvm_cbe_tmp263_2e_i;
  unsigned int llvm_cbe_stackCount_2e_i513_2e_3;
  unsigned int llvm_cbe_stackCount_2e_i513_2e_3__PHI_TEMPORARY;
  struct l_struct_2E_b2JointEdge **llvm_cbe_tmp269_2e_i733;
  unsigned int llvm_cbe_stackCount_2e_i513_2e_4;
  unsigned int llvm_cbe_stackCount_2e_i513_2e_4__PHI_TEMPORARY;
  struct l_struct_2E_b2JointEdge **llvm_cbe_storemerge4_2e_in_2e_i734;
  struct l_struct_2E_b2JointEdge **llvm_cbe_storemerge4_2e_in_2e_i734__PHI_TEMPORARY;
  struct l_struct_2E_b2JointEdge *llvm_cbe_storemerge4_2e_i735;
  unsigned int llvm_cbe_stackCount_2e_i513_2e_0_2e_be;
  unsigned int llvm_cbe_stackCount_2e_i513_2e_0_2e_be__PHI_TEMPORARY;
  unsigned char llvm_cbe_tmp284_2e_i741;
  unsigned char llvm_cbe_tmp288_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_tmp21_2e_i112_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp25_2e_i114_2e_i;
  unsigned short llvm_cbe_tmp3_2e_i_2e_i_2e_i750;
  float llvm_cbe_tmp34_2e_i_2e_i756;
  float llvm_cbe_tmp3_2e_i46_2e_i_2e_i;
  float *llvm_cbe_tmp7_2e_i50_2e_i_2e_i;
  float llvm_cbe_tmp8_2e_i51_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp19_2e_i_2e_i_2e_i7671740__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i_2e_i_2e_i7701747__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp22_2e_i_2e_i_2e_i770174717481749_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp39_2e_i121_2e_i1710__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp42_2e_i123_2e_i1714__BITCAST_TEMPORARY;
  float llvm_cbe_tmp3_2e_i72_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i79_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i98_2e_i_2e_i1754__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i101_2e_i_2e_i1761__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i101_2e_i_2e_i176117621763_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp48_2e_i126_2e_i1717__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp51_2e_i_2e_i7841721__BITCAST_TEMPORARY;
  float llvm_cbe_tmp54_2e_i131_2e_i;
  llvmBitCastUnion llvm_cbe_tmp19_2e_i138_2e_i_2e_i1768__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i141_2e_i_2e_i1775__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp22_2e_i141_2e_i_2e_i177517761777_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp59_2e_i_2e_i7871724__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp62_2e_i_2e_i7901728__BITCAST_TEMPORARY;
  struct l_struct_2E_b2Vec2 *llvm_cbe_tmp64_2e_i_2e_i792;
  float *llvm_cbe_tmp1_2e_i151_2e_i_2e_i;
  float llvm_cbe_tmp2_2e_i152_2e_i_2e_i;
  float llvm_cbe_tmp6_2e_i156_2e_i_2e_i;
  float *llvm_cbe_tmp10_2e_i160_2e_i_2e_i;
  float llvm_cbe_tmp11_2e_i161_2e_i_2e_i;
  float llvm_cbe_tmp15_2e_i165_2e_i_2e_i;
  float *llvm_cbe_tmp66_2e_i_2e_i794;
  float llvm_cbe_tmp67_2e_i_2e_i795;
  float llvm_cbe_tmp70_2e_i_2e_i798;
  float llvm_cbe_tmp73_2e_i_2e_i801;
  float *llvm_cbe_tmp76_2e_i_2e_i804;
  float llvm_cbe_tmp77_2e_i_2e_i;
  float llvm_cbe_tmp79_2e_i_2e_i806;
  float llvm_cbe_tmp88_2e_i_2e_i815;
  float llvm_cbe_tmp91_2e_i_2e_i818;
  float llvm_cbe_tmp93_2e_i_2e_i820;
  float llvm_cbe_storemerge_2e_i_2e_i_2e_i_2e_i824_2e_reload2153;
  float llvm_cbe_storemerge_2e_i11_2e_i_2e_i_2e_i;
  float llvm_cbe_storemerge_2e_i11_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  float llvm_cbe_tmp4_2e_i284_2e_i_2e_i;
  float llvm_cbe_tmp11_2e_i291_2e_i_2e_i;
  float llvm_cbe_tmp102_2e_i_2e_i835;
  float llvm_cbe_tmp105_2e_i_2e_i838;
  float llvm_cbe_tmp107_2e_i_2e_i840;
  float llvm_cbe_storemerge_2e_i_2e_i313_2e_i_2e_i_2e_reload2156;
  float llvm_cbe_storemerge_2e_i11_2e_i324_2e_i_2e_i;
  float llvm_cbe_storemerge_2e_i11_2e_i324_2e_i_2e_i__PHI_TEMPORARY;
  float llvm_cbe_tmp124_2e_i_2e_i850;
  float llvm_cbe_tmp2_2e_i412_2e_i_2e_i;
  float llvm_cbe_tmp9_2e_i419_2e_i_2e_i;
  float llvm_cbe_tmp130_2e_i_2e_i856;
  unsigned long long llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_0;
  unsigned long long llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp155_2e_i_2e_i;
  unsigned long long llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_1;
  unsigned long long llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge_2e_i132_2e_i;
  unsigned int llvm_cbe_storemerge_2e_i132_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp159_2e_i_2e_i870;
  struct l_struct_2E_b2StackAllocator *llvm_cbe_tmp167_2e_i_2e_i;
  unsigned int llvm_cbe_tmp170_2e_i_2e_i;
  struct l_struct_2E_b2Contact **llvm_cbe_tmp173_2e_i_2e_i878;
  struct l_struct_2E_b2ContactConstraint *llvm_cbe_tmp15_2e_i351_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp1617_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp21_2e_i355_2e_i_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp24_2e_i358_2e_i_2e_i;
  float llvm_cbe_tmp27_2e_i361_2e_i_2e_i;
  float llvm_cbe_tmp30_2e_i364_2e_i_2e_i;
  float llvm_cbe_tmp33_2e_i_2e_i_2e_i882;
  float llvm_cbe_tmp36_2e_i368_2e_i_2e_i;
  float llvm_cbe_tmp41_2e_i371_2e_i_2e_i;
  float llvm_cbe_tmp44_2e_i374_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp20_2e_i_2e_i_2e_i_2e_i9061838__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i_2e_i_2e_i_2e_i9091845__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp23_2e_i_2e_i_2e_i_2e_i909184518461847_2e_ins;
  float llvm_cbe_tmp55_2e_i_2e_i_2e_i9161794;
  llvmBitCastUnion llvm_cbe_tmp55_2e_i_2e_i_2e_i9161794__BITCAST_TEMPORARY;
  float llvm_cbe_tmp58_2e_i_2e_i_2e_i9181798;
  llvmBitCastUnion llvm_cbe_tmp58_2e_i_2e_i_2e_i9181798__BITCAST_TEMPORARY;
  unsigned char llvm_cbe_tmp61_2e_i_2e_i_2e_i921;
  unsigned int *llvm_cbe_tmp189_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp119_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp1_2e_i150_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp10_2e_i159_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp141_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp1_2e_i69_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp10_2e_i78_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp6768_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp72_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp75_2e_i_2e_i_2e_i926;
  float llvm_cbe_tmp76_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp80_2e_i_2e_i_2e_i930;
  float llvm_cbe_tmp81_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp84_2e_i_2e_i_2e_i931;
  float llvm_cbe_tmp85_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp19_2e_i355_2e_i_2e_i_2e_i1908__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i358_2e_i_2e_i_2e_i1915__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp22_2e_i358_2e_i_2e_i_2e_i191519161917_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp95_2e_i_2e_i_2e_i1801__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp98_2e_i_2e_i_2e_i1805__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp19_2e_i310_2e_i_2e_i_2e_i1894__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i313_2e_i_2e_i_2e_i1901__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp22_2e_i313_2e_i_2e_i_2e_i190119021903_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp106_2e_i_2e_i_2e_i1808__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp109_2e_i_2e_i_2e_i1812__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i269_2e_i_2e_i_2e_i1880__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i272_2e_i_2e_i_2e_i1887__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i272_2e_i_2e_i_2e_i188718881889_2e_ins;
  float llvm_cbe_tmp114_2e_i_2e_i_2e_i1815;
  llvmBitCastUnion llvm_cbe_tmp114_2e_i_2e_i_2e_i1815__BITCAST_TEMPORARY;
  float llvm_cbe_tmp117_2e_i_2e_i_2e_i1819;
  llvmBitCastUnion llvm_cbe_tmp117_2e_i_2e_i_2e_i1819__BITCAST_TEMPORARY;
  float llvm_cbe_tmp120_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp3_2e_i217_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i224_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp19_2e_i201_2e_i_2e_i_2e_i1866__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i204_2e_i_2e_i_2e_i1873__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp22_2e_i204_2e_i_2e_i_2e_i187318741875_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp134_2e_i_2e_i_2e_i1822__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp137_2e_i_2e_i_2e_i1826__BITCAST_TEMPORARY;
  float llvm_cbe_tmp2_2e_i151_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp11_2e_i160_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp142_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp3_2e_i134_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i141_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp19_2e_i120_2e_i_2e_i_2e_i1852__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i123_2e_i_2e_i_2e_i1859__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp22_2e_i123_2e_i_2e_i_2e_i185918601861_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp156_2e_i_2e_i_2e_i1829__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp159_2e_i_2e_i_2e_i1833__BITCAST_TEMPORARY;
  float llvm_cbe_tmp2_2e_i70_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp11_2e_i79_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp163_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge_2e_i388_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge_2e_i388_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp167_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp190_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp178179_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp186_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge64_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge64_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp197_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge65_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge65_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp201_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2Joint **llvm_cbe_tmp186_2e_i_2e_i937;
  struct l_struct_2E_b2Joint *llvm_cbe_tmp190_2e_i_2e_i940;
  unsigned int  (**llvm_cbe_tmp192_2e_i_2e_i942) ();
  unsigned int  (*llvm_cbe_tmp194_2e_i_2e_i) ();
  unsigned int llvm_cbe_tmp206_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge6_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge6_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp210_2e_i_2e_i;
  struct l_struct_2E_b2Joint **llvm_cbe_tmp228_2e_i_2e_i;
  struct l_struct_2E_b2Joint *llvm_cbe_tmp232_2e_i_2e_i;
  unsigned int  (**llvm_cbe_tmp234_2e_i_2e_i) ();
  unsigned int  (*llvm_cbe_tmp236_2e_i_2e_i) ();
  unsigned int llvm_cbe_tmp248_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge7_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge7_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp252_2e_i_2e_i;
  unsigned int llvm_cbe_tmp259_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge8_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge8_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp263_2e_i_2e_i;
  struct l_struct_2E_b2ContactConstraint *llvm_cbe_tmp2_2e_i250_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp34_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2Manifold *llvm_cbe_tmp8_2e_i254_2e_i_2e_i;
  unsigned int *llvm_cbe_tmp41_2e_i_2e_i_2e_i949;
  unsigned long long llvm_cbe_tmp1114_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp17_2e_i259_2e_i_2e_i;
  float llvm_cbe_tmp30_2e_i265_2e_i_2e_i;
  unsigned int llvm_cbe_tmp38_2e_i_2e_i_2e_i947;
  unsigned int llvm_cbe_storemerge_2e_i267_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge_2e_i267_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp42_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp48_2e_i_2e_i_2e_i952;
  unsigned int llvm_cbe_storemerge1_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp52_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_tmp273_2e_i_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp277_2e_i_2e_i;
  unsigned short llvm_cbe_tmp3_2e_i242_2e_i_2e_i;
  float llvm_cbe_tmp288_2e_i_2e_i;
  float llvm_cbe_tmp291_2e_i_2e_i;
  float *llvm_cbe_tmp303_2e_i_2e_i;
  float llvm_cbe_tmp304_2e_i_2e_i;
  float llvm_cbe_tmp312_2e_i_2e_i;
  float llvm_cbe_tmp3_2e_i207_2e_i_2e_i;
  float llvm_cbe_tmp8_2e_i212_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp19_2e_i229_2e_i_2e_i1782__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i232_2e_i_2e_i1789__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp22_2e_i232_2e_i_2e_i178917901791_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp317_2e_i_2e_i1731__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp320_2e_i_2e_i1735__BITCAST_TEMPORARY;
  float *llvm_cbe_tmp1_2e_i178_2e_i_2e_i;
  float llvm_cbe_tmp2_2e_i179_2e_i_2e_i;
  float *llvm_cbe_tmp10_2e_i187_2e_i_2e_i;
  float llvm_cbe_tmp11_2e_i188_2e_i_2e_i;
  float llvm_cbe_tmp330_2e_i_2e_i;
  float llvm_cbe_tmp333_2e_i_2e_i;
  unsigned long long llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp342_2e_i134_2e_i;
  unsigned long long llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge9_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge9_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp346_2e_i_2e_i;
  struct l_struct_2E_b2Joint **llvm_cbe_tmp365_2e_i_2e_i;
  struct l_struct_2E_b2Joint *llvm_cbe_tmp369_2e_i_2e_i;
  unsigned int  (**llvm_cbe_tmp371_2e_i_2e_i) ();
  unsigned int  (*llvm_cbe_tmp373_2e_i_2e_i) ();
  unsigned int llvm_cbe_tmp384_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge12_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge12_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp388_2e_i_2e_i;
  unsigned char llvm_cbe_tmp398_2e_i_2e_i;
  struct l_struct_2E_b2Joint **llvm_cbe_tmp409_2e_i_2e_i;
  struct l_struct_2E_b2Joint *llvm_cbe_tmp413_2e_i_2e_i;
  unsigned int  (**llvm_cbe_tmp415_2e_i_2e_i) ();
  unsigned int  (*llvm_cbe_tmp417_2e_i_2e_i) ();
  unsigned char llvm_cbe_tmp427_2e_i_2e_i;
  unsigned char llvm_cbe_storemerge13_2e_i_2e_i;
  unsigned int llvm_cbe_tmp442_2e_i_2e_i;
  unsigned char llvm_cbe_jointsOkay_2e_i_2e_i_2e_0;
  unsigned char llvm_cbe_jointsOkay_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge14_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge14_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp446_2e_i_2e_i;
  unsigned int llvm_cbe_tmp460_2e_i_2e_i;
  unsigned int llvm_cbe_tmp461_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge;
  unsigned int llvm_cbe_storemerge__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp467_2e_i_2e_i_2e_rle;
  unsigned int llvm_cbe_tmp467_2e_i_2e_i_2e_rle__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp470_2e_i_2e_i;
  struct l_struct_2E_b2ContactConstraint *llvm_cbe_tmp476_2e_i_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_tmp485_2e_i_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp489_2e_i_2e_i;
  float llvm_cbe_tmp492_2e_i_2e_i;
  unsigned short llvm_cbe_tmp499_2e_i_2e_i;
  float llvm_cbe_minSleepTime_2e_i_2e_i_2e_0;
  float llvm_cbe_minSleepTime_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  float llvm_cbe_tmp520_2e_i_2e_i;
  float llvm_cbe_tmp3_2e_i38_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i_2e_i_2e_i957;
  float *llvm_cbe_tmp548_2e_i_2e_i;
  float llvm_cbe_tmp549_2e_i_2e_i;
  float llvm_cbe_tmp552_2e_i_2e_i;
  float llvm_cbe_tmp553_2e_i_2e_i;
  float llvm_cbe_storemerge_2e_i_2e_i_2e_i968;
  float llvm_cbe_minSleepTime_2e_i_2e_i_2e_1;
  float llvm_cbe_minSleepTime_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp563_2e_i_2e_i;
  float llvm_cbe_minSleepTime_2e_i_2e_i_2e_2;
  float llvm_cbe_minSleepTime_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge16_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge16_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp567_2e_i_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_tmp581_2e_i_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp585_2e_i_2e_i;
  unsigned short *llvm_cbe_tmp587_2e_i_2e_i;
  unsigned short llvm_cbe_tmp588_2e_i_2e_i;
  unsigned int llvm_cbe_tmp603_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge17_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge17_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp607_2e_i_2e_i;
  struct l_struct_2E_b2ContactConstraint *llvm_cbe_tmp2_2e_i23_2e_i_2e_i;
  struct l_struct_2E_b2StackAllocator *llvm_cbe_tmp5_2e_i26_2e_i_2e_i;
  unsigned int llvm_cbe_tmp297_2e_i977;
  unsigned int llvm_cbe_tmp300_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_tmp306_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp310_2e_i986;
  unsigned short llvm_cbe_tmp3_2e_i88_2e_i;
  unsigned short *llvm_cbe_tmp317_2e_i989;
  unsigned short llvm_cbe_tmp318_2e_i990;
  unsigned int llvm_cbe_tmp324_2e_i995;
  unsigned int llvm_cbe_storemerge5_2e_i996;
  unsigned int llvm_cbe_storemerge5_2e_i996__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp327_2e_i998;
  unsigned long long llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_2;
  unsigned long long llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  struct l_struct_2E_b2Body **llvm_cbe_tmp334_2e_i1002;
  unsigned long long llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_3;
  unsigned long long llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  struct l_struct_2E_b2Body **llvm_cbe_storemerge6_2e_in_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_storemerge6_2e_in_2e_i__PHI_TEMPORARY;
  struct l_struct_2E_b2Body *llvm_cbe_storemerge6_2e_i1003;
  struct l_struct_2E_Os **llvm_cbe_tmp374_2e_i1020;
  unsigned short llvm_cbe_tmp353_2e_i1012;
  unsigned short llvm_cbe_tmp3_2e_i64_2e_i;
  unsigned char llvm_cbe_tmp367_2e_i1017;
  struct l_struct_2E_Os *llvm_cbe_tmp375_2e_i1021;
  unsigned int  (**llvm_cbe_tmp387_2e_i1027) ();
  unsigned int  (*llvm_cbe_tmp389_2e_i1029) ();
  struct l_struct_2E_b2Body **llvm_cbe_tmp2_2e_i50_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_storemerge7_2e_i1036_2e_in;
  struct l_struct_2E_b2Body **llvm_cbe_storemerge7_2e_i1036_2e_in__PHI_TEMPORARY;
  struct l_struct_2E_b2Body *llvm_cbe_storemerge7_2e_i1036;
  struct l_struct_2E_b2BroadPhase *llvm_cbe_tmp407_2e_i1039;
  struct l_struct_2E_b2Joint **llvm_cbe_tmp2_2e_i30_2e_i;
  struct l_struct_2E_b2StackAllocator *llvm_cbe_tmp5_2e_i33_2e_i;
  struct l_struct_2E_b2Contact **llvm_cbe_tmp9_2e_i37_2e_i;
  struct l_struct_2E_b2StackAllocator *llvm_cbe_tmp12_2e_i40_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_tmp16_2e_i44_2e_i;
  struct l_struct_2E_b2StackAllocator *llvm_cbe_tmp19_2e_i47_2e_i;
  unsigned char llvm_cbe_tmp41;
  float llvm_cbe_tmp45;
  struct l_struct_2E_Os **llvm_cbe_tmp11_2e_i49;
  struct l_struct_2E_Os *llvm_cbe_tmp12_2e_i;
  struct l_struct_2E_b2StackAllocator *llvm_cbe_tmp14_2e_i;
  unsigned int *llvm_cbe_tmp16_2e_i50;
  unsigned int llvm_cbe_tmp17_2e_i51;
  unsigned int *llvm_cbe_tmp1_2e_i_2e_i53;
  unsigned int *llvm_cbe_tmp4_2e_i_2e_i56;
  unsigned int *llvm_cbe_tmp10_2e_i_2e_i62;
  unsigned int *llvm_cbe_tmp12_2e_i_2e_i64;
  unsigned int *llvm_cbe_tmp14_2e_i_2e_i66;
  struct l_struct_2E_b2StackAllocator **llvm_cbe_tmp16_2e_i_2e_i68;
  unsigned char *llvm_cbe_tmp28_2e_i_2e_i77;
  struct l_struct_2E_b2Body ***llvm_cbe_tmp31_2e_i_2e_i79;
  struct l_struct_2E_b2StackAllocator *llvm_cbe_tmp38_2e_i_2e_i83;
  unsigned char *llvm_cbe_tmp39_2e_i_2e_i84;
  struct l_struct_2E_b2Contact ***llvm_cbe_tmp42_2e_i_2e_i86;
  struct l_struct_2E_b2StackAllocator *llvm_cbe_tmp49_2e_i_2e_i89;
  unsigned char *llvm_cbe_tmp50_2e_i_2e_i;
  struct l_struct_2E_b2Joint ***llvm_cbe_tmp53_2e_i_2e_i91;
  unsigned int llvm_cbe_tmp20_2e_i96;
  unsigned char *llvm_cbe_tmp27_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_tmp2728_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_tmp30_2e_i100;
  unsigned short *llvm_cbe_tmp33_2e_i102;
  unsigned short llvm_cbe_tmp34_2e_i103;
  struct l_struct_2E_b2Body **llvm_cbe_tmp42_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_storemerge_2e_in_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_storemerge_2e_in_2e_i__PHI_TEMPORARY;
  struct l_struct_2E_b2Body *llvm_cbe_storemerge_2e_i111;
  struct l_struct_2E_b2Contact **llvm_cbe_tmp50_2e_i;
  unsigned int *llvm_cbe_tmp54_2e_i;
  unsigned int llvm_cbe_tmp55_2e_i;
  struct l_struct_2E_b2Contact **llvm_cbe_tmp60_2e_i114;
  struct l_struct_2E_b2Contact **llvm_cbe_storemerge1_2e_in_2e_i;
  struct l_struct_2E_b2Contact **llvm_cbe_storemerge1_2e_in_2e_i__PHI_TEMPORARY;
  struct l_struct_2E_b2Contact *llvm_cbe_storemerge1_2e_i115;
  float *llvm_cbe_tmp77_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp80_2e_i68_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp95_2e_i79_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp98_2e_i82_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2Vec2 *llvm_cbe_tmp21_2e_i_2e_i_2e_i_2e_i174;
  struct l_struct_2E_b2Vec2 *llvm_cbe_tmp34_2e_i_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2Vec2 *llvm_cbe_tmp49_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp91_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp94_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp109_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp112_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp128_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp131_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp182_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp185_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp189_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp192_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp196_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp199_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp234_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp237_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp241_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp244_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp248_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp251_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp262_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp265_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp269_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp272_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp276_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp279_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp455_2e_i;
  float *llvm_cbe_tmp469_2e_i;
  unsigned int *llvm_cbe_tmp473_2e_i332;
  struct l_struct_2E_b2ContactConstraint **llvm_cbe_tmp124_2e_i_2e_i;
  struct l_struct_2E_b2StackAllocator **llvm_cbe_tmp4_2e_i11_2e_i_2e_i;
  struct l_struct_2E_Os **llvm_cbe_tmp511_2e_i429;
  struct l_struct_2E_b2BroadPhase **llvm_cbe_tmp591_2e_i456;
  unsigned long long llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_5;
  unsigned long long llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_5;
  unsigned long long llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_6;
  unsigned long long llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_6;
  unsigned long long llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_6;
  unsigned long long llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_5;
  unsigned long long llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_6;
  unsigned long long llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_6;
  unsigned long long llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_6;
  unsigned long long llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_6;
  unsigned long long llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_5;
  unsigned long long llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_5;
  unsigned long long llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_6;
  unsigned long long llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_6;
  unsigned long long llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_6;
  unsigned long long llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  unsigned int *llvm_cbe_tmp73_2e_i;
  unsigned int llvm_cbe_tmp74_2e_i118;
  float llvm_cbe_tmp90_2e_i123;
  struct l_struct_2E_b2Shape **llvm_cbe_tmp2_2e_i51_2e_i;
  struct l_struct_2E_b2Shape *llvm_cbe_tmp3_2e_i52_2e_i;
  struct l_struct_2E_b2Shape **llvm_cbe_tmp2_2e_i54_2e_i;
  struct l_struct_2E_b2Shape *llvm_cbe_tmp3_2e_i55_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp3_2e_i207_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp3_2e_i279_2e_i;
  unsigned short llvm_cbe_tmp3_2e_i410_2e_i;
  unsigned short llvm_cbe_tmp3_2e_i417_2e_i;
  unsigned short llvm_cbe_tmp3_2e_i430_2e_i;
  unsigned short llvm_cbe_tmp3_2e_i422_2e_i;
  float llvm_cbe_tmp125_2e_i;
  float llvm_cbe_tmp133_2e_i139;
  float llvm_cbe_t0_2e_i_2e_0;
  float llvm_cbe_t0_2e_i_2e_0__PHI_TEMPORARY;
  struct l_struct_2E_b2Sweep *llvm_cbe_tmp178_2e_i;
  struct l_struct_2E_b2Shape *llvm_cbe_tmp181_2e_i;
  struct l_struct_2E_b2Sweep *llvm_cbe_tmp183_2e_i155;
  struct l_struct_2E_b2Shape *llvm_cbe_tmp186_2e_i;
  float llvm_cbe_tmp3_2e_i_2e_i307_2e_i;
  float llvm_cbe_tmp3_2e_i205_2e_i_2e_i;
  float llvm_cbe_tmp12_2e_i311_2e_i;
  float llvm_cbe_tmp15_2e_i314_2e_i;
  float llvm_cbe_tmp3_2e_i219_2e_i_2e_i;
  float llvm_cbe_tmp6_2e_i222_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i226_2e_i_2e_i;
  float llvm_cbe_tmp13_2e_i229_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i245_2e_i_2e_i1684__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i248_2e_i_2e_i1691__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i248_2e_i_2e_i169116921693_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp45_2e_i328_2e_i1311__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp48_2e_i331_2e_i1315__BITCAST_TEMPORARY;
  float llvm_cbe_tmp3_2e_i284_2e_i_2e_i;
  float llvm_cbe_tmp6_2e_i287_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i291_2e_i_2e_i;
  float llvm_cbe_tmp13_2e_i294_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i310_2e_i_2e_i1698__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i313_2e_i_2e_i1705__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i313_2e_i_2e_i170517061707_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp57_2e_i_2e_i1621318__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp60_2e_i340_2e_i1322__BITCAST_TEMPORARY;
  float llvm_cbe_tmp63_2e_i342_2e_i;
  float llvm_cbe_tmp66_2e_i345_2e_i;
  float llvm_cbe_tmp67_2e_i346_2e_i;
  float llvm_cbe_tmp70_2e_i347_2e_i;
  float llvm_cbe_tmp73_2e_i350_2e_i;
  float llvm_cbe_tmp74_2e_i351_2e_i;
  unsigned int *llvm_cbe_tmp2_2e_i_2e_i185_2e_i_2e_i;
  unsigned int *llvm_cbe_tmp2_2e_i5_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2CircleShape *llvm_cbe_tmp1314_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2CircleShape *llvm_cbe_tmp1516_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2Vec2 *llvm_cbe_tmp2_2e_i_2e_i38_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2Vec2 *llvm_cbe_tmp2_2e_i472_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp2_2e_i401_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp2_2e_i398_2e_i_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i_2e_i389_2e_i1341__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp23_2e_i_2e_i389_2e_i13411342;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i_2e_i392_2e_i1348__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i_2e_i392_2e_i134813491350;
  float llvm_cbe_tmp5_2e_i46_2e_i_2e_i;
  float llvm_cbe_tmp5_2e_i35_2e_i_2e_i;
  struct l_struct_2E_b2PolygonShape *llvm_cbe_tmp3536_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2PolygonShape *llvm_cbe_tmp5556_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2Vec2 *llvm_cbe_tmp4_2e_i110_2e_i_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2Vec2 *llvm_cbe_tmp4_2e_i227_2e_i_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  float llvm_cbe_targetDistance_2e_i_2e_i_2e_1;
  float llvm_cbe_targetDistance_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_iter_2e_i_2e_i_2e_0;
  unsigned int llvm_cbe_iter_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  float llvm_cbe_alpha_2e_i_2e_i_2e_1;
  float llvm_cbe_alpha_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  float llvm_cbe_tmp87_2e_i359_2e_i;
  unsigned int llvm_cbe_tmp3_2e_i_2e_i186_2e_i_2e_i;
  unsigned int llvm_cbe_tmp3_2e_i6_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp18_2e_i39_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp22_2e_i_2e_i_2e_i_2e_i1681521;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i_2e_i_2e_i_2e_i1681521__BITCAST_TEMPORARY;
  float llvm_cbe_tmp25_2e_i43_2e_i_2e_i_2e_i1525;
  llvmBitCastUnion llvm_cbe_tmp25_2e_i43_2e_i_2e_i_2e_i1525__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp29_2e_i_2e_i_2e_i_2e_i170;
  float llvm_cbe_tmp33_2e_i_2e_i_2e_i_2e_i1528;
  llvmBitCastUnion llvm_cbe_tmp33_2e_i_2e_i_2e_i_2e_i1528__BITCAST_TEMPORARY;
  float llvm_cbe_tmp36_2e_i_2e_i_2e_i_2e_i1532;
  llvmBitCastUnion llvm_cbe_tmp36_2e_i_2e_i_2e_i_2e_i1532__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i460_2e_i_2e_i_2e_i_2e_i1670__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i463_2e_i_2e_i_2e_i_2e_i1677__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i463_2e_i_2e_i_2e_i_2e_i167716781679_2e_ins;
  float llvm_cbe_tmp41_2e_i48_2e_i_2e_i_2e_i1535;
  llvmBitCastUnion llvm_cbe_tmp41_2e_i48_2e_i_2e_i_2e_i1535__BITCAST_TEMPORARY;
  float llvm_cbe_tmp44_2e_i49_2e_i_2e_i_2e_i1539;
  llvmBitCastUnion llvm_cbe_tmp44_2e_i49_2e_i_2e_i_2e_i1539__BITCAST_TEMPORARY;
  float llvm_cbe_tmp15_2e_i421_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp3_2e_i402_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp48_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp3_2e_i399_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp51_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp54_2e_i54_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp16_2e_i_2e_i372_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp8_2e_i377_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp13_2e_i382_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp20_2e_i389_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_0_2e_0;
  float llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_0_2e_0__PHI_TEMPORARY;
  float llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_1_2e_0;
  float llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_1_2e_0__PHI_TEMPORARY;
  float llvm_cbe_storemerge_2e_i394_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_storemerge_2e_i394_2e_i_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  float llvm_cbe_tmp64_2e_i58_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp19_2e_i341_2e_i_2e_i_2e_i_2e_i1656__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i344_2e_i_2e_i_2e_i_2e_i1663__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp22_2e_i344_2e_i_2e_i_2e_i_2e_i166316641665_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp70_2e_i62_2e_i_2e_i_2e_i1542__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp73_2e_i65_2e_i_2e_i_2e_i1546__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i296_2e_i_2e_i_2e_i_2e_i1642__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i299_2e_i_2e_i_2e_i_2e_i1649__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i299_2e_i_2e_i_2e_i_2e_i164916501651_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp79_2e_i67_2e_i_2e_i_2e_i1549__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp82_2e_i70_2e_i_2e_i_2e_i1553__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp19_2e_i247_2e_i_2e_i_2e_i_2e_i1628__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i250_2e_i_2e_i_2e_i_2e_i1635__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp22_2e_i250_2e_i_2e_i_2e_i_2e_i163516361637_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp88_2e_i76_2e_i_2e_i_2e_i1556__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp91_2e_i77_2e_i_2e_i_2e_i1560__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i202_2e_i_2e_i_2e_i_2e_i1614__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i205_2e_i_2e_i_2e_i_2e_i1621__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i205_2e_i_2e_i_2e_i_2e_i162116221623_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp97_2e_i81_2e_i_2e_i_2e_i1563__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp100_2e_i_2e_i_2e_i_2e_i1567__BITCAST_TEMPORARY;
  float llvm_cbe_tmp16_2e_i_2e_i_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp8_2e_i148_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp13_2e_i153_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp20_2e_i160_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_0_2e_1;
  float llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_0_2e_1__PHI_TEMPORARY;
  float llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_1_2e_1;
  float llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_1_2e_1__PHI_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp19_2e_i130_2e_i_2e_i_2e_i_2e_i1600__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i133_2e_i_2e_i_2e_i_2e_i1607__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp22_2e_i133_2e_i_2e_i_2e_i_2e_i160716081609_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp114_2e_i96_2e_i_2e_i_2e_i1570__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp117_2e_i99_2e_i_2e_i_2e_i1574__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i_2e_i128_2e_i_2e_i_2e_i1586__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i_2e_i131_2e_i_2e_i_2e_i1593__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i_2e_i131_2e_i_2e_i_2e_i159315941595_2e_ins;
  float llvm_cbe_tmp123_2e_i142_2e_i_2e_i_2e_i1577;
  llvmBitCastUnion llvm_cbe_tmp123_2e_i142_2e_i_2e_i_2e_i1577__BITCAST_TEMPORARY;
  float llvm_cbe_tmp126_2e_i_2e_i_2e_i_2e_i1581;
  llvmBitCastUnion llvm_cbe_tmp126_2e_i_2e_i_2e_i_2e_i1581__BITCAST_TEMPORARY;
  float llvm_cbe_tmp41_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp61_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp18_2e_i_2e_i_2e_i_2e_i25_2e_0;
  unsigned long long llvm_cbe_tmp18_2e_i_2e_i_2e_i_2e_i25_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp27_2e_i_2e_i_2e_i_2e_i179;
  unsigned long long llvm_cbe_tmp15_2e_i_2e_i179_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_tmp15_2e_i_2e_i179_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp41_2e_i_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp12_2e_i_2e_i177_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_tmp12_2e_i_2e_i177_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp56_2e_i_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp6_2e_i112_2e_i_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp71_2e_i_2e_i_2e_i_2e_i1367__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp74_2e_i_2e_i_2e_i_2e_i1371__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp6_2e_i229_2e_i_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp82_2e_i_2e_i_2e_i_2e_i1374__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp85_2e_i_2e_i_2e_i_2e_i1378__BITCAST_TEMPORARY;
  unsigned int llvm_cbe_iter_2e_i_2e_i_2e_i_2e_i_2e_0;
  unsigned int llvm_cbe_iter_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_1;
  unsigned int llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  float llvm_cbe_tmp3_2e_i302_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp6_2e_i305_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i309_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp13_2e_i312_2e_i_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i328_2e_i_2e_i_2e_i_2e_i1509__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i331_2e_i_2e_i_2e_i_2e_i1516__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i331_2e_i_2e_i_2e_i_2e_i151615171518_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp93_2e_i_2e_i_2e_i_2e_i1381__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp96_2e_i_2e_i_2e_i_2e_i1385__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp99_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp103_2e_i_2e_i_2e_i_2e_i1388;
  llvmBitCastUnion llvm_cbe_tmp103_2e_i_2e_i_2e_i_2e_i1388__BITCAST_TEMPORARY;
  float llvm_cbe_tmp106_2e_i_2e_i_2e_i_2e_i1392;
  llvmBitCastUnion llvm_cbe_tmp106_2e_i_2e_i_2e_i_2e_i1392__BITCAST_TEMPORARY;
  float llvm_cbe_tmp3_2e_i260_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp7_2e_i264_2e_i_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp17_2e_i280_2e_i_2e_i_2e_i_2e_i1495__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp20_2e_i283_2e_i_2e_i_2e_i_2e_i1502__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp20_2e_i283_2e_i_2e_i_2e_i_2e_i150215031504_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp111_2e_i_2e_i_2e_i_2e_i1395__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp114_2e_i_2e_i_2e_i_2e_i1399__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp117_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp121_2e_i_2e_i_2e_i_2e_i1402;
  llvmBitCastUnion llvm_cbe_tmp121_2e_i_2e_i_2e_i_2e_i1402__BITCAST_TEMPORARY;
  float llvm_cbe_tmp124_2e_i_2e_i_2e_i_2e_i1406;
  llvmBitCastUnion llvm_cbe_tmp124_2e_i_2e_i_2e_i_2e_i1406__BITCAST_TEMPORARY;
  float llvm_cbe_tmp3_2e_i204_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i211_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp15_2e_i216_2e_i_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i188_2e_i_2e_i_2e_i_2e_i1460__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i191_2e_i_2e_i_2e_i_2e_i1467__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i191_2e_i_2e_i_2e_i_2e_i146714681469_2e_ins;
  float llvm_cbe_tmp130_2e_i_2e_i_2e_i_2e_i1409;
  llvmBitCastUnion llvm_cbe_tmp130_2e_i_2e_i_2e_i_2e_i1409__BITCAST_TEMPORARY;
  float llvm_cbe_tmp133_2e_i_2e_i_2e_i_2e_i1413;
  llvmBitCastUnion llvm_cbe_tmp133_2e_i_2e_i_2e_i_2e_i1413__BITCAST_TEMPORARY;
  unsigned char llvm_cbe_tmp146_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp177_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp198_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp201_2e_i_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp231_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp250_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp253_2e_i_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp259_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp278_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp281_2e_i_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp287_2e_i_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_0;
  unsigned int llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp297298_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp3_2e_i90_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i97_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp15_2e_i102_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_storemerge_2e_i_2e_i_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp307_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_maxSqr_2e_i_2e_i_2e_i_2e_i_2e_0;
  float llvm_cbe_maxSqr_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge4_2e_i_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge4_2e_i_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  float llvm_cbe_tmp3_2e_i64_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp6_2e_i67_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i71_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp13_2e_i74_2e_i_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i_2e_i_2e_i_2e_i_2e_i1425__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i_2e_i_2e_i_2e_i_2e_i1432__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i_2e_i_2e_i_2e_i_2e_i143214331434_2e_ins;
  float llvm_cbe_tmp334_2e_i_2e_i_2e_i_2e_i1416;
  llvmBitCastUnion llvm_cbe_tmp334_2e_i_2e_i_2e_i_2e_i1416__BITCAST_TEMPORARY;
  float llvm_cbe_tmp337_2e_i_2e_i_2e_i_2e_i1420;
  llvmBitCastUnion llvm_cbe_tmp337_2e_i_2e_i_2e_i_2e_i1420__BITCAST_TEMPORARY;
  float llvm_cbe_tmp340_2e_i_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp343_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp351_2e_i_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  float llvm_cbe_tmp_2e_i183_2e_i_2e_i_2e_0;
  float llvm_cbe_tmp_2e_i183_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  float llvm_cbe_tmp107_2e_i_2e_i188;
  float llvm_cbe_storemerge_2e_i164_2e_i_2e_i;
  float llvm_cbe_targetDistance_2e_i_2e_i_2e_0;
  float llvm_cbe_targetDistance_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  float llvm_cbe_tmp112_2e_i_2e_i;
  float llvm_cbe_tmp3_2e_i117_2e_i_2e_i;
  float llvm_cbe_tmp6_2e_i120_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i124_2e_i_2e_i;
  float llvm_cbe_tmp13_2e_i127_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i143_2e_i_2e_i1355__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i146_2e_i_2e_i1362__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i146_2e_i_2e_i136213631364_2e_ins;
  float llvm_cbe_tmp127_2e_i_2e_i1891325;
  llvmBitCastUnion llvm_cbe_tmp127_2e_i_2e_i1891325__BITCAST_TEMPORARY;
  float llvm_cbe_tmp130_2e_i374_2e_i1329;
  llvmBitCastUnion llvm_cbe_tmp130_2e_i374_2e_i1329__BITCAST_TEMPORARY;
  float llvm_cbe_tmp16_2e_i_2e_i_2e_i_2e_i201;
  float llvm_cbe_tmp8_2e_i87_2e_i_2e_i;
  float llvm_cbe_tmp13_2e_i92_2e_i_2e_i;
  float llvm_cbe_tmp20_2e_i99_2e_i_2e_i;
  float llvm_cbe_normal_2e_i_2e_i_2e_0_2e_0;
  float llvm_cbe_normal_2e_i_2e_i_2e_0_2e_0__PHI_TEMPORARY;
  float llvm_cbe_normal_2e_i_2e_i_2e_1_2e_0;
  float llvm_cbe_normal_2e_i_2e_i_2e_1_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i_2e_i392_2e_i134813491350_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp136_2e_i_2e_i2041332__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp139_2e_i_2e_i1336__BITCAST_TEMPORARY;
  float llvm_cbe_tmp150_2e_i_2e_i212;
  float llvm_cbe_tmp5_2e_i_2e_i406_2e_i;
  float llvm_cbe_storemerge_2e_i_2e_i_2e_i;
  float llvm_cbe_storemerge_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  float llvm_cbe_tmp166_2e_i_2e_i220;
  unsigned int llvm_cbe_tmp187_2e_i_2e_i228;
  unsigned long long llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  float llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2165;
  float llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2164;
  float llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2163;
  float llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2160;
  float llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2162;
  float llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2161;
  float llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2159;
  float llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload;
  float llvm_cbe_tmp218_2e_i;
  float llvm_cbe_storemerge_2e_i288_2e_i;
  float llvm_cbe_toi_2e_i_2e_1;
  float llvm_cbe_toi_2e_i_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp226_2e_i238;
  unsigned long long llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_1_2e_reload;
  unsigned long long llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_1_2e_reload;
  unsigned long long llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  float llvm_cbe_toi_2e_i_2e_0;
  float llvm_cbe_toi_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  float llvm_cbe_minTOI_2e_i_2e_0;
  float llvm_cbe_minTOI_2e_i_2e_0__PHI_TEMPORARY;
  struct l_struct_2E_b2Contact *llvm_cbe_minContact_2e_i_2e_0;
  struct l_struct_2E_b2Contact *llvm_cbe_minContact_2e_i_2e_0__PHI_TEMPORARY;
  struct l_struct_2E_b2Contact **llvm_cbe_tmp246_2e_i;
  unsigned long long llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_5;
  unsigned long long llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_5;
  unsigned long long llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_5;
  unsigned long long llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_5;
  unsigned long long llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_5;
  unsigned long long llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_5;
  unsigned long long llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_5;
  unsigned long long llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_4;
  unsigned long long llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_5;
  unsigned long long llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_5;
  unsigned long long llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_5;
  unsigned long long llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  float llvm_cbe_minTOI_2e_i_2e_1;
  float llvm_cbe_minTOI_2e_i_2e_1__PHI_TEMPORARY;
  struct l_struct_2E_b2Contact *llvm_cbe_minContact_2e_i_2e_1;
  struct l_struct_2E_b2Contact *llvm_cbe_minContact_2e_i_2e_1__PHI_TEMPORARY;
  struct l_struct_2E_b2Contact **llvm_cbe_storemerge3_2e_in_2e_i;
  struct l_struct_2E_b2Contact **llvm_cbe_storemerge3_2e_in_2e_i__PHI_TEMPORARY;
  struct l_struct_2E_b2Contact *llvm_cbe_storemerge3_2e_i;
  struct l_struct_2E_b2Shape *llvm_cbe_tmp3_2e_i275_2e_i;
  struct l_struct_2E_b2Shape *llvm_cbe_tmp3_2e_i271_2e_i253;
  struct l_struct_2E_b2Body *llvm_cbe_tmp3_2e_i267_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp3_2e_i263_2e_i;
  float llvm_cbe_tmp9_2e_i244_2e_i;
  float llvm_cbe_tmp12_2e_i247_2e_i;
  float llvm_cbe_tmp25_2e_i257_2e_i;
  float llvm_cbe_tmp9_2e_i218_2e_i;
  float llvm_cbe_tmp12_2e_i221_2e_i;
  float llvm_cbe_tmp25_2e_i231_2e_i;
  struct l_struct_2E_Os *llvm_cbe_tmp286_2e_i;
  unsigned int *llvm_cbe_tmp290_2e_i259;
  unsigned int llvm_cbe_tmp291_2e_i260;
  unsigned int llvm_cbe_tmp3_2e_i203_2e_i;
  unsigned short llvm_cbe_tmp3_2e_i196_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_seed_2e_i_2e_0;
  unsigned short *llvm_cbe_tmp318_2e_i;
  unsigned short llvm_cbe_tmp319_2e_i269;
  unsigned int llvm_cbe_stackCount_2e_i_2e_0_2e_reload;
  unsigned int llvm_cbe_tmp325_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp330_2e_i275;
  unsigned int llvm_cbe_tmp2_2e_i170_2e_i;
  unsigned int llvm_cbe_tmp5_2e_i173_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_tmp14_2e_i178_2e_i;
  unsigned short *llvm_cbe_tmp333_2e_i277;
  unsigned short llvm_cbe_tmp334_2e_i;
  unsigned short llvm_cbe_tmp3_2e_i162_2e_i;
  struct l_struct_2E_b2ContactEdge **llvm_cbe_tmp344_2e_i279;
  unsigned int llvm_cbe_tmp348_2e_i281;
  unsigned int llvm_cbe_tmp350_2e_i;
  struct l_struct_2E_b2Contact **llvm_cbe_tmp356_2e_i;
  struct l_struct_2E_b2Contact *llvm_cbe_tmp357_2e_i284;
  unsigned int llvm_cbe_tmp359_2e_i;
  unsigned int llvm_cbe_tmp3_2e_i158_2e_i;
  struct l_struct_2E_b2Contact **llvm_cbe_tmp14_2e_i148_2e_i;
  struct l_struct_2E_b2Contact *llvm_cbe_tmp379_2e_i294;
  unsigned int *llvm_cbe_tmp383_2e_i297;
  unsigned int llvm_cbe_tmp384_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp389_2e_i;
  unsigned short *llvm_cbe_tmp391_2e_i299;
  unsigned short llvm_cbe_tmp392_2e_i;
  unsigned short llvm_cbe_tmp3_2e_i132_2e_i;
  float llvm_cbe_tmp9_2e_i114_2e_i;
  float llvm_cbe_tmp12_2e_i117_2e_i;
  float llvm_cbe_tmp25_2e_i126_2e_i;
  unsigned short llvm_cbe_tmp2_2e_i100_2e_i306;
  unsigned int llvm_cbe_tmp427_2e_i;
  unsigned short llvm_cbe_tmp430_2e_i317;
  unsigned int llvm_cbe_stackCount_2e_i_2e_1;
  unsigned int llvm_cbe_stackCount_2e_i_2e_1__PHI_TEMPORARY;
  struct l_struct_2E_b2ContactEdge **llvm_cbe_tmp436_2e_i;
  unsigned int llvm_cbe_stackCount_2e_i_2e_2;
  unsigned int llvm_cbe_stackCount_2e_i_2e_2__PHI_TEMPORARY;
  struct l_struct_2E_b2ContactEdge **llvm_cbe_storemerge4_2e_in_2e_i;
  struct l_struct_2E_b2ContactEdge **llvm_cbe_storemerge4_2e_in_2e_i__PHI_TEMPORARY;
  struct l_struct_2E_b2ContactEdge *llvm_cbe_storemerge4_2e_i;
  unsigned int llvm_cbe_stackCount_2e_i_2e_0_2e_be;
  unsigned int llvm_cbe_stackCount_2e_i_2e_0_2e_be__PHI_TEMPORARY;
  float llvm_cbe_tmp453_2e_i325;
  float llvm_cbe_tmp454_2e_i;
  unsigned int llvm_cbe_tmp472_2e_i331;
  struct l_struct_2E_b2StackAllocator *llvm_cbe_tmp7_2e_i67_2e_i;
  unsigned int llvm_cbe_tmp10_2e_i70_2e_i;
  struct l_struct_2E_b2Contact **llvm_cbe_tmp13_2e_i73_2e_i;
  unsigned int llvm_cbe_tmp16_2e_i76_2e_i;
  unsigned int llvm_cbe_storemerge_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp20_2e_i79_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_tmp28_2e_i83_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp32_2e_i85_2e_i;
  unsigned short llvm_cbe_tmp3_2e_i_2e_i_2e_i338;
  float llvm_cbe_tmp43_2e_i89_2e_i;
  float llvm_cbe_tmp46_2e_i_2e_i341;
  float *llvm_cbe_tmp58_2e_i_2e_i344;
  float llvm_cbe_tmp59_2e_i_2e_i345;
  float llvm_cbe_tmp67_2e_i_2e_i350;
  float llvm_cbe_tmp3_2e_i17_2e_i_2e_i;
  float llvm_cbe_tmp8_2e_i_2e_i_2e_i354;
  llvmBitCastUnion llvm_cbe_tmp19_2e_i_2e_i_2e_i3691299__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i_2e_i_2e_i3721306__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp22_2e_i_2e_i_2e_i372130613071308_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp72_2e_i_2e_i3811290__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp75_2e_i_2e_i1294__BITCAST_TEMPORARY;
  float *llvm_cbe_tmp1_2e_i23_2e_i_2e_i;
  float llvm_cbe_tmp2_2e_i24_2e_i_2e_i;
  float *llvm_cbe_tmp10_2e_i32_2e_i_2e_i;
  float llvm_cbe_tmp11_2e_i33_2e_i_2e_i;
  float llvm_cbe_tmp85_2e_i_2e_i388;
  float llvm_cbe_tmp88_2e_i_2e_i;
  unsigned long long llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp97_2e_i_2e_i393;
  unsigned long long llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge1_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp101_2e_i_2e_i396;
  unsigned char llvm_cbe_tmp109_2e_i_2e_i397;
  unsigned int llvm_cbe_tmp114_2e_i_2e_i399;
  unsigned int llvm_cbe_storemerge3_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge3_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp118_2e_i_2e_i402;
  struct l_struct_2E_b2ContactConstraint *llvm_cbe_tmp125_2e_i_2e_i;
  struct l_struct_2E_b2ContactConstraint *llvm_cbe_tmp2_2e_i9_2e_i_2e_i;
  struct l_struct_2E_b2StackAllocator *llvm_cbe_tmp5_2e_i12_2e_i_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_tmp477_2e_i410;
  struct l_struct_2E_b2Body *llvm_cbe_tmp481_2e_i413;
  unsigned short *llvm_cbe_tmp483_2e_i414;
  unsigned short llvm_cbe_tmp484_2e_i415;
  unsigned short llvm_cbe_tmp485_2e_i416;
  unsigned short llvm_cbe_tmp3_2e_i59_2e_i;
  unsigned char llvm_cbe_tmp504_2e_i428;
  struct l_struct_2E_Os *llvm_cbe_tmp512_2e_i430;
  unsigned int  (**llvm_cbe_tmp524_2e_i) ();
  unsigned int  (*llvm_cbe_tmp526_2e_i) ();
  struct l_struct_2E_b2ContactEdge **llvm_cbe_tmp535_2e_i437;
  struct l_struct_2E_b2Contact *llvm_cbe_tmp540_2e_i;
  unsigned int *llvm_cbe_tmp544_2e_i;
  unsigned int llvm_cbe_tmp545_2e_i;
  struct l_struct_2E_b2ContactEdge **llvm_cbe_tmp549_2e_i442;
  struct l_struct_2E_b2ContactEdge **llvm_cbe_storemerge5_2e_in_2e_i;
  struct l_struct_2E_b2ContactEdge **llvm_cbe_storemerge5_2e_in_2e_i__PHI_TEMPORARY;
  struct l_struct_2E_b2ContactEdge *llvm_cbe_storemerge5_2e_i;
  unsigned int llvm_cbe_tmp558_2e_i;
  unsigned int llvm_cbe_storemerge6_2e_i;
  unsigned int llvm_cbe_storemerge6_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp561_2e_i;
  struct l_struct_2E_b2Contact **llvm_cbe_tmp569_2e_i446;
  struct l_struct_2E_b2Contact *llvm_cbe_tmp573_2e_i448;
  unsigned int *llvm_cbe_tmp575_2e_i449;
  unsigned int llvm_cbe_tmp576_2e_i450;
  unsigned int llvm_cbe_tmp581_2e_i453;
  unsigned int llvm_cbe_storemerge7_2e_i;
  unsigned int llvm_cbe_storemerge7_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp584_2e_i;
  struct l_struct_2E_b2BroadPhase *llvm_cbe_tmp592_2e_i;
  struct l_struct_2E_b2Joint **llvm_cbe_tmp2_2e_i31_2e_i;
  struct l_struct_2E_b2StackAllocator *llvm_cbe_tmp5_2e_i34_2e_i;
  struct l_struct_2E_b2Contact **llvm_cbe_tmp9_2e_i38_2e_i;
  struct l_struct_2E_b2StackAllocator *llvm_cbe_tmp12_2e_i41_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_tmp16_2e_i45_2e_i;
  struct l_struct_2E_b2StackAllocator *llvm_cbe_tmp19_2e_i48_2e_i;
  struct l_struct_2E_b2DebugDraw **llvm_cbe_tmp43_2e_i;
  struct l_struct_2E_b2DebugDraw *llvm_cbe_tmp44_2e_i;
  unsigned int llvm_cbe_tmp3_2e_i_2e_i12;
  unsigned char llvm_cbe_tmp5859_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_tmp61_2e_i;
  float *llvm_cbe_tmp1_2e_i112_2e_i;
  float *llvm_cbe_tmp4_2e_i115_2e_i;
  float *llvm_cbe_tmp7_2e_i118_2e_i;
  float *llvm_cbe_tmp1_2e_i321_2e_i;
  float *llvm_cbe_tmp4_2e_i324_2e_i;
  float *llvm_cbe_tmp7_2e_i327_2e_i;
  float *llvm_cbe_tmp1_2e_i239_2e_i;
  float *llvm_cbe_tmp4_2e_i242_2e_i;
  float *llvm_cbe_tmp7_2e_i245_2e_i;
  struct l_struct_2E_b2XForm *llvm_cbe_tmp2_2e_i84_2e_i;
  struct l_struct_2E_b2Shape **llvm_cbe_tmp2_2e_i100_2e_i;
  unsigned short *llvm_cbe_tmp2_2e_i104_2e_i;
  unsigned short *llvm_cbe_tmp2_2e_i182_2e_i;
  unsigned short llvm_cbe_tmp3_2e_i105_2e_i;
  unsigned short llvm_cbe_tmp3_2e_i183_2e_i;
  struct l_struct_2E_b2Shape **llvm_cbe_tmp2_2e_i594_2e_i;
  struct l_struct_2E_b2Shape **llvm_cbe_storemerge_2e_i19_2e_in;
  struct l_struct_2E_b2Shape **llvm_cbe_storemerge_2e_i19_2e_in__PHI_TEMPORARY;
  struct l_struct_2E_b2Shape *llvm_cbe_storemerge_2e_i19;
  struct l_struct_2E_b2Body **llvm_cbe_tmp2_2e_i590_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_storemerge1_2e_i20_2e_in;
  struct l_struct_2E_b2Body **llvm_cbe_storemerge1_2e_i20_2e_in__PHI_TEMPORARY;
  struct l_struct_2E_b2Body *llvm_cbe_storemerge1_2e_i20;
  struct l_struct_2E_b2Joint **llvm_cbe_tmp123_2e_i;
  float *llvm_cbe_tmp22_2e_i569_2e_i;
  float *llvm_cbe_tmp25_2e_i572_2e_i;
  float *llvm_cbe_tmp36_2e_i_2e_i;
  float *llvm_cbe_tmp39_2e_i_2e_i;
  float *llvm_cbe_tmp51_2e_i_2e_i;
  float *llvm_cbe_tmp54_2e_i_2e_i;
  float *llvm_cbe_tmp66_2e_i_2e_i;
  float *llvm_cbe_tmp69_2e_i_2e_i;
  float *llvm_cbe_tmp1_2e_i_2e_i581_2e_i;
  float *llvm_cbe_tmp4_2e_i_2e_i582_2e_i;
  float *llvm_cbe_tmp7_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp95_2e_i_2e_i;
  float *llvm_cbe_tmp98_2e_i_2e_i;
  float *llvm_cbe_tmp104_2e_i_2e_i;
  float *llvm_cbe_tmp107_2e_i_2e_i;
  unsigned int *llvm_cbe_tmp2_2e_i586_2e_i;
  unsigned int llvm_cbe_tmp3_2e_i587_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp3_2e_i_2e_i558_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp3_2e_i69_2e_i_2e_i;
  float llvm_cbe_tmp18_2e_i565_2e_i;
  float llvm_cbe_tmp21_2e_i568_2e_i;
  float llvm_cbe_tmp32_2e_i578_2e_i;
  float llvm_cbe_tmp35_2e_i_2e_i;
  unsigned int  (***llvm_cbe_tmp43_2e_i_2e_i) ();
  unsigned int  (**llvm_cbe_tmp44_2e_i_2e_i) ();
  unsigned int  (*llvm_cbe_tmp46_2e_i_2e_i) ();
  unsigned long long llvm_cbe_tmp49_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp53_2e_i_2e_i1192__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp56_2e_i_2e_i1196__BITCAST_TEMPORARY;
  unsigned int  (**llvm_cbe_tmp59_2e_i_2e_i) ();
  unsigned int  (*llvm_cbe_tmp61_2e_i_2e_i) ();
  unsigned long long llvm_cbe_tmp64_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp68_2e_i_2e_i1199__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp71_2e_i_2e_i1203__BITCAST_TEMPORARY;
  unsigned int llvm_cbe_tmp3_2e_i80_2e_i_2e_i;
  struct l_struct_2E_b2DebugDraw *llvm_cbe_tmp80_2e_i_2e_i;
  unsigned int  (**llvm_cbe_tmp82_2e_i_2e_i) ();
  unsigned int  (*llvm_cbe_tmp84_2e_i_2e_i) ();
  struct l_struct_2E_b2PulleyJoint *llvm_cbe_tmp9091_2e_i_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_tmp5_2e_i88_2e_i_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp6_2e_i89_2e_i_2e_i;
  float llvm_cbe_tmp3_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp6_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp13_2e_i_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i_2e_i_2e_i_2e_i1243__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i_2e_i_2e_i_2e_i1250__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i_2e_i_2e_i_2e_i125012511252_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp97_2e_i_2e_i1206__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp100_2e_i_2e_i1210__BITCAST_TEMPORARY;
  struct l_struct_2E_b2Body *llvm_cbe_tmp6_2e_i111_2e_i_2e_i;
  float llvm_cbe_tmp3_2e_i_2e_i118_2e_i_2e_i;
  float llvm_cbe_tmp6_2e_i_2e_i121_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i_2e_i125_2e_i_2e_i;
  float llvm_cbe_tmp13_2e_i_2e_i128_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i_2e_i144_2e_i_2e_i1278__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i_2e_i147_2e_i_2e_i1285__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i_2e_i147_2e_i_2e_i128512861287_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp106_2e_i_2e_i1213__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp109_2e_i_2e_i1217__BITCAST_TEMPORARY;
  struct l_struct_2E_b2DebugDraw *llvm_cbe_tmp115_2e_i_2e_i;
  unsigned int  (**llvm_cbe_tmp117_2e_i_2e_i) ();
  unsigned int  (*llvm_cbe_tmp119_2e_i_2e_i) ();
  struct l_struct_2E_b2DebugDraw *llvm_cbe_tmp129_2e_i_2e_i;
  unsigned int  (**llvm_cbe_tmp131_2e_i_2e_i) ();
  unsigned int  (*llvm_cbe_tmp133_2e_i_2e_i) ();
  struct l_struct_2E_b2DebugDraw *llvm_cbe_tmp143_2e_i_2e_i;
  unsigned int  (**llvm_cbe_tmp145_2e_i_2e_i) ();
  unsigned int  (*llvm_cbe_tmp147_2e_i_2e_i) ();
  struct l_struct_2E_b2DebugDraw *llvm_cbe_tmp159_2e_i_2e_i;
  unsigned int  (**llvm_cbe_tmp161_2e_i_2e_i) ();
  unsigned int  (*llvm_cbe_tmp163_2e_i_2e_i) ();
  struct l_struct_2E_b2DebugDraw *llvm_cbe_tmp173_2e_i_2e_i;
  unsigned int  (**llvm_cbe_tmp175_2e_i_2e_i) ();
  unsigned int  (*llvm_cbe_tmp177_2e_i_2e_i) ();
  struct l_struct_2E_b2DebugDraw *llvm_cbe_tmp187_2e_i_2e_i;
  unsigned int  (**llvm_cbe_tmp189_2e_i_2e_i) ();
  unsigned int  (*llvm_cbe_tmp191_2e_i_2e_i) ();
  unsigned long long llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  struct l_struct_2E_b2Joint **llvm_cbe_tmp2_2e_i546_2e_i;
  unsigned long long llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  struct l_struct_2E_b2Joint **llvm_cbe_storemerge11_2e_i_2e_in;
  struct l_struct_2E_b2Joint **llvm_cbe_storemerge11_2e_i_2e_in__PHI_TEMPORARY;
  struct l_struct_2E_b2Joint *llvm_cbe_storemerge11_2e_i;
  struct l_struct_2E_b2BroadPhase *llvm_cbe_tmp152_2e_i;
  float llvm_cbe_tmp156_2e_i;
  float llvm_cbe_tmp157_2e_i;
  float llvm_cbe_tmp161_2e_i;
  float llvm_cbe_tmp162_2e_i;
  float *llvm_cbe_tmp201_2e_i;
  float *llvm_cbe_tmp226_2e_i;
  float *llvm_cbe_tmp410_2e_i;
  float *llvm_cbe_tmp413_2e_i;
  float *llvm_cbe_tmp428_2e_i;
  float *llvm_cbe_tmp431_2e_i;
  unsigned int llvm_cbe_i9_2e_i_2e_0;
  unsigned int llvm_cbe_i9_2e_i_2e_0__PHI_TEMPORARY;
  unsigned short *llvm_cbe_tmp169_2e_i;
  unsigned long long llvm_cbe_tmp176177178_2e_i;
  unsigned short llvm_cbe_tmp185_2e_i;
  unsigned long long llvm_cbe_tmp185186187_2e_i;
  unsigned short llvm_cbe_tmp194_2e_i;
  unsigned long long llvm_cbe_tmp194195196_2e_i;
  float llvm_cbe_tmp202_2e_i;
  unsigned short llvm_cbe_tmp208_2e_i;
  unsigned short llvm_cbe_tmp216_2e_i;
  float llvm_cbe_tmp227_2e_i;
  unsigned short llvm_cbe_tmp233_2e_i;
  unsigned short llvm_cbe_tmp241_2e_i;
  unsigned short llvm_cbe_tmp258_2e_i;
  unsigned short llvm_cbe_tmp266_2e_i;
  unsigned short llvm_cbe_tmp283_2e_i;
  unsigned short llvm_cbe_tmp291_2e_i;
  unsigned short llvm_cbe_tmp308_2e_i;
  unsigned short llvm_cbe_tmp316_2e_i;
  unsigned short llvm_cbe_tmp333_2e_i;
  unsigned short llvm_cbe_tmp341_2e_i;
  unsigned short llvm_cbe_tmp358_2e_i;
  unsigned short llvm_cbe_tmp366_2e_i;
  unsigned short llvm_cbe_tmp383_2e_i;
  unsigned short llvm_cbe_tmp391_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i504_2e_i1180__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i507_2e_i1187__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i507_2e_i118711881189_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp404_2e_i1073__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp407_2e_i1077__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp19_2e_i455_2e_i1166__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i458_2e_i1173__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp22_2e_i458_2e_i117311741175_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp412_2e_i1080__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp415_2e_i1084__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i410_2e_i1152__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i413_2e_i1159__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i413_2e_i115911601161_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp422_2e_i1087__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp425_2e_i1091__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp19_2e_i362_2e_i1138__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i365_2e_i1145__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp22_2e_i365_2e_i114511461147_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp430_2e_i1094__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp433_2e_i1098__BITCAST_TEMPORARY;
  struct l_struct_2E_b2DebugDraw *llvm_cbe_tmp439_2e_i;
  unsigned int  (**llvm_cbe_tmp441_2e_i) ();
  unsigned int  (*llvm_cbe_tmp443_2e_i) ();
  unsigned short *llvm_cbe_tmp449_2e_i;
  unsigned short *llvm_cbe_storemerge12_2e_in_2e_i;
  unsigned short *llvm_cbe_storemerge12_2e_in_2e_i__PHI_TEMPORARY;
  unsigned short llvm_cbe_storemerge12_2e_i;
  unsigned int llvm_cbe_tmp458_2e_i;
  struct l_struct_2E_b2BroadPhase *llvm_cbe_tmp473_2e_i;
  float llvm_cbe_tmp479_2e_i;
  float llvm_cbe_tmp482_2e_i;
  float llvm_cbe_tmp494_2e_i;
  float llvm_cbe_tmp497_2e_i;
  float llvm_cbe_tmp507_2e_i;
  float llvm_cbe_tmp508_2e_i;
  float llvm_cbe_tmp512_2e_i;
  float llvm_cbe_tmp513_2e_i;
  struct l_struct_2E_b2Vec2 *llvm_cbe_tmp616_2e_i;
  float *llvm_cbe_tmp1_2e_i278_2e_i;
  float *llvm_cbe_tmp4_2e_i281_2e_i;
  float *llvm_cbe_tmp1_2e_i269_2e_i;
  float *llvm_cbe_tmp4_2e_i272_2e_i;
  float *llvm_cbe_tmp1_2e_i260_2e_i;
  float *llvm_cbe_tmp4_2e_i263_2e_i;
  float *llvm_cbe_tmp1_2e_i251_2e_i;
  float *llvm_cbe_tmp4_2e_i254_2e_i;
  unsigned int llvm_cbe_i5_2e_i_2e_0;
  unsigned int llvm_cbe_i5_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp518519_2e_i;
  unsigned short llvm_cbe_tmp3_2e_i289_2e_i;
  unsigned short llvm_cbe_tmp535_2e_i;
  unsigned short llvm_cbe_tmp543_2e_i;
  float llvm_cbe_tmp547_2e_i;
  unsigned short llvm_cbe_tmp557_2e_i;
  unsigned short llvm_cbe_tmp565_2e_i;
  float llvm_cbe_tmp569_2e_i;
  unsigned short llvm_cbe_tmp579_2e_i;
  unsigned short llvm_cbe_tmp587_2e_i;
  float llvm_cbe_tmp591_2e_i;
  unsigned short llvm_cbe_tmp601_2e_i;
  unsigned short llvm_cbe_tmp609_2e_i;
  float llvm_cbe_tmp613_2e_i;
  unsigned long long llvm_cbe_tmp28_2e_i4_2e_0;
  unsigned long long llvm_cbe_tmp28_2e_i4_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp623_2e_i;
  struct l_struct_2E_b2DebugDraw *llvm_cbe_tmp664_2e_i;
  unsigned int  (**llvm_cbe_tmp666_2e_i) ();
  unsigned int  (*llvm_cbe_tmp668_2e_i) ();
  unsigned int llvm_cbe_tmp676_2e_i;
  struct l_struct_2E_b2Vec2 *llvm_cbe_tmp683_2e_i;
  unsigned long long llvm_cbe_tmp25_2e_i_2e_0;
  unsigned long long llvm_cbe_tmp25_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp690_2e_i;
  struct l_struct_2E_b2DebugDraw *llvm_cbe_tmp723_2e_i;
  unsigned int  (**llvm_cbe_tmp725_2e_i) ();
  unsigned int  (*llvm_cbe_tmp727_2e_i) ();
  struct l_struct_2E_b2Body **llvm_cbe_tmp741_2e_i;
  struct l_struct_2E_b2Vec2 *llvm_cbe_tmp774_2e_i;
  float *llvm_cbe_tmp1_2e_i149_2e_i;
  float *llvm_cbe_tmp4_2e_i152_2e_i;
  float *llvm_cbe_tmp1_2e_i140_2e_i;
  float *llvm_cbe_tmp4_2e_i143_2e_i;
  float *llvm_cbe_tmp1_2e_i131_2e_i;
  float *llvm_cbe_tmp4_2e_i134_2e_i;
  float *llvm_cbe_tmp1_2e_i122_2e_i;
  float *llvm_cbe_tmp4_2e_i125_2e_i;
  struct l_struct_2E_b2XForm *llvm_cbe_tmp2_2e_i166_2e_i;
  struct l_struct_2E_b2Shape **llvm_cbe_tmp2_2e_i162_2e_i;
  unsigned int llvm_cbe_tmp3_2e_i159_2e_i;
  struct l_struct_2E_b2PolygonShape *llvm_cbe_tmp756757_2e_i;
  float llvm_cbe_tmp764_2e_i;
  float llvm_cbe_tmp767_2e_i;
  unsigned long long llvm_cbe_tmp20_2e_i_2e_0;
  unsigned long long llvm_cbe_tmp20_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp781_2e_i;
  float llvm_cbe_tmp791_2e_i;
  float llvm_cbe_tmp794_2e_i;
  struct l_struct_2E_b2AABB *llvm_cbe_tmp819_2e_i;
  float *llvm_cbe_tmp2_2e_i107_2e_i;
  float *llvm_cbe_tmp9_2e_i_2e_i;
  unsigned int llvm_cbe_i_2e_i_2e_0;
  unsigned int llvm_cbe_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp815816_2e_i;
  struct l_struct_2E_b2Vec2 *llvm_cbe_tmp817_2e_i;
  unsigned long long llvm_cbe_tmp820_2e_i;
  llvmBitCastUnion llvm_cbe_tmp824_2e_i1101__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp827_2e_i1105__BITCAST_TEMPORARY;
  float llvm_cbe_tmp3_2e_i108_2e_i;
  float llvm_cbe_tmp10_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i_2e_i1124__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i_2e_i1131__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i_2e_i113111321133_2e_ins;
  float *llvm_cbe_tmp834_2e_i;
  llvmBitCastUnion llvm_cbe_tmp836_2e_i1108__BITCAST_TEMPORARY;
  float *llvm_cbe_tmp837_2e_i;
  llvmBitCastUnion llvm_cbe_tmp839_2e_i1112__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp845_2e_i;
  llvmBitCastUnion llvm_cbe_tmp851_2e_i1115__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp854_2e_i1119__BITCAST_TEMPORARY;
  unsigned int llvm_cbe_tmp856_2e_i;
  struct l_struct_2E_b2DebugDraw *llvm_cbe_tmp868_2e_i;
  unsigned int  (**llvm_cbe_tmp870_2e_i) ();
  unsigned int  (*llvm_cbe_tmp872_2e_i) ();
  unsigned long long llvm_cbe_retval_2e_i106_2e_i_2e_1;
  unsigned long long llvm_cbe_retval_2e_i106_2e_i_2e_1__PHI_TEMPORARY;
  struct l_struct_2E_b2Shape **llvm_cbe_tmp2_2e_i96_2e_i;
  unsigned long long llvm_cbe_retval_2e_i106_2e_i_2e_2;
  unsigned long long llvm_cbe_retval_2e_i106_2e_i_2e_2__PHI_TEMPORARY;
  struct l_struct_2E_b2Shape **llvm_cbe_storemerge73_2e_i_2e_in;
  struct l_struct_2E_b2Shape **llvm_cbe_storemerge73_2e_i_2e_in__PHI_TEMPORARY;
  struct l_struct_2E_b2Shape *llvm_cbe_storemerge73_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_tmp2_2e_i92_2e_i;
  unsigned long long llvm_cbe_retval_2e_i106_2e_i_2e_3;
  unsigned long long llvm_cbe_retval_2e_i106_2e_i_2e_3__PHI_TEMPORARY;
  struct l_struct_2E_b2Body **llvm_cbe_storemerge74_2e_i_2e_in;
  struct l_struct_2E_b2Body **llvm_cbe_storemerge74_2e_i_2e_in__PHI_TEMPORARY;
  struct l_struct_2E_b2Body *llvm_cbe_storemerge74_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_tmp902_2e_i;
  float *llvm_cbe_tmp909_2e_i;
  float *llvm_cbe_tmp912_2e_i;
  float *llvm_cbe_tmp919_2e_i;
  float *llvm_cbe_tmp922_2e_i;
  float *llvm_cbe_tmp927_2e_i;
  float *llvm_cbe_tmp930_2e_i;
  float llvm_cbe_tmp911_2e_i;
  float llvm_cbe_tmp914_2e_i;
  float llvm_cbe_tmp921_2e_i;
  float llvm_cbe_tmp924_2e_i;
  float llvm_cbe_tmp929_2e_i;
  float llvm_cbe_tmp932_2e_i;
  float llvm_cbe_tmp937_2e_i;
  float llvm_cbe_tmp940_2e_i;
  struct l_struct_2E_b2DebugDraw *llvm_cbe_tmp953_2e_i;
  unsigned int  (**llvm_cbe_tmp955_2e_i) ();
  unsigned int  (*llvm_cbe_tmp957_2e_i) ();
  struct l_struct_2E_b2Body **llvm_cbe_tmp2_2e_i80_2e_i;
  struct l_struct_2E_b2Body **llvm_cbe_storemerge75_2e_i_2e_in;
  struct l_struct_2E_b2Body **llvm_cbe_storemerge75_2e_i_2e_in__PHI_TEMPORARY;
  struct l_struct_2E_b2Body *llvm_cbe_storemerge75_2e_i;
  float llvm_cbe_tmp54;

  llvm_cbe_tmp1 = (&llvm_cbe_this->field2);
  *llvm_cbe_tmp1 = ((unsigned char )1);
  llvm_cbe_tmp2 = (&llvm_cbe_step.field0);
  *llvm_cbe_tmp2 = 0x1.111112p-6;
  llvm_cbe_tmp4 = (&llvm_cbe_step.field3);
  *llvm_cbe_tmp4 = 10u;
  *((&llvm_cbe_step.field1)) = 0x1.dffffep+5;
  llvm_cbe_tmp16 = (&llvm_cbe_this->field19);
  llvm_cbe_tmp17 = *llvm_cbe_tmp16;
  llvm_cbe_tmp20 = (&llvm_cbe_step.field2);
  *llvm_cbe_tmp20 = (((float )(llvm_cbe_tmp17 * 0x1.111112p-6)));
  llvm_cbe_tmp22 = (&llvm_cbe_this->field21);
  llvm_cbe_tmp23 = *llvm_cbe_tmp22;
  *((&llvm_cbe_step.field5)) = llvm_cbe_tmp23;
  llvm_cbe_tmp27 = *((&llvm_cbe_this->field22));
  llvm_cbe_tmp28 = (&llvm_cbe_step.field4);
  *llvm_cbe_tmp28 = llvm_cbe_tmp27;
  llvm_cbe_tmp2_2e_i = *((&llvm_cbe_this->field4.field1));
  llvm_cbe_tmp3_2e_i = (&llvm_cbe_tmp2_2e_i->field7);
  llvm_cbe_tmp29_2e_i = (&llvm_cbe_this->field4.field1);
  llvm_cbe_storemerge1_2e_i_2e_in__PHI_TEMPORARY = llvm_cbe_tmp3_2e_i;   /* for PHI node */
  goto llvm_cbe_bb37_2e_i;

  do {     /* Syntactic loop 'bb37.i' to make GCC happy */
llvm_cbe_bb37_2e_i:
  llvm_cbe_storemerge1_2e_i_2e_in = llvm_cbe_storemerge1_2e_i_2e_in__PHI_TEMPORARY;
  llvm_cbe_storemerge1_2e_i = *llvm_cbe_storemerge1_2e_i_2e_in;
  if ((llvm_cbe_storemerge1_2e_i == ((struct l_struct_2E_b2Contact *)/*NULL*/0))) {
    goto llvm_cbe__ZN16b2ContactManager7CollideEv_2e_exit;
  } else {
    goto llvm_cbe_bb_2e_i;
  }

llvm_cbe_bb34_2e_i:
  llvm_cbe_tmp2_2e_i3_2e_i = (&llvm_cbe_storemerge1_2e_i->field4);
  llvm_cbe_storemerge1_2e_i_2e_in__PHI_TEMPORARY = llvm_cbe_tmp2_2e_i3_2e_i;   /* for PHI node */
  goto llvm_cbe_bb37_2e_i;

llvm_cbe_bb15_2e_i:
  llvm_cbe_tmp3_2e_i27_2e_i = *((&llvm_cbe_storemerge1_2e_i->field8));
  llvm_cbe_tmp3_2e_i23_2e_i = *((&llvm_cbe_tmp3_2e_i27_2e_i->field3));
  llvm_cbe_tmp3_2e_i12_2e_i = *((&llvm_cbe_tmp3_2e_i23_2e_i->field0));
  if ((((((unsigned int )(unsigned short )llvm_cbe_tmp3_2e_i12_2e_i)) & 8u) == 0u)) {
    goto llvm_cbe_bb27_2e_i;
  } else {
    goto llvm_cbe_bb34_2e_i;
  }

llvm_cbe_bb_2e_i:
  llvm_cbe_tmp3_2e_i_2e_i = *((&llvm_cbe_storemerge1_2e_i->field7));
  llvm_cbe_tmp3_2e_i8_2e_i = *((&llvm_cbe_tmp3_2e_i_2e_i->field3));
  llvm_cbe_tmp3_2e_i15_2e_i = *((&llvm_cbe_tmp3_2e_i8_2e_i->field0));
  if ((((((unsigned int )(unsigned short )llvm_cbe_tmp3_2e_i15_2e_i)) & 8u) == 0u)) {
    goto llvm_cbe_bb27_2e_i;
  } else {
    goto llvm_cbe_bb15_2e_i;
  }

llvm_cbe_bb27_2e_i:
  llvm_cbe_tmp30_2e_i = *llvm_cbe_tmp29_2e_i;
  llvm_cbe_tmp32_2e_i = *((&llvm_cbe_tmp30_2e_i->field17));
  _ZN9b2Contact6UpdateEP17b2ContactListener(llvm_cbe_storemerge1_2e_i, llvm_cbe_tmp32_2e_i);
  goto llvm_cbe_bb34_2e_i;

  } while (1); /* end of syntactic loop 'bb37.i' */
llvm_cbe__ZN16b2ContactManager7CollideEv_2e_exit:
  llvm_cbe_tmp32 = *llvm_cbe_tmp2;
  if ((llvm_fcmp_ogt(llvm_cbe_tmp32, 0x0p+0))) {
    goto llvm_cbe_bb36;
  } else {
    goto llvm_cbe_bb38;
  }

llvm_cbe_bb36:
  llvm_cbe_tmp5_2e_i524 = (&llvm_cbe_this->field20);
  *llvm_cbe_tmp5_2e_i524 = 0u;
  llvm_cbe_tmp8_2e_i525 = *((&llvm_cbe_this->field17));
  llvm_cbe_tmp10_2e_i = (&llvm_cbe_this->field1);
  llvm_cbe_tmp13_2e_i528 = *((&llvm_cbe_this->field10));
  llvm_cbe_tmp16_2e_i531 = *((&llvm_cbe_this->field9));
  llvm_cbe_tmp18_2e_i533 = (&llvm_cbe_this->field8);
  llvm_cbe_tmp19_2e_i534 = *llvm_cbe_tmp18_2e_i533;
  llvm_cbe_tmp1_2e_i_2e_i536 = (&llvm_cbe_island_2e_i520.field8);
  *llvm_cbe_tmp1_2e_i_2e_i536 = llvm_cbe_tmp19_2e_i534;
  llvm_cbe_tmp4_2e_i_2e_i539 = (&llvm_cbe_island_2e_i520.field9);
  *llvm_cbe_tmp4_2e_i_2e_i539 = llvm_cbe_tmp16_2e_i531;
  llvm_cbe_tmp7_2e_i_2e_i542 = (&llvm_cbe_island_2e_i520.field10);
  *llvm_cbe_tmp7_2e_i_2e_i542 = llvm_cbe_tmp13_2e_i528;
  llvm_cbe_tmp10_2e_i_2e_i545 = (&llvm_cbe_island_2e_i520.field5);
  *llvm_cbe_tmp10_2e_i_2e_i545 = 0u;
  llvm_cbe_tmp12_2e_i_2e_i547 = (&llvm_cbe_island_2e_i520.field7);
  *llvm_cbe_tmp12_2e_i_2e_i547 = 0u;
  llvm_cbe_tmp14_2e_i_2e_i549 = (&llvm_cbe_island_2e_i520.field6);
  *llvm_cbe_tmp14_2e_i_2e_i549 = 0u;
  llvm_cbe_tmp16_2e_i_2e_i551 = (&llvm_cbe_island_2e_i520.field0);
  *llvm_cbe_tmp16_2e_i_2e_i551 = llvm_cbe_tmp10_2e_i;
  *((&llvm_cbe_island_2e_i520.field1)) = llvm_cbe_tmp8_2e_i525;
  llvm_cbe_tmp28_2e_i_2e_i561 = _ZN16b2StackAllocator8AllocateEi(llvm_cbe_tmp10_2e_i, (llvm_cbe_tmp19_2e_i534 << 3u));
  llvm_cbe_tmp31_2e_i_2e_i564 = (&llvm_cbe_island_2e_i520.field2);
  *llvm_cbe_tmp31_2e_i_2e_i564 = (((struct l_struct_2E_b2Body **)llvm_cbe_tmp28_2e_i_2e_i561));
  llvm_cbe_tmp38_2e_i_2e_i569 = *llvm_cbe_tmp16_2e_i_2e_i551;
  llvm_cbe_tmp39_2e_i_2e_i570 = _ZN16b2StackAllocator8AllocateEi(llvm_cbe_tmp38_2e_i_2e_i569, (llvm_cbe_tmp16_2e_i531 << 3u));
  llvm_cbe_tmp42_2e_i_2e_i573 = (&llvm_cbe_island_2e_i520.field3);
  *llvm_cbe_tmp42_2e_i_2e_i573 = (((struct l_struct_2E_b2Contact **)llvm_cbe_tmp39_2e_i_2e_i570));
  llvm_cbe_tmp49_2e_i_2e_i578 = *llvm_cbe_tmp16_2e_i_2e_i551;
  llvm_cbe_tmp50_2e_i_2e_i579 = _ZN16b2StackAllocator8AllocateEi(llvm_cbe_tmp49_2e_i_2e_i578, (llvm_cbe_tmp13_2e_i528 << 3u));
  llvm_cbe_tmp53_2e_i_2e_i582 = (&llvm_cbe_island_2e_i520.field4);
  *llvm_cbe_tmp53_2e_i_2e_i582 = (((struct l_struct_2E_b2Joint **)llvm_cbe_tmp50_2e_i_2e_i579));
  llvm_cbe_tmp55_2e_i_2e_i584 = (&llvm_cbe_island_2e_i520.field11);
  *llvm_cbe_tmp55_2e_i_2e_i584 = 0u;
  llvm_cbe_tmp21_2e_i586 = (&llvm_cbe_this->field5);
  llvm_cbe_storemerge_2e_in_2e_i596__PHI_TEMPORARY = llvm_cbe_tmp21_2e_i586;   /* for PHI node */
  goto llvm_cbe_bb32_2e_i;

  do {     /* Syntactic loop 'bb32.i' to make GCC happy */
llvm_cbe_bb32_2e_i:
  llvm_cbe_storemerge_2e_in_2e_i596 = llvm_cbe_storemerge_2e_in_2e_i596__PHI_TEMPORARY;
  llvm_cbe_storemerge_2e_i597 = *llvm_cbe_storemerge_2e_in_2e_i596;
  if ((llvm_cbe_storemerge_2e_i597 == ((struct l_struct_2E_b2Body *)/*NULL*/0))) {
    goto llvm_cbe_bb36_2e_i;
  } else {
    goto llvm_cbe_bb_2e_i595;
  }

llvm_cbe_bb_2e_i595:
  llvm_cbe_tmp24_2e_i588 = (&llvm_cbe_storemerge_2e_i597->field0);
  llvm_cbe_tmp25_2e_i589 = *llvm_cbe_tmp24_2e_i588;
  *llvm_cbe_tmp24_2e_i588 = (((unsigned short )(llvm_cbe_tmp25_2e_i589 & ((unsigned short )-5))));
  llvm_cbe_tmp30_2e_i594 = (&llvm_cbe_storemerge_2e_i597->field10);
  llvm_cbe_storemerge_2e_in_2e_i596__PHI_TEMPORARY = llvm_cbe_tmp30_2e_i594;   /* for PHI node */
  goto llvm_cbe_bb32_2e_i;

  } while (1); /* end of syntactic loop 'bb32.i' */
llvm_cbe_bb36_2e_i:
  llvm_cbe_tmp38_2e_i600 = (&llvm_cbe_this->field7);
  llvm_cbe_storemerge1_2e_in_2e_i609__PHI_TEMPORARY = llvm_cbe_tmp38_2e_i600;   /* for PHI node */
  goto llvm_cbe_bb50_2e_i;

  do {     /* Syntactic loop 'bb50.i' to make GCC happy */
llvm_cbe_bb50_2e_i:
  llvm_cbe_storemerge1_2e_in_2e_i609 = llvm_cbe_storemerge1_2e_in_2e_i609__PHI_TEMPORARY;
  llvm_cbe_storemerge1_2e_i610 = *llvm_cbe_storemerge1_2e_in_2e_i609;
  if ((llvm_cbe_storemerge1_2e_i610 == ((struct l_struct_2E_b2Contact *)/*NULL*/0))) {
    goto llvm_cbe_bb55_2e_i613;
  } else {
    goto llvm_cbe_bb40_2e_i;
  }

llvm_cbe_bb40_2e_i:
  llvm_cbe_tmp42_2e_i602 = (&llvm_cbe_storemerge1_2e_i610->field1);
  llvm_cbe_tmp43_2e_i603 = *llvm_cbe_tmp42_2e_i602;
  *llvm_cbe_tmp42_2e_i602 = (llvm_cbe_tmp43_2e_i603 & 4294967291u);
  llvm_cbe_tmp48_2e_i608 = (&llvm_cbe_storemerge1_2e_i610->field4);
  llvm_cbe_storemerge1_2e_in_2e_i609__PHI_TEMPORARY = llvm_cbe_tmp48_2e_i608;   /* for PHI node */
  goto llvm_cbe_bb50_2e_i;

  } while (1); /* end of syntactic loop 'bb50.i' */
llvm_cbe_bb55_2e_i613:
  llvm_cbe_tmp57_2e_i612 = (&llvm_cbe_this->field6);
  llvm_cbe_storemerge2_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp57_2e_i612;   /* for PHI node */
  goto llvm_cbe_bb65_2e_i;

  do {     /* Syntactic loop 'bb65.i' to make GCC happy */
llvm_cbe_bb65_2e_i:
  llvm_cbe_storemerge2_2e_in_2e_i = llvm_cbe_storemerge2_2e_in_2e_i__PHI_TEMPORARY;
  llvm_cbe_storemerge2_2e_i617 = *llvm_cbe_storemerge2_2e_in_2e_i;
  if ((llvm_cbe_storemerge2_2e_i617 == ((struct l_struct_2E_b2Joint *)/*NULL*/0))) {
    goto llvm_cbe_bb70_2e_i;
  } else {
    goto llvm_cbe_bb59_2e_i;
  }

llvm_cbe_bb59_2e_i:
  *((&llvm_cbe_storemerge2_2e_i617->field9)) = ((unsigned char )0);
  llvm_cbe_tmp63_2e_i = (&llvm_cbe_storemerge2_2e_i617->field3);
  llvm_cbe_storemerge2_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp63_2e_i;   /* for PHI node */
  goto llvm_cbe_bb65_2e_i;

  } while (1); /* end of syntactic loop 'bb65.i' */
llvm_cbe_bb70_2e_i:
  llvm_cbe_tmp73_2e_i619 = *llvm_cbe_tmp18_2e_i533;
  llvm_cbe_tmp80_2e_i622 = _ZN16b2StackAllocator8AllocateEi(llvm_cbe_tmp10_2e_i, (llvm_cbe_tmp73_2e_i619 << 3u));
  llvm_cbe_tmp8081_2e_i = ((struct l_struct_2E_b2Body **)llvm_cbe_tmp80_2e_i622);
  llvm_cbe_tmp283_2e_i740 = (&llvm_cbe_this->field12);
  llvm_cbe_tmp2_2e_i71_2e_i_2e_i = (&llvm_cbe_this->field11.field1);
  llvm_cbe_tmp9_2e_i78_2e_i_2e_i = (&llvm_cbe_this->field11.field0);
  llvm_cbe_tmp200_2e_i_2e_i_2e_i = (&llvm_cbe_contactSolver_2e_i_2e_i492.field3);
  llvm_cbe_tmp14_2e_i350_2e_i_2e_i = (&llvm_cbe_contactSolver_2e_i_2e_i492.field2);
  llvm_cbe_tmp4_2e_i25_2e_i_2e_i = (&llvm_cbe_contactSolver_2e_i_2e_i492.field1);
  llvm_cbe_storemerge6_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp21_2e_i586;   /* for PHI node */
  goto llvm_cbe_bb336_2e_i;

llvm_cbe_bb_2e_i_2e_i643:
  __assert_fail(((&_2E_str2155[((signed long long )0ull)])), ((&_2E_str3156[((signed long long )0ull)])), 52u, ((&_ZZN8b2Island3AddEP6b2BodyE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb_2e_i165_2e_i:
  __assert_fail(((&_2E_str4157[((signed long long )0ull)])), ((&_2E_str3156[((signed long long )0ull)])), 58u, ((&_ZZN8b2Island3AddEP9b2ContactE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb186_2e_i:
  __assert_fail(((&_2E_str8161[((signed long long )0ull)])), ((&_2E_str1154[((signed long long )0ull)])), 404u, ((&_ZZN7b2World5SolveERK10b2TimeStepE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb_2e_i144_2e_i:
  __assert_fail(((&_2E_str5158[((signed long long )0ull)])), ((&_2E_str3156[((signed long long )0ull)])), 64u, ((&_ZZN8b2Island3AddEP7b2JointE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb249_2e_i:
  __assert_fail(((&_2E_str8161[((signed long long )0ull)])), ((&_2E_str1154[((signed long long )0ull)])), 426u, ((&_ZZN7b2World5SolveERK10b2TimeStepE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
  do {     /* Syntactic loop 'bb336.i' to make GCC happy */
llvm_cbe_bb336_2e_i:
  llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_3 = llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_storemerge6_2e_in_2e_i = llvm_cbe_storemerge6_2e_in_2e_i__PHI_TEMPORARY;
  llvm_cbe_storemerge6_2e_i1003 = *llvm_cbe_storemerge6_2e_in_2e_i;
  if ((llvm_cbe_storemerge6_2e_i1003 == ((struct l_struct_2E_b2Body *)/*NULL*/0))) {
    goto llvm_cbe_bb341_2e_i;
  } else {
    goto llvm_cbe_bb85_2e_i628;
  }

llvm_cbe_bb332_2e_i:
  llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_2 = llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_tmp334_2e_i1002 = (&llvm_cbe_storemerge6_2e_i1003->field10);
  llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_storemerge6_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp334_2e_i1002;   /* for PHI node */
  goto llvm_cbe_bb336_2e_i;

llvm_cbe_bb85_2e_i628:
  llvm_cbe_tmp87_2e_i = (&llvm_cbe_storemerge6_2e_i1003->field0);
  llvm_cbe_tmp88_2e_i626 = *llvm_cbe_tmp87_2e_i;
  if ((((((unsigned int )(unsigned short )llvm_cbe_tmp88_2e_i626)) & 14u) == 0u)) {
    goto llvm_cbe_bb94_2e_i;
  } else {
    llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_2;   /* for PHI node */
    goto llvm_cbe_bb332_2e_i;
  }

llvm_cbe_bb94_2e_i:
  llvm_cbe_tmp3_2e_i54_2e_i = *((&llvm_cbe_storemerge6_2e_i1003->field1));
  if ((llvm_cbe_tmp3_2e_i54_2e_i == ((unsigned short )0))) {
    llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_2;   /* for PHI node */
    goto llvm_cbe_bb332_2e_i;
  } else {
    goto llvm_cbe_bb99_2e_i640;
  }

  do {     /* Syntactic loop 'bb325.i' to make GCC happy */
llvm_cbe_bb325_2e_i:
  llvm_cbe_storemerge5_2e_i996 = llvm_cbe_storemerge5_2e_i996__PHI_TEMPORARY;
  llvm_cbe_tmp327_2e_i998 = *llvm_cbe_tmp10_2e_i_2e_i545;
  if ((((signed int )llvm_cbe_tmp327_2e_i998) > ((signed int )llvm_cbe_storemerge5_2e_i996))) {
    goto llvm_cbe_bb304_2e_i;
  } else {
    llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_1;   /* for PHI node */
    llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_1;   /* for PHI node */
    llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_1;   /* for PHI node */
    llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_1;   /* for PHI node */
    llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_0;   /* for PHI node */
    goto llvm_cbe_bb332_2e_i;
  }

llvm_cbe_bb322_2e_i:
  llvm_cbe_tmp324_2e_i995 = llvm_cbe_storemerge5_2e_i996 + 1u;
  llvm_cbe_storemerge5_2e_i996__PHI_TEMPORARY = llvm_cbe_tmp324_2e_i995;   /* for PHI node */
  goto llvm_cbe_bb325_2e_i;

llvm_cbe_bb304_2e_i:
  llvm_cbe_tmp306_2e_i = *llvm_cbe_tmp31_2e_i_2e_i564;
  llvm_cbe_tmp310_2e_i986 = *((&llvm_cbe_tmp306_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge5_2e_i996)))]));
  llvm_cbe_tmp3_2e_i88_2e_i = *((&llvm_cbe_tmp310_2e_i986->field1));
  if ((llvm_cbe_tmp3_2e_i88_2e_i == ((unsigned short )0))) {
    goto llvm_cbe_bb315_2e_i;
  } else {
    goto llvm_cbe_bb322_2e_i;
  }

llvm_cbe_bb315_2e_i:
  llvm_cbe_tmp317_2e_i989 = (&llvm_cbe_tmp310_2e_i986->field0);
  llvm_cbe_tmp318_2e_i990 = *llvm_cbe_tmp317_2e_i989;
  *llvm_cbe_tmp317_2e_i989 = (((unsigned short )(llvm_cbe_tmp318_2e_i990 & ((unsigned short )-5))));
  goto llvm_cbe_bb322_2e_i;

  } while (1); /* end of syntactic loop 'bb325.i' */
llvm_cbe__ZN8b2Island5SolveERK10b2TimeStepRK6b2Vec2bb_2e_exit_2e_i:
  llvm_cbe_tmp2_2e_i23_2e_i_2e_i = *llvm_cbe_tmp14_2e_i350_2e_i_2e_i;
  llvm_cbe_tmp5_2e_i26_2e_i_2e_i = *llvm_cbe_tmp4_2e_i25_2e_i_2e_i;
  _ZN16b2StackAllocator4FreeEPv(llvm_cbe_tmp5_2e_i26_2e_i_2e_i, (((unsigned char *)llvm_cbe_tmp2_2e_i23_2e_i_2e_i)));
  llvm_cbe_tmp297_2e_i977 = *llvm_cbe_tmp55_2e_i_2e_i584;
  llvm_cbe_tmp300_2e_i = *llvm_cbe_tmp5_2e_i524;
  *llvm_cbe_tmp5_2e_i524 = ((((((signed int )llvm_cbe_tmp300_2e_i) > ((signed int )llvm_cbe_tmp297_2e_i977))) ? (llvm_cbe_tmp300_2e_i) : (llvm_cbe_tmp297_2e_i977)));
  llvm_cbe_storemerge5_2e_i996__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb325_2e_i;

llvm_cbe_bb474_2e_i_2e_i:
  llvm_cbe_tmp476_2e_i_2e_i = *llvm_cbe_tmp14_2e_i350_2e_i_2e_i;
  _ZN8b2Island6ReportEP19b2ContactConstraint((&llvm_cbe_island_2e_i520), llvm_cbe_tmp476_2e_i_2e_i);
  if ((llvm_cbe_tmp284_2e_i741 == ((unsigned char )0))) {
    goto llvm_cbe__ZN8b2Island5SolveERK10b2TimeStepRK6b2Vec2bb_2e_exit_2e_i;
  } else {
    llvm_cbe_minSleepTime_2e_i_2e_i_2e_2__PHI_TEMPORARY = 0x1.fffffep+127;   /* for PHI node */
    llvm_cbe_storemerge16_2e_i_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
    goto llvm_cbe_bb564_2e_i_2e_i;
  }

llvm_cbe_bb351_2e_i_2e_i:
  if ((llvm_cbe_tmp288_2e_i == ((unsigned char )0))) {
    goto llvm_cbe_bb474_2e_i_2e_i;
  } else {
    llvm_cbe_storemerge12_2e_i_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
    goto llvm_cbe_bb385_2e_i_2e_i;
  }

  do {     /* Syntactic loop 'bb343.i.i' to make GCC happy */
llvm_cbe_bb343_2e_i_2e_i:
  llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_storemerge9_2e_i_2e_i = llvm_cbe_storemerge9_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp346_2e_i_2e_i = *llvm_cbe_tmp10_2e_i_2e_i545;
  if ((((signed int )llvm_cbe_tmp346_2e_i_2e_i) > ((signed int )llvm_cbe_storemerge9_2e_i_2e_i))) {
    goto llvm_cbe_bb270_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb351_2e_i_2e_i;
  }

llvm_cbe_bb340_2e_i_2e_i:
  llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_0 = llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp342_2e_i134_2e_i = llvm_cbe_storemerge9_2e_i_2e_i + 1u;
  llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_0;   /* for PHI node */
  llvm_cbe_storemerge9_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp342_2e_i134_2e_i;   /* for PHI node */
  goto llvm_cbe_bb343_2e_i_2e_i;

llvm_cbe_bb270_2e_i_2e_i:
  llvm_cbe_tmp273_2e_i_2e_i = *llvm_cbe_tmp31_2e_i_2e_i564;
  llvm_cbe_tmp277_2e_i_2e_i = *((&llvm_cbe_tmp273_2e_i_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge9_2e_i_2e_i)))]));
  llvm_cbe_tmp3_2e_i242_2e_i_2e_i = *((&llvm_cbe_tmp277_2e_i_2e_i->field1));
  if ((llvm_cbe_tmp3_2e_i242_2e_i_2e_i == ((unsigned short )0))) {
    llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_1;   /* for PHI node */
    goto llvm_cbe_bb340_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb282_2e_i_2e_i;
  }

llvm_cbe_bb282_2e_i_2e_i:
  llvm_cbe_tmp288_2e_i_2e_i = *((&llvm_cbe_tmp277_2e_i_2e_i->field3.field2.field0));
  llvm_cbe_tmp291_2e_i_2e_i = *((&llvm_cbe_tmp277_2e_i_2e_i->field3.field2.field1));
  *((&llvm_cbe_tmp277_2e_i_2e_i->field3.field1.field0)) = llvm_cbe_tmp288_2e_i_2e_i;
  *((&llvm_cbe_tmp277_2e_i_2e_i->field3.field1.field1)) = llvm_cbe_tmp291_2e_i_2e_i;
  llvm_cbe_tmp303_2e_i_2e_i = (&llvm_cbe_tmp277_2e_i_2e_i->field3.field4);
  llvm_cbe_tmp304_2e_i_2e_i = *llvm_cbe_tmp303_2e_i_2e_i;
  *((&llvm_cbe_tmp277_2e_i_2e_i->field3.field3)) = llvm_cbe_tmp304_2e_i_2e_i;
  llvm_cbe_tmp312_2e_i_2e_i = *llvm_cbe_tmp2;
  llvm_cbe_tmp3_2e_i207_2e_i_2e_i = *((&llvm_cbe_tmp277_2e_i_2e_i->field4.field1));
  llvm_cbe_tmp8_2e_i212_2e_i_2e_i = *((&llvm_cbe_tmp277_2e_i_2e_i->field4.field0));
  llvm_cbe_tmp22_2e_i232_2e_i_2e_i178917901791_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp19_2e_i229_2e_i_2e_i1782__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp8_2e_i212_2e_i_2e_i * llvm_cbe_tmp312_2e_i_2e_i))), llvm_cbe_tmp19_2e_i229_2e_i_2e_i1782__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp22_2e_i232_2e_i_2e_i1789__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp3_2e_i207_2e_i_2e_i * llvm_cbe_tmp312_2e_i_2e_i))), llvm_cbe_tmp22_2e_i232_2e_i_2e_i1789__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp1_2e_i178_2e_i_2e_i = (&llvm_cbe_tmp277_2e_i_2e_i->field3.field2.field0);
  llvm_cbe_tmp2_2e_i179_2e_i_2e_i = *llvm_cbe_tmp1_2e_i178_2e_i_2e_i;
  *llvm_cbe_tmp1_2e_i178_2e_i_2e_i = (((float )(llvm_cbe_tmp2_2e_i179_2e_i_2e_i + ((llvm_cbe_tmp317_2e_i_2e_i1731__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp22_2e_i232_2e_i_2e_i178917901791_2e_ins)), llvm_cbe_tmp317_2e_i_2e_i1731__BITCAST_TEMPORARY.Float)))));
  llvm_cbe_tmp10_2e_i187_2e_i_2e_i = (&llvm_cbe_tmp277_2e_i_2e_i->field3.field2.field1);
  llvm_cbe_tmp11_2e_i188_2e_i_2e_i = *llvm_cbe_tmp10_2e_i187_2e_i_2e_i;
  *llvm_cbe_tmp10_2e_i187_2e_i_2e_i = (((float )(llvm_cbe_tmp11_2e_i188_2e_i_2e_i + ((llvm_cbe_tmp320_2e_i_2e_i1735__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp22_2e_i232_2e_i_2e_i178917901791_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp320_2e_i_2e_i1735__BITCAST_TEMPORARY.Float)))));
  llvm_cbe_tmp330_2e_i_2e_i = *llvm_cbe_tmp2;
  llvm_cbe_tmp333_2e_i_2e_i = *((&llvm_cbe_tmp277_2e_i_2e_i->field5));
  *llvm_cbe_tmp303_2e_i_2e_i = (((float )(llvm_cbe_tmp304_2e_i_2e_i + (((float )(llvm_cbe_tmp330_2e_i_2e_i * llvm_cbe_tmp333_2e_i_2e_i))))));
  _ZN6b2Body20SynchronizeTransformEv(llvm_cbe_tmp277_2e_i_2e_i);
  llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i232_2e_i_2e_i178917901791_2e_ins;   /* for PHI node */
  goto llvm_cbe_bb340_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb343.i.i' */
  do {     /* Syntactic loop 'bb49.i.i.i' to make GCC happy */
llvm_cbe_bb49_2e_i_2e_i_2e_i:
  llvm_cbe_storemerge1_2e_i_2e_i_2e_i = llvm_cbe_storemerge1_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp52_2e_i_2e_i_2e_i = *llvm_cbe_tmp200_2e_i_2e_i_2e_i;
  if ((((signed int )llvm_cbe_tmp52_2e_i_2e_i_2e_i) > ((signed int )llvm_cbe_storemerge1_2e_i_2e_i_2e_i))) {
    goto llvm_cbe_bb_2e_i255_2e_i_2e_i;
  } else {
    llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i200_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_storemerge9_2e_i_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
    goto llvm_cbe_bb343_2e_i_2e_i;
  }

llvm_cbe_bb46_2e_i_2e_i_2e_i:
  llvm_cbe_tmp48_2e_i_2e_i_2e_i952 = llvm_cbe_storemerge1_2e_i_2e_i_2e_i + 1u;
  llvm_cbe_storemerge1_2e_i_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp48_2e_i_2e_i_2e_i952;   /* for PHI node */
  goto llvm_cbe_bb49_2e_i_2e_i_2e_i;

  do {     /* Syntactic loop 'bb39.i.i.i' to make GCC happy */
llvm_cbe_bb39_2e_i_2e_i_2e_i:
  llvm_cbe_storemerge_2e_i267_2e_i_2e_i = llvm_cbe_storemerge_2e_i267_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp42_2e_i_2e_i_2e_i = *llvm_cbe_tmp41_2e_i_2e_i_2e_i949;
  if ((((signed int )llvm_cbe_tmp42_2e_i_2e_i_2e_i) > ((signed int )llvm_cbe_storemerge_2e_i267_2e_i_2e_i))) {
    goto llvm_cbe_bb9_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb46_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb9_2e_i_2e_i_2e_i:
  llvm_cbe_tmp1114_2e_i_2e_i_2e_i = ((signed long long )(signed int )llvm_cbe_storemerge_2e_i267_2e_i_2e_i);
  llvm_cbe_tmp17_2e_i259_2e_i_2e_i = *((&llvm_cbe_tmp2_2e_i250_2e_i_2e_i[((signed long long )llvm_cbe_tmp34_2e_i_2e_i_2e_i)].field0[((signed long long )llvm_cbe_tmp1114_2e_i_2e_i_2e_i)].field4));
  *((&llvm_cbe_tmp8_2e_i254_2e_i_2e_i->field0[((signed long long )llvm_cbe_tmp1114_2e_i_2e_i_2e_i)].field3)) = llvm_cbe_tmp17_2e_i259_2e_i_2e_i;
  llvm_cbe_tmp30_2e_i265_2e_i_2e_i = *((&llvm_cbe_tmp2_2e_i250_2e_i_2e_i[((signed long long )llvm_cbe_tmp34_2e_i_2e_i_2e_i)].field0[((signed long long )llvm_cbe_tmp1114_2e_i_2e_i_2e_i)].field5));
  *((&llvm_cbe_tmp8_2e_i254_2e_i_2e_i->field0[((signed long long )llvm_cbe_tmp1114_2e_i_2e_i_2e_i)].field4)) = llvm_cbe_tmp30_2e_i265_2e_i_2e_i;
  llvm_cbe_tmp38_2e_i_2e_i_2e_i947 = llvm_cbe_storemerge_2e_i267_2e_i_2e_i + 1u;
  llvm_cbe_storemerge_2e_i267_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp38_2e_i_2e_i_2e_i947;   /* for PHI node */
  goto llvm_cbe_bb39_2e_i_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb39.i.i.i' */
llvm_cbe_bb_2e_i255_2e_i_2e_i:
  llvm_cbe_tmp2_2e_i250_2e_i_2e_i = *llvm_cbe_tmp14_2e_i350_2e_i_2e_i;
  llvm_cbe_tmp34_2e_i_2e_i_2e_i = ((signed long long )(signed int )llvm_cbe_storemerge1_2e_i_2e_i_2e_i);
  llvm_cbe_tmp8_2e_i254_2e_i_2e_i = *((&llvm_cbe_tmp2_2e_i250_2e_i_2e_i[((signed long long )llvm_cbe_tmp34_2e_i_2e_i_2e_i)].field2));
  llvm_cbe_tmp41_2e_i_2e_i_2e_i949 = (&llvm_cbe_tmp2_2e_i250_2e_i_2e_i[((signed long long )llvm_cbe_tmp34_2e_i_2e_i_2e_i)].field7);
  llvm_cbe_storemerge_2e_i267_2e_i_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb39_2e_i_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb49.i.i.i' */
  do {     /* Syntactic loop 'bb260.i.i' to make GCC happy */
llvm_cbe_bb260_2e_i_2e_i:
  llvm_cbe_storemerge8_2e_i_2e_i = llvm_cbe_storemerge8_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp263_2e_i_2e_i = *llvm_cbe_tmp4;
  if ((((signed int )llvm_cbe_tmp263_2e_i_2e_i) > ((signed int )llvm_cbe_storemerge8_2e_i_2e_i))) {
    goto llvm_cbe_bb216_2e_i_2e_i;
  } else {
    llvm_cbe_storemerge1_2e_i_2e_i_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
    goto llvm_cbe_bb49_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb257_2e_i_2e_i:
  llvm_cbe_tmp259_2e_i_2e_i = llvm_cbe_storemerge8_2e_i_2e_i + 1u;
  llvm_cbe_storemerge8_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp259_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb260_2e_i_2e_i;

  do {     /* Syntactic loop 'bb249.i.i' to make GCC happy */
llvm_cbe_bb249_2e_i_2e_i:
  llvm_cbe_storemerge7_2e_i_2e_i = llvm_cbe_storemerge7_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp252_2e_i_2e_i = *llvm_cbe_tmp14_2e_i_2e_i549;
  if ((((signed int )llvm_cbe_tmp252_2e_i_2e_i) > ((signed int )llvm_cbe_storemerge7_2e_i_2e_i))) {
    goto llvm_cbe_bb218_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb257_2e_i_2e_i;
  }

llvm_cbe_bb218_2e_i_2e_i:
  llvm_cbe_tmp228_2e_i_2e_i = *llvm_cbe_tmp53_2e_i_2e_i582;
  llvm_cbe_tmp232_2e_i_2e_i = *((&llvm_cbe_tmp228_2e_i_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge7_2e_i_2e_i)))]));
  llvm_cbe_tmp234_2e_i_2e_i = *((&llvm_cbe_tmp232_2e_i_2e_i->field0));
  llvm_cbe_tmp236_2e_i_2e_i = *((&llvm_cbe_tmp234_2e_i_2e_i[((signed long long )7ull)]));
  (((void  (*) (struct l_struct_2E_b2Joint *, struct l_struct_2E_b2TimeStep *))llvm_cbe_tmp236_2e_i_2e_i))(llvm_cbe_tmp232_2e_i_2e_i, (&llvm_cbe_step));
  llvm_cbe_tmp248_2e_i_2e_i = llvm_cbe_storemerge7_2e_i_2e_i + 1u;
  llvm_cbe_storemerge7_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp248_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb249_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb249.i.i' */
llvm_cbe_bb216_2e_i_2e_i:
  _ZN15b2ContactSolver24SolveVelocityConstraintsEv((&llvm_cbe_contactSolver_2e_i_2e_i492));
  llvm_cbe_storemerge7_2e_i_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb249_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb260.i.i' */
  do {     /* Syntactic loop 'bb207.i.i' to make GCC happy */
llvm_cbe_bb207_2e_i_2e_i:
  llvm_cbe_storemerge6_2e_i_2e_i = llvm_cbe_storemerge6_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp210_2e_i_2e_i = *llvm_cbe_tmp14_2e_i_2e_i549;
  if ((((signed int )llvm_cbe_tmp210_2e_i_2e_i) > ((signed int )llvm_cbe_storemerge6_2e_i_2e_i))) {
    goto llvm_cbe_bb176_2e_i_2e_i945;
  } else {
    llvm_cbe_storemerge8_2e_i_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
    goto llvm_cbe_bb260_2e_i_2e_i;
  }

llvm_cbe_bb176_2e_i_2e_i945:
  llvm_cbe_tmp186_2e_i_2e_i937 = *llvm_cbe_tmp53_2e_i_2e_i582;
  llvm_cbe_tmp190_2e_i_2e_i940 = *((&llvm_cbe_tmp186_2e_i_2e_i937[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge6_2e_i_2e_i)))]));
  llvm_cbe_tmp192_2e_i_2e_i942 = *((&llvm_cbe_tmp190_2e_i_2e_i940->field0));
  llvm_cbe_tmp194_2e_i_2e_i = *((&llvm_cbe_tmp192_2e_i_2e_i942[((signed long long )6ull)]));
  (((void  (*) (struct l_struct_2E_b2Joint *, struct l_struct_2E_b2TimeStep *))llvm_cbe_tmp194_2e_i_2e_i))(llvm_cbe_tmp190_2e_i_2e_i940, (&llvm_cbe_step));
  llvm_cbe_tmp206_2e_i_2e_i = llvm_cbe_storemerge6_2e_i_2e_i + 1u;
  llvm_cbe_storemerge6_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp206_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb207_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb207.i.i' */
  do {     /* Syntactic loop 'bb198.i.i.i' to make GCC happy */
llvm_cbe_bb198_2e_i_2e_i_2e_i:
  llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_0 = llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_storemerge65_2e_i_2e_i_2e_i = llvm_cbe_storemerge65_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp201_2e_i_2e_i_2e_i = *llvm_cbe_tmp200_2e_i_2e_i_2e_i;
  if ((((signed int )llvm_cbe_tmp201_2e_i_2e_i_2e_i) > ((signed int )llvm_cbe_storemerge65_2e_i_2e_i_2e_i))) {
    goto llvm_cbe_bb_2e_i387_2e_i_2e_i;
  } else {
    llvm_cbe_storemerge6_2e_i_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
    goto llvm_cbe_bb207_2e_i_2e_i;
  }

llvm_cbe_bb195_2e_i_2e_i_2e_i:
  llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_tmp197_2e_i_2e_i_2e_i = llvm_cbe_storemerge65_2e_i_2e_i_2e_i + 1u;
  llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp23_2e_i_2e_i_2e_i_2e_i909184518461847_2e_ins;   /* for PHI node */
  llvm_cbe_storemerge65_2e_i_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp197_2e_i_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb198_2e_i_2e_i_2e_i;

  do {     /* Syntactic loop 'bb164.i.i.i' to make GCC happy */
llvm_cbe_bb164_2e_i_2e_i_2e_i:
  llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_0 = llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_0 = llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_0 = llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_0 = llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_0 = llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_storemerge_2e_i388_2e_i_2e_i = llvm_cbe_storemerge_2e_i388_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp167_2e_i_2e_i_2e_i = *llvm_cbe_tmp189_2e_i_2e_i_2e_i;
  if ((((signed int )llvm_cbe_tmp167_2e_i_2e_i_2e_i) > ((signed int )llvm_cbe_storemerge_2e_i388_2e_i_2e_i))) {
    goto llvm_cbe_bb63_2e_i_2e_i_2e_i;
  } else {
    llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_0;   /* for PHI node */
    llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_0;   /* for PHI node */
    llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_0;   /* for PHI node */
    llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_0;   /* for PHI node */
    llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_0;   /* for PHI node */
    goto llvm_cbe_bb195_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb63_2e_i_2e_i_2e_i:
  llvm_cbe_tmp6768_2e_i_2e_i_2e_i = ((signed long long )(signed int )llvm_cbe_storemerge_2e_i388_2e_i_2e_i);
  llvm_cbe_tmp72_2e_i_2e_i_2e_i = *((&llvm_cbe_tmp15_2e_i351_2e_i_2e_i[((signed long long )llvm_cbe_tmp1617_2e_i_2e_i_2e_i)].field0[((signed long long )llvm_cbe_tmp6768_2e_i_2e_i_2e_i)].field4));
  llvm_cbe_tmp75_2e_i_2e_i_2e_i926 = *llvm_cbe_tmp20;
  llvm_cbe_tmp76_2e_i_2e_i_2e_i = ((float )(llvm_cbe_tmp72_2e_i_2e_i_2e_i * llvm_cbe_tmp75_2e_i_2e_i_2e_i926));
  *((&llvm_cbe_tmp15_2e_i351_2e_i_2e_i[((signed long long )llvm_cbe_tmp1617_2e_i_2e_i_2e_i)].field0[((signed long long )llvm_cbe_tmp6768_2e_i_2e_i_2e_i)].field4)) = llvm_cbe_tmp76_2e_i_2e_i_2e_i;
  llvm_cbe_tmp80_2e_i_2e_i_2e_i930 = (&llvm_cbe_tmp15_2e_i351_2e_i_2e_i[((signed long long )llvm_cbe_tmp1617_2e_i_2e_i_2e_i)].field0[((signed long long )llvm_cbe_tmp6768_2e_i_2e_i_2e_i)].field5);
  llvm_cbe_tmp81_2e_i_2e_i_2e_i = *llvm_cbe_tmp80_2e_i_2e_i_2e_i930;
  llvm_cbe_tmp84_2e_i_2e_i_2e_i931 = *llvm_cbe_tmp20;
  llvm_cbe_tmp85_2e_i_2e_i_2e_i = ((float )(llvm_cbe_tmp81_2e_i_2e_i_2e_i * llvm_cbe_tmp84_2e_i_2e_i_2e_i931));
  *llvm_cbe_tmp80_2e_i_2e_i_2e_i930 = llvm_cbe_tmp85_2e_i_2e_i_2e_i;
  llvm_cbe_tmp22_2e_i358_2e_i_2e_i_2e_i191519161917_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp19_2e_i355_2e_i_2e_i_2e_i1908__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp55_2e_i_2e_i_2e_i9161794 * llvm_cbe_tmp85_2e_i_2e_i_2e_i))), llvm_cbe_tmp19_2e_i355_2e_i_2e_i_2e_i1908__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp22_2e_i358_2e_i_2e_i_2e_i1915__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp58_2e_i_2e_i_2e_i9181798 * llvm_cbe_tmp85_2e_i_2e_i_2e_i))), llvm_cbe_tmp22_2e_i358_2e_i_2e_i_2e_i1915__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp22_2e_i313_2e_i_2e_i_2e_i190119021903_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp19_2e_i310_2e_i_2e_i_2e_i1894__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp41_2e_i371_2e_i_2e_i * llvm_cbe_tmp76_2e_i_2e_i_2e_i))), llvm_cbe_tmp19_2e_i310_2e_i_2e_i_2e_i1894__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp22_2e_i313_2e_i_2e_i_2e_i1901__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp44_2e_i374_2e_i_2e_i * llvm_cbe_tmp76_2e_i_2e_i_2e_i))), llvm_cbe_tmp22_2e_i313_2e_i_2e_i_2e_i1901__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp26_2e_i272_2e_i_2e_i_2e_i188718881889_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i269_2e_i_2e_i_2e_i1880__BITCAST_TEMPORARY.Float = (((float )(((llvm_cbe_tmp106_2e_i_2e_i_2e_i1808__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp22_2e_i313_2e_i_2e_i_2e_i190119021903_2e_ins)), llvm_cbe_tmp106_2e_i_2e_i_2e_i1808__BITCAST_TEMPORARY.Float)) + ((llvm_cbe_tmp95_2e_i_2e_i_2e_i1801__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp22_2e_i358_2e_i_2e_i_2e_i191519161917_2e_ins)), llvm_cbe_tmp95_2e_i_2e_i_2e_i1801__BITCAST_TEMPORARY.Float))))), llvm_cbe_tmp23_2e_i269_2e_i_2e_i_2e_i1880__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i272_2e_i_2e_i_2e_i1887__BITCAST_TEMPORARY.Float = (((float )(((llvm_cbe_tmp109_2e_i_2e_i_2e_i1812__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp22_2e_i313_2e_i_2e_i_2e_i190119021903_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp109_2e_i_2e_i_2e_i1812__BITCAST_TEMPORARY.Float)) + ((llvm_cbe_tmp98_2e_i_2e_i_2e_i1805__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp22_2e_i358_2e_i_2e_i_2e_i191519161917_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp98_2e_i_2e_i_2e_i1805__BITCAST_TEMPORARY.Float))))), llvm_cbe_tmp26_2e_i272_2e_i_2e_i_2e_i1887__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp114_2e_i_2e_i_2e_i1815 = (llvm_cbe_tmp114_2e_i_2e_i_2e_i1815__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i272_2e_i_2e_i_2e_i188718881889_2e_ins)), llvm_cbe_tmp114_2e_i_2e_i_2e_i1815__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp117_2e_i_2e_i_2e_i1819 = (llvm_cbe_tmp117_2e_i_2e_i_2e_i1819__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i272_2e_i_2e_i_2e_i188718881889_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp117_2e_i_2e_i_2e_i1819__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp120_2e_i_2e_i_2e_i = *llvm_cbe_tmp119_2e_i_2e_i_2e_i;
  llvm_cbe_tmp3_2e_i217_2e_i_2e_i_2e_i = *((&llvm_cbe_tmp15_2e_i351_2e_i_2e_i[((signed long long )llvm_cbe_tmp1617_2e_i_2e_i_2e_i)].field0[((signed long long )llvm_cbe_tmp6768_2e_i_2e_i_2e_i)].field2.field0));
  llvm_cbe_tmp10_2e_i224_2e_i_2e_i_2e_i = *((&llvm_cbe_tmp15_2e_i351_2e_i_2e_i[((signed long long )llvm_cbe_tmp1617_2e_i_2e_i_2e_i)].field0[((signed long long )llvm_cbe_tmp6768_2e_i_2e_i_2e_i)].field2.field1));
  *llvm_cbe_tmp119_2e_i_2e_i_2e_i = (((float )(llvm_cbe_tmp120_2e_i_2e_i_2e_i - (((float )((((float )((((float )(llvm_cbe_tmp3_2e_i217_2e_i_2e_i_2e_i * llvm_cbe_tmp117_2e_i_2e_i_2e_i1819))) - (((float )(llvm_cbe_tmp10_2e_i224_2e_i_2e_i_2e_i * llvm_cbe_tmp114_2e_i_2e_i_2e_i1815)))))) * llvm_cbe_tmp30_2e_i364_2e_i_2e_i))))));
  llvm_cbe_tmp22_2e_i204_2e_i_2e_i_2e_i187318741875_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp19_2e_i201_2e_i_2e_i_2e_i1866__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp114_2e_i_2e_i_2e_i1815 * llvm_cbe_tmp27_2e_i361_2e_i_2e_i))), llvm_cbe_tmp19_2e_i201_2e_i_2e_i_2e_i1866__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp22_2e_i204_2e_i_2e_i_2e_i1873__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp117_2e_i_2e_i_2e_i1819 * llvm_cbe_tmp27_2e_i361_2e_i_2e_i))), llvm_cbe_tmp22_2e_i204_2e_i_2e_i_2e_i1873__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp2_2e_i151_2e_i_2e_i_2e_i = *llvm_cbe_tmp1_2e_i150_2e_i_2e_i_2e_i;
  *llvm_cbe_tmp1_2e_i150_2e_i_2e_i_2e_i = (((float )(llvm_cbe_tmp2_2e_i151_2e_i_2e_i_2e_i - ((llvm_cbe_tmp134_2e_i_2e_i_2e_i1822__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp22_2e_i204_2e_i_2e_i_2e_i187318741875_2e_ins)), llvm_cbe_tmp134_2e_i_2e_i_2e_i1822__BITCAST_TEMPORARY.Float)))));
  llvm_cbe_tmp11_2e_i160_2e_i_2e_i_2e_i = *llvm_cbe_tmp10_2e_i159_2e_i_2e_i_2e_i;
  *llvm_cbe_tmp10_2e_i159_2e_i_2e_i_2e_i = (((float )(llvm_cbe_tmp11_2e_i160_2e_i_2e_i_2e_i - ((llvm_cbe_tmp137_2e_i_2e_i_2e_i1826__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp22_2e_i204_2e_i_2e_i_2e_i187318741875_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp137_2e_i_2e_i_2e_i1826__BITCAST_TEMPORARY.Float)))));
  llvm_cbe_tmp142_2e_i_2e_i_2e_i = *llvm_cbe_tmp141_2e_i_2e_i_2e_i;
  llvm_cbe_tmp3_2e_i134_2e_i_2e_i_2e_i = *((&llvm_cbe_tmp15_2e_i351_2e_i_2e_i[((signed long long )llvm_cbe_tmp1617_2e_i_2e_i_2e_i)].field0[((signed long long )llvm_cbe_tmp6768_2e_i_2e_i_2e_i)].field3.field0));
  llvm_cbe_tmp10_2e_i141_2e_i_2e_i_2e_i = *((&llvm_cbe_tmp15_2e_i351_2e_i_2e_i[((signed long long )llvm_cbe_tmp1617_2e_i_2e_i_2e_i)].field0[((signed long long )llvm_cbe_tmp6768_2e_i_2e_i_2e_i)].field3.field1));
  *llvm_cbe_tmp141_2e_i_2e_i_2e_i = (((float )(llvm_cbe_tmp142_2e_i_2e_i_2e_i + (((float )((((float )((((float )(llvm_cbe_tmp3_2e_i134_2e_i_2e_i_2e_i * llvm_cbe_tmp117_2e_i_2e_i_2e_i1819))) - (((float )(llvm_cbe_tmp10_2e_i141_2e_i_2e_i_2e_i * llvm_cbe_tmp114_2e_i_2e_i_2e_i1815)))))) * llvm_cbe_tmp36_2e_i368_2e_i_2e_i))))));
  llvm_cbe_tmp22_2e_i123_2e_i_2e_i_2e_i185918601861_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp19_2e_i120_2e_i_2e_i_2e_i1852__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp114_2e_i_2e_i_2e_i1815 * llvm_cbe_tmp33_2e_i_2e_i_2e_i882))), llvm_cbe_tmp19_2e_i120_2e_i_2e_i_2e_i1852__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp22_2e_i123_2e_i_2e_i_2e_i1859__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp117_2e_i_2e_i_2e_i1819 * llvm_cbe_tmp33_2e_i_2e_i_2e_i882))), llvm_cbe_tmp22_2e_i123_2e_i_2e_i_2e_i1859__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp2_2e_i70_2e_i_2e_i_2e_i = *llvm_cbe_tmp1_2e_i69_2e_i_2e_i_2e_i;
  *llvm_cbe_tmp1_2e_i69_2e_i_2e_i_2e_i = (((float )(llvm_cbe_tmp2_2e_i70_2e_i_2e_i_2e_i + ((llvm_cbe_tmp156_2e_i_2e_i_2e_i1829__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp22_2e_i123_2e_i_2e_i_2e_i185918601861_2e_ins)), llvm_cbe_tmp156_2e_i_2e_i_2e_i1829__BITCAST_TEMPORARY.Float)))));
  llvm_cbe_tmp11_2e_i79_2e_i_2e_i_2e_i = *llvm_cbe_tmp10_2e_i78_2e_i_2e_i_2e_i;
  *llvm_cbe_tmp10_2e_i78_2e_i_2e_i_2e_i = (((float )(llvm_cbe_tmp11_2e_i79_2e_i_2e_i_2e_i + ((llvm_cbe_tmp159_2e_i_2e_i_2e_i1833__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp22_2e_i123_2e_i_2e_i_2e_i185918601861_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp159_2e_i_2e_i_2e_i1833__BITCAST_TEMPORARY.Float)))));
  llvm_cbe_tmp163_2e_i_2e_i_2e_i = llvm_cbe_storemerge_2e_i388_2e_i_2e_i + 1u;
  llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i123_2e_i_2e_i_2e_i185918601861_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i204_2e_i_2e_i_2e_i187318741875_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i272_2e_i_2e_i_2e_i188718881889_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i313_2e_i_2e_i_2e_i190119021903_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i358_2e_i_2e_i_2e_i191519161917_2e_ins;   /* for PHI node */
  llvm_cbe_storemerge_2e_i388_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp163_2e_i_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb164_2e_i_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb164.i.i.i' */
llvm_cbe_bb62_2e_i_2e_i_2e_i922:
  llvm_cbe_tmp119_2e_i_2e_i_2e_i = (&llvm_cbe_tmp21_2e_i355_2e_i_2e_i->field5);
  llvm_cbe_tmp1_2e_i150_2e_i_2e_i_2e_i = (&llvm_cbe_tmp21_2e_i355_2e_i_2e_i->field4.field0);
  llvm_cbe_tmp10_2e_i159_2e_i_2e_i_2e_i = (&llvm_cbe_tmp21_2e_i355_2e_i_2e_i->field4.field1);
  llvm_cbe_tmp141_2e_i_2e_i_2e_i = (&llvm_cbe_tmp24_2e_i358_2e_i_2e_i->field5);
  llvm_cbe_tmp1_2e_i69_2e_i_2e_i_2e_i = (&llvm_cbe_tmp24_2e_i358_2e_i_2e_i->field4.field0);
  llvm_cbe_tmp10_2e_i78_2e_i_2e_i_2e_i = (&llvm_cbe_tmp24_2e_i358_2e_i_2e_i->field4.field1);
  llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_storemerge_2e_i388_2e_i_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb164_2e_i_2e_i_2e_i;

llvm_cbe_bb_2e_i387_2e_i_2e_i:
  llvm_cbe_tmp15_2e_i351_2e_i_2e_i = *llvm_cbe_tmp14_2e_i350_2e_i_2e_i;
  llvm_cbe_tmp1617_2e_i_2e_i_2e_i = ((signed long long )(signed int )llvm_cbe_storemerge65_2e_i_2e_i_2e_i);
  llvm_cbe_tmp21_2e_i355_2e_i_2e_i = *((&llvm_cbe_tmp15_2e_i351_2e_i_2e_i[((signed long long )llvm_cbe_tmp1617_2e_i_2e_i_2e_i)].field3));
  llvm_cbe_tmp24_2e_i358_2e_i_2e_i = *((&llvm_cbe_tmp15_2e_i351_2e_i_2e_i[((signed long long )llvm_cbe_tmp1617_2e_i_2e_i_2e_i)].field4));
  llvm_cbe_tmp27_2e_i361_2e_i_2e_i = *((&llvm_cbe_tmp21_2e_i355_2e_i_2e_i->field16));
  llvm_cbe_tmp30_2e_i364_2e_i_2e_i = *((&llvm_cbe_tmp21_2e_i355_2e_i_2e_i->field18));
  llvm_cbe_tmp33_2e_i_2e_i_2e_i882 = *((&llvm_cbe_tmp24_2e_i358_2e_i_2e_i->field16));
  llvm_cbe_tmp36_2e_i368_2e_i_2e_i = *((&llvm_cbe_tmp24_2e_i358_2e_i_2e_i->field18));
  llvm_cbe_tmp41_2e_i371_2e_i_2e_i = *((&llvm_cbe_tmp15_2e_i351_2e_i_2e_i[((signed long long )llvm_cbe_tmp1617_2e_i_2e_i_2e_i)].field1.field0));
  llvm_cbe_tmp44_2e_i374_2e_i_2e_i = *((&llvm_cbe_tmp15_2e_i351_2e_i_2e_i[((signed long long )llvm_cbe_tmp1617_2e_i_2e_i_2e_i)].field1.field1));
  llvm_cbe_tmp23_2e_i_2e_i_2e_i_2e_i909184518461847_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp20_2e_i_2e_i_2e_i_2e_i9061838__BITCAST_TEMPORARY.Float = llvm_cbe_tmp44_2e_i374_2e_i_2e_i, llvm_cbe_tmp20_2e_i_2e_i_2e_i_2e_i9061838__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i_2e_i_2e_i_2e_i9091845__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp41_2e_i371_2e_i_2e_i * -0x1p+0))), llvm_cbe_tmp23_2e_i_2e_i_2e_i_2e_i9091845__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp55_2e_i_2e_i_2e_i9161794 = (llvm_cbe_tmp55_2e_i_2e_i_2e_i9161794__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp23_2e_i_2e_i_2e_i_2e_i909184518461847_2e_ins)), llvm_cbe_tmp55_2e_i_2e_i_2e_i9161794__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp58_2e_i_2e_i_2e_i9181798 = (llvm_cbe_tmp58_2e_i_2e_i_2e_i9181798__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp23_2e_i_2e_i_2e_i_2e_i909184518461847_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp58_2e_i_2e_i_2e_i9181798__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp61_2e_i_2e_i_2e_i921 = *llvm_cbe_tmp28;
  llvm_cbe_tmp189_2e_i_2e_i_2e_i = (&llvm_cbe_tmp15_2e_i351_2e_i_2e_i[((signed long long )llvm_cbe_tmp1617_2e_i_2e_i_2e_i)].field7);
  if ((llvm_cbe_tmp61_2e_i_2e_i_2e_i921 == ((unsigned char )0))) {
    goto llvm_cbe_bb173_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb62_2e_i_2e_i_2e_i922;
  }

  do {     /* Syntactic loop 'bb187.i.i.i' to make GCC happy */
llvm_cbe_bb187_2e_i_2e_i_2e_i:
  llvm_cbe_storemerge64_2e_i_2e_i_2e_i = llvm_cbe_storemerge64_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  if ((((signed int )llvm_cbe_tmp190_2e_i_2e_i_2e_i) > ((signed int )llvm_cbe_storemerge64_2e_i_2e_i_2e_i))) {
    goto llvm_cbe_bb174_2e_i_2e_i_2e_i;
  } else {
    llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    goto llvm_cbe_bb195_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb174_2e_i_2e_i_2e_i:
  llvm_cbe_tmp178179_2e_i_2e_i_2e_i = ((signed long long )(signed int )llvm_cbe_storemerge64_2e_i_2e_i_2e_i);
  *((&llvm_cbe_tmp15_2e_i351_2e_i_2e_i[((signed long long )llvm_cbe_tmp1617_2e_i_2e_i_2e_i)].field0[((signed long long )llvm_cbe_tmp178179_2e_i_2e_i_2e_i)].field4)) = 0x0p+0;
  *((&llvm_cbe_tmp15_2e_i351_2e_i_2e_i[((signed long long )llvm_cbe_tmp1617_2e_i_2e_i_2e_i)].field0[((signed long long )llvm_cbe_tmp178179_2e_i_2e_i_2e_i)].field5)) = 0x0p+0;
  llvm_cbe_tmp186_2e_i_2e_i_2e_i = llvm_cbe_storemerge64_2e_i_2e_i_2e_i + 1u;
  llvm_cbe_storemerge64_2e_i_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp186_2e_i_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb187_2e_i_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb187.i.i.i' */
llvm_cbe_bb173_2e_i_2e_i_2e_i:
  llvm_cbe_tmp190_2e_i_2e_i_2e_i = *llvm_cbe_tmp189_2e_i_2e_i_2e_i;
  llvm_cbe_storemerge64_2e_i_2e_i_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb187_2e_i_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb198.i.i.i' */
llvm_cbe_bb164_2e_i_2e_i:
  llvm_cbe_tmp167_2e_i_2e_i = *llvm_cbe_tmp16_2e_i_2e_i551;
  llvm_cbe_tmp170_2e_i_2e_i = *llvm_cbe_tmp12_2e_i_2e_i547;
  llvm_cbe_tmp173_2e_i_2e_i878 = *llvm_cbe_tmp42_2e_i_2e_i573;
  _ZN15b2ContactSolverC1ERK10b2TimeStepPP9b2ContactiP16b2StackAllocator((&llvm_cbe_contactSolver_2e_i_2e_i492), (&llvm_cbe_step), llvm_cbe_tmp173_2e_i_2e_i878, llvm_cbe_tmp170_2e_i_2e_i, llvm_cbe_tmp167_2e_i_2e_i);
  llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i91_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i172_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i236_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i281_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i326_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i_2e_i331_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_storemerge65_2e_i_2e_i_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb198_2e_i_2e_i_2e_i;

  do {     /* Syntactic loop 'bb156.i.i' to make GCC happy */
llvm_cbe_bb156_2e_i_2e_i:
  llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_1 = llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_1__PHI_TEMPORARY;
  llvm_cbe_storemerge_2e_i132_2e_i = llvm_cbe_storemerge_2e_i132_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp159_2e_i_2e_i870 = *llvm_cbe_tmp10_2e_i_2e_i545;
  if ((((signed int )llvm_cbe_tmp159_2e_i_2e_i870) > ((signed int )llvm_cbe_storemerge_2e_i132_2e_i))) {
    goto llvm_cbe_bb_2e_i115_2e_i;
  } else {
    goto llvm_cbe_bb164_2e_i_2e_i;
  }

llvm_cbe_bb153_2e_i_2e_i867:
  llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_0 = llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_0 = llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_0 = llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp155_2e_i_2e_i = llvm_cbe_storemerge_2e_i132_2e_i + 1u;
  llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_0;   /* for PHI node */
  llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_0;   /* for PHI node */
  llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_0;   /* for PHI node */
  llvm_cbe_storemerge_2e_i132_2e_i__PHI_TEMPORARY = llvm_cbe_tmp155_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb156_2e_i_2e_i;

llvm_cbe_bb_2e_i115_2e_i:
  llvm_cbe_tmp21_2e_i112_2e_i = *llvm_cbe_tmp31_2e_i_2e_i564;
  llvm_cbe_tmp25_2e_i114_2e_i = *((&llvm_cbe_tmp21_2e_i112_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge_2e_i132_2e_i)))]));
  llvm_cbe_tmp3_2e_i_2e_i_2e_i750 = *((&llvm_cbe_tmp25_2e_i114_2e_i->field1));
  if ((llvm_cbe_tmp3_2e_i_2e_i_2e_i750 == ((unsigned short )0))) {
    llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_1;   /* for PHI node */
    llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_1;   /* for PHI node */
    llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_1;   /* for PHI node */
    goto llvm_cbe_bb153_2e_i_2e_i867;
  } else {
    goto llvm_cbe_bb29_2e_i_2e_i821;
  }

llvm_cbe_bb127_2e_i_2e_i:
  llvm_cbe_tmp130_2e_i_2e_i856 = *llvm_cbe_tmp66_2e_i_2e_i794;
  if ((llvm_fcmp_ogt((((float )(llvm_cbe_tmp130_2e_i_2e_i856 * llvm_cbe_tmp130_2e_i_2e_i856))), 0x1.e848p+15))) {
    goto llvm_cbe_bb138_2e_i_2e_i;
  } else {
    llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i141_2e_i_2e_i177517761777_2e_ins;   /* for PHI node */
    llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i101_2e_i_2e_i176117621763_2e_ins;   /* for PHI node */
    llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_0__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i_2e_i_2e_i770174717481749_2e_ins;   /* for PHI node */
    goto llvm_cbe_bb153_2e_i_2e_i867;
  }

llvm_cbe__Z7b2ClampIfET_S0_S0_S0__2e_exit327_2e_i_2e_i:
  llvm_cbe_storemerge_2e_i11_2e_i324_2e_i_2e_i = llvm_cbe_storemerge_2e_i11_2e_i324_2e_i_2e_i__PHI_TEMPORARY;
  *llvm_cbe_tmp66_2e_i_2e_i794 = (((float )(llvm_cbe_tmp79_2e_i_2e_i806 * llvm_cbe_storemerge_2e_i11_2e_i324_2e_i_2e_i)));
  if ((llvm_fcmp_ogt((((float )((((float )(llvm_cbe_tmp4_2e_i284_2e_i_2e_i * llvm_cbe_tmp4_2e_i284_2e_i_2e_i))) + (((float )(llvm_cbe_tmp11_2e_i291_2e_i_2e_i * llvm_cbe_tmp11_2e_i291_2e_i_2e_i)))))), 0x1.388p+15))) {
    goto llvm_cbe_bb121_2e_i_2e_i853;
  } else {
    goto llvm_cbe_bb127_2e_i_2e_i;
  }

llvm_cbe__Z5b2MinIfET_S0_S0__2e_exit_2e_i319_2e_i_2e_i:
  *(&llvm_cbe_storemerge_2e_i_2e_i313_2e_i_2e_i_2e_reg2mem) = llvm_cbe_tmp107_2e_i_2e_i840;
  if ((llvm_fcmp_olt(llvm_cbe_tmp107_2e_i_2e_i840, 0x0p+0))) {
    llvm_cbe_storemerge_2e_i11_2e_i324_2e_i_2e_i__PHI_TEMPORARY = 0x0p+0;   /* for PHI node */
    goto llvm_cbe__Z7b2ClampIfET_S0_S0_S0__2e_exit327_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb6_2e_i10_2e_i323_2e_i_2e_i;
  }

llvm_cbe__Z7b2ClampIfET_S0_S0_S0__2e_exit_2e_i_2e_i:
  llvm_cbe_storemerge_2e_i11_2e_i_2e_i_2e_i = llvm_cbe_storemerge_2e_i11_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp4_2e_i284_2e_i_2e_i = ((float )(llvm_cbe_tmp6_2e_i156_2e_i_2e_i * llvm_cbe_storemerge_2e_i11_2e_i_2e_i_2e_i));
  *llvm_cbe_tmp1_2e_i151_2e_i_2e_i = llvm_cbe_tmp4_2e_i284_2e_i_2e_i;
  llvm_cbe_tmp11_2e_i291_2e_i_2e_i = ((float )(llvm_cbe_tmp15_2e_i165_2e_i_2e_i * llvm_cbe_storemerge_2e_i11_2e_i_2e_i_2e_i));
  *llvm_cbe_tmp10_2e_i160_2e_i_2e_i = llvm_cbe_tmp11_2e_i291_2e_i_2e_i;
  llvm_cbe_tmp102_2e_i_2e_i835 = *llvm_cbe_tmp2;
  llvm_cbe_tmp105_2e_i_2e_i838 = *((&llvm_cbe_tmp25_2e_i114_2e_i->field20));
  llvm_cbe_tmp107_2e_i_2e_i840 = ((float )(0x1p+0 - (((float )(llvm_cbe_tmp102_2e_i_2e_i835 * llvm_cbe_tmp105_2e_i_2e_i838)))));
  if ((llvm_fcmp_olt(llvm_cbe_tmp107_2e_i_2e_i840, 0x1p+0))) {
    goto llvm_cbe__Z5b2MinIfET_S0_S0__2e_exit_2e_i319_2e_i_2e_i;
  } else {
    goto llvm_cbe__Z5b2MinIfET_S0_S0__2e_exit_2e_i319_2e_i_2e_i_2e_thread;
  }

llvm_cbe__Z5b2MinIfET_S0_S0__2e_exit_2e_i_2e_i_2e_i:
  *(&llvm_cbe_storemerge_2e_i_2e_i_2e_i_2e_i824_2e_reg2mem) = llvm_cbe_tmp93_2e_i_2e_i820;
  if ((llvm_fcmp_olt(llvm_cbe_tmp93_2e_i_2e_i820, 0x0p+0))) {
    llvm_cbe_storemerge_2e_i11_2e_i_2e_i_2e_i__PHI_TEMPORARY = 0x0p+0;   /* for PHI node */
    goto llvm_cbe__Z7b2ClampIfET_S0_S0_S0__2e_exit_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb6_2e_i10_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb29_2e_i_2e_i821:
  llvm_cbe_tmp34_2e_i_2e_i756 = *((&llvm_cbe_tmp25_2e_i114_2e_i->field16));
  llvm_cbe_tmp3_2e_i46_2e_i_2e_i = *((&llvm_cbe_tmp25_2e_i114_2e_i->field6.field1));
  llvm_cbe_tmp7_2e_i50_2e_i_2e_i = (&llvm_cbe_tmp25_2e_i114_2e_i->field6.field0);
  llvm_cbe_tmp8_2e_i51_2e_i_2e_i = *llvm_cbe_tmp7_2e_i50_2e_i_2e_i;
  llvm_cbe_tmp22_2e_i_2e_i_2e_i770174717481749_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp19_2e_i_2e_i_2e_i7671740__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp8_2e_i51_2e_i_2e_i * llvm_cbe_tmp34_2e_i_2e_i756))), llvm_cbe_tmp19_2e_i_2e_i_2e_i7671740__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp22_2e_i_2e_i_2e_i7701747__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp3_2e_i46_2e_i_2e_i * llvm_cbe_tmp34_2e_i_2e_i756))), llvm_cbe_tmp22_2e_i_2e_i_2e_i7701747__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp3_2e_i72_2e_i_2e_i = *llvm_cbe_tmp2_2e_i71_2e_i_2e_i;
  llvm_cbe_tmp10_2e_i79_2e_i_2e_i = *llvm_cbe_tmp9_2e_i78_2e_i_2e_i;
  llvm_cbe_tmp26_2e_i101_2e_i_2e_i176117621763_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i98_2e_i_2e_i1754__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp10_2e_i79_2e_i_2e_i + ((llvm_cbe_tmp39_2e_i121_2e_i1710__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp22_2e_i_2e_i_2e_i770174717481749_2e_ins)), llvm_cbe_tmp39_2e_i121_2e_i1710__BITCAST_TEMPORARY.Float))))), llvm_cbe_tmp23_2e_i98_2e_i_2e_i1754__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i101_2e_i_2e_i1761__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp3_2e_i72_2e_i_2e_i + ((llvm_cbe_tmp42_2e_i123_2e_i1714__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp22_2e_i_2e_i_2e_i770174717481749_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp42_2e_i123_2e_i1714__BITCAST_TEMPORARY.Float))))), llvm_cbe_tmp26_2e_i101_2e_i_2e_i1761__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp54_2e_i131_2e_i = *llvm_cbe_tmp2;
  llvm_cbe_tmp22_2e_i141_2e_i_2e_i177517761777_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp19_2e_i138_2e_i_2e_i1768__BITCAST_TEMPORARY.Float = (((float )(((llvm_cbe_tmp48_2e_i126_2e_i1717__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i101_2e_i_2e_i176117621763_2e_ins)), llvm_cbe_tmp48_2e_i126_2e_i1717__BITCAST_TEMPORARY.Float)) * llvm_cbe_tmp54_2e_i131_2e_i))), llvm_cbe_tmp19_2e_i138_2e_i_2e_i1768__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp22_2e_i141_2e_i_2e_i1775__BITCAST_TEMPORARY.Float = (((float )(((llvm_cbe_tmp51_2e_i_2e_i7841721__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i101_2e_i_2e_i176117621763_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp51_2e_i_2e_i7841721__BITCAST_TEMPORARY.Float)) * llvm_cbe_tmp54_2e_i131_2e_i))), llvm_cbe_tmp22_2e_i141_2e_i_2e_i1775__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp64_2e_i_2e_i792 = (&llvm_cbe_tmp25_2e_i114_2e_i->field4);
  llvm_cbe_tmp1_2e_i151_2e_i_2e_i = (&llvm_cbe_tmp25_2e_i114_2e_i->field4.field0);
  llvm_cbe_tmp2_2e_i152_2e_i_2e_i = *llvm_cbe_tmp1_2e_i151_2e_i_2e_i;
  llvm_cbe_tmp6_2e_i156_2e_i_2e_i = ((float )(llvm_cbe_tmp2_2e_i152_2e_i_2e_i + ((llvm_cbe_tmp59_2e_i_2e_i7871724__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp22_2e_i141_2e_i_2e_i177517761777_2e_ins)), llvm_cbe_tmp59_2e_i_2e_i7871724__BITCAST_TEMPORARY.Float))));
  *llvm_cbe_tmp1_2e_i151_2e_i_2e_i = llvm_cbe_tmp6_2e_i156_2e_i_2e_i;
  llvm_cbe_tmp10_2e_i160_2e_i_2e_i = (&llvm_cbe_tmp25_2e_i114_2e_i->field4.field1);
  llvm_cbe_tmp11_2e_i161_2e_i_2e_i = *llvm_cbe_tmp10_2e_i160_2e_i_2e_i;
  llvm_cbe_tmp15_2e_i165_2e_i_2e_i = ((float )(llvm_cbe_tmp11_2e_i161_2e_i_2e_i + ((llvm_cbe_tmp62_2e_i_2e_i7901728__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp22_2e_i141_2e_i_2e_i177517761777_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp62_2e_i_2e_i7901728__BITCAST_TEMPORARY.Float))));
  *llvm_cbe_tmp10_2e_i160_2e_i_2e_i = llvm_cbe_tmp15_2e_i165_2e_i_2e_i;
  llvm_cbe_tmp66_2e_i_2e_i794 = (&llvm_cbe_tmp25_2e_i114_2e_i->field5);
  llvm_cbe_tmp67_2e_i_2e_i795 = *llvm_cbe_tmp66_2e_i_2e_i794;
  llvm_cbe_tmp70_2e_i_2e_i798 = *llvm_cbe_tmp2;
  llvm_cbe_tmp73_2e_i_2e_i801 = *((&llvm_cbe_tmp25_2e_i114_2e_i->field18));
  llvm_cbe_tmp76_2e_i_2e_i804 = (&llvm_cbe_tmp25_2e_i114_2e_i->field7);
  llvm_cbe_tmp77_2e_i_2e_i = *llvm_cbe_tmp76_2e_i_2e_i804;
  llvm_cbe_tmp79_2e_i_2e_i806 = ((float )(llvm_cbe_tmp67_2e_i_2e_i795 + (((float )((((float )(llvm_cbe_tmp70_2e_i_2e_i798 * llvm_cbe_tmp73_2e_i_2e_i801))) * llvm_cbe_tmp77_2e_i_2e_i)))));
  *llvm_cbe_tmp66_2e_i_2e_i794 = llvm_cbe_tmp79_2e_i_2e_i806;
  *llvm_cbe_tmp7_2e_i50_2e_i_2e_i = 0x0p+0;
  *((&llvm_cbe_tmp25_2e_i114_2e_i->field6.field1)) = 0x0p+0;
  *llvm_cbe_tmp76_2e_i_2e_i804 = 0x0p+0;
  llvm_cbe_tmp88_2e_i_2e_i815 = *llvm_cbe_tmp2;
  llvm_cbe_tmp91_2e_i_2e_i818 = *((&llvm_cbe_tmp25_2e_i114_2e_i->field19));
  llvm_cbe_tmp93_2e_i_2e_i820 = ((float )(0x1p+0 - (((float )(llvm_cbe_tmp88_2e_i_2e_i815 * llvm_cbe_tmp91_2e_i_2e_i818)))));
  if ((llvm_fcmp_olt(llvm_cbe_tmp93_2e_i_2e_i820, 0x1p+0))) {
    goto llvm_cbe__Z5b2MinIfET_S0_S0__2e_exit_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe__Z5b2MinIfET_S0_S0__2e_exit_2e_i_2e_i_2e_i_2e_thread;
  }

llvm_cbe_bb6_2e_i10_2e_i_2e_i_2e_i:
  llvm_cbe_storemerge_2e_i_2e_i_2e_i_2e_i824_2e_reload2153 = *(&llvm_cbe_storemerge_2e_i_2e_i_2e_i_2e_i824_2e_reg2mem);
  llvm_cbe_storemerge_2e_i11_2e_i_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_storemerge_2e_i_2e_i_2e_i_2e_i824_2e_reload2153;   /* for PHI node */
  goto llvm_cbe__Z7b2ClampIfET_S0_S0_S0__2e_exit_2e_i_2e_i;

llvm_cbe__Z5b2MinIfET_S0_S0__2e_exit_2e_i_2e_i_2e_i_2e_thread:
  *(&llvm_cbe_storemerge_2e_i_2e_i_2e_i_2e_i824_2e_reg2mem) = 0x1p+0;
  goto llvm_cbe_bb6_2e_i10_2e_i_2e_i_2e_i;

llvm_cbe_bb6_2e_i10_2e_i323_2e_i_2e_i:
  llvm_cbe_storemerge_2e_i_2e_i313_2e_i_2e_i_2e_reload2156 = *(&llvm_cbe_storemerge_2e_i_2e_i313_2e_i_2e_i_2e_reg2mem);
  llvm_cbe_storemerge_2e_i11_2e_i324_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_storemerge_2e_i_2e_i313_2e_i_2e_i_2e_reload2156;   /* for PHI node */
  goto llvm_cbe__Z7b2ClampIfET_S0_S0_S0__2e_exit327_2e_i_2e_i;

llvm_cbe__Z5b2MinIfET_S0_S0__2e_exit_2e_i319_2e_i_2e_i_2e_thread:
  *(&llvm_cbe_storemerge_2e_i_2e_i313_2e_i_2e_i_2e_reg2mem) = 0x1p+0;
  goto llvm_cbe_bb6_2e_i10_2e_i323_2e_i_2e_i;

llvm_cbe_bb121_2e_i_2e_i853:
  llvm_cbe_tmp124_2e_i_2e_i850 = _ZN6b2Vec29NormalizeEv(llvm_cbe_tmp64_2e_i_2e_i792);
  llvm_cbe_tmp2_2e_i412_2e_i_2e_i = *llvm_cbe_tmp1_2e_i151_2e_i_2e_i;
  *llvm_cbe_tmp1_2e_i151_2e_i_2e_i = (((float )(llvm_cbe_tmp2_2e_i412_2e_i_2e_i * 0x1.9p+7)));
  llvm_cbe_tmp9_2e_i419_2e_i_2e_i = *llvm_cbe_tmp10_2e_i160_2e_i_2e_i;
  *llvm_cbe_tmp10_2e_i160_2e_i_2e_i = (((float )(llvm_cbe_tmp9_2e_i419_2e_i_2e_i * 0x1.9p+7)));
  goto llvm_cbe_bb127_2e_i_2e_i;

llvm_cbe_bb145_2e_i_2e_i:
  *llvm_cbe_tmp66_2e_i_2e_i794 = -0x1.f4p+7;
  llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i141_2e_i_2e_i177517761777_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i101_2e_i_2e_i176117621763_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_0__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i_2e_i_2e_i770174717481749_2e_ins;   /* for PHI node */
  goto llvm_cbe_bb153_2e_i_2e_i867;

llvm_cbe_bb138_2e_i_2e_i:
  if ((llvm_fcmp_olt(llvm_cbe_tmp130_2e_i_2e_i856, 0x0p+0))) {
    goto llvm_cbe_bb145_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb150_2e_i_2e_i;
  }

llvm_cbe_bb150_2e_i_2e_i:
  *llvm_cbe_tmp66_2e_i_2e_i794 = 0x1.f4p+7;
  llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i141_2e_i_2e_i177517761777_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i101_2e_i_2e_i176117621763_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_0__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i_2e_i_2e_i770174717481749_2e_ins;   /* for PHI node */
  goto llvm_cbe_bb153_2e_i_2e_i867;

  } while (1); /* end of syntactic loop 'bb156.i.i' */
llvm_cbe_bb281_2e_i:
  llvm_cbe_tmp284_2e_i741 = *llvm_cbe_tmp283_2e_i740;
  llvm_cbe_tmp288_2e_i = *llvm_cbe_tmp22;
  llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i109_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i65_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i43_2e_i_2e_i479_2e_3;   /* for PHI node */
  llvm_cbe_storemerge_2e_i132_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb156_2e_i_2e_i;

  do {     /* Syntactic loop 'bb113.i' to make GCC happy */
llvm_cbe_bb113_2e_i:
  llvm_cbe_stackCount_2e_i513_2e_0_2e_reload = *(&llvm_cbe_stackCount_2e_i513_2e_0_2e_reg2mem);
  llvm_cbe_tmp115_2e_i = llvm_cbe_stackCount_2e_i513_2e_0_2e_reload + 4294967295u;
  llvm_cbe_tmp120_2e_i = *((&llvm_cbe_tmp8081_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_tmp115_2e_i)))]));
  llvm_cbe_tmp2_2e_i72_2e_i = *llvm_cbe_tmp10_2e_i_2e_i545;
  llvm_cbe_tmp5_2e_i75_2e_i = *llvm_cbe_tmp1_2e_i_2e_i536;
  if ((((signed int )llvm_cbe_tmp2_2e_i72_2e_i) < ((signed int )llvm_cbe_tmp5_2e_i75_2e_i))) {
    goto llvm_cbe__ZN8b2Island3AddEP6b2Body_2e_exit_2e_i653;
  } else {
    goto llvm_cbe_bb_2e_i_2e_i643;
  }

llvm_cbe_bb276_2e_i:
  llvm_cbe_stackCount_2e_i513_2e_0_2e_be = llvm_cbe_stackCount_2e_i513_2e_0_2e_be__PHI_TEMPORARY;
  *(&llvm_cbe_stackCount_2e_i513_2e_0_2e_reg2mem) = llvm_cbe_stackCount_2e_i513_2e_0_2e_be;
  if ((((signed int )llvm_cbe_stackCount_2e_i513_2e_0_2e_be) > ((signed int )0u))) {
    goto llvm_cbe_bb113_2e_i;
  } else {
    goto llvm_cbe_bb281_2e_i;
  }

llvm_cbe__ZN8b2Island3AddEP6b2Body_2e_exit_2e_i653:
  llvm_cbe_tmp14_2e_i79_2e_i = *llvm_cbe_tmp31_2e_i_2e_i564;
  *((&llvm_cbe_tmp14_2e_i79_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_tmp2_2e_i72_2e_i)))])) = llvm_cbe_tmp120_2e_i;
  *llvm_cbe_tmp10_2e_i_2e_i545 = (llvm_cbe_tmp2_2e_i72_2e_i + 1u);
  llvm_cbe_tmp123_2e_i648 = (&llvm_cbe_tmp120_2e_i->field0);
  llvm_cbe_tmp124_2e_i649 = *llvm_cbe_tmp123_2e_i648;
  *llvm_cbe_tmp123_2e_i648 = (((unsigned short )(llvm_cbe_tmp124_2e_i649 & ((unsigned short )-9))));
  llvm_cbe_tmp3_2e_i184_2e_i = *((&llvm_cbe_tmp120_2e_i->field1));
  if ((llvm_cbe_tmp3_2e_i184_2e_i == ((unsigned short )0))) {
    llvm_cbe_stackCount_2e_i513_2e_0_2e_be__PHI_TEMPORARY = llvm_cbe_tmp115_2e_i;   /* for PHI node */
    goto llvm_cbe_bb276_2e_i;
  } else {
    goto llvm_cbe_bb132_2e_i656;
  }

  do {     /* Syntactic loop 'bb271.i' to make GCC happy */
llvm_cbe_bb271_2e_i:
  llvm_cbe_stackCount_2e_i513_2e_4 = llvm_cbe_stackCount_2e_i513_2e_4__PHI_TEMPORARY;
  llvm_cbe_storemerge4_2e_in_2e_i734 = llvm_cbe_storemerge4_2e_in_2e_i734__PHI_TEMPORARY;
  llvm_cbe_storemerge4_2e_i735 = *llvm_cbe_storemerge4_2e_in_2e_i734;
  if ((llvm_cbe_storemerge4_2e_i735 == ((struct l_struct_2E_b2JointEdge *)/*NULL*/0))) {
    llvm_cbe_stackCount_2e_i513_2e_0_2e_be__PHI_TEMPORARY = llvm_cbe_stackCount_2e_i513_2e_4;   /* for PHI node */
    goto llvm_cbe_bb276_2e_i;
  } else {
    goto llvm_cbe_bb217_2e_i;
  }

llvm_cbe_bb267_2e_i:
  llvm_cbe_stackCount_2e_i513_2e_3 = llvm_cbe_stackCount_2e_i513_2e_3__PHI_TEMPORARY;
  llvm_cbe_tmp269_2e_i733 = (&llvm_cbe_storemerge4_2e_i735->field3);
  llvm_cbe_stackCount_2e_i513_2e_4__PHI_TEMPORARY = llvm_cbe_stackCount_2e_i513_2e_3;   /* for PHI node */
  llvm_cbe_storemerge4_2e_in_2e_i734__PHI_TEMPORARY = llvm_cbe_tmp269_2e_i733;   /* for PHI node */
  goto llvm_cbe_bb271_2e_i;

llvm_cbe_bb217_2e_i:
  llvm_cbe_tmp219_2e_i699 = (&llvm_cbe_storemerge4_2e_i735->field1);
  llvm_cbe_tmp220_2e_i700 = *llvm_cbe_tmp219_2e_i699;
  llvm_cbe_tmp222_2e_i702 = *((&llvm_cbe_tmp220_2e_i700->field9));
  if ((llvm_cbe_tmp222_2e_i702 == ((unsigned char )0))) {
    goto llvm_cbe_bb224_2e_i;
  } else {
    llvm_cbe_stackCount_2e_i513_2e_3__PHI_TEMPORARY = llvm_cbe_stackCount_2e_i513_2e_4;   /* for PHI node */
    goto llvm_cbe_bb267_2e_i;
  }

llvm_cbe__ZN8b2Island3AddEP7b2Joint_2e_exit_2e_i:
  llvm_cbe_tmp14_2e_i147_2e_i = *llvm_cbe_tmp53_2e_i_2e_i582;
  *((&llvm_cbe_tmp14_2e_i147_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_tmp2_2e_i139_2e_i)))])) = llvm_cbe_tmp220_2e_i700;
  *llvm_cbe_tmp14_2e_i_2e_i549 = (llvm_cbe_tmp2_2e_i139_2e_i + 1u);
  llvm_cbe_tmp230_2e_i712 = *llvm_cbe_tmp219_2e_i699;
  *((&llvm_cbe_tmp230_2e_i712->field9)) = ((unsigned char )1);
  llvm_cbe_tmp234_2e_i = *((&llvm_cbe_storemerge4_2e_i735->field0));
  llvm_cbe_tmp236_2e_i716 = (&llvm_cbe_tmp234_2e_i->field0);
  llvm_cbe_tmp237_2e_i717 = *llvm_cbe_tmp236_2e_i716;
  if ((((((unsigned int )(unsigned short )llvm_cbe_tmp237_2e_i717)) & 4u) == 0u)) {
    goto llvm_cbe_bb243_2e_i;
  } else {
    llvm_cbe_stackCount_2e_i513_2e_3__PHI_TEMPORARY = llvm_cbe_stackCount_2e_i513_2e_4;   /* for PHI node */
    goto llvm_cbe_bb267_2e_i;
  }

llvm_cbe_bb224_2e_i:
  llvm_cbe_tmp2_2e_i139_2e_i = *llvm_cbe_tmp14_2e_i_2e_i549;
  llvm_cbe_tmp5_2e_i142_2e_i = *llvm_cbe_tmp7_2e_i_2e_i542;
  if ((((signed int )llvm_cbe_tmp2_2e_i139_2e_i) < ((signed int )llvm_cbe_tmp5_2e_i142_2e_i))) {
    goto llvm_cbe__ZN8b2Island3AddEP7b2Joint_2e_exit_2e_i;
  } else {
    goto llvm_cbe_bb_2e_i144_2e_i;
  }

llvm_cbe_bb253_2e_i732:
  *((&llvm_cbe_tmp8081_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_stackCount_2e_i513_2e_4)))])) = llvm_cbe_tmp234_2e_i;
  llvm_cbe_tmp260_2e_i728 = llvm_cbe_stackCount_2e_i513_2e_4 + 1u;
  llvm_cbe_tmp263_2e_i = *llvm_cbe_tmp236_2e_i716;
  *llvm_cbe_tmp236_2e_i716 = (((unsigned short )(llvm_cbe_tmp263_2e_i | ((unsigned short )4))));
  llvm_cbe_stackCount_2e_i513_2e_3__PHI_TEMPORARY = llvm_cbe_tmp260_2e_i728;   /* for PHI node */
  goto llvm_cbe_bb267_2e_i;

llvm_cbe_bb243_2e_i:
  if ((((signed int )llvm_cbe_stackCount_2e_i513_2e_4) < ((signed int )llvm_cbe_tmp73_2e_i619))) {
    goto llvm_cbe_bb253_2e_i732;
  } else {
    goto llvm_cbe_bb249_2e_i;
  }

  } while (1); /* end of syntactic loop 'bb271.i' */
llvm_cbe_bb213_2e_i:
  llvm_cbe_tmp215_2e_i697 = (&llvm_cbe_tmp120_2e_i->field13);
  llvm_cbe_stackCount_2e_i513_2e_4__PHI_TEMPORARY = llvm_cbe_stackCount_2e_i513_2e_2;   /* for PHI node */
  llvm_cbe_storemerge4_2e_in_2e_i734__PHI_TEMPORARY = llvm_cbe_tmp215_2e_i697;   /* for PHI node */
  goto llvm_cbe_bb271_2e_i;

  do {     /* Syntactic loop 'bb208.i' to make GCC happy */
llvm_cbe_bb208_2e_i:
  llvm_cbe_stackCount_2e_i513_2e_2 = llvm_cbe_stackCount_2e_i513_2e_2__PHI_TEMPORARY;
  llvm_cbe_storemerge3_2e_in_2e_i693 = llvm_cbe_storemerge3_2e_in_2e_i693__PHI_TEMPORARY;
  llvm_cbe_storemerge3_2e_i694 = *llvm_cbe_storemerge3_2e_in_2e_i693;
  if ((llvm_cbe_storemerge3_2e_i694 == ((struct l_struct_2E_b2ContactEdge *)/*NULL*/0))) {
    goto llvm_cbe_bb213_2e_i;
  } else {
    goto llvm_cbe_bb136_2e_i;
  }

llvm_cbe_bb204_2e_i:
  llvm_cbe_stackCount_2e_i513_2e_1 = llvm_cbe_stackCount_2e_i513_2e_1__PHI_TEMPORARY;
  llvm_cbe_tmp206_2e_i = (&llvm_cbe_storemerge3_2e_i694->field3);
  llvm_cbe_stackCount_2e_i513_2e_2__PHI_TEMPORARY = llvm_cbe_stackCount_2e_i513_2e_1;   /* for PHI node */
  llvm_cbe_storemerge3_2e_in_2e_i693__PHI_TEMPORARY = llvm_cbe_tmp206_2e_i;   /* for PHI node */
  goto llvm_cbe_bb208_2e_i;

llvm_cbe_bb136_2e_i:
  llvm_cbe_tmp138_2e_i657 = (&llvm_cbe_storemerge3_2e_i694->field1);
  llvm_cbe_tmp139_2e_i = *llvm_cbe_tmp138_2e_i657;
  llvm_cbe_tmp141_2e_i659 = *((&llvm_cbe_tmp139_2e_i->field1));
  if (((llvm_cbe_tmp141_2e_i659 & 5u) == 0u)) {
    goto llvm_cbe_bb146_2e_i665;
  } else {
    llvm_cbe_stackCount_2e_i513_2e_1__PHI_TEMPORARY = llvm_cbe_stackCount_2e_i513_2e_2;   /* for PHI node */
    goto llvm_cbe_bb204_2e_i;
  }

llvm_cbe_bb146_2e_i665:
  llvm_cbe_tmp3_2e_i180_2e_i = *((&llvm_cbe_tmp139_2e_i->field2));
  if ((llvm_cbe_tmp3_2e_i180_2e_i == 0u)) {
    llvm_cbe_stackCount_2e_i513_2e_1__PHI_TEMPORARY = llvm_cbe_stackCount_2e_i513_2e_2;   /* for PHI node */
    goto llvm_cbe_bb204_2e_i;
  } else {
    goto llvm_cbe_bb155_2e_i;
  }

llvm_cbe__ZN8b2Island3AddEP9b2Contact_2e_exit_2e_i680:
  llvm_cbe_tmp14_2e_i168_2e_i = *llvm_cbe_tmp42_2e_i_2e_i573;
  *((&llvm_cbe_tmp14_2e_i168_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_tmp2_2e_i160_2e_i)))])) = llvm_cbe_tmp139_2e_i;
  *llvm_cbe_tmp12_2e_i_2e_i547 = (llvm_cbe_tmp2_2e_i160_2e_i + 1u);
  llvm_cbe_tmp161_2e_i671 = *llvm_cbe_tmp138_2e_i657;
  llvm_cbe_tmp165_2e_i675 = (&llvm_cbe_tmp161_2e_i671->field1);
  llvm_cbe_tmp166_2e_i = *llvm_cbe_tmp165_2e_i675;
  *llvm_cbe_tmp165_2e_i675 = (llvm_cbe_tmp166_2e_i | 4u);
  llvm_cbe_tmp171_2e_i = *((&llvm_cbe_storemerge3_2e_i694->field0));
  llvm_cbe_tmp173_2e_i = (&llvm_cbe_tmp171_2e_i->field0);
  llvm_cbe_tmp174_2e_i = *llvm_cbe_tmp173_2e_i;
  if ((((((unsigned int )(unsigned short )llvm_cbe_tmp174_2e_i)) & 4u) == 0u)) {
    goto llvm_cbe_bb180_2e_i;
  } else {
    llvm_cbe_stackCount_2e_i513_2e_1__PHI_TEMPORARY = llvm_cbe_stackCount_2e_i513_2e_2;   /* for PHI node */
    goto llvm_cbe_bb204_2e_i;
  }

llvm_cbe_bb155_2e_i:
  llvm_cbe_tmp2_2e_i160_2e_i = *llvm_cbe_tmp12_2e_i_2e_i547;
  llvm_cbe_tmp5_2e_i163_2e_i = *llvm_cbe_tmp4_2e_i_2e_i539;
  if ((((signed int )llvm_cbe_tmp2_2e_i160_2e_i) < ((signed int )llvm_cbe_tmp5_2e_i163_2e_i))) {
    goto llvm_cbe__ZN8b2Island3AddEP9b2Contact_2e_exit_2e_i680;
  } else {
    goto llvm_cbe_bb_2e_i165_2e_i;
  }

llvm_cbe_bb190_2e_i:
  *((&llvm_cbe_tmp8081_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_stackCount_2e_i513_2e_2)))])) = llvm_cbe_tmp171_2e_i;
  llvm_cbe_tmp197_2e_i687 = llvm_cbe_stackCount_2e_i513_2e_2 + 1u;
  llvm_cbe_tmp200_2e_i = *llvm_cbe_tmp173_2e_i;
  *llvm_cbe_tmp173_2e_i = (((unsigned short )(llvm_cbe_tmp200_2e_i | ((unsigned short )4))));
  llvm_cbe_stackCount_2e_i513_2e_1__PHI_TEMPORARY = llvm_cbe_tmp197_2e_i687;   /* for PHI node */
  goto llvm_cbe_bb204_2e_i;

llvm_cbe_bb180_2e_i:
  if ((((signed int )llvm_cbe_stackCount_2e_i513_2e_2) < ((signed int )llvm_cbe_tmp73_2e_i619))) {
    goto llvm_cbe_bb190_2e_i;
  } else {
    goto llvm_cbe_bb186_2e_i;
  }

  } while (1); /* end of syntactic loop 'bb208.i' */
llvm_cbe_bb132_2e_i656:
  llvm_cbe_tmp134_2e_i655 = (&llvm_cbe_tmp120_2e_i->field14);
  llvm_cbe_stackCount_2e_i513_2e_2__PHI_TEMPORARY = llvm_cbe_tmp115_2e_i;   /* for PHI node */
  llvm_cbe_storemerge3_2e_in_2e_i693__PHI_TEMPORARY = llvm_cbe_tmp134_2e_i655;   /* for PHI node */
  goto llvm_cbe_bb208_2e_i;

  } while (1); /* end of syntactic loop 'bb113.i' */
llvm_cbe_bb99_2e_i640:
  *llvm_cbe_tmp10_2e_i_2e_i545 = 0u;
  *llvm_cbe_tmp12_2e_i_2e_i547 = 0u;
  *llvm_cbe_tmp14_2e_i_2e_i549 = 0u;
  *llvm_cbe_tmp8081_2e_i = llvm_cbe_storemerge6_2e_i1003;
  llvm_cbe_tmp109_2e_i = *llvm_cbe_tmp87_2e_i;
  *llvm_cbe_tmp87_2e_i = (((unsigned short )(llvm_cbe_tmp109_2e_i | ((unsigned short )4))));
  *(&llvm_cbe_stackCount_2e_i513_2e_0_2e_reg2mem) = 1u;
  goto llvm_cbe_bb113_2e_i;

  do {     /* Syntactic loop 'bb464.i.i' to make GCC happy */
llvm_cbe_bb464_2e_i_2e_i:
  llvm_cbe_storemerge = llvm_cbe_storemerge__PHI_TEMPORARY;
  llvm_cbe_tmp467_2e_i_2e_i_2e_rle = llvm_cbe_tmp467_2e_i_2e_i_2e_rle__PHI_TEMPORARY;
  *llvm_cbe_tmp55_2e_i_2e_i584 = llvm_cbe_storemerge;
  llvm_cbe_tmp470_2e_i_2e_i = *llvm_cbe_tmp4;
  if ((((signed int )llvm_cbe_tmp467_2e_i_2e_i_2e_rle) < ((signed int )llvm_cbe_tmp470_2e_i_2e_i))) {
    goto llvm_cbe_bb396_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb474_2e_i_2e_i;
  }

llvm_cbe_bb457_2e_i_2e_i:
  llvm_cbe_tmp460_2e_i_2e_i = *llvm_cbe_tmp55_2e_i_2e_i584;
  llvm_cbe_tmp461_2e_i_2e_i = llvm_cbe_tmp460_2e_i_2e_i + 1u;
  llvm_cbe_storemerge__PHI_TEMPORARY = llvm_cbe_tmp461_2e_i_2e_i;   /* for PHI node */
  llvm_cbe_tmp467_2e_i_2e_i_2e_rle__PHI_TEMPORARY = llvm_cbe_tmp461_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb464_2e_i_2e_i;

llvm_cbe_bb451_2e_i_2e_i:
  if (((((llvm_cbe_tmp398_2e_i_2e_i == ((unsigned char )0)) | (llvm_cbe_jointsOkay_2e_i_2e_i_2e_0 == ((unsigned char )0)))&1))) {
    goto llvm_cbe_bb457_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb474_2e_i_2e_i;
  }

  do {     /* Syntactic loop 'bb443.i.i' to make GCC happy */
llvm_cbe_bb443_2e_i_2e_i:
  llvm_cbe_jointsOkay_2e_i_2e_i_2e_0 = llvm_cbe_jointsOkay_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_storemerge14_2e_i_2e_i = llvm_cbe_storemerge14_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp446_2e_i_2e_i = *llvm_cbe_tmp14_2e_i_2e_i549;
  if ((((signed int )llvm_cbe_tmp446_2e_i_2e_i) > ((signed int )llvm_cbe_storemerge14_2e_i_2e_i))) {
    goto llvm_cbe_bb399_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb451_2e_i_2e_i;
  }

llvm_cbe_bb399_2e_i_2e_i:
  llvm_cbe_tmp409_2e_i_2e_i = *llvm_cbe_tmp53_2e_i_2e_i582;
  llvm_cbe_tmp413_2e_i_2e_i = *((&llvm_cbe_tmp409_2e_i_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge14_2e_i_2e_i)))]));
  llvm_cbe_tmp415_2e_i_2e_i = *((&llvm_cbe_tmp413_2e_i_2e_i->field0));
  llvm_cbe_tmp417_2e_i_2e_i = *((&llvm_cbe_tmp415_2e_i_2e_i[((signed long long )9ull)]));
  llvm_cbe_tmp427_2e_i_2e_i = (((unsigned char  (*) (struct l_struct_2E_b2Joint *))llvm_cbe_tmp417_2e_i_2e_i))(llvm_cbe_tmp413_2e_i_2e_i);
  llvm_cbe_storemerge13_2e_i_2e_i = ((unsigned char )((((unsigned char )(bool )((((llvm_cbe_jointsOkay_2e_i_2e_i_2e_0 == ((unsigned char )0)) | (llvm_cbe_tmp427_2e_i_2e_i == ((unsigned char )0)))&1)))) ^ ((unsigned char )1)));
  llvm_cbe_tmp442_2e_i_2e_i = llvm_cbe_storemerge14_2e_i_2e_i + 1u;
  llvm_cbe_jointsOkay_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_storemerge13_2e_i_2e_i;   /* for PHI node */
  llvm_cbe_storemerge14_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp442_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb443_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb443.i.i' */
llvm_cbe_bb396_2e_i_2e_i:
  llvm_cbe_tmp398_2e_i_2e_i = _ZN15b2ContactSolver24SolvePositionConstraintsEf((&llvm_cbe_contactSolver_2e_i_2e_i492), 0x1.99999ap-3);
  llvm_cbe_jointsOkay_2e_i_2e_i_2e_0__PHI_TEMPORARY = ((unsigned char )1);   /* for PHI node */
  llvm_cbe_storemerge14_2e_i_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb443_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb464.i.i' */
  do {     /* Syntactic loop 'bb385.i.i' to make GCC happy */
llvm_cbe_bb385_2e_i_2e_i:
  llvm_cbe_storemerge12_2e_i_2e_i = llvm_cbe_storemerge12_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp388_2e_i_2e_i = *llvm_cbe_tmp14_2e_i_2e_i549;
  if ((((signed int )llvm_cbe_tmp388_2e_i_2e_i) > ((signed int )llvm_cbe_storemerge12_2e_i_2e_i))) {
    goto llvm_cbe_bb355_2e_i_2e_i;
  } else {
    llvm_cbe_storemerge__PHI_TEMPORARY = 0u;   /* for PHI node */
    llvm_cbe_tmp467_2e_i_2e_i_2e_rle__PHI_TEMPORARY = 0u;   /* for PHI node */
    goto llvm_cbe_bb464_2e_i_2e_i;
  }

llvm_cbe_bb355_2e_i_2e_i:
  llvm_cbe_tmp365_2e_i_2e_i = *llvm_cbe_tmp53_2e_i_2e_i582;
  llvm_cbe_tmp369_2e_i_2e_i = *((&llvm_cbe_tmp365_2e_i_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge12_2e_i_2e_i)))]));
  llvm_cbe_tmp371_2e_i_2e_i = *((&llvm_cbe_tmp369_2e_i_2e_i->field0));
  llvm_cbe_tmp373_2e_i_2e_i = *((&llvm_cbe_tmp371_2e_i_2e_i[((signed long long )8ull)]));
  (((void  (*) (struct l_struct_2E_b2Joint *))llvm_cbe_tmp373_2e_i_2e_i))(llvm_cbe_tmp369_2e_i_2e_i);
  llvm_cbe_tmp384_2e_i_2e_i = llvm_cbe_storemerge12_2e_i_2e_i + 1u;
  llvm_cbe_storemerge12_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp384_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb385_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb385.i.i' */
llvm_cbe_bb572_2e_i_2e_i:
  if ((llvm_fcmp_ult(llvm_cbe_minSleepTime_2e_i_2e_i_2e_2, 0x1p-1))) {
    goto llvm_cbe__ZN8b2Island5SolveERK10b2TimeStepRK6b2Vec2bb_2e_exit_2e_i;
  } else {
    llvm_cbe_storemerge17_2e_i_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
    goto llvm_cbe_bb604_2e_i_2e_i;
  }

  do {     /* Syntactic loop 'bb564.i.i' to make GCC happy */
llvm_cbe_bb564_2e_i_2e_i:
  llvm_cbe_minSleepTime_2e_i_2e_i_2e_2 = llvm_cbe_minSleepTime_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_storemerge16_2e_i_2e_i = llvm_cbe_storemerge16_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp567_2e_i_2e_i = *llvm_cbe_tmp10_2e_i_2e_i545;
  if ((((signed int )llvm_cbe_tmp567_2e_i_2e_i) > ((signed int )llvm_cbe_storemerge16_2e_i_2e_i))) {
    goto llvm_cbe_bb482_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb572_2e_i_2e_i;
  }

llvm_cbe_bb561_2e_i_2e_i:
  llvm_cbe_minSleepTime_2e_i_2e_i_2e_1 = llvm_cbe_minSleepTime_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_tmp563_2e_i_2e_i = llvm_cbe_storemerge16_2e_i_2e_i + 1u;
  llvm_cbe_minSleepTime_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_minSleepTime_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_storemerge16_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp563_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb564_2e_i_2e_i;

llvm_cbe_bb482_2e_i_2e_i:
  llvm_cbe_tmp485_2e_i_2e_i = *llvm_cbe_tmp31_2e_i_2e_i564;
  llvm_cbe_tmp489_2e_i_2e_i = *((&llvm_cbe_tmp485_2e_i_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge16_2e_i_2e_i)))]));
  llvm_cbe_tmp492_2e_i_2e_i = *((&llvm_cbe_tmp489_2e_i_2e_i->field16));
  if ((llvm_fcmp_oeq(llvm_cbe_tmp492_2e_i_2e_i, 0x0p+0))) {
    llvm_cbe_minSleepTime_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_minSleepTime_2e_i_2e_i_2e_2;   /* for PHI node */
    goto llvm_cbe_bb561_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb496_2e_i_2e_i;
  }

llvm_cbe_bb543_2e_i_2e_i:
  *((&llvm_cbe_tmp489_2e_i_2e_i->field21)) = 0x0p+0;
  llvm_cbe_minSleepTime_2e_i_2e_i_2e_1__PHI_TEMPORARY = 0x0p+0;   /* for PHI node */
  goto llvm_cbe_bb561_2e_i_2e_i;

llvm_cbe_bb508_2e_i_2e_i:
  llvm_cbe_minSleepTime_2e_i_2e_i_2e_0 = llvm_cbe_minSleepTime_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  if ((((((unsigned int )(unsigned short )llvm_cbe_tmp499_2e_i_2e_i)) & 16u) == 0u)) {
    goto llvm_cbe_bb543_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb517_2e_i_2e_i;
  }

llvm_cbe_bb496_2e_i_2e_i:
  llvm_cbe_tmp499_2e_i_2e_i = *((&llvm_cbe_tmp489_2e_i_2e_i->field0));
  if ((((((unsigned int )(unsigned short )llvm_cbe_tmp499_2e_i_2e_i)) & 16u) == 0u)) {
    goto llvm_cbe_bb505_2e_i_2e_i;
  } else {
    llvm_cbe_minSleepTime_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_minSleepTime_2e_i_2e_i_2e_2;   /* for PHI node */
    goto llvm_cbe_bb508_2e_i_2e_i;
  }

llvm_cbe_bb505_2e_i_2e_i:
  *((&llvm_cbe_tmp489_2e_i_2e_i->field21)) = 0x0p+0;
  llvm_cbe_minSleepTime_2e_i_2e_i_2e_0__PHI_TEMPORARY = 0x0p+0;   /* for PHI node */
  goto llvm_cbe_bb508_2e_i_2e_i;

llvm_cbe_bb517_2e_i_2e_i:
  llvm_cbe_tmp520_2e_i_2e_i = *((&llvm_cbe_tmp489_2e_i_2e_i->field5));
  if ((llvm_fcmp_ogt((((float )(llvm_cbe_tmp520_2e_i_2e_i * llvm_cbe_tmp520_2e_i_2e_i))), 0x1.02e85cp-13))) {
    goto llvm_cbe_bb543_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb528_2e_i_2e_i;
  }

llvm_cbe_bb528_2e_i_2e_i:
  llvm_cbe_tmp3_2e_i38_2e_i_2e_i = *((&llvm_cbe_tmp489_2e_i_2e_i->field4.field0));
  llvm_cbe_tmp10_2e_i_2e_i_2e_i957 = *((&llvm_cbe_tmp489_2e_i_2e_i->field4.field1));
  if ((llvm_fcmp_ogt((((float )((((float )(llvm_cbe_tmp3_2e_i38_2e_i_2e_i * llvm_cbe_tmp3_2e_i38_2e_i_2e_i))) + (((float )(llvm_cbe_tmp10_2e_i_2e_i_2e_i957 * llvm_cbe_tmp10_2e_i_2e_i_2e_i957)))))), 0x1.a36e2ep-14))) {
    goto llvm_cbe_bb543_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb546_2e_i_2e_i;
  }

llvm_cbe_bb546_2e_i_2e_i:
  llvm_cbe_tmp548_2e_i_2e_i = (&llvm_cbe_tmp489_2e_i_2e_i->field21);
  llvm_cbe_tmp549_2e_i_2e_i = *llvm_cbe_tmp548_2e_i_2e_i;
  llvm_cbe_tmp552_2e_i_2e_i = *llvm_cbe_tmp2;
  llvm_cbe_tmp553_2e_i_2e_i = ((float )(llvm_cbe_tmp549_2e_i_2e_i + llvm_cbe_tmp552_2e_i_2e_i));
  *llvm_cbe_tmp548_2e_i_2e_i = llvm_cbe_tmp553_2e_i_2e_i;
  llvm_cbe_storemerge_2e_i_2e_i_2e_i968 = (((llvm_fcmp_olt(llvm_cbe_minSleepTime_2e_i_2e_i_2e_0, llvm_cbe_tmp553_2e_i_2e_i))) ? (llvm_cbe_minSleepTime_2e_i_2e_i_2e_0) : (llvm_cbe_tmp553_2e_i_2e_i));
  llvm_cbe_minSleepTime_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_storemerge_2e_i_2e_i_2e_i968;   /* for PHI node */
  goto llvm_cbe_bb561_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb564.i.i' */
  do {     /* Syntactic loop 'bb604.i.i' to make GCC happy */
llvm_cbe_bb604_2e_i_2e_i:
  llvm_cbe_storemerge17_2e_i_2e_i = llvm_cbe_storemerge17_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp607_2e_i_2e_i = *llvm_cbe_tmp10_2e_i_2e_i545;
  if ((((signed int )llvm_cbe_tmp607_2e_i_2e_i) > ((signed int )llvm_cbe_storemerge17_2e_i_2e_i))) {
    goto llvm_cbe_bb578_2e_i_2e_i;
  } else {
    goto llvm_cbe__ZN8b2Island5SolveERK10b2TimeStepRK6b2Vec2bb_2e_exit_2e_i;
  }

llvm_cbe_bb578_2e_i_2e_i:
  llvm_cbe_tmp581_2e_i_2e_i = *llvm_cbe_tmp31_2e_i_2e_i564;
  llvm_cbe_tmp585_2e_i_2e_i = *((&llvm_cbe_tmp581_2e_i_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge17_2e_i_2e_i)))]));
  llvm_cbe_tmp587_2e_i_2e_i = (&llvm_cbe_tmp585_2e_i_2e_i->field0);
  llvm_cbe_tmp588_2e_i_2e_i = *llvm_cbe_tmp587_2e_i_2e_i;
  *llvm_cbe_tmp587_2e_i_2e_i = (((unsigned short )(llvm_cbe_tmp588_2e_i_2e_i | ((unsigned short )8))));
  *((&llvm_cbe_tmp585_2e_i_2e_i->field4.field0)) = 0x0p+0;
  *((&llvm_cbe_tmp585_2e_i_2e_i->field4.field1)) = 0x0p+0;
  *((&llvm_cbe_tmp585_2e_i_2e_i->field5)) = 0x0p+0;
  llvm_cbe_tmp603_2e_i_2e_i = llvm_cbe_storemerge17_2e_i_2e_i + 1u;
  llvm_cbe_storemerge17_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp603_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb604_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb604.i.i' */
  } while (1); /* end of syntactic loop 'bb336.i' */
llvm_cbe_bb341_2e_i:
  _ZN16b2StackAllocator4FreeEPv(llvm_cbe_tmp10_2e_i, llvm_cbe_tmp80_2e_i622);
  llvm_cbe_tmp374_2e_i1020 = (&llvm_cbe_this->field15);
  llvm_cbe_storemerge7_2e_i1036_2e_in__PHI_TEMPORARY = llvm_cbe_tmp21_2e_i586;   /* for PHI node */
  goto llvm_cbe_bb399_2e_i;

  do {     /* Syntactic loop 'bb399.i' to make GCC happy */
llvm_cbe_bb399_2e_i:
  llvm_cbe_storemerge7_2e_i1036_2e_in = llvm_cbe_storemerge7_2e_i1036_2e_in__PHI_TEMPORARY;
  llvm_cbe_storemerge7_2e_i1036 = *llvm_cbe_storemerge7_2e_i1036_2e_in;
  if ((llvm_cbe_storemerge7_2e_i1036 == ((struct l_struct_2E_b2Body *)/*NULL*/0))) {
    goto llvm_cbe_bb404_2e_i;
  } else {
    goto llvm_cbe_bb350_2e_i;
  }

llvm_cbe_bb396_2e_i:
  llvm_cbe_tmp2_2e_i50_2e_i = (&llvm_cbe_storemerge7_2e_i1036->field10);
  llvm_cbe_storemerge7_2e_i1036_2e_in__PHI_TEMPORARY = llvm_cbe_tmp2_2e_i50_2e_i;   /* for PHI node */
  goto llvm_cbe_bb399_2e_i;

llvm_cbe_bb350_2e_i:
  llvm_cbe_tmp353_2e_i1012 = *((&llvm_cbe_storemerge7_2e_i1036->field0));
  if ((((((unsigned int )(unsigned short )llvm_cbe_tmp353_2e_i1012)) & 10u) == 0u)) {
    goto llvm_cbe_bb359_2e_i;
  } else {
    goto llvm_cbe_bb396_2e_i;
  }

llvm_cbe_bb359_2e_i:
  llvm_cbe_tmp3_2e_i64_2e_i = *((&llvm_cbe_storemerge7_2e_i1036->field1));
  if ((llvm_cbe_tmp3_2e_i64_2e_i == ((unsigned short )0))) {
    goto llvm_cbe_bb396_2e_i;
  } else {
    goto llvm_cbe_bb364_2e_i1018;
  }

llvm_cbe_bb364_2e_i1018:
  llvm_cbe_tmp367_2e_i1017 = _ZN6b2Body17SynchronizeShapesEv(llvm_cbe_storemerge7_2e_i1036);
  if ((llvm_cbe_tmp367_2e_i1017 == ((unsigned char )0))) {
    goto llvm_cbe_bb372_2e_i;
  } else {
    goto llvm_cbe_bb396_2e_i;
  }

llvm_cbe_bb372_2e_i:
  llvm_cbe_tmp375_2e_i1021 = *llvm_cbe_tmp374_2e_i1020;
  if ((llvm_cbe_tmp375_2e_i1021 == ((struct l_struct_2E_Os *)/*NULL*/0))) {
    goto llvm_cbe_bb396_2e_i;
  } else {
    goto llvm_cbe_bb379_2e_i;
  }

llvm_cbe_bb379_2e_i:
  llvm_cbe_tmp387_2e_i1027 = *((&llvm_cbe_tmp375_2e_i1021->field0));
  llvm_cbe_tmp389_2e_i1029 = *((&llvm_cbe_tmp387_2e_i1027[((signed long long )2ull)]));
  (((void  (*) (struct l_struct_2E_Os *, struct l_struct_2E_b2Body *))llvm_cbe_tmp389_2e_i1029))(llvm_cbe_tmp375_2e_i1021, llvm_cbe_storemerge7_2e_i1036);
  goto llvm_cbe_bb396_2e_i;

  } while (1); /* end of syntactic loop 'bb399.i' */
llvm_cbe_bb404_2e_i:
  llvm_cbe_tmp407_2e_i1039 = *((&llvm_cbe_this->field3));
  _ZN13b2PairManager6CommitEv(((&llvm_cbe_tmp407_2e_i1039->field0)));
  llvm_cbe_tmp2_2e_i30_2e_i = *llvm_cbe_tmp53_2e_i_2e_i582;
  llvm_cbe_tmp5_2e_i33_2e_i = *llvm_cbe_tmp16_2e_i_2e_i551;
  _ZN16b2StackAllocator4FreeEPv(llvm_cbe_tmp5_2e_i33_2e_i, (((unsigned char *)llvm_cbe_tmp2_2e_i30_2e_i)));
  llvm_cbe_tmp9_2e_i37_2e_i = *llvm_cbe_tmp42_2e_i_2e_i573;
  llvm_cbe_tmp12_2e_i40_2e_i = *llvm_cbe_tmp16_2e_i_2e_i551;
  _ZN16b2StackAllocator4FreeEPv(llvm_cbe_tmp12_2e_i40_2e_i, (((unsigned char *)llvm_cbe_tmp9_2e_i37_2e_i)));
  llvm_cbe_tmp16_2e_i44_2e_i = *llvm_cbe_tmp31_2e_i_2e_i564;
  llvm_cbe_tmp19_2e_i47_2e_i = *llvm_cbe_tmp16_2e_i_2e_i551;
  _ZN16b2StackAllocator4FreeEPv(llvm_cbe_tmp19_2e_i47_2e_i, (((unsigned char *)llvm_cbe_tmp16_2e_i44_2e_i)));
  goto llvm_cbe_bb38;

llvm_cbe_bb38:
  llvm_cbe_tmp41 = *((&llvm_cbe_this->field23));
  if ((llvm_cbe_tmp41 == ((unsigned char )0))) {
    goto llvm_cbe_bb51;
  } else {
    goto llvm_cbe_bb43;
  }

llvm_cbe_bb43:
  llvm_cbe_tmp45 = *llvm_cbe_tmp2;
  if ((llvm_fcmp_ogt(llvm_cbe_tmp45, 0x0p+0))) {
    goto llvm_cbe_bb49;
  } else {
    goto llvm_cbe_bb51;
  }

llvm_cbe_bb49:
  llvm_cbe_tmp11_2e_i49 = (&llvm_cbe_this->field17);
  llvm_cbe_tmp12_2e_i = *llvm_cbe_tmp11_2e_i49;
  llvm_cbe_tmp14_2e_i = (&llvm_cbe_this->field1);
  llvm_cbe_tmp16_2e_i50 = (&llvm_cbe_this->field8);
  llvm_cbe_tmp17_2e_i51 = *llvm_cbe_tmp16_2e_i50;
  llvm_cbe_tmp1_2e_i_2e_i53 = (&llvm_cbe_island_2e_i.field8);
  *llvm_cbe_tmp1_2e_i_2e_i53 = llvm_cbe_tmp17_2e_i51;
  llvm_cbe_tmp4_2e_i_2e_i56 = (&llvm_cbe_island_2e_i.field9);
  *llvm_cbe_tmp4_2e_i_2e_i56 = 32u;
  *((&llvm_cbe_island_2e_i.field10)) = 0u;
  llvm_cbe_tmp10_2e_i_2e_i62 = (&llvm_cbe_island_2e_i.field5);
  *llvm_cbe_tmp10_2e_i_2e_i62 = 0u;
  llvm_cbe_tmp12_2e_i_2e_i64 = (&llvm_cbe_island_2e_i.field7);
  *llvm_cbe_tmp12_2e_i_2e_i64 = 0u;
  llvm_cbe_tmp14_2e_i_2e_i66 = (&llvm_cbe_island_2e_i.field6);
  *llvm_cbe_tmp14_2e_i_2e_i66 = 0u;
  llvm_cbe_tmp16_2e_i_2e_i68 = (&llvm_cbe_island_2e_i.field0);
  *llvm_cbe_tmp16_2e_i_2e_i68 = llvm_cbe_tmp14_2e_i;
  *((&llvm_cbe_island_2e_i.field1)) = llvm_cbe_tmp12_2e_i;
  llvm_cbe_tmp28_2e_i_2e_i77 = _ZN16b2StackAllocator8AllocateEi(llvm_cbe_tmp14_2e_i, (llvm_cbe_tmp17_2e_i51 << 3u));
  llvm_cbe_tmp31_2e_i_2e_i79 = (&llvm_cbe_island_2e_i.field2);
  *llvm_cbe_tmp31_2e_i_2e_i79 = (((struct l_struct_2E_b2Body **)llvm_cbe_tmp28_2e_i_2e_i77));
  llvm_cbe_tmp38_2e_i_2e_i83 = *llvm_cbe_tmp16_2e_i_2e_i68;
  llvm_cbe_tmp39_2e_i_2e_i84 = _ZN16b2StackAllocator8AllocateEi(llvm_cbe_tmp38_2e_i_2e_i83, 256u);
  llvm_cbe_tmp42_2e_i_2e_i86 = (&llvm_cbe_island_2e_i.field3);
  *llvm_cbe_tmp42_2e_i_2e_i86 = (((struct l_struct_2E_b2Contact **)llvm_cbe_tmp39_2e_i_2e_i84));
  llvm_cbe_tmp49_2e_i_2e_i89 = *llvm_cbe_tmp16_2e_i_2e_i68;
  llvm_cbe_tmp50_2e_i_2e_i = _ZN16b2StackAllocator8AllocateEi(llvm_cbe_tmp49_2e_i_2e_i89, 0u);
  llvm_cbe_tmp53_2e_i_2e_i91 = (&llvm_cbe_island_2e_i.field4);
  *llvm_cbe_tmp53_2e_i_2e_i91 = (((struct l_struct_2E_b2Joint **)llvm_cbe_tmp50_2e_i_2e_i));
  *((&llvm_cbe_island_2e_i.field11)) = 0u;
  llvm_cbe_tmp20_2e_i96 = *llvm_cbe_tmp16_2e_i50;
  llvm_cbe_tmp27_2e_i = _ZN16b2StackAllocator8AllocateEi(llvm_cbe_tmp14_2e_i, (llvm_cbe_tmp20_2e_i96 << 3u));
  llvm_cbe_tmp2728_2e_i = ((struct l_struct_2E_b2Body **)llvm_cbe_tmp27_2e_i);
  llvm_cbe_tmp30_2e_i100 = (&llvm_cbe_this->field5);
  llvm_cbe_storemerge_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp30_2e_i100;   /* for PHI node */
  goto llvm_cbe_bb44_2e_i;

  do {     /* Syntactic loop 'bb44.i' to make GCC happy */
llvm_cbe_bb44_2e_i:
  llvm_cbe_storemerge_2e_in_2e_i = llvm_cbe_storemerge_2e_in_2e_i__PHI_TEMPORARY;
  llvm_cbe_storemerge_2e_i111 = *llvm_cbe_storemerge_2e_in_2e_i;
  if ((llvm_cbe_storemerge_2e_i111 == ((struct l_struct_2E_b2Body *)/*NULL*/0))) {
    goto llvm_cbe_bb48_2e_i;
  } else {
    goto llvm_cbe_bb_2e_i110;
  }

llvm_cbe_bb_2e_i110:
  llvm_cbe_tmp33_2e_i102 = (&llvm_cbe_storemerge_2e_i111->field0);
  llvm_cbe_tmp34_2e_i103 = *llvm_cbe_tmp33_2e_i102;
  *llvm_cbe_tmp33_2e_i102 = (((unsigned short )(llvm_cbe_tmp34_2e_i103 & ((unsigned short )-5))));
  *((&llvm_cbe_storemerge_2e_i111->field3.field5)) = 0x0p+0;
  llvm_cbe_tmp42_2e_i = (&llvm_cbe_storemerge_2e_i111->field10);
  llvm_cbe_storemerge_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp42_2e_i;   /* for PHI node */
  goto llvm_cbe_bb44_2e_i;

  } while (1); /* end of syntactic loop 'bb44.i' */
llvm_cbe_bb48_2e_i:
  llvm_cbe_tmp50_2e_i = (&llvm_cbe_this->field7);
  llvm_cbe_storemerge1_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp50_2e_i;   /* for PHI node */
  goto llvm_cbe_bb62_2e_i;

  do {     /* Syntactic loop 'bb62.i' to make GCC happy */
llvm_cbe_bb62_2e_i:
  llvm_cbe_storemerge1_2e_in_2e_i = llvm_cbe_storemerge1_2e_in_2e_i__PHI_TEMPORARY;
  llvm_cbe_storemerge1_2e_i115 = *llvm_cbe_storemerge1_2e_in_2e_i;
  if ((llvm_cbe_storemerge1_2e_i115 == ((struct l_struct_2E_b2Contact *)/*NULL*/0))) {
    goto llvm_cbe_bb67_2e_i_2e_loopexit;
  } else {
    goto llvm_cbe_bb52_2e_i;
  }

llvm_cbe_bb52_2e_i:
  llvm_cbe_tmp54_2e_i = (&llvm_cbe_storemerge1_2e_i115->field1);
  llvm_cbe_tmp55_2e_i = *llvm_cbe_tmp54_2e_i;
  *llvm_cbe_tmp54_2e_i = (llvm_cbe_tmp55_2e_i & 4294967283u);
  llvm_cbe_tmp60_2e_i114 = (&llvm_cbe_storemerge1_2e_i115->field4);
  llvm_cbe_storemerge1_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp60_2e_i114;   /* for PHI node */
  goto llvm_cbe_bb62_2e_i;

  } while (1); /* end of syntactic loop 'bb62.i' */
llvm_cbe_bb67_2e_i_2e_loopexit:
  llvm_cbe_tmp77_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_p1_2e_i_2e_i32.field0);
  llvm_cbe_tmp80_2e_i68_2e_i_2e_i_2e_i = (&llvm_cbe_p1_2e_i_2e_i32.field1);
  llvm_cbe_tmp95_2e_i79_2e_i_2e_i_2e_i = (&llvm_cbe_p2_2e_i_2e_i31.field0);
  llvm_cbe_tmp98_2e_i82_2e_i_2e_i_2e_i = (&llvm_cbe_p2_2e_i_2e_i31.field1);
  llvm_cbe_tmp21_2e_i_2e_i_2e_i_2e_i174 = (&llvm_cbe_p1s_2e_i_2e_i_2e_i_2e_i[((signed long long )0ull)]);
  llvm_cbe_tmp34_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_p2s_2e_i_2e_i_2e_i_2e_i[((signed long long )0ull)]);
  llvm_cbe_tmp49_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_points_2e_i_2e_i_2e_i_2e_i[((signed long long )0ull)]);
  llvm_cbe_tmp91_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_v_2e_i_2e_i_2e_i_2e_i24.field0);
  llvm_cbe_tmp94_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_v_2e_i_2e_i_2e_i_2e_i24.field1);
  llvm_cbe_tmp109_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_tmp7_2e_i_2e_i172_2e_i_2e_i.field0);
  llvm_cbe_tmp112_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_tmp7_2e_i_2e_i172_2e_i_2e_i.field1);
  llvm_cbe_tmp128_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_w_2e_i_2e_i_2e_i_2e_i.field0);
  llvm_cbe_tmp131_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_w_2e_i_2e_i_2e_i_2e_i.field1);
  llvm_cbe_tmp182_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_p1s_2e_i_2e_i_2e_i_2e_i[((signed int )0u)].field0);
  llvm_cbe_tmp185_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_p1s_2e_i_2e_i_2e_i_2e_i[((signed int )0u)].field1);
  llvm_cbe_tmp189_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_p2s_2e_i_2e_i_2e_i_2e_i[((signed int )0u)].field0);
  llvm_cbe_tmp192_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_p2s_2e_i_2e_i_2e_i_2e_i[((signed int )0u)].field1);
  llvm_cbe_tmp196_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_points_2e_i_2e_i_2e_i_2e_i[((signed int )0u)].field0);
  llvm_cbe_tmp199_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_points_2e_i_2e_i_2e_i_2e_i[((signed int )0u)].field1);
  llvm_cbe_tmp234_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_p1s_2e_i_2e_i_2e_i_2e_i[((signed long long )1ull)].field0);
  llvm_cbe_tmp237_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_p1s_2e_i_2e_i_2e_i_2e_i[((signed long long )1ull)].field1);
  llvm_cbe_tmp241_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_p2s_2e_i_2e_i_2e_i_2e_i[((signed long long )1ull)].field0);
  llvm_cbe_tmp244_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_p2s_2e_i_2e_i_2e_i_2e_i[((signed long long )1ull)].field1);
  llvm_cbe_tmp248_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_points_2e_i_2e_i_2e_i_2e_i[((signed long long )1ull)].field0);
  llvm_cbe_tmp251_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_points_2e_i_2e_i_2e_i_2e_i[((signed long long )1ull)].field1);
  llvm_cbe_tmp262_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_p1s_2e_i_2e_i_2e_i_2e_i[((signed long long )2ull)].field0);
  llvm_cbe_tmp265_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_p1s_2e_i_2e_i_2e_i_2e_i[((signed long long )2ull)].field1);
  llvm_cbe_tmp269_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_p2s_2e_i_2e_i_2e_i_2e_i[((signed long long )2ull)].field0);
  llvm_cbe_tmp272_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_p2s_2e_i_2e_i_2e_i_2e_i[((signed long long )2ull)].field1);
  llvm_cbe_tmp276_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_points_2e_i_2e_i_2e_i_2e_i[((signed long long )2ull)].field0);
  llvm_cbe_tmp279_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_points_2e_i_2e_i_2e_i_2e_i[((signed long long )2ull)].field1);
  llvm_cbe_tmp455_2e_i = (&llvm_cbe_subStep_2e_i.field0);
  llvm_cbe_tmp469_2e_i = (&llvm_cbe_subStep_2e_i.field1);
  llvm_cbe_tmp473_2e_i332 = (&llvm_cbe_subStep_2e_i.field3);
  llvm_cbe_tmp124_2e_i_2e_i = (&llvm_cbe_contactSolver_2e_i_2e_i.field2);
  llvm_cbe_tmp4_2e_i11_2e_i_2e_i = (&llvm_cbe_contactSolver_2e_i_2e_i.field1);
  llvm_cbe_tmp511_2e_i429 = (&llvm_cbe_this->field15);
  llvm_cbe_tmp591_2e_i456 = (&llvm_cbe_this->field3);
  goto llvm_cbe_bb67_2e_i;

  do {     /* Syntactic loop 'bb67.i' to make GCC happy */
llvm_cbe_bb67_2e_i:
  llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_5 = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_5 = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_6 = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_6 = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_6 = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_5 = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_6 = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_6 = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_6 = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_6 = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_5 = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_5 = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_6 = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_6 = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_6 = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_6;   /* for PHI node */
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_6;   /* for PHI node */
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_6;   /* for PHI node */
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_6;   /* for PHI node */
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_6;   /* for PHI node */
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_6;   /* for PHI node */
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_6;   /* for PHI node */
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_6;   /* for PHI node */
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_6;   /* for PHI node */
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_6;   /* for PHI node */
  llvm_cbe_minTOI_2e_i_2e_1__PHI_TEMPORARY = 0x1p+0;   /* for PHI node */
  llvm_cbe_minContact_2e_i_2e_1__PHI_TEMPORARY = ((struct l_struct_2E_b2Contact *)/*NULL*/0);   /* for PHI node */
  llvm_cbe_storemerge3_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp50_2e_i;   /* for PHI node */
  goto llvm_cbe_bb248_2e_i;

llvm_cbe_bb269_2e_i:
  llvm_cbe_tmp3_2e_i275_2e_i = *((&llvm_cbe_minContact_2e_i_2e_1->field7));
  llvm_cbe_tmp3_2e_i271_2e_i253 = *((&llvm_cbe_minContact_2e_i_2e_1->field8));
  llvm_cbe_tmp3_2e_i267_2e_i = *((&llvm_cbe_tmp3_2e_i275_2e_i->field3));
  llvm_cbe_tmp3_2e_i263_2e_i = *((&llvm_cbe_tmp3_2e_i271_2e_i253->field3));
  _ZN7b2Sweep7AdvanceEf(((&llvm_cbe_tmp3_2e_i267_2e_i->field3)), llvm_cbe_minTOI_2e_i_2e_1);
  llvm_cbe_tmp9_2e_i244_2e_i = *((&llvm_cbe_tmp3_2e_i267_2e_i->field3.field1.field0));
  llvm_cbe_tmp12_2e_i247_2e_i = *((&llvm_cbe_tmp3_2e_i267_2e_i->field3.field1.field1));
  *((&llvm_cbe_tmp3_2e_i267_2e_i->field3.field2.field0)) = llvm_cbe_tmp9_2e_i244_2e_i;
  *((&llvm_cbe_tmp3_2e_i267_2e_i->field3.field2.field1)) = llvm_cbe_tmp12_2e_i247_2e_i;
  llvm_cbe_tmp25_2e_i257_2e_i = *((&llvm_cbe_tmp3_2e_i267_2e_i->field3.field3));
  *((&llvm_cbe_tmp3_2e_i267_2e_i->field3.field4)) = llvm_cbe_tmp25_2e_i257_2e_i;
  _ZN6b2Body20SynchronizeTransformEv(llvm_cbe_tmp3_2e_i267_2e_i);
  _ZN7b2Sweep7AdvanceEf(((&llvm_cbe_tmp3_2e_i263_2e_i->field3)), llvm_cbe_minTOI_2e_i_2e_1);
  llvm_cbe_tmp9_2e_i218_2e_i = *((&llvm_cbe_tmp3_2e_i263_2e_i->field3.field1.field0));
  llvm_cbe_tmp12_2e_i221_2e_i = *((&llvm_cbe_tmp3_2e_i263_2e_i->field3.field1.field1));
  *((&llvm_cbe_tmp3_2e_i263_2e_i->field3.field2.field0)) = llvm_cbe_tmp9_2e_i218_2e_i;
  *((&llvm_cbe_tmp3_2e_i263_2e_i->field3.field2.field1)) = llvm_cbe_tmp12_2e_i221_2e_i;
  llvm_cbe_tmp25_2e_i231_2e_i = *((&llvm_cbe_tmp3_2e_i263_2e_i->field3.field3));
  *((&llvm_cbe_tmp3_2e_i263_2e_i->field3.field4)) = llvm_cbe_tmp25_2e_i231_2e_i;
  _ZN6b2Body20SynchronizeTransformEv(llvm_cbe_tmp3_2e_i263_2e_i);
  llvm_cbe_tmp286_2e_i = *llvm_cbe_tmp11_2e_i49;
  _ZN9b2Contact6UpdateEP17b2ContactListener(llvm_cbe_minContact_2e_i_2e_1, llvm_cbe_tmp286_2e_i);
  llvm_cbe_tmp290_2e_i259 = (&llvm_cbe_minContact_2e_i_2e_1->field1);
  llvm_cbe_tmp291_2e_i260 = *llvm_cbe_tmp290_2e_i259;
  *llvm_cbe_tmp290_2e_i259 = (llvm_cbe_tmp291_2e_i260 & 4294967287u);
  llvm_cbe_tmp3_2e_i203_2e_i = *((&llvm_cbe_minContact_2e_i_2e_1->field2));
  if ((llvm_cbe_tmp3_2e_i203_2e_i == 0u)) {
    llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    goto llvm_cbe_bb67_2e_i;
  } else {
    goto llvm_cbe_bb301_2e_i;
  }

llvm_cbe_bb253_2e_i:
  if (((((llvm_cbe_minContact_2e_i_2e_1 == ((struct l_struct_2E_b2Contact *)/*NULL*/0)) | (llvm_fcmp_ogt(llvm_cbe_minTOI_2e_i_2e_1, 0x1.fffe7p-1)))&1))) {
    goto llvm_cbe__ZN7b2World8SolveTOIERK10b2TimeStep_2e_exit;
  } else {
    goto llvm_cbe_bb269_2e_i;
  }

  do {     /* Syntactic loop 'bb248.i' to make GCC happy */
llvm_cbe_bb248_2e_i:
  llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_5 = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_5 = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_5 = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_5 = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_5 = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_5 = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_5 = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_5 = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_5 = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_5 = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY;
  llvm_cbe_minTOI_2e_i_2e_1 = llvm_cbe_minTOI_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_minContact_2e_i_2e_1 = llvm_cbe_minContact_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_storemerge3_2e_in_2e_i = llvm_cbe_storemerge3_2e_in_2e_i__PHI_TEMPORARY;
  llvm_cbe_storemerge3_2e_i = *llvm_cbe_storemerge3_2e_in_2e_i;
  if ((llvm_cbe_storemerge3_2e_i == ((struct l_struct_2E_b2Contact *)/*NULL*/0))) {
    goto llvm_cbe_bb253_2e_i;
  } else {
    goto llvm_cbe_bb71_2e_i;
  }

llvm_cbe_bb244_2e_i:
  llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_4 = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY;
  llvm_cbe_minTOI_2e_i_2e_0 = llvm_cbe_minTOI_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_minContact_2e_i_2e_0 = llvm_cbe_minContact_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp246_2e_i = (&llvm_cbe_storemerge3_2e_i->field4);
  llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_minTOI_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_minTOI_2e_i_2e_0;   /* for PHI node */
  llvm_cbe_minContact_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_minContact_2e_i_2e_0;   /* for PHI node */
  llvm_cbe_storemerge3_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp246_2e_i;   /* for PHI node */
  goto llvm_cbe_bb248_2e_i;

llvm_cbe_bb71_2e_i:
  llvm_cbe_tmp73_2e_i = (&llvm_cbe_storemerge3_2e_i->field1);
  llvm_cbe_tmp74_2e_i118 = *llvm_cbe_tmp73_2e_i;
  if (((llvm_cbe_tmp74_2e_i118 & 3u) == 0u)) {
    goto llvm_cbe_bb79_2e_i;
  } else {
    llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_minTOI_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_minTOI_2e_i_2e_1;   /* for PHI node */
    llvm_cbe_minContact_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_minContact_2e_i_2e_1;   /* for PHI node */
    goto llvm_cbe_bb244_2e_i;
  }

llvm_cbe_bb107_2e_i132:
  llvm_cbe_tmp3_2e_i430_2e_i = *((&llvm_cbe_tmp3_2e_i279_2e_i->field1));
  if ((llvm_cbe_tmp3_2e_i430_2e_i == ((unsigned short )0))) {
    llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_minTOI_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_minTOI_2e_i_2e_1;   /* for PHI node */
    llvm_cbe_minContact_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_minContact_2e_i_2e_1;   /* for PHI node */
    goto llvm_cbe_bb244_2e_i;
  } else {
    goto llvm_cbe_bb111_2e_i;
  }

llvm_cbe_bb91_2e_i:
  llvm_cbe_tmp2_2e_i51_2e_i = (&llvm_cbe_storemerge3_2e_i->field7);
  llvm_cbe_tmp3_2e_i52_2e_i = *llvm_cbe_tmp2_2e_i51_2e_i;
  llvm_cbe_tmp2_2e_i54_2e_i = (&llvm_cbe_storemerge3_2e_i->field8);
  llvm_cbe_tmp3_2e_i55_2e_i = *llvm_cbe_tmp2_2e_i54_2e_i;
  llvm_cbe_tmp3_2e_i207_2e_i = *((&llvm_cbe_tmp3_2e_i52_2e_i->field3));
  llvm_cbe_tmp3_2e_i279_2e_i = *((&llvm_cbe_tmp3_2e_i55_2e_i->field3));
  llvm_cbe_tmp3_2e_i410_2e_i = *((&llvm_cbe_tmp3_2e_i207_2e_i->field1));
  if ((llvm_cbe_tmp3_2e_i410_2e_i == ((unsigned short )0))) {
    goto llvm_cbe_bb107_2e_i132;
  } else {
    goto llvm_cbe_bb103_2e_i;
  }

llvm_cbe_bb79_2e_i:
  if (((llvm_cbe_tmp74_2e_i118 & 8u) == 0u)) {
    goto llvm_cbe_bb91_2e_i;
  } else {
    goto llvm_cbe_bb87_2e_i;
  }

llvm_cbe_bb103_2e_i:
  llvm_cbe_tmp3_2e_i417_2e_i = *((&llvm_cbe_tmp3_2e_i207_2e_i->field0));
  if ((((((unsigned int )(unsigned short )llvm_cbe_tmp3_2e_i417_2e_i)) & 8u) == 0u)) {
    goto llvm_cbe_bb121_2e_i141;
  } else {
    goto llvm_cbe_bb107_2e_i132;
  }

llvm_cbe_bb111_2e_i:
  llvm_cbe_tmp3_2e_i422_2e_i = *((&llvm_cbe_tmp3_2e_i279_2e_i->field0));
  if ((((((unsigned int )(unsigned short )llvm_cbe_tmp3_2e_i422_2e_i)) & 8u) == 0u)) {
    goto llvm_cbe_bb121_2e_i141;
  } else {
    llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
    llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
    llvm_cbe_minTOI_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_minTOI_2e_i_2e_1;   /* for PHI node */
    llvm_cbe_minContact_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_minContact_2e_i_2e_1;   /* for PHI node */
    goto llvm_cbe_bb244_2e_i;
  }

llvm_cbe_bb230_2e_i:
  llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_0 = llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_0 = llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_3 = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_toi_2e_i_2e_0 = llvm_cbe_toi_2e_i_2e_0__PHI_TEMPORARY;
  if (((((llvm_fcmp_ogt(llvm_cbe_toi_2e_i_2e_0, 0x1p-23)) & (llvm_fcmp_olt(llvm_cbe_toi_2e_i_2e_0, llvm_cbe_minTOI_2e_i_2e_1)))&1))) {
    goto llvm_cbe_bb241_2e_i;
  } else {
    llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_0;   /* for PHI node */
    llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_0;   /* for PHI node */
    llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_minTOI_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_minTOI_2e_i_2e_1;   /* for PHI node */
    llvm_cbe_minContact_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_minContact_2e_i_2e_1;   /* for PHI node */
    goto llvm_cbe_bb244_2e_i;
  }

llvm_cbe_bb87_2e_i:
  llvm_cbe_tmp90_2e_i123 = *((&llvm_cbe_storemerge3_2e_i->field11));
  llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_toi_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp90_2e_i123;   /* for PHI node */
  goto llvm_cbe_bb230_2e_i;

llvm_cbe_bb220_2e_i:
  llvm_cbe_toi_2e_i_2e_1 = llvm_cbe_toi_2e_i_2e_1__PHI_TEMPORARY;
  *((&llvm_cbe_storemerge3_2e_i->field11)) = llvm_cbe_toi_2e_i_2e_1;
  llvm_cbe_tmp226_2e_i238 = *llvm_cbe_tmp73_2e_i;
  *llvm_cbe_tmp73_2e_i = (llvm_cbe_tmp226_2e_i238 | 8u);
  llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_1_2e_reload = *(&llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_1_2e_reg2mem);
  llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_1_2e_reload = *(&llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_1_2e_reg2mem);
  llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_1_2e_reload;   /* for PHI node */
  llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i313_2e_i_2e_i170517061707_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i248_2e_i_2e_i169116921693_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_1_2e_reload;   /* for PHI node */
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_0;   /* for PHI node */
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_0;   /* for PHI node */
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_0;   /* for PHI node */
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_toi_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_toi_2e_i_2e_1;   /* for PHI node */
  goto llvm_cbe_bb230_2e_i;

llvm_cbe_bb202_2e_i:
  llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2163 = *(&llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reg2mem);
  llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2160 = *(&llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reg2mem);
  if ((llvm_fcmp_ogt(llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2163, 0x0p+0))) {
    goto llvm_cbe_bb207_2e_i;
  } else {
    llvm_cbe_toi_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2160;   /* for PHI node */
    goto llvm_cbe_bb220_2e_i;
  }

llvm_cbe_bb193_2e_i:
  llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2164 = *(&llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reg2mem);
  if ((llvm_fcmp_ugt(llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2164, 0x1p+0))) {
    goto llvm_cbe_bb198_2e_i;
  } else {
    goto llvm_cbe_bb202_2e_i;
  }

llvm_cbe__Z14b2TimeOfImpactPK7b2ShapeRK7b2SweepS1_S4__2e_exit_2e_i_2e_thread:
  *(&llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reg2mem) = 0x1p+0;
  *(&llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_1_2e_reg2mem) = llvm_cbe_tmp26_2e_i_2e_i392_2e_i134813491350_2e_ins;
  *(&llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_1_2e_reg2mem) = llvm_cbe_tmp26_2e_i146_2e_i_2e_i136213631364_2e_ins;
  goto llvm_cbe_bb193_2e_i;

  do {     /* Syntactic loop 'bb81.i.i' to make GCC happy */
llvm_cbe_bb81_2e_i_2e_i:
  llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_0 = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_0 = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_targetDistance_2e_i_2e_i_2e_1 = llvm_cbe_targetDistance_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_iter_2e_i_2e_i_2e_0 = llvm_cbe_iter_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_alpha_2e_i_2e_i_2e_1 = llvm_cbe_alpha_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_tmp87_2e_i359_2e_i = ((float )((((float )((((float )(0x1p+0 - llvm_cbe_alpha_2e_i_2e_i_2e_1))) * llvm_cbe_tmp12_2e_i311_2e_i))) + llvm_cbe_alpha_2e_i_2e_i_2e_1));
  _ZNK7b2Sweep8GetXFormEP7b2XFormf(llvm_cbe_tmp183_2e_i155, (&llvm_cbe_xf1_2e_i_2e_i30), llvm_cbe_tmp87_2e_i359_2e_i);
  _ZNK7b2Sweep8GetXFormEP7b2XFormf(llvm_cbe_tmp178_2e_i, (&llvm_cbe_xf2_2e_i_2e_i29), llvm_cbe_tmp87_2e_i359_2e_i);
  llvm_cbe_tmp3_2e_i_2e_i186_2e_i_2e_i = *llvm_cbe_tmp2_2e_i_2e_i185_2e_i_2e_i;
  llvm_cbe_tmp3_2e_i6_2e_i_2e_i_2e_i = *llvm_cbe_tmp2_2e_i5_2e_i_2e_i_2e_i;
  if (((((llvm_cbe_tmp3_2e_i_2e_i186_2e_i_2e_i == 0u) & (llvm_cbe_tmp3_2e_i6_2e_i_2e_i_2e_i == 0u))&1))) {
    goto llvm_cbe_bb12_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb22_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb184_2e_i_2e_i:
  llvm_cbe_tmp187_2e_i_2e_i228 = llvm_cbe_iter_2e_i_2e_i_2e_0 + 1u;
  llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i146_2e_i_2e_i136213631364_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i_2e_i392_2e_i134813491350_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_0;   /* for PHI node */
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_0;   /* for PHI node */
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_0;   /* for PHI node */
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_targetDistance_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_targetDistance_2e_i_2e_i_2e_0;   /* for PHI node */
  llvm_cbe_iter_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp187_2e_i_2e_i228;   /* for PHI node */
  llvm_cbe_alpha_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp166_2e_i_2e_i220;   /* for PHI node */
  goto llvm_cbe_bb81_2e_i_2e_i;

llvm_cbe_bb177_2e_i_2e_i:
  if ((llvm_fcmp_ogt((((float )(llvm_cbe_alpha_2e_i_2e_i_2e_1 * 0x1.0000c8p+0))), llvm_cbe_tmp166_2e_i_2e_i220))) {
    llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i146_2e_i_2e_i136213631364_2e_ins;   /* for PHI node */
    llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i_2e_i392_2e_i134813491350_2e_ins;   /* for PHI node */
    goto llvm_cbe__Z14b2TimeOfImpactPK7b2ShapeRK7b2SweepS1_S4__2e_exit_2e_i;
  } else {
    goto llvm_cbe_bb184_2e_i_2e_i;
  }

llvm_cbe_bb158_2e_i_2e_i:
  llvm_cbe_tmp166_2e_i_2e_i220 = ((float )(llvm_cbe_alpha_2e_i_2e_i_2e_1 + (((float )(llvm_cbe_tmp112_2e_i_2e_i / llvm_cbe_tmp150_2e_i_2e_i212)))));
  if (((((llvm_fcmp_olt(llvm_cbe_tmp166_2e_i_2e_i220, 0x0p+0)) | (llvm_fcmp_ogt(llvm_cbe_tmp166_2e_i_2e_i220, 0x1p+0)))&1))) {
    goto llvm_cbe__Z14b2TimeOfImpactPK7b2ShapeRK7b2SweepS1_S4__2e_exit_2e_i_2e_thread;
  } else {
    goto llvm_cbe_bb177_2e_i_2e_i;
  }

llvm_cbe__Z5b2Absf_2e_exit_2e_i_2e_i:
  llvm_cbe_storemerge_2e_i_2e_i_2e_i = llvm_cbe_storemerge_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  if ((llvm_fcmp_olt(llvm_cbe_storemerge_2e_i_2e_i_2e_i, 0x1p-23))) {
    goto llvm_cbe__Z14b2TimeOfImpactPK7b2ShapeRK7b2SweepS1_S4__2e_exit_2e_i_2e_thread;
  } else {
    goto llvm_cbe_bb158_2e_i_2e_i;
  }

llvm_cbe__ZN6b2Vec29NormalizeEv_2e_exit_2e_i_2e_i:
  llvm_cbe_normal_2e_i_2e_i_2e_0_2e_0 = llvm_cbe_normal_2e_i_2e_i_2e_0_2e_0__PHI_TEMPORARY;
  llvm_cbe_normal_2e_i_2e_i_2e_1_2e_0 = llvm_cbe_normal_2e_i_2e_i_2e_1_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp26_2e_i_2e_i392_2e_i134813491350_2e_ins = llvm_cbe_tmp23_2e_i_2e_i389_2e_i13411342 | llvm_cbe_tmp26_2e_i_2e_i392_2e_i134813491350;
  llvm_cbe_tmp150_2e_i_2e_i212 = ((float )((((float )((((float )((((float )(llvm_cbe_normal_2e_i_2e_i_2e_0_2e_0 * ((llvm_cbe_tmp136_2e_i_2e_i2041332__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i_2e_i392_2e_i134813491350_2e_ins)), llvm_cbe_tmp136_2e_i_2e_i2041332__BITCAST_TEMPORARY.Float))))) + (((float )(llvm_cbe_normal_2e_i_2e_i_2e_1_2e_0 * ((llvm_cbe_tmp139_2e_i_2e_i1336__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i_2e_i392_2e_i134813491350_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp139_2e_i_2e_i1336__BITCAST_TEMPORARY.Float)))))))) + (((float )(((((llvm_fcmp_ule(llvm_cbe_tmp67_2e_i346_2e_i, 0x0p+0))) ? (llvm_cbe_tmp5_2e_i46_2e_i_2e_i) : (llvm_cbe_tmp67_2e_i346_2e_i))) * llvm_cbe_tmp3_2e_i_2e_i307_2e_i)))))) + (((float )(((((llvm_fcmp_ule(llvm_cbe_tmp74_2e_i351_2e_i, 0x0p+0))) ? (llvm_cbe_tmp5_2e_i35_2e_i_2e_i) : (llvm_cbe_tmp74_2e_i351_2e_i))) * llvm_cbe_tmp3_2e_i205_2e_i_2e_i)))));
  if ((llvm_fcmp_ule(llvm_cbe_tmp150_2e_i_2e_i212, 0x0p+0))) {
    goto llvm_cbe_bb_2e_i_2e_i_2e_i;
  } else {
    llvm_cbe_storemerge_2e_i_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp150_2e_i_2e_i212;   /* for PHI node */
    goto llvm_cbe__Z5b2Absf_2e_exit_2e_i_2e_i;
  }

llvm_cbe_bb122_2e_i_2e_i:
  llvm_cbe_tmp3_2e_i117_2e_i_2e_i = *llvm_cbe_tmp98_2e_i82_2e_i_2e_i_2e_i;
  llvm_cbe_tmp6_2e_i120_2e_i_2e_i = *llvm_cbe_tmp80_2e_i68_2e_i_2e_i_2e_i;
  llvm_cbe_tmp10_2e_i124_2e_i_2e_i = *llvm_cbe_tmp95_2e_i79_2e_i_2e_i_2e_i;
  llvm_cbe_tmp13_2e_i127_2e_i_2e_i = *llvm_cbe_tmp77_2e_i_2e_i_2e_i_2e_i;
  llvm_cbe_tmp26_2e_i146_2e_i_2e_i136213631364_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i143_2e_i_2e_i1355__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp10_2e_i124_2e_i_2e_i - llvm_cbe_tmp13_2e_i127_2e_i_2e_i))), llvm_cbe_tmp23_2e_i143_2e_i_2e_i1355__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i146_2e_i_2e_i1362__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp3_2e_i117_2e_i_2e_i - llvm_cbe_tmp6_2e_i120_2e_i_2e_i))), llvm_cbe_tmp26_2e_i146_2e_i_2e_i1362__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp127_2e_i_2e_i1891325 = (llvm_cbe_tmp127_2e_i_2e_i1891325__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i146_2e_i_2e_i136213631364_2e_ins)), llvm_cbe_tmp127_2e_i_2e_i1891325__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp130_2e_i374_2e_i1329 = (llvm_cbe_tmp130_2e_i374_2e_i1329__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i146_2e_i_2e_i136213631364_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp130_2e_i374_2e_i1329__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp16_2e_i_2e_i_2e_i_2e_i201 = sqrtf((((float )((((float )(llvm_cbe_tmp127_2e_i_2e_i1891325 * llvm_cbe_tmp127_2e_i_2e_i1891325))) + (((float )(llvm_cbe_tmp130_2e_i374_2e_i1329 * llvm_cbe_tmp130_2e_i374_2e_i1329)))))));
  if ((llvm_fcmp_olt(llvm_cbe_tmp16_2e_i_2e_i_2e_i_2e_i201, 0x1p-23))) {
    llvm_cbe_normal_2e_i_2e_i_2e_0_2e_0__PHI_TEMPORARY = llvm_cbe_tmp127_2e_i_2e_i1891325;   /* for PHI node */
    llvm_cbe_normal_2e_i_2e_i_2e_1_2e_0__PHI_TEMPORARY = llvm_cbe_tmp130_2e_i374_2e_i1329;   /* for PHI node */
    goto llvm_cbe__ZN6b2Vec29NormalizeEv_2e_exit_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb6_2e_i103_2e_i_2e_i;
  }

llvm_cbe_bb109_2e_i_2e_i:
  llvm_cbe_targetDistance_2e_i_2e_i_2e_0 = llvm_cbe_targetDistance_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp112_2e_i_2e_i = ((float )(llvm_cbe_tmp_2e_i183_2e_i_2e_i_2e_0 - llvm_cbe_targetDistance_2e_i_2e_i_2e_0));
  if (((((llvm_fcmp_olt(llvm_cbe_tmp112_2e_i_2e_i, 0x1.0624dep-9)) | (llvm_cbe_iter_2e_i_2e_i_2e_0 == 20u))&1))) {
    llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_0;   /* for PHI node */
    llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_0;   /* for PHI node */
    goto llvm_cbe__Z14b2TimeOfImpactPK7b2ShapeRK7b2SweepS1_S4__2e_exit_2e_i;
  } else {
    goto llvm_cbe_bb122_2e_i_2e_i;
  }

llvm_cbe__Z10b2DistanceP6b2Vec2S0_PK7b2ShapeRK7b2XFormS3_S6__2e_exit_2e_i_2e_i:
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_0 = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_0 = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_0 = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_tmp_2e_i183_2e_i_2e_i_2e_0 = llvm_cbe_tmp_2e_i183_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  if ((llvm_cbe_iter_2e_i_2e_i_2e_0 == 0u)) {
    goto llvm_cbe_bb99_2e_i_2e_i;
  } else {
    llvm_cbe_targetDistance_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_targetDistance_2e_i_2e_i_2e_1;   /* for PHI node */
    goto llvm_cbe_bb109_2e_i_2e_i;
  }

llvm_cbe__ZN6b2Vec29NormalizeEv_2e_exit396_2e_i_2e_i_2e_i_2e_i:
  llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_0_2e_0 = llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_0_2e_0__PHI_TEMPORARY;
  llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_1_2e_0 = llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_1_2e_0__PHI_TEMPORARY;
  llvm_cbe_storemerge_2e_i394_2e_i_2e_i_2e_i_2e_i = llvm_cbe_storemerge_2e_i394_2e_i_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp64_2e_i58_2e_i_2e_i_2e_i = ((float )(llvm_cbe_storemerge_2e_i394_2e_i_2e_i_2e_i_2e_i - llvm_cbe_tmp54_2e_i54_2e_i_2e_i_2e_i));
  llvm_cbe_tmp22_2e_i344_2e_i_2e_i_2e_i_2e_i166316641665_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp19_2e_i341_2e_i_2e_i_2e_i_2e_i1656__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_0_2e_0 * llvm_cbe_tmp48_2e_i_2e_i_2e_i_2e_i))), llvm_cbe_tmp19_2e_i341_2e_i_2e_i_2e_i_2e_i1656__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp22_2e_i344_2e_i_2e_i_2e_i_2e_i1663__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_1_2e_0 * llvm_cbe_tmp48_2e_i_2e_i_2e_i_2e_i))), llvm_cbe_tmp22_2e_i344_2e_i_2e_i_2e_i_2e_i1663__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp26_2e_i299_2e_i_2e_i_2e_i_2e_i164916501651_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i296_2e_i_2e_i_2e_i_2e_i1642__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp22_2e_i_2e_i_2e_i_2e_i1681521 + ((llvm_cbe_tmp70_2e_i62_2e_i_2e_i_2e_i1542__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp22_2e_i344_2e_i_2e_i_2e_i_2e_i166316641665_2e_ins)), llvm_cbe_tmp70_2e_i62_2e_i_2e_i_2e_i1542__BITCAST_TEMPORARY.Float))))), llvm_cbe_tmp23_2e_i296_2e_i_2e_i_2e_i_2e_i1642__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i299_2e_i_2e_i_2e_i_2e_i1649__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp25_2e_i43_2e_i_2e_i_2e_i1525 + ((llvm_cbe_tmp73_2e_i65_2e_i_2e_i_2e_i1546__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp22_2e_i344_2e_i_2e_i_2e_i_2e_i166316641665_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp73_2e_i65_2e_i_2e_i_2e_i1546__BITCAST_TEMPORARY.Float))))), llvm_cbe_tmp26_2e_i299_2e_i_2e_i_2e_i_2e_i1649__BITCAST_TEMPORARY.Int32)))) << 32ull);
  *llvm_cbe_tmp77_2e_i_2e_i_2e_i_2e_i = ((llvm_cbe_tmp79_2e_i67_2e_i_2e_i_2e_i1549__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i299_2e_i_2e_i_2e_i_2e_i164916501651_2e_ins)), llvm_cbe_tmp79_2e_i67_2e_i_2e_i_2e_i1549__BITCAST_TEMPORARY.Float));
  *llvm_cbe_tmp80_2e_i68_2e_i_2e_i_2e_i = ((llvm_cbe_tmp82_2e_i70_2e_i_2e_i_2e_i1553__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i299_2e_i_2e_i_2e_i_2e_i164916501651_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp82_2e_i70_2e_i_2e_i_2e_i1553__BITCAST_TEMPORARY.Float));
  llvm_cbe_tmp22_2e_i250_2e_i_2e_i_2e_i_2e_i163516361637_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp19_2e_i247_2e_i_2e_i_2e_i_2e_i1628__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_0_2e_0 * llvm_cbe_tmp51_2e_i_2e_i_2e_i_2e_i))), llvm_cbe_tmp19_2e_i247_2e_i_2e_i_2e_i_2e_i1628__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp22_2e_i250_2e_i_2e_i_2e_i_2e_i1635__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_1_2e_0 * llvm_cbe_tmp51_2e_i_2e_i_2e_i_2e_i))), llvm_cbe_tmp22_2e_i250_2e_i_2e_i_2e_i_2e_i1635__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp26_2e_i205_2e_i_2e_i_2e_i_2e_i162116221623_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i202_2e_i_2e_i_2e_i_2e_i1614__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp33_2e_i_2e_i_2e_i_2e_i1528 - ((llvm_cbe_tmp88_2e_i76_2e_i_2e_i_2e_i1556__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp22_2e_i250_2e_i_2e_i_2e_i_2e_i163516361637_2e_ins)), llvm_cbe_tmp88_2e_i76_2e_i_2e_i_2e_i1556__BITCAST_TEMPORARY.Float))))), llvm_cbe_tmp23_2e_i202_2e_i_2e_i_2e_i_2e_i1614__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i205_2e_i_2e_i_2e_i_2e_i1621__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp36_2e_i_2e_i_2e_i_2e_i1532 - ((llvm_cbe_tmp91_2e_i77_2e_i_2e_i_2e_i1560__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp22_2e_i250_2e_i_2e_i_2e_i_2e_i163516361637_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp91_2e_i77_2e_i_2e_i_2e_i1560__BITCAST_TEMPORARY.Float))))), llvm_cbe_tmp26_2e_i205_2e_i_2e_i_2e_i_2e_i1621__BITCAST_TEMPORARY.Int32)))) << 32ull);
  *llvm_cbe_tmp95_2e_i79_2e_i_2e_i_2e_i = ((llvm_cbe_tmp97_2e_i81_2e_i_2e_i_2e_i1563__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i205_2e_i_2e_i_2e_i_2e_i162116221623_2e_ins)), llvm_cbe_tmp97_2e_i81_2e_i_2e_i_2e_i1563__BITCAST_TEMPORARY.Float));
  *llvm_cbe_tmp98_2e_i82_2e_i_2e_i_2e_i = ((llvm_cbe_tmp100_2e_i_2e_i_2e_i_2e_i1567__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i205_2e_i_2e_i_2e_i_2e_i162116221623_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp100_2e_i_2e_i_2e_i_2e_i1567__BITCAST_TEMPORARY.Float));
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i463_2e_i_2e_i_2e_i_2e_i167716781679_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i205_2e_i_2e_i_2e_i_2e_i162116221623_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i250_2e_i_2e_i_2e_i_2e_i163516361637_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i299_2e_i_2e_i_2e_i_2e_i164916501651_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i344_2e_i_2e_i_2e_i_2e_i166316641665_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_tmp_2e_i183_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp64_2e_i58_2e_i_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe__Z10b2DistanceP6b2Vec2S0_PK7b2ShapeRK7b2XFormS3_S6__2e_exit_2e_i_2e_i;

llvm_cbe_bb_2e_i57_2e_i_2e_i_2e_i:
  llvm_cbe_tmp16_2e_i_2e_i372_2e_i_2e_i_2e_i_2e_i = sqrtf(llvm_cbe_tmp15_2e_i421_2e_i_2e_i_2e_i_2e_i);
  if ((llvm_fcmp_olt(llvm_cbe_tmp16_2e_i_2e_i372_2e_i_2e_i_2e_i_2e_i, 0x1p-23))) {
    llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_0_2e_0__PHI_TEMPORARY = llvm_cbe_tmp41_2e_i48_2e_i_2e_i_2e_i1535;   /* for PHI node */
    llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_1_2e_0__PHI_TEMPORARY = llvm_cbe_tmp44_2e_i49_2e_i_2e_i_2e_i1539;   /* for PHI node */
    llvm_cbe_storemerge_2e_i394_2e_i_2e_i_2e_i_2e_i__PHI_TEMPORARY = 0x0p+0;   /* for PHI node */
    goto llvm_cbe__ZN6b2Vec29NormalizeEv_2e_exit396_2e_i_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb6_2e_i393_2e_i_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb12_2e_i_2e_i_2e_i:
  llvm_cbe_tmp18_2e_i39_2e_i_2e_i_2e_i = _Z5b2MulRK7b2XFormRK6b2Vec2((&llvm_cbe_xf1_2e_i_2e_i30), llvm_cbe_tmp2_2e_i_2e_i38_2e_i_2e_i_2e_i);
  llvm_cbe_tmp22_2e_i_2e_i_2e_i_2e_i1681521 = (llvm_cbe_tmp22_2e_i_2e_i_2e_i_2e_i1681521__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp18_2e_i39_2e_i_2e_i_2e_i)), llvm_cbe_tmp22_2e_i_2e_i_2e_i_2e_i1681521__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp25_2e_i43_2e_i_2e_i_2e_i1525 = (llvm_cbe_tmp25_2e_i43_2e_i_2e_i_2e_i1525__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp18_2e_i39_2e_i_2e_i_2e_i) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp25_2e_i43_2e_i_2e_i_2e_i1525__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp29_2e_i_2e_i_2e_i_2e_i170 = _Z5b2MulRK7b2XFormRK6b2Vec2((&llvm_cbe_xf2_2e_i_2e_i29), llvm_cbe_tmp2_2e_i472_2e_i_2e_i_2e_i_2e_i);
  llvm_cbe_tmp33_2e_i_2e_i_2e_i_2e_i1528 = (llvm_cbe_tmp33_2e_i_2e_i_2e_i_2e_i1528__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp29_2e_i_2e_i_2e_i_2e_i170)), llvm_cbe_tmp33_2e_i_2e_i_2e_i_2e_i1528__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp36_2e_i_2e_i_2e_i_2e_i1532 = (llvm_cbe_tmp36_2e_i_2e_i_2e_i_2e_i1532__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp29_2e_i_2e_i_2e_i_2e_i170) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp36_2e_i_2e_i_2e_i_2e_i1532__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp26_2e_i463_2e_i_2e_i_2e_i_2e_i167716781679_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i460_2e_i_2e_i_2e_i_2e_i1670__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp33_2e_i_2e_i_2e_i_2e_i1528 - llvm_cbe_tmp22_2e_i_2e_i_2e_i_2e_i1681521))), llvm_cbe_tmp23_2e_i460_2e_i_2e_i_2e_i_2e_i1670__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i463_2e_i_2e_i_2e_i_2e_i1677__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp36_2e_i_2e_i_2e_i_2e_i1532 - llvm_cbe_tmp25_2e_i43_2e_i_2e_i_2e_i1525))), llvm_cbe_tmp26_2e_i463_2e_i_2e_i_2e_i_2e_i1677__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp41_2e_i48_2e_i_2e_i_2e_i1535 = (llvm_cbe_tmp41_2e_i48_2e_i_2e_i_2e_i1535__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i463_2e_i_2e_i_2e_i_2e_i167716781679_2e_ins)), llvm_cbe_tmp41_2e_i48_2e_i_2e_i_2e_i1535__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp44_2e_i49_2e_i_2e_i_2e_i1539 = (llvm_cbe_tmp44_2e_i49_2e_i_2e_i_2e_i1539__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i463_2e_i_2e_i_2e_i_2e_i167716781679_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp44_2e_i49_2e_i_2e_i_2e_i1539__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp15_2e_i421_2e_i_2e_i_2e_i_2e_i = ((float )((((float )(llvm_cbe_tmp41_2e_i48_2e_i_2e_i_2e_i1535 * llvm_cbe_tmp41_2e_i48_2e_i_2e_i_2e_i1535))) + (((float )(llvm_cbe_tmp44_2e_i49_2e_i_2e_i_2e_i1539 * llvm_cbe_tmp44_2e_i49_2e_i_2e_i_2e_i1539)))));
  llvm_cbe_tmp3_2e_i402_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp2_2e_i401_2e_i_2e_i_2e_i_2e_i;
  llvm_cbe_tmp48_2e_i_2e_i_2e_i_2e_i = ((float )(llvm_cbe_tmp3_2e_i402_2e_i_2e_i_2e_i_2e_i - 0x1.47ae14p-5));
  llvm_cbe_tmp3_2e_i399_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp2_2e_i398_2e_i_2e_i_2e_i_2e_i;
  llvm_cbe_tmp51_2e_i_2e_i_2e_i_2e_i = ((float )(llvm_cbe_tmp3_2e_i399_2e_i_2e_i_2e_i_2e_i - 0x1.47ae14p-5));
  llvm_cbe_tmp54_2e_i54_2e_i_2e_i_2e_i = ((float )(llvm_cbe_tmp48_2e_i_2e_i_2e_i_2e_i + llvm_cbe_tmp51_2e_i_2e_i_2e_i_2e_i));
  if ((llvm_fcmp_olt((((float )(llvm_cbe_tmp54_2e_i54_2e_i_2e_i_2e_i * llvm_cbe_tmp54_2e_i54_2e_i_2e_i_2e_i))), llvm_cbe_tmp15_2e_i421_2e_i_2e_i_2e_i_2e_i))) {
    goto llvm_cbe_bb_2e_i57_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb102_2e_i_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb6_2e_i393_2e_i_2e_i_2e_i_2e_i:
  llvm_cbe_tmp8_2e_i377_2e_i_2e_i_2e_i_2e_i = ((float )(0x1p+0 / llvm_cbe_tmp16_2e_i_2e_i372_2e_i_2e_i_2e_i_2e_i));
  llvm_cbe_tmp13_2e_i382_2e_i_2e_i_2e_i_2e_i = ((float )(llvm_cbe_tmp41_2e_i48_2e_i_2e_i_2e_i1535 * llvm_cbe_tmp8_2e_i377_2e_i_2e_i_2e_i_2e_i));
  llvm_cbe_tmp20_2e_i389_2e_i_2e_i_2e_i_2e_i = ((float )(llvm_cbe_tmp44_2e_i49_2e_i_2e_i_2e_i1539 * llvm_cbe_tmp8_2e_i377_2e_i_2e_i_2e_i_2e_i));
  llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_0_2e_0__PHI_TEMPORARY = llvm_cbe_tmp13_2e_i382_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_1_2e_0__PHI_TEMPORARY = llvm_cbe_tmp20_2e_i389_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  llvm_cbe_storemerge_2e_i394_2e_i_2e_i_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp16_2e_i_2e_i372_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe__ZN6b2Vec29NormalizeEv_2e_exit396_2e_i_2e_i_2e_i_2e_i;

llvm_cbe__ZN6b2Vec29NormalizeEv_2e_exit_2e_i_2e_i_2e_i_2e_i:
  llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_0_2e_1 = llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_0_2e_1__PHI_TEMPORARY;
  llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_1_2e_1 = llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_1_2e_1__PHI_TEMPORARY;
  llvm_cbe_tmp22_2e_i133_2e_i_2e_i_2e_i_2e_i160716081609_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp19_2e_i130_2e_i_2e_i_2e_i_2e_i1600__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_0_2e_1 * llvm_cbe_tmp48_2e_i_2e_i_2e_i_2e_i))), llvm_cbe_tmp19_2e_i130_2e_i_2e_i_2e_i_2e_i1600__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp22_2e_i133_2e_i_2e_i_2e_i_2e_i1607__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_1_2e_1 * llvm_cbe_tmp48_2e_i_2e_i_2e_i_2e_i))), llvm_cbe_tmp22_2e_i133_2e_i_2e_i_2e_i_2e_i1607__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp26_2e_i_2e_i131_2e_i_2e_i_2e_i159315941595_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i_2e_i128_2e_i_2e_i_2e_i1586__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp22_2e_i_2e_i_2e_i_2e_i1681521 + ((llvm_cbe_tmp114_2e_i96_2e_i_2e_i_2e_i1570__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp22_2e_i133_2e_i_2e_i_2e_i_2e_i160716081609_2e_ins)), llvm_cbe_tmp114_2e_i96_2e_i_2e_i_2e_i1570__BITCAST_TEMPORARY.Float))))), llvm_cbe_tmp23_2e_i_2e_i128_2e_i_2e_i_2e_i1586__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i_2e_i131_2e_i_2e_i_2e_i1593__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp25_2e_i43_2e_i_2e_i_2e_i1525 + ((llvm_cbe_tmp117_2e_i99_2e_i_2e_i_2e_i1574__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp22_2e_i133_2e_i_2e_i_2e_i_2e_i160716081609_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp117_2e_i99_2e_i_2e_i_2e_i1574__BITCAST_TEMPORARY.Float))))), llvm_cbe_tmp26_2e_i_2e_i131_2e_i_2e_i_2e_i1593__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp123_2e_i142_2e_i_2e_i_2e_i1577 = (llvm_cbe_tmp123_2e_i142_2e_i_2e_i_2e_i1577__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i_2e_i131_2e_i_2e_i_2e_i159315941595_2e_ins)), llvm_cbe_tmp123_2e_i142_2e_i_2e_i_2e_i1577__BITCAST_TEMPORARY.Float);
  *llvm_cbe_tmp77_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp123_2e_i142_2e_i_2e_i_2e_i1577;
  llvm_cbe_tmp126_2e_i_2e_i_2e_i_2e_i1581 = (llvm_cbe_tmp126_2e_i_2e_i_2e_i_2e_i1581__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i_2e_i131_2e_i_2e_i_2e_i159315941595_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp126_2e_i_2e_i_2e_i_2e_i1581__BITCAST_TEMPORARY.Float);
  *llvm_cbe_tmp80_2e_i68_2e_i_2e_i_2e_i = llvm_cbe_tmp126_2e_i_2e_i_2e_i_2e_i1581;
  *llvm_cbe_tmp95_2e_i79_2e_i_2e_i_2e_i = llvm_cbe_tmp123_2e_i142_2e_i_2e_i_2e_i1577;
  *llvm_cbe_tmp98_2e_i82_2e_i_2e_i_2e_i = llvm_cbe_tmp126_2e_i_2e_i_2e_i_2e_i1581;
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i_2e_i131_2e_i_2e_i_2e_i159315941595_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i133_2e_i_2e_i_2e_i_2e_i160716081609_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i463_2e_i_2e_i_2e_i_2e_i167716781679_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_tmp_2e_i183_2e_i_2e_i_2e_0__PHI_TEMPORARY = 0x0p+0;   /* for PHI node */
  goto llvm_cbe__Z10b2DistanceP6b2Vec2S0_PK7b2ShapeRK7b2XFormS3_S6__2e_exit_2e_i_2e_i;

llvm_cbe_bb107_2e_i_2e_i_2e_i_2e_i:
  llvm_cbe_tmp16_2e_i_2e_i_2e_i_2e_i_2e_i_2e_i = sqrtf(llvm_cbe_tmp15_2e_i421_2e_i_2e_i_2e_i_2e_i);
  if ((llvm_fcmp_olt(llvm_cbe_tmp16_2e_i_2e_i_2e_i_2e_i_2e_i_2e_i, 0x1p-23))) {
    llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_0_2e_1__PHI_TEMPORARY = llvm_cbe_tmp41_2e_i48_2e_i_2e_i_2e_i1535;   /* for PHI node */
    llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_1_2e_1__PHI_TEMPORARY = llvm_cbe_tmp44_2e_i49_2e_i_2e_i_2e_i1539;   /* for PHI node */
    goto llvm_cbe__ZN6b2Vec29NormalizeEv_2e_exit_2e_i_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb6_2e_i_2e_i88_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb102_2e_i_2e_i_2e_i_2e_i:
  if ((llvm_fcmp_ogt(llvm_cbe_tmp15_2e_i421_2e_i_2e_i_2e_i_2e_i, 0x1p-46))) {
    goto llvm_cbe_bb107_2e_i_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb141_2e_i_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb6_2e_i_2e_i88_2e_i_2e_i_2e_i:
  llvm_cbe_tmp8_2e_i148_2e_i_2e_i_2e_i_2e_i = ((float )(0x1p+0 / llvm_cbe_tmp16_2e_i_2e_i_2e_i_2e_i_2e_i_2e_i));
  llvm_cbe_tmp13_2e_i153_2e_i_2e_i_2e_i_2e_i = ((float )(llvm_cbe_tmp41_2e_i48_2e_i_2e_i_2e_i1535 * llvm_cbe_tmp8_2e_i148_2e_i_2e_i_2e_i_2e_i));
  llvm_cbe_tmp20_2e_i160_2e_i_2e_i_2e_i_2e_i = ((float )(llvm_cbe_tmp44_2e_i49_2e_i_2e_i_2e_i1539 * llvm_cbe_tmp8_2e_i148_2e_i_2e_i_2e_i_2e_i));
  llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_0_2e_1__PHI_TEMPORARY = llvm_cbe_tmp13_2e_i153_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  llvm_cbe_d_2e_i_2e_i_2e_i_2e_i_2e_1_2e_1__PHI_TEMPORARY = llvm_cbe_tmp20_2e_i160_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe__ZN6b2Vec29NormalizeEv_2e_exit_2e_i_2e_i_2e_i_2e_i;

llvm_cbe_bb141_2e_i_2e_i_2e_i_2e_i:
  *llvm_cbe_tmp77_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp22_2e_i_2e_i_2e_i_2e_i1681521;
  *llvm_cbe_tmp80_2e_i68_2e_i_2e_i_2e_i = llvm_cbe_tmp25_2e_i43_2e_i_2e_i_2e_i1525;
  *llvm_cbe_tmp95_2e_i79_2e_i_2e_i_2e_i = llvm_cbe_tmp22_2e_i_2e_i_2e_i_2e_i1681521;
  *llvm_cbe_tmp98_2e_i82_2e_i_2e_i_2e_i = llvm_cbe_tmp25_2e_i43_2e_i_2e_i_2e_i1525;
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i463_2e_i_2e_i_2e_i_2e_i167716781679_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_tmp_2e_i183_2e_i_2e_i_2e_0__PHI_TEMPORARY = 0x0p+0;   /* for PHI node */
  goto llvm_cbe__Z10b2DistanceP6b2Vec2S0_PK7b2ShapeRK7b2XFormS3_S6__2e_exit_2e_i_2e_i;

llvm_cbe_bb32_2e_i_2e_i_2e_i:
  llvm_cbe_tmp41_2e_i_2e_i_2e_i = _ZL10DistancePCP6b2Vec2S0_PK14b2PolygonShapeRK7b2XFormPK13b2CircleShapeS6_((&llvm_cbe_p1_2e_i_2e_i32), (&llvm_cbe_p2_2e_i_2e_i31), llvm_cbe_tmp3536_2e_i_2e_i_2e_i, (&llvm_cbe_xf1_2e_i_2e_i30), llvm_cbe_tmp1314_2e_i_2e_i_2e_i, (&llvm_cbe_xf2_2e_i_2e_i29));
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_tmp_2e_i183_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp41_2e_i_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe__Z10b2DistanceP6b2Vec2S0_PK7b2ShapeRK7b2XFormS3_S6__2e_exit_2e_i_2e_i;

llvm_cbe_bb22_2e_i_2e_i_2e_i:
  if (((((llvm_cbe_tmp3_2e_i_2e_i186_2e_i_2e_i == 1u) & (llvm_cbe_tmp3_2e_i6_2e_i_2e_i_2e_i == 0u))&1))) {
    goto llvm_cbe_bb32_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb42_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb52_2e_i_2e_i_2e_i:
  llvm_cbe_tmp61_2e_i_2e_i_2e_i = _ZL10DistancePCP6b2Vec2S0_PK14b2PolygonShapeRK7b2XFormPK13b2CircleShapeS6_((&llvm_cbe_p2_2e_i_2e_i31), (&llvm_cbe_p1_2e_i_2e_i32), llvm_cbe_tmp5556_2e_i_2e_i_2e_i, (&llvm_cbe_xf2_2e_i_2e_i29), llvm_cbe_tmp1516_2e_i_2e_i_2e_i, (&llvm_cbe_xf1_2e_i_2e_i30));
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_tmp_2e_i183_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp61_2e_i_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe__Z10b2DistanceP6b2Vec2S0_PK7b2ShapeRK7b2XFormS3_S6__2e_exit_2e_i_2e_i;

llvm_cbe_bb42_2e_i_2e_i_2e_i:
  if (((((llvm_cbe_tmp3_2e_i_2e_i186_2e_i_2e_i == 0u) & (llvm_cbe_tmp3_2e_i6_2e_i_2e_i_2e_i == 1u))&1))) {
    goto llvm_cbe_bb52_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb62_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb62_2e_i_2e_i_2e_i:
  if (((((llvm_cbe_tmp3_2e_i_2e_i186_2e_i_2e_i == 1u) & (llvm_cbe_tmp3_2e_i6_2e_i_2e_i_2e_i == 1u))&1))) {
    llvm_cbe_tmp18_2e_i_2e_i_2e_i_2e_i25_2e_0__PHI_TEMPORARY = 2ull;   /* for PHI node */
    goto llvm_cbe_bb_2e_i_2e_i_2e_i_2e_i;
  } else {
    llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
    llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
    llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
    llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_tmp_2e_i183_2e_i_2e_i_2e_0__PHI_TEMPORARY = 0x0p+0;   /* for PHI node */
    goto llvm_cbe__Z10b2DistanceP6b2Vec2S0_PK7b2ShapeRK7b2XFormS3_S6__2e_exit_2e_i_2e_i;
  }

llvm_cbe_bb174_2e_i_2e_i_2e_i_2e_i:
  llvm_cbe_tmp177_2e_i_2e_i_2e_i_2e_i = sqrtf(llvm_cbe_tmp15_2e_i216_2e_i_2e_i_2e_i_2e_i);
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp6_2e_i229_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp6_2e_i112_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i191_2e_i_2e_i_2e_i_2e_i146714681469_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp20_2e_i283_2e_i_2e_i_2e_i_2e_i150215031504_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i331_2e_i_2e_i_2e_i_2e_i151615171518_2e_ins;   /* for PHI node */
  llvm_cbe_tmp_2e_i183_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp177_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe__Z10b2DistanceP6b2Vec2S0_PK7b2ShapeRK7b2XFormS3_S6__2e_exit_2e_i_2e_i;

llvm_cbe_bb154_2e_i_2e_i_2e_i_2e_i:
  if ((llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_1 == 0u)) {
    goto llvm_cbe_bb159_2e_i_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb174_2e_i_2e_i_2e_i_2e_i;
  }

  do {     /* Syntactic loop 'bb86.i.i.i.i' to make GCC happy */
llvm_cbe_bb86_2e_i_2e_i_2e_i_2e_i:
  llvm_cbe_iter_2e_i_2e_i_2e_i_2e_i_2e_0 = llvm_cbe_iter_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_tmp3_2e_i302_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp98_2e_i82_2e_i_2e_i_2e_i;
  llvm_cbe_tmp6_2e_i305_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp80_2e_i68_2e_i_2e_i_2e_i;
  llvm_cbe_tmp10_2e_i309_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp95_2e_i79_2e_i_2e_i_2e_i;
  llvm_cbe_tmp13_2e_i312_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp77_2e_i_2e_i_2e_i_2e_i;
  llvm_cbe_tmp26_2e_i331_2e_i_2e_i_2e_i_2e_i151615171518_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i328_2e_i_2e_i_2e_i_2e_i1509__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp10_2e_i309_2e_i_2e_i_2e_i_2e_i - llvm_cbe_tmp13_2e_i312_2e_i_2e_i_2e_i_2e_i))), llvm_cbe_tmp23_2e_i328_2e_i_2e_i_2e_i_2e_i1509__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i331_2e_i_2e_i_2e_i_2e_i1516__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp3_2e_i302_2e_i_2e_i_2e_i_2e_i - llvm_cbe_tmp6_2e_i305_2e_i_2e_i_2e_i_2e_i))), llvm_cbe_tmp26_2e_i331_2e_i_2e_i_2e_i_2e_i1516__BITCAST_TEMPORARY.Int32)))) << 32ull);
  *llvm_cbe_tmp91_2e_i_2e_i_2e_i_2e_i = ((llvm_cbe_tmp93_2e_i_2e_i_2e_i_2e_i1381__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i331_2e_i_2e_i_2e_i_2e_i151615171518_2e_ins)), llvm_cbe_tmp93_2e_i_2e_i_2e_i_2e_i1381__BITCAST_TEMPORARY.Float));
  *llvm_cbe_tmp94_2e_i_2e_i_2e_i_2e_i = ((llvm_cbe_tmp96_2e_i_2e_i_2e_i_2e_i1385__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i331_2e_i_2e_i_2e_i_2e_i151615171518_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp96_2e_i_2e_i_2e_i_2e_i1385__BITCAST_TEMPORARY.Float));
  llvm_cbe_tmp99_2e_i_2e_i_2e_i_2e_i = _ZNK14b2PolygonShape7SupportERK7b2XFormRK6b2Vec2(llvm_cbe_tmp3536_2e_i_2e_i_2e_i, (&llvm_cbe_xf1_2e_i_2e_i30), (&llvm_cbe_v_2e_i_2e_i_2e_i_2e_i24));
  llvm_cbe_tmp103_2e_i_2e_i_2e_i_2e_i1388 = (llvm_cbe_tmp103_2e_i_2e_i_2e_i_2e_i1388__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp99_2e_i_2e_i_2e_i_2e_i)), llvm_cbe_tmp103_2e_i_2e_i_2e_i_2e_i1388__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp106_2e_i_2e_i_2e_i_2e_i1392 = (llvm_cbe_tmp106_2e_i_2e_i_2e_i_2e_i1392__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp99_2e_i_2e_i_2e_i_2e_i) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp106_2e_i_2e_i_2e_i_2e_i1392__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp3_2e_i260_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp94_2e_i_2e_i_2e_i_2e_i;
  llvm_cbe_tmp7_2e_i264_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp91_2e_i_2e_i_2e_i_2e_i;
  llvm_cbe_tmp20_2e_i283_2e_i_2e_i_2e_i_2e_i150215031504_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp17_2e_i280_2e_i_2e_i_2e_i_2e_i1495__BITCAST_TEMPORARY.Float = (((float )(-(llvm_cbe_tmp7_2e_i264_2e_i_2e_i_2e_i_2e_i)))), llvm_cbe_tmp17_2e_i280_2e_i_2e_i_2e_i_2e_i1495__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp20_2e_i283_2e_i_2e_i_2e_i_2e_i1502__BITCAST_TEMPORARY.Float = (((float )(-(llvm_cbe_tmp3_2e_i260_2e_i_2e_i_2e_i_2e_i)))), llvm_cbe_tmp20_2e_i283_2e_i_2e_i_2e_i_2e_i1502__BITCAST_TEMPORARY.Int32)))) << 32ull);
  *llvm_cbe_tmp109_2e_i_2e_i_2e_i_2e_i = ((llvm_cbe_tmp111_2e_i_2e_i_2e_i_2e_i1395__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp20_2e_i283_2e_i_2e_i_2e_i_2e_i150215031504_2e_ins)), llvm_cbe_tmp111_2e_i_2e_i_2e_i_2e_i1395__BITCAST_TEMPORARY.Float));
  *llvm_cbe_tmp112_2e_i_2e_i_2e_i_2e_i = ((llvm_cbe_tmp114_2e_i_2e_i_2e_i_2e_i1399__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp20_2e_i283_2e_i_2e_i_2e_i_2e_i150215031504_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp114_2e_i_2e_i_2e_i_2e_i1399__BITCAST_TEMPORARY.Float));
  llvm_cbe_tmp117_2e_i_2e_i_2e_i_2e_i = _ZNK14b2PolygonShape7SupportERK7b2XFormRK6b2Vec2(llvm_cbe_tmp5556_2e_i_2e_i_2e_i, (&llvm_cbe_xf2_2e_i_2e_i29), (&llvm_cbe_tmp7_2e_i_2e_i172_2e_i_2e_i));
  llvm_cbe_tmp121_2e_i_2e_i_2e_i_2e_i1402 = (llvm_cbe_tmp121_2e_i_2e_i_2e_i_2e_i1402__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp117_2e_i_2e_i_2e_i_2e_i)), llvm_cbe_tmp121_2e_i_2e_i_2e_i_2e_i1402__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp124_2e_i_2e_i_2e_i_2e_i1406 = (llvm_cbe_tmp124_2e_i_2e_i_2e_i_2e_i1406__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp117_2e_i_2e_i_2e_i_2e_i) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp124_2e_i_2e_i_2e_i_2e_i1406__BITCAST_TEMPORARY.Float);
  llvm_cbe_tmp3_2e_i204_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp91_2e_i_2e_i_2e_i_2e_i;
  llvm_cbe_tmp10_2e_i211_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp94_2e_i_2e_i_2e_i_2e_i;
  llvm_cbe_tmp15_2e_i216_2e_i_2e_i_2e_i_2e_i = ((float )((((float )(llvm_cbe_tmp3_2e_i204_2e_i_2e_i_2e_i_2e_i * llvm_cbe_tmp3_2e_i204_2e_i_2e_i_2e_i_2e_i))) + (((float )(llvm_cbe_tmp10_2e_i211_2e_i_2e_i_2e_i_2e_i * llvm_cbe_tmp10_2e_i211_2e_i_2e_i_2e_i_2e_i)))));
  llvm_cbe_tmp26_2e_i191_2e_i_2e_i_2e_i_2e_i146714681469_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i188_2e_i_2e_i_2e_i_2e_i1460__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp121_2e_i_2e_i_2e_i_2e_i1402 - llvm_cbe_tmp103_2e_i_2e_i_2e_i_2e_i1388))), llvm_cbe_tmp23_2e_i188_2e_i_2e_i_2e_i_2e_i1460__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i191_2e_i_2e_i_2e_i_2e_i1467__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp124_2e_i_2e_i_2e_i_2e_i1406 - llvm_cbe_tmp106_2e_i_2e_i_2e_i_2e_i1392))), llvm_cbe_tmp26_2e_i191_2e_i_2e_i_2e_i_2e_i1467__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp130_2e_i_2e_i_2e_i_2e_i1409 = (llvm_cbe_tmp130_2e_i_2e_i_2e_i_2e_i1409__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i191_2e_i_2e_i_2e_i_2e_i146714681469_2e_ins)), llvm_cbe_tmp130_2e_i_2e_i_2e_i_2e_i1409__BITCAST_TEMPORARY.Float);
  *llvm_cbe_tmp128_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp130_2e_i_2e_i_2e_i_2e_i1409;
  llvm_cbe_tmp133_2e_i_2e_i_2e_i_2e_i1413 = (llvm_cbe_tmp133_2e_i_2e_i_2e_i_2e_i1413__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i191_2e_i_2e_i_2e_i_2e_i146714681469_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp133_2e_i_2e_i_2e_i_2e_i1413__BITCAST_TEMPORARY.Float);
  *llvm_cbe_tmp131_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp133_2e_i_2e_i_2e_i_2e_i1413;
  if ((llvm_fcmp_ugt((((float )(llvm_cbe_tmp15_2e_i216_2e_i_2e_i_2e_i_2e_i - (((float )((((float )(llvm_cbe_tmp3_2e_i204_2e_i_2e_i_2e_i_2e_i * llvm_cbe_tmp130_2e_i_2e_i_2e_i_2e_i1409))) + (((float )(llvm_cbe_tmp10_2e_i211_2e_i_2e_i_2e_i_2e_i * llvm_cbe_tmp133_2e_i_2e_i_2e_i_2e_i1413))))))))), (((float )(llvm_cbe_tmp15_2e_i216_2e_i_2e_i_2e_i_2e_i * 0x1.47ae14p-7)))))) {
    goto llvm_cbe_bb143_2e_i_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb154_2e_i_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb341_2e_i_2e_i_2e_i_2e_i:
  llvm_cbe_tmp343_2e_i_2e_i_2e_i_2e_i = llvm_cbe_iter_2e_i_2e_i_2e_i_2e_i_2e_0 + 1u;
  if ((((signed int )llvm_cbe_tmp343_2e_i_2e_i_2e_i_2e_i) < ((signed int )20u))) {
    llvm_cbe_iter_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp343_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
    llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_0;   /* for PHI node */
    goto llvm_cbe_bb86_2e_i_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb349_2e_i_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb319_2e_i_2e_i_2e_i_2e_i:
  if ((llvm_fcmp_ult((((float )(llvm_cbe_maxSqr_2e_i_2e_i_2e_i_2e_i_2e_0 * 0x1.9p-17))), llvm_cbe_tmp15_2e_i216_2e_i_2e_i_2e_i_2e_i))) {
    goto llvm_cbe_bb341_2e_i_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb326_2e_i_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb314_2e_i_2e_i_2e_i_2e_i:
  if ((llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_0 == 3u)) {
    goto llvm_cbe_bb326_2e_i_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb319_2e_i_2e_i_2e_i_2e_i;
  }

  do {     /* Syntactic loop 'bb308.i.i.i.i' to make GCC happy */
llvm_cbe_bb308_2e_i_2e_i_2e_i_2e_i:
  llvm_cbe_maxSqr_2e_i_2e_i_2e_i_2e_i_2e_0 = llvm_cbe_maxSqr_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_storemerge4_2e_i_2e_i_2e_i_2e_i = llvm_cbe_storemerge4_2e_i_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  if ((((signed int )llvm_cbe_storemerge4_2e_i_2e_i_2e_i_2e_i) < ((signed int )llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_0))) {
    goto llvm_cbe_bb296_2e_i_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb314_2e_i_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb296_2e_i_2e_i_2e_i_2e_i:
  llvm_cbe_tmp297298_2e_i_2e_i_2e_i_2e_i = ((signed long long )(signed int )llvm_cbe_storemerge4_2e_i_2e_i_2e_i_2e_i);
  llvm_cbe_tmp3_2e_i90_2e_i_2e_i_2e_i_2e_i = *((&llvm_cbe_points_2e_i_2e_i_2e_i_2e_i[((signed long long )llvm_cbe_tmp297298_2e_i_2e_i_2e_i_2e_i)].field0));
  llvm_cbe_tmp10_2e_i97_2e_i_2e_i_2e_i_2e_i = *((&llvm_cbe_points_2e_i_2e_i_2e_i_2e_i[((signed long long )llvm_cbe_tmp297298_2e_i_2e_i_2e_i_2e_i)].field1));
  llvm_cbe_tmp15_2e_i102_2e_i_2e_i_2e_i_2e_i = ((float )((((float )(llvm_cbe_tmp3_2e_i90_2e_i_2e_i_2e_i_2e_i * llvm_cbe_tmp3_2e_i90_2e_i_2e_i_2e_i_2e_i))) + (((float )(llvm_cbe_tmp10_2e_i97_2e_i_2e_i_2e_i_2e_i * llvm_cbe_tmp10_2e_i97_2e_i_2e_i_2e_i_2e_i)))));
  llvm_cbe_storemerge_2e_i_2e_i_2e_i_2e_i_2e_i = (((llvm_fcmp_ogt(llvm_cbe_maxSqr_2e_i_2e_i_2e_i_2e_i_2e_0, llvm_cbe_tmp15_2e_i102_2e_i_2e_i_2e_i_2e_i))) ? (llvm_cbe_maxSqr_2e_i_2e_i_2e_i_2e_i_2e_0) : (llvm_cbe_tmp15_2e_i102_2e_i_2e_i_2e_i_2e_i));
  llvm_cbe_tmp307_2e_i_2e_i_2e_i_2e_i = llvm_cbe_storemerge4_2e_i_2e_i_2e_i_2e_i + 1u;
  llvm_cbe_maxSqr_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_storemerge_2e_i_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  llvm_cbe_storemerge4_2e_i_2e_i_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp307_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb308_2e_i_2e_i_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb308.i.i.i.i' */
llvm_cbe_bb288_2e_i_2e_i_2e_i_2e_i:
  llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_0 = llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  if ((llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_0 == 3u)) {
    llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
    llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp6_2e_i229_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
    llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp6_2e_i112_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
    llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i191_2e_i_2e_i_2e_i_2e_i146714681469_2e_ins;   /* for PHI node */
    llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp20_2e_i283_2e_i_2e_i_2e_i_2e_i150215031504_2e_ins;   /* for PHI node */
    llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i331_2e_i_2e_i_2e_i_2e_i151615171518_2e_ins;   /* for PHI node */
    llvm_cbe_tmp_2e_i183_2e_i_2e_i_2e_0__PHI_TEMPORARY = 0x0p+0;   /* for PHI node */
    goto llvm_cbe__Z10b2DistanceP6b2Vec2S0_PK7b2ShapeRK7b2XFormS3_S6__2e_exit_2e_i_2e_i;
  } else {
    llvm_cbe_maxSqr_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = -0x1.fffffep+127;   /* for PHI node */
    llvm_cbe_storemerge4_2e_i_2e_i_2e_i_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
    goto llvm_cbe_bb308_2e_i_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb178_2e_i_2e_i_2e_i_2e_i:
  switch (llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_1) {
  default:
    llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
    goto llvm_cbe_bb288_2e_i_2e_i_2e_i_2e_i;
;
  case 0u:
    goto llvm_cbe_bb180_2e_i_2e_i_2e_i_2e_i;
    break;
  case 1u:
    goto llvm_cbe_bb232_2e_i_2e_i_2e_i_2e_i;
  case 2u:
    goto llvm_cbe_bb260_2e_i_2e_i_2e_i_2e_i;
  }
llvm_cbe_bb143_2e_i_2e_i_2e_i_2e_i:
  llvm_cbe_tmp146_2e_i_2e_i_2e_i_2e_i = _ZL8InPointsRK6b2Vec2PS0_i((&llvm_cbe_w_2e_i_2e_i_2e_i_2e_i), llvm_cbe_tmp49_2e_i_2e_i_2e_i_2e_i, llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_1);
  if ((llvm_cbe_tmp146_2e_i_2e_i_2e_i_2e_i == ((unsigned char )0))) {
    goto llvm_cbe_bb178_2e_i_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb154_2e_i_2e_i_2e_i_2e_i;
  }

llvm_cbe_bb180_2e_i_2e_i_2e_i_2e_i:
  *llvm_cbe_tmp182_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp103_2e_i_2e_i_2e_i_2e_i1388;
  *llvm_cbe_tmp185_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp106_2e_i_2e_i_2e_i_2e_i1392;
  *llvm_cbe_tmp189_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp121_2e_i_2e_i_2e_i_2e_i1402;
  *llvm_cbe_tmp192_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp124_2e_i_2e_i_2e_i_2e_i1406;
  llvm_cbe_tmp198_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp128_2e_i_2e_i_2e_i_2e_i;
  *llvm_cbe_tmp196_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp198_2e_i_2e_i_2e_i_2e_i;
  llvm_cbe_tmp201_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp131_2e_i_2e_i_2e_i_2e_i;
  *llvm_cbe_tmp199_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp201_2e_i_2e_i_2e_i_2e_i;
  *llvm_cbe_tmp77_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp103_2e_i_2e_i_2e_i_2e_i1388;
  *llvm_cbe_tmp80_2e_i68_2e_i_2e_i_2e_i = llvm_cbe_tmp106_2e_i_2e_i_2e_i_2e_i1392;
  *llvm_cbe_tmp95_2e_i79_2e_i_2e_i_2e_i = llvm_cbe_tmp121_2e_i_2e_i_2e_i_2e_i1402;
  *llvm_cbe_tmp98_2e_i82_2e_i_2e_i_2e_i = llvm_cbe_tmp124_2e_i_2e_i_2e_i_2e_i1406;
  llvm_cbe_tmp231_2e_i_2e_i_2e_i_2e_i = llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_1 + 1u;
  llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp231_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb288_2e_i_2e_i_2e_i_2e_i;

llvm_cbe_bb232_2e_i_2e_i_2e_i_2e_i:
  *llvm_cbe_tmp234_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp103_2e_i_2e_i_2e_i_2e_i1388;
  *llvm_cbe_tmp237_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp106_2e_i_2e_i_2e_i_2e_i1392;
  *llvm_cbe_tmp241_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp121_2e_i_2e_i_2e_i_2e_i1402;
  *llvm_cbe_tmp244_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp124_2e_i_2e_i_2e_i_2e_i1406;
  llvm_cbe_tmp250_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp128_2e_i_2e_i_2e_i_2e_i;
  *llvm_cbe_tmp248_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp250_2e_i_2e_i_2e_i_2e_i;
  llvm_cbe_tmp253_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp131_2e_i_2e_i_2e_i_2e_i;
  *llvm_cbe_tmp251_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp253_2e_i_2e_i_2e_i_2e_i;
  llvm_cbe_tmp259_2e_i_2e_i_2e_i_2e_i = _ZL10ProcessTwoP6b2Vec2S0_S0_S0_S0_((&llvm_cbe_p1_2e_i_2e_i32), (&llvm_cbe_p2_2e_i_2e_i31), llvm_cbe_tmp21_2e_i_2e_i_2e_i_2e_i174, llvm_cbe_tmp34_2e_i_2e_i_2e_i_2e_i, llvm_cbe_tmp49_2e_i_2e_i_2e_i_2e_i);
  llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp259_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb288_2e_i_2e_i_2e_i_2e_i;

llvm_cbe_bb260_2e_i_2e_i_2e_i_2e_i:
  *llvm_cbe_tmp262_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp103_2e_i_2e_i_2e_i_2e_i1388;
  *llvm_cbe_tmp265_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp106_2e_i_2e_i_2e_i_2e_i1392;
  *llvm_cbe_tmp269_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp121_2e_i_2e_i_2e_i_2e_i1402;
  *llvm_cbe_tmp272_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp124_2e_i_2e_i_2e_i_2e_i1406;
  llvm_cbe_tmp278_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp128_2e_i_2e_i_2e_i_2e_i;
  *llvm_cbe_tmp276_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp278_2e_i_2e_i_2e_i_2e_i;
  llvm_cbe_tmp281_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp131_2e_i_2e_i_2e_i_2e_i;
  *llvm_cbe_tmp279_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp281_2e_i_2e_i_2e_i_2e_i;
  llvm_cbe_tmp287_2e_i_2e_i_2e_i_2e_i = _ZL12ProcessThreeP6b2Vec2S0_S0_S0_S0_((&llvm_cbe_p1_2e_i_2e_i32), (&llvm_cbe_p2_2e_i_2e_i31), llvm_cbe_tmp21_2e_i_2e_i_2e_i_2e_i174, llvm_cbe_tmp34_2e_i_2e_i_2e_i_2e_i, llvm_cbe_tmp49_2e_i_2e_i_2e_i_2e_i);
  llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp287_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb288_2e_i_2e_i_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb86.i.i.i.i' */
llvm_cbe_bb62_2e_i_2e_i_2e_i_2e_i:
  llvm_cbe_tmp6_2e_i112_2e_i_2e_i_2e_i_2e_i = _Z5b2MulRK7b2XFormRK6b2Vec2((&llvm_cbe_xf1_2e_i_2e_i30), llvm_cbe_tmp4_2e_i110_2e_i_2e_i_2e_i_2e_i);
  *llvm_cbe_tmp77_2e_i_2e_i_2e_i_2e_i = ((llvm_cbe_tmp71_2e_i_2e_i_2e_i_2e_i1367__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp6_2e_i112_2e_i_2e_i_2e_i_2e_i)), llvm_cbe_tmp71_2e_i_2e_i_2e_i_2e_i1367__BITCAST_TEMPORARY.Float));
  *llvm_cbe_tmp80_2e_i68_2e_i_2e_i_2e_i = ((llvm_cbe_tmp74_2e_i_2e_i_2e_i_2e_i1371__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp6_2e_i112_2e_i_2e_i_2e_i_2e_i) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp74_2e_i_2e_i_2e_i_2e_i1371__BITCAST_TEMPORARY.Float));
  llvm_cbe_tmp6_2e_i229_2e_i_2e_i_2e_i_2e_i = _Z5b2MulRK7b2XFormRK6b2Vec2((&llvm_cbe_xf2_2e_i_2e_i29), llvm_cbe_tmp4_2e_i227_2e_i_2e_i_2e_i_2e_i);
  *llvm_cbe_tmp95_2e_i79_2e_i_2e_i_2e_i = ((llvm_cbe_tmp82_2e_i_2e_i_2e_i_2e_i1374__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp6_2e_i229_2e_i_2e_i_2e_i_2e_i)), llvm_cbe_tmp82_2e_i_2e_i_2e_i_2e_i1374__BITCAST_TEMPORARY.Float));
  *llvm_cbe_tmp98_2e_i82_2e_i_2e_i_2e_i = ((llvm_cbe_tmp85_2e_i_2e_i_2e_i_2e_i1378__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp6_2e_i229_2e_i_2e_i_2e_i_2e_i) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp85_2e_i_2e_i_2e_i_2e_i1378__BITCAST_TEMPORARY.Float));
  llvm_cbe_iter_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = 0u;   /* for PHI node */
  llvm_cbe_pointCount_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb86_2e_i_2e_i_2e_i_2e_i;

  do {     /* Syntactic loop 'bb51.i.i.i.i' to make GCC happy */
llvm_cbe_bb51_2e_i_2e_i_2e_i_2e_i:
  llvm_cbe_tmp12_2e_i_2e_i177_2e_i_2e_i_2e_0 = llvm_cbe_tmp12_2e_i_2e_i177_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp56_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp12_2e_i_2e_i177_2e_i_2e_i_2e_0 + 18446744073709551615ull;
  if ((llvm_cbe_tmp56_2e_i_2e_i_2e_i_2e_i == 18446744073709551615ull)) {
    goto llvm_cbe_bb62_2e_i_2e_i_2e_i_2e_i;
  } else {
    llvm_cbe_tmp12_2e_i_2e_i177_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp56_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
    goto llvm_cbe_bb51_2e_i_2e_i_2e_i_2e_i;
  }

  } while (1); /* end of syntactic loop 'bb51.i.i.i.i' */
  do {     /* Syntactic loop 'bb36.i.i.i.i' to make GCC happy */
llvm_cbe_bb36_2e_i_2e_i_2e_i_2e_i:
  llvm_cbe_tmp15_2e_i_2e_i179_2e_i_2e_i_2e_0 = llvm_cbe_tmp15_2e_i_2e_i179_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp41_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp15_2e_i_2e_i179_2e_i_2e_i_2e_0 + 18446744073709551615ull;
  if ((llvm_cbe_tmp41_2e_i_2e_i_2e_i_2e_i == 18446744073709551615ull)) {
    llvm_cbe_tmp12_2e_i_2e_i177_2e_i_2e_i_2e_0__PHI_TEMPORARY = 2ull;   /* for PHI node */
    goto llvm_cbe_bb51_2e_i_2e_i_2e_i_2e_i;
  } else {
    llvm_cbe_tmp15_2e_i_2e_i179_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp41_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
    goto llvm_cbe_bb36_2e_i_2e_i_2e_i_2e_i;
  }

  } while (1); /* end of syntactic loop 'bb36.i.i.i.i' */
  do {     /* Syntactic loop 'bb.i.i.i.i' to make GCC happy */
llvm_cbe_bb_2e_i_2e_i_2e_i_2e_i:
  llvm_cbe_tmp18_2e_i_2e_i_2e_i_2e_i25_2e_0 = llvm_cbe_tmp18_2e_i_2e_i_2e_i_2e_i25_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp27_2e_i_2e_i_2e_i_2e_i179 = llvm_cbe_tmp18_2e_i_2e_i_2e_i_2e_i25_2e_0 + 18446744073709551615ull;
  if ((llvm_cbe_tmp27_2e_i_2e_i_2e_i_2e_i179 == 18446744073709551615ull)) {
    llvm_cbe_tmp15_2e_i_2e_i179_2e_i_2e_i_2e_0__PHI_TEMPORARY = 2ull;   /* for PHI node */
    goto llvm_cbe_bb36_2e_i_2e_i_2e_i_2e_i;
  } else {
    llvm_cbe_tmp18_2e_i_2e_i_2e_i_2e_i25_2e_0__PHI_TEMPORARY = llvm_cbe_tmp27_2e_i_2e_i_2e_i_2e_i179;   /* for PHI node */
    goto llvm_cbe_bb_2e_i_2e_i_2e_i_2e_i;
  }

  } while (1); /* end of syntactic loop 'bb.i.i.i.i' */
llvm_cbe_bb159_2e_i_2e_i_2e_i_2e_i:
  *llvm_cbe_tmp77_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp103_2e_i_2e_i_2e_i_2e_i1388;
  *llvm_cbe_tmp80_2e_i68_2e_i_2e_i_2e_i = llvm_cbe_tmp106_2e_i_2e_i_2e_i_2e_i1392;
  *llvm_cbe_tmp95_2e_i79_2e_i_2e_i_2e_i = llvm_cbe_tmp121_2e_i_2e_i_2e_i_2e_i1402;
  *llvm_cbe_tmp98_2e_i82_2e_i_2e_i_2e_i = llvm_cbe_tmp124_2e_i_2e_i_2e_i_2e_i1406;
  goto llvm_cbe_bb174_2e_i_2e_i_2e_i_2e_i;

llvm_cbe_bb326_2e_i_2e_i_2e_i_2e_i:
  llvm_cbe_tmp3_2e_i64_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp98_2e_i82_2e_i_2e_i_2e_i;
  llvm_cbe_tmp6_2e_i67_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp80_2e_i68_2e_i_2e_i_2e_i;
  llvm_cbe_tmp10_2e_i71_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp95_2e_i79_2e_i_2e_i_2e_i;
  llvm_cbe_tmp13_2e_i74_2e_i_2e_i_2e_i_2e_i = *llvm_cbe_tmp77_2e_i_2e_i_2e_i_2e_i;
  llvm_cbe_tmp26_2e_i_2e_i_2e_i_2e_i_2e_i143214331434_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i_2e_i_2e_i_2e_i_2e_i1425__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp10_2e_i71_2e_i_2e_i_2e_i_2e_i - llvm_cbe_tmp13_2e_i74_2e_i_2e_i_2e_i_2e_i))), llvm_cbe_tmp23_2e_i_2e_i_2e_i_2e_i_2e_i1425__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i_2e_i_2e_i_2e_i_2e_i1432__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp3_2e_i64_2e_i_2e_i_2e_i_2e_i - llvm_cbe_tmp6_2e_i67_2e_i_2e_i_2e_i_2e_i))), llvm_cbe_tmp26_2e_i_2e_i_2e_i_2e_i_2e_i1432__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp334_2e_i_2e_i_2e_i_2e_i1416 = (llvm_cbe_tmp334_2e_i_2e_i_2e_i_2e_i1416__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i_2e_i_2e_i_2e_i_2e_i143214331434_2e_ins)), llvm_cbe_tmp334_2e_i_2e_i_2e_i_2e_i1416__BITCAST_TEMPORARY.Float);
  *llvm_cbe_tmp91_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp334_2e_i_2e_i_2e_i_2e_i1416;
  llvm_cbe_tmp337_2e_i_2e_i_2e_i_2e_i1420 = (llvm_cbe_tmp337_2e_i_2e_i_2e_i_2e_i1420__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i_2e_i_2e_i_2e_i_2e_i143214331434_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp337_2e_i_2e_i_2e_i_2e_i1420__BITCAST_TEMPORARY.Float);
  *llvm_cbe_tmp94_2e_i_2e_i_2e_i_2e_i = llvm_cbe_tmp337_2e_i_2e_i_2e_i_2e_i1420;
  llvm_cbe_tmp340_2e_i_2e_i_2e_i_2e_i = sqrtf((((float )((((float )(llvm_cbe_tmp334_2e_i_2e_i_2e_i_2e_i1416 * llvm_cbe_tmp334_2e_i_2e_i_2e_i_2e_i1416))) + (((float )(llvm_cbe_tmp337_2e_i_2e_i_2e_i_2e_i1420 * llvm_cbe_tmp337_2e_i_2e_i_2e_i_2e_i1420)))))));
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i_2e_i_2e_i_2e_i_2e_i143214331434_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp6_2e_i229_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp6_2e_i112_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i191_2e_i_2e_i_2e_i_2e_i146714681469_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp20_2e_i283_2e_i_2e_i_2e_i_2e_i150215031504_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i331_2e_i_2e_i_2e_i_2e_i151615171518_2e_ins;   /* for PHI node */
  llvm_cbe_tmp_2e_i183_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp340_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe__Z10b2DistanceP6b2Vec2S0_PK7b2ShapeRK7b2XFormS3_S6__2e_exit_2e_i_2e_i;

llvm_cbe_bb349_2e_i_2e_i_2e_i_2e_i:
  llvm_cbe_tmp351_2e_i_2e_i_2e_i_2e_i = sqrtf(llvm_cbe_tmp15_2e_i216_2e_i_2e_i_2e_i_2e_i);
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp6_2e_i229_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp6_2e_i112_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i191_2e_i_2e_i_2e_i_2e_i146714681469_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp20_2e_i283_2e_i_2e_i_2e_i_2e_i150215031504_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i331_2e_i_2e_i_2e_i_2e_i151615171518_2e_ins;   /* for PHI node */
  llvm_cbe_tmp_2e_i183_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp351_2e_i_2e_i_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe__Z10b2DistanceP6b2Vec2S0_PK7b2ShapeRK7b2XFormS3_S6__2e_exit_2e_i_2e_i;

llvm_cbe_bb99_2e_i_2e_i:
  if ((llvm_fcmp_ogt(llvm_cbe_tmp_2e_i183_2e_i_2e_i_2e_0, 0x1.47ae14p-4))) {
    llvm_cbe_targetDistance_2e_i_2e_i_2e_0__PHI_TEMPORARY = 0x1.eb851ep-5;   /* for PHI node */
    goto llvm_cbe_bb109_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb105_2e_i_2e_i;
  }

llvm_cbe_bb105_2e_i_2e_i:
  llvm_cbe_tmp107_2e_i_2e_i188 = ((float )(llvm_cbe_tmp_2e_i183_2e_i_2e_i_2e_0 - 0x1.47ae14p-6));
  llvm_cbe_storemerge_2e_i164_2e_i_2e_i = (((llvm_fcmp_olt(llvm_cbe_tmp107_2e_i_2e_i188, 0x1.0624dep-9))) ? (0x1.0624dep-9) : (llvm_cbe_tmp107_2e_i_2e_i188));
  llvm_cbe_targetDistance_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_storemerge_2e_i164_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb109_2e_i_2e_i;

llvm_cbe_bb6_2e_i103_2e_i_2e_i:
  llvm_cbe_tmp8_2e_i87_2e_i_2e_i = ((float )(0x1p+0 / llvm_cbe_tmp16_2e_i_2e_i_2e_i_2e_i201));
  llvm_cbe_tmp13_2e_i92_2e_i_2e_i = ((float )(llvm_cbe_tmp127_2e_i_2e_i1891325 * llvm_cbe_tmp8_2e_i87_2e_i_2e_i));
  llvm_cbe_tmp20_2e_i99_2e_i_2e_i = ((float )(llvm_cbe_tmp130_2e_i374_2e_i1329 * llvm_cbe_tmp8_2e_i87_2e_i_2e_i));
  llvm_cbe_normal_2e_i_2e_i_2e_0_2e_0__PHI_TEMPORARY = llvm_cbe_tmp13_2e_i92_2e_i_2e_i;   /* for PHI node */
  llvm_cbe_normal_2e_i_2e_i_2e_1_2e_0__PHI_TEMPORARY = llvm_cbe_tmp20_2e_i99_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe__ZN6b2Vec29NormalizeEv_2e_exit_2e_i_2e_i;

llvm_cbe_bb_2e_i_2e_i_2e_i:
  llvm_cbe_tmp5_2e_i_2e_i406_2e_i = ((float )(-(llvm_cbe_tmp150_2e_i_2e_i212)));
  llvm_cbe_storemerge_2e_i_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp5_2e_i_2e_i406_2e_i;   /* for PHI node */
  goto llvm_cbe__Z5b2Absf_2e_exit_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb81.i.i' */
llvm_cbe_bb33_2e_i_2e_i:
  llvm_cbe_tmp3_2e_i219_2e_i_2e_i = *((&llvm_cbe_tmp3_2e_i207_2e_i->field3.field2.field1));
  llvm_cbe_tmp6_2e_i222_2e_i_2e_i = *((&llvm_cbe_tmp3_2e_i207_2e_i->field3.field1.field1));
  llvm_cbe_tmp10_2e_i226_2e_i_2e_i = *((&llvm_cbe_tmp3_2e_i207_2e_i->field3.field2.field0));
  llvm_cbe_tmp13_2e_i229_2e_i_2e_i = *((&llvm_cbe_tmp3_2e_i207_2e_i->field3.field1.field0));
  llvm_cbe_tmp26_2e_i248_2e_i_2e_i169116921693_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i245_2e_i_2e_i1684__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp10_2e_i226_2e_i_2e_i - llvm_cbe_tmp13_2e_i229_2e_i_2e_i))), llvm_cbe_tmp23_2e_i245_2e_i_2e_i1684__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i248_2e_i_2e_i1691__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp3_2e_i219_2e_i_2e_i - llvm_cbe_tmp6_2e_i222_2e_i_2e_i))), llvm_cbe_tmp26_2e_i248_2e_i_2e_i1691__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp3_2e_i284_2e_i_2e_i = *((&llvm_cbe_tmp3_2e_i279_2e_i->field3.field2.field1));
  llvm_cbe_tmp6_2e_i287_2e_i_2e_i = *((&llvm_cbe_tmp3_2e_i279_2e_i->field3.field1.field1));
  llvm_cbe_tmp10_2e_i291_2e_i_2e_i = *((&llvm_cbe_tmp3_2e_i279_2e_i->field3.field2.field0));
  llvm_cbe_tmp13_2e_i294_2e_i_2e_i = *((&llvm_cbe_tmp3_2e_i279_2e_i->field3.field1.field0));
  llvm_cbe_tmp26_2e_i313_2e_i_2e_i170517061707_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i310_2e_i_2e_i1698__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp10_2e_i291_2e_i_2e_i - llvm_cbe_tmp13_2e_i294_2e_i_2e_i))), llvm_cbe_tmp23_2e_i310_2e_i_2e_i1698__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i313_2e_i_2e_i1705__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp3_2e_i284_2e_i_2e_i - llvm_cbe_tmp6_2e_i287_2e_i_2e_i))), llvm_cbe_tmp26_2e_i313_2e_i_2e_i1705__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp63_2e_i342_2e_i = *((&llvm_cbe_tmp3_2e_i207_2e_i->field3.field4));
  llvm_cbe_tmp66_2e_i345_2e_i = *((&llvm_cbe_tmp3_2e_i207_2e_i->field3.field3));
  llvm_cbe_tmp67_2e_i346_2e_i = ((float )(llvm_cbe_tmp63_2e_i342_2e_i - llvm_cbe_tmp66_2e_i345_2e_i));
  llvm_cbe_tmp70_2e_i347_2e_i = *((&llvm_cbe_tmp3_2e_i279_2e_i->field3.field4));
  llvm_cbe_tmp73_2e_i350_2e_i = *((&llvm_cbe_tmp3_2e_i279_2e_i->field3.field3));
  llvm_cbe_tmp74_2e_i351_2e_i = ((float )(llvm_cbe_tmp70_2e_i347_2e_i - llvm_cbe_tmp73_2e_i350_2e_i));
  llvm_cbe_tmp2_2e_i_2e_i185_2e_i_2e_i = (&llvm_cbe_tmp186_2e_i->field1);
  llvm_cbe_tmp2_2e_i5_2e_i_2e_i_2e_i = (&llvm_cbe_tmp181_2e_i->field1);
  llvm_cbe_tmp1314_2e_i_2e_i_2e_i = ((struct l_struct_2E_b2CircleShape *)llvm_cbe_tmp181_2e_i);
  llvm_cbe_tmp1516_2e_i_2e_i_2e_i = ((struct l_struct_2E_b2CircleShape *)llvm_cbe_tmp186_2e_i);
  llvm_cbe_tmp2_2e_i_2e_i38_2e_i_2e_i_2e_i = (&llvm_cbe_tmp1516_2e_i_2e_i_2e_i->field1);
  llvm_cbe_tmp2_2e_i472_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_tmp1314_2e_i_2e_i_2e_i->field1);
  llvm_cbe_tmp2_2e_i401_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_tmp1516_2e_i_2e_i_2e_i->field2);
  llvm_cbe_tmp2_2e_i398_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_tmp1314_2e_i_2e_i_2e_i->field2);
  llvm_cbe_tmp23_2e_i_2e_i389_2e_i13411342 = ((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i_2e_i389_2e_i1341__BITCAST_TEMPORARY.Float = (((float )(((llvm_cbe_tmp45_2e_i328_2e_i1311__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i248_2e_i_2e_i169116921693_2e_ins)), llvm_cbe_tmp45_2e_i328_2e_i1311__BITCAST_TEMPORARY.Float)) - ((llvm_cbe_tmp57_2e_i_2e_i1621318__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i313_2e_i_2e_i170517061707_2e_ins)), llvm_cbe_tmp57_2e_i_2e_i1621318__BITCAST_TEMPORARY.Float))))), llvm_cbe_tmp23_2e_i_2e_i389_2e_i1341__BITCAST_TEMPORARY.Int32)));
  llvm_cbe_tmp26_2e_i_2e_i392_2e_i134813491350 = (((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i_2e_i392_2e_i1348__BITCAST_TEMPORARY.Float = (((float )(((llvm_cbe_tmp48_2e_i331_2e_i1315__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i248_2e_i_2e_i169116921693_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp48_2e_i331_2e_i1315__BITCAST_TEMPORARY.Float)) - ((llvm_cbe_tmp60_2e_i340_2e_i1322__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i313_2e_i_2e_i170517061707_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp60_2e_i340_2e_i1322__BITCAST_TEMPORARY.Float))))), llvm_cbe_tmp26_2e_i_2e_i392_2e_i1348__BITCAST_TEMPORARY.Int32)))) << 32ull;
  llvm_cbe_tmp5_2e_i46_2e_i_2e_i = ((float )(-(llvm_cbe_tmp67_2e_i346_2e_i)));
  llvm_cbe_tmp5_2e_i35_2e_i_2e_i = ((float )(-(llvm_cbe_tmp74_2e_i351_2e_i)));
  llvm_cbe_tmp3536_2e_i_2e_i_2e_i = ((struct l_struct_2E_b2PolygonShape *)llvm_cbe_tmp186_2e_i);
  llvm_cbe_tmp5556_2e_i_2e_i_2e_i = ((struct l_struct_2E_b2PolygonShape *)llvm_cbe_tmp181_2e_i);
  llvm_cbe_tmp4_2e_i110_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_tmp3536_2e_i_2e_i_2e_i->field5[((signed long long )0ull)]);
  llvm_cbe_tmp4_2e_i227_2e_i_2e_i_2e_i_2e_i = (&llvm_cbe_tmp5556_2e_i_2e_i_2e_i->field5[((signed long long )0ull)]);
  llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_targetDistance_2e_i_2e_i_2e_1__PHI_TEMPORARY = 0x0p+0;   /* for PHI node */
  llvm_cbe_iter_2e_i_2e_i_2e_0__PHI_TEMPORARY = 0u;   /* for PHI node */
  llvm_cbe_alpha_2e_i_2e_i_2e_1__PHI_TEMPORARY = 0x0p+0;   /* for PHI node */
  goto llvm_cbe_bb81_2e_i_2e_i;

llvm_cbe_bb21_2e_i_2e_i:
  if ((llvm_fcmp_ule((((float )(0x1p+0 - llvm_cbe_tmp12_2e_i311_2e_i))), 0x1p-23))) {
    goto llvm_cbe_bb29_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb33_2e_i_2e_i;
  }

llvm_cbe_bb176_2e_i:
  llvm_cbe_tmp178_2e_i = (&llvm_cbe_tmp3_2e_i279_2e_i->field3);
  llvm_cbe_tmp181_2e_i = *llvm_cbe_tmp2_2e_i54_2e_i;
  llvm_cbe_tmp183_2e_i155 = (&llvm_cbe_tmp3_2e_i207_2e_i->field3);
  llvm_cbe_tmp186_2e_i = *llvm_cbe_tmp2_2e_i51_2e_i;
  llvm_cbe_tmp3_2e_i_2e_i307_2e_i = *((&llvm_cbe_tmp186_2e_i->field4));
  llvm_cbe_tmp3_2e_i205_2e_i_2e_i = *((&llvm_cbe_tmp181_2e_i->field4));
  llvm_cbe_tmp12_2e_i311_2e_i = *((&llvm_cbe_tmp3_2e_i207_2e_i->field3.field5));
  llvm_cbe_tmp15_2e_i314_2e_i = *((&llvm_cbe_tmp3_2e_i279_2e_i->field3.field5));
  if ((llvm_fcmp_une(llvm_cbe_tmp12_2e_i311_2e_i, llvm_cbe_tmp15_2e_i314_2e_i))) {
    goto llvm_cbe_bb_2e_i316_2e_i;
  } else {
    goto llvm_cbe_bb21_2e_i_2e_i;
  }

llvm_cbe_bb167_2e_i:
  llvm_cbe_t0_2e_i_2e_0 = llvm_cbe_t0_2e_i_2e_0__PHI_TEMPORARY;
  if ((llvm_fcmp_uge(llvm_cbe_t0_2e_i_2e_0, 0x1p+0))) {
    goto llvm_cbe_bb172_2e_i;
  } else {
    goto llvm_cbe_bb176_2e_i;
  }

llvm_cbe_bb137_2e_i:
  _ZN7b2Sweep7AdvanceEf(((&llvm_cbe_tmp3_2e_i207_2e_i->field3)), llvm_cbe_tmp133_2e_i139);
  llvm_cbe_t0_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp133_2e_i139;   /* for PHI node */
  goto llvm_cbe_bb167_2e_i;

llvm_cbe_bb121_2e_i141:
  llvm_cbe_tmp125_2e_i = *((&llvm_cbe_tmp3_2e_i207_2e_i->field3.field5));
  llvm_cbe_tmp133_2e_i139 = *((&llvm_cbe_tmp3_2e_i279_2e_i->field3.field5));
  if ((llvm_fcmp_olt(llvm_cbe_tmp125_2e_i, llvm_cbe_tmp133_2e_i139))) {
    goto llvm_cbe_bb137_2e_i;
  } else {
    goto llvm_cbe_bb146_2e_i;
  }

llvm_cbe_bb146_2e_i:
  if ((llvm_fcmp_olt(llvm_cbe_tmp133_2e_i139, llvm_cbe_tmp125_2e_i))) {
    goto llvm_cbe_bb158_2e_i;
  } else {
    llvm_cbe_t0_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp125_2e_i;   /* for PHI node */
    goto llvm_cbe_bb167_2e_i;
  }

llvm_cbe_bb158_2e_i:
  _ZN7b2Sweep7AdvanceEf(((&llvm_cbe_tmp3_2e_i279_2e_i->field3)), llvm_cbe_tmp125_2e_i);
  llvm_cbe_t0_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp125_2e_i;   /* for PHI node */
  goto llvm_cbe_bb167_2e_i;

llvm_cbe__Z14b2TimeOfImpactPK7b2ShapeRK7b2SweepS1_S4__2e_exit_2e_i:
  llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  *(&llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reg2mem) = llvm_cbe_alpha_2e_i_2e_i_2e_1;
  *(&llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_1_2e_reg2mem) = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_1;
  *(&llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_1_2e_reg2mem) = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_1;
  llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2165 = *(&llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reg2mem);
  if ((llvm_fcmp_ult(llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2165, 0x0p+0))) {
    goto llvm_cbe_bb198_2e_i;
  } else {
    goto llvm_cbe_bb193_2e_i;
  }

llvm_cbe_bb207_2e_i:
  llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2162 = *(&llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reg2mem);
  llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2161 = *(&llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reg2mem);
  if ((llvm_fcmp_olt(llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2162, 0x1p+0))) {
    goto llvm_cbe_bb212_2e_i;
  } else {
    llvm_cbe_toi_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2161;   /* for PHI node */
    goto llvm_cbe_bb220_2e_i;
  }

llvm_cbe_bb212_2e_i:
  llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2159 = *(&llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reg2mem);
  llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload = *(&llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reg2mem);
  llvm_cbe_tmp218_2e_i = ((float )((((float )((((float )(0x1p+0 - llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload2159))) * llvm_cbe_t0_2e_i_2e_0))) + llvm_cbe_alpha_2e_i_2e_i_2e_0_2e_reload));
  llvm_cbe_storemerge_2e_i288_2e_i = (((llvm_fcmp_olt(llvm_cbe_tmp218_2e_i, 0x1p+0))) ? (llvm_cbe_tmp218_2e_i) : (0x1p+0));
  llvm_cbe_toi_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_storemerge_2e_i288_2e_i;   /* for PHI node */
  goto llvm_cbe_bb220_2e_i;

llvm_cbe_bb241_2e_i:
  llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_0;   /* for PHI node */
  llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_0;   /* for PHI node */
  llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_4__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_minTOI_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_toi_2e_i_2e_0;   /* for PHI node */
  llvm_cbe_minContact_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_storemerge3_2e_i;   /* for PHI node */
  goto llvm_cbe_bb244_2e_i;

  } while (1); /* end of syntactic loop 'bb248.i' */
llvm_cbe_bb589_2e_i:
  llvm_cbe_tmp592_2e_i = *llvm_cbe_tmp591_2e_i456;
  _ZN13b2PairManager6CommitEv(((&llvm_cbe_tmp592_2e_i->field0)));
  llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i110_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i277_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i212_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i62_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i61_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i95_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i101_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i427_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i169_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i218_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i263_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i312_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i220_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_5__PHI_TEMPORARY = llvm_cbe_retval_2e_i104_2e_i_2e_i_2e_i_2e_i_2e_4;   /* for PHI node */
  llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i155_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i253_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_6__PHI_TEMPORARY = llvm_cbe_retval_2e_i295_2e_i_2e_i_2e_i_2e_i_2e_5;   /* for PHI node */
  goto llvm_cbe_bb67_2e_i;

  do {     /* Syntactic loop 'bb582.i' to make GCC happy */
llvm_cbe_bb582_2e_i:
  llvm_cbe_storemerge7_2e_i = llvm_cbe_storemerge7_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp584_2e_i = *llvm_cbe_tmp12_2e_i_2e_i64;
  if ((((signed int )llvm_cbe_tmp584_2e_i) > ((signed int )llvm_cbe_storemerge7_2e_i))) {
    goto llvm_cbe_bb567_2e_i;
  } else {
    goto llvm_cbe_bb589_2e_i;
  }

llvm_cbe_bb567_2e_i:
  llvm_cbe_tmp569_2e_i446 = *llvm_cbe_tmp42_2e_i_2e_i86;
  llvm_cbe_tmp573_2e_i448 = *((&llvm_cbe_tmp569_2e_i446[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge7_2e_i)))]));
  llvm_cbe_tmp575_2e_i449 = (&llvm_cbe_tmp573_2e_i448->field1);
  llvm_cbe_tmp576_2e_i450 = *llvm_cbe_tmp575_2e_i449;
  *llvm_cbe_tmp575_2e_i449 = (llvm_cbe_tmp576_2e_i450 & 4294967283u);
  llvm_cbe_tmp581_2e_i453 = llvm_cbe_storemerge7_2e_i + 1u;
  llvm_cbe_storemerge7_2e_i__PHI_TEMPORARY = llvm_cbe_tmp581_2e_i453;   /* for PHI node */
  goto llvm_cbe_bb582_2e_i;

  } while (1); /* end of syntactic loop 'bb582.i' */
  do {     /* Syntactic loop 'bb559.i' to make GCC happy */
llvm_cbe_bb559_2e_i:
  llvm_cbe_storemerge6_2e_i = llvm_cbe_storemerge6_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp561_2e_i = *llvm_cbe_tmp10_2e_i_2e_i62;
  if ((((signed int )llvm_cbe_tmp561_2e_i) > ((signed int )llvm_cbe_storemerge6_2e_i))) {
    goto llvm_cbe_bb475_2e_i;
  } else {
    llvm_cbe_storemerge7_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
    goto llvm_cbe_bb582_2e_i;
  }

llvm_cbe_bb556_2e_i:
  llvm_cbe_tmp558_2e_i = llvm_cbe_storemerge6_2e_i + 1u;
  llvm_cbe_storemerge6_2e_i__PHI_TEMPORARY = llvm_cbe_tmp558_2e_i;   /* for PHI node */
  goto llvm_cbe_bb559_2e_i;

llvm_cbe_bb475_2e_i:
  llvm_cbe_tmp477_2e_i410 = *llvm_cbe_tmp31_2e_i_2e_i79;
  llvm_cbe_tmp481_2e_i413 = *((&llvm_cbe_tmp477_2e_i410[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge6_2e_i)))]));
  llvm_cbe_tmp483_2e_i414 = (&llvm_cbe_tmp481_2e_i413->field0);
  llvm_cbe_tmp484_2e_i415 = *llvm_cbe_tmp483_2e_i414;
  llvm_cbe_tmp485_2e_i416 = ((unsigned short )(llvm_cbe_tmp484_2e_i415 & ((unsigned short )-5)));
  *llvm_cbe_tmp483_2e_i414 = llvm_cbe_tmp485_2e_i416;
  if ((((((unsigned int )(unsigned short )llvm_cbe_tmp485_2e_i416)) & 10u) == 0u)) {
    goto llvm_cbe_bb496_2e_i;
  } else {
    goto llvm_cbe_bb556_2e_i;
  }

llvm_cbe_bb496_2e_i:
  llvm_cbe_tmp3_2e_i59_2e_i = *((&llvm_cbe_tmp481_2e_i413->field1));
  if ((llvm_cbe_tmp3_2e_i59_2e_i == ((unsigned short )0))) {
    goto llvm_cbe_bb556_2e_i;
  } else {
    goto llvm_cbe_bb501_2e_i;
  }

  do {     /* Syntactic loop 'bb551.i' to make GCC happy */
llvm_cbe_bb551_2e_i:
  llvm_cbe_storemerge5_2e_in_2e_i = llvm_cbe_storemerge5_2e_in_2e_i__PHI_TEMPORARY;
  llvm_cbe_storemerge5_2e_i = *llvm_cbe_storemerge5_2e_in_2e_i;
  if ((llvm_cbe_storemerge5_2e_i == ((struct l_struct_2E_b2ContactEdge *)/*NULL*/0))) {
    goto llvm_cbe_bb556_2e_i;
  } else {
    goto llvm_cbe_bb537_2e_i;
  }

llvm_cbe_bb537_2e_i:
  llvm_cbe_tmp540_2e_i = *((&llvm_cbe_storemerge5_2e_i->field1));
  llvm_cbe_tmp544_2e_i = (&llvm_cbe_tmp540_2e_i->field1);
  llvm_cbe_tmp545_2e_i = *llvm_cbe_tmp544_2e_i;
  *llvm_cbe_tmp544_2e_i = (llvm_cbe_tmp545_2e_i & 4294967287u);
  llvm_cbe_tmp549_2e_i442 = (&llvm_cbe_storemerge5_2e_i->field3);
  llvm_cbe_storemerge5_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp549_2e_i442;   /* for PHI node */
  goto llvm_cbe_bb551_2e_i;

  } while (1); /* end of syntactic loop 'bb551.i' */
llvm_cbe_bb533_2e_i:
  llvm_cbe_tmp535_2e_i437 = (&llvm_cbe_tmp481_2e_i413->field14);
  llvm_cbe_storemerge5_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp535_2e_i437;   /* for PHI node */
  goto llvm_cbe_bb551_2e_i;

llvm_cbe_bb501_2e_i:
  llvm_cbe_tmp504_2e_i428 = _ZN6b2Body17SynchronizeShapesEv(llvm_cbe_tmp481_2e_i413);
  if ((llvm_cbe_tmp504_2e_i428 == ((unsigned char )0))) {
    goto llvm_cbe_bb509_2e_i;
  } else {
    goto llvm_cbe_bb533_2e_i;
  }

llvm_cbe_bb509_2e_i:
  llvm_cbe_tmp512_2e_i430 = *llvm_cbe_tmp511_2e_i429;
  if ((llvm_cbe_tmp512_2e_i430 == ((struct l_struct_2E_Os *)/*NULL*/0))) {
    goto llvm_cbe_bb533_2e_i;
  } else {
    goto llvm_cbe_bb516_2e_i;
  }

llvm_cbe_bb516_2e_i:
  llvm_cbe_tmp524_2e_i = *((&llvm_cbe_tmp512_2e_i430->field0));
  llvm_cbe_tmp526_2e_i = *((&llvm_cbe_tmp524_2e_i[((signed long long )2ull)]));
  (((void  (*) (struct l_struct_2E_Os *, struct l_struct_2E_b2Body *))llvm_cbe_tmp526_2e_i))(llvm_cbe_tmp512_2e_i430, llvm_cbe_tmp481_2e_i413);
  goto llvm_cbe_bb533_2e_i;

  } while (1); /* end of syntactic loop 'bb559.i' */
llvm_cbe_bb123_2e_i_2e_i:
  llvm_cbe_tmp125_2e_i_2e_i = *llvm_cbe_tmp124_2e_i_2e_i;
  _ZN8b2Island6ReportEP19b2ContactConstraint((&llvm_cbe_island_2e_i), llvm_cbe_tmp125_2e_i_2e_i);
  llvm_cbe_tmp2_2e_i9_2e_i_2e_i = *llvm_cbe_tmp124_2e_i_2e_i;
  llvm_cbe_tmp5_2e_i12_2e_i_2e_i = *llvm_cbe_tmp4_2e_i11_2e_i_2e_i;
  _ZN16b2StackAllocator4FreeEPv(llvm_cbe_tmp5_2e_i12_2e_i_2e_i, (((unsigned char *)llvm_cbe_tmp2_2e_i9_2e_i_2e_i)));
  llvm_cbe_storemerge6_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb559_2e_i;

  do {     /* Syntactic loop 'bb115.i.i' to make GCC happy */
llvm_cbe_bb115_2e_i_2e_i:
  llvm_cbe_storemerge3_2e_i_2e_i = llvm_cbe_storemerge3_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp118_2e_i_2e_i402 = *llvm_cbe_tmp473_2e_i332;
  if ((((signed int )llvm_cbe_tmp118_2e_i_2e_i402) > ((signed int )llvm_cbe_storemerge3_2e_i_2e_i))) {
    goto llvm_cbe_bb107_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb123_2e_i_2e_i;
  }

llvm_cbe_bb112_2e_i_2e_i:
  llvm_cbe_tmp114_2e_i_2e_i399 = llvm_cbe_storemerge3_2e_i_2e_i + 1u;
  llvm_cbe_storemerge3_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp114_2e_i_2e_i399;   /* for PHI node */
  goto llvm_cbe_bb115_2e_i_2e_i;

llvm_cbe_bb107_2e_i_2e_i:
  llvm_cbe_tmp109_2e_i_2e_i397 = _ZN15b2ContactSolver24SolvePositionConstraintsEf((&llvm_cbe_contactSolver_2e_i_2e_i), 0x1.8p-1);
  if ((llvm_cbe_tmp109_2e_i_2e_i397 == ((unsigned char )0))) {
    goto llvm_cbe_bb112_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb123_2e_i_2e_i;
  }

  } while (1); /* end of syntactic loop 'bb115.i.i' */
  do {     /* Syntactic loop 'bb98.i.i' to make GCC happy */
llvm_cbe_bb98_2e_i_2e_i:
  llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_storemerge1_2e_i_2e_i = llvm_cbe_storemerge1_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp101_2e_i_2e_i396 = *llvm_cbe_tmp10_2e_i_2e_i62;
  if ((((signed int )llvm_cbe_tmp101_2e_i_2e_i396) > ((signed int )llvm_cbe_storemerge1_2e_i_2e_i))) {
    goto llvm_cbe_bb25_2e_i_2e_i;
  } else {
    llvm_cbe_storemerge3_2e_i_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
    goto llvm_cbe_bb115_2e_i_2e_i;
  }

llvm_cbe_bb95_2e_i_2e_i:
  llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_0 = llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp97_2e_i_2e_i393 = llvm_cbe_storemerge1_2e_i_2e_i + 1u;
  llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_0;   /* for PHI node */
  llvm_cbe_storemerge1_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp97_2e_i_2e_i393;   /* for PHI node */
  goto llvm_cbe_bb98_2e_i_2e_i;

llvm_cbe_bb25_2e_i_2e_i:
  llvm_cbe_tmp28_2e_i83_2e_i = *llvm_cbe_tmp31_2e_i_2e_i79;
  llvm_cbe_tmp32_2e_i85_2e_i = *((&llvm_cbe_tmp28_2e_i83_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_storemerge1_2e_i_2e_i)))]));
  llvm_cbe_tmp3_2e_i_2e_i_2e_i338 = *((&llvm_cbe_tmp32_2e_i85_2e_i->field1));
  if ((llvm_cbe_tmp3_2e_i_2e_i_2e_i338 == ((unsigned short )0))) {
    llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_1;   /* for PHI node */
    goto llvm_cbe_bb95_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb37_2e_i_2e_i;
  }

llvm_cbe_bb37_2e_i_2e_i:
  llvm_cbe_tmp43_2e_i89_2e_i = *((&llvm_cbe_tmp32_2e_i85_2e_i->field3.field2.field0));
  llvm_cbe_tmp46_2e_i_2e_i341 = *((&llvm_cbe_tmp32_2e_i85_2e_i->field3.field2.field1));
  *((&llvm_cbe_tmp32_2e_i85_2e_i->field3.field1.field0)) = llvm_cbe_tmp43_2e_i89_2e_i;
  *((&llvm_cbe_tmp32_2e_i85_2e_i->field3.field1.field1)) = llvm_cbe_tmp46_2e_i_2e_i341;
  llvm_cbe_tmp58_2e_i_2e_i344 = (&llvm_cbe_tmp32_2e_i85_2e_i->field3.field4);
  llvm_cbe_tmp59_2e_i_2e_i345 = *llvm_cbe_tmp58_2e_i_2e_i344;
  *((&llvm_cbe_tmp32_2e_i85_2e_i->field3.field3)) = llvm_cbe_tmp59_2e_i_2e_i345;
  llvm_cbe_tmp67_2e_i_2e_i350 = *llvm_cbe_tmp455_2e_i;
  llvm_cbe_tmp3_2e_i17_2e_i_2e_i = *((&llvm_cbe_tmp32_2e_i85_2e_i->field4.field1));
  llvm_cbe_tmp8_2e_i_2e_i_2e_i354 = *((&llvm_cbe_tmp32_2e_i85_2e_i->field4.field0));
  llvm_cbe_tmp22_2e_i_2e_i_2e_i372130613071308_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp19_2e_i_2e_i_2e_i3691299__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp8_2e_i_2e_i_2e_i354 * llvm_cbe_tmp67_2e_i_2e_i350))), llvm_cbe_tmp19_2e_i_2e_i_2e_i3691299__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp22_2e_i_2e_i_2e_i3721306__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp3_2e_i17_2e_i_2e_i * llvm_cbe_tmp67_2e_i_2e_i350))), llvm_cbe_tmp22_2e_i_2e_i_2e_i3721306__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp1_2e_i23_2e_i_2e_i = (&llvm_cbe_tmp32_2e_i85_2e_i->field3.field2.field0);
  llvm_cbe_tmp2_2e_i24_2e_i_2e_i = *llvm_cbe_tmp1_2e_i23_2e_i_2e_i;
  *llvm_cbe_tmp1_2e_i23_2e_i_2e_i = (((float )(llvm_cbe_tmp2_2e_i24_2e_i_2e_i + ((llvm_cbe_tmp72_2e_i_2e_i3811290__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp22_2e_i_2e_i_2e_i372130613071308_2e_ins)), llvm_cbe_tmp72_2e_i_2e_i3811290__BITCAST_TEMPORARY.Float)))));
  llvm_cbe_tmp10_2e_i32_2e_i_2e_i = (&llvm_cbe_tmp32_2e_i85_2e_i->field3.field2.field1);
  llvm_cbe_tmp11_2e_i33_2e_i_2e_i = *llvm_cbe_tmp10_2e_i32_2e_i_2e_i;
  *llvm_cbe_tmp10_2e_i32_2e_i_2e_i = (((float )(llvm_cbe_tmp11_2e_i33_2e_i_2e_i + ((llvm_cbe_tmp75_2e_i_2e_i1294__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp22_2e_i_2e_i_2e_i372130613071308_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp75_2e_i_2e_i1294__BITCAST_TEMPORARY.Float)))));
  llvm_cbe_tmp85_2e_i_2e_i388 = *llvm_cbe_tmp455_2e_i;
  llvm_cbe_tmp88_2e_i_2e_i = *((&llvm_cbe_tmp32_2e_i85_2e_i->field5));
  *llvm_cbe_tmp58_2e_i_2e_i344 = (((float )(llvm_cbe_tmp59_2e_i_2e_i345 + (((float )(llvm_cbe_tmp85_2e_i_2e_i388 * llvm_cbe_tmp88_2e_i_2e_i))))));
  _ZN6b2Body20SynchronizeTransformEv(llvm_cbe_tmp32_2e_i85_2e_i);
  llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp22_2e_i_2e_i_2e_i372130613071308_2e_ins;   /* for PHI node */
  goto llvm_cbe_bb95_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb98.i.i' */
  do {     /* Syntactic loop 'bb17.i.i' to make GCC happy */
llvm_cbe_bb17_2e_i_2e_i:
  llvm_cbe_storemerge_2e_i_2e_i = llvm_cbe_storemerge_2e_i_2e_i__PHI_TEMPORARY;
  llvm_cbe_tmp20_2e_i79_2e_i = *llvm_cbe_tmp473_2e_i332;
  if ((((signed int )llvm_cbe_tmp20_2e_i79_2e_i) > ((signed int )llvm_cbe_storemerge_2e_i_2e_i))) {
    goto llvm_cbe_bb_2e_i_2e_i334;
  } else {
    llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i14_2e_i_2e_i_2e_3;   /* for PHI node */
    llvm_cbe_storemerge1_2e_i_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
    goto llvm_cbe_bb98_2e_i_2e_i;
  }

llvm_cbe_bb_2e_i_2e_i334:
  _ZN15b2ContactSolver24SolveVelocityConstraintsEv((&llvm_cbe_contactSolver_2e_i_2e_i));
  llvm_cbe_tmp16_2e_i76_2e_i = llvm_cbe_storemerge_2e_i_2e_i + 1u;
  llvm_cbe_storemerge_2e_i_2e_i__PHI_TEMPORARY = llvm_cbe_tmp16_2e_i76_2e_i;   /* for PHI node */
  goto llvm_cbe_bb17_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb17.i.i' */
llvm_cbe_bb465_2e_i:
  *llvm_cbe_tmp469_2e_i = (((float )(0x1p+0 / llvm_cbe_tmp454_2e_i)));
  llvm_cbe_tmp472_2e_i331 = *llvm_cbe_tmp4;
  *llvm_cbe_tmp473_2e_i332 = llvm_cbe_tmp472_2e_i331;
  llvm_cbe_tmp7_2e_i67_2e_i = *llvm_cbe_tmp16_2e_i_2e_i68;
  llvm_cbe_tmp10_2e_i70_2e_i = *llvm_cbe_tmp12_2e_i_2e_i64;
  llvm_cbe_tmp13_2e_i73_2e_i = *llvm_cbe_tmp42_2e_i_2e_i86;
  _ZN15b2ContactSolverC1ERK10b2TimeStepPP9b2ContactiP16b2StackAllocator((&llvm_cbe_contactSolver_2e_i_2e_i), (&llvm_cbe_subStep_2e_i), llvm_cbe_tmp13_2e_i73_2e_i, llvm_cbe_tmp10_2e_i70_2e_i, llvm_cbe_tmp7_2e_i67_2e_i);
  llvm_cbe_storemerge_2e_i_2e_i__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb17_2e_i_2e_i;

llvm_cbe_bb448_2e_i:
  llvm_cbe_tmp453_2e_i325 = *llvm_cbe_tmp2;
  llvm_cbe_tmp454_2e_i = ((float )((((float )(0x1p+0 - llvm_cbe_minTOI_2e_i_2e_1))) * llvm_cbe_tmp453_2e_i325));
  *llvm_cbe_tmp455_2e_i = llvm_cbe_tmp454_2e_i;
  if ((llvm_fcmp_ule(llvm_cbe_tmp454_2e_i, 0x1p-23))) {
    goto llvm_cbe_bb461_2e_i;
  } else {
    goto llvm_cbe_bb465_2e_i;
  }

  do {     /* Syntactic loop 'bb323.i' to make GCC happy */
llvm_cbe_bb323_2e_i:
  llvm_cbe_stackCount_2e_i_2e_0_2e_reload = *(&llvm_cbe_stackCount_2e_i_2e_0_2e_reg2mem);
  llvm_cbe_tmp325_2e_i = llvm_cbe_stackCount_2e_i_2e_0_2e_reload + 4294967295u;
  llvm_cbe_tmp330_2e_i275 = *((&llvm_cbe_tmp2728_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_tmp325_2e_i)))]));
  llvm_cbe_tmp2_2e_i170_2e_i = *llvm_cbe_tmp10_2e_i_2e_i62;
  llvm_cbe_tmp5_2e_i173_2e_i = *llvm_cbe_tmp1_2e_i_2e_i53;
  if ((((signed int )llvm_cbe_tmp2_2e_i170_2e_i) < ((signed int )llvm_cbe_tmp5_2e_i173_2e_i))) {
    goto llvm_cbe__ZN8b2Island3AddEP6b2Body_2e_exit_2e_i;
  } else {
    goto llvm_cbe_bb_2e_i175_2e_i;
  }

llvm_cbe_bb443_2e_i:
  llvm_cbe_stackCount_2e_i_2e_0_2e_be = llvm_cbe_stackCount_2e_i_2e_0_2e_be__PHI_TEMPORARY;
  *(&llvm_cbe_stackCount_2e_i_2e_0_2e_reg2mem) = llvm_cbe_stackCount_2e_i_2e_0_2e_be;
  if ((((signed int )llvm_cbe_stackCount_2e_i_2e_0_2e_be) > ((signed int )0u))) {
    goto llvm_cbe_bb323_2e_i;
  } else {
    goto llvm_cbe_bb448_2e_i;
  }

llvm_cbe__ZN8b2Island3AddEP6b2Body_2e_exit_2e_i:
  llvm_cbe_tmp14_2e_i178_2e_i = *llvm_cbe_tmp31_2e_i_2e_i79;
  *((&llvm_cbe_tmp14_2e_i178_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_tmp2_2e_i170_2e_i)))])) = llvm_cbe_tmp330_2e_i275;
  *llvm_cbe_tmp10_2e_i_2e_i62 = (llvm_cbe_tmp2_2e_i170_2e_i + 1u);
  llvm_cbe_tmp333_2e_i277 = (&llvm_cbe_tmp330_2e_i275->field0);
  llvm_cbe_tmp334_2e_i = *llvm_cbe_tmp333_2e_i277;
  *llvm_cbe_tmp333_2e_i277 = (((unsigned short )(llvm_cbe_tmp334_2e_i & ((unsigned short )-9))));
  llvm_cbe_tmp3_2e_i162_2e_i = *((&llvm_cbe_tmp330_2e_i275->field1));
  if ((llvm_cbe_tmp3_2e_i162_2e_i == ((unsigned short )0))) {
    llvm_cbe_stackCount_2e_i_2e_0_2e_be__PHI_TEMPORARY = llvm_cbe_tmp325_2e_i;   /* for PHI node */
    goto llvm_cbe_bb443_2e_i;
  } else {
    goto llvm_cbe_bb342_2e_i;
  }

  do {     /* Syntactic loop 'bb438.i' to make GCC happy */
llvm_cbe_bb438_2e_i:
  llvm_cbe_stackCount_2e_i_2e_2 = llvm_cbe_stackCount_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_storemerge4_2e_in_2e_i = llvm_cbe_storemerge4_2e_in_2e_i__PHI_TEMPORARY;
  llvm_cbe_storemerge4_2e_i = *llvm_cbe_storemerge4_2e_in_2e_i;
  if ((llvm_cbe_storemerge4_2e_i == ((struct l_struct_2E_b2ContactEdge *)/*NULL*/0))) {
    llvm_cbe_stackCount_2e_i_2e_0_2e_be__PHI_TEMPORARY = llvm_cbe_stackCount_2e_i_2e_2;   /* for PHI node */
    goto llvm_cbe_bb443_2e_i;
  } else {
    goto llvm_cbe_bb346_2e_i;
  }

llvm_cbe_bb434_2e_i:
  llvm_cbe_stackCount_2e_i_2e_1 = llvm_cbe_stackCount_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_tmp436_2e_i = (&llvm_cbe_storemerge4_2e_i->field3);
  llvm_cbe_stackCount_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_stackCount_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_storemerge4_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp436_2e_i;   /* for PHI node */
  goto llvm_cbe_bb438_2e_i;

llvm_cbe_bb346_2e_i:
  llvm_cbe_tmp348_2e_i281 = *llvm_cbe_tmp12_2e_i_2e_i64;
  llvm_cbe_tmp350_2e_i = *llvm_cbe_tmp4_2e_i_2e_i56;
  if ((llvm_cbe_tmp348_2e_i281 == llvm_cbe_tmp350_2e_i)) {
    llvm_cbe_stackCount_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_stackCount_2e_i_2e_2;   /* for PHI node */
    goto llvm_cbe_bb434_2e_i;
  } else {
    goto llvm_cbe_bb354_2e_i;
  }

llvm_cbe_bb354_2e_i:
  llvm_cbe_tmp356_2e_i = (&llvm_cbe_storemerge4_2e_i->field1);
  llvm_cbe_tmp357_2e_i284 = *llvm_cbe_tmp356_2e_i;
  llvm_cbe_tmp359_2e_i = *((&llvm_cbe_tmp357_2e_i284->field1));
  if (((llvm_cbe_tmp359_2e_i & 7u) == 0u)) {
    goto llvm_cbe_bb364_2e_i;
  } else {
    llvm_cbe_stackCount_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_stackCount_2e_i_2e_2;   /* for PHI node */
    goto llvm_cbe_bb434_2e_i;
  }

llvm_cbe_bb364_2e_i:
  llvm_cbe_tmp3_2e_i158_2e_i = *((&llvm_cbe_tmp357_2e_i284->field2));
  if ((llvm_cbe_tmp3_2e_i158_2e_i == 0u)) {
    llvm_cbe_stackCount_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_stackCount_2e_i_2e_2;   /* for PHI node */
    goto llvm_cbe_bb434_2e_i;
  } else {
    goto llvm_cbe_bb373_2e_i;
  }

llvm_cbe__ZN8b2Island3AddEP9b2Contact_2e_exit_2e_i:
  llvm_cbe_tmp14_2e_i148_2e_i = *llvm_cbe_tmp42_2e_i_2e_i86;
  *((&llvm_cbe_tmp14_2e_i148_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_tmp348_2e_i281)))])) = llvm_cbe_tmp357_2e_i284;
  *llvm_cbe_tmp12_2e_i_2e_i64 = (llvm_cbe_tmp348_2e_i281 + 1u);
  llvm_cbe_tmp379_2e_i294 = *llvm_cbe_tmp356_2e_i;
  llvm_cbe_tmp383_2e_i297 = (&llvm_cbe_tmp379_2e_i294->field1);
  llvm_cbe_tmp384_2e_i = *llvm_cbe_tmp383_2e_i297;
  *llvm_cbe_tmp383_2e_i297 = (llvm_cbe_tmp384_2e_i | 4u);
  llvm_cbe_tmp389_2e_i = *((&llvm_cbe_storemerge4_2e_i->field0));
  llvm_cbe_tmp391_2e_i299 = (&llvm_cbe_tmp389_2e_i->field0);
  llvm_cbe_tmp392_2e_i = *llvm_cbe_tmp391_2e_i299;
  if ((((((unsigned int )(unsigned short )llvm_cbe_tmp392_2e_i)) & 4u) == 0u)) {
    goto llvm_cbe_bb398_2e_i;
  } else {
    llvm_cbe_stackCount_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_stackCount_2e_i_2e_2;   /* for PHI node */
    goto llvm_cbe_bb434_2e_i;
  }

llvm_cbe_bb373_2e_i:
  if ((((signed int )llvm_cbe_tmp348_2e_i281) < ((signed int )llvm_cbe_tmp350_2e_i))) {
    goto llvm_cbe__ZN8b2Island3AddEP9b2Contact_2e_exit_2e_i;
  } else {
    goto llvm_cbe_bb_2e_i145_2e_i;
  }

llvm_cbe_bb420_2e_i:
  *((&llvm_cbe_tmp2728_2e_i[((signed long long )(((signed long long )(signed int )llvm_cbe_stackCount_2e_i_2e_2)))])) = llvm_cbe_tmp389_2e_i;
  llvm_cbe_tmp427_2e_i = llvm_cbe_stackCount_2e_i_2e_2 + 1u;
  llvm_cbe_tmp430_2e_i317 = *llvm_cbe_tmp391_2e_i299;
  *llvm_cbe_tmp391_2e_i299 = (((unsigned short )(llvm_cbe_tmp430_2e_i317 | ((unsigned short )4))));
  llvm_cbe_stackCount_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp427_2e_i;   /* for PHI node */
  goto llvm_cbe_bb434_2e_i;

llvm_cbe_bb410_2e_i:
  if ((((signed int )llvm_cbe_stackCount_2e_i_2e_2) < ((signed int )llvm_cbe_tmp20_2e_i96))) {
    goto llvm_cbe_bb420_2e_i;
  } else {
    goto llvm_cbe_bb416_2e_i;
  }

llvm_cbe_bb398_2e_i:
  llvm_cbe_tmp3_2e_i132_2e_i = *((&llvm_cbe_tmp389_2e_i->field1));
  if ((llvm_cbe_tmp3_2e_i132_2e_i == ((unsigned short )0))) {
    goto llvm_cbe_bb410_2e_i;
  } else {
    goto llvm_cbe_bb405_2e_i;
  }

llvm_cbe_bb405_2e_i:
  _ZN7b2Sweep7AdvanceEf(((&llvm_cbe_tmp389_2e_i->field3)), llvm_cbe_minTOI_2e_i_2e_1);
  llvm_cbe_tmp9_2e_i114_2e_i = *((&llvm_cbe_tmp389_2e_i->field3.field1.field0));
  llvm_cbe_tmp12_2e_i117_2e_i = *((&llvm_cbe_tmp389_2e_i->field3.field1.field1));
  *((&llvm_cbe_tmp389_2e_i->field3.field2.field0)) = llvm_cbe_tmp9_2e_i114_2e_i;
  *((&llvm_cbe_tmp389_2e_i->field3.field2.field1)) = llvm_cbe_tmp12_2e_i117_2e_i;
  llvm_cbe_tmp25_2e_i126_2e_i = *((&llvm_cbe_tmp389_2e_i->field3.field3));
  *((&llvm_cbe_tmp389_2e_i->field3.field4)) = llvm_cbe_tmp25_2e_i126_2e_i;
  _ZN6b2Body20SynchronizeTransformEv(llvm_cbe_tmp389_2e_i);
  llvm_cbe_tmp2_2e_i100_2e_i306 = *llvm_cbe_tmp391_2e_i299;
  *llvm_cbe_tmp391_2e_i299 = (((unsigned short )(llvm_cbe_tmp2_2e_i100_2e_i306 & ((unsigned short )-9))));
  *((&llvm_cbe_tmp389_2e_i->field21)) = 0x0p+0;
  goto llvm_cbe_bb410_2e_i;

  } while (1); /* end of syntactic loop 'bb438.i' */
llvm_cbe_bb342_2e_i:
  llvm_cbe_tmp344_2e_i279 = (&llvm_cbe_tmp330_2e_i275->field14);
  llvm_cbe_stackCount_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_tmp325_2e_i;   /* for PHI node */
  llvm_cbe_storemerge4_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp344_2e_i279;   /* for PHI node */
  goto llvm_cbe_bb438_2e_i;

  } while (1); /* end of syntactic loop 'bb323.i' */
llvm_cbe_bb301_2e_i:
  llvm_cbe_tmp3_2e_i196_2e_i = *((&llvm_cbe_tmp3_2e_i267_2e_i->field1));
  llvm_cbe_seed_2e_i_2e_0 = (((llvm_cbe_tmp3_2e_i196_2e_i == ((unsigned short )0))) ? (llvm_cbe_tmp3_2e_i263_2e_i) : (llvm_cbe_tmp3_2e_i267_2e_i));
  *llvm_cbe_tmp10_2e_i_2e_i62 = 0u;
  *llvm_cbe_tmp12_2e_i_2e_i64 = 0u;
  *llvm_cbe_tmp14_2e_i_2e_i66 = 0u;
  *llvm_cbe_tmp2728_2e_i = llvm_cbe_seed_2e_i_2e_0;
  llvm_cbe_tmp318_2e_i = (&llvm_cbe_seed_2e_i_2e_0->field0);
  llvm_cbe_tmp319_2e_i269 = *llvm_cbe_tmp318_2e_i;
  *llvm_cbe_tmp318_2e_i = (((unsigned short )(llvm_cbe_tmp319_2e_i269 | ((unsigned short )4))));
  *(&llvm_cbe_stackCount_2e_i_2e_0_2e_reg2mem) = 1u;
  goto llvm_cbe_bb323_2e_i;

  } while (1); /* end of syntactic loop 'bb67.i' */
llvm_cbe_bb172_2e_i:
  __assert_fail(((&_2E_str6159[((signed long long )0ull)])), ((&_2E_str1154[((signed long long )0ull)])), 548u, ((&_ZZN7b2World8SolveTOIERK10b2TimeStepE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb_2e_i316_2e_i:
  __assert_fail(((&_2E_str166[((signed long long )0ull)])), ((&_2E_str1167[((signed long long )0ull)])), 31u, ((&_ZZ14b2TimeOfImpactPK7b2ShapeRK7b2SweepS1_S4_E19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb29_2e_i_2e_i:
  __assert_fail(((&_2E_str2168[((signed long long )0ull)])), ((&_2E_str1167[((signed long long )0ull)])), 32u, ((&_ZZ14b2TimeOfImpactPK7b2ShapeRK7b2SweepS1_S4_E19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb198_2e_i:
  __assert_fail(((&_2E_str7160[((signed long long )0ull)])), ((&_2E_str1154[((signed long long )0ull)])), 553u, ((&_ZZN7b2World8SolveTOIERK10b2TimeStepE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb_2e_i175_2e_i:
  __assert_fail(((&_2E_str2155[((signed long long )0ull)])), ((&_2E_str3156[((signed long long )0ull)])), 52u, ((&_ZZN8b2Island3AddEP6b2BodyE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb_2e_i145_2e_i:
  __assert_fail(((&_2E_str4157[((signed long long )0ull)])), ((&_2E_str3156[((signed long long )0ull)])), 58u, ((&_ZZN8b2Island3AddEP9b2ContactE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb416_2e_i:
  __assert_fail(((&_2E_str8161[((signed long long )0ull)])), ((&_2E_str1154[((signed long long )0ull)])), 668u, ((&_ZZN7b2World8SolveTOIERK10b2TimeStepE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb461_2e_i:
  __assert_fail(((&_2E_str9162[((signed long long )0ull)])), ((&_2E_str1154[((signed long long )0ull)])), 676u, ((&_ZZN7b2World8SolveTOIERK10b2TimeStepE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe__ZN7b2World8SolveTOIERK10b2TimeStep_2e_exit:
  _ZN16b2StackAllocator4FreeEPv(llvm_cbe_tmp14_2e_i, llvm_cbe_tmp27_2e_i);
  llvm_cbe_tmp2_2e_i31_2e_i = *llvm_cbe_tmp53_2e_i_2e_i91;
  llvm_cbe_tmp5_2e_i34_2e_i = *llvm_cbe_tmp16_2e_i_2e_i68;
  _ZN16b2StackAllocator4FreeEPv(llvm_cbe_tmp5_2e_i34_2e_i, (((unsigned char *)llvm_cbe_tmp2_2e_i31_2e_i)));
  llvm_cbe_tmp9_2e_i38_2e_i = *llvm_cbe_tmp42_2e_i_2e_i86;
  llvm_cbe_tmp12_2e_i41_2e_i = *llvm_cbe_tmp16_2e_i_2e_i68;
  _ZN16b2StackAllocator4FreeEPv(llvm_cbe_tmp12_2e_i41_2e_i, (((unsigned char *)llvm_cbe_tmp9_2e_i38_2e_i)));
  llvm_cbe_tmp16_2e_i45_2e_i = *llvm_cbe_tmp31_2e_i_2e_i79;
  llvm_cbe_tmp19_2e_i48_2e_i = *llvm_cbe_tmp16_2e_i_2e_i68;
  _ZN16b2StackAllocator4FreeEPv(llvm_cbe_tmp19_2e_i48_2e_i, (((unsigned char *)llvm_cbe_tmp16_2e_i45_2e_i)));
  goto llvm_cbe_bb51;

llvm_cbe_bb51:
  llvm_cbe_tmp43_2e_i = (&llvm_cbe_this->field18);
  llvm_cbe_tmp44_2e_i = *llvm_cbe_tmp43_2e_i;
  if ((llvm_cbe_tmp44_2e_i == ((struct l_struct_2E_b2DebugDraw *)/*NULL*/0))) {
    goto llvm_cbe__ZN7b2World13DrawDebugDataEv_2e_exit;
  } else {
    goto llvm_cbe_bb_2e_i14;
  }

llvm_cbe_bb_2e_i14:
  llvm_cbe_tmp3_2e_i_2e_i12 = *((&llvm_cbe_tmp44_2e_i->field1));
  if (((llvm_cbe_tmp3_2e_i_2e_i12 & 1u) == 0u)) {
    goto llvm_cbe_bb115_2e_i;
  } else {
    goto llvm_cbe_bb55_2e_i;
  }

llvm_cbe_bb55_2e_i:
  llvm_cbe_tmp5859_2e_i = ((unsigned char )((((unsigned char )(((unsigned char )(((unsigned char )(((unsigned char )llvm_cbe_tmp3_2e_i_2e_i12))) >> ((unsigned char )((unsigned char )2))))))) & ((unsigned char )1)));
  llvm_cbe_tmp61_2e_i = (&llvm_cbe_this->field5);
  llvm_cbe_tmp1_2e_i112_2e_i = (&llvm_cbe_tmp41_2e_i.field0);
  llvm_cbe_tmp4_2e_i115_2e_i = (&llvm_cbe_tmp41_2e_i.field1);
  llvm_cbe_tmp7_2e_i118_2e_i = (&llvm_cbe_tmp41_2e_i.field2);
  llvm_cbe_tmp1_2e_i321_2e_i = (&llvm_cbe_tmp39_2e_i10.field0);
  llvm_cbe_tmp4_2e_i324_2e_i = (&llvm_cbe_tmp39_2e_i10.field1);
  llvm_cbe_tmp7_2e_i327_2e_i = (&llvm_cbe_tmp39_2e_i10.field2);
  llvm_cbe_tmp1_2e_i239_2e_i = (&llvm_cbe_tmp40_2e_i.field0);
  llvm_cbe_tmp4_2e_i242_2e_i = (&llvm_cbe_tmp40_2e_i.field1);
  llvm_cbe_tmp7_2e_i245_2e_i = (&llvm_cbe_tmp40_2e_i.field2);
  llvm_cbe_storemerge1_2e_i20_2e_in__PHI_TEMPORARY = llvm_cbe_tmp61_2e_i;   /* for PHI node */
  goto llvm_cbe_bb110_2e_i;

  do {     /* Syntactic loop 'bb110.i' to make GCC happy */
llvm_cbe_bb110_2e_i:
  llvm_cbe_storemerge1_2e_i20_2e_in = llvm_cbe_storemerge1_2e_i20_2e_in__PHI_TEMPORARY;
  llvm_cbe_storemerge1_2e_i20 = *llvm_cbe_storemerge1_2e_i20_2e_in;
  if ((llvm_cbe_storemerge1_2e_i20 == ((struct l_struct_2E_b2Body *)/*NULL*/0))) {
    goto llvm_cbe_bb115_2e_i;
  } else {
    goto llvm_cbe_bb63_2e_i;
  }

llvm_cbe_bb107_2e_i:
  llvm_cbe_tmp2_2e_i590_2e_i = (&llvm_cbe_storemerge1_2e_i20->field10);
  llvm_cbe_storemerge1_2e_i20_2e_in__PHI_TEMPORARY = llvm_cbe_tmp2_2e_i590_2e_i;   /* for PHI node */
  goto llvm_cbe_bb110_2e_i;

  do {     /* Syntactic loop 'bb102.i' to make GCC happy */
llvm_cbe_bb102_2e_i:
  llvm_cbe_storemerge_2e_i19_2e_in = llvm_cbe_storemerge_2e_i19_2e_in__PHI_TEMPORARY;
  llvm_cbe_storemerge_2e_i19 = *llvm_cbe_storemerge_2e_i19_2e_in;
  if ((llvm_cbe_storemerge_2e_i19 == ((struct l_struct_2E_b2Shape *)/*NULL*/0))) {
    goto llvm_cbe_bb107_2e_i;
  } else {
    goto llvm_cbe_bb68_2e_i;
  }

llvm_cbe_bb99_2e_i:
  llvm_cbe_tmp2_2e_i594_2e_i = (&llvm_cbe_storemerge_2e_i19->field2);
  llvm_cbe_storemerge_2e_i19_2e_in__PHI_TEMPORARY = llvm_cbe_tmp2_2e_i594_2e_i;   /* for PHI node */
  goto llvm_cbe_bb102_2e_i;

llvm_cbe_bb73_2e_i:
  *llvm_cbe_tmp1_2e_i112_2e_i = 0x1p-1;
  *llvm_cbe_tmp4_2e_i115_2e_i = 0x1.ccccccp-1;
  *llvm_cbe_tmp7_2e_i118_2e_i = 0x1p-1;
  _ZN7b2World9DrawShapeEP7b2ShapeRK7b2XFormRK7b2Colorb(llvm_cbe_this, llvm_cbe_storemerge_2e_i19, llvm_cbe_tmp2_2e_i84_2e_i, (&llvm_cbe_tmp41_2e_i), llvm_cbe_tmp5859_2e_i);
  goto llvm_cbe_bb99_2e_i;

llvm_cbe_bb68_2e_i:
  llvm_cbe_tmp3_2e_i105_2e_i = *llvm_cbe_tmp2_2e_i104_2e_i;
  if ((llvm_cbe_tmp3_2e_i105_2e_i == ((unsigned short )0))) {
    goto llvm_cbe_bb73_2e_i;
  } else {
    goto llvm_cbe_bb80_2e_i;
  }

llvm_cbe_bb85_2e_i:
  *llvm_cbe_tmp1_2e_i239_2e_i = 0x1p-1;
  *llvm_cbe_tmp4_2e_i242_2e_i = 0x1p-1;
  *llvm_cbe_tmp7_2e_i245_2e_i = 0x1.ccccccp-1;
  _ZN7b2World9DrawShapeEP7b2ShapeRK7b2XFormRK7b2Colorb(llvm_cbe_this, llvm_cbe_storemerge_2e_i19, llvm_cbe_tmp2_2e_i84_2e_i, (&llvm_cbe_tmp40_2e_i), llvm_cbe_tmp5859_2e_i);
  goto llvm_cbe_bb99_2e_i;

llvm_cbe_bb80_2e_i:
  llvm_cbe_tmp3_2e_i183_2e_i = *llvm_cbe_tmp2_2e_i182_2e_i;
  if ((((((unsigned int )(unsigned short )llvm_cbe_tmp3_2e_i183_2e_i)) & 8u) == 0u)) {
    goto llvm_cbe_bb92_2e_i;
  } else {
    goto llvm_cbe_bb85_2e_i;
  }

llvm_cbe_bb92_2e_i:
  *llvm_cbe_tmp1_2e_i321_2e_i = 0x1.ccccccp-1;
  *llvm_cbe_tmp4_2e_i324_2e_i = 0x1.ccccccp-1;
  *llvm_cbe_tmp7_2e_i327_2e_i = 0x1.ccccccp-1;
  _ZN7b2World9DrawShapeEP7b2ShapeRK7b2XFormRK7b2Colorb(llvm_cbe_this, llvm_cbe_storemerge_2e_i19, llvm_cbe_tmp2_2e_i84_2e_i, (&llvm_cbe_tmp39_2e_i10), llvm_cbe_tmp5859_2e_i);
  goto llvm_cbe_bb99_2e_i;

  } while (1); /* end of syntactic loop 'bb102.i' */
llvm_cbe_bb63_2e_i:
  llvm_cbe_tmp2_2e_i84_2e_i = (&llvm_cbe_storemerge1_2e_i20->field2);
  llvm_cbe_tmp2_2e_i100_2e_i = (&llvm_cbe_storemerge1_2e_i20->field11);
  llvm_cbe_tmp2_2e_i104_2e_i = (&llvm_cbe_storemerge1_2e_i20->field1);
  llvm_cbe_tmp2_2e_i182_2e_i = (&llvm_cbe_storemerge1_2e_i20->field0);
  llvm_cbe_storemerge_2e_i19_2e_in__PHI_TEMPORARY = llvm_cbe_tmp2_2e_i100_2e_i;   /* for PHI node */
  goto llvm_cbe_bb102_2e_i;

  } while (1); /* end of syntactic loop 'bb110.i' */
llvm_cbe_bb115_2e_i:
  if (((llvm_cbe_tmp3_2e_i_2e_i12 & 2u) == 0u)) {
    goto llvm_cbe_bb143_2e_i;
  } else {
    goto llvm_cbe_bb121_2e_i;
  }

llvm_cbe_bb121_2e_i:
  llvm_cbe_tmp123_2e_i = (&llvm_cbe_this->field6);
  llvm_cbe_tmp22_2e_i569_2e_i = (&llvm_cbe_x1_2e_i_2e_i.field0);
  llvm_cbe_tmp25_2e_i572_2e_i = (&llvm_cbe_x1_2e_i_2e_i.field1);
  llvm_cbe_tmp36_2e_i_2e_i = (&llvm_cbe_x2_2e_i_2e_i.field0);
  llvm_cbe_tmp39_2e_i_2e_i = (&llvm_cbe_x2_2e_i_2e_i.field1);
  llvm_cbe_tmp51_2e_i_2e_i = (&llvm_cbe_p1_2e_i_2e_i.field0);
  llvm_cbe_tmp54_2e_i_2e_i = (&llvm_cbe_p1_2e_i_2e_i.field1);
  llvm_cbe_tmp66_2e_i_2e_i = (&llvm_cbe_p2_2e_i_2e_i.field0);
  llvm_cbe_tmp69_2e_i_2e_i = (&llvm_cbe_p2_2e_i_2e_i.field1);
  llvm_cbe_tmp1_2e_i_2e_i581_2e_i = (&llvm_cbe_color_2e_i_2e_i.field0);
  llvm_cbe_tmp4_2e_i_2e_i582_2e_i = (&llvm_cbe_color_2e_i_2e_i.field1);
  llvm_cbe_tmp7_2e_i_2e_i_2e_i = (&llvm_cbe_color_2e_i_2e_i.field2);
  llvm_cbe_tmp95_2e_i_2e_i = (&llvm_cbe_s1_2e_i_2e_i.field0);
  llvm_cbe_tmp98_2e_i_2e_i = (&llvm_cbe_s1_2e_i_2e_i.field1);
  llvm_cbe_tmp104_2e_i_2e_i = (&llvm_cbe_s2_2e_i_2e_i.field0);
  llvm_cbe_tmp107_2e_i_2e_i = (&llvm_cbe_s2_2e_i_2e_i.field1);
  llvm_cbe_storemerge11_2e_i_2e_in__PHI_TEMPORARY = llvm_cbe_tmp123_2e_i;   /* for PHI node */
  goto llvm_cbe_bb138_2e_i;

  do {     /* Syntactic loop 'bb138.i' to make GCC happy */
llvm_cbe_bb138_2e_i:
  llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_2 = llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_storemerge11_2e_i_2e_in = llvm_cbe_storemerge11_2e_i_2e_in__PHI_TEMPORARY;
  llvm_cbe_storemerge11_2e_i = *llvm_cbe_storemerge11_2e_i_2e_in;
  if ((llvm_cbe_storemerge11_2e_i == ((struct l_struct_2E_b2Joint *)/*NULL*/0))) {
    goto llvm_cbe_bb143_2e_i;
  } else {
    goto llvm_cbe_bb125_2e_i;
  }

llvm_cbe_bb135_2e_i:
  llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_1 = llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_tmp2_2e_i546_2e_i = (&llvm_cbe_storemerge11_2e_i->field3);
  llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_storemerge11_2e_i_2e_in__PHI_TEMPORARY = llvm_cbe_tmp2_2e_i546_2e_i;   /* for PHI node */
  goto llvm_cbe_bb138_2e_i;

llvm_cbe_bb125_2e_i:
  llvm_cbe_tmp2_2e_i586_2e_i = (&llvm_cbe_storemerge11_2e_i->field1);
  llvm_cbe_tmp3_2e_i587_2e_i = *llvm_cbe_tmp2_2e_i586_2e_i;
  if ((llvm_cbe_tmp3_2e_i587_2e_i == 5u)) {
    llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    goto llvm_cbe_bb135_2e_i;
  } else {
    goto llvm_cbe_bb132_2e_i;
  }

llvm_cbe_bb132_2e_i:
  llvm_cbe_tmp3_2e_i_2e_i558_2e_i = *((&llvm_cbe_storemerge11_2e_i->field6));
  llvm_cbe_tmp3_2e_i69_2e_i_2e_i = *((&llvm_cbe_storemerge11_2e_i->field7));
  llvm_cbe_tmp18_2e_i565_2e_i = *((&llvm_cbe_tmp3_2e_i_2e_i558_2e_i->field2.field0.field0));
  llvm_cbe_tmp21_2e_i568_2e_i = *((&llvm_cbe_tmp3_2e_i_2e_i558_2e_i->field2.field0.field1));
  *llvm_cbe_tmp22_2e_i569_2e_i = llvm_cbe_tmp18_2e_i565_2e_i;
  *llvm_cbe_tmp25_2e_i572_2e_i = llvm_cbe_tmp21_2e_i568_2e_i;
  llvm_cbe_tmp32_2e_i578_2e_i = *((&llvm_cbe_tmp3_2e_i69_2e_i_2e_i->field2.field0.field0));
  llvm_cbe_tmp35_2e_i_2e_i = *((&llvm_cbe_tmp3_2e_i69_2e_i_2e_i->field2.field0.field1));
  *llvm_cbe_tmp36_2e_i_2e_i = llvm_cbe_tmp32_2e_i578_2e_i;
  *llvm_cbe_tmp39_2e_i_2e_i = llvm_cbe_tmp35_2e_i_2e_i;
  llvm_cbe_tmp43_2e_i_2e_i = (&llvm_cbe_storemerge11_2e_i->field0);
  llvm_cbe_tmp44_2e_i_2e_i = *llvm_cbe_tmp43_2e_i_2e_i;
  llvm_cbe_tmp46_2e_i_2e_i = *llvm_cbe_tmp44_2e_i_2e_i;
  llvm_cbe_tmp49_2e_i_2e_i = (((unsigned long long  (*) (struct l_struct_2E_b2Joint *))llvm_cbe_tmp46_2e_i_2e_i))(llvm_cbe_storemerge11_2e_i);
  *llvm_cbe_tmp51_2e_i_2e_i = ((llvm_cbe_tmp53_2e_i_2e_i1192__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp49_2e_i_2e_i)), llvm_cbe_tmp53_2e_i_2e_i1192__BITCAST_TEMPORARY.Float));
  *llvm_cbe_tmp54_2e_i_2e_i = ((llvm_cbe_tmp56_2e_i_2e_i1196__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp49_2e_i_2e_i) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp56_2e_i_2e_i1196__BITCAST_TEMPORARY.Float));
  llvm_cbe_tmp59_2e_i_2e_i = *llvm_cbe_tmp43_2e_i_2e_i;
  llvm_cbe_tmp61_2e_i_2e_i = *((&llvm_cbe_tmp59_2e_i_2e_i[((signed long long )1ull)]));
  llvm_cbe_tmp64_2e_i_2e_i = (((unsigned long long  (*) (struct l_struct_2E_b2Joint *))llvm_cbe_tmp61_2e_i_2e_i))(llvm_cbe_storemerge11_2e_i);
  *llvm_cbe_tmp66_2e_i_2e_i = ((llvm_cbe_tmp68_2e_i_2e_i1199__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp64_2e_i_2e_i)), llvm_cbe_tmp68_2e_i_2e_i1199__BITCAST_TEMPORARY.Float));
  *llvm_cbe_tmp69_2e_i_2e_i = ((llvm_cbe_tmp71_2e_i_2e_i1203__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp64_2e_i_2e_i) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp71_2e_i_2e_i1203__BITCAST_TEMPORARY.Float));
  *llvm_cbe_tmp1_2e_i_2e_i581_2e_i = 0x1p-1;
  *llvm_cbe_tmp4_2e_i_2e_i582_2e_i = 0x1.99999ap-1;
  *llvm_cbe_tmp7_2e_i_2e_i_2e_i = 0x1.99999ap-1;
  llvm_cbe_tmp3_2e_i80_2e_i_2e_i = *llvm_cbe_tmp2_2e_i586_2e_i;
  switch (llvm_cbe_tmp3_2e_i80_2e_i_2e_i) {
  default:
    goto llvm_cbe_bb153_2e_i_2e_i;
;
  case 3u:
    goto llvm_cbe_bb_2e_i_2e_i;
    break;
  case 4u:
    goto llvm_cbe_bb89_2e_i_2e_i;
  case 5u:
    llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_2;   /* for PHI node */
    llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
    goto llvm_cbe_bb135_2e_i;
  }
llvm_cbe_bb_2e_i_2e_i:
  llvm_cbe_tmp80_2e_i_2e_i = *llvm_cbe_tmp43_2e_i;
  llvm_cbe_tmp82_2e_i_2e_i = *((&llvm_cbe_tmp80_2e_i_2e_i->field0));
  llvm_cbe_tmp84_2e_i_2e_i = *((&llvm_cbe_tmp82_2e_i_2e_i[((signed long long )6ull)]));
  (((void  (*) (struct l_struct_2E_b2DebugDraw *, struct l_struct_2E_b2Vec2 *, struct l_struct_2E_b2Vec2 *, struct l_struct_2E_b2Color *))llvm_cbe_tmp84_2e_i_2e_i))(llvm_cbe_tmp80_2e_i_2e_i, (&llvm_cbe_p1_2e_i_2e_i), (&llvm_cbe_p2_2e_i_2e_i), (&llvm_cbe_color_2e_i_2e_i));
  llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  goto llvm_cbe_bb135_2e_i;

llvm_cbe_bb89_2e_i_2e_i:
  llvm_cbe_tmp9091_2e_i_2e_i = ((struct l_struct_2E_b2PulleyJoint *)llvm_cbe_storemerge11_2e_i);
  llvm_cbe_tmp5_2e_i88_2e_i_2e_i = (&llvm_cbe_tmp9091_2e_i_2e_i->field1);
  llvm_cbe_tmp6_2e_i89_2e_i_2e_i = *llvm_cbe_tmp5_2e_i88_2e_i_2e_i;
  llvm_cbe_tmp3_2e_i_2e_i_2e_i_2e_i = *((&llvm_cbe_tmp6_2e_i89_2e_i_2e_i->field2.field0.field1));
  llvm_cbe_tmp6_2e_i_2e_i_2e_i_2e_i = *((&llvm_cbe_tmp9091_2e_i_2e_i->field2.field1));
  llvm_cbe_tmp10_2e_i_2e_i_2e_i_2e_i = *((&llvm_cbe_tmp6_2e_i89_2e_i_2e_i->field2.field0.field0));
  llvm_cbe_tmp13_2e_i_2e_i_2e_i_2e_i = *((&llvm_cbe_tmp9091_2e_i_2e_i->field2.field0));
  llvm_cbe_tmp26_2e_i_2e_i_2e_i_2e_i125012511252_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i_2e_i_2e_i_2e_i1243__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp10_2e_i_2e_i_2e_i_2e_i + llvm_cbe_tmp13_2e_i_2e_i_2e_i_2e_i))), llvm_cbe_tmp23_2e_i_2e_i_2e_i_2e_i1243__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i_2e_i_2e_i_2e_i1250__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp3_2e_i_2e_i_2e_i_2e_i + llvm_cbe_tmp6_2e_i_2e_i_2e_i_2e_i))), llvm_cbe_tmp26_2e_i_2e_i_2e_i_2e_i1250__BITCAST_TEMPORARY.Int32)))) << 32ull);
  *llvm_cbe_tmp95_2e_i_2e_i = ((llvm_cbe_tmp97_2e_i_2e_i1206__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i_2e_i_2e_i_2e_i125012511252_2e_ins)), llvm_cbe_tmp97_2e_i_2e_i1206__BITCAST_TEMPORARY.Float));
  *llvm_cbe_tmp98_2e_i_2e_i = ((llvm_cbe_tmp100_2e_i_2e_i1210__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i_2e_i_2e_i_2e_i125012511252_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp100_2e_i_2e_i1210__BITCAST_TEMPORARY.Float));
  llvm_cbe_tmp6_2e_i111_2e_i_2e_i = *llvm_cbe_tmp5_2e_i88_2e_i_2e_i;
  llvm_cbe_tmp3_2e_i_2e_i118_2e_i_2e_i = *((&llvm_cbe_tmp6_2e_i111_2e_i_2e_i->field2.field0.field1));
  llvm_cbe_tmp6_2e_i_2e_i121_2e_i_2e_i = *((&llvm_cbe_tmp9091_2e_i_2e_i->field3.field1));
  llvm_cbe_tmp10_2e_i_2e_i125_2e_i_2e_i = *((&llvm_cbe_tmp6_2e_i111_2e_i_2e_i->field2.field0.field0));
  llvm_cbe_tmp13_2e_i_2e_i128_2e_i_2e_i = *((&llvm_cbe_tmp9091_2e_i_2e_i->field3.field0));
  llvm_cbe_tmp26_2e_i_2e_i147_2e_i_2e_i128512861287_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i_2e_i144_2e_i_2e_i1278__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp10_2e_i_2e_i125_2e_i_2e_i + llvm_cbe_tmp13_2e_i_2e_i128_2e_i_2e_i))), llvm_cbe_tmp23_2e_i_2e_i144_2e_i_2e_i1278__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i_2e_i147_2e_i_2e_i1285__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp3_2e_i_2e_i118_2e_i_2e_i + llvm_cbe_tmp6_2e_i_2e_i121_2e_i_2e_i))), llvm_cbe_tmp26_2e_i_2e_i147_2e_i_2e_i1285__BITCAST_TEMPORARY.Int32)))) << 32ull);
  *llvm_cbe_tmp104_2e_i_2e_i = ((llvm_cbe_tmp106_2e_i_2e_i1213__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i_2e_i147_2e_i_2e_i128512861287_2e_ins)), llvm_cbe_tmp106_2e_i_2e_i1213__BITCAST_TEMPORARY.Float));
  *llvm_cbe_tmp107_2e_i_2e_i = ((llvm_cbe_tmp109_2e_i_2e_i1217__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i_2e_i147_2e_i_2e_i128512861287_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp109_2e_i_2e_i1217__BITCAST_TEMPORARY.Float));
  llvm_cbe_tmp115_2e_i_2e_i = *llvm_cbe_tmp43_2e_i;
  llvm_cbe_tmp117_2e_i_2e_i = *((&llvm_cbe_tmp115_2e_i_2e_i->field0));
  llvm_cbe_tmp119_2e_i_2e_i = *((&llvm_cbe_tmp117_2e_i_2e_i[((signed long long )6ull)]));
  (((void  (*) (struct l_struct_2E_b2DebugDraw *, struct l_struct_2E_b2Vec2 *, struct l_struct_2E_b2Vec2 *, struct l_struct_2E_b2Color *))llvm_cbe_tmp119_2e_i_2e_i))(llvm_cbe_tmp115_2e_i_2e_i, (&llvm_cbe_s1_2e_i_2e_i), (&llvm_cbe_p1_2e_i_2e_i), (&llvm_cbe_color_2e_i_2e_i));
  llvm_cbe_tmp129_2e_i_2e_i = *llvm_cbe_tmp43_2e_i;
  llvm_cbe_tmp131_2e_i_2e_i = *((&llvm_cbe_tmp129_2e_i_2e_i->field0));
  llvm_cbe_tmp133_2e_i_2e_i = *((&llvm_cbe_tmp131_2e_i_2e_i[((signed long long )6ull)]));
  (((void  (*) (struct l_struct_2E_b2DebugDraw *, struct l_struct_2E_b2Vec2 *, struct l_struct_2E_b2Vec2 *, struct l_struct_2E_b2Color *))llvm_cbe_tmp133_2e_i_2e_i))(llvm_cbe_tmp129_2e_i_2e_i, (&llvm_cbe_s2_2e_i_2e_i), (&llvm_cbe_p2_2e_i_2e_i), (&llvm_cbe_color_2e_i_2e_i));
  llvm_cbe_tmp143_2e_i_2e_i = *llvm_cbe_tmp43_2e_i;
  llvm_cbe_tmp145_2e_i_2e_i = *((&llvm_cbe_tmp143_2e_i_2e_i->field0));
  llvm_cbe_tmp147_2e_i_2e_i = *((&llvm_cbe_tmp145_2e_i_2e_i[((signed long long )6ull)]));
  (((void  (*) (struct l_struct_2E_b2DebugDraw *, struct l_struct_2E_b2Vec2 *, struct l_struct_2E_b2Vec2 *, struct l_struct_2E_b2Color *))llvm_cbe_tmp147_2e_i_2e_i))(llvm_cbe_tmp143_2e_i_2e_i, (&llvm_cbe_s1_2e_i_2e_i), (&llvm_cbe_s2_2e_i_2e_i), (&llvm_cbe_color_2e_i_2e_i));
  llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i_2e_i147_2e_i_2e_i128512861287_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i_2e_i147_2e_i_2e_i128512861287_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i_2e_i_2e_i_2e_i125012511252_2e_ins;   /* for PHI node */
  llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i_2e_i_2e_i_2e_i125012511252_2e_ins;   /* for PHI node */
  goto llvm_cbe_bb135_2e_i;

llvm_cbe_bb153_2e_i_2e_i:
  llvm_cbe_tmp159_2e_i_2e_i = *llvm_cbe_tmp43_2e_i;
  llvm_cbe_tmp161_2e_i_2e_i = *((&llvm_cbe_tmp159_2e_i_2e_i->field0));
  llvm_cbe_tmp163_2e_i_2e_i = *((&llvm_cbe_tmp161_2e_i_2e_i[((signed long long )6ull)]));
  (((void  (*) (struct l_struct_2E_b2DebugDraw *, struct l_struct_2E_b2Vec2 *, struct l_struct_2E_b2Vec2 *, struct l_struct_2E_b2Color *))llvm_cbe_tmp163_2e_i_2e_i))(llvm_cbe_tmp159_2e_i_2e_i, (&llvm_cbe_x1_2e_i_2e_i), (&llvm_cbe_p1_2e_i_2e_i), (&llvm_cbe_color_2e_i_2e_i));
  llvm_cbe_tmp173_2e_i_2e_i = *llvm_cbe_tmp43_2e_i;
  llvm_cbe_tmp175_2e_i_2e_i = *((&llvm_cbe_tmp173_2e_i_2e_i->field0));
  llvm_cbe_tmp177_2e_i_2e_i = *((&llvm_cbe_tmp175_2e_i_2e_i[((signed long long )6ull)]));
  (((void  (*) (struct l_struct_2E_b2DebugDraw *, struct l_struct_2E_b2Vec2 *, struct l_struct_2E_b2Vec2 *, struct l_struct_2E_b2Color *))llvm_cbe_tmp177_2e_i_2e_i))(llvm_cbe_tmp173_2e_i_2e_i, (&llvm_cbe_p1_2e_i_2e_i), (&llvm_cbe_p2_2e_i_2e_i), (&llvm_cbe_color_2e_i_2e_i));
  llvm_cbe_tmp187_2e_i_2e_i = *llvm_cbe_tmp43_2e_i;
  llvm_cbe_tmp189_2e_i_2e_i = *((&llvm_cbe_tmp187_2e_i_2e_i->field0));
  llvm_cbe_tmp191_2e_i_2e_i = *((&llvm_cbe_tmp189_2e_i_2e_i[((signed long long )6ull)]));
  (((void  (*) (struct l_struct_2E_b2DebugDraw *, struct l_struct_2E_b2Vec2 *, struct l_struct_2E_b2Vec2 *, struct l_struct_2E_b2Color *))llvm_cbe_tmp191_2e_i_2e_i))(llvm_cbe_tmp187_2e_i_2e_i, (&llvm_cbe_x2_2e_i_2e_i), (&llvm_cbe_p2_2e_i_2e_i), (&llvm_cbe_color_2e_i_2e_i));
  llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i102_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i32_2e_i96_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i83_2e_i_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i32_2e_i_2e_i_2e_i_2e_2;   /* for PHI node */
  goto llvm_cbe_bb135_2e_i;

  } while (1); /* end of syntactic loop 'bb138.i' */
llvm_cbe_bb143_2e_i:
  if (((llvm_cbe_tmp3_2e_i_2e_i12 & 32u) == 0u)) {
    goto llvm_cbe_bb464_2e_i;
  } else {
    goto llvm_cbe_bb149_2e_i;
  }

llvm_cbe_bb149_2e_i:
  llvm_cbe_tmp152_2e_i = *((&llvm_cbe_this->field3));
  llvm_cbe_tmp156_2e_i = *((&llvm_cbe_tmp152_2e_i->field7.field1));
  llvm_cbe_tmp157_2e_i = ((float )(0x1p+0 / llvm_cbe_tmp156_2e_i));
  llvm_cbe_tmp161_2e_i = *((&llvm_cbe_tmp152_2e_i->field7.field0));
  llvm_cbe_tmp162_2e_i = ((float )(0x1p+0 / llvm_cbe_tmp161_2e_i));
  *((&llvm_cbe_color10_2e_i.field0)) = 0x1.ccccccp-1;
  *((&llvm_cbe_color10_2e_i.field1)) = 0x1.ccccccp-1;
  *((&llvm_cbe_color10_2e_i.field2)) = 0x1.333334p-2;
  llvm_cbe_tmp201_2e_i = (&llvm_cbe_tmp152_2e_i->field6.field0.field0);
  llvm_cbe_tmp226_2e_i = (&llvm_cbe_tmp152_2e_i->field6.field0.field1);
  llvm_cbe_tmp410_2e_i = (&llvm_cbe_x1_2e_i.field0);
  llvm_cbe_tmp413_2e_i = (&llvm_cbe_x1_2e_i.field1);
  llvm_cbe_tmp428_2e_i = (&llvm_cbe_x2_2e_i.field0);
  llvm_cbe_tmp431_2e_i = (&llvm_cbe_x2_2e_i.field1);
  llvm_cbe_i9_2e_i_2e_0__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb163_2e_i;

  do {     /* Syntactic loop 'bb163.i' to make GCC happy */
llvm_cbe_bb163_2e_i:
  llvm_cbe_i9_2e_i_2e_0 = llvm_cbe_i9_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp169_2e_i = (&llvm_cbe_tmp152_2e_i->field0.field7[((signed long long )(((signed long long )(signed int )llvm_cbe_i9_2e_i_2e_0)))]);
  llvm_cbe_storemerge12_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp169_2e_i;   /* for PHI node */
  goto llvm_cbe_bb451_2e_i;

llvm_cbe_bb456_2e_i:
  llvm_cbe_tmp458_2e_i = llvm_cbe_i9_2e_i_2e_0 + 1u;
  if ((((signed int )llvm_cbe_tmp458_2e_i) < ((signed int )16384u))) {
    llvm_cbe_i9_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp458_2e_i;   /* for PHI node */
    goto llvm_cbe_bb163_2e_i;
  } else {
    goto llvm_cbe_bb464_2e_i;
  }

  do {     /* Syntactic loop 'bb451.i' to make GCC happy */
llvm_cbe_bb451_2e_i:
  llvm_cbe_storemerge12_2e_in_2e_i = llvm_cbe_storemerge12_2e_in_2e_i__PHI_TEMPORARY;
  llvm_cbe_storemerge12_2e_i = *llvm_cbe_storemerge12_2e_in_2e_i;
  if ((llvm_cbe_storemerge12_2e_i == ((unsigned short )-1))) {
    goto llvm_cbe_bb456_2e_i;
  } else {
    goto llvm_cbe_bb171_2e_i;
  }

llvm_cbe_bb171_2e_i:
  llvm_cbe_tmp176177178_2e_i = ((unsigned long long )(unsigned short )llvm_cbe_storemerge12_2e_i);
  llvm_cbe_tmp185_2e_i = *((&llvm_cbe_tmp152_2e_i->field0.field2[((signed long long )llvm_cbe_tmp176177178_2e_i)].field1));
  llvm_cbe_tmp185186187_2e_i = ((unsigned long long )(unsigned short )llvm_cbe_tmp185_2e_i);
  llvm_cbe_tmp194_2e_i = *((&llvm_cbe_tmp152_2e_i->field0.field2[((signed long long )llvm_cbe_tmp176177178_2e_i)].field2));
  llvm_cbe_tmp194195196_2e_i = ((unsigned long long )(unsigned short )llvm_cbe_tmp194_2e_i);
  llvm_cbe_tmp202_2e_i = *llvm_cbe_tmp201_2e_i;
  llvm_cbe_tmp208_2e_i = *((&llvm_cbe_tmp152_2e_i->field1[((signed long long )llvm_cbe_tmp185186187_2e_i)].field0[((signed long long )0ull)]));
  llvm_cbe_tmp216_2e_i = *((&llvm_cbe_tmp152_2e_i->field3[((signed int )0u)][((signed long long )(((unsigned long long )(unsigned short )llvm_cbe_tmp208_2e_i)))].field0));
  llvm_cbe_tmp227_2e_i = *llvm_cbe_tmp226_2e_i;
  llvm_cbe_tmp233_2e_i = *((&llvm_cbe_tmp152_2e_i->field1[((signed long long )llvm_cbe_tmp185186187_2e_i)].field0[((signed long long )1ull)]));
  llvm_cbe_tmp241_2e_i = *((&llvm_cbe_tmp152_2e_i->field3[((signed long long )1ull)][((signed long long )(((unsigned long long )(unsigned short )llvm_cbe_tmp233_2e_i)))].field0));
  llvm_cbe_tmp258_2e_i = *((&llvm_cbe_tmp152_2e_i->field1[((signed long long )llvm_cbe_tmp185186187_2e_i)].field1[((signed long long )0ull)]));
  llvm_cbe_tmp266_2e_i = *((&llvm_cbe_tmp152_2e_i->field3[((signed int )0u)][((signed long long )(((unsigned long long )(unsigned short )llvm_cbe_tmp258_2e_i)))].field0));
  llvm_cbe_tmp283_2e_i = *((&llvm_cbe_tmp152_2e_i->field1[((signed long long )llvm_cbe_tmp185186187_2e_i)].field1[((signed long long )1ull)]));
  llvm_cbe_tmp291_2e_i = *((&llvm_cbe_tmp152_2e_i->field3[((signed long long )1ull)][((signed long long )(((unsigned long long )(unsigned short )llvm_cbe_tmp283_2e_i)))].field0));
  llvm_cbe_tmp308_2e_i = *((&llvm_cbe_tmp152_2e_i->field1[((signed long long )llvm_cbe_tmp194195196_2e_i)].field0[((signed long long )0ull)]));
  llvm_cbe_tmp316_2e_i = *((&llvm_cbe_tmp152_2e_i->field3[((signed int )0u)][((signed long long )(((unsigned long long )(unsigned short )llvm_cbe_tmp308_2e_i)))].field0));
  llvm_cbe_tmp333_2e_i = *((&llvm_cbe_tmp152_2e_i->field1[((signed long long )llvm_cbe_tmp194195196_2e_i)].field0[((signed long long )1ull)]));
  llvm_cbe_tmp341_2e_i = *((&llvm_cbe_tmp152_2e_i->field3[((signed long long )1ull)][((signed long long )(((unsigned long long )(unsigned short )llvm_cbe_tmp333_2e_i)))].field0));
  llvm_cbe_tmp358_2e_i = *((&llvm_cbe_tmp152_2e_i->field1[((signed long long )llvm_cbe_tmp194195196_2e_i)].field1[((signed long long )0ull)]));
  llvm_cbe_tmp366_2e_i = *((&llvm_cbe_tmp152_2e_i->field3[((signed int )0u)][((signed long long )(((unsigned long long )(unsigned short )llvm_cbe_tmp358_2e_i)))].field0));
  llvm_cbe_tmp383_2e_i = *((&llvm_cbe_tmp152_2e_i->field1[((signed long long )llvm_cbe_tmp194195196_2e_i)].field1[((signed long long )1ull)]));
  llvm_cbe_tmp391_2e_i = *((&llvm_cbe_tmp152_2e_i->field3[((signed long long )1ull)][((signed long long )(((unsigned long long )(unsigned short )llvm_cbe_tmp383_2e_i)))].field0));
  llvm_cbe_tmp26_2e_i507_2e_i118711881189_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i504_2e_i1180__BITCAST_TEMPORARY.Float = (((float )((((float )(llvm_cbe_tmp202_2e_i + (((float )(llvm_cbe_tmp162_2e_i * (((float )(signed int )(((unsigned int )(unsigned short )llvm_cbe_tmp216_2e_i)))))))))) + (((float )(llvm_cbe_tmp202_2e_i + (((float )(llvm_cbe_tmp162_2e_i * (((float )(signed int )(((unsigned int )(unsigned short )llvm_cbe_tmp266_2e_i))))))))))))), llvm_cbe_tmp23_2e_i504_2e_i1180__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i507_2e_i1187__BITCAST_TEMPORARY.Float = (((float )((((float )(llvm_cbe_tmp227_2e_i + (((float )(llvm_cbe_tmp157_2e_i * (((float )(signed int )(((unsigned int )(unsigned short )llvm_cbe_tmp241_2e_i)))))))))) + (((float )(llvm_cbe_tmp227_2e_i + (((float )(llvm_cbe_tmp157_2e_i * (((float )(signed int )(((unsigned int )(unsigned short )llvm_cbe_tmp291_2e_i))))))))))))), llvm_cbe_tmp26_2e_i507_2e_i1187__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp22_2e_i458_2e_i117311741175_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp19_2e_i455_2e_i1166__BITCAST_TEMPORARY.Float = (((float )(((llvm_cbe_tmp404_2e_i1073__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i507_2e_i118711881189_2e_ins)), llvm_cbe_tmp404_2e_i1073__BITCAST_TEMPORARY.Float)) * 0x1p-1))), llvm_cbe_tmp19_2e_i455_2e_i1166__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp22_2e_i458_2e_i1173__BITCAST_TEMPORARY.Float = (((float )(((llvm_cbe_tmp407_2e_i1077__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i507_2e_i118711881189_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp407_2e_i1077__BITCAST_TEMPORARY.Float)) * 0x1p-1))), llvm_cbe_tmp22_2e_i458_2e_i1173__BITCAST_TEMPORARY.Int32)))) << 32ull);
  *llvm_cbe_tmp410_2e_i = ((llvm_cbe_tmp412_2e_i1080__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp22_2e_i458_2e_i117311741175_2e_ins)), llvm_cbe_tmp412_2e_i1080__BITCAST_TEMPORARY.Float));
  *llvm_cbe_tmp413_2e_i = ((llvm_cbe_tmp415_2e_i1084__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp22_2e_i458_2e_i117311741175_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp415_2e_i1084__BITCAST_TEMPORARY.Float));
  llvm_cbe_tmp26_2e_i413_2e_i115911601161_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i410_2e_i1152__BITCAST_TEMPORARY.Float = (((float )((((float )(llvm_cbe_tmp202_2e_i + (((float )(llvm_cbe_tmp162_2e_i * (((float )(signed int )(((unsigned int )(unsigned short )llvm_cbe_tmp316_2e_i)))))))))) + (((float )(llvm_cbe_tmp202_2e_i + (((float )(llvm_cbe_tmp162_2e_i * (((float )(signed int )(((unsigned int )(unsigned short )llvm_cbe_tmp366_2e_i))))))))))))), llvm_cbe_tmp23_2e_i410_2e_i1152__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i413_2e_i1159__BITCAST_TEMPORARY.Float = (((float )((((float )(llvm_cbe_tmp227_2e_i + (((float )(llvm_cbe_tmp157_2e_i * (((float )(signed int )(((unsigned int )(unsigned short )llvm_cbe_tmp341_2e_i)))))))))) + (((float )(llvm_cbe_tmp227_2e_i + (((float )(llvm_cbe_tmp157_2e_i * (((float )(signed int )(((unsigned int )(unsigned short )llvm_cbe_tmp391_2e_i))))))))))))), llvm_cbe_tmp26_2e_i413_2e_i1159__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp22_2e_i365_2e_i114511461147_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp19_2e_i362_2e_i1138__BITCAST_TEMPORARY.Float = (((float )(((llvm_cbe_tmp422_2e_i1087__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i413_2e_i115911601161_2e_ins)), llvm_cbe_tmp422_2e_i1087__BITCAST_TEMPORARY.Float)) * 0x1p-1))), llvm_cbe_tmp19_2e_i362_2e_i1138__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp22_2e_i365_2e_i1145__BITCAST_TEMPORARY.Float = (((float )(((llvm_cbe_tmp425_2e_i1091__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i413_2e_i115911601161_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp425_2e_i1091__BITCAST_TEMPORARY.Float)) * 0x1p-1))), llvm_cbe_tmp22_2e_i365_2e_i1145__BITCAST_TEMPORARY.Int32)))) << 32ull);
  *llvm_cbe_tmp428_2e_i = ((llvm_cbe_tmp430_2e_i1094__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp22_2e_i365_2e_i114511461147_2e_ins)), llvm_cbe_tmp430_2e_i1094__BITCAST_TEMPORARY.Float));
  *llvm_cbe_tmp431_2e_i = ((llvm_cbe_tmp433_2e_i1098__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp22_2e_i365_2e_i114511461147_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp433_2e_i1098__BITCAST_TEMPORARY.Float));
  llvm_cbe_tmp439_2e_i = *llvm_cbe_tmp43_2e_i;
  llvm_cbe_tmp441_2e_i = *((&llvm_cbe_tmp439_2e_i->field0));
  llvm_cbe_tmp443_2e_i = *((&llvm_cbe_tmp441_2e_i[((signed long long )6ull)]));
  (((void  (*) (struct l_struct_2E_b2DebugDraw *, struct l_struct_2E_b2Vec2 *, struct l_struct_2E_b2Vec2 *, struct l_struct_2E_b2Color *))llvm_cbe_tmp443_2e_i))(llvm_cbe_tmp439_2e_i, (&llvm_cbe_x1_2e_i), (&llvm_cbe_x2_2e_i), (&llvm_cbe_color10_2e_i));
  llvm_cbe_tmp449_2e_i = (&llvm_cbe_tmp152_2e_i->field0.field2[((signed long long )llvm_cbe_tmp176177178_2e_i)].field3);
  llvm_cbe_storemerge12_2e_in_2e_i__PHI_TEMPORARY = llvm_cbe_tmp449_2e_i;   /* for PHI node */
  goto llvm_cbe_bb451_2e_i;

  } while (1); /* end of syntactic loop 'bb451.i' */
  } while (1); /* end of syntactic loop 'bb163.i' */
llvm_cbe_bb464_2e_i:
  if (((llvm_cbe_tmp3_2e_i_2e_i12 & 8u) == 0u)) {
    goto llvm_cbe_bb733_2e_i;
  } else {
    goto llvm_cbe_bb470_2e_i;
  }

llvm_cbe_bb470_2e_i:
  llvm_cbe_tmp473_2e_i = *((&llvm_cbe_this->field3));
  llvm_cbe_tmp479_2e_i = *((&llvm_cbe_tmp473_2e_i->field6.field0.field0));
  llvm_cbe_tmp482_2e_i = *((&llvm_cbe_tmp473_2e_i->field6.field0.field1));
  llvm_cbe_tmp494_2e_i = *((&llvm_cbe_tmp473_2e_i->field6.field1.field0));
  llvm_cbe_tmp497_2e_i = *((&llvm_cbe_tmp473_2e_i->field6.field1.field1));
  llvm_cbe_tmp507_2e_i = *((&llvm_cbe_tmp473_2e_i->field7.field1));
  llvm_cbe_tmp508_2e_i = ((float )(0x1p+0 / llvm_cbe_tmp507_2e_i));
  llvm_cbe_tmp512_2e_i = *((&llvm_cbe_tmp473_2e_i->field7.field0));
  llvm_cbe_tmp513_2e_i = ((float )(0x1p+0 / llvm_cbe_tmp512_2e_i));
  *((&llvm_cbe_color7_2e_i.field0)) = 0x1.ccccccp-1;
  *((&llvm_cbe_color7_2e_i.field1)) = 0x1.333334p-2;
  *((&llvm_cbe_color7_2e_i.field2)) = 0x1.ccccccp-1;
  llvm_cbe_tmp616_2e_i = (&llvm_cbe_vs3_2e_i[((signed long long )0ull)]);
  llvm_cbe_tmp1_2e_i278_2e_i = (&llvm_cbe_vs3_2e_i[((signed int )0u)].field0);
  llvm_cbe_tmp4_2e_i281_2e_i = (&llvm_cbe_vs3_2e_i[((signed int )0u)].field1);
  llvm_cbe_tmp1_2e_i269_2e_i = (&llvm_cbe_vs3_2e_i[((signed long long )1ull)].field0);
  llvm_cbe_tmp4_2e_i272_2e_i = (&llvm_cbe_vs3_2e_i[((signed long long )1ull)].field1);
  llvm_cbe_tmp1_2e_i260_2e_i = (&llvm_cbe_vs3_2e_i[((signed long long )2ull)].field0);
  llvm_cbe_tmp4_2e_i263_2e_i = (&llvm_cbe_vs3_2e_i[((signed long long )2ull)].field1);
  llvm_cbe_tmp1_2e_i251_2e_i = (&llvm_cbe_vs3_2e_i[((signed long long )3ull)].field0);
  llvm_cbe_tmp4_2e_i254_2e_i = (&llvm_cbe_vs3_2e_i[((signed long long )3ull)].field1);
  llvm_cbe_i5_2e_i_2e_0__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb514_2e_i;

  do {     /* Syntactic loop 'bb514.i' to make GCC happy */
llvm_cbe_bb514_2e_i:
  llvm_cbe_i5_2e_i_2e_0 = llvm_cbe_i5_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp518519_2e_i = ((signed long long )(signed int )llvm_cbe_i5_2e_i_2e_0);
  llvm_cbe_tmp3_2e_i289_2e_i = *((&llvm_cbe_tmp473_2e_i->field1[((signed long long )llvm_cbe_tmp518519_2e_i)].field2));
  if ((llvm_cbe_tmp3_2e_i289_2e_i == ((unsigned short )-1))) {
    goto llvm_cbe_bb674_2e_i;
  } else {
    goto llvm_cbe_bb527_2e_i;
  }

llvm_cbe_bb674_2e_i:
  llvm_cbe_tmp676_2e_i = llvm_cbe_i5_2e_i_2e_0 + 1u;
  if ((((signed int )llvm_cbe_tmp676_2e_i) < ((signed int )2048u))) {
    llvm_cbe_i5_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp676_2e_i;   /* for PHI node */
    goto llvm_cbe_bb514_2e_i;
  } else {
    goto llvm_cbe_bb682_2e_i;
  }

llvm_cbe_bb629_2e_i:
  *llvm_cbe_tmp1_2e_i278_2e_i = llvm_cbe_tmp547_2e_i;
  *llvm_cbe_tmp4_2e_i281_2e_i = llvm_cbe_tmp569_2e_i;
  *llvm_cbe_tmp1_2e_i269_2e_i = llvm_cbe_tmp591_2e_i;
  *llvm_cbe_tmp4_2e_i272_2e_i = llvm_cbe_tmp569_2e_i;
  *llvm_cbe_tmp1_2e_i260_2e_i = llvm_cbe_tmp591_2e_i;
  *llvm_cbe_tmp4_2e_i263_2e_i = llvm_cbe_tmp613_2e_i;
  *llvm_cbe_tmp1_2e_i251_2e_i = llvm_cbe_tmp547_2e_i;
  *llvm_cbe_tmp4_2e_i254_2e_i = llvm_cbe_tmp613_2e_i;
  llvm_cbe_tmp664_2e_i = *llvm_cbe_tmp43_2e_i;
  llvm_cbe_tmp666_2e_i = *((&llvm_cbe_tmp664_2e_i->field0));
  llvm_cbe_tmp668_2e_i = *((&llvm_cbe_tmp666_2e_i[((signed long long )2ull)]));
  (((void  (*) (struct l_struct_2E_b2DebugDraw *, struct l_struct_2E_b2Vec2 *, unsigned int , struct l_struct_2E_b2Color *))llvm_cbe_tmp668_2e_i))(llvm_cbe_tmp664_2e_i, llvm_cbe_tmp616_2e_i, 4u, (&llvm_cbe_color7_2e_i));
  goto llvm_cbe_bb674_2e_i;

  do {     /* Syntactic loop 'bb618.i' to make GCC happy */
llvm_cbe_bb618_2e_i:
  llvm_cbe_tmp28_2e_i4_2e_0 = llvm_cbe_tmp28_2e_i4_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp623_2e_i = llvm_cbe_tmp28_2e_i4_2e_0 + 18446744073709551615ull;
  if ((llvm_cbe_tmp623_2e_i == 18446744073709551615ull)) {
    goto llvm_cbe_bb629_2e_i;
  } else {
    llvm_cbe_tmp28_2e_i4_2e_0__PHI_TEMPORARY = llvm_cbe_tmp623_2e_i;   /* for PHI node */
    goto llvm_cbe_bb618_2e_i;
  }

  } while (1); /* end of syntactic loop 'bb618.i' */
llvm_cbe_bb527_2e_i:
  llvm_cbe_tmp535_2e_i = *((&llvm_cbe_tmp473_2e_i->field1[((signed long long )llvm_cbe_tmp518519_2e_i)].field0[((signed long long )0ull)]));
  llvm_cbe_tmp543_2e_i = *((&llvm_cbe_tmp473_2e_i->field3[((signed int )0u)][((signed long long )(((unsigned long long )(unsigned short )llvm_cbe_tmp535_2e_i)))].field0));
  llvm_cbe_tmp547_2e_i = ((float )(llvm_cbe_tmp479_2e_i + (((float )(llvm_cbe_tmp513_2e_i * (((float )(signed int )(((unsigned int )(unsigned short )llvm_cbe_tmp543_2e_i)))))))));
  llvm_cbe_tmp557_2e_i = *((&llvm_cbe_tmp473_2e_i->field1[((signed long long )llvm_cbe_tmp518519_2e_i)].field0[((signed long long )1ull)]));
  llvm_cbe_tmp565_2e_i = *((&llvm_cbe_tmp473_2e_i->field3[((signed long long )1ull)][((signed long long )(((unsigned long long )(unsigned short )llvm_cbe_tmp557_2e_i)))].field0));
  llvm_cbe_tmp569_2e_i = ((float )(llvm_cbe_tmp482_2e_i + (((float )(llvm_cbe_tmp508_2e_i * (((float )(signed int )(((unsigned int )(unsigned short )llvm_cbe_tmp565_2e_i)))))))));
  llvm_cbe_tmp579_2e_i = *((&llvm_cbe_tmp473_2e_i->field1[((signed long long )llvm_cbe_tmp518519_2e_i)].field1[((signed long long )0ull)]));
  llvm_cbe_tmp587_2e_i = *((&llvm_cbe_tmp473_2e_i->field3[((signed int )0u)][((signed long long )(((unsigned long long )(unsigned short )llvm_cbe_tmp579_2e_i)))].field0));
  llvm_cbe_tmp591_2e_i = ((float )(llvm_cbe_tmp479_2e_i + (((float )(llvm_cbe_tmp513_2e_i * (((float )(signed int )(((unsigned int )(unsigned short )llvm_cbe_tmp587_2e_i)))))))));
  llvm_cbe_tmp601_2e_i = *((&llvm_cbe_tmp473_2e_i->field1[((signed long long )llvm_cbe_tmp518519_2e_i)].field1[((signed long long )1ull)]));
  llvm_cbe_tmp609_2e_i = *((&llvm_cbe_tmp473_2e_i->field3[((signed long long )1ull)][((signed long long )(((unsigned long long )(unsigned short )llvm_cbe_tmp601_2e_i)))].field0));
  llvm_cbe_tmp613_2e_i = ((float )(llvm_cbe_tmp482_2e_i + (((float )(llvm_cbe_tmp508_2e_i * (((float )(signed int )(((unsigned int )(unsigned short )llvm_cbe_tmp609_2e_i)))))))));
  llvm_cbe_tmp28_2e_i4_2e_0__PHI_TEMPORARY = 3ull;   /* for PHI node */
  goto llvm_cbe_bb618_2e_i;

  } while (1); /* end of syntactic loop 'bb514.i' */
llvm_cbe_bb682_2e_i:
  llvm_cbe_tmp683_2e_i = (&llvm_cbe_vs6_2e_i[((signed long long )0ull)]);
  llvm_cbe_tmp25_2e_i_2e_0__PHI_TEMPORARY = 3ull;   /* for PHI node */
  goto llvm_cbe_bb685_2e_i;

  do {     /* Syntactic loop 'bb685.i' to make GCC happy */
llvm_cbe_bb685_2e_i:
  llvm_cbe_tmp25_2e_i_2e_0 = llvm_cbe_tmp25_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp690_2e_i = llvm_cbe_tmp25_2e_i_2e_0 + 18446744073709551615ull;
  if ((llvm_cbe_tmp690_2e_i == 18446744073709551615ull)) {
    goto llvm_cbe_bb696_2e_i;
  } else {
    llvm_cbe_tmp25_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp690_2e_i;   /* for PHI node */
    goto llvm_cbe_bb685_2e_i;
  }

  } while (1); /* end of syntactic loop 'bb685.i' */
llvm_cbe_bb696_2e_i:
  *((&llvm_cbe_vs6_2e_i[((signed int )0u)].field0)) = llvm_cbe_tmp479_2e_i;
  *((&llvm_cbe_vs6_2e_i[((signed int )0u)].field1)) = llvm_cbe_tmp482_2e_i;
  *((&llvm_cbe_vs6_2e_i[((signed long long )1ull)].field0)) = llvm_cbe_tmp494_2e_i;
  *((&llvm_cbe_vs6_2e_i[((signed long long )1ull)].field1)) = llvm_cbe_tmp482_2e_i;
  *((&llvm_cbe_vs6_2e_i[((signed long long )2ull)].field0)) = llvm_cbe_tmp494_2e_i;
  *((&llvm_cbe_vs6_2e_i[((signed long long )2ull)].field1)) = llvm_cbe_tmp497_2e_i;
  *((&llvm_cbe_vs6_2e_i[((signed long long )3ull)].field0)) = llvm_cbe_tmp479_2e_i;
  *((&llvm_cbe_vs6_2e_i[((signed long long )3ull)].field1)) = llvm_cbe_tmp497_2e_i;
  llvm_cbe_tmp723_2e_i = *llvm_cbe_tmp43_2e_i;
  llvm_cbe_tmp725_2e_i = *((&llvm_cbe_tmp723_2e_i->field0));
  llvm_cbe_tmp727_2e_i = *((&llvm_cbe_tmp725_2e_i[((signed long long )2ull)]));
  *((&llvm_cbe_tmp24_2e_i.field0)) = 0x1.333334p-2;
  *((&llvm_cbe_tmp24_2e_i.field1)) = 0x1.ccccccp-1;
  *((&llvm_cbe_tmp24_2e_i.field2)) = 0x1.ccccccp-1;
  (((void  (*) (struct l_struct_2E_b2DebugDraw *, struct l_struct_2E_b2Vec2 *, unsigned int , struct l_struct_2E_b2Color *))llvm_cbe_tmp727_2e_i))(llvm_cbe_tmp723_2e_i, llvm_cbe_tmp683_2e_i, 4u, (&llvm_cbe_tmp24_2e_i));
  goto llvm_cbe_bb733_2e_i;

llvm_cbe_bb733_2e_i:
  if (((llvm_cbe_tmp3_2e_i_2e_i12 & 16u) == 0u)) {
    goto llvm_cbe_bb894_2e_i;
  } else {
    goto llvm_cbe_bb739_2e_i;
  }

llvm_cbe_bb739_2e_i:
  *((&llvm_cbe_color_2e_i.field0)) = 0x1p-1;
  *((&llvm_cbe_color_2e_i.field1)) = 0x1.333334p-2;
  *((&llvm_cbe_color_2e_i.field2)) = 0x1p-1;
  llvm_cbe_tmp741_2e_i = (&llvm_cbe_this->field5);
  llvm_cbe_tmp774_2e_i = (&llvm_cbe_vs_2e_i[((signed long long )0ull)]);
  llvm_cbe_tmp1_2e_i149_2e_i = (&llvm_cbe_vs_2e_i[((signed int )0u)].field0);
  llvm_cbe_tmp4_2e_i152_2e_i = (&llvm_cbe_vs_2e_i[((signed int )0u)].field1);
  llvm_cbe_tmp1_2e_i140_2e_i = (&llvm_cbe_vs_2e_i[((signed long long )1ull)].field0);
  llvm_cbe_tmp4_2e_i143_2e_i = (&llvm_cbe_vs_2e_i[((signed long long )1ull)].field1);
  llvm_cbe_tmp1_2e_i131_2e_i = (&llvm_cbe_vs_2e_i[((signed long long )2ull)].field0);
  llvm_cbe_tmp4_2e_i134_2e_i = (&llvm_cbe_vs_2e_i[((signed long long )2ull)].field1);
  llvm_cbe_tmp1_2e_i122_2e_i = (&llvm_cbe_vs_2e_i[((signed long long )3ull)].field0);
  llvm_cbe_tmp4_2e_i125_2e_i = (&llvm_cbe_vs_2e_i[((signed long long )3ull)].field1);
  llvm_cbe_storemerge74_2e_i_2e_in__PHI_TEMPORARY = llvm_cbe_tmp741_2e_i;   /* for PHI node */
  goto llvm_cbe_bb889_2e_i;

  do {     /* Syntactic loop 'bb889.i' to make GCC happy */
llvm_cbe_bb889_2e_i:
  llvm_cbe_retval_2e_i106_2e_i_2e_3 = llvm_cbe_retval_2e_i106_2e_i_2e_3__PHI_TEMPORARY;
  llvm_cbe_storemerge74_2e_i_2e_in = llvm_cbe_storemerge74_2e_i_2e_in__PHI_TEMPORARY;
  llvm_cbe_storemerge74_2e_i = *llvm_cbe_storemerge74_2e_i_2e_in;
  if ((llvm_cbe_storemerge74_2e_i == ((struct l_struct_2E_b2Body *)/*NULL*/0))) {
    goto llvm_cbe_bb894_2e_i;
  } else {
    goto llvm_cbe_bb743_2e_i;
  }

llvm_cbe_bb886_2e_i:
  llvm_cbe_tmp2_2e_i92_2e_i = (&llvm_cbe_storemerge74_2e_i->field10);
  llvm_cbe_retval_2e_i106_2e_i_2e_3__PHI_TEMPORARY = llvm_cbe_retval_2e_i106_2e_i_2e_2;   /* for PHI node */
  llvm_cbe_storemerge74_2e_i_2e_in__PHI_TEMPORARY = llvm_cbe_tmp2_2e_i92_2e_i;   /* for PHI node */
  goto llvm_cbe_bb889_2e_i;

  do {     /* Syntactic loop 'bb881.i' to make GCC happy */
llvm_cbe_bb881_2e_i:
  llvm_cbe_retval_2e_i106_2e_i_2e_2 = llvm_cbe_retval_2e_i106_2e_i_2e_2__PHI_TEMPORARY;
  llvm_cbe_storemerge73_2e_i_2e_in = llvm_cbe_storemerge73_2e_i_2e_in__PHI_TEMPORARY;
  llvm_cbe_storemerge73_2e_i = *llvm_cbe_storemerge73_2e_i_2e_in;
  if ((llvm_cbe_storemerge73_2e_i == ((struct l_struct_2E_b2Shape *)/*NULL*/0))) {
    goto llvm_cbe_bb886_2e_i;
  } else {
    goto llvm_cbe_bb748_2e_i;
  }

llvm_cbe_bb878_2e_i:
  llvm_cbe_retval_2e_i106_2e_i_2e_1 = llvm_cbe_retval_2e_i106_2e_i_2e_1__PHI_TEMPORARY;
  llvm_cbe_tmp2_2e_i96_2e_i = (&llvm_cbe_storemerge73_2e_i->field2);
  llvm_cbe_retval_2e_i106_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i106_2e_i_2e_1;   /* for PHI node */
  llvm_cbe_storemerge73_2e_i_2e_in__PHI_TEMPORARY = llvm_cbe_tmp2_2e_i96_2e_i;   /* for PHI node */
  goto llvm_cbe_bb881_2e_i;

llvm_cbe_bb748_2e_i:
  llvm_cbe_tmp3_2e_i159_2e_i = *((&llvm_cbe_storemerge73_2e_i->field1));
  if ((llvm_cbe_tmp3_2e_i159_2e_i == 1u)) {
    goto llvm_cbe_bb755_2e_i;
  } else {
    llvm_cbe_retval_2e_i106_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_retval_2e_i106_2e_i_2e_2;   /* for PHI node */
    goto llvm_cbe_bb878_2e_i;
  }

llvm_cbe_bb862_2e_i:
  llvm_cbe_tmp868_2e_i = *llvm_cbe_tmp43_2e_i;
  llvm_cbe_tmp870_2e_i = *((&llvm_cbe_tmp868_2e_i->field0));
  llvm_cbe_tmp872_2e_i = *((&llvm_cbe_tmp870_2e_i[((signed long long )2ull)]));
  (((void  (*) (struct l_struct_2E_b2DebugDraw *, struct l_struct_2E_b2Vec2 *, unsigned int , struct l_struct_2E_b2Color *))llvm_cbe_tmp872_2e_i))(llvm_cbe_tmp868_2e_i, llvm_cbe_tmp774_2e_i, 4u, (&llvm_cbe_color_2e_i));
  llvm_cbe_retval_2e_i106_2e_i_2e_1__PHI_TEMPORARY = llvm_cbe_tmp26_2e_i_2e_i113111321133_2e_ins;   /* for PHI node */
  goto llvm_cbe_bb878_2e_i;

  do {     /* Syntactic loop 'bb813.i' to make GCC happy */
llvm_cbe_bb813_2e_i:
  llvm_cbe_i_2e_i_2e_0 = llvm_cbe_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp815816_2e_i = ((signed long long )(signed int )llvm_cbe_i_2e_i_2e_0);
  llvm_cbe_tmp817_2e_i = (&llvm_cbe_vs_2e_i[((signed long long )llvm_cbe_tmp815816_2e_i)]);
  llvm_cbe_tmp820_2e_i = _Z5b2MulRK7b2Mat22RK6b2Vec2(llvm_cbe_tmp819_2e_i, llvm_cbe_tmp817_2e_i);
  llvm_cbe_tmp3_2e_i108_2e_i = *llvm_cbe_tmp2_2e_i107_2e_i;
  llvm_cbe_tmp10_2e_i_2e_i = *llvm_cbe_tmp9_2e_i_2e_i;
  llvm_cbe_tmp26_2e_i_2e_i113111321133_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i_2e_i1124__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp10_2e_i_2e_i + ((llvm_cbe_tmp824_2e_i1101__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp820_2e_i)), llvm_cbe_tmp824_2e_i1101__BITCAST_TEMPORARY.Float))))), llvm_cbe_tmp23_2e_i_2e_i1124__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i_2e_i1131__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp3_2e_i108_2e_i + ((llvm_cbe_tmp827_2e_i1105__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp820_2e_i) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp827_2e_i1105__BITCAST_TEMPORARY.Float))))), llvm_cbe_tmp26_2e_i_2e_i1131__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp834_2e_i = (&llvm_cbe_vs_2e_i[((signed long long )llvm_cbe_tmp815816_2e_i)].field0);
  *llvm_cbe_tmp834_2e_i = ((llvm_cbe_tmp836_2e_i1108__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i_2e_i113111321133_2e_ins)), llvm_cbe_tmp836_2e_i1108__BITCAST_TEMPORARY.Float));
  llvm_cbe_tmp837_2e_i = (&llvm_cbe_vs_2e_i[((signed long long )llvm_cbe_tmp815816_2e_i)].field1);
  *llvm_cbe_tmp837_2e_i = ((llvm_cbe_tmp839_2e_i1112__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i_2e_i113111321133_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp839_2e_i1112__BITCAST_TEMPORARY.Float));
  llvm_cbe_tmp845_2e_i = _Z5b2MulRK7b2XFormRK6b2Vec2(llvm_cbe_tmp2_2e_i166_2e_i, llvm_cbe_tmp817_2e_i);
  *llvm_cbe_tmp834_2e_i = ((llvm_cbe_tmp851_2e_i1115__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp845_2e_i)), llvm_cbe_tmp851_2e_i1115__BITCAST_TEMPORARY.Float));
  *llvm_cbe_tmp837_2e_i = ((llvm_cbe_tmp854_2e_i1119__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp845_2e_i) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp854_2e_i1119__BITCAST_TEMPORARY.Float));
  llvm_cbe_tmp856_2e_i = llvm_cbe_i_2e_i_2e_0 + 1u;
  if ((((signed int )llvm_cbe_tmp856_2e_i) < ((signed int )4u))) {
    llvm_cbe_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp856_2e_i;   /* for PHI node */
    goto llvm_cbe_bb813_2e_i;
  } else {
    goto llvm_cbe_bb862_2e_i;
  }

  } while (1); /* end of syntactic loop 'bb813.i' */
llvm_cbe_bb787_2e_i:
  llvm_cbe_tmp791_2e_i = ((float )(-(llvm_cbe_tmp767_2e_i)));
  llvm_cbe_tmp794_2e_i = ((float )(-(llvm_cbe_tmp764_2e_i)));
  *llvm_cbe_tmp1_2e_i149_2e_i = llvm_cbe_tmp794_2e_i;
  *llvm_cbe_tmp4_2e_i152_2e_i = llvm_cbe_tmp791_2e_i;
  *llvm_cbe_tmp1_2e_i140_2e_i = llvm_cbe_tmp764_2e_i;
  *llvm_cbe_tmp4_2e_i143_2e_i = llvm_cbe_tmp791_2e_i;
  *llvm_cbe_tmp1_2e_i131_2e_i = llvm_cbe_tmp764_2e_i;
  *llvm_cbe_tmp4_2e_i134_2e_i = llvm_cbe_tmp767_2e_i;
  *llvm_cbe_tmp1_2e_i122_2e_i = llvm_cbe_tmp794_2e_i;
  *llvm_cbe_tmp4_2e_i125_2e_i = llvm_cbe_tmp767_2e_i;
  llvm_cbe_tmp819_2e_i = (&llvm_cbe_tmp756757_2e_i->field2.field0);
  llvm_cbe_tmp2_2e_i107_2e_i = (&llvm_cbe_tmp756757_2e_i->field2.field1.field1);
  llvm_cbe_tmp9_2e_i_2e_i = (&llvm_cbe_tmp756757_2e_i->field2.field1.field0);
  llvm_cbe_i_2e_i_2e_0__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb813_2e_i;

  do {     /* Syntactic loop 'bb776.i' to make GCC happy */
llvm_cbe_bb776_2e_i:
  llvm_cbe_tmp20_2e_i_2e_0 = llvm_cbe_tmp20_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp781_2e_i = llvm_cbe_tmp20_2e_i_2e_0 + 18446744073709551615ull;
  if ((llvm_cbe_tmp781_2e_i == 18446744073709551615ull)) {
    goto llvm_cbe_bb787_2e_i;
  } else {
    llvm_cbe_tmp20_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp781_2e_i;   /* for PHI node */
    goto llvm_cbe_bb776_2e_i;
  }

  } while (1); /* end of syntactic loop 'bb776.i' */
llvm_cbe_bb755_2e_i:
  llvm_cbe_tmp756757_2e_i = ((struct l_struct_2E_b2PolygonShape *)llvm_cbe_storemerge73_2e_i);
  llvm_cbe_tmp764_2e_i = *((&llvm_cbe_tmp756757_2e_i->field2.field2.field0));
  llvm_cbe_tmp767_2e_i = *((&llvm_cbe_tmp756757_2e_i->field2.field2.field1));
  llvm_cbe_tmp20_2e_i_2e_0__PHI_TEMPORARY = 3ull;   /* for PHI node */
  goto llvm_cbe_bb776_2e_i;

  } while (1); /* end of syntactic loop 'bb881.i' */
llvm_cbe_bb743_2e_i:
  llvm_cbe_tmp2_2e_i166_2e_i = (&llvm_cbe_storemerge74_2e_i->field2);
  llvm_cbe_tmp2_2e_i162_2e_i = (&llvm_cbe_storemerge74_2e_i->field11);
  llvm_cbe_retval_2e_i106_2e_i_2e_2__PHI_TEMPORARY = llvm_cbe_retval_2e_i106_2e_i_2e_3;   /* for PHI node */
  llvm_cbe_storemerge73_2e_i_2e_in__PHI_TEMPORARY = llvm_cbe_tmp2_2e_i162_2e_i;   /* for PHI node */
  goto llvm_cbe_bb881_2e_i;

  } while (1); /* end of syntactic loop 'bb889.i' */
llvm_cbe_bb894_2e_i:
  if (((llvm_cbe_tmp3_2e_i_2e_i12 & 64u) == 0u)) {
    goto llvm_cbe__ZN7b2World13DrawDebugDataEv_2e_exit;
  } else {
    goto llvm_cbe_bb900_2e_i;
  }

llvm_cbe_bb900_2e_i:
  llvm_cbe_tmp902_2e_i = (&llvm_cbe_this->field5);
  llvm_cbe_tmp909_2e_i = (&llvm_cbe_xf_2e_i.field0.field0);
  llvm_cbe_tmp912_2e_i = (&llvm_cbe_xf_2e_i.field0.field1);
  llvm_cbe_tmp919_2e_i = (&llvm_cbe_xf_2e_i.field1.field0.field0);
  llvm_cbe_tmp922_2e_i = (&llvm_cbe_xf_2e_i.field1.field0.field1);
  llvm_cbe_tmp927_2e_i = (&llvm_cbe_xf_2e_i.field1.field1.field0);
  llvm_cbe_tmp930_2e_i = (&llvm_cbe_xf_2e_i.field1.field1.field1);
  llvm_cbe_storemerge75_2e_i_2e_in__PHI_TEMPORARY = llvm_cbe_tmp902_2e_i;   /* for PHI node */
  goto llvm_cbe_bb964_2e_i;

  do {     /* Syntactic loop 'bb964.i' to make GCC happy */
llvm_cbe_bb964_2e_i:
  llvm_cbe_storemerge75_2e_i_2e_in = llvm_cbe_storemerge75_2e_i_2e_in__PHI_TEMPORARY;
  llvm_cbe_storemerge75_2e_i = *llvm_cbe_storemerge75_2e_i_2e_in;
  if ((llvm_cbe_storemerge75_2e_i == ((struct l_struct_2E_b2Body *)/*NULL*/0))) {
    goto llvm_cbe__ZN7b2World13DrawDebugDataEv_2e_exit;
  } else {
    goto llvm_cbe_bb904_2e_i;
  }

llvm_cbe_bb904_2e_i:
  llvm_cbe_tmp911_2e_i = *((&llvm_cbe_storemerge75_2e_i->field2.field0.field0));
  *llvm_cbe_tmp909_2e_i = llvm_cbe_tmp911_2e_i;
  llvm_cbe_tmp914_2e_i = *((&llvm_cbe_storemerge75_2e_i->field2.field0.field1));
  *llvm_cbe_tmp912_2e_i = llvm_cbe_tmp914_2e_i;
  llvm_cbe_tmp921_2e_i = *((&llvm_cbe_storemerge75_2e_i->field2.field1.field0.field0));
  *llvm_cbe_tmp919_2e_i = llvm_cbe_tmp921_2e_i;
  llvm_cbe_tmp924_2e_i = *((&llvm_cbe_storemerge75_2e_i->field2.field1.field0.field1));
  *llvm_cbe_tmp922_2e_i = llvm_cbe_tmp924_2e_i;
  llvm_cbe_tmp929_2e_i = *((&llvm_cbe_storemerge75_2e_i->field2.field1.field1.field0));
  *llvm_cbe_tmp927_2e_i = llvm_cbe_tmp929_2e_i;
  llvm_cbe_tmp932_2e_i = *((&llvm_cbe_storemerge75_2e_i->field2.field1.field1.field1));
  *llvm_cbe_tmp930_2e_i = llvm_cbe_tmp932_2e_i;
  llvm_cbe_tmp937_2e_i = *((&llvm_cbe_storemerge75_2e_i->field3.field2.field0));
  llvm_cbe_tmp940_2e_i = *((&llvm_cbe_storemerge75_2e_i->field3.field2.field1));
  *llvm_cbe_tmp909_2e_i = llvm_cbe_tmp937_2e_i;
  *llvm_cbe_tmp912_2e_i = llvm_cbe_tmp940_2e_i;
  llvm_cbe_tmp953_2e_i = *llvm_cbe_tmp43_2e_i;
  llvm_cbe_tmp955_2e_i = *((&llvm_cbe_tmp953_2e_i->field0));
  llvm_cbe_tmp957_2e_i = *((&llvm_cbe_tmp955_2e_i[((signed long long )7ull)]));
  (((void  (*) (struct l_struct_2E_b2DebugDraw *, struct l_struct_2E_b2XForm *))llvm_cbe_tmp957_2e_i))(llvm_cbe_tmp953_2e_i, (&llvm_cbe_xf_2e_i));
  llvm_cbe_tmp2_2e_i80_2e_i = (&llvm_cbe_storemerge75_2e_i->field10);
  llvm_cbe_storemerge75_2e_i_2e_in__PHI_TEMPORARY = llvm_cbe_tmp2_2e_i80_2e_i;   /* for PHI node */
  goto llvm_cbe_bb964_2e_i;

  } while (1); /* end of syntactic loop 'bb964.i' */
llvm_cbe__ZN7b2World13DrawDebugDataEv_2e_exit:
  llvm_cbe_tmp54 = *((&llvm_cbe_step.field1));
  *llvm_cbe_tmp16 = llvm_cbe_tmp54;
  *llvm_cbe_tmp1 = ((unsigned char )0);
  return;
}


static void _ZN5SceneC1Eb(struct l_struct_2E_Scene *llvm_cbe_this, unsigned char llvm_cbe_noWorld) {
  unsigned int llvm_cbe_j_2e_i_2e_i_2e_1_2e_reg2mem;    /* Address-exposed local */
  unsigned int llvm_cbe_i_2e_i_2e_i_2e_0_2e_reg2mem;    /* Address-exposed local */
  struct l_struct_2E_b2BodyDef llvm_cbe_bd_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2AABB llvm_cbe_worldAABB;    /* Address-exposed local */
  struct l_struct_2E_b2World **llvm_cbe_tmp8;
  struct l_struct_2E_Stroke ***llvm_cbe_tmp1_2e_i50;
  unsigned int *llvm_cbe_tmp5_2e_i54;
  unsigned char *llvm_cbe_tmp28_2e_i_2e_i78;
  float *llvm_cbe_tmp1_2e_i38;
  float *llvm_cbe_tmp4_2e_i41;
  float *llvm_cbe_tmp1_2e_i29;
  float *llvm_cbe_tmp4_2e_i32;
  unsigned char *llvm_cbe_tmp30;
  struct l_struct_2E_b2World *llvm_cbe_tmp3031;
  struct l_struct_2E_b2BlockAllocator *llvm_cbe_tmp3_2e_i14;
  unsigned int *llvm_cbe_tmp5_2e_i_2e_i;
  unsigned int llvm_cbe_tmp6_2e_i_2e_i;
  unsigned int llvm_cbe_tmp2_2e_i_2e_i_2e_i84;
  unsigned int llvm_cbe_tmp3_2e_i_2e_i_2e_i;
  unsigned char *llvm_cbe_tmp8_2e_i_2e_i_2e_i;
  unsigned char *llvm_cbe_tmp13_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp16_2e_i_2e_i;
  unsigned char *ltmp_8_1;
  unsigned char *ltmp_9_1;
  bool llvm_cbe_tmp27_2e_b_2e_i_2e_i;
  unsigned int llvm_cbe_j_2e_i_2e_i_2e_1_2e_reload116;
  unsigned int llvm_cbe_j_2e_i_2e_i_2e_1_2e_reload115;
  unsigned int llvm_cbe_tmp43_2e_i_2e_i;
  unsigned int llvm_cbe_i_2e_i_2e_i_2e_0_2e_reload112;
  unsigned int llvm_cbe_j_2e_i_2e_i_2e_1_2e_reload;
  unsigned int llvm_cbe_i_2e_i_2e_i_2e_0_2e_reload111;
  unsigned int llvm_cbe_j_2e_i_2e_i_2e_1_2e_reload113;
  unsigned int llvm_cbe_tmp56_2e_i_2e_i;
  unsigned int llvm_cbe_i_2e_i_2e_i_2e_0_2e_reload;
  unsigned int llvm_cbe_j_2e_i_2e_i_2e_0;
  unsigned int llvm_cbe_j_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_i_2e_i_2e_i_2e_0_2e_reload110;
  unsigned int llvm_cbe_tmp64_2e_i_2e_i;
  struct l_struct_2E_Os **llvm_cbe_tmp17_2e_i;
  unsigned int llvm_cbe_tmp3_2e_i123_2e_i;
  unsigned char *llvm_cbe_tmp8_2e_i128_2e_i;
  unsigned char *llvm_cbe_tmp13_2e_i131_2e_i;
  struct l_struct_2E_b2BroadPhase *llvm_cbe_tmp6768_2e_i;
  struct l_struct_2E_Os *llvm_cbe_tmp74_2e_i;
  unsigned int llvm_cbe_i1_2e_i_2e_i_2e_i_2e_0;
  unsigned int llvm_cbe_i1_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp15_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_i_2e_i_2e_i_2e_i_2e_0;
  unsigned int llvm_cbe_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp2528_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp59_2e_i_2e_i_2e_i;
  unsigned char llvm_cbe_tmp12_2e_i85_2e_i;
  float llvm_cbe_tmp26_2e_i91_2e_i;
  float llvm_cbe_tmp29_2e_i94_2e_i;
  float llvm_cbe_tmp34_2e_i_2e_i;
  float llvm_cbe_tmp37_2e_i_2e_i;
  float llvm_cbe_tmp3_2e_i22_2e_i_2e_i;
  float llvm_cbe_tmp6_2e_i_2e_i102_2e_i;
  float llvm_cbe_tmp10_2e_i24_2e_i_2e_i;
  float llvm_cbe_tmp13_2e_i25_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i32_2e_i_2e_i100__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i34_2e_i_2e_i107__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i34_2e_i_2e_i107108109_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp29_2e_i_2e_i_2e_i99__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp32_2e_i37_2e_i_2e_i105__BITCAST_TEMPORARY;
  unsigned short llvm_cbe_i_2e_i69_2e_i_2e_0;
  unsigned short llvm_cbe_i_2e_i69_2e_i_2e_0__PHI_TEMPORARY;
  unsigned short llvm_cbe_tmp66_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp686972_2e_i_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp93_2e_i;

  *((&llvm_cbe_this->field0.field0)) = ((&_ZTV5Scene[((signed long long )2ull)]));
  llvm_cbe_tmp8 = (&llvm_cbe_this->field1);
  *llvm_cbe_tmp8 = ((struct l_struct_2E_b2World *)/*NULL*/0);
  llvm_cbe_tmp1_2e_i50 = (&llvm_cbe_this->field2.field0);
  *llvm_cbe_tmp1_2e_i50 = ((struct l_struct_2E_Stroke **)/*NULL*/0);
  *((&llvm_cbe_this->field2.field1)) = 0u;
  llvm_cbe_tmp5_2e_i54 = (&llvm_cbe_this->field2.field2);
  *llvm_cbe_tmp5_2e_i54 = 0u;
  llvm_cbe_tmp28_2e_i_2e_i78 = malloc(0ull);
  *llvm_cbe_tmp1_2e_i50 = (((struct l_struct_2E_Stroke **)llvm_cbe_tmp28_2e_i_2e_i78));
  *llvm_cbe_tmp5_2e_i54 = 0u;
  _ZNSsC1Ev(((&llvm_cbe_this->field3)));
  _ZNSsC1Ev(((&llvm_cbe_this->field4)));
  _ZNSsC1Ev(((&llvm_cbe_this->field5)));
  *((&llvm_cbe_this->field6)) = ((struct l_struct_2E_Image *)/*NULL*/0);
  *((&llvm_cbe_this->field7)) = 0u;
  if ((llvm_cbe_noWorld == ((unsigned char )0))) {
    goto llvm_cbe_bb;
  } else {
    goto llvm_cbe_return;
  }

llvm_cbe_bb:
  llvm_cbe_tmp1_2e_i38 = (&llvm_cbe_worldAABB.field0.field0);
  *llvm_cbe_tmp1_2e_i38 = -0x1.9p+6;
  llvm_cbe_tmp4_2e_i41 = (&llvm_cbe_worldAABB.field0.field1);
  *llvm_cbe_tmp4_2e_i41 = -0x1.9p+6;
  llvm_cbe_tmp1_2e_i29 = (&llvm_cbe_worldAABB.field1.field0);
  *llvm_cbe_tmp1_2e_i29 = 0x1.9p+6;
  llvm_cbe_tmp4_2e_i32 = (&llvm_cbe_worldAABB.field1.field1);
  *llvm_cbe_tmp4_2e_i32 = 0x1.9p+6;
  llvm_cbe_tmp30 = _Znwm(103344ull);
  llvm_cbe_tmp3031 = ((struct l_struct_2E_b2World *)llvm_cbe_tmp30);
  llvm_cbe_tmp3_2e_i14 = ((struct l_struct_2E_b2BlockAllocator *)llvm_cbe_tmp30);
  *((&llvm_cbe_tmp3031->field0.field2)) = 128u;
  *((&llvm_cbe_tmp3031->field0.field1)) = 0u;
  llvm_cbe_tmp5_2e_i_2e_i = (&llvm_cbe_tmp3031->field0.field2);
  llvm_cbe_tmp6_2e_i_2e_i = *llvm_cbe_tmp5_2e_i_2e_i;
  llvm_cbe_tmp2_2e_i_2e_i_2e_i84 = (llvm_cbe_tmp6_2e_i_2e_i << 4u) | 4u;
  llvm_cbe_tmp3_2e_i_2e_i_2e_i = *(&b2_byteCount);
  *(&b2_byteCount) = (llvm_cbe_tmp3_2e_i_2e_i_2e_i + llvm_cbe_tmp2_2e_i_2e_i_2e_i84);
  llvm_cbe_tmp8_2e_i_2e_i_2e_i = malloc((((signed long long )(signed int )llvm_cbe_tmp2_2e_i_2e_i_2e_i84)));
  *(((unsigned int *)llvm_cbe_tmp8_2e_i_2e_i_2e_i)) = llvm_cbe_tmp2_2e_i_2e_i_2e_i84;
  llvm_cbe_tmp13_2e_i_2e_i_2e_i = (&llvm_cbe_tmp8_2e_i_2e_i_2e_i[((signed long long )4ull)]);
  *(((struct l_struct_2E_b2Chunk **)llvm_cbe_tmp30)) = (((struct l_struct_2E_b2Chunk *)llvm_cbe_tmp13_2e_i_2e_i_2e_i));
  llvm_cbe_tmp16_2e_i_2e_i = *llvm_cbe_tmp5_2e_i_2e_i;
  ltmp_8_1 = memset(llvm_cbe_tmp13_2e_i_2e_i_2e_i, (((unsigned int )(unsigned char )((unsigned char )0))), ((((signed long long )(signed int )llvm_cbe_tmp16_2e_i_2e_i)) << 4ull));
  ltmp_9_1 = memset(((&llvm_cbe_tmp30[((signed long long )16ull)])), (((unsigned int )(unsigned char )((unsigned char )0))), 112ull);
  llvm_cbe_tmp27_2e_b_2e_i_2e_i = ((*(&_ZN16b2BlockAllocator28s_blockSizeLookupInitializedE_2E_b))&1);
  if (llvm_cbe_tmp27_2e_b_2e_i_2e_i) {
    goto llvm_cbe__ZN16b2BlockAllocatorC1Ev_2e_exit_2e_i;
  } else {
    goto llvm_cbe_bb30_2e_i_2e_i_2e_thread;
  }

llvm_cbe_bb30_2e_i_2e_i_2e_thread:
  *(&llvm_cbe_j_2e_i_2e_i_2e_1_2e_reg2mem) = 0u;
  *(&llvm_cbe_i_2e_i_2e_i_2e_0_2e_reg2mem) = 1u;
  goto llvm_cbe_bb39_2e_i_2e_i;

llvm_cbe_bb35_2e_i_2e_i:
  __assert_fail(((&_2E_str3180[((signed long long )0ull)])), ((&_2E_str1178[((signed long long )0ull)])), 72u, ((&_ZZN16b2BlockAllocatorC4EvE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
  do {     /* Syntactic loop 'bb39.i.i' to make GCC happy */
llvm_cbe_bb39_2e_i_2e_i:
  llvm_cbe_j_2e_i_2e_i_2e_1_2e_reload115 = *(&llvm_cbe_j_2e_i_2e_i_2e_1_2e_reg2mem);
  llvm_cbe_tmp43_2e_i_2e_i = *((&_ZN16b2BlockAllocator12s_blockSizesE[((signed long long )(((signed long long )(signed int )llvm_cbe_j_2e_i_2e_i_2e_1_2e_reload115)))]));
  llvm_cbe_i_2e_i_2e_i_2e_0_2e_reload112 = *(&llvm_cbe_i_2e_i_2e_i_2e_0_2e_reg2mem);
  llvm_cbe_j_2e_i_2e_i_2e_1_2e_reload = *(&llvm_cbe_j_2e_i_2e_i_2e_1_2e_reg2mem);
  if ((((signed int )llvm_cbe_tmp43_2e_i_2e_i) < ((signed int )llvm_cbe_i_2e_i_2e_i_2e_0_2e_reload112))) {
    goto llvm_cbe_bb54_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb48_2e_i_2e_i;
  }

llvm_cbe_bb30_2e_i_2e_i:
  *(&llvm_cbe_j_2e_i_2e_i_2e_1_2e_reg2mem) = llvm_cbe_j_2e_i_2e_i_2e_0;
  *(&llvm_cbe_i_2e_i_2e_i_2e_0_2e_reg2mem) = llvm_cbe_tmp64_2e_i_2e_i;
  llvm_cbe_j_2e_i_2e_i_2e_1_2e_reload116 = *(&llvm_cbe_j_2e_i_2e_i_2e_1_2e_reg2mem);
  if ((((signed int )llvm_cbe_j_2e_i_2e_i_2e_1_2e_reload116) > ((signed int )13u))) {
    goto llvm_cbe_bb35_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb39_2e_i_2e_i;
  }

llvm_cbe_bb62_2e_i_2e_i:
  llvm_cbe_j_2e_i_2e_i_2e_0 = llvm_cbe_j_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_i_2e_i_2e_i_2e_0_2e_reload110 = *(&llvm_cbe_i_2e_i_2e_i_2e_0_2e_reg2mem);
  llvm_cbe_tmp64_2e_i_2e_i = llvm_cbe_i_2e_i_2e_i_2e_0_2e_reload110 + 1u;
  if ((((signed int )llvm_cbe_tmp64_2e_i_2e_i) < ((signed int )641u))) {
    goto llvm_cbe_bb30_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb71_2e_i_2e_i;
  }

llvm_cbe_bb48_2e_i_2e_i:
  llvm_cbe_i_2e_i_2e_i_2e_0_2e_reload111 = *(&llvm_cbe_i_2e_i_2e_i_2e_0_2e_reg2mem);
  *((&_ZN16b2BlockAllocator17s_blockSizeLookupE[((signed long long )(((signed long long )(signed int )llvm_cbe_i_2e_i_2e_i_2e_0_2e_reload111)))])) = (((unsigned char )llvm_cbe_j_2e_i_2e_i_2e_1_2e_reload));
  llvm_cbe_j_2e_i_2e_i_2e_1_2e_reload113 = *(&llvm_cbe_j_2e_i_2e_i_2e_1_2e_reg2mem);
  llvm_cbe_j_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_j_2e_i_2e_i_2e_1_2e_reload113;   /* for PHI node */
  goto llvm_cbe_bb62_2e_i_2e_i;

llvm_cbe_bb54_2e_i_2e_i:
  llvm_cbe_tmp56_2e_i_2e_i = llvm_cbe_j_2e_i_2e_i_2e_1_2e_reload + 1u;
  llvm_cbe_i_2e_i_2e_i_2e_0_2e_reload = *(&llvm_cbe_i_2e_i_2e_i_2e_0_2e_reg2mem);
  *((&_ZN16b2BlockAllocator17s_blockSizeLookupE[((signed long long )(((signed long long )(signed int )llvm_cbe_i_2e_i_2e_i_2e_0_2e_reload)))])) = (((unsigned char )llvm_cbe_tmp56_2e_i_2e_i));
  llvm_cbe_j_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp56_2e_i_2e_i;   /* for PHI node */
  goto llvm_cbe_bb62_2e_i_2e_i;

  } while (1); /* end of syntactic loop 'bb39.i.i' */
llvm_cbe_bb71_2e_i_2e_i:
  *(&_ZN16b2BlockAllocator28s_blockSizeLookupInitializedE_2E_b) = ((1) & 1);
  goto llvm_cbe__ZN16b2BlockAllocatorC1Ev_2e_exit_2e_i;

llvm_cbe__ZN16b2BlockAllocatorC1Ev_2e_exit_2e_i:
  *((&llvm_cbe_tmp3031->field1.field1)) = 0u;
  *((&llvm_cbe_tmp3031->field1.field2)) = 0u;
  *((&llvm_cbe_tmp3031->field1.field3)) = 0u;
  *((&llvm_cbe_tmp3031->field1.field5)) = 0u;
  *((&llvm_cbe_tmp3031->field4.field0.field0)) = ((&_ZTV14b2PairCallback[((signed long long )2ull)]));
  *((&llvm_cbe_tmp3031->field4.field0.field0)) = ((&_ZTV16b2ContactManager[((signed long long )2ull)]));
  *((&llvm_cbe_tmp3031->field4.field1)) = ((struct l_struct_2E_b2World *)/*NULL*/0);
  *((&llvm_cbe_tmp3031->field4.field2.field0.field0)) = ((&_ZTV9b2Contact[((signed long long )2ull)]));
  *((&llvm_cbe_tmp3031->field4.field2.field0.field7)) = ((struct l_struct_2E_b2Shape *)/*NULL*/0);
  *((&llvm_cbe_tmp3031->field4.field2.field0.field8)) = ((struct l_struct_2E_b2Shape *)/*NULL*/0);
  *((&llvm_cbe_tmp3031->field4.field2.field0.field0)) = ((&_ZTV13b2NullContact[((signed long long )2ull)]));
  *((&llvm_cbe_tmp3031->field4.field3)) = ((unsigned char )0);
  *((&llvm_cbe_tmp3031->field14)) = ((struct l_struct_2E_Os *)/*NULL*/0);
  *((&llvm_cbe_tmp3031->field15)) = ((struct l_struct_2E_Os *)/*NULL*/0);
  *((&llvm_cbe_tmp3031->field16)) = (&b2_defaultFilter);
  llvm_cbe_tmp17_2e_i = (&llvm_cbe_tmp3031->field17);
  *llvm_cbe_tmp17_2e_i = ((struct l_struct_2E_Os *)/*NULL*/0);
  *((&llvm_cbe_tmp3031->field18)) = ((struct l_struct_2E_b2DebugDraw *)/*NULL*/0);
  *((&llvm_cbe_tmp3031->field5)) = ((struct l_struct_2E_b2Body *)/*NULL*/0);
  *((&llvm_cbe_tmp3031->field7)) = ((struct l_struct_2E_b2Contact *)/*NULL*/0);
  *((&llvm_cbe_tmp3031->field6)) = ((struct l_struct_2E_b2Joint *)/*NULL*/0);
  *((&llvm_cbe_tmp3031->field8)) = 0u;
  *((&llvm_cbe_tmp3031->field9)) = 0u;
  *((&llvm_cbe_tmp3031->field10)) = 0u;
  *((&llvm_cbe_tmp3031->field21)) = ((unsigned char )1);
  *((&llvm_cbe_tmp3031->field22)) = ((unsigned char )1);
  *((&llvm_cbe_tmp3031->field23)) = ((unsigned char )1);
  *((&llvm_cbe_tmp3031->field12)) = ((unsigned char )1);
  *((&llvm_cbe_tmp3031->field11.field0)) = 0x0p+0;
  *((&llvm_cbe_tmp3031->field11.field1)) = 0x1.4p+3;
  *((&llvm_cbe_tmp3031->field2)) = ((unsigned char )0);
  *((&llvm_cbe_tmp3031->field19)) = 0x0p+0;
  *((&llvm_cbe_tmp3031->field4.field1)) = llvm_cbe_tmp3031;
  llvm_cbe_tmp3_2e_i123_2e_i = *(&b2_byteCount);
  *(&b2_byteCount) = (llvm_cbe_tmp3_2e_i123_2e_i + 462924u);
  llvm_cbe_tmp8_2e_i128_2e_i = malloc(462924ull);
  *(((unsigned int *)llvm_cbe_tmp8_2e_i128_2e_i)) = 462924u;
  llvm_cbe_tmp13_2e_i131_2e_i = (&llvm_cbe_tmp8_2e_i128_2e_i[((signed long long )4ull)]);
  llvm_cbe_tmp6768_2e_i = ((struct l_struct_2E_b2BroadPhase *)llvm_cbe_tmp13_2e_i131_2e_i);
  if ((llvm_cbe_tmp13_2e_i131_2e_i == ((unsigned char *)/*NULL*/0))) {
    goto llvm_cbe_bb87_2e_i;
  } else {
    goto llvm_cbe_bb_2e_i18;
  }

llvm_cbe_bb_2e_i18:
  llvm_cbe_tmp74_2e_i = (&llvm_cbe_tmp3031->field4.field0);
  llvm_cbe_i1_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb8_2e_i_2e_i_2e_i;

  do {     /* Syntactic loop 'bb8.i.i.i' to make GCC happy */
llvm_cbe_bb8_2e_i_2e_i_2e_i:
  llvm_cbe_i1_2e_i_2e_i_2e_i_2e_0 = llvm_cbe_i1_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  *((&llvm_cbe_tmp6768_2e_i->field0.field7[((signed long long )(((signed long long )(signed int )llvm_cbe_i1_2e_i_2e_i_2e_i_2e_0)))])) = ((unsigned short )-1);
  llvm_cbe_tmp15_2e_i_2e_i_2e_i = llvm_cbe_i1_2e_i_2e_i_2e_i_2e_0 + 1u;
  if ((((signed int )llvm_cbe_tmp15_2e_i_2e_i_2e_i) < ((signed int )16384u))) {
    llvm_cbe_i1_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp15_2e_i_2e_i_2e_i;   /* for PHI node */
    goto llvm_cbe_bb8_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe_bb21_2e_i_2e_i_2e_i;
  }

  } while (1); /* end of syntactic loop 'bb8.i.i.i' */
llvm_cbe_bb21_2e_i_2e_i_2e_i:
  *((&llvm_cbe_tmp6768_2e_i->field0.field3)) = ((unsigned short )0);
  llvm_cbe_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_bb24_2e_i_2e_i_2e_i;

  do {     /* Syntactic loop 'bb24.i.i.i' to make GCC happy */
llvm_cbe_bb24_2e_i_2e_i_2e_i:
  llvm_cbe_i_2e_i_2e_i_2e_i_2e_0 = llvm_cbe_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp2528_2e_i_2e_i_2e_i = ((signed long long )(signed int )llvm_cbe_i_2e_i_2e_i_2e_i_2e_0);
  *((&llvm_cbe_tmp6768_2e_i->field0.field2[((signed long long )llvm_cbe_tmp2528_2e_i_2e_i_2e_i)].field1)) = ((unsigned short )-1);
  *((&llvm_cbe_tmp6768_2e_i->field0.field2[((signed long long )llvm_cbe_tmp2528_2e_i_2e_i_2e_i)].field2)) = ((unsigned short )-1);
  *((&llvm_cbe_tmp6768_2e_i->field0.field2[((signed long long )llvm_cbe_tmp2528_2e_i_2e_i_2e_i)].field0)) = ((unsigned char *)/*NULL*/0);
  *((&llvm_cbe_tmp6768_2e_i->field0.field2[((signed long long )llvm_cbe_tmp2528_2e_i_2e_i_2e_i)].field4)) = ((unsigned short )0);
  *((&llvm_cbe_tmp6768_2e_i->field0.field2[((signed long long )llvm_cbe_tmp2528_2e_i_2e_i_2e_i)].field3)) = (((unsigned short )((((unsigned short )llvm_cbe_i_2e_i_2e_i_2e_i_2e_0)) + ((unsigned short )1))));
  llvm_cbe_tmp59_2e_i_2e_i_2e_i = llvm_cbe_i_2e_i_2e_i_2e_i_2e_0 + 1u;
  if ((((signed int )llvm_cbe_tmp59_2e_i_2e_i_2e_i) < ((signed int )16384u))) {
    llvm_cbe_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp59_2e_i_2e_i_2e_i;   /* for PHI node */
    goto llvm_cbe_bb24_2e_i_2e_i_2e_i;
  } else {
    goto llvm_cbe__ZN13b2PairManagerC1Ev_2e_exit_2e_i_2e_i;
  }

  } while (1); /* end of syntactic loop 'bb24.i.i.i' */
llvm_cbe__ZN13b2PairManagerC1Ev_2e_exit_2e_i_2e_i:
  *((&llvm_cbe_tmp6768_2e_i->field0.field2[((signed long long )16383ull)].field3)) = ((unsigned short )-1);
  *((&llvm_cbe_tmp6768_2e_i->field0.field4)) = 0u;
  *((&llvm_cbe_tmp6768_2e_i->field0.field6)) = 0u;
  *(((struct l_struct_2E_b2BroadPhase **)llvm_cbe_tmp13_2e_i131_2e_i)) = llvm_cbe_tmp6768_2e_i;
  *((&llvm_cbe_tmp6768_2e_i->field0.field1)) = llvm_cbe_tmp74_2e_i;
  llvm_cbe_tmp12_2e_i85_2e_i = _ZNK6b2AABB7IsValidEv((&llvm_cbe_worldAABB));
  if ((llvm_cbe_tmp12_2e_i85_2e_i == ((unsigned char )0))) {
    goto llvm_cbe_bb_2e_i86_2e_i;
  } else {
    goto llvm_cbe_bb18_2e_i_2e_i;
  }

llvm_cbe_bb_2e_i86_2e_i:
  __assert_fail(((&_2E_str24214[((signed long long )0ull)])), ((&_2E_str1191[((signed long long )0ull)])), 71u, ((&_ZZN12b2BroadPhaseC4ERK6b2AABBP14b2PairCallbackE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb18_2e_i_2e_i:
  llvm_cbe_tmp26_2e_i91_2e_i = *((&llvm_cbe_worldAABB.field0.field0));
  *((&llvm_cbe_tmp6768_2e_i->field6.field0.field0)) = llvm_cbe_tmp26_2e_i91_2e_i;
  llvm_cbe_tmp29_2e_i94_2e_i = *((&llvm_cbe_worldAABB.field0.field1));
  *((&llvm_cbe_tmp6768_2e_i->field6.field0.field1)) = llvm_cbe_tmp29_2e_i94_2e_i;
  llvm_cbe_tmp34_2e_i_2e_i = *((&llvm_cbe_worldAABB.field1.field0));
  *((&llvm_cbe_tmp6768_2e_i->field6.field1.field0)) = llvm_cbe_tmp34_2e_i_2e_i;
  llvm_cbe_tmp37_2e_i_2e_i = *((&llvm_cbe_worldAABB.field1.field1));
  *((&llvm_cbe_tmp6768_2e_i->field6.field1.field1)) = llvm_cbe_tmp37_2e_i_2e_i;
  *((&llvm_cbe_tmp6768_2e_i->field8)) = 0u;
  llvm_cbe_tmp3_2e_i22_2e_i_2e_i = *llvm_cbe_tmp4_2e_i32;
  llvm_cbe_tmp6_2e_i_2e_i102_2e_i = *llvm_cbe_tmp4_2e_i41;
  llvm_cbe_tmp10_2e_i24_2e_i_2e_i = *llvm_cbe_tmp1_2e_i29;
  llvm_cbe_tmp13_2e_i25_2e_i_2e_i = *llvm_cbe_tmp1_2e_i38;
  llvm_cbe_tmp26_2e_i34_2e_i_2e_i107108109_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp23_2e_i32_2e_i_2e_i100__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp10_2e_i24_2e_i_2e_i - llvm_cbe_tmp13_2e_i25_2e_i_2e_i))), llvm_cbe_tmp23_2e_i32_2e_i_2e_i100__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp26_2e_i34_2e_i_2e_i107__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp3_2e_i22_2e_i_2e_i - llvm_cbe_tmp6_2e_i_2e_i102_2e_i))), llvm_cbe_tmp26_2e_i34_2e_i_2e_i107__BITCAST_TEMPORARY.Int32)))) << 32ull);
  *((&llvm_cbe_tmp6768_2e_i->field7.field0)) = (((float )(0x1.fffep+15 / ((llvm_cbe_tmp29_2e_i_2e_i_2e_i99__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp26_2e_i34_2e_i_2e_i107108109_2e_ins)), llvm_cbe_tmp29_2e_i_2e_i_2e_i99__BITCAST_TEMPORARY.Float)))));
  *((&llvm_cbe_tmp6768_2e_i->field7.field1)) = (((float )(0x1.fffep+15 / ((llvm_cbe_tmp32_2e_i37_2e_i_2e_i105__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp26_2e_i34_2e_i_2e_i107108109_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp32_2e_i37_2e_i_2e_i105__BITCAST_TEMPORARY.Float)))));
  llvm_cbe_i_2e_i69_2e_i_2e_0__PHI_TEMPORARY = ((unsigned short )0);   /* for PHI node */
  goto llvm_cbe_bb64_2e_i_2e_i;

  do {     /* Syntactic loop 'bb64.i.i' to make GCC happy */
llvm_cbe_bb64_2e_i_2e_i:
  llvm_cbe_i_2e_i69_2e_i_2e_0 = llvm_cbe_i_2e_i69_2e_i_2e_0__PHI_TEMPORARY;
  llvm_cbe_tmp66_2e_i_2e_i = ((unsigned short )(llvm_cbe_i_2e_i69_2e_i_2e_0 + ((unsigned short )1)));
  llvm_cbe_tmp686972_2e_i_2e_i = ((unsigned long long )(unsigned short )llvm_cbe_i_2e_i69_2e_i_2e_0);
  *((&llvm_cbe_tmp6768_2e_i->field1[((signed long long )llvm_cbe_tmp686972_2e_i_2e_i)].field0[((signed long long )0ull)])) = llvm_cbe_tmp66_2e_i_2e_i;
  *((&llvm_cbe_tmp6768_2e_i->field1[((signed long long )llvm_cbe_tmp686972_2e_i_2e_i)].field3)) = ((unsigned short )0);
  *((&llvm_cbe_tmp6768_2e_i->field1[((signed long long )llvm_cbe_tmp686972_2e_i_2e_i)].field2)) = ((unsigned short )-1);
  *((&llvm_cbe_tmp6768_2e_i->field1[((signed long long )llvm_cbe_tmp686972_2e_i_2e_i)].field4)) = ((unsigned char *)/*NULL*/0);
  if ((((unsigned short )llvm_cbe_tmp66_2e_i_2e_i) < ((unsigned short )((unsigned short )2047)))) {
    llvm_cbe_i_2e_i69_2e_i_2e_0__PHI_TEMPORARY = llvm_cbe_tmp66_2e_i_2e_i;   /* for PHI node */
    goto llvm_cbe_bb64_2e_i_2e_i;
  } else {
    goto llvm_cbe__ZN12b2BroadPhaseC1ERK6b2AABBP14b2PairCallback_2e_exit_2e_i;
  }

  } while (1); /* end of syntactic loop 'bb64.i.i' */
llvm_cbe__ZN12b2BroadPhaseC1ERK6b2AABBP14b2PairCallback_2e_exit_2e_i:
  *((&llvm_cbe_tmp6768_2e_i->field1[((signed long long )2047ull)].field0[((signed long long )0ull)])) = ((unsigned short )-1);
  *((&llvm_cbe_tmp6768_2e_i->field1[((signed long long )2047ull)].field3)) = ((unsigned short )0);
  *((&llvm_cbe_tmp6768_2e_i->field1[((signed long long )2047ull)].field2)) = ((unsigned short )-1);
  *((&llvm_cbe_tmp6768_2e_i->field1[((signed long long )2047ull)].field4)) = ((unsigned char *)/*NULL*/0);
  *((&llvm_cbe_tmp6768_2e_i->field2)) = ((unsigned short )0);
  *((&llvm_cbe_tmp6768_2e_i->field9)) = ((unsigned short )1);
  *((&llvm_cbe_tmp6768_2e_i->field5)) = 0u;
  goto llvm_cbe_bb87_2e_i;

llvm_cbe_bb87_2e_i:
  *((&llvm_cbe_tmp3031->field3)) = llvm_cbe_tmp6768_2e_i;
  *((&llvm_cbe_bd_2e_i.field0.field1.field0)) = 0x0p+0;
  *((&llvm_cbe_bd_2e_i.field0.field1.field1)) = 0x0p+0;
  *((&llvm_cbe_bd_2e_i.field0.field0)) = 0x0p+0;
  *((&llvm_cbe_bd_2e_i.field0.field2)) = 0x0p+0;
  *((&llvm_cbe_bd_2e_i.field1)) = ((unsigned char *)/*NULL*/0);
  *((&llvm_cbe_bd_2e_i.field2.field0)) = 0x0p+0;
  *((&llvm_cbe_bd_2e_i.field2.field1)) = 0x0p+0;
  *((&llvm_cbe_bd_2e_i.field3)) = 0x0p+0;
  *((&llvm_cbe_bd_2e_i.field4)) = 0x0p+0;
  *((&llvm_cbe_bd_2e_i.field5)) = 0x0p+0;
  *((&llvm_cbe_bd_2e_i.field6)) = ((unsigned char )1);
  *((&llvm_cbe_bd_2e_i.field7)) = ((unsigned char )0);
  *((&llvm_cbe_bd_2e_i.field8)) = ((unsigned char )0);
  *((&llvm_cbe_bd_2e_i.field9)) = ((unsigned char )0);
  llvm_cbe_tmp93_2e_i = _ZN7b2World10CreateBodyEPK9b2BodyDef(llvm_cbe_tmp3031, (&llvm_cbe_bd_2e_i));
  *((&llvm_cbe_tmp3031->field13)) = llvm_cbe_tmp93_2e_i;
  *llvm_cbe_tmp8 = llvm_cbe_tmp3031;
  *llvm_cbe_tmp17_2e_i = ((&llvm_cbe_this->field0));
  return;
llvm_cbe_return:
  return;
}


static void _ZN5SceneD1Ev(struct l_struct_2E_Scene *llvm_cbe_this) {
  unsigned int  (***llvm_cbe_tmp4) ();
  struct l_struct_2E_b2World **llvm_cbe_tmp7;
  struct l_struct_2E_b2World *llvm_cbe_tmp8;
  struct l_struct_2E_b2World *llvm_cbe_tmp15;
  struct l_struct_2E_Stroke **llvm_cbe_tmp2_2e_i;
  struct l_struct_2E_Stroke **llvm_cbe_tmp7_2e_i;

  llvm_cbe_tmp4 = (&llvm_cbe_this->field0.field0);
  *llvm_cbe_tmp4 = ((&_ZTV5Scene[((signed long long )2ull)]));
  _ZN5Scene5clearEv(llvm_cbe_this);
  llvm_cbe_tmp7 = (&llvm_cbe_this->field1);
  llvm_cbe_tmp8 = *llvm_cbe_tmp7;
  if ((llvm_cbe_tmp8 == ((struct l_struct_2E_b2World *)/*NULL*/0))) {
    goto llvm_cbe_bb25;
  } else {
    goto llvm_cbe_bb;
  }

llvm_cbe_bb:
  _ZN5Scene4stepEv(llvm_cbe_this);
  llvm_cbe_tmp15 = *llvm_cbe_tmp7;
  if ((llvm_cbe_tmp15 == ((struct l_struct_2E_b2World *)/*NULL*/0))) {
    goto llvm_cbe_bb25;
  } else {
    goto llvm_cbe_bb20;
  }

llvm_cbe_bb20:
  _ZN7b2WorldD1Ev(llvm_cbe_tmp15);
  _ZdlPv((((unsigned char *)llvm_cbe_tmp15)));
  goto llvm_cbe_bb25;

llvm_cbe_bb25:
  _ZNSsD1Ev(((&llvm_cbe_this->field5)));
  _ZNSsD1Ev(((&llvm_cbe_this->field4)));
  _ZNSsD1Ev(((&llvm_cbe_this->field3)));
  llvm_cbe_tmp2_2e_i = *((&llvm_cbe_this->field2.field0));
  if ((llvm_cbe_tmp2_2e_i == ((struct l_struct_2E_Stroke **)/*NULL*/0))) {
    goto llvm_cbe__ZN5ArrayIP6StrokeED1Ev_2e_exit;
  } else {
    goto llvm_cbe_bb_2e_i;
  }

llvm_cbe_bb_2e_i:
  llvm_cbe_tmp7_2e_i = *((&llvm_cbe_this->field2.field0));
  free((((unsigned char *)llvm_cbe_tmp7_2e_i)));
  goto llvm_cbe__ZN5ArrayIP6StrokeED1Ev_2e_exit;

llvm_cbe__ZN5ArrayIP6StrokeED1Ev_2e_exit:
  *llvm_cbe_tmp4 = ((&_ZTV17b2ContactListener[((signed long long )2ull)]));
  return;
}


static void _ZN5SceneD0Ev(struct l_struct_2E_Scene *llvm_cbe_this) {
  unsigned int  (***llvm_cbe_tmp4) ();
  struct l_struct_2E_b2World **llvm_cbe_tmp7;
  struct l_struct_2E_b2World *llvm_cbe_tmp8;
  struct l_struct_2E_b2World *llvm_cbe_tmp15;
  struct l_struct_2E_Stroke **llvm_cbe_tmp2_2e_i;
  struct l_struct_2E_Stroke **llvm_cbe_tmp7_2e_i;

  llvm_cbe_tmp4 = (&llvm_cbe_this->field0.field0);
  *llvm_cbe_tmp4 = ((&_ZTV5Scene[((signed long long )2ull)]));
  _ZN5Scene5clearEv(llvm_cbe_this);
  llvm_cbe_tmp7 = (&llvm_cbe_this->field1);
  llvm_cbe_tmp8 = *llvm_cbe_tmp7;
  if ((llvm_cbe_tmp8 == ((struct l_struct_2E_b2World *)/*NULL*/0))) {
    goto llvm_cbe_bb25;
  } else {
    goto llvm_cbe_bb;
  }

llvm_cbe_bb:
  _ZN5Scene4stepEv(llvm_cbe_this);
  llvm_cbe_tmp15 = *llvm_cbe_tmp7;
  if ((llvm_cbe_tmp15 == ((struct l_struct_2E_b2World *)/*NULL*/0))) {
    goto llvm_cbe_bb25;
  } else {
    goto llvm_cbe_bb20;
  }

llvm_cbe_bb20:
  _ZN7b2WorldD1Ev(llvm_cbe_tmp15);
  _ZdlPv((((unsigned char *)llvm_cbe_tmp15)));
  goto llvm_cbe_bb25;

llvm_cbe_bb25:
  _ZNSsD1Ev(((&llvm_cbe_this->field5)));
  _ZNSsD1Ev(((&llvm_cbe_this->field4)));
  _ZNSsD1Ev(((&llvm_cbe_this->field3)));
  llvm_cbe_tmp2_2e_i = *((&llvm_cbe_this->field2.field0));
  if ((llvm_cbe_tmp2_2e_i == ((struct l_struct_2E_Stroke **)/*NULL*/0))) {
    goto llvm_cbe__ZN5ArrayIP6StrokeED1Ev_2e_exit;
  } else {
    goto llvm_cbe_bb_2e_i;
  }

llvm_cbe_bb_2e_i:
  llvm_cbe_tmp7_2e_i = *((&llvm_cbe_this->field2.field0));
  free((((unsigned char *)llvm_cbe_tmp7_2e_i)));
  goto llvm_cbe__ZN5ArrayIP6StrokeED1Ev_2e_exit;

llvm_cbe__ZN5ArrayIP6StrokeED1Ev_2e_exit:
  *llvm_cbe_tmp4 = ((&_ZTV17b2ContactListener[((signed long long )2ull)]));
  _ZdlPv((((unsigned char *)llvm_cbe_this)));
  return;
}


static void _ZN11GameControlD0Ev(struct l_struct_2E_GameControl *llvm_cbe_this) {
  struct l_struct_2E_Levels_3A__3A_LevelDesc **llvm_cbe_tmp2_2e_i_2e_i;
  struct l_struct_2E_Levels_3A__3A_LevelDesc **llvm_cbe_tmp7_2e_i_2e_i;

  *((&llvm_cbe_this->field0)) = ((&_ZTV11GameControl[((signed long long )2ull)]));
  llvm_cbe_tmp2_2e_i_2e_i = *((&llvm_cbe_this->field9.field0.field0));
  if ((llvm_cbe_tmp2_2e_i_2e_i == ((struct l_struct_2E_Levels_3A__3A_LevelDesc **)/*NULL*/0))) {
    goto llvm_cbe_bb5;
  } else {
    goto llvm_cbe_bb_2e_i_2e_i;
  }

llvm_cbe_bb_2e_i_2e_i:
  llvm_cbe_tmp7_2e_i_2e_i = *((&llvm_cbe_this->field9.field0.field0));
  free((((unsigned char *)llvm_cbe_tmp7_2e_i_2e_i)));
  goto llvm_cbe_bb5;

llvm_cbe_bb5:
  _ZdlPv((((unsigned char *)llvm_cbe_this)));
  return;
}


static void _ZN11GameControlD1Ev(struct l_struct_2E_GameControl *llvm_cbe_this) {
  struct l_struct_2E_Levels_3A__3A_LevelDesc **llvm_cbe_tmp2_2e_i_2e_i;
  struct l_struct_2E_Levels_3A__3A_LevelDesc **llvm_cbe_tmp7_2e_i_2e_i;

  *((&llvm_cbe_this->field0)) = ((&_ZTV11GameControl[((signed long long )2ull)]));
  llvm_cbe_tmp2_2e_i_2e_i = *((&llvm_cbe_this->field9.field0.field0));
  if ((llvm_cbe_tmp2_2e_i_2e_i == ((struct l_struct_2E_Levels_3A__3A_LevelDesc **)/*NULL*/0))) {
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb_2e_i_2e_i;
  }

llvm_cbe_bb_2e_i_2e_i:
  llvm_cbe_tmp7_2e_i_2e_i = *((&llvm_cbe_this->field9.field0.field0));
  free((((unsigned char *)llvm_cbe_tmp7_2e_i_2e_i)));
  return;
llvm_cbe_return:
  return;
}


static void _ZN6b2Body8SetXFormERK6b2Vec2f(struct l_struct_2E_b2Body *llvm_cbe_this, struct l_struct_2E_b2Vec2 *llvm_cbe_position, float llvm_cbe_angle) {
  struct l_struct_2E_b2World **llvm_cbe_tmp6;
  struct l_struct_2E_b2World *llvm_cbe_tmp7;
  unsigned char llvm_cbe_tmp9;
  unsigned short *llvm_cbe_tmp2_2e_i;
  unsigned short llvm_cbe_tmp3_2e_i;
  float llvm_cbe_tmp1_2e_i20;
  float llvm_cbe_tmp3_2e_i22;
  float llvm_cbe_tmp35;
  float llvm_cbe_tmp38;
  struct l_struct_2E_b2XForm *llvm_cbe_tmp52;
  unsigned long long llvm_cbe_tmp53;
  float llvm_cbe_tmp6031;
  llvmBitCastUnion llvm_cbe_tmp6031__BITCAST_TEMPORARY;
  float llvm_cbe_tmp6335;
  llvmBitCastUnion llvm_cbe_tmp6335__BITCAST_TEMPORARY;
  struct l_struct_2E_b2Shape **llvm_cbe_tmp94;
  unsigned char llvm_cbe_tmp107;
  struct l_struct_2E_b2Shape **llvm_cbe_tmp115;
  struct l_struct_2E_b2Shape **llvm_cbe_storemerge_2e_in;
  struct l_struct_2E_b2Shape **llvm_cbe_storemerge_2e_in__PHI_TEMPORARY;
  struct l_struct_2E_b2Shape *llvm_cbe_storemerge;
  struct l_struct_2E_b2World *llvm_cbe_tmp158;
  struct l_struct_2E_b2BroadPhase *llvm_cbe_tmp160;
  unsigned short llvm_cbe_tmp128;
  unsigned short *llvm_cbe_tmp1_2e_i11;
  unsigned short llvm_cbe_tmp2_2e_i12;
  struct l_struct_2E_b2World *llvm_cbe_tmp142;
  struct l_struct_2E_b2BroadPhase *llvm_cbe_tmp144;
  struct l_struct_2E_b2Shape **llvm_cbe_tmp147;
  struct l_struct_2E_b2Shape **llvm_cbe_storemerge1_2e_in;
  struct l_struct_2E_b2Shape **llvm_cbe_storemerge1_2e_in__PHI_TEMPORARY;
  struct l_struct_2E_b2Shape *llvm_cbe_storemerge1;

  llvm_cbe_tmp6 = (&llvm_cbe_this->field8);
  llvm_cbe_tmp7 = *llvm_cbe_tmp6;
  llvm_cbe_tmp9 = *((&llvm_cbe_tmp7->field2));
  if ((llvm_cbe_tmp9 == ((unsigned char )0))) {
    goto llvm_cbe_bb21;
  } else {
    goto llvm_cbe_bb;
  }

llvm_cbe_bb:
  __assert_fail(((&_2E_str146[((signed long long )0ull)])), ((&_2E_str1147[((signed long long )0ull)])), 314u, ((&_ZZN6b2Body8SetXFormERK6b2Vec2fE19__PRETTY_FUNCTION__[((signed long long )0ull)])));
  /*UNREACHABLE*/;
llvm_cbe_bb21:
  llvm_cbe_tmp2_2e_i = (&llvm_cbe_this->field0);
  llvm_cbe_tmp3_2e_i = *llvm_cbe_tmp2_2e_i;
  if ((((((unsigned int )(unsigned short )llvm_cbe_tmp3_2e_i)) & 2u) == 0u)) {
    goto llvm_cbe_bb27;
  } else {
    goto llvm_cbe_return;
  }

llvm_cbe_bb27:
  llvm_cbe_tmp1_2e_i20 = cosf(llvm_cbe_angle);
  llvm_cbe_tmp3_2e_i22 = sinf(llvm_cbe_angle);
  *((&llvm_cbe_this->field2.field1.field0.field0)) = llvm_cbe_tmp1_2e_i20;
  *((&llvm_cbe_this->field2.field1.field1.field0)) = (((float )(-(llvm_cbe_tmp3_2e_i22))));
  *((&llvm_cbe_this->field2.field1.field0.field1)) = llvm_cbe_tmp3_2e_i22;
  *((&llvm_cbe_this->field2.field1.field1.field1)) = llvm_cbe_tmp1_2e_i20;
  llvm_cbe_tmp35 = *((&llvm_cbe_position->field0));
  llvm_cbe_tmp38 = *((&llvm_cbe_position->field1));
  *((&llvm_cbe_this->field2.field0.field0)) = llvm_cbe_tmp35;
  *((&llvm_cbe_this->field2.field0.field1)) = llvm_cbe_tmp38;
  llvm_cbe_tmp52 = (&llvm_cbe_this->field2);
  llvm_cbe_tmp53 = _Z5b2MulRK7b2XFormRK6b2Vec2(llvm_cbe_tmp52, ((&llvm_cbe_this->field3.field0)));
  llvm_cbe_tmp6031 = (llvm_cbe_tmp6031__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp53)), llvm_cbe_tmp6031__BITCAST_TEMPORARY.Float);
  *((&llvm_cbe_this->field3.field2.field0)) = llvm_cbe_tmp6031;
  llvm_cbe_tmp6335 = (llvm_cbe_tmp6335__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp53) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp6335__BITCAST_TEMPORARY.Float);
  *((&llvm_cbe_this->field3.field2.field1)) = llvm_cbe_tmp6335;
  *((&llvm_cbe_this->field3.field1.field0)) = llvm_cbe_tmp6031;
  *((&llvm_cbe_this->field3.field1.field1)) = llvm_cbe_tmp6335;
  *((&llvm_cbe_this->field3.field4)) = llvm_cbe_angle;
  *((&llvm_cbe_this->field3.field3)) = llvm_cbe_angle;
  llvm_cbe_tmp94 = (&llvm_cbe_this->field11);
  llvm_cbe_storemerge_2e_in__PHI_TEMPORARY = llvm_cbe_tmp94;   /* for PHI node */
  goto llvm_cbe_bb117;

  do {     /* Syntactic loop 'bb117' to make GCC happy */
llvm_cbe_bb117:
  llvm_cbe_storemerge_2e_in = llvm_cbe_storemerge_2e_in__PHI_TEMPORARY;
  llvm_cbe_storemerge = *llvm_cbe_storemerge_2e_in;
  llvm_cbe_tmp158 = *llvm_cbe_tmp6;
  llvm_cbe_tmp160 = *((&llvm_cbe_tmp158->field3));
  if ((llvm_cbe_storemerge == ((struct l_struct_2E_b2Shape *)/*NULL*/0))) {
    goto llvm_cbe_bb155;
  } else {
    goto llvm_cbe_bb96;
  }

llvm_cbe_bb113:
  llvm_cbe_tmp115 = (&llvm_cbe_storemerge->field2);
  llvm_cbe_storemerge_2e_in__PHI_TEMPORARY = llvm_cbe_tmp115;   /* for PHI node */
  goto llvm_cbe_bb117;

llvm_cbe_bb96:
  llvm_cbe_tmp107 = _ZN7b2Shape11SynchronizeEP12b2BroadPhaseRK7b2XFormS4_(llvm_cbe_storemerge, llvm_cbe_tmp160, llvm_cbe_tmp52, llvm_cbe_tmp52);
  if ((llvm_cbe_tmp107 == ((unsigned char )0))) {
    goto llvm_cbe_bb125;
  } else {
    goto llvm_cbe_bb113;
  }

  } while (1); /* end of syntactic loop 'bb117' */
llvm_cbe_bb125:
  llvm_cbe_tmp128 = *llvm_cbe_tmp2_2e_i;
  *llvm_cbe_tmp2_2e_i = (((unsigned short )(llvm_cbe_tmp128 | ((unsigned short )2))));
  *((&llvm_cbe_this->field4.field0)) = 0x0p+0;
  *((&llvm_cbe_this->field4.field1)) = 0x0p+0;
  *((&llvm_cbe_this->field5)) = 0x0p+0;
  llvm_cbe_storemerge1_2e_in__PHI_TEMPORARY = llvm_cbe_tmp94;   /* for PHI node */
  goto llvm_cbe_bb149;

  do {     /* Syntactic loop 'bb149' to make GCC happy */
llvm_cbe_bb149:
  llvm_cbe_storemerge1_2e_in = llvm_cbe_storemerge1_2e_in__PHI_TEMPORARY;
  llvm_cbe_storemerge1 = *llvm_cbe_storemerge1_2e_in;
  if ((llvm_cbe_storemerge1 == ((struct l_struct_2E_b2Shape *)/*NULL*/0))) {
    goto llvm_cbe_return;
  } else {
    goto llvm_cbe_bb139;
  }

llvm_cbe__ZN7b2Shape12DestroyProxyEP12b2BroadPhase_2e_exit:
  llvm_cbe_tmp147 = (&llvm_cbe_storemerge1->field2);
  llvm_cbe_storemerge1_2e_in__PHI_TEMPORARY = llvm_cbe_tmp147;   /* for PHI node */
  goto llvm_cbe_bb149;

llvm_cbe_bb139:
  llvm_cbe_tmp1_2e_i11 = (&llvm_cbe_storemerge1->field8);
  llvm_cbe_tmp2_2e_i12 = *llvm_cbe_tmp1_2e_i11;
  if ((llvm_cbe_tmp2_2e_i12 == ((unsigned short )-1))) {
    goto llvm_cbe__ZN7b2Shape12DestroyProxyEP12b2BroadPhase_2e_exit;
  } else {
    goto llvm_cbe_bb_2e_i;
  }

llvm_cbe_bb_2e_i:
  llvm_cbe_tmp142 = *llvm_cbe_tmp6;
  llvm_cbe_tmp144 = *((&llvm_cbe_tmp142->field3));
  _ZN12b2BroadPhase12DestroyProxyEi(llvm_cbe_tmp144, (((unsigned int )(unsigned short )llvm_cbe_tmp2_2e_i12)));
  *llvm_cbe_tmp1_2e_i11 = ((unsigned short )-1);
  goto llvm_cbe__ZN7b2Shape12DestroyProxyEP12b2BroadPhase_2e_exit;

  } while (1); /* end of syntactic loop 'bb149' */
llvm_cbe_bb155:
  _ZN13b2PairManager6CommitEv(((&llvm_cbe_tmp160->field0)));
  return;
llvm_cbe_return:
  return;
}


static unsigned char _ZN6Stroke9transformEv(struct l_struct_2E_Stroke *llvm_cbe_this) {
  struct l_struct_2E_Vec2 llvm_cbe_n_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2AABB llvm_cbe_rot;    /* Address-exposed local */
  struct l_struct_2E_Vec2 llvm_cbe_o;    /* Address-exposed local */
  struct l_struct_2E_Rect llvm_cbe_tmp;    /* Address-exposed local */
  struct l_struct_2E_Rect llvm_cbe_tmp1;    /* Address-exposed local */
  struct l_struct_2E_Vec2 llvm_cbe_tmp3;    /* Address-exposed local */
  struct l_struct_2E_Rect llvm_cbe_tmp6;    /* Address-exposed local */
  unsigned int *llvm_cbe_tmp8;
  unsigned int llvm_cbe_tmp9;
  struct l_struct_2E_Path *llvm_cbe_tmp22;
  unsigned int llvm_cbe_tmp3_2e_i;
  unsigned int llvm_cbe_tmp7_2e_i;
  struct l_struct_2E_Path *llvm_cbe_tmp10_2e_i;
  struct l_struct_2E_Path *llvm_cbe_tmp3_2e_i15;
  unsigned int llvm_cbe_tmp38;
  unsigned int llvm_cbe_tmp41;
  unsigned int llvm_cbe_tmp46;
  unsigned int llvm_cbe_tmp49;
  unsigned int llvm_cbe_tmp52;
  struct l_struct_2E_b2Body **llvm_cbe_tmp59;
  struct l_struct_2E_b2Body *llvm_cbe_tmp60;
  unsigned int llvm_cbe_tmp3_2e_i27;
  float llvm_cbe_tmp79;
  float llvm_cbe_tmp4_2e_i45;
  float *llvm_cbe_tmp96;
  float llvm_cbe_tmp97;
  float *llvm_cbe_tmp3_2e_i70;
  float llvm_cbe_tmp4_2e_i71;
  float llvm_cbe_tmp3_2e_i89;
  float llvm_cbe_tmp6_2e_i92;
  float llvm_cbe_tmp11_2e_i96;
  float llvm_cbe_tmp14_2e_i99;
  float llvm_cbe_tmp4_2e_i154;
  float llvm_cbe_tmp5_2e_i136;
  float llvm_cbe_tmp7_2e_i138;
  float llvm_cbe_tmp3_2e_i107;
  float llvm_cbe_tmp8_2e_i112;
  llvmBitCastUnion llvm_cbe_tmp19_2e_i167__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i174__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp22_2e_i174175176_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp25_2e_i166__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp28_2e_i172__BITCAST_TEMPORARY;
  struct l_struct_2E_Path *llvm_cbe_tmp142;
  struct l_struct_2E_Path *llvm_cbe_tmp149;
  struct l_struct_2E_b2Body *llvm_cbe_tmp152;
  float llvm_cbe_tmp4_2e_i67;
  float llvm_cbe_tmp162;
  float llvm_cbe_tmp165;
  struct l_struct_2E_Path *llvm_cbe_tmp175;
  unsigned char llvm_cbe_tmp5_2e_i52;
  struct l_struct_2E_Path *llvm_cbe_tmp15_2e_i60;
  unsigned int llvm_cbe_tmp186;
  unsigned int llvm_cbe_tmp189;
  unsigned int llvm_cbe_tmp194;
  unsigned int llvm_cbe_tmp197;
  struct l_struct_2E_Path *llvm_cbe_tmp203;
  struct l_struct_2E_Path *llvm_cbe_tmp209;
  struct l_struct_2E_Path *llvm_cbe_tmp211;
  unsigned char llvm_cbe_tmp5_2e_i20;
  struct l_struct_2E_Path *llvm_cbe_tmp15_2e_i;
  unsigned int llvm_cbe_tmp222;
  unsigned int llvm_cbe_tmp225;
  unsigned int llvm_cbe_tmp230;
  unsigned int llvm_cbe_tmp233;
  unsigned char llvm_cbe_tmp5_2e_0;
  unsigned char llvm_cbe_tmp5_2e_0__PHI_TEMPORARY;

  llvm_cbe_tmp8 = (&llvm_cbe_this->field14);
  llvm_cbe_tmp9 = *llvm_cbe_tmp8;
  if ((llvm_cbe_tmp9 == 0u)) {
    goto llvm_cbe_bb57;
  } else {
    goto llvm_cbe_bb;
  }

llvm_cbe_bb:
  if ((((signed int )llvm_cbe_tmp9) < ((signed int )80u))) {
    goto llvm_cbe_bb18;
  } else {
    llvm_cbe_tmp5_2e_0__PHI_TEMPORARY = ((unsigned char )1);   /* for PHI node */
    goto llvm_cbe_return;
  }

llvm_cbe_bb18:
  llvm_cbe_o = _ZNK4Rect8centroidEv(((&llvm_cbe_this->field9)));
  llvm_cbe_tmp22 = (&llvm_cbe_this->field6);
  llvm_cbe_tmp3_2e_i = *((&llvm_cbe_o.field1));
  llvm_cbe_tmp7_2e_i = *((&llvm_cbe_o.field0));
  *((&llvm_cbe_n_2e_i.field0)) = (-(llvm_cbe_tmp7_2e_i));
  *((&llvm_cbe_n_2e_i.field1)) = (-(llvm_cbe_tmp3_2e_i));
  llvm_cbe_tmp10_2e_i = _ZN4Path9translateERK4Vec2(llvm_cbe_tmp22, (&llvm_cbe_n_2e_i));
  _ZN4Path5scaleEf(llvm_cbe_tmp22, 0x1.fae148p-1);
  llvm_cbe_tmp3_2e_i15 = _ZN4Path9translateERK4Vec2(llvm_cbe_tmp22, (&llvm_cbe_o));
  llvm_cbe_tmp6 = _ZNK4Path4bboxEv(llvm_cbe_tmp22);
  llvm_cbe_tmp38 = *((&llvm_cbe_tmp6.field0.field0));
  *((&llvm_cbe_this->field9.field0.field0)) = llvm_cbe_tmp38;
  llvm_cbe_tmp41 = *((&llvm_cbe_tmp6.field0.field1));
  *((&llvm_cbe_this->field9.field0.field1)) = llvm_cbe_tmp41;
  llvm_cbe_tmp46 = *((&llvm_cbe_tmp6.field1.field0));
  *((&llvm_cbe_this->field9.field1.field0)) = llvm_cbe_tmp46;
  llvm_cbe_tmp49 = *((&llvm_cbe_tmp6.field1.field1));
  *((&llvm_cbe_this->field9.field1.field1)) = llvm_cbe_tmp49;
  llvm_cbe_tmp52 = *llvm_cbe_tmp8;
  *llvm_cbe_tmp8 = (llvm_cbe_tmp52 + 1u);
  return ((unsigned char )1);
llvm_cbe_bb57:
  llvm_cbe_tmp59 = (&llvm_cbe_this->field12);
  llvm_cbe_tmp60 = *llvm_cbe_tmp59;
  if ((llvm_cbe_tmp60 == ((struct l_struct_2E_b2Body *)/*NULL*/0))) {
    goto llvm_cbe_bb199;
  } else {
    goto llvm_cbe_bb64;
  }

llvm_cbe_bb64:
  llvm_cbe_tmp3_2e_i27 = *((&llvm_cbe_this->field2));
  if (((llvm_cbe_tmp3_2e_i27 & 8u) == 0u)) {
    goto llvm_cbe_bb70;
  } else {
    llvm_cbe_tmp5_2e_0__PHI_TEMPORARY = ((unsigned char )0);   /* for PHI node */
    goto llvm_cbe_return;
  }

llvm_cbe_bb70:
  if (((llvm_cbe_tmp3_2e_i27 & 1u) == 0u)) {
    goto llvm_cbe_bb94;
  } else {
    goto llvm_cbe_bb76;
  }

llvm_cbe_bb76:
  llvm_cbe_tmp79 = *((&llvm_cbe_this->field7));
  llvm_cbe_tmp4_2e_i45 = *((&llvm_cbe_tmp60->field3.field4));
  if ((llvm_fcmp_une(llvm_cbe_tmp79, llvm_cbe_tmp4_2e_i45))) {
    goto llvm_cbe_bb94;
  } else {
    llvm_cbe_tmp5_2e_0__PHI_TEMPORARY = ((unsigned char )0);   /* for PHI node */
    goto llvm_cbe_return;
  }

llvm_cbe_bb94:
  llvm_cbe_tmp96 = (&llvm_cbe_this->field7);
  llvm_cbe_tmp97 = *llvm_cbe_tmp96;
  llvm_cbe_tmp3_2e_i70 = (&llvm_cbe_tmp60->field3.field4);
  llvm_cbe_tmp4_2e_i71 = *llvm_cbe_tmp3_2e_i70;
  if ((llvm_fcmp_une(llvm_cbe_tmp97, llvm_cbe_tmp4_2e_i71))) {
    goto llvm_cbe_bb122;
  } else {
    goto llvm_cbe_bb105;
  }

llvm_cbe_bb105:
  llvm_cbe_tmp3_2e_i89 = *((&llvm_cbe_this->field8.field0));
  llvm_cbe_tmp6_2e_i92 = *((&llvm_cbe_tmp60->field2.field0.field0));
  if ((llvm_fcmp_une(llvm_cbe_tmp3_2e_i89, llvm_cbe_tmp6_2e_i92))) {
    goto llvm_cbe_bb122;
  } else {
    goto llvm_cbe_bb_2e_i101;
  }

llvm_cbe_bb_2e_i101:
  llvm_cbe_tmp11_2e_i96 = *((&llvm_cbe_this->field8.field1));
  llvm_cbe_tmp14_2e_i99 = *((&llvm_cbe_tmp60->field2.field0.field1));
  if ((llvm_fcmp_une(llvm_cbe_tmp11_2e_i96, llvm_cbe_tmp14_2e_i99))) {
    goto llvm_cbe_bb122;
  } else {
    llvm_cbe_tmp5_2e_0__PHI_TEMPORARY = ((unsigned char )0);   /* for PHI node */
    goto llvm_cbe_return;
  }

llvm_cbe_bb122:
  llvm_cbe_tmp4_2e_i154 = *llvm_cbe_tmp3_2e_i70;
  llvm_cbe_tmp5_2e_i136 = cosf(llvm_cbe_tmp4_2e_i154);
  llvm_cbe_tmp7_2e_i138 = sinf(llvm_cbe_tmp4_2e_i154);
  *((&llvm_cbe_rot.field0.field0)) = llvm_cbe_tmp5_2e_i136;
  *((&llvm_cbe_rot.field1.field0)) = (((float )(-(llvm_cbe_tmp7_2e_i138))));
  *((&llvm_cbe_rot.field0.field1)) = llvm_cbe_tmp7_2e_i138;
  *((&llvm_cbe_rot.field1.field1)) = llvm_cbe_tmp5_2e_i136;
  llvm_cbe_tmp3_2e_i107 = *((&llvm_cbe_tmp60->field2.field0.field1));
  llvm_cbe_tmp8_2e_i112 = *((&llvm_cbe_tmp60->field2.field0.field0));
  llvm_cbe_tmp22_2e_i174175176_2e_ins = (((unsigned long long )(unsigned int )((llvm_cbe_tmp19_2e_i167__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp8_2e_i112 * 0x1.4p+3))), llvm_cbe_tmp19_2e_i167__BITCAST_TEMPORARY.Int32)))) | ((((unsigned long long )(unsigned int )((llvm_cbe_tmp22_2e_i174__BITCAST_TEMPORARY.Float = (((float )(llvm_cbe_tmp3_2e_i107 * 0x1.4p+3))), llvm_cbe_tmp22_2e_i174__BITCAST_TEMPORARY.Int32)))) << 32ull);
  llvm_cbe_tmp142 = (&llvm_cbe_this->field5);
  _ZN4PathaSERKS_(llvm_cbe_tmp142, ((&llvm_cbe_this->field0)));
  _ZN4Path6rotateERK7b2Mat22(llvm_cbe_tmp142, (&llvm_cbe_rot));
  *((&llvm_cbe_tmp3.field0)) = (((signed int )((llvm_cbe_tmp25_2e_i166__BITCAST_TEMPORARY.Int32 = (((unsigned int )llvm_cbe_tmp22_2e_i174175176_2e_ins)), llvm_cbe_tmp25_2e_i166__BITCAST_TEMPORARY.Float))));
  *((&llvm_cbe_tmp3.field1)) = (((signed int )((llvm_cbe_tmp28_2e_i172__BITCAST_TEMPORARY.Int32 = (((unsigned int )(((unsigned long long )(((unsigned long long )llvm_cbe_tmp22_2e_i174175176_2e_ins) >> ((unsigned long long )32ull)))))), llvm_cbe_tmp28_2e_i172__BITCAST_TEMPORARY.Float))));
  llvm_cbe_tmp149 = _ZN4Path9translateERK4Vec2(llvm_cbe_tmp142, (&llvm_cbe_tmp3));
  llvm_cbe_tmp152 = *llvm_cbe_tmp59;
  llvm_cbe_tmp4_2e_i67 = *((&llvm_cbe_tmp152->field3.field4));
  *llvm_cbe_tmp96 = llvm_cbe_tmp4_2e_i67;
  llvm_cbe_tmp162 = *((&llvm_cbe_tmp152->field2.field0.field0));
  llvm_cbe_tmp165 = *((&llvm_cbe_tmp152->field2.field0.field1));
  *((&llvm_cbe_this->field8.field0)) = llvm_cbe_tmp162;
  *((&llvm_cbe_this->field8.field1)) = llvm_cbe_tmp165;
  llvm_cbe_tmp175 = (&llvm_cbe_this->field6);
  _ZN4PathaSERKS_(llvm_cbe_tmp175, llvm_cbe_tmp142);
  llvm_cbe_tmp5_2e_i52 = *((&worldToScreen.field0));
  if ((llvm_cbe_tmp5_2e_i52 == ((unsigned char )0))) {
    goto llvm_cbe_bb_2e_i61;
  } else {
    goto llvm_cbe__ZN9Transform9transformERK4PathRS0__2e_exit62;
  }

llvm_cbe_bb_2e_i61:
  _ZN4Path6rotateERK7b2Mat22(llvm_cbe_tmp175, ((&worldToScreen.field1)));
  llvm_cbe_tmp15_2e_i60 = _ZN4Path9translateERK4Vec2(llvm_cbe_tmp175, ((&worldToScreen.field3)));
  goto llvm_cbe__ZN9Transform9transformERK4PathRS0__2e_exit62;

llvm_cbe__ZN9Transform9transformERK4PathRS0__2e_exit62:
  llvm_cbe_tmp1 = _ZNK4Path4bboxEv(llvm_cbe_tmp175);
  llvm_cbe_tmp186 = *((&llvm_cbe_tmp1.field0.field0));
  *((&llvm_cbe_this->field9.field0.field0)) = llvm_cbe_tmp186;
  llvm_cbe_tmp189 = *((&llvm_cbe_tmp1.field0.field1));
  *((&llvm_cbe_this->field9.field0.field1)) = llvm_cbe_tmp189;
  llvm_cbe_tmp194 = *((&llvm_cbe_tmp1.field1.field0));
  *((&llvm_cbe_this->field9.field1.field0)) = llvm_cbe_tmp194;
  llvm_cbe_tmp197 = *((&llvm_cbe_tmp1.field1.field1));
  *((&llvm_cbe_this->field9.field1.field1)) = llvm_cbe_tmp197;
  return ((unsigned char )1);
llvm_cbe_bb199:
  llvm_cbe_tmp203 = (&llvm_cbe_this->field5);
  _ZN4PathaSERKS_(llvm_cbe_tmp203, ((&llvm_cbe_this->field0)));
  llvm_cbe_tmp209 = _ZN4Path9translateERK4Vec2(llvm_cbe_tmp203, ((&llvm_cbe_this->field3)));
  llvm_cbe_tmp211 = (&llvm_cbe_this->field6);
  _ZN4PathaSERKS_(llvm_cbe_tmp211, llvm_cbe_tmp203);
  llvm_cbe_tmp5_2e_i20 = *((&worldToScreen.field0));
  if ((llvm_cbe_tmp5_2e_i20 == ((unsigned char )0))) {
    goto llvm_cbe_bb_2e_i;
  } else {
    goto llvm_cbe__ZN9Transform9transformERK4PathRS0__2e_exit;
  }

llvm_cbe_bb_2e_i:
  _ZN4Path6rotateERK7b2Mat22(llvm_cbe_tmp211, ((&worldToScreen.field1)));
  llvm_cbe_tmp15_2e_i = _ZN4Path9translateERK4Vec2(llvm_cbe_tmp211, ((&worldToScreen.field3)));
  goto llvm_cbe__ZN9Transform9transformERK4PathRS0__2e_exit;

llvm_cbe__ZN9Transform9transformERK4PathRS0__2e_exit:
  llvm_cbe_tmp = _ZNK4Path4bboxEv(llvm_cbe_tmp211);
  llvm_cbe_tmp222 = *((&llvm_cbe_tmp.field0.field0));
  *((&llvm_cbe_this->field9.field0.field0)) = llvm_cbe_tmp222;
  llvm_cbe_tmp225 = *((&llvm_cbe_tmp.field0.field1));
  *((&llvm_cbe_this->field9.field0.field1)) = llvm_cbe_tmp225;
  llvm_cbe_tmp230 = *((&llvm_cbe_tmp.field1.field0));
  *((&llvm_cbe_this->field9.field1.field0)) = llvm_cbe_tmp230;
  llvm_cbe_tmp233 = *((&llvm_cbe_tmp.field1.field1));
  *((&llvm_cbe_this->field9.field1.field1)) = llvm_cbe_tmp233;
  return ((unsigned char )0);
llvm_cbe_return:
  llvm_cbe_tmp5_2e_0 = llvm_cbe_tmp5_2e_0__PHI_TEMPORARY;
  return llvm_cbe_tmp5_2e_0;
}


static void _ZN6Stroke12createBodiesER7b2World(struct l_struct_2E_Stroke *llvm_cbe_this, struct l_struct_2E_b2World *llvm_cbe_world) {
  struct l_struct_2E_b2Vec2 llvm_cbe_v_addr_2e_i_2e_i132;    /* Address-exposed local */
  struct l_struct_2E_b2XForm llvm_cbe_xf_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_bar_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2AABB llvm_cbe_aabb_2e_i_2e_i56;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_center_2e_i_2e_i_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_r_2e_i_2e_i_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_upper_2e_i_2e_i_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_lower_2e_i_2e_i_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_p_2e_i_2e_i_2e_i_2e_i[9];    /* Address-exposed local */
  struct l_struct_2E_b2AABB llvm_cbe_A_2e_i_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2Vec2 llvm_cbe_d_2e_i_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2AABB llvm_cbe_aabb_2e_i_2e_i;    /* Address-exposed local */
  struct l_struct_2E_b2MassData llvm_cbe_massData_2e_i;    /* Address-exposed local */
  unsigned int  (**llvm_cbe_boxDef456[14]) ();    /* Address-exposed local */
  struct l_struct_2E_Stroke_3A__3A_BoxDef *llvm_cbe_tmpcast455;
  struct l_struct_2E_b2BodyDef llvm_cbe_bodyDef;    /* Address-exposed local */
  struct l_struct_2E_Path *llvm_cbe_tmp1_2e_i;
  struct l_struct_2E_Path *llvm_cbe_tmp6_2e_i;
  unsigned int *llvm_cbe_tmp2_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp9_2e_i;
  float llvm_cbe_thresh_2e_i_2e_0;
  float llvm_cbe_thresh_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp3_2e_i_2e_i_2e_i;
  unsigned int *llvm_cbe_tmp2_2e_i13;
  unsigned int llvm_cbe_tmp3_2e_i14;
  float *llvm_cbe_tmp1_2e_i1_2e_i;
  float *llvm_cbe_tmp4_2e_i_2e_i438;
  unsigned char *llvm_cbe_tmp26_2e_i449;
  unsigned int llvm_cbe_tmp4_2e_i390;
  unsigned int llvm_cbe_tmp8_2e_i394;
  llvmBitCastUnion llvm_cbe_tmp18_2e_i409977__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp21_2e_i412984__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp21_2e_i412984985986_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp24_2e_i415976__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp27_2e_i418982__BITCAST_TEMPORARY;
  float llvm_cbe_tmp2_2e_i371;
  float llvm_cbe_tmp9_2e_i378;
  struct l_struct_2E_b2Body *llvm_cbe_tmp39;
  struct l_struct_2E_b2Body **llvm_cbe_tmp41;
  struct l_struct_2E_b2ShapeDef *llvm_cbe_tmp45_2e_i_2e_i323;
  unsigned int *llvm_cbe_tmp4_2e_i_2e_i_2e_i326;
  unsigned char **llvm_cbe_tmp6_2e_i_2e_i_2e_i328;
  float *llvm_cbe_tmp8_2e_i_2e_i_2e_i330;
  float *llvm_cbe_tmp10_2e_i_2e_i_2e_i332;
  float *llvm_cbe_tmp12_2e_i_2e_i_2e_i334;
  unsigned short *llvm_cbe_tmp15_2e_i_2e_i_2e_i336;
  unsigned short *llvm_cbe_tmp18_2e_i_2e_i_2e_i338;
  unsigned short *llvm_cbe_tmp21_2e_i_2e_i_2e_i340;
  unsigned char *llvm_cbe_tmp23_2e_i_2e_i_2e_i342;
  unsigned int  (***llvm_cbe_tmp10_2e_i_2e_i344) ();
  unsigned int *llvm_cbe_tmp29_2e_i_2e_i356;
  unsigned int *llvm_cbe_tmp31_2e_i_2e_i358;
  unsigned int  (***llvm_cbe_tmp7_2e_i360) ();
  struct l_struct_2E_Vec2 **llvm_cbe_tmp2_2e_i_2e_i310;
  float *llvm_cbe_tmp20_2e_i195;
  float *llvm_cbe_tmp23_2e_i198;
  unsigned int *llvm_cbe_tmp28_2e_i202;
  unsigned int *llvm_cbe_tmp30_2e_i204;
  unsigned int *llvm_cbe_tmp2_2e_i168_2e_i;
  unsigned int *llvm_cbe_tmp3_2e_i169_2e_i;
  float *llvm_cbe_tmp5_2e_i170_2e_i;
  float *llvm_cbe_tmp7_2e_i172_2e_i;
  unsigned int *llvm_cbe_tmp1_2e_i_2e_i44_2e_i;
  float *llvm_cbe_tmp1_2e_i_2e_i_2e_i_2e_i230;
  float *llvm_cbe_tmp4_2e_i_2e_i_2e_i_2e_i233;
  float *llvm_cbe_tmp1_2e_i23_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp4_2e_i26_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp1_2e_i14_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp4_2e_i17_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp1_2e_i5_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp4_2e_i8_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp13_2e_i54_2e_i250;
  float *llvm_cbe_tmp16_2e_i57_2e_i253;
  float *llvm_cbe_tmp6_2e_i39_2e_i_2e_i;
  float *llvm_cbe_tmp12_2e_i_2e_i_2e_i256;
  float *llvm_cbe_tmp15_2e_i44_2e_i_2e_i;
  float *llvm_cbe_tmp19_2e_i46_2e_i_2e_i;
  struct l_struct_2E_b2ShapeDef *llvm_cbe_tmp5556_2e_i;
  float *llvm_cbe_tmp57_2e_i269;
  float *llvm_cbe_tmp101_2e_i284;
  float *llvm_cbe_tmp107_2e_i286;
  struct l_struct_2E_b2CircleDef *llvm_cbe_tmp1920_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp27_2e_i69_2e_i_2e_i;
  float *llvm_cbe_tmp30_2e_i71_2e_i_2e_i;
  float *llvm_cbe_tmp41_2e_i79_2e_i_2e_i;
  struct l_struct_2E_b2PolygonDef *llvm_cbe_tmp9798_2e_i_2e_i_2e_i;
  unsigned int *llvm_cbe_tmp100_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2Vec2 *llvm_cbe_tmp234_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp74_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp77_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp1_2e_i421_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp4_2e_i424_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp1_2e_i412_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp4_2e_i415_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp143_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp145_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp218_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp221_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp321_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp324_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp348_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp352_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp356_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp360_2e_i_2e_i_2e_i;
  unsigned int  (***llvm_cbe_tmp2_2e_i_2e_i_2e_i51) ();
  unsigned long long llvm_cbe_tmp_2e_i_2e_i319_2e_0;
  unsigned long long llvm_cbe_tmp_2e_i_2e_i319_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp19_2e_i_2e_i351;
  unsigned int llvm_cbe_tmp45;
  struct l_struct_2E_Vec2 *llvm_cbe_tmp3_2e_i_2e_i311;
  unsigned long long llvm_cbe_tmp45_2e_i_2e_i313;
  unsigned long long llvm_cbe_tmp45_2e_i_2e_i298;
  unsigned int llvm_cbe_tmp4_2e_i_2e_i158;
  unsigned int llvm_cbe_tmp8_2e_i_2e_i162;
  llvmBitCastUnion llvm_cbe_tmp18_2e_i_2e_i177914__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp21_2e_i_2e_i180921__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp21_2e_i_2e_i180921922923_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp12_2e_i189884__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp15_2e_i192888__BITCAST_TEMPORARY;
  unsigned int llvm_cbe_tmp5_2e_i255_2e_i;
  unsigned int llvm_cbe_tmp12_2e_i262_2e_i;
  llvmBitCastUnion llvm_cbe_tmp18_2e_i237_2e_i963__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp21_2e_i240_2e_i970__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp21_2e_i240_2e_i970971972_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i197891__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp25_2e_i200895__BITCAST_TEMPORARY;
  float llvm_cbe_tmp11_2e_i204_2e_i;
  unsigned int llvm_cbe_tmp29_2e_i203;
  unsigned int llvm_cbe_tmp31_2e_i205;
  float llvm_cbe_tmp6_2e_i171_2e_i;
  float llvm_cbe_tmp8_2e_i173_2e_i;
  float llvm_cbe_tmp9_2e_i174_2e_i;
  float llvm_cbe_tmp8_2e_i139_2e_i;
  llvmBitCastUnion llvm_cbe_tmp19_2e_i156_2e_i949__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i159_2e_i956__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp22_2e_i159_2e_i956957958_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp37_2e_i209898__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp40_2e_i212902__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i117_2e_i935__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i120_2e_i942__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i120_2e_i942943944_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp45_2e_i219905__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp48_2e_i222909__BITCAST_TEMPORARY;
  float llvm_cbe_tmp16_2e_i83_2e_i;
  float llvm_cbe_tmp50_2e_i223;
  float llvm_cbe_tmp5_2e_i_2e_i48_2e_i;
  float llvm_cbe_tmp1_2e_i35_2e_i_2e_i;
  float llvm_cbe_tmp3_2e_i37_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp2225_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp27_2e_i65_2e_i;
  llvmBitCastUnion llvm_cbe_tmp35_2e_i_2e_i926__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp38_2e_i_2e_i260930__BITCAST_TEMPORARY;
  unsigned int llvm_cbe_tmp40_2e_i_2e_i262;
  unsigned int llvm_cbe_storemerge_2e_i_2e_i264;
  unsigned int llvm_cbe_storemerge_2e_i_2e_i264__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp44_2e_i_2e_i;
  struct l_struct_2E_b2Body *llvm_cbe_tmp59;
  struct l_struct_2E_b2World **llvm_cbe_tmp2_2e_i67;
  struct l_struct_2E_b2World *llvm_cbe_tmp3_2e_i68;
  unsigned char llvm_cbe_tmp5_2e_i70;
  struct l_struct_2E_b2BlockAllocator *llvm_cbe_tmp21_2e_i;
  unsigned int llvm_cbe_tmp6_2e_i_2e_i82;
  unsigned char *llvm_cbe_tmp8_2e_i_2e_i84;
  struct l_struct_2E_b2CircleShape *llvm_cbe_tmp1011_2e_i_2e_i;
  unsigned char *llvm_cbe_tmp5_2e_i_2e_i15_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i_2e_i20_2e_i_2e_i;
  float llvm_cbe_tmp15_2e_i_2e_i25_2e_i_2e_i;
  float llvm_cbe_tmp20_2e_i_2e_i30_2e_i_2e_i;
  unsigned short llvm_cbe_tmp37_2e_i_2e_i45_2e_i_2e_i;
  unsigned short llvm_cbe_tmp40_2e_i_2e_i48_2e_i_2e_i;
  unsigned short llvm_cbe_tmp43_2e_i_2e_i51_2e_i_2e_i;
  unsigned char llvm_cbe_tmp46_2e_i_2e_i54_2e_i_2e_i;
  unsigned int llvm_cbe_tmp12_2e_i63_2e_i_2e_i;
  float llvm_cbe_tmp28_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp31_2e_i72_2e_i_2e_i;
  float llvm_cbe_tmp42_2e_i80_2e_i_2e_i;
  unsigned char *llvm_cbe_tmp33_2e_i_2e_i;
  struct l_struct_2E_b2PolygonShape *llvm_cbe_tmp3536_2e_i_2e_i;
  unsigned char *llvm_cbe_tmp5_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp15_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp20_2e_i_2e_i_2e_i_2e_i;
  unsigned short llvm_cbe_tmp37_2e_i_2e_i_2e_i_2e_i;
  unsigned short llvm_cbe_tmp40_2e_i_2e_i_2e_i_2e_i;
  unsigned short llvm_cbe_tmp43_2e_i_2e_i_2e_i_2e_i;
  unsigned char llvm_cbe_tmp46_2e_i_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp20_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_tmp20_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp42_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp17_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_tmp17_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp58_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp14_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_tmp14_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp75_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp85_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp101_2e_i_2e_i_2e_i;
  unsigned int *llvm_cbe_tmp103_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp124127_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp131_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp134_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp146_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge3_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge3_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp159_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_phitmp1435;
  unsigned long long llvm_cbe_storemerge4_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_storemerge4_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp172175_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp3_2e_i474_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp6_2e_i477_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i481_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp13_2e_i484_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i500_2e_i_2e_i_2e_i872__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i503_2e_i_2e_i_2e_i879__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i503_2e_i_2e_i_2e_i879880881_2e_ins;
  float llvm_cbe_tmp186_2e_i_2e_i_2e_i499;
  llvmBitCastUnion llvm_cbe_tmp186_2e_i_2e_i_2e_i499__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp189_2e_i_2e_i_2e_i501;
  float llvm_cbe_tmp189_2e_i_2e_i_2e_i503;
  llvmBitCastUnion llvm_cbe_tmp189_2e_i_2e_i_2e_i503__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i438_2e_i_2e_i_2e_i865__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp23_2e_i438_2e_i_2e_i_2e_i865866867_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp208_2e_i_2e_i_2e_i506__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp211_2e_i_2e_i_2e_i510__BITCAST_TEMPORARY;
  float llvm_cbe_tmp217_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_retval_2e_i467_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i467_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i405_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i405_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge5_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge5_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp223_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp231_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp2627_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp31_2e_i274_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp34_2e_i277_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp42_2e_i285_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2Vec2 *llvm_cbe_tmp52_2e_i291_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2Vec2 *llvm_cbe_storemerge_2e_i292_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2Vec2 *llvm_cbe_storemerge_2e_i292_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  float llvm_cbe_tmp60_2e_i295_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp63_2e_i298_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i278_2e_i_2e_i_2e_i_2e_i844__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i281_2e_i_2e_i_2e_i_2e_i851__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i281_2e_i_2e_i_2e_i_2e_i851852853_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp74_2e_i302_2e_i_2e_i_2e_i737__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp77_2e_i305_2e_i_2e_i_2e_i741__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i229_2e_i_2e_i_2e_i_2e_i830__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i232_2e_i_2e_i_2e_i_2e_i837__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i232_2e_i_2e_i_2e_i_2e_i837838839_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp82_2e_i307_2e_i_2e_i_2e_i744__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp85_2e_i310_2e_i_2e_i_2e_i748__BITCAST_TEMPORARY;
  float llvm_cbe_tmp88_2e_i312_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp91_2e_i_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i162_2e_i_2e_i_2e_i_2e_i816__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i165_2e_i_2e_i_2e_i_2e_i823__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i165_2e_i_2e_i_2e_i_2e_i823824825_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp96_2e_i316_2e_i_2e_i_2e_i751__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp99_2e_i319_2e_i_2e_i_2e_i755__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i118_2e_i_2e_i_2e_i_2e_i802__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i121_2e_i_2e_i_2e_i_2e_i809__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i121_2e_i_2e_i_2e_i_2e_i809810811_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp104_2e_i327_2e_i_2e_i_2e_i758__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp107_2e_i_2e_i_2e_i_2e_i762__BITCAST_TEMPORARY;
  float llvm_cbe_tmp109_2e_i329_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp19_2e_i_2e_i338_2e_i_2e_i_2e_i788__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp22_2e_i_2e_i341_2e_i_2e_i_2e_i795__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp22_2e_i_2e_i341_2e_i_2e_i_2e_i795796797_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp114_2e_i351_2e_i_2e_i_2e_i765__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp117_2e_i352_2e_i_2e_i_2e_i769__BITCAST_TEMPORARY;
  float llvm_cbe_tmp6_2e_i54_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp15_2e_i_2e_i354_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_retval_2e_i_2e_i238_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i_2e_i238_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i85_2e_i_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i85_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i129_2e_i_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i129_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i196_2e_i_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i196_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_retval_2e_i245_2e_i_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_retval_2e_i245_2e_i_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  float llvm_cbe_c_2e_i_2e_i_2e_i_2e_i_2e_0_2e_0;
  float llvm_cbe_c_2e_i_2e_i_2e_i_2e_i_2e_0_2e_0__PHI_TEMPORARY;
  float llvm_cbe_c_2e_i_2e_i_2e_i_2e_i_2e_1_2e_0;
  float llvm_cbe_c_2e_i_2e_i_2e_i_2e_i_2e_1_2e_0__PHI_TEMPORARY;
  float llvm_cbe_area_2e_i248_2e_i_2e_i_2e_i_2e_0;
  float llvm_cbe_area_2e_i248_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned int llvm_cbe_storemerge1_2e_i357_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_i357_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  float llvm_cbe_tmp137_2e_i362_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp146_2e_i383_2e_i_2e_i_2e_i774__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp149_2e_i385_2e_i_2e_i_2e_i781__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp149_2e_i385_2e_i_2e_i_2e_i781782783_2e_ins;
  llvmBitCastUnion llvm_cbe_tmp241_2e_i_2e_i_2e_i513__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp244_2e_i_2e_i_2e_i517__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp17_2e_i210_2e_i_2e_i_2e_i_2e_0;
  unsigned long long llvm_cbe_tmp17_2e_i210_2e_i_2e_i_2e_i_2e_0__PHI_TEMPORARY;
  unsigned long long llvm_cbe_tmp34_2e_i_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp4546_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp50_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp53_2e_i_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_tmp63_2e_i_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_i_2e_i_2e_i_2e_i;
  unsigned int llvm_cbe_storemerge1_2e_i_2e_i_2e_i_2e_i__PHI_TEMPORARY;
  float llvm_cbe_tmp75_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp78_2e_i_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp7179_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp193_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp196_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp202_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp205_2e_i_2e_i_2e_i_2e_i;
  struct l_struct_2E_b2AABB *llvm_cbe_tmp225_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp238_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp241_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp256_2e_i_2e_i_2e_i_2e_i;
  float *llvm_cbe_tmp259_2e_i_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp8990_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp94_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp97_2e_i_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp104105_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp3_2e_i160_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i167_2e_i_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i186_2e_i_2e_i_2e_i_2e_i683__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i189_2e_i_2e_i_2e_i_2e_i690__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i189_2e_i_2e_i_2e_i_2e_i690691692_2e_ins;
  float llvm_cbe_tmp111_2e_i_2e_i_2e_i_2e_i569;
  llvmBitCastUnion llvm_cbe_tmp111_2e_i_2e_i_2e_i_2e_i569__BITCAST_TEMPORARY;
  float llvm_cbe_tmp114_2e_i_2e_i_2e_i_2e_i573;
  llvmBitCastUnion llvm_cbe_tmp114_2e_i_2e_i_2e_i_2e_i573__BITCAST_TEMPORARY;
  float llvm_cbe_tmp16_2e_i_2e_i_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp8_2e_i299_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp13_2e_i304_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp20_2e_i311_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp129_2e_i_2e_i_2e_i_2e_i;
  unsigned long long llvm_cbe_tmp131132_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp3_2e_i371_2e_i_2e_i_2e_i_2e_i;
  float llvm_cbe_tmp10_2e_i378_2e_i_2e_i_2e_i_2e_i;
  llvmBitCastUnion llvm_cbe_tmp23_2e_i397_2e_i_2e_i_2e_i_2e_i725__BITCAST_TEMPORARY;
  llvmBitCastUnion llvm_cbe_tmp26_2e_i400_2e_i_2e_i_2e_i_2e_i732__BITCAST_TEMPORARY;
  unsigned long long llvm_cbe_tmp26_2e_i400_2e_i_2e_i_2e_i_2e_i732733734_2e_ins;
  float llvm_cbe_tmp138_2e_i_2e_i_2e_i_2e_i576;
  llvmBitCastUnion llvm_cbe_tmp138_2e_i_2e_i_2e_i_2e_i576__BITCAST_TEMPORARY;
  float llvm_cbe_tmp141_2e_i_2e_i_2e_i_2e_i580;
  