/*
 * This file is part of NumptyPhysics
 * Copyright (C) 2008 Tim Edmonds
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 */

#ifndef UI_H
#define UI_H

#include "Common.h"
#include "Array.h"
#include "Event.h"

#include <string>
#include <SDL/SDL.h>

class Canvas;
class Widget;

class WidgetParent;


class Widget
{
 public:
  virtual ~Widget() {} 
  virtual bool isDirty() {return false;}
  virtual Rect dirtyArea() {return Rect();};
  virtual void onTick( int tick ) {}
  virtual void draw( Canvas& screen, const Rect& area ) {};
  virtual bool handleEvent( SDL_Event& ev );
  virtual bool handleEvent( Event& ev ) {return false;}
  void setParent(WidgetParent* p) {m_parent = p;}
  WidgetParent* parent() { return m_parent; }
  void setEventMap(EventMap* em) {m_eventMap = em;}

  virtual void dirty() {}
  virtual void dirty( const Rect& r ) {}
  Rect& position() { return m_pos; }
 protected:
  Widget(WidgetParent *p=NULL) : m_parent(p), m_eventMap(NULL) {}
  WidgetParent* m_parent;
  EventMap*     m_eventMap;
  Rect          m_pos;
};


class WidgetParent : public Widget
{
 public:
  virtual void add( Widget* w, int x=-9999, int y=-9999 )=0;
  virtual void remove( Widget* w )=0;
};



class Label : public Widget
{
 public:
  Label();
  Label(const std::string& s, int a=0);
  void text( const std::string& s );
  void align( int a );
  virtual void draw( Canvas& screen, const Rect& area );
 private:
  std::string m_text;
};

class Button : public Widget
{
 public:
  Button();
};

class Container : public WidgetParent
{
 public:
  Container();
  ~Container();

  virtual bool isDirty();
  virtual Rect dirtyArea();
  virtual void onTick( int tick );
  virtual void draw( Canvas& screen, const Rect& area );
  virtual bool handleEvent( SDL_Event& ev );

  void add( Widget* w, int x, int y );
  virtual void remove( Widget* w );
 protected:
  Array<Widget*> m_children;
};


class Layer : public Container
{
 public:
  virtual void onShow() {}
  virtual void onHide() {}
};


#endif //UI_H
