/*
 * This file is part of NumptyPhysics
 * Copyright (C) 2008 Tim Edmonds
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 */

#include "Ui.h"
#include "Font.h"


bool Widget::handleEvent( SDL_Event& ev ) {
  if (m_eventMap) { 
    Event e = m_eventMap->process(ev);
    if (e.code != Event::NOP) {
      if (handleEvent(e)) {
	return true;
      } else if (m_parent) {
	return m_parent->handleEvent(e);
      }
    }
  }
  return false;
}


Label::Label()
{
  m_pos = Rect(0,0,50,20);
}


Label::Label(const std::string& s, int a)
  : m_text(s)
{}

void Label::text( const std::string& s )
{
  m_text = s;
}

void Label::draw( Canvas& screen, const Rect& area )
{
  Font::blurbFont()->drawCenter( &screen, m_pos.centroid(), m_text, 0 );
}

void Label::align( int a )
{}



Container::Container()
{}


Container::~Container()
{
  for (int i=0; i<m_children.size(); ++i) {
    delete m_children[i];
  }
}
  
bool Container::isDirty()
{
  for (int i=0; i<m_children.size(); ++i) {
    if (m_children[i]->isDirty()) {
      return true;
    }
  }
  return false;
}

Rect Container::dirtyArea()
{
  Rect r(false);
  for (int i=0; i<m_children.size(); ++i) {
    r.expand(m_children[i]->dirtyArea());
  }
  return r;
}

void Container::onTick( int tick )
{
  for (int i=0; i<m_children.size(); ++i) {
    m_children[i]->onTick(tick);
  }
}

void Container::draw( Canvas& screen, const Rect& area )
{
  for (int i=0; i<m_children.size(); ++i) {
    m_children[i]->draw(screen, area);
  }
}

bool Container::handleEvent( SDL_Event& ev )
{
  for (int i=0; i<m_children.size(); ++i) {
    if (m_children[i]->handleEvent(ev)) {
      return true;
    }
  }
  return Widget::handleEvent(ev);
}


void Container::add( Widget* w, int x, int y )
{
  if (x!=-9999 && y!=-9999) {
    w->position() = w->position() + -w->position().tl + Vec2(x,y);
  }
  m_children.append(w);
}


void Container::remove( Widget* w )
{
  m_children.erase(m_children.indexOf(w));
}


