﻿ #!/usr/bin/env python
# -*- coding: utf-8 -*-
# 


__title__="NumberLocation"
__author__= "binkcn"
__email__="binkcn@vip.qq.com"
__version__= "0.2.0"
__build__="111009"

import sys
import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtMaemo5 import QMaemo5InformationBox

class MainApp(QApplication):
    def __init__(self, parent=None):
        super(MainApp, self).__init__(parent)
        self.create_default_window()
        
    def create_default_window(self):
        self.defaultWin=DefaultWindow(None)
        aboutAction=self.create_action(unicode("关于软件"), self.show_about_form)
        self.menuBar=QMenuBar()
        self.menuBar.addAction(aboutAction)
        self.defaultWin.setMenuBar(self.menuBar)
        self.defaultWin.show()
        
    def show_about_form(self):
        aboutForm=AboutForm(self.defaultWin)
        aboutForm.show()
        
    def create_action(self, text, slot=None, shortcut=None, icon=None, tip=None, checkable=False, signal="triggered()"):
        action = QAction(text, self)
        if slot is not None:
            self.connect(action, SIGNAL(signal), slot)
        if checkable:
            action.setCheckable(True)
        return action
        
class DefaultWindow(QMainWindow):
    def __init__(self, parent=None, orientation=0):
        super(DefaultWindow, self).__init__(parent)
        self.setWindowTitle(__title__)
        
        self.orientation=orientation
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        
        st="""
            <br />
            NumberLocation 来/去电 号码归属地及类型显示<br />
            <br />
            如果您安装完毕后来电/去电没有显示号码归属地信息，<br />
            请点击下面第一个按钮重启归属地显示进程。<br />
            <br />
            如果您安装了 Extended Call Log，则可以点击第二个按钮，<br />
            将以前通讯录中所有未知号码归属地全部显示出来，<br />
            对于以后拨入/拨入的号码，将自动记录归属地信息。
        """
        
        self.labelsummary = QLabel()
        self.labelsummary.setText(st)
        self.rebootBtn = QPushButton(unicode("重新启动后台进程（归属地不显示时点击）"))
        self.parseBtn = QPushButton(unicode("批量追加显示通讯录中现有号码归属地信息"))
        
        self.buttonFormLayout=QFormLayout(self)
        self.buttonFormLayout.setAlignment(Qt.AlignTop)
        
        self.buttonFormLayout.addRow(self.labelsummary)
        self.buttonFormLayout.addRow(self.rebootBtn)
        self.buttonFormLayout.addRow(self.parseBtn)
        
        self.buttonFrame=QFrame()
        self.buttonFrame.setLayout(self.buttonFormLayout)
        
        self.mainLayout = QGridLayout(self)
        self.mainLayout.addWidget(self.buttonFrame)
        self.mainLayout.setAlignment(Qt.AlignTop)

        
        self.setCentralWidget(self.buttonFrame)
        self.setFixedSize(800,480)
        self.centralWidget().setStyleSheet("background-color: #333");
        self.connect(self.rebootBtn, SIGNAL("clicked()"), self.rebootBtn_Clicked)
        self.connect(self.parseBtn, SIGNAL("clicked()"), self.parseBtn_Clicked)
        
    def rebootBtn_Clicked(self):
        import os
        os.system("kill -9 `ps -ef|grep numberlocation|grep -v \"grep\"|awk '{print $1}'`")
        os.system("python numberlocation.py &")
        
        self.show_notice("后台进程重新启动成功！")
        
    def parseBtn_Clicked(self):
        self.show_notice("该功能暂未开放，有待商榷！")
        
        
    def show_notice(self,message,timeout=QMaemo5InformationBox.DefaultTimeout):
        QMaemo5InformationBox.information(None,"\n"+unicode(message)+"\n",timeout)
        
        
class AboutForm(QDialog):
    def __init__(self, parent=None):
        super(AboutForm, self).__init__(parent)
        self.setWindowTitle(unicode("关于"))
        self.aboutLabel=QLabel()
        st="""<b>NumberLocation</b>
            <p>  Nokia N900 来/去电号码归属地及类型显示
            <p>  如需在通讯录中显示归属地信息，请在源中安装以下软件：
            <p>  Extended Call Log
            <p>  版本号 %s  最后修订 %s
            <p>  软件作者 %s
            <p>  联系邮箱 %s
            """ % (
                          __version__, __build__,
                          __author__, __email__)
        self.aboutLabel.setText(st)
        self.formLayout=QFormLayout(self)
        self.formLayout.addRow(self.aboutLabel)
        
def main():
    reload(sys)
    sys.setdefaultencoding('utf8')
    QTextCodec.setCodecForCStrings(QTextCodec.codecForName("UTF-8"))
    app = MainApp(sys.argv)
    app.setApplicationName("NumberLocation")
    app.setOrganizationName("Binkcn")
    app.setOrganizationDomain("t.qq.com/binkcn")
    app.exec_()

main()
