import os
import threading
import time

import Audiobook
import FileStorage
import SimpleGStreamer
import Paths

import logging
log = logging.getLogger("nqaap.Controller")

class Player:
    def __init__(self,ui = None, threaded = False):
        self.storage = FileStorage.FileStorage(path = Paths.config_dir)
        self.player = SimpleGStreamer.SimpleGStreamer(self.chapter_done, run_thread = threaded)
        self.ui = ui
        self.audiobook = None

        if self.storage.selected != None:
            try:
                log.info("continuing book: " + self.storage.selected)
                self.set_book(self.storage.selected)
            except IOError:
                log.info("Audiobook could not be loaded")
                
        if self.ui is not None: 
            self.ui.set_books(self.get_books())

            
    def set_book(self, book):
        self.storage.select_book(book)
        chapter_num, time = self.storage.get_time()
        self.audiobook = Audiobook.Audiobook(os.path.join(Paths.book_dir , book), chapter_num)
        
        # self.player.set_file(self.audiobook.get_current_chapter())
        # self.player.seek_time(time) 
        
        if self.ui is not None:
            self.ui.set_book(book, self.audiobook.get_cover_img())
            self.ui.set_chapters(self.audiobook.chapters)

        chapter_title = self.audiobook.chapters[chapter_num]
        self.set_chapter(chapter_title,True)

    def set_chapter(self, chapter, continuing = False):
        log.info("set chapter:" + chapter + " : Continuing: " + str(continuing))
        self.audiobook.set_chapter(chapter)
        self.player.set_file(self.audiobook.get_current_chapter())
        if not continuing:
            self.storage.set_time(self.audiobook.current_chapter,0)
        
        if self.ui is not None:
            self.ui.set_chapter(self.audiobook.current_chapter)

        
    def chapter_done(self,player):
        log.info("chapter done")
        self.player.stop()
        next_file = self.audiobook.get_next_chapter()
        if next_file != False:
            self.set_chapter(next_file)
            self.player.play()
        else:                           # the book is over
            self.storage.set_time(0,0)

    def play(self):
        if self.audiobook != None:

            self.player.play()
            dummy, target_time = self.storage.get_time()
            if target_time > 0:
                time.sleep(1)
                self.player.seek_time(target_time)
            #print self.player.elapsed()
        else:
            print "No book selected, find one in ", Paths.book_dir

            
    def stop(self):
        position = self.player.elapsed()
        self.player.stop()
        
        #print "stopped at ", position
        if not self.audiobook is None:
            self.storage.set_time(self.audiobook.current_chapter, position)



    def is_playing(self):
        return self.player.playing

    def sleeptimer(self, secs):
        #print "sleeper", secs
        time.sleep(secs)
        #print "now its time to sleep"
        self.stop()
    
    def start_sleeptimer(self, secs):
        #print "startin sleep"
        sleep_thread = threading.Thread(target=self.sleeptimer, args=(secs,))
        sleep_thread.start()
        #print "started sleep"

    def get_percentage(self):
        try:
            return float(self.player.elapsed()) / float(self.player.duration())
        except ZeroDivisionError:
            return 0.0

    def seek_percent(self, ratio):
        try:
            target = self.player.duration() * ratio # Calculate where to seek
            self.player.seek_time(int(target))      # seek

            position = self.player.elapsed()
            self.storage.set_time(self.audiobook.current_chapter, target) # save position
            return True
        except:
            return False

    def get_books(self):
        return Paths.get_books()

    # def get_chapters(self):
    #     """returns a list of all the chapters in the current book"""
    #     raise Exception("this function should not be used")
    #     return {c[0:-4] for c in self.audiobook.chapters}
        
