import os
import glob

import logging
log = logging.getLogger("pap.Audiobook")


class Audiobook:
    def __init__(self,path, current_chapter = 0):
        # Fields
        self.title = ""
        self.cover = ""
        self.chapters = []
        self.current_chapter = current_chapter
        self.book_dir = ""

        # read inx file
        self.read(path)

    def get_current_chapter(self):
        #print self.chapters
        #print self.current_chapter
        #print "get_current_chapter: ", os.path.join(self.book_dir,self.chapters[self.current_chapter])
        return os.path.join(self.book_dir,self.chapters[self.current_chapter])

    def set_chapter(self,chapter):
        if chapter in self.chapters:
            self.current_chapter = self.chapters.index(chapter)
        else:
            raise Exception("Unknown chapter set")
    
    def get_next_chapter(self):
        if len(self.chapters) == self.current_chapter:
            return False
        else:
            self.current_chapter = self.current_chapter +1
            return self.chapters[self.current_chapter] # return the
                                                       # file name for
                                                       # the next
                                                       # chapter,
                                                       # without path

    def get_cover_img(self):
        log.info("get_cover_img :" + os.path.join(self.book_dir,self.cover))
        return os.path.join(self.book_dir,self.cover) if self.cover != "" else ""
    
    def read(self, path):
        
        if (os.path.isfile(path)):
            self.read_inx_file(path)
        elif (os.path.isdir(path)):
            self.read_dir(path)
        else:
            print "path not found"

    def read_dir(self, path):
        
        self.book_dir = path
        self.title = os.path.split(self.book_dir)[-1]
        #print self.title, ": reading dir: ", self.book_dir 
        files = [f for f in os.listdir(self.book_dir) if os.path.isfile(os.path.join(self.book_dir, f))]

        images = [f for f in files if f[-4:] in [".png",".gif",".jpg","jpeg"]]
        if len(images) == 0:
            self.cover = ""
        else:
            self.cover = images[0]

        self.chapters = sorted([f for f in files if f[-4:] in [".awb"] ])#.sort()
        
    def read_inx_file(self, file):
        self.book_dir = os.path.dirname(file)
        
        import unicodedata 
            
        # Reading file
        looking_for_title = False
        looking_for_cover = False
        looking_for_chapters = False

        f = open(file,'r')
        for line in f:
            # title
            ascii = unicodedata.normalize('NFKD', unicode(line,"latin-1")).encode('ascii','ignore')
            print line[:-1], "PIC\n" in line, line in "#PIC"
            if ("#BOOK" in line):
                looking_for_title = True
                continue
            if (looking_for_title):
                self.title = line[:-1]
                looking_for_title = False
            if ("#PIC" in line):
                looking_for_cover = True
                continue
            if (looking_for_cover):
                self.cover = line[:-1]
                looking_for_cover = False
            if ("#TRACKS" in line):
                looking_for_chapters = True
                continue
            if (looking_for_chapters):
                if ("#CHAPTERS" in line):
                    break           # no further information needed
                self.chapters.add(line.split(':')[0])            
        
    
