import gtk
import hildon

import noor.gtkhelper
import noor.uihelpers


def make_menu_bar(main):
    if not noor.uihelpers.get_option(main.config, 'gtk.menu_bar', True):
        return None
    menus = [
        (_('Reload'), main._current_aya),
	(_('Choose Sura'), main._ask_sura),
        (_('Random Aya'), main._goto_random_aya),
        (_('Add Bookmark'), main._add_bookmark),
        (_('Show Bookmarks'), main._list_bookmarks),
        (_('About'), main._show_about),
	(_('talk.maemo.org'), main._tmo_homepage),
        ]

    menu_bar = hildon.AppMenu()
    _add_menu(menus, menu_bar)
    return menu_bar

def _add_menu(menus, menu):
    for submenu in menus:
        item = hildon.GtkButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        item.set_label(submenu[0])
        if submenu[1] is not None:
            item.connect('clicked', submenu[1])
        menu.append(item)
    return menu

