#!/usr/bin/env python2.5
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA  02110-1301, USA.
#

from distutils.core import setup

version = '0.1'

# files to install
inst_dbus = ['nolazy.service']
inst_desktop = ['nolazy.desktop']
inst_icon = ['nolazy.png']
inst_py = ['nolazy.py', 'portrait.py','backend.py']
backup_conf  = ['nolazy.conf']
sh = ['nolazy']

data_files = [
  ('share/applications/hildon', inst_desktop),
  ('share/dbus-1/services',   inst_dbus),
  ('share/icons/hicolor/scalable/hildon/',  inst_icon),
  ('/opt/nolazy',   inst_py),
  ('/etc/osso-backup/applications/',   backup_conf),
]

setup(
  name         = 'nolazy',
  version      = version,
  description  = 'Manage your tasks in Remember The Milk',
  author       = 'Daniel Martin Yerga',
  author_email = 'dyerga@gmail.com',
  url          = 'http://yerga.net',
  data_files   = data_files,
  scripts      = sh
)
