#!/usr/bin/env python
# -*- coding: UTF8 -*-
# Copyright (C) 2009 by Daniel Martin Yerga
# <dyerga@gmail.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# NoLazy: A Remember The Milk application
# Version 0.1
#

import gtk
import hildon
import backend
import gobject
import thread
import os

import osso
osso_c = osso.Context("org.maemo.nolazy", "0.1", False)

from portrait import FremantleRotation

fhsize = gtk.HILDON_SIZE_FINGER_HEIGHT
horbtn = hildon.BUTTON_ARRANGEMENT_HORIZONTAL
verbtn = hildon.BUTTON_ARRANGEMENT_VERTICAL
ui_normal = gtk.HILDON_UI_MODE_NORMAL
winprogind = hildon.hildon_gtk_window_set_progress_indicator

def show_info_banner(widget, msg):
    hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', msg)

HOME = os.path.expanduser("~")
configdir = HOME + '/.nolazy/'
configfile = configdir + 'authtoken.xml'
if not os.path.exists(configdir):
    os.mkdir(configdir)

#FIXME: check for Internet

gtk.gdk.threads_init()

class MainWindow:
    def __init__(self):
        if os.path.exists(configfile):
            token = self.open_authtoken()
            self.RTM = backend.RTMbackend(token)
            self.notauth = False
        else:
            self.notauth = True

        self.program = hildon.Program()
        self.program.__init__()
        gtk.set_application_name("NoLazy")

        self.window = hildon.StackableWindow()
        self.window.set_default_size(800, 480)
        self.window.set_title('Lists')
        self.window.connect("destroy", gtk.main_quit)
        self.program.add_window(self.window)

        self.rotation = FremantleRotation('RTM', None, "0.1", 0)

        menu = self.make_menu()
        self.window.set_app_menu(menu)

        vbox = self.initial_screen()
        self.window.add(vbox)

        self.window.show_all()

        if self.notauth:
            #TODO: banner
            print 'Must authenticate to RTM'
        else:
            thread.start_new_thread(self.get_lists_from_rtm, ())

    def make_menu(self):
        menu = hildon.AppMenu()

        if self.notauth:
            button = gtk.Button("Authenticate in RTM")
            button.connect("clicked", self.authenticate_to_rtm)
            menu.append(button)


        button = gtk.Button("Add task")
        button.connect("clicked", self.add_task_to_inbox)
        menu.append(button)

        menu.show_all()
        return menu

    def initial_screen(self):
        vbox = gtk.VBox()

        parea = hildon.PannableArea()
        parea.set_property("mov-mode", hildon.MOVEMENT_MODE_BOTH)

        self.liststv = hildon.GtkTreeView(ui_normal)

        #TODO: Hildon live search

        self.lists_model = self.create_lists_model('')
        self.liststv.set_model(self.lists_model)

        self.add_columns_to_lists(self.liststv)

        parea.add(self.liststv)
        vbox.pack_start(parea, True, True, 0)

        return vbox

    def get_lists_from_rtm(self):
        winprogind(self.window, 1)
        rtmlists = self.RTM.get_lists()
        winprogind(self.window, 0)
        self.lists_model = self.create_lists_model(rtmlists)
        self.liststv.set_model(self.lists_model)
        gtk.gdk.threads_enter()
        self.liststv.connect("row-activated", self.tasks_from_list_screen, self.lists_model)
        gtk.gdk.threads_leave()

    def create_lists_model(self, rtmlists):
        import operator
        lstore = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING)
        #lists=[[id, 'title']...]
        rtmlists = sorted(rtmlists, key=operator.itemgetter(1))
        for item in rtmlists:
            lstore_iter = lstore.append()
            lstore.set(lstore_iter, 0, item[0], 1, item[1])

        return lstore

    def add_columns_to_lists(self, treeview):
        model = treeview.get_model()

        # column for ID
        column = gtk.TreeViewColumn('ID', gtk.CellRendererText(), text=0)
        column.set_visible(False)
        treeview.append_column(column)

        # column for title
        column = gtk.TreeViewColumn('List title',gtk.CellRendererText() , text=1)
        treeview.append_column(column)


    def tasks_from_list_screen(self, widget, path, column, model):
        listid = model[path][0]
        listname = model[path][1]

        win = hildon.StackableWindow()
        win.set_title("Tasks - %s" % listname)
        vbox = gtk.VBox()
        parea = hildon.PannableArea()
        parea.set_property("mov-mode", hildon.MOVEMENT_MODE_BOTH)

        #TODO: Hildon live search

        self.taskstv = hildon.GtkTreeView(ui_normal)
        self.tasks_model = self.create_tasks_model('')
        self.taskstv.set_model(self.tasks_model)

        self.add_columns_to_tasklist(self.taskstv)

        parea.add(self.taskstv)
        vbox.pack_start(parea, True, True, 0)
        win.add(vbox)

        menu = hildon.AppMenu()
        button = gtk.Button("Add task")
        button.connect("clicked", self.add_smart_task_to_list, listid)
        #button.connect("clicked", self.edit_task_screen, listid, False)
        menu.append(button)

        #TODO:
        #button = gtk.Button("Delete tasks")
        #button.connect("clicked", self.edit_recipe_from_view, recipe_id)
        #menu.append(button)

        menu.show_all()
        win.set_app_menu(menu)

        win.show_all()

        thread.start_new_thread(self.get_tasks_from_rtm, (listid, listname, win))

    def get_tasks_from_rtm(self, listid, listname, win):
        winprogind(win, 1)
        rtmtasks = self.RTM.get_tasks_from_list(listid)

        if not rtmtasks:
            rtmtasks = ''
            gtk.gdk.threads_enter()
            show_info_banner(win, "No tasks in this list")
            gtk.gdk.threads_leave()

        self.tasks_model = self.create_tasks_model(rtmtasks)
        self.taskstv.set_model(self.tasks_model)
        winprogind(win, 0)
        gtk.gdk.threads_enter()
        self.taskstv.connect("row-activated", self.task_details_screen,
                        self.tasks_model, listname)
        gtk.gdk.threads_leave()


    def create_tasks_model(self, rtmtasks):
        lstore = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING)
        #lists=[[id, 'title']...]
        for item in rtmtasks:
            lstore_iter = lstore.append()
            lstore.set(lstore_iter, 0, item[0], 1, item[1])

        return lstore

    def add_columns_to_tasklist(self, treeview):
        model = treeview.get_model()

        # column for ID
        column = gtk.TreeViewColumn('ID', gtk.CellRendererText(), text=0)
        column.set_visible(False)
        treeview.append_column(column)

        # column for title
        column = gtk.TreeViewColumn('Task title',gtk.CellRendererText() , text=1)
        treeview.append_column(column)


    def task_details_screen(self, widget, path, column, model, listname):
        serieid, taskid, listid = model[path][0].split('-')

        #data = [name, due, estimate, tags, locid, priority, url, notes]
        data = self.RTM.get_task_details(listid, serieid)

        if not data:
            #TODO: show banner
            return

        win = hildon.StackableWindow()
        win.set_title("Task details")
        parea = hildon.PannableArea()
        parea.set_property("mov-mode", hildon.MOVEMENT_MODE_BOTH)
        vbox = gtk.VBox()

        #taskname and listname
        label = gtk.Label()
        label.set_markup('<b>%s</b> [%s]' % (data[0], listname.replace('<', '')))
        vbox.pack_start(label, True, True, 0)

        #due date
        label = gtk.Label()
        label.set_markup('<b>Due:</b> %s' % data[1])
        vbox.pack_start(label, True, True, 0)

        #repeat
        #label = gtk.Label()
        #label.set_markup('<b>Repeat:</b> %s' % "every Sunday")
        #vbox.pack_start(label, True, True, 0)

        #time estimate
        label = gtk.Label()
        label.set_markup('<b>Time estimate:</b> %s' % data[2])
        vbox.pack_start(label, True, True, 0)

        #tags
        label = gtk.Label()
        label.set_markup('<b>Tags:</b> %s' % data[3])
        vbox.pack_start(label, True, True, 0)

        #location
        label = gtk.Label()
        label.set_markup('<b>Location:</b> %s' % data[4])
        vbox.pack_start(label, True, True, 0)

        #URL
        label = gtk.Label()
        label.set_markup('<b>URL:</b> %s' % data[6])
        vbox.pack_start(label, True, True, 0)

        #priority
        label = gtk.Label()
        label.set_markup('<b>Priority:</b> %s' % data[5])
        vbox.pack_start(label, True, True, 0)

        #notes
        label = gtk.Label()
        label.set_markup('<b>Notes:</b> %s' % data[7])
        vbox.pack_start(label, True, True, 0)

        parea.add_with_viewport(vbox)

        win.add(parea)

        menu = hildon.AppMenu()
        button = gtk.Button("Complete")
        button.connect("clicked", self.complete_task, serieid, taskid, listid, win)
        menu.append(button)

        button = gtk.Button("Postpone")
        button.connect("clicked", self.postpone_task, serieid, taskid, listid, win)
        menu.append(button)

        button = gtk.Button("Delete")
        button.connect("clicked", self.delete_task, serieid, taskid, listid, win)
        menu.append(button)

        menu.show_all()
        win.set_app_menu(menu)

        win.show_all()

    def complete_task(self, widget, serieid, taskid, listid, win):
        winprogind(win, 1)
        thread.start_new_thread(self._do_complete, (listid, serieid, taskid, win))

    def _do_complete(self, listid, serieid, taskid, win):
        self.RTM.complete_task(listid, serieid, taskid)
        winprogind(win, 0)
        gtk.gdk.threads_enter()
        show_info_banner(win, "Task completed")
        gtk.gdk.threads_leave()

    def postpone_task(self, widget, serieid, taskid, listid, win):
        winprogind(win, 1)
        thread.start_new_thread(self._do_postpone, (listid, serieid, taskid, win))

    def _do_postpone(self, listid, serieid, taskid, win):
        self.RTM.postpone_task(listid, serieid, taskid)
        winprogind(win, 0)
        gtk.gdk.threads_enter()
        show_info_banner(win, "Task posponed")
        gtk.gdk.threads_leave()

    def delete_task(self, widget, serieid, taskid, listid, win):
        winprogind(win, 1)
        thread.start_new_thread(self._do_delete, (listid, serieid, taskid, win))

    def _do_delete(self, listid, serieid, taskid, win):
        self.RTM.delete_task(listid, serieid, taskid)
        winprogind(win, 0)
        gtk.gdk.threads_enter()
        show_info_banner(win, "Task deleted")
        gtk.gdk.threads_leave()
        #TODO: hide the task in the tasklist, etc.

    def edit_task_screen(self, widget, listid, editing):
        if editing:
            pass
            #get all data
        else:
            name = ''
            repeat = ''
            estimate = ''
            tags = ''
            location = ''
            url = ''
            priority = 0

        win = hildon.StackableWindow()
        win.set_title("Editing task")
        parea = hildon.PannableArea()
        vbox = gtk.VBox()

        #taskname and listname
        hbox = gtk.HBox()
        label = gtk.Label('Name:')
        self.enname = hildon.Entry(fhsize)

        hbox.pack_start(label, True, True, 0)
        hbox.pack_start(self.enname, True, True, 0)
        vbox.pack_start(hbox, True, True, 0)

        #due date
        hbox = gtk.HBox()
        label = gtk.Label('Due:')
        self.endue = hildon.Entry(fhsize)

        hbox.pack_start(label, True, True, 0)
        hbox.pack_start(self.endue, True, True, 0)
        vbox.pack_start(hbox, True, True, 0)

        #repeat
        hbox = gtk.HBox()
        label = gtk.Label('Repeat:')
        self.enrepeat = hildon.Entry(fhsize)

        hbox.pack_start(label, True, True, 0)
        hbox.pack_start(self.enrepeat, True, True, 0)
        vbox.pack_start(hbox, True, True, 0)

        #time estimate
        hbox = gtk.HBox()
        label = gtk.Label('Estimate:')
        self.enestimate = hildon.Entry(fhsize)

        hbox.pack_start(label, True, True, 0)
        hbox.pack_start(self.enestimate, True, True, 0)
        vbox.pack_start(hbox, True, True, 0)

        #tags
        hbox = gtk.HBox()
        label = gtk.Label('Tags:')
        self.entags = hildon.Entry(fhsize)

        hbox.pack_start(label, True, True, 0)
        hbox.pack_start(self.entags, True, True, 0)
        vbox.pack_start(hbox, True, True, 0)

        #location
        #hbox = gtk.HBox()
        #label = gtk.Label('Location:')
        #self.enlocation = hildon.Entry(fhsize)

        #hbox.pack_start(label, True, True, 0)
        #hbox.pack_start(self.enlocation, True, True, 0)
        #vbox.pack_start(hbox, True, True, 0)

        #URL
        hbox = gtk.HBox()
        label = gtk.Label('URL:')
        self.enurl = hildon.Entry(fhsize)

        hbox.pack_start(label, True, True, 0)
        hbox.pack_start(self.enurl, True, True, 0)
        vbox.pack_start(hbox, True, True, 0)

        #priority
        hbox = gtk.HBox()
        label = gtk.Label('Priority:')

        self.btn0 = hildon.GtkRadioButton(fhsize)
        self.btn0.set_mode(False)
        self.btn0.set_label('None')

        self.btn1 = hildon.GtkRadioButton(fhsize)
        self.btn1.set_mode(False)
        self.btn1.set_label('1')
        self.btn1.set_group(self.btn0)

        self.btn2 = hildon.GtkRadioButton(fhsize)
        self.btn2.set_mode(False)
        self.btn2.set_label('2')
        self.btn2.set_group(self.btn0)

        self.btn3 = hildon.GtkRadioButton(fhsize)
        self.btn3.set_mode(False)
        self.btn3.set_label('3')
        self.btn3.set_group(self.btn0)

        hbox.pack_start(label, False, False, 0)
        hbox.pack_start(self.btn0, True, True, 0)
        hbox.pack_start(self.btn1, True, True, 0)
        hbox.pack_start(self.btn2, True, True, 0)
        hbox.pack_start(self.btn3, True, True, 0)
        vbox.pack_start(hbox, True, True, 0)

        #notes
        #label = gtk.Label('Notes: coming')
        #vbox.pack_start(label, True, True, 0)

        parea.add_with_viewport(vbox)

        win.add(parea)

        menu = hildon.AppMenu()
        button = gtk.Button("Save task")
        button.connect("clicked", self.save_task, editing, listid)
        menu.append(button)

        menu.show_all()
        win.set_app_menu(menu)

        win.show_all()

    def save_task(self, widget, editing, listid):
        #TODO: get data from entries
        #TODO: change location_name for location_id
        if editing:
            pass
        else:
            serieid, taskid = self.RTM.add_task(listid, name)
            self.RTM.set_estimate(listid, serieid, taskid, estimate)
            self.RTM.set_duedate(listid, serieid, taskid, due)
            self.RTM.set_URL(listid, serieid, taskid, url)
            self.RTM.set_priority(listid, serieid, taskid, priority)
            self.RTM.set_tags(listid, serieid, taskid, tags)
            self.RTM.set_recurrence(listid, serieid, taskid, repeat)
            #self.RTM.set_location(listid, serieid, taskid, locid)

    def save_authtoken(self, TOKEN):
        from lxml import etree
        root = etree.Element("authtoken")
        root.text = TOKEN
        xmltext = etree.tostring(root)
        try:
            file_object = open(configfile, "w")
            file_object.write(xmltext)
            file_object.close()
        except IOError, (errno, strerror):
            print "Error saving configuration(%s): %s" % (errno, strerror)


    def open_authtoken(self):
        from lxml import etree
        xmltext = self.open_configfile()
        if xmltext:
            root = etree.XML(xmltext)
            token = root.text

            return token

        return False

    def open_configfile(self):
        xmltext = False
        try:
            file_object = open(configfile, "r")
            xmltext = file_object.read()
            file_object.close()
        except IOError, (errno, strerror):
            print "Error saving configuration(%s): %s" % (errno, strerror)

        return xmltext

    def authenticate_to_rtm(self, widget):
        #FIXME: handling errors
        self.RTM = backend.RTMbackend(None)
        authurl = self.RTM.myrtm.getAuthURL()

        thread.start_new_thread(self.open_url, (authurl,))

        dlg = self.show_info_dialog(self.window)

        #if not dlg:
        #    print 'You need authorize to Remember the Milk to use this application'

        authtoken = self.RTM.myrtm.getToken()

        self.save_authtoken(authtoken)

        self.RTM = backend.RTMbackend(authtoken)
        thread.start_new_thread(self.get_lists_from_rtm, ())

    def open_url(self, authurl):
        import dbus
        bus = dbus.SystemBus()
        proxy = bus.get_object("com.nokia.osso_browser", "/com/nokia/osso_browser/request")
        iface = dbus.Interface(proxy, 'com.nokia.osso_browser')
        iface.open_new_window(authurl)

    def show_info_dialog(self, win):
        dialog = gtk.Dialog(title='Authorize Remember The Milk', parent=win, buttons=("OK", gtk.RESPONSE_OK))
        dialog.set_transient_for(win)
        label1 = gtk.Label('Press OK after you have given authorization.')
        dialog.vbox.pack_start(label1, True, True, 0)

        dialog.show_all()
        result = dialog.run()
        if result == gtk.RESPONSE_OK:
            dialog.destroy()
            return True
        #else:
        #    dialog.destroy()
        #    return False

        dialog.destroy()

    def add_task_to_inbox(self, widget):
        for i in range(len(self.lists_model)):
            if self.lists_model[i][1] == 'Inbox':
                listid = self.lists_model[i][0]
                break

        self.smart_task_screen(listid)

    def add_smart_task_to_list(self, widget, listid):
        self.smart_task_screen(listid)
        #TODO: add task to the treeview list

    def smart_task_screen(self, listid):
        win = hildon.StackableWindow()
        win.set_title("Adding task")
        parea = hildon.PannableArea()
        vbox = gtk.VBox()

        #taskname
        textview = hildon.TextView()
        textview.set_wrap_mode(gtk.WRAP_WORD)
        textview.set_editable(True)
        tbuffer = textview.get_buffer()

        vbox.pack_start(textview, True, True, 0)

        label = gtk.Label("Smart add syntax:\n"
                        "^  Due Date\n"
                        "! 	Priority\n"
                        "# 	Lists and Tags\n"
                        "@ 	Location\n"
                        "* 	Repeat\n"
                        "= 	Time Estimate")

        vbox.pack_start(label, False, False, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_label("Save task")
        button.connect("clicked", self.save_smart_task, tbuffer, win, listid)
        vbox.pack_start(button, False, False, 0)

        parea.add_with_viewport(vbox)

        win.add(parea)

        win.show_all()

    def save_smart_task(self, widget, tbuffer, win, listid):
        start, end = tbuffer.get_bounds()
        tasktext = tbuffer.get_text(start, end)
        winprogind(win, 1)
        thread.start_new_thread(self._do_save_smart_task, (listid, tasktext, win))

    def _do_save_smart_task(self, listid, tasktext, win):
        serieid, taskid = self.RTM.add_smart_task(listid, tasktext)
        winprogind(win, 0)
        stack = win.get_stack()
        stack.pop_1()
        gtk.gdk.threads_enter()
        show_info_banner(win, "Task saved")
        gtk.gdk.threads_leave()


if __name__ == "__main__":
    MainWindow = MainWindow()
    gtk.gdk.threads_enter()
    gtk.main()
    gtk.gdk.threads_leave()
