import rtm
import datetime

API_KEY = '6f5af2c7b25c226ba2369a6762ff159d'
SECRET = '1432f6a265a3d644'


class RTMbackend:
    def __init__(self, TOKEN):
        self.myrtm = rtm.RTM(API_KEY, SECRET, TOKEN)

        if TOKEN is not None:
            rsp = self.myrtm.timelines.create()
            self.timeline = rsp.timeline

    def get_lists(self):
        rsp = self.myrtm.lists.getList()
        lists = []
        for i in rsp.lists.list:
            lists.append([i.id, i.name])

        return lists

    def get_tasks_from_list(self, listid):
        rsp = self.myrtm.tasks.getList(list_id=listid)
        taskslist = rsp.tasks.list

        if not (type(taskslist) == list):
            try:
                taskslist.taskseries
            except:
                print 'No tasks in this list'
                return None

        tasks = []

        if type(taskslist) == list:
            for i in rsp.tasks.list:
                if type(i.taskseries) == list:
                    for j in i.taskseries:
                        if not j.task.completed:
                            tasks.append(["%s-%s-%s" % (j.id, j.task.id, listid),
                                    j.name])
                else:
                    if not i.taskseries.task.completed:
                        tasks.append(["%s-%s-%s" % (i.taskseries.id,
                                    i.taskseries.task.id, listid), i.taskseries.name])
        else:
            if type(taskslist.taskseries) == list:
                for task in taskslist.taskseries:
                    #Just shows the not-completed tasks
                    if not task.task.completed:
                        ##seriesid-taskid-listid
                        tasks.append(["%s-%s-%s" % (task.id, task.task.id,
                                    listid), task.name])
            else:
                tasks.append(["%s-%s-%s" % (taskslist.taskseries.id,
                                    taskslist.taskseries.task.id, listid),
                                    taskslist.taskseries.name])

        return tasks


    def add_task(self, listid, name):
        rsp = self.myrtm.tasks.add(timeline=self.timeline, list_id=listid,
                name=name)

        serieid = rsp.list.taskseries.id
        taskid = rsp.list.taskseries.task.id

        return serieid, taskid

    def add_smart_task(self, listid, name):
        rsp = self.myrtm.tasks.add(timeline=self.timeline, list_id=listid,
                name=name, parse=1)

        serieid = rsp.list.taskseries.id
        taskid = rsp.list.taskseries.task.id

        return serieid, taskid



    def delete_task(self, listid, seriesid, taskid):
        rsp = self.myrtm.tasks.delete(timeline=self.timeline, list_id=listid,
                taskseries_id=seriesid, task_id=taskid)

    def complete_task(self,  listid, seriesid, taskid):
        rsp = self.myrtm.tasks.complete(timeline=self.timeline, list_id=listid,
                taskseries_id=seriesid, task_id=taskid)

    def postpone_task(self,  listid, seriesid, taskid):
        rsp = self.myrtm.tasks.postpone(timeline=self.timeline, list_id=listid,
                taskseries_id=seriesid, task_id=taskid)

    def uncomplete_task(self, listid, seriesid, taskid):
        rsp = self.myrtm.tasks.uncomplete(timeline=self.timeline,
                list_id=listid, taskseries_id=seriesid, task_id=taskid)

    def set_estimate(self, listid, seriesid, taskid, estimate):
        #estimate = "1 day", "1 hour", etc. (days, hours, minutes)
        rsp = self.myrtm.tasks.setEstimate(timeline=self.timeline,
                list_id=listid, taskseries_id=seriesid, task_id=taskid,
                estimate=estimate)

    def set_duedate(self, listid, seriesid, taskid, due):
        #estimate = Due date for a task, in ISO 8601 format: YYYY-MM-DD
        #TODO: has_due_time, parse
        rsp = self.myrtm.tasks.setDueDate(timeline=self.timeline,
                list_id=listid, taskseries_id=seriesid, task_id=taskid,
                due=due)

    def rename_task(self, listid, seriesid, taskid, newname):
        rsp = self.myrtm.tasks.setName(timeline=self.timeline,
                list_id=listid, taskseries_id=seriesid, task_id=taskid,
                name=newname)

    def set_URL(self, listid, seriesid, taskid, url):
        rsp = self.myrtm.tasks.setURL(timeline=self.timeline,
                list_id=listid, taskseries_id=seriesid, task_id=taskid,
                url=url)

    def set_priority(self, listid, seriesid, taskid, priority):
        #priority = 1, 2, 3
        rsp = self.myrtm.tasks.setPriority(timeline=self.timeline,
                list_id=listid, taskseries_id=seriesid, task_id=taskid,
                priority=priority)

    def set_tags(self, listid, seriesid, taskid, tags):
        #Overwrite the actual tags
        #tags = 'tag1, tag2, tag3, etc.'
        rsp = self.myrtm.tasks.setTags(timeline=self.timeline,
                list_id=listid, taskseries_id=seriesid, task_id=taskid,
                tags=tags)

    def add_tags(self, listid, seriesid, taskid, tags):
        #Add tags to the actual ones
        #tags = 'tag1, tag2, tag3, etc.'
        rsp = self.myrtm.tasks.addTags(timeline=self.timeline,
                list_id=listid, taskseries_id=seriesid, task_id=taskid,
                tags=tags)

    def remove_tags(self, listid, seriesid, taskid, tags):
        #tags = 'tag1, tag2, tag3, etc.'
        rsp = self.myrtm.tasks.removeTags(timeline=self.timeline,
                list_id=listid, taskseries_id=seriesid, task_id=taskid,
                tags=tags)

    def set_recurrence(self, listid, seriesid, taskid, repeat):
        #repeat= www.rememberthemilk.com/help/answers/basics/repeatformat.rtm
        rsp = self.myrtm.tasks.setRecurrence(timeline=self.timeline,
                list_id=listid, taskseries_id=seriesid, task_id=taskid,
                repeat=repeat)

    def set_location(self, listid, seriesid, taskid, locid):
        #repeat= www.rememberthemilk.com/help/answers/basics/repeatformat.rtm
        rsp = self.myrtm.tasks.setLocation(timeline=self.timeline,
                list_id=listid, taskseries_id=seriesid, task_id=taskid,
                location_id=locid)

    def move_task_to_list(self, oldlistid, newlistid, seriesid, taskid):
        rsp = self.myrtm.tasks.moveTo(timeline=self.timeline,
                from_list_id=oldlistid, to_list_id=newlistid,
                taskseries_id=seriesid, task_id=taskid)

    def get_task_details(self, listid, serieid):
        rsp = self.myrtm.tasks.getList(list_id=listid)
        taskdetails = []
        taskslist = rsp.tasks.list

        if type(taskslist) == list:
            for i in rsp.tasks.list:
                if type(i.taskseries) == list:
                    for j in i.taskseries:
                        if j.id == serieid:

                            if j.tags != []:
                                tags = j.tags.tag
                            else:
                                tags = ''

                            #TODO: get notes instead of the number
                            taskdetails = [j.name, j.task.due, j.task.estimate,
                                    tags, j.location_id, j.task.priority,
                                    j.url, len(j.notes)]

                            taskdetails = self.process_details(taskdetails)
                            return taskdetails

                else:
                    if i.taskseries.id == serieid:

                        if i.taskseries.tags != []:
                            tags = i.taskseries.tags.tag
                        else:
                            tags = ''

                        #TODO: get notes instead of the number
                        taskdetails = [i.taskseries.name,
                                i.taskseries.task.due,
                                i.taskseries.task.estimate, tags,
                                i.taskseries.location_id,
                                i.taskseries.task.priority,
                                i.taskseries.url, len(i.taskseries.notes)]

                        taskdetails = self.process_details(taskdetails)
                        return taskdetails
        else:
            if type(taskslist.taskseries) == list:
                for serie in taskslist.taskseries:
                    if serie.id == serieid:
                        if serie.tags != []:
                            tags = serie.tags.tag
                        else:
                            tags = ''

                        #TODO: get notes instead of the number
                        taskdetails = [serie.name, serie.task.due, serie.task.estimate,
                                tags, serie.location_id, serie.task.priority,
                                serie.url, len(serie.notes)]

                        taskdetails = self.process_details(taskdetails)
                        return taskdetails

            else:
                if taskslist.taskseries.id == serieid:
                    if taskslist.taskseries.tags != []:
                        tags = taskslist.taskseries.tags.tag
                    else:
                        tags = ''

                    #TODO: get notes instead of the number
                    taskdetails = [taskslist.taskseries.name,
                                taskslist.taskseries.task.due,
                                taskslist.taskseries.task.estimate, tags,
                                taskslist.taskseries.location_id,
                                taskslist.taskseries.task.priority,
                                taskslist.taskseries.url,
                                len(taskslist.taskseries.notes)]

                    taskdetails = self.process_details(taskdetails)
                    return taskdetails

        return taskdetails

    def process_details(self, taskdetails):
        name = taskdetails[0]

        if taskdetails[1]:
            due = datetime.datetime.strptime(taskdetails[1], "%Y-%m-%dT%H:%M:%SZ")
            due = self.add_one_day(due)
        else:
            due = 'Never'

        if taskdetails[2]:
            estimate = taskdetails[2]
        else:
            estimate = 'None'

        #TODO: if tags is list -> to string
        if str(taskdetails[3]):
            tags = str(taskdetails[3])
        else:
            tags = 'None'

        #TODO: get location name instead of id
        if taskdetails[4]:
            locid = taskdetails[4]
        else:
            locid = 'None'

        if taskdetails[5] == 'N':
            priority = 'None'
        else:
            priority = taskdetails[5]

        if taskdetails[6]:
            url = taskdetails[6]
        else:
            url = 'None'

        notes = "%s note(s)" % taskdetails[7]

        details = [name, due, estimate, tags, locid, priority, url, notes]

        return details


    def add_one_day(self, date):
        delta = datetime.timedelta(days=1)
        date = date + delta
        return date
