#include "tcpadaptor.h"
#include <QStringList>
#include <QDomDocument>
#include <QtDebug>
#include <QMetaMethod>

TcpAdaptor::TcpAdaptor( QObject *parent) :
    QObject(parent),m_socket(NULL)
{

}

void TcpAdaptor::setSocket(QTcpSocket *s)
{
	m_socket = s;
	connect(m_socket,SIGNAL(readyRead()),this, SLOT(readData()));
}

void TcpAdaptor::readData()
{
	QString ba = m_socket->readAll();
	QStringList all = ba.split("\n");

	foreach(QString data, all)
	{
		if(data.trimmed() == "")
			continue;
		parseData(data.trimmed());
	}
}

void TcpAdaptor::parseData(QString ba)
{
	if(parent() == NULL) ///blow up
		return;

	////An incomming command should look like this:
	/// methodName value value

	QStringList command = ba.split(" ");

	qDebug()<<"received: "<<ba;

	if(!command.size())
	{
		qDebug()<<"seems to be an invalid command: "<<ba;
		return;
	}

	QString methodName = command[0];
	command.removeFirst();

	QStringList args = command;

	int index;
	if((index = parent()->metaObject()->indexOfMethod(methodName.toStdString().c_str()))!= -1)
	{

		QMetaMethod method = parent()->metaObject()->method(index);
		qDebug()<<"invoking method: "<<methodName;

		if(args.size() == 0)
			method.invoke(parent(), Qt::DirectConnection);
		else if(args.size() == 1)
			method.invoke(parent(), Qt::DirectConnection, Q_ARG(QByteArray,args[0].toAscii()));
		else if(args.size() == 2)
		{
			qDebug()<<"...with arguments:"<<args[0]<<", "<<args[1];
			method.invoke(parent(), Qt::DirectConnection, Q_ARG(QByteArray,args[0].toAscii()), Q_ARG(QString,args[1]));
		}
		else if(args.size() == 3)
		{
			qDebug()<<"...with arguments:"<<args[0]<<", "<<args[1]<<", "<<args[2];
			method.invoke(parent(), Qt::DirectConnection, Q_ARG(QByteArray,args[0].toAscii()),
				      Q_ARG(QByteArray,args[1].toAscii()) ,Q_ARG(QByteArray,args[2].toAscii()));
		}
	}
	else
	{
		qDebug()<<"failed to invoke method for command: "<<ba;
		send("error",QStringList()<<QString("could not invoke method for "+ ba));
	}
}

void TcpAdaptor::send(QString methodName, QStringList args)
{
	if(!m_socket || !m_socket->isValid() || !m_socket->isOpen()) return;

	QString command;
	command += methodName + " ";

	foreach(QString arg, args)
	{
		command += arg + " ";
	}

	command += "\n";

	m_socket->write(command.toAscii());

	qDebug()<<command;
}

