/*
 * nobdy logger plugin
 * Copyright (c) 2010, Kevron Rees.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef TCPSUBSCRIBER_H
#define TCPSUBSCRIBER_H

#include "ipluginsubscriber.h"
#include "../tcpadaptor.h"
#include <QTcpServer>

class TcpSubscriber : public IPluginSubscriber
{
Q_OBJECT
Q_INTERFACES(IPluginSubscriber);
public:
	explicit TcpSubscriber(QObject *parent = 0);
	virtual QString name(){ return "tcp subscriber"; }
	virtual QList<QByteArray> requests();

public slots:
	void triggerAddRequest(QByteArray);
	void triggerSingleShotRequest(QByteArray);
	void triggerBlindSingleShotRequest(QByteArray);
	virtual void pidReceived(QByteArray pid,QString val,int set,double time);
	virtual void supportedPids(QList<int> list);
	virtual void troubleCodes(QList<QString> codes);

	void error(QString);
	void newConnection();
	void disconnected();
private:
	QTcpServer* server;
	TcpAdaptor* adaptor;
};

#endif // TCPSUBSCRIBER_H
