/*
 * nobdy logger plugin
 * Copyright (c) 2010, Kevron Rees.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "tcpsubscriber.h"
#include <QtPlugin>
#include <QtDebug>
#include <QTcpServer>

Q_EXPORT_PLUGIN2(tcpSubscriber,TcpSubscriber)

TcpSubscriber::TcpSubscriber(QObject *parent) :
    IPluginSubscriber(parent),adaptor(new TcpAdaptor(this))
{
	server = new QTcpServer(this);

	server->listen(QHostAddress::Any,29696);

	connect(server,SIGNAL(newConnection()),this,SLOT(newConnection()));
}

QList<QByteArray> TcpSubscriber::requests()
{
	return QList<QByteArray>();
}

void TcpSubscriber::triggerAddRequest(QByteArray val)
{
	emit addRequest(val);
}

void TcpSubscriber::triggerBlindSingleShotRequest(QByteArray val)
{
	//emit blindSingleShotRequest(val);
}

void TcpSubscriber::triggerSingleShotRequest(QByteArray val)
{
	emit singleShotRequest(val);
}

void TcpSubscriber::pidReceived(QByteArray pid,QString val, int set, double time)
{
	Q_UNUSED(set);
	Q_UNUSED(time);
	Q_ASSERT(adaptor);

	adaptor->send("pidReceived(QByteArray,QString)", QStringList()<<pid<<val);
}

void TcpSubscriber::supportedPids(QList<int> list)
{
	Q_UNUSED(list);
}

void TcpSubscriber::troubleCodes(QList<QString> codes)
{
	foreach(QString code, codes)
	{
		qDebug()<<"trouble code: "<<code;
	}
}

void TcpSubscriber::error(QString err)
{
	qDebug()<<err;
}

void TcpSubscriber::newConnection()
{
	qDebug("awesome new connection!!");
	QTcpSocket* socket = server->nextPendingConnection();
	adaptor->setSocket(socket);

	connect(socket,SIGNAL(disconnected()),this,SLOT(disconnected()));

	server->close();
}

void TcpSubscriber::disconnected()
{
	adaptor->socket()->close();
	server->listen(QHostAddress::Any,29696);
}


