#ifndef OBDPROSWCAN_H
#define OBDPROSWCAN_H

#include "ipluginprovider.h"

#include <QDomNode>
#include <QThread>
#include "../tcpadaptor.h"

class QTcpSocket;

class TcpProvider: public IPluginProvider
{
Q_OBJECT
Q_INTERFACES(IPluginProvider)
public:
	TcpProvider(QObject* parent=0);

	///from IPluginProvider
	virtual QString name() { return "TCP/IP Provider";}
	virtual void setPort(QString port);
	virtual void setBaud(int baud);
	virtual void addRequest(QByteArray request);
	virtual void singleShotRequest(QByteArray request);
	virtual void connect();
	virtual void disconnect();
	virtual void configure(QDomNode innerxml);
	virtual void blindSingleShotRequest(QByteArray request);

private slots:
	void tryConnect();
	void error(QString err);
	void connected();
	void disconnected();
	void pidReceived(QByteArray pid, QString val);
private:
	bool isConnected;
	QString m_port;
	QString m_host;
	QTcpSocket* socket;
	TcpAdaptor *adaptor;
	QList<QByteArray> requests;
};

#endif // OBDPROSWCAN_H
