#include "tcpprovider.h"

#include <QtPlugin>
#include <QProcess>
#include <QTcpSocket>
#include <QDateTime>
#include <QTimer>

Q_EXPORT_PLUGIN2(tcpProvider, TcpProvider)

TcpProvider::TcpProvider(QObject* parent)
	: IPluginProvider(parent),socket(NULL),adaptor(NULL)
{
	adaptor = new TcpAdaptor(this);
	isConnected=false;
}

void TcpProvider::setPort(QString port)
{
	m_port = port;
}

void TcpProvider::setBaud(int)
{

}

void TcpProvider::addRequest(QByteArray request)
{
	if(!adaptor->socket() || !socket)
	{
		requests.append(request);
		return;
	}

	adaptor->send("triggerAddRequest(QByteArray)",QStringList()<<request);
}

void TcpProvider::blindSingleShotRequest(QByteArray request)
{
	if(!adaptor || !socket)
	{
		return;
	}

	adaptor->send("triggerBlindSingleShotRequest(QByteArray)",QStringList()<<request);
}

void TcpProvider::singleShotRequest(QByteArray request)
{
	if(!adaptor || !socket)
	{
		return;
	}

	adaptor->send("triggerSingleShotRequest(QByteArray)",QStringList()<<request);
}

void TcpProvider::connect()
{
	socket = new QTcpSocket(this);
	socket->connectToHost(m_host, m_port.toInt(),QIODevice::ReadWrite);

	IPluginProvider::connect(socket,SIGNAL(connected()),this,SLOT(connected()));
	IPluginProvider::connect(socket,SIGNAL(disconnected()),this,SLOT(disconnected()));
}

void TcpProvider::disconnect()
{
	socket->disconnectFromHost();
}

void TcpProvider::configure(QDomNode innerxml)
{
	QDomNode n = innerxml.firstChild();
	while(!n.isNull())
	{
		QDomElement e = n.toElement(); // try to convert the node to an element.
		if(!e.isNull())
		{
			if(e.tagName() == "port")
			{
				setPort(e.text());
			}
			else if(e.tagName() == "host")
			{
				m_host = e.text();
			}
		}
		n = n.nextSibling();
	}
	connect();
}
void TcpProvider::tryConnect()
{
	if(!isConnected)
	{
		connect();
		QTimer::singleShot(15000,this,SLOT(tryConnect()));
	}
}

void TcpProvider::connected()
{
	isConnected = true;

	emit IPluginProvider::connected("TcpProvider ");

	adaptor->setSocket(socket);

	foreach(QByteArray req, requests)
	{
		addRequest(req);
	}
}

void TcpProvider::disconnected()
{
	isConnected = false;
	QTimer::singleShot(30000, this, SLOT(tryConnect()));
}

void TcpProvider::pidReceived(QByteArray pid, QString val)
{
	qDebug()<<"TcpProvider: pid:"<<pid<<" val: "<<val;
	emit IPluginProvider::pidReceived(pid, val, 0, QDateTime::currentDateTime().toTime_t());
}

void TcpProvider::error(QString err)
{
	qDebug()<<err;
}
