/*
 * nobdy logger plugin
 * Copyright (c) 2010, Kevron Rees.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "trip.h"

#include <sys/time.h>

trip::trip(QString dbname)
	:starttime(0)
{
	tableSchema = "CREATE TABLE trip (tripid INTEGER PRIMARY KEY, start REAL, end REAL DEFAULT -1)";

	init(dbname.toStdString(), "trip", tableSchema);
	start();
}

trip::~trip()
{
	stop();
}

void trip::start()
{
	struct timeval time;
	gettimeofday(&time,NULL);

	starttime = time.tv_sec + time.tv_usec / 1000000;

}

void trip::stop()
{
	double endtime=0;
	struct timeval time;
	gettimeofday(&time,NULL);

	endtime = time.tv_sec + time.tv_usec / 1000000;

	create(starttime, endtime);
}

void trip::create(double start, double end)
{

	NameValuePair<double> _start("start",start);
	NameValuePair<double> _end("end",end);

	DictionaryList<double> list;
	list<<_start<<_end;

	insert<double> (list);
}






