/*
 * nobdy logger plugin
 * Copyright (c) 2010, Kevron Rees.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "gpsdb.h"

Gps::Gps(QString dbname)
{
	tableSchema = "CREATE TABLE gps (lat REAL, lon REAL, alt REAL, time REAL)";

	init(dbname.toStdString(),"gps",tableSchema);
}

void Gps::create(double lat, double lon, double time)
{
	NameValuePair<double> latitude("lat",lat);
	NameValuePair<double> longitude("lon",lon);
	NameValuePair<double> t("time",time);

	DictionaryList<double> insertions;
	insertions << latitude << longitude << t;

	insert<double>(insertions);
}
