/*
 * dbussimple
 * Copyright (c) 2010, Kevron Rees.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "dbussimple.h"
#include <iostream>
#include <QtPlugin>
#include <QtDebug>
#include <QDBusConnection>
#include "adapter.h"


using namespace std;

Q_EXPORT_PLUGIN2(dBusSimpleSubscriber, DBusSimpleSubscriber)

DBusSimpleSubscriber::DBusSimpleSubscriber(QObject *parent) :
    IPluginSubscriber(parent)
{
	qDebug("constructing DBusSimpleSubscriber");
	new AdapterSimple(this);
	
	QDBusConnection connection = QDBusConnection::sessionBus();
	if(!connection.registerObject("/org/openice/nobdy/simple", this))
	{
		qDebug("failed to register dbus object");
		qDebug()<<connection.lastError().message();
	}
	if(!connection.registerService("org.openice.nobdy"))
	{
		qDebug("failed to register dbus service org.openice.nobdy");
		qDebug()<<connection.lastError().message();
	}

}

QList<QByteArray> DBusSimpleSubscriber::requests()
{
	return QList<QByteArray>();
}

void DBusSimpleSubscriber::pidReceived(QByteArray pid,QString val, int set, double time)
{
	emit PidReceived(pid, val.toAscii());
}

void DBusSimpleSubscriber::singleRequestReceived(QByteArray req, QByteArray value)
{
	emit PidReceived(req, value);
}

/*void DBusSimpleSubscriber::supportedPids(QList<int> list)
{
	Q_UNUSED(list);
}

void DBusSimpleSubscriber::troubleCodes(QList<QString> codes)
{
	foreach(QString code, codes)
	{
		cout<<"trouble code: "<<code.toStdString()<<endl;
	}
}*/


void DBusSimpleSubscriber::AddRequest(const QByteArray &pid)
{
	qDebug("add request called");
	emit addRequest(pid);
}

void DBusSimpleSubscriber::SingleRequest(const QByteArray &pid)
{
	qDebug("single request called");
	emit singleShotRequest(pid, false);
}

