/***************************************************************************
 *   Copyright (C) 2007 by kev,,,   *
 *   kev@kev-mobile   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <string.h>
#include <iostream>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/select.h>
#include <stdio.h>

#include "port.h"

using namespace std;

rs232::rs232()
{
	myport=-1;
}

rs232::~rs232()
{
	close(myport);
}

bool rs232::openPort(QString p, long int baud)
{
	struct termios m_dcb;
	int portsig=0; //port readiness
	///open the serial port:
	myport = open(p.toStdString().c_str(), O_RDWR | O_NOCTTY);
	
	if(myport<0)
	{
		cerr<<"failed to open port fd for: "<<p.toStdString()<<endl;
		perror(p.toStdString().c_str());
		return false;
	}
	///check if port was opened successfully:
	if((portsig = tcgetattr(myport, &m_dcb)) == -1)
	{
		cerr<<"Port failed to open! Big fat error!!!"<<endl;
		perror(p.toStdString().c_str());
		return false;
	}
	///set up port settings:
	/// TODO: use baud setting
	cfsetispeed(&m_dcb,B9600);
	cfsetospeed(&m_dcb,B9600);
	m_dcb.c_cflag |=(CLOCAL|CREAD);
	//m_dcb.c_cflag &= ~CSIZE;
	m_dcb.c_cflag |= CS8;
	//m_dcb.c_cflag &= ~PARENB;
	//m_dcb.c_cflag &= ~CSTOPB;
	//options.c_cflag &= ~CNEW_RTSCTS;
	//m_dcb.c_lflag &= ~(ICANON|ECHO|ECHOE|ISIG);
	m_dcb.c_lflag &= ~ICANON;
	//m_dcb.c_iflag &= ~(IXON|IXOFF|IXANY);
	m_dcb.c_iflag = IGNPAR | ICRNL;
	//m_dcb.c_oflag &= ~OPOST;
	tcsetattr(myport, TCSANOW, &m_dcb);
	///successful return:
	return true;
}

bool rs232::out(QByteArray o)
{
	bw = write(myport, o.data(), o.size());
	if (bw < o.length())
	{
		return false;
	}

	return true;

}

QByteArray rs232::in()
{
	if(!waitIn(1000)) return "";
	br = read(myport, &buffer, 255);
	if(br>0)
	{
		QByteArray b=buffer;
		return b;
	}

	return "";
}

int rs232::waitIn(int m)
{

	if(!ready) return 0;

	int            n;
	int            fd=-1;
	int            max_fd;
	fd_set         input;
	struct timeval timeout;

	/* Initialize the input set */
	FD_ZERO(&input);
	FD_SET(fd, &input);

	max_fd = fd+1;

	/* Initialize the timeout structure */
	timeout.tv_sec  = 0;
	timeout.tv_usec = m;

	/* Do the select */
	if (m==0)
		n = select(max_fd, &input, NULL, NULL, NULL);
	else
	 	n = select(max_fd, &input, NULL, NULL, &timeout);

	/* See if there was an error */
	if (n < 0)
	{
		cerr<<"select failed"<<endl;
		return 0;
	}
	else if (n == 0)
	{
		cout<<"TIMEOUT"<<endl;
		return 0;
	}
	else
	{
		/* We have input */
		if (FD_ISSET(fd, &input))
			return 1;
		else return 0;
	}
}
