#ifndef OBDPROSWCAN_H
#define OBDPROSWCAN_H

#include "ipluginprovider.h"
#include "port.h"

#include <ObdThread.h>
#include <QDomNode>
#include <QThread>

class ObdProSWCan: public IPluginProvider
{
Q_OBJECT
Q_INTERFACES(IPluginProvider)
public:
	ObdProSWCan(QObject* parent=0);

	///from IPluginProvider
	virtual QString name() { return "SingleWire CAN specific to the OBDPro scantool";}
	virtual void setPort(QString port);
	virtual void setBaud(int baud);
	virtual void addRequest(QByteArray request);
	virtual void singleShotRequest(QByteArray request);
	virtual void connect();
	virtual void disconnect();
	virtual void configure(QDomNode innerxml);

private:
	rs232 bus;
	long m_baud;
	QString m_port;
};

#endif // OBDPROSWCAN_H
