#include "obdproswcan.h"

#include <QtPlugin>
#include <QProcess>

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <termios.h>
#include <fcntl.h>

Q_EXPORT_PLUGIN2(obdProSWCan, ObdProSWCan)

ObdProSWCan::ObdProSWCan(QObject* parent)
	: IPluginProvider(parent)
{

}

void ObdProSWCan::setPort(QString port)
{
	m_port = port;
}

void ObdProSWCan::setBaud(int baud)
{
	m_baud = baud;
}

void ObdProSWCan::addRequest(QByteArray request)
{
	///TODO: maybe we add a filter here to listen for?
}

void ObdProSWCan::singleShotRequest(QByteArray request)
{

}

void ObdProSWCan::connect()
{
	if(!bus.openPort(m_port,m_baud))
		emit consoleMessage("Failed to open port!!!");
}

void ObdProSWCan::disconnect()
{

}

void ObdProSWCan::configure(QDomNode innerxml)
{
	QDomNode n = innerxml.firstChild();
	while(!n.isNull())
	{
		QDomElement e = n.toElement(); // try to convert the node to an element.
		if(!e.isNull())
		{
			if(e.tagName() == "port")
			{
				setPort(e.text());
			}
			else if(e.tagName() == "baud")
			{
				setBaud(e.text().toInt());
			}
		}
		n = n.nextSibling();
	}
}

