/*
 * nobdy
 * Copyright (c) 2010, Kevron Rees.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef RUNNER_H
#define RUNNER_H

#include <QObject>
#include <QHash>
#include <QList>
#include <QPair>
#include <QTimer>
#include "ipluginprovider.h"
#include "ipluginsubscriber.h"

typedef QList<IPluginSubscriber*> SubscriberList;

class Runner : public QObject
{
Q_OBJECT
public:
	explicit Runner(QString config,QObject *parent = 0);
	~Runner();
signals:

public slots:
	void pidReceived(QByteArray pid,QString val,int set,double time);
	void supportedPids(QList<int> list);
	void troubleCodes(QList<QString> codes);

private slots:
	void connected(QString);
	void consoleOutput(QString);

	void handleSingleRequest(QByteArray, bool);
	void singleShotResponse(QByteArray);
	void processRequests();

	void subscriberAddRequest(QByteArray);
private:
	IPluginProvider* provider;
	SubscriberList subscribers;

	QHash<QByteArray, SubscriberList> pidSubscriberMap;
	QList< QPair<QByteArray,IPluginSubscriber*> > singleRequestQueue;
	bool requestInProgress;
};

#endif // RUNNER_H
