/*
 * nobdy
 * Copyright (c) 2010, Kevron Rees.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "pluginloader.h"

#include <QDomDocument>
#include <QFile>
#include <QDir>
#include <QString>
#include <QStringList>
#include <QtDebug>
#include <QPluginLoader>

PluginLoader::PluginLoader(QString config)
{
	QString providerFile;
	QMap<QString, QDomNode> subscriberConfigMap;
	QDomDocument doc("plugins");
	QString filename;

	qDebug()<<"attempting to using config: "<<config;

	if(QFile::exists(config))
		filename = config;
	else if(QFile::exists(QDir::homePath() +"/.nobdy/plugins.xml"))
		filename = QDir::homePath() +"/.nobdy/plugins.xml";
	else if(QFile::exists("plugins.xml"))
		filename ="plugins.xml";
	else if(QFile::exists("/etc/nobdy/plugins.xml"))
		filename = "/etc/nobdy/plugins.xml";

	QFile file(filename);

	if (!file.open(QIODevice::ReadOnly))
	{
		qDebug("bad plugin.xml path");
		return;
	}
	if (!doc.setContent(&file))
	{
		qDebug("possibly bad xml in plugins.xml");
		file.close();
		return;
	}
	file.close();

	// print out the element names of all elements that are direct children
	// of the outermost element.
	QDomElement docElem = doc.documentElement();
	QDomNode providerXml;
	QDomNode n = docElem.firstChild();
	while(!n.isNull())
	{
		QDomElement e = n.toElement(); // try to convert the node to an element.
		if(!e.isNull())
		{
			if(e.tagName() == "provider")
			{
				providerFile = e.attribute("path","");
				providerXml=e;
			}
			else if(e.tagName() == "subscriber")
			{

				subscriberConfigMap[e.attribute("path","")] = e;
			}
		}
		n = n.nextSibling();
	}

	QPluginLoader loader(providerFile);
	IPluginProvider* prov = qobject_cast<IPluginProvider*>(loader.instance());
	if(!prov)
	{
		qDebug()<<"Failed to load provider: "<<providerFile<<" because "<<loader.errorString();
		Q_ASSERT(0);
	}
	else
	{
		qDebug()<<"Loading provider: "<<providerFile;
		m_provider = prov;
		m_provider->configure(providerXml);
	}

	foreach(QString plugin, subscriberConfigMap.keys())
	{
		QPluginLoader loader(plugin);
		IPluginSubscriber* sub = qobject_cast<IPluginSubscriber*>(loader.instance());
		if(sub)
		{
			qDebug()<<"loading subscriber: "<<plugin;
			sub->configure(subscriberConfigMap[plugin]);
			m_subscribers.append(sub);
		}
		else
		{
			qDebug()<<"Failed to load subscriber: "<<plugin<<" because "<<loader.errorString();
		}
	}
}
