/*
 * nobdy
 * Copyright (c) 2010, Kevron Rees.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QCoreApplication>
#include <QtDebug>

#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <unistd.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include <grp.h>
#include <errno.h>
#include <fcntl.h>
#include "runner.h"

void interrupt(int sign)
{
	signal(sign, SIG_IGN);
	qDebug("Signal caught. Exiting gracefully.\n");
	QCoreApplication::exit(0);
}

void daemonize();

void printhelp(const char *argv0);

static const char shortopts[] = "hvdc:";

static const struct option longopts[] = {
	{ "help", no_argument, NULL, 'h' }, ///< Print the help text
	{ "version", no_argument, NULL, 'v' }, ///< Print the version text
	{ "daemonise", no_argument, NULL, 'd' }, ///< Daemonise
	{ "config", required_argument, NULL, 'c' },
	{ NULL, 0, NULL, 0 } ///< End
};

int main(int argc, char *argv[])
{
	bool isdeamonize=false;
	QString config;
	int optc;

	while ((optc = getopt_long (argc, argv, shortopts, longopts, NULL)) != -1)
	{
		switch (optc)
		{
			case 'd':
				isdeamonize = true;
				break;

			case 'v':
				printf("0.0.2\n");
				return (0);
				break;
			case 'c':
				qDebug()<<"config: "<<optarg;
				config=optarg;
				break;
			default:
				fprintf(stderr, "Unknown option %c\n", optc);
				printhelp(argv[0]);
				return (0);
				break;
		}
	}

	if(isdeamonize)
		daemonize();

	QCoreApplication a(argc, argv);

	/* Register signal handler */
	signal(SIGINT, interrupt);
	signal(SIGTERM, interrupt);

	Runner runner(config);

	return a.exec();
}

void daemonize()
{
	int i=0;
	if(getppid() == 1)
	{
		return;	// already a daemon
	}
	if((i = fork()) < 0)
	{
		fprintf(stderr, "%s:%s(%d) - fork error: %s", __FILE__, __FUNCTION__, __LINE__, strerror(errno));
		exit(1);
	}
	if(i > 0)
	{
		exit(0);	// parent exits
	}	// child (daemon) continues
	setsid();	// obtain a new process group
	for(i = getdtablesize(); i >= 0; --i)
	{
		close(i);	// close all descriptors
	}
	{	// handle standard I/O
		i = open("/dev/null", O_RDWR);
		dup(i);
		dup(i);
	}
	// first instance continues
}

void printhelp(const char *argv0)
{
	printf("Usage: %s [args]\n"
		"   [-d|--daemonise]\n"
		"   [-v|--version]\n"
		"   [-c]--config <configfile> \t]"
		"   [-h|--help]\n"
		, argv0);
}
