/*
 * libnobdy
 * Copyright (c) 2010, Kevron Rees.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef IPLUGINSUBSCRIBER_H
#define IPLUGINSUBSCRIBER_H

#include <QObject>
#include <QDomNode>
#include "pidpriority.h"

class IPluginSubscriber : public QObject
{
	Q_OBJECT;

public:
	explicit IPluginSubscriber(QObject *parent=NULL):QObject(parent){}
	virtual QString name()=0;
	virtual QList<QByteArray> requests() = 0;
	virtual void configure(QDomNode innerxml){Q_UNUSED(innerxml)}

signals:
	void addRequest(QByteArray);
	void getSupportedPids();
	void getTroubleCodes();
	void singleShotRequest(QByteArray pid, bool hasreply=true);

public slots:
	virtual void pidReceived(QByteArray pid, QString val,int set,double time);
	virtual void singleRequestReceived(QByteArray req, QByteArray value);
	virtual void supportedPids(QList<int> list);
	virtual void troubleCodes(QList<QString> codes);
};

Q_DECLARE_INTERFACE(IPluginSubscriber, "org.openice.nobdy.subscriber");

#endif // IPLUGINSUBSCRIBER_H
