/*
 * libnobdy
 * Copyright (c) 2010, Kevron Rees.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef IPLUGINPROVIDER_H
#define IPLUGINPROVIDER_H

#include <QObject>
#include <QDomNode>

class IPluginProvider: public QObject
{
	Q_OBJECT
public:
	IPluginProvider(QObject* parent = NULL):QObject(parent){}
	virtual QString name()=0;
	virtual void addRequest(QByteArray)=0;
	virtual void singleShotRequest(QByteArray request)=0;
	virtual void blindSingleShotRequest(QByteArray request)=0;
	virtual void getSupportedPids() {}
	virtual void requestTroubleCodes() {}

	virtual void configure(QDomNode innerxml){Q_UNUSED(innerxml)}
signals:
	void connected(QString version);
	void disconnected();
	void pidReceived(QByteArray pid,QString val,int set,double time);
	void singleShotResponse(QByteArray list);
	void supportedPids(QList<int> list);
	void troubleCodes(QList<QString> codes);
	void consoleMessage(QString message);
};

Q_DECLARE_INTERFACE(IPluginProvider,"org.openice.nobdy.provider")

#endif // IPLUGINPROVIDER_H
